\name{BinaryGrindPeakImageFilter}
\alias{BinaryGrindPeakImageFilter}
\title{BinaryGrindPeakImageFilter}
\Rdversion{1.1}
\docType{class}
\description{
Remove the objects not connected to the boundary of the image.
BinaryGrindPeakImageFilter}
\details{
BinaryGrindPeakImageFilter grinds peaks in a grayscale image.
Geodesic morphology and the grind peak algorithm is described in
Chapter 6 of Pierre Soille's book "Morphological Image Analysis:
Principles and Applications", Second Edition, Springer, 2003.
Gaetan Lehmann. Biologie du Developpement et de la Reproduction, INRA
de Jouy-en-Josas, France.
 This implementation was taken from the Insight Journal paper: https://www.insight-journal.org/browse/publication/176
See:
GrayscaleGrindPeakImageFilter
BinaryGrindPeak for the procedural interface
itk::BinaryGrindPeakImageFilter for the Doxygen on the original ITK class.
BinaryGrindPeakImageFilter}
%C++ includes: sitkBinaryGrindPeakImageFilter.h
\section{Methods}{
\describe{
\item{ BinaryGrindPeakImageFilter():}{
Default Constructor that takes no arguments and initializes default
parameters
}
\item{Image Execute(const Image &image1):}{
Execute the filter on the input image
}
\item{Self FullyConnectedOff():}{}
\item{Self FullyConnectedOn():}{
Set the value of FullyConnected to true or false respectfully.
}
\item{double GetBackgroundValue() const:}{
Set the value in eroded part of the image. Defaults to zero
}
\item{double GetForegroundValue() const:}{
Get the value in the image considered as "foreground". Defaults to
maximum value of InputPixelType.
}
\item{bool GetFullyConnected() const:}{
Set/Get whether the connected components are defined strictly by face
connectivity or by face+edge+vertex connectivity. Default is
FullyConnectedOff. For objects that are 1 pixel wide, use
FullyConnectedOn.
}
\item{std::string GetName() const:}{
Name of this class
}
\item{Self SetBackgroundValue(double BackgroundValue):}{
Set the value in eroded part of the image. Defaults to zero
}
\item{Self SetForegroundValue(double ForegroundValue):}{
Set the value in the image to consider as "foreground". Defaults to
maximum value of InputPixelType.
}
\item{Self SetFullyConnected(bool FullyConnected):}{
Set/Get whether the connected components are defined strictly by face
connectivity or by face+edge+vertex connectivity. Default is
FullyConnectedOff. For objects that are 1 pixel wide, use
FullyConnectedOn.
}
\item{std::string ToString() const:}{
Print ourselves out
}
\item{ ~BinaryGrindPeakImageFilter():}{
Destructor
}
}
}
