/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.annotations.ArgumentClinic;
import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.Python3Core;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.modules.PosixModuleBuiltins;
import com.oracle.graal.python.builtins.modules.PwdModuleBuiltinsClinicProviders;
import com.oracle.graal.python.builtins.modules.PwdModuleBuiltinsFactory;
import com.oracle.graal.python.builtins.objects.ints.PInt;
import com.oracle.graal.python.builtins.objects.tuple.StructSequence;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PConstructAndRaiseNode;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.StringLiterals;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryClinicBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.clinic.ArgumentClinicProvider;
import com.oracle.graal.python.nodes.object.BuiltinClassProfiles;
import com.oracle.graal.python.runtime.GilNode;
import com.oracle.graal.python.runtime.PosixSupportLibrary;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.graal.python.runtime.object.PFactory;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.strings.TruffleString;
import java.util.Arrays;
import java.util.List;

@CoreFunctions(defineModule="pwd")
public final class PwdModuleBuiltins
extends PythonBuiltins {
    private static final TruffleString T_NOT_AVAILABLE = PythonUtils.tsLiteral("NOT_AVAILABLE");
    static final StructSequence.BuiltinTypeDescriptor STRUCT_PASSWD_DESC = new StructSequence.BuiltinTypeDescriptor(PythonBuiltinClassType.PStructPasswd, 7, new String[]{"pw_name", "pw_passwd", "pw_uid", "pw_gid", "pw_gecos", "pw_dir", "pw_shell"}, new String[]{"user name", "password", "user id", "group id", "real name", "home directory", "shell program"});

    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        PosixSupportLibrary posixLib = PosixSupportLibrary.getUncached();
        boolean hasGetpwentries = posixLib.hasGetpwentries(PythonContext.get(null).getPosixSupport());
        if (hasGetpwentries) {
            return PwdModuleBuiltinsFactory.getFactories();
        }
        assert (PwdModuleBuiltinsFactory.getFactories().size() == 3);
        return Arrays.asList(PwdModuleBuiltinsFactory.GetpwuidNodeFactory.getInstance(), PwdModuleBuiltinsFactory.GetpwnamNodeFactory.getInstance());
    }

    @Override
    public void initialize(Python3Core core) {
        super.initialize(core);
        StructSequence.initType(core, STRUCT_PASSWD_DESC);
    }

    private static Object[] createPwuidObject(Node inliningTarget, PosixSupportLibrary.PwdResult pwd, PythonLanguage language, InlinedConditionProfile unsignedConversionProfile) {
        return new Object[]{pwd.name, T_NOT_AVAILABLE, PInt.createPythonIntFromUnsignedLong(inliningTarget, language, unsignedConversionProfile, pwd.uid), PInt.createPythonIntFromUnsignedLong(inliningTarget, language, unsignedConversionProfile, pwd.gid), StringLiterals.T_EMPTY_STRING, pwd.dir, pwd.shell};
    }

    @Builtin(name="getpwall")
    @GenerateNodeFactory
    public static abstract class GetpwallNode
    extends PythonBuiltinNode {
        @Specialization
        static Object doGetpall(VirtualFrame frame, @Bind Node inliningTarget, @Bind PythonContext context, @CachedLibrary(value="context.getPosixSupport()") PosixSupportLibrary posixLib, @Cached InlinedConditionProfile unsignedConversionProfile, @Cached PConstructAndRaiseNode.Lazy constructAndRaiseNode) {
            PosixSupportLibrary.PwdResult[] entries;
            try {
                entries = posixLib.getpwentries(context.getPosixSupport());
            }
            catch (PosixSupportLibrary.PosixException e) {
                throw constructAndRaiseNode.get(inliningTarget).raiseOSErrorFromPosixException(frame, e);
            }
            catch (PosixSupportLibrary.UnsupportedPosixFeatureException e) {
                throw constructAndRaiseNode.get(inliningTarget).raiseOSErrorUnsupported(frame, e);
            }
            PythonLanguage language = context.getLanguage(inliningTarget);
            Object[] result = new Object[entries.length];
            for (int i = 0; i < result.length; ++i) {
                result[i] = PFactory.createStructSeq(language, STRUCT_PASSWD_DESC, PwdModuleBuiltins.createPwuidObject(inliningTarget, entries[i], language, unsignedConversionProfile));
            }
            return PFactory.createList(language, result);
        }
    }

    @Builtin(name="getpwnam", minNumOfPositionalArgs=1, parameterNames={"name"})
    @ArgumentClinic(name="name", conversion=ArgumentClinic.ClinicConversion.TString)
    @GenerateNodeFactory
    public static abstract class GetpwnamNode
    extends PythonUnaryClinicBuiltinNode {
        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return PwdModuleBuiltinsClinicProviders.GetpwnamNodeClinicProviderGen.INSTANCE;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        static Object doGetpwname(VirtualFrame frame, TruffleString name, @Bind Node inliningTarget, @Bind PythonContext context, @Cached GilNode gil, @Cached PosixModuleBuiltins.StringOrBytesToOpaquePathNode encodeFSDefault, @CachedLibrary(value="context.getPosixSupport()") PosixSupportLibrary posixLib, @Cached InlinedConditionProfile unsignedConversionProfile, @Cached PConstructAndRaiseNode.Lazy constructAndRaiseNode, @Bind PythonLanguage language, @Cached PRaiseNode raiseNode) {
            PosixSupportLibrary.PwdResult pwd;
            Object nameEncoded = encodeFSDefault.execute(inliningTarget, name);
            try {
                gil.release(true);
                try {
                    pwd = posixLib.getpwnam(context.getPosixSupport(), nameEncoded);
                }
                finally {
                    gil.acquire(context);
                }
            }
            catch (PosixSupportLibrary.PosixException e) {
                throw constructAndRaiseNode.get(inliningTarget).raiseOSErrorFromPosixException(frame, e);
            }
            catch (PosixSupportLibrary.UnsupportedPosixFeatureException e) {
                throw constructAndRaiseNode.get(inliningTarget).raiseOSErrorUnsupported(frame, e);
            }
            if (pwd == null) {
                throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.KeyError, ErrorMessages.GETPWNAM_NAME_NOT_FOUND, name);
            }
            return PFactory.createStructSeq(language, STRUCT_PASSWD_DESC, PwdModuleBuiltins.createPwuidObject(inliningTarget, pwd, context.getLanguage(inliningTarget), unsignedConversionProfile));
        }
    }

    @Builtin(name="getpwuid", minNumOfPositionalArgs=1, parameterNames={"uid"})
    @GenerateNodeFactory
    public static abstract class GetpwuidNode
    extends PythonUnaryBuiltinNode {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        static Object doGetpwuid(VirtualFrame frame, Object uidObj, @Bind Node inliningTarget, @Bind PythonContext context, @Cached PosixModuleBuiltins.UidConversionNode uidConversionNode, @Cached BuiltinClassProfiles.IsBuiltinObjectProfile classProfile, @Cached GilNode gil, @CachedLibrary(value="context.getPosixSupport()") PosixSupportLibrary posixLib, @Cached InlinedConditionProfile unsignedConversionProfile, @Cached PConstructAndRaiseNode.Lazy constructAndRaiseNode, @Cached PRaiseNode raiseNode) {
            PosixSupportLibrary.PwdResult pwd;
            long uid;
            try {
                uid = uidConversionNode.executeLong(frame, uidObj);
            }
            catch (PException ex) {
                if (classProfile.profileException(inliningTarget, ex, PythonBuiltinClassType.OverflowError)) {
                    throw GetpwuidNode.raiseUidNotFound(inliningTarget, raiseNode);
                }
                throw ex;
            }
            try {
                gil.release(true);
                try {
                    pwd = posixLib.getpwuid(context.getPosixSupport(), uid);
                }
                finally {
                    gil.acquire(context);
                }
            }
            catch (PosixSupportLibrary.PosixException e) {
                throw constructAndRaiseNode.get(inliningTarget).raiseOSErrorFromPosixException(frame, e);
            }
            catch (PosixSupportLibrary.UnsupportedPosixFeatureException e) {
                throw constructAndRaiseNode.get(inliningTarget).raiseOSErrorUnsupported(frame, e);
            }
            if (pwd == null) {
                throw GetpwuidNode.raiseUidNotFound(inliningTarget, raiseNode);
            }
            PythonLanguage language = context.getLanguage(inliningTarget);
            return PFactory.createStructSeq(language, STRUCT_PASSWD_DESC, PwdModuleBuiltins.createPwuidObject(inliningTarget, pwd, language, unsignedConversionProfile));
        }

        private static PException raiseUidNotFound(Node inliningTarget, PRaiseNode raiseNode) {
            throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.KeyError, ErrorMessages.GETPWUID_NOT_FOUND);
        }
    }
}

