/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.nodes.bytecode;

import com.oracle.graal.python.lib.PyObjectGetItem;
import com.oracle.graal.python.nodes.PNodeWithContext;
import com.oracle.graal.python.nodes.bytecode.ReadFromDictOrGlobalsNodeGen;
import com.oracle.graal.python.nodes.frame.ReadGlobalOrBuiltinNode;
import com.oracle.graal.python.nodes.object.BuiltinClassProfiles;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.TruffleString;

@GenerateUncached
@GenerateCached
@GenerateInline(value=false)
public abstract class ReadFromDictOrGlobalsNode
extends PNodeWithContext {
    public abstract int execute(VirtualFrame var1, int var2, Object var3, TruffleString var4);

    @Specialization
    static int read(VirtualFrame frame, int initialStackTop, Object globals, TruffleString name, @Bind Node inliningTarget, @Cached PyObjectGetItem getItemNode, @Cached ReadGlobalOrBuiltinNode readGlobal, @Cached BuiltinClassProfiles.IsBuiltinObjectProfile errorProfile) {
        Object value;
        int stackTop = initialStackTop;
        Object dict = frame.getObject(stackTop);
        frame.setObject(stackTop--, null);
        try {
            value = getItemNode.executeCached((Frame)frame, dict, name);
        }
        catch (PException e) {
            e.expect(inliningTarget, PythonErrorType.KeyError, errorProfile);
            value = readGlobal.read((Frame)frame, globals, name);
        }
        frame.setObject(++stackTop, value);
        return stackTop;
    }

    @NeverDefault
    public static ReadFromDictOrGlobalsNode create() {
        return ReadFromDictOrGlobalsNodeGen.create();
    }

    @NeverDefault
    public static ReadFromDictOrGlobalsNode getUncached() {
        return ReadFromDictOrGlobalsNodeGen.getUncached();
    }
}

