/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.resolver;

import java.io.File;
import java.lang.reflect.Executable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.function.BiConsumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.jdbc.logging.annotations.Blind;
import oracle.jdbc.logging.annotations.PropertiesBlinder;
import oracle.net.resolver.EnvVariableResolver;

public class EZConnectResolver {
    private static final String DESCRIPTION_FORMAT = "(DESCRIPTION=%s%s%s%s)";
    private static final String ADDRESS_LIST_FORMAT = "(ADDRESS_LIST=(LOAD_BALANCE=%s)%s)";
    private static final String ADDRESS_FORMAT = "(ADDRESS=(PROTOCOL=%s)(HOST=%s)(PORT=%s)%s)";
    private static final String HTTPS_PROXY_FORMAT = "(HTTPS_PROXY=%s)";
    private static final String HTTPS_PROXY_PORT_FORMAT = "(HTTPS_PROXY_PORT=%s)";
    private static final String CONNECT_DATA_FORMAT = "(CONNECT_DATA=%s%s%s%s)";
    private static final String SERVICE_NAME_FORMAT = "(SERVICE_NAME=%s)";
    private static final String SERVER_MODE_FORMAT = "(SERVER=%s)";
    private static final String INSTANCE_NAME_FORMAT = "(INSTANCE_NAME=%s)";
    private static final String SERVICE_TAG_FORMAT = "(SERVICE_TAG=%s)";
    private static final String SECURITY_FORMAT = "(SECURITY=%s)";
    private static final String SERVER_DN_MATCH_FORMAT = "(SSL_SERVER_DN_MATCH=%s)";
    private static final String SERVER_DN_FORMAT = "(SSL_SERVER_CERT_DN=%s)";
    private static final String MY_WALLET_DIR_FORMAT = "(MY_WALLET_DIRECTORY=%s)";
    private static final String ENCRYPTION_CLIENT_FORMAT = "(ENCRYPTION_CLIENT=%s)";
    private static final String ENCRYPTION_TYPES_CLIENT_FORMAT = "(ENCRYPTION_TYPES_CLIENT=%s)";
    private static final String CRYPTO_CHECKSUM_CLIENT_FORMAT = "(CRYPTO_CHECKSUM_CLIENT=%s)";
    private static final String CRYPTO_CHECKSUM_TYPES_CLIENT_FORMAT = "(CRYPTO_CHECKSUM_TYPES_CLIENT=%s)";
    private static final String EMPTY_STRING = "";
    private static final String KEY_VALUE_FORMAT = "(%s=%s)";
    private static final Pattern HOST_INFO_PATTERN;
    private static final Pattern EZ_URL_PATTERN;
    private static final String EXT_TNS_ADMIN_KEYWORD = "TNS_ADMIN";
    private static final char EXT_DOUBLE_QT = '\"';
    private static final char EXT_KEY_VAL_SEP = '=';
    private static final char EXT_PARAM_SEP = '&';
    private static final char EXT_ESCAPE_CHAR = '\\';
    private static final Map<String, String> URL_PROPS_ALIAS;
    private static final Map<String, String> CONNECTION_PROPS_ALIAS;
    private static final List<String> DESCRIPTION_PARAMS;
    private final String url;
    private String resolvedUrl;
    private final Properties connectionProps = new Properties();
    private final Properties urlProps = new Properties();
    private final String urlPrefix;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;
    private static Executable $$$methodRef$$$18;
    private static Logger $$$loggerRef$$$18;
    private static Executable $$$methodRef$$$19;
    private static Logger $$$loggerRef$$$19;

    private EZConnectResolver(String url) {
        int jdbcUrlPrefix = url.indexOf(64);
        if (jdbcUrlPrefix != -1) {
            this.url = url.substring(jdbcUrlPrefix + 1);
            this.urlPrefix = url.substring(0, jdbcUrlPrefix + 1);
        } else {
            this.url = url;
            this.urlPrefix = EMPTY_STRING;
        }
        this.parse();
    }

    public static EZConnectResolver newInstance(String url) {
        return new EZConnectResolver(url);
    }

    public String getResolvedUrl() {
        return this.resolvedUrl;
    }

    @Blind(value=PropertiesBlinder.class)
    public Properties getProperties() {
        return this.connectionProps;
    }

    private void parse() {
        String parsedUrl = this.parseExtendedSettings(this.url);
        if (this.connectionProps.isEmpty() && this.urlProps.isEmpty()) {
            parsedUrl = this.url;
        }
        this.resolvedUrl = parsedUrl.startsWith("(") ? this.urlPrefix + parsedUrl : this.urlPrefix + this.resolveToLongURLFormat(parsedUrl);
    }

    private String resolveToLongURLFormat(String url) {
        String proxyPort;
        String urlWithoutWhiteSpaces = url.replaceAll("\\s+", EMPTY_STRING);
        Matcher matcher = EZ_URL_PATTERN.matcher(urlWithoutWhiteSpaces);
        if (!matcher.matches()) {
            return url;
        }
        String protocol = matcher.group("protocol");
        String hostInfo = matcher.group("hostinfo");
        String serviceName = matcher.group("servicename");
        String serverMode = matcher.group("servermode");
        String instanceName = matcher.group("instance");
        if (hostInfo == null) {
            return url;
        }
        if (protocol == null && serviceName == null && serverMode == null && instanceName == null) {
            return url;
        }
        String proxyHost = this.urlProps.getProperty("HTTPS_PROXY");
        String addressInfo = this.buildAddressList(hostInfo, protocol, proxyHost, proxyPort = this.urlProps.getProperty("HTTPS_PROXY_PORT"));
        if (addressInfo == null) {
            return url;
        }
        return String.format(DESCRIPTION_FORMAT, this.buildDescriptionParams(), addressInfo, this.buildConnectData(serviceName, serverMode, instanceName), this.buildSecurityInfo(protocol));
    }

    private String buildConnectData(String serviceName, String serverMode, String instanceName) {
        String serviceTag = this.urlProps.getProperty("SERVICE_TAG");
        return String.format(CONNECT_DATA_FORMAT, String.format(SERVICE_NAME_FORMAT, serviceName == null ? EMPTY_STRING : serviceName), serverMode == null ? EMPTY_STRING : String.format(SERVER_MODE_FORMAT, serverMode), instanceName == null ? EMPTY_STRING : String.format(INSTANCE_NAME_FORMAT, instanceName), serviceTag == null ? EMPTY_STRING : String.format(SERVICE_TAG_FORMAT, serviceTag));
    }

    private String buildAddressList(String hostInfo, String protocol, String proxyHost, String proxyPort) {
        Matcher matcher = HOST_INFO_PATTERN.matcher(hostInfo);
        StringBuilder builder = new StringBuilder();
        String proxyInfo = EMPTY_STRING;
        if (proxyHost != null && proxyPort != null) {
            proxyInfo = String.format(HTTPS_PROXY_FORMAT, proxyHost) + String.format(HTTPS_PROXY_PORT_FORMAT, proxyPort);
        }
        if (protocol == null) {
            protocol = "TCP";
        }
        int count = 0;
        while (matcher.find()) {
            String[] hosts = matcher.group("hostnames").split(",");
            String port = matcher.group("port");
            if (port == null) {
                port = "1521";
            }
            for (String host : hosts) {
                if ((host = host.trim()).length() == 0) continue;
                if (host.startsWith("[") && host.endsWith("]")) {
                    host = host.substring(1, host.length() - 1);
                }
                builder.append(String.format(ADDRESS_FORMAT, protocol, host, port, proxyInfo));
                ++count;
            }
        }
        if (count == 1) {
            return builder.toString();
        }
        if (count > 1) {
            return String.format(ADDRESS_LIST_FORMAT, this.urlProps.getProperty("LOAD_BALANCE", "ON"), builder.toString());
        }
        return null;
    }

    private String buildDescriptionParams() {
        if (this.urlProps.isEmpty()) {
            return EMPTY_STRING;
        }
        StringBuilder builder = new StringBuilder();
        this.urlProps.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k2, v2) -> {
            if (DESCRIPTION_PARAMS.contains(k2)) {
                builder.append(String.format(KEY_VALUE_FORMAT, k2, v2));
            }
        }));
        return builder.toString();
    }

    private String buildSecurityInfo(String protocol) {
        StringBuilder securityInfo = new StringBuilder();
        if (protocol != null && protocol.equalsIgnoreCase("tcps")) {
            String serverDNMatch = this.connectionProps.getProperty("oracle.net.ssl_server_dn_match", "TRUE");
            String serverCertDN = this.urlProps.getProperty("SSL_SERVER_CERT_DN");
            String walletDir = this.urlProps.getProperty("MY_WALLET_DIRECTORY");
            securityInfo.append(String.format(SERVER_DN_MATCH_FORMAT, serverDNMatch));
            this.connectionProps.setProperty("oracle.net.ssl_server_dn_match", serverDNMatch);
            if (serverCertDN != null) {
                securityInfo.append(String.format(SERVER_DN_FORMAT, serverCertDN));
            }
            if (walletDir != null) {
                securityInfo.append(String.format(MY_WALLET_DIR_FORMAT, walletDir));
            }
        } else {
            String encryptionClient = this.urlProps.getProperty("ENCRYPTION_CLIENT");
            String encryptionClientTypes = this.urlProps.getProperty("ENCRYPTION_TYPES_CLIENT");
            String checksumClient = this.urlProps.getProperty("CRYPTO_CHECKSUM_CLIENT");
            String checksumClientTypes = this.urlProps.getProperty("CRYPTO_CHECKSUM_TYPES_CLIENT");
            if (encryptionClient != null) {
                securityInfo.append(String.format(ENCRYPTION_CLIENT_FORMAT, encryptionClient));
            }
            if (encryptionClientTypes != null) {
                securityInfo.append(String.format(ENCRYPTION_TYPES_CLIENT_FORMAT, encryptionClientTypes));
            }
            if (checksumClient != null) {
                securityInfo.append(String.format(CRYPTO_CHECKSUM_CLIENT_FORMAT, checksumClient));
            }
            if (checksumClientTypes != null) {
                securityInfo.append(String.format(CRYPTO_CHECKSUM_TYPES_CLIENT_FORMAT, checksumClientTypes));
            }
        }
        return securityInfo.length() == 0 ? EMPTY_STRING : String.format(SECURITY_FORMAT, securityInfo.toString());
    }

    private String parseExtendedSettings(String urlStr) {
        char[] urlBytes = urlStr.trim().toCharArray();
        int extendedSettingsIndex = this.findExtendedSettingPosition(urlBytes);
        if (extendedSettingsIndex == -1) {
            return urlStr;
        }
        this.parseExtendedProperties(urlBytes, extendedSettingsIndex + 1);
        return urlStr.substring(0, extendedSettingsIndex);
    }

    private void parseExtendedProperties(char[] urlChars, int extIndex) {
        try {
            String key = null;
            String value = null;
            char[] token = new char[urlChars.length];
            int tokenIndx = 0;
            block8: for (int i2 = extIndex; i2 < urlChars.length; ++i2) {
                if (Character.isWhitespace(urlChars[i2])) continue;
                switch (urlChars[i2]) {
                    case '\\': {
                        if (i2 + 1 < urlChars.length && this.isValidEscapeChar(urlChars[i2 + 1])) {
                            token[tokenIndx++] = urlChars[++i2];
                            continue block8;
                        }
                        throw new RuntimeException("Invalid character at " + i2 + " : " + urlChars[i2]);
                    }
                    case '\"': {
                        int[] indicies = this.parseQuotedString(i2, urlChars, tokenIndx, token);
                        tokenIndx = indicies[1];
                        i2 = indicies[0];
                        continue block8;
                    }
                    case '=': {
                        if (key != null) {
                            String errMsg = "Unable to parse url \"" + new String(token, 0, tokenIndx) + "\"";
                            throw new RuntimeException(errMsg);
                        }
                        key = new String(token, 0, tokenIndx).trim();
                        tokenIndx = 0;
                        continue block8;
                    }
                    case '&': {
                        if (key == null) {
                            String errMsg = "Unable to parse url \"" + new String(token, 0, tokenIndx) + "\"";
                            throw new RuntimeException(errMsg);
                        }
                        value = new String(token, 0, tokenIndx).trim();
                        this.addParam(key, value);
                        key = null;
                        value = null;
                        tokenIndx = 0;
                        continue block8;
                    }
                    default: {
                        token[tokenIndx++] = urlChars[i2];
                    }
                }
            }
            if (key != null) {
                value = new String(token, 0, tokenIndx).trim();
                this.addParam(key, value);
            }
        }
        catch (Exception e2) {
            Logger.getLogger("oracle.jdbc.driver").log(Level.SEVERE, "Extended settings parsing failed.", e2);
        }
    }

    private int[] parseQuotedString(int startIndex, char[] urlChars, int tokenIndex, char[] token) {
        for (int i2 = startIndex + 1; i2 < urlChars.length; ++i2) {
            char curChar = urlChars[i2];
            if (curChar == '\\') {
                if (i2 + 1 < urlChars.length && this.isValidEscapeChar(urlChars[i2 + 1])) {
                    token[tokenIndex++] = urlChars[++i2];
                    continue;
                }
                throw new RuntimeException("Invalid character at " + i2 + " : " + urlChars[i2]);
            }
            if (curChar == '\"') {
                return new int[]{i2, tokenIndex};
            }
            token[tokenIndex++] = curChar;
        }
        throw new RuntimeException("Quote at " + startIndex + " not closed.");
    }

    private boolean isValidEscapeChar(char currentChar) {
        return currentChar == '\\' || currentChar == '\"';
    }

    private void addParam(String key, String value) {
        if (key.equalsIgnoreCase(EXT_TNS_ADMIN_KEYWORD)) {
            this.addTNSAdmin(value);
        } else {
            String aliasKeyName = key.toLowerCase();
            String propertyName = URL_PROPS_ALIAS.get(aliasKeyName);
            if (propertyName != null) {
                this.urlProps.put(propertyName, value);
            } else {
                propertyName = CONNECTION_PROPS_ALIAS.getOrDefault(aliasKeyName, key);
                this.connectionProps.put(propertyName, value);
            }
        }
    }

    private void addTNSAdmin(String tnsAdminValue) {
        if (!new File(tnsAdminValue).exists()) {
            tnsAdminValue = EnvVariableResolver.resolveEnvPlaceHolders(tnsAdminValue, this.connectionProps);
        }
        this.connectionProps.put("oracle.net.tns_admin", tnsAdminValue);
    }

    private int findExtendedSettingPosition(char[] urlBytes) {
        int urlNodeDepth = 0;
        for (int i2 = 0; i2 < urlBytes.length; ++i2) {
            if (urlBytes[i2] == '(') {
                ++urlNodeDepth;
                continue;
            }
            if (urlBytes[i2] == ')') {
                --urlNodeDepth;
                continue;
            }
            if (urlBytes[i2] != '?' || urlNodeDepth != 0) continue;
            return i2;
        }
        return -1;
    }

    private static final Map<String, String> initializeUrlAlias() {
        HashMap<String, String> aliasMap = new HashMap<String, String>();
        aliasMap.put("enable", "ENABLE");
        aliasMap.put("failover", "FAILOVER");
        aliasMap.put("load_balance", "LOAD_BALANCE");
        aliasMap.put("recv_buf_size", "RECV_BUF_SIZE");
        aliasMap.put("send_buf_size", "SEND_BUF_SIZE");
        aliasMap.put("sdu", "SDU");
        aliasMap.put("source_route", "SOURCE_ROUTE");
        aliasMap.put("retry_count", "RETRY_COUNT");
        aliasMap.put("retry_delay", "RETRY_DELAY");
        aliasMap.put("https_proxy", "HTTPS_PROXY");
        aliasMap.put("https_proxy_port", "HTTPS_PROXY_PORT");
        aliasMap.put("connect_timeout", "CONNECT_TIMEOUT");
        aliasMap.put("transport_connect_timeout", "TRANSPORT_CONNECT_TIMEOUT");
        aliasMap.put("ssl_server_cert_dn", "SSL_SERVER_CERT_DN");
        aliasMap.put("wallet_location", "MY_WALLET_DIRECTORY");
        aliasMap.put("encryption_client", "ENCRYPTION_CLIENT");
        aliasMap.put("encryption_types_client", "ENCRYPTION_TYPES_CLIENT");
        aliasMap.put("crypto_checksum_client", "CRYPTO_CHECKSUM_CLIENT");
        aliasMap.put("crypto_checksum_types_client", "CRYPTO_CHECKSUM_TYPES_CLIENT");
        aliasMap.put("pool_connection_class", "POOL_CONNECTION_CLASS");
        aliasMap.put("pool_purity", "POOL_PURITY");
        aliasMap.put("service_tag", "SERVICE_TAG");
        return aliasMap;
    }

    private static final Map<String, String> initializeConnectionPropertiesAlias() {
        HashMap<String, String> aliasMap = new HashMap<String, String>();
        aliasMap.put("keystore_type", "javax.net.ssl.keyStoreType");
        aliasMap.put("keystore_password", "javax.net.ssl.keyStorePassword");
        aliasMap.put("keystore", "javax.net.ssl.keyStore");
        aliasMap.put("truststore_type", "javax.net.ssl.trustStoreType");
        aliasMap.put("truststore_password", "javax.net.ssl.trustStorePassword");
        aliasMap.put("truststore", "javax.net.ssl.trustStore");
        aliasMap.put("ssl_version", "oracle.net.ssl_version");
        aliasMap.put("ssl_ciphers", "oracle.net.ssl_cipher_suites");
        aliasMap.put("ssl_server_dn_match", "oracle.net.ssl_server_dn_match");
        aliasMap.put("allow_weak_crypto", "oracle.net.allow_weak_crypto");
        return aliasMap;
    }

    static {
        try {
            $$$methodRef$$$19 = EZConnectResolver.class.getDeclaredConstructor(String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$19 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$18 = EZConnectResolver.class.getDeclaredMethod("lambda$buildDescriptionParams$0", StringBuilder.class, Object.class, Object.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$17 = EZConnectResolver.class.getDeclaredMethod("initializeConnectionPropertiesAlias", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$16 = EZConnectResolver.class.getDeclaredMethod("initializeUrlAlias", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$15 = EZConnectResolver.class.getDeclaredMethod("findExtendedSettingPosition", char[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$14 = EZConnectResolver.class.getDeclaredMethod("addTNSAdmin", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$13 = EZConnectResolver.class.getDeclaredMethod("addParam", String.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$12 = EZConnectResolver.class.getDeclaredMethod("isValidEscapeChar", Character.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$11 = EZConnectResolver.class.getDeclaredMethod("parseQuotedString", Integer.TYPE, char[].class, Integer.TYPE, char[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$10 = EZConnectResolver.class.getDeclaredMethod("parseExtendedProperties", char[].class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$9 = EZConnectResolver.class.getDeclaredMethod("parseExtendedSettings", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$8 = EZConnectResolver.class.getDeclaredMethod("buildSecurityInfo", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = EZConnectResolver.class.getDeclaredMethod("buildDescriptionParams", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = EZConnectResolver.class.getDeclaredMethod("buildAddressList", String.class, String.class, String.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = EZConnectResolver.class.getDeclaredMethod("buildConnectData", String.class, String.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = EZConnectResolver.class.getDeclaredMethod("resolveToLongURLFormat", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = EZConnectResolver.class.getDeclaredMethod("parse", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = EZConnectResolver.class.getDeclaredMethod("getProperties", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = EZConnectResolver.class.getDeclaredMethod("getResolvedUrl", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = EZConnectResolver.class.getDeclaredMethod("newInstance", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        HOST_INFO_PATTERN = Pattern.compile("(?<hostnames>(((\\[[A-z0-9:]+\\])|([A-z0-9][A-z0-9._-]+)),?)+)(:(?<port>\\d+))?");
        EZ_URL_PATTERN = Pattern.compile("((?<protocol>tcp|tcps):)?(//)?(?<hostinfo>(" + HOST_INFO_PATTERN.pattern() + ")+)(/(?<servicename>[A-z][A-z0-9,-.]+))?(:(?<servermode>dedicated|shared|pooled))?(/(?<instance>[A-z][A-z0-9]+))?", 2);
        URL_PROPS_ALIAS = EZConnectResolver.initializeUrlAlias();
        CONNECTION_PROPS_ALIAS = EZConnectResolver.initializeConnectionPropertiesAlias();
        DESCRIPTION_PARAMS = Collections.unmodifiableList(Arrays.asList("ENABLE", "FAILOVER", "LOAD_BALANCE", "RECV_BUF_SIZE", "SEND_BUF_SIZE", "SDU", "SOURCE_ROUTE", "RETRY_COUNT", "RETRY_DELAY", "CONNECT_TIMEOUT", "TRANSPORT_CONNECT_TIMEOUT", "POOL_CONNECTION_CLASS", "POOL_PURITY"));
    }
}

