/*******************************************************************************
 * Copyright 2015 Intel Corporation.
 *
 *
 * This software and the related documents are Intel copyrighted materials, and your use of them is governed by
 * the express license under which they were provided to you ('License'). Unless the License provides otherwise,
 * you may not use, modify, copy, publish, distribute, disclose or transmit this software or the related
 * documents without Intel's prior written permission.
 * This software and the related documents are provided as is, with no express or implied warranties, other than
 * those that are expressly stated in the License.
 *******************************************************************************/

/*
//   Description:
//       Intel(R) Integrated Performance Primitives (Intel(R) IPP) Resize Functions Wrappers for Threading Layer redefinitions:
//       functions with _L API call their _LT versions
//
//   Content:
//       ippiResizeGetBufferSize_LT_Proxy
//       ippiResizeNearestInit_C4R_LT
//       ippiResizeLinearInit_C4R_LT
//       ippiResizeCubicInit_C4R_LT
//       ippiResizeLanczosInit_C4R_LT
//       ippiResizeSuperInit_C4R_LT
//       ippiResizeNearest_8u_C1R_LT_Proxy
//       ippiResizeNearest_8u_C3R_LT_Proxy
//       ippiResizeNearest_8u_C4R_LT_Proxy
//       ippiResizeNearest_16u_C1R_LT_Proxy
//       ippiResizeNearest_16u_C3R_LT_Proxy
//       ippiResizeNearest_16u_C4R_LT_Proxy
//       ippiResizeNearest_16s_C1R_LT_Proxy
//       ippiResizeNearest_16s_C3R_LT_Proxy
//       ippiResizeNearest_16s_C4R_LT_Proxy
//       ippiResizeNearest_32f_C1R_LT_Proxy
//       ippiResizeNearest_32f_C3R_LT_Proxy
//       ippiResizeNearest_32f_C4R_LT_Proxy
//       ippiResizeLinear_8u_C1R_LT_Proxy
//       ippiResizeLinear_8u_C3R_LT_Proxy
//       ippiResizeLinear_8u_C4R_LT_Proxy
//       ippiResizeLinear_16u_C1R_LT_Proxy
//       ippiResizeLinear_16u_C3R_LT_Proxy
//       ippiResizeLinear_16u_C4R_LT_Proxy
//       ippiResizeLinear_16s_C1R_LT_Proxy
//       ippiResizeLinear_16s_C3R_LT_Proxy
//       ippiResizeLinear_16s_C4R_LT_Proxy
//       ippiResizeLinear_32f_C1R_LT_Proxy
//       ippiResizeLinear_32f_C3R_LT_Proxy
//       ippiResizeLinear_32f_C4R_LT_Proxy
//       ippiResizeLinear_64f_C1R_LT_Proxy
//       ippiResizeLinear_64f_C3R_LT_Proxy
//       ippiResizeLinear_64f_C4R_LT_Proxy
//       ippiResizeCubic_8u_C1R_LT_Proxy
//       ippiResizeCubic_8u_C3R_LT_Proxy
//       ippiResizeCubic_8u_C4R_LT_Proxy
//       ippiResizeCubic_16u_C1R_LT_Proxy
//       ippiResizeCubic_16u_C3R_LT_Proxy
//       ippiResizeCubic_16u_C4R_LT_Proxy
//       ippiResizeCubic_16s_C1R_LT_Proxy
//       ippiResizeCubic_16s_C3R_LT_Proxy
//       ippiResizeCubic_16s_C4R_LT_Proxy
//       ippiResizeCubic_32f_C1R_LT_Proxy
//       ippiResizeCubic_32f_C3R_LT_Proxy
//       ippiResizeCubic_32f_C4R_LT_Proxy
//       ippiResizeLanczos_8u_C1R_LT_Proxy
//       ippiResizeLanczos_8u_C3R_LT_Proxy
//       ippiResizeLanczos_8u_C4R_LT_Proxy
//       ippiResizeLanczos_16u_C1R_LT_Proxy
//       ippiResizeLanczos_16u_C3R_LT_Proxy
//       ippiResizeLanczos_16u_C4R_LT_Proxy
//       ippiResizeLanczos_16s_C1R_LT_Proxy
//       ippiResizeLanczos_16s_C3R_LT_Proxy
//       ippiResizeLanczos_16s_C4R_LT_Proxy
//       ippiResizeLanczos_32f_C1R_LT_Proxy
//       ippiResizeLanczos_32f_C3R_LT_Proxy
//       ippiResizeLanczos_32f_C4R_LT_Proxy
//       ippiResizeSuper_8u_C1R_LT_Proxy
//       ippiResizeSuper_8u_C3R_LT_Proxy
//       ippiResizeSuper_8u_C4R_LT_Proxy
//       ippiResizeSuper_16u_C1R_LT_Proxy
//       ippiResizeSuper_16u_C3R_LT_Proxy
//       ippiResizeSuper_16u_C4R_LT_Proxy
//       ippiResizeSuper_16s_C1R_LT_Proxy
//       ippiResizeSuper_16s_C3R_LT_Proxy
//       ippiResizeSuper_16s_C4R_LT_Proxy
//       ippiResizeSuper_32f_C1R_LT_Proxy
//       ippiResizeSuper_32f_C3R_LT_Proxy
//       ippiResizeSuper_32f_C4R_LT_Proxy
//
*/

#if defined(IPP_ENABLED_THREADING_LAYER_REDEFINITIONS)
  #error \
      "This file is not intended to be compiled with -DIPP_ENABLED_THREADING_LAYER_REDEFINITIONS option. Use this option in your application instead."
#endif

#include "owndefs_tl.h"
#include "ippi_tl.h"

/* //////////////////////////////////////////////////////////// */

IPPFUN(IppStatus, ippiResizeGetBufferSize_LT_Proxy, (const IppiResizeSpec_LT *pSpec, IppiSizeL dstSize, Ipp32u numChannels, IppSizeL *pBufSize))
{
    return ippiResizeGetBufferSize_LT(pSpec, pBufSize);
}

/* //////////////////////////////////////////////////////////// */

IPPFUN(IppStatus, ippiResizeNearestInit_C4R_LT, (IppiSizeL srcSize, IppiSizeL dstSize, IppDataType dataType, IppiResizeSpec_LT *pSpec))
{
    return ippiResizeNearestInit_LT(srcSize, dstSize, dataType, 4, pSpec);
}
IPPFUN(IppStatus, ippiResizeLinearInit_C4R_LT, (IppiSizeL srcSize, IppiSizeL dstSize, IppDataType dataType, IppiResizeSpec_LT *pSpec))
{
    return ippiResizeLinearInit_LT(srcSize, dstSize, dataType, 4, pSpec);
}
IPPFUN(IppStatus, ippiResizeCubicInit_C4R_LT,
       (IppiSizeL srcSize, IppiSizeL dstSize, IppDataType dataType, Ipp32f valueB, Ipp32f valueC, IppiResizeSpec_LT *pSpec, Ipp8u *pInitBuf))
{
    return ippiResizeCubicInit_LT(srcSize, dstSize, dataType, 4, valueB, valueC, pSpec, pInitBuf);
}
IPPFUN(IppStatus, ippiResizeLanczosInit_C4R_LT,
       (IppiSizeL srcSize, IppiSizeL dstSize, IppDataType dataType, Ipp32u numLobes, IppiResizeSpec_LT *pSpec, Ipp8u *pInitBuf))
{
    return ippiResizeLanczosInit_LT(srcSize, dstSize, dataType, 4, numLobes, pSpec, pInitBuf);
}
IPPFUN(IppStatus, ippiResizeSuperInit_C4R_LT, (IppiSizeL srcSize, IppiSizeL dstSize, IppDataType dataType, IppiResizeSpec_LT *pSpec))
{
    return ippiResizeSuperInit_LT(srcSize, dstSize, dataType, 4, pSpec);
}

/* //////////////////////////////////////////////////////////// */

#define ippiResize_LT_Proxy(ftype, type, depth, chan)                                                                                             \
    IPPFUN(IppStatus, ippiResize##ftype##_##depth##_C##chan##R_LT_Proxy,                                                                          \
           (const type *pSrc, IppSizeL srcStep, type *pDst, IppSizeL dstStep, IppiPointL dstOffset, IppiSizeL dstSize, /* shall be set in init */ \
            const IppiResizeSpec_LT *pSpec, Ipp8u *pBuffer))                                                                                      \
    {                                                                                                                                             \
        return ippiResize##ftype##_##depth##_C##chan##R_LT(pSrc, srcStep, pDst, dstStep, pSpec, pBuffer);                                         \
    }

ippiResize_LT_Proxy(Nearest, Ipp8u, 8u, 1);
ippiResize_LT_Proxy(Nearest, Ipp8u, 8u, 3);
ippiResize_LT_Proxy(Nearest, Ipp8u, 8u, 4);
ippiResize_LT_Proxy(Nearest, Ipp16u, 16u, 1);
ippiResize_LT_Proxy(Nearest, Ipp16u, 16u, 3);
ippiResize_LT_Proxy(Nearest, Ipp16u, 16u, 4);
ippiResize_LT_Proxy(Nearest, Ipp16s, 16s, 1);
ippiResize_LT_Proxy(Nearest, Ipp16s, 16s, 3);
ippiResize_LT_Proxy(Nearest, Ipp16s, 16s, 4);
ippiResize_LT_Proxy(Nearest, Ipp32f, 32f, 1);
ippiResize_LT_Proxy(Nearest, Ipp32f, 32f, 3);
ippiResize_LT_Proxy(Nearest, Ipp32f, 32f, 4);

ippiResize_LT_Proxy(Super, Ipp8u, 8u, 1);
ippiResize_LT_Proxy(Super, Ipp8u, 8u, 3);
ippiResize_LT_Proxy(Super, Ipp8u, 8u, 4);
ippiResize_LT_Proxy(Super, Ipp16u, 16u, 1);
ippiResize_LT_Proxy(Super, Ipp16u, 16u, 3);
ippiResize_LT_Proxy(Super, Ipp16u, 16u, 4);
ippiResize_LT_Proxy(Super, Ipp16s, 16s, 1);
ippiResize_LT_Proxy(Super, Ipp16s, 16s, 3);
ippiResize_LT_Proxy(Super, Ipp16s, 16s, 4);
ippiResize_LT_Proxy(Super, Ipp32f, 32f, 1);
ippiResize_LT_Proxy(Super, Ipp32f, 32f, 3);
ippiResize_LT_Proxy(Super, Ipp32f, 32f, 4);

/* //////////////////////////////////////////////////////////// */

#define ippiResizeBorder_LT_Proxy(ftype, type, depth, chan)                                                                                       \
    IPPFUN(IppStatus, ippiResize##ftype##_##depth##_C##chan##R_LT_Proxy,                                                                          \
           (const type *pSrc, IppSizeL srcStep, type *pDst, IppSizeL dstStep, IppiPointL dstOffset, IppiSizeL dstSize, /* shall be set in init */ \
            IppiBorderType border, const type *pBorderValue, const IppiResizeSpec_LT *pSpec, Ipp8u *pBuffer))                                     \
    {                                                                                                                                             \
        return ippiResize##ftype##_##depth##_C##chan##R_LT(pSrc, srcStep, pDst, dstStep, border, pBorderValue, pSpec, pBuffer);                   \
    }

ippiResizeBorder_LT_Proxy(Linear, Ipp8u, 8u, 1);
ippiResizeBorder_LT_Proxy(Linear, Ipp8u, 8u, 3);
ippiResizeBorder_LT_Proxy(Linear, Ipp8u, 8u, 4);
ippiResizeBorder_LT_Proxy(Linear, Ipp16u, 16u, 1);
ippiResizeBorder_LT_Proxy(Linear, Ipp16u, 16u, 3);
ippiResizeBorder_LT_Proxy(Linear, Ipp16u, 16u, 4);
ippiResizeBorder_LT_Proxy(Linear, Ipp16s, 16s, 1);
ippiResizeBorder_LT_Proxy(Linear, Ipp16s, 16s, 3);
ippiResizeBorder_LT_Proxy(Linear, Ipp16s, 16s, 4);
ippiResizeBorder_LT_Proxy(Linear, Ipp32f, 32f, 1);
ippiResizeBorder_LT_Proxy(Linear, Ipp32f, 32f, 3);
ippiResizeBorder_LT_Proxy(Linear, Ipp32f, 32f, 4);
ippiResizeBorder_LT_Proxy(Linear, Ipp64f, 64f, 1);
ippiResizeBorder_LT_Proxy(Linear, Ipp64f, 64f, 3);
ippiResizeBorder_LT_Proxy(Linear, Ipp64f, 64f, 4);

ippiResizeBorder_LT_Proxy(Cubic, Ipp8u, 8u, 1);
ippiResizeBorder_LT_Proxy(Cubic, Ipp8u, 8u, 3);
ippiResizeBorder_LT_Proxy(Cubic, Ipp8u, 8u, 4);
ippiResizeBorder_LT_Proxy(Cubic, Ipp16u, 16u, 1);
ippiResizeBorder_LT_Proxy(Cubic, Ipp16u, 16u, 3);
ippiResizeBorder_LT_Proxy(Cubic, Ipp16u, 16u, 4);
ippiResizeBorder_LT_Proxy(Cubic, Ipp16s, 16s, 1);
ippiResizeBorder_LT_Proxy(Cubic, Ipp16s, 16s, 3);
ippiResizeBorder_LT_Proxy(Cubic, Ipp16s, 16s, 4);
ippiResizeBorder_LT_Proxy(Cubic, Ipp32f, 32f, 1);
ippiResizeBorder_LT_Proxy(Cubic, Ipp32f, 32f, 3);
ippiResizeBorder_LT_Proxy(Cubic, Ipp32f, 32f, 4);

ippiResizeBorder_LT_Proxy(Lanczos, Ipp8u, 8u, 1);
ippiResizeBorder_LT_Proxy(Lanczos, Ipp8u, 8u, 3);
ippiResizeBorder_LT_Proxy(Lanczos, Ipp8u, 8u, 4);
ippiResizeBorder_LT_Proxy(Lanczos, Ipp16u, 16u, 1);
ippiResizeBorder_LT_Proxy(Lanczos, Ipp16u, 16u, 3);
ippiResizeBorder_LT_Proxy(Lanczos, Ipp16u, 16u, 4);
ippiResizeBorder_LT_Proxy(Lanczos, Ipp16s, 16s, 1);
ippiResizeBorder_LT_Proxy(Lanczos, Ipp16s, 16s, 3);
ippiResizeBorder_LT_Proxy(Lanczos, Ipp16s, 16s, 4);
ippiResizeBorder_LT_Proxy(Lanczos, Ipp32f, 32f, 1);
ippiResizeBorder_LT_Proxy(Lanczos, Ipp32f, 32f, 3);
ippiResizeBorder_LT_Proxy(Lanczos, Ipp32f, 32f, 4);

/* //////////////////////////////////////////////////////////// */
