# Copyright (C) 2025 Intel Corporation
# SPDX-License-Identifier: MIT

class TomlMerger:

    @staticmethod
    def merge(base_toml, merge_toml):
        if base_toml == merge_toml:
            return base_toml

        for key in merge_toml:
            if key not in base_toml:
                base_toml[key] = merge_toml[key]
                continue
            TomlMerger.merge_instance(base_toml, key, merge_toml)
        return base_toml

    @staticmethod
    def merge_instance(base_toml, key, merge_toml):
        if isinstance(merge_toml[key], dict) and isinstance(base_toml[key], dict):
            TomlMerger.merge(base_toml[key], merge_toml[key])
        elif isinstance(merge_toml[key], list) and isinstance(base_toml[key], list):
            TomlMerger.merge_list(base_toml[key], merge_toml[key])
        else:
            raise TypeError(f"Instance not handled: {type(merge_toml[key])} in {key}")

    @staticmethod
    def merge_list(base_list, merge_list):
        for item in merge_list:
            if item not in base_list:
                base_list.append(item)
