"use strict";angular.module("timelinepane",["ui-session","services","loading","ngRoute"],["$routeProvider",e=>{e.when("/timeline/:identity",{template:'<div class="timelinepane" localize="localize" default-msg-catalog="viewpoint"><timeline class="timeline" configuration="::configuration" dump-api="::dumpApi" is-filter-empty="isFilterEmpty" loading="::loading" messages="::messages" pane-id="::paneId"></timeline><loading show-when="loading.isInProgress()"></loading></div><timeline-pane-test-harness-dump pane-id="::paneId" results="::results" dump-api="::dumpApi"></timeline-pane-test-harness-dump>',controller:"TimelinePaneController"})}]);
"use strict";angular.module("timelinepane").directive("timelinePane",(function(){return{restrict:"E",scope:{paneId:"="},template:'<div class="timelinepane" localize="localize" default-msg-catalog="viewpoint"><timeline class="timeline" configuration="::configuration" dump-api="::dumpApi" is-filter-empty="isFilterEmpty" loading="::loading" messages="::messages" pane-id="::paneId"></timeline><loading show-when="loading.isInProgress()"></loading></div><timeline-pane-test-harness-dump pane-id="::paneId" results="::results" dump-api="::dumpApi"></timeline-pane-test-harness-dump>',controller:"TimelinePaneController"}}));
"use strict";angular.module("timelinepane").controller("TimelinePaneController",["$scope","requestIdentity","$http","$q","$timeout","uiSession","error","localize","Tracker",function(e,o,t,i,l,n,a,r,s){const m=i.defer(),u=e.loading=new s;function p(o){const t=o.data;e.configuration={timelineId:"timeline"+Date.now(),areas:t.areas,ruler:t.ruler},e.paneId=(t.pane||{}).id||e.paneId,e.results=t.results}function T(){return r(["%ZoomInLabel","%ZoomOutLabel","%ZoomResetLabel","%ZoomUndoLabel","%FilteredOutTooltip","%PausedRangeHint","%TimelineTooltipDurationLabel","%TimelineTooltipItemsShownLabel","%TimelineTooltipStartLabel","%TimelineTooltipToLabel","%TimelineTooltipOutOfLabel","%TimelineTooltipCorrelationLabel"],"viewpoint").then((o=>{Object.assign(e.messages,{filteredOutLabel:o["%FilteredOutTooltip"],pause:o["%PausedRangeHint"],zoomInButtonTooltip:o["%ZoomInLabel"],zoomOutButtonTooltip:o["%ZoomOutLabel"],zoomUndoButtonTooltip:o["%ZoomUndoLabel"],zoomResetButtonTooltip:o["%ZoomResetLabel"],durationLabel:o["%TimelineTooltipDurationLabel"],itemsShownLabel:o["%TimelineTooltipItemsShownLabel"],outOfLabel:o["%TimelineTooltipOutOfLabel"],startLabel:o["%TimelineTooltipStartLabel"],correlationLabel:o["%TimelineTooltipCorrelationLabel"],toLabel:o["%TimelineTooltipToLabel"]})})).catch(a.handle(e))}u.start(),e.dumpApi={},e.messages={},e.isFilterEmpty=!0,n.getPartitionSocket(e).then((()=>{(function(){const i=e.paneId?"api/viewpoint/config":"api/configuration";return t.get(i,{params:{identity:o.get(e),paneId:e.paneId},timeout:m.promise})})().then(p).then(T).catch(a.handle(e)).finally(u.stop)})),e.$on("$destroy",(()=>{m.resolve(),u.destroy()}))}]);
"use strict";angular.module("timelinepane").factory("ContextDrawer",["constants",function(t){const e=t.intervalTextOffset;class s{constructor(t,e,s){this._context=t,this._textFont=e,this._utils=s}drawIntervalText(t,e,s,n){this.setContextColor(n),this.setTextBaselineStyle(),this.setTextFontStyle(),this._context.fillText(s,t,e)}drawIntervalWithText(t,s,n,i,l,o){this.drawInterval(t,s,n,i,l);const x=this._utils.clipText(this._context,o,n-2*e),r=this._utils.getContrastColor(l),a=s+i/2+1,h=t+e;this.drawIntervalText(h,a,x,r)}drawInterval(t,e,s,n,i){this.setContextColor(i),this._context.fillRect(t,e,s,n)}setTextFontStyle(){this._context.font!==this._textFont&&(this._context.font=this._textFont)}setContextColor(t){this._context.fillStyle!==t&&(this._context.fillStyle=t)}setTextBaselineStyle(){"middle"!==this._context.textBaseline&&(this._context.textBaseline="middle")}}return{create:(t,e,n)=>new s(t,e,n)}}]);
"use strict";angular.module("timelinepane").factory("Frame",["$q","constants",function(e,t){const{frameBase:s}=t,i=t.colors.defaultStrokeColor,r=s/2;function n(e){this._utils=e}function o(e,t,s){this.layerIndex=e,this.strokeColor=i,this.data=[],this.selectionData=[],this.visible=!0,this._drawer=t,this._utils=s}function l(e,t,s,i,r,n,o){e.fillStyle!==n&&(e.fillStyle=n);const l=a(e,t,s,s+t,i,r,o);e.fill(),l&&e.stroke()}function a(e,s,i,r,n,o,l){let a=!1;if(e.beginPath(),s>o&&!l){const t=i+.5,l=r+.5,c=n-.5,h=o+.5;if(e.moveTo(t,.5),e.lineTo(t,c),s>n){const s=t+o-1,i=l-o+1,r=h-1;e.lineTo(s,h),e.lineTo(s,r),e.lineTo(i,r),e.lineTo(i,h)}else{const i=s/2;e.lineTo(t+i,c-i)}e.lineTo(l,c),e.lineTo(l,.5),e.lineTo(t,.5),a=!0}else e.rect(i,0,s,n),s>t.pixelThreshold&&!l&&(a=!0);return a}return n.prototype.drawLayer=function(t,n,a){if(!n.intervals||!n.intervals.length)return void(t.graph.isRulerGraph||this._utils.setLayerAbsenceInBand(t,a.index));const{graph:c}=t,{offscreenCanvas:h}=c,d=h.getContext("2d");let y;const f=new o(a.index,this,this._utils);a.allowToHideStyles&&(y=this._utils.getVisibleStyles(a.styles));const u=e=>{const t=e.start,i=e.end,n=this._utils.processInterval(t,i,r),o=n.start,c=n.width,{isMerged:h}=e,u=this._utils.toRgba(e.colorStyle.color),g=e.colorStyle.name;let p=!0;const w={start:t,end:i,name:e.name,processedStart:o,processedWidth:c,fillColor:u,isMerged:h,style:g};a.allowToHideStyles&&(p=this._utils.checkIntervalVisibility(g,"",y)),w.isVisible=p,p&&l(d,c,o,s,r,u,h),f.data.push(w)};return{layerIndex:a.index,drawLayer:t=>{if(d.strokeStyle=i,!t)return this._utils.processArrayWithoutUIBlocking(n.intervals,u).then((()=>(c.savedLayerData.set(a.index,f),e.when())));n.intervals.forEach(u),c.savedLayerData.set(a.index,f)}}},n.prototype.highlightElements=function(e,i,n){if(i&&i.length){const o=e.getContext("2d"),l=n||t.colors.highlightColor,c=this._utils.getTimeRange(),h=c.start,d=c.end;o.fillStyle!==l&&(o.fillStyle=l),1!==o.lineWidth&&(o.lineWidth=1),i.forEach((e=>{const t=e.start,i=t+e.duration;if(i>h&&t<d){const e=this._utils.processInterval(t,i,r),n=e.start,l=e.width;a(o,l,n,n+l,s,r,!1),o.fill()}}))}},n.prototype.filterLayer=function(e,t,s){const i=e.savedLayerData.get(t.index);if(!i)return;return this._utils.filterLayer(i,t,s,(()=>{i.drawFrameLayerWithProcessedX(e)}))},o.prototype.drawFrameLayerWithProcessedX=function(e){const{offscreenCanvas:t}=e,i=t.getContext("2d");i.strokeStyle=this.strokeColor,this.data.forEach((e=>{e.isVisible&&l(i,e.processedWidth,e.processedStart,s,r,e.fillColor,e.isMerged)}))},o.prototype.processHeightResize=function(e){return{layerIndex:this.layerIndex,drawLayer:()=>{this.drawFrameLayerWithProcessedX(e)}}},o.prototype.processScroll=function(e){return{layerIndex:this.layerIndex,drawLayer:()=>{const{offscreenCanvas:t}=e,i=t.getContext("2d");i.strokeStyle=this.strokeColor;const n=this._utils.getTimeRange(),o=n.start,a=n.end;this.data.forEach((e=>{if(e.isVisible){const t=e.start,n=e.end;if(n>o&&t<a){const o=this._utils.processInterval(t,n,r),a=o.start,c=o.width;l(i,c,a,s,r,e.fillColor,e.isMerged)}}}))}}},o.prototype.restoreLayer=function(e){return{layerIndex:this.layerIndex,drawLayer:()=>{this.drawFrameLayerWithProcessedX(e)}}},o.prototype.selectLayerObjects=function(e,t,s){return{layerIndex:this.layerIndex,drawLayer:()=>{t&&t.length&&(void 0!==t[0].isVisible?this._drawer.highlightElements(e.onscreenSelectionCanvas,t.filter((e=>e.isVisible)),s):this._drawer.highlightElements(e.onscreenSelectionCanvas,t,s))}}},{create:e=>new n(e)}}]);
"use strict";angular.module("timelinepane").factory("Global",["$q","constants",function(t,e){function s(t){this._utils=t}function r(t,e,s,r){this.layerIndex=t,this.color=e.normal,this.invertedColor=e.inverted,this.data=[],this.visible=!0,this._drawer=s,this._utils=r,this._drawGlobalCrossLineLayerWithProcessedX=(t,e)=>{const s=t.offscreenGlobalCrossLineCanvas.getContext("2d");s.strokeStyle=this.color;const r=e||t.offscreenGlobalCrossLineCanvas.height;this.data.forEach((t=>{o(s,t.processedStart,r)}))}}function o(t,e,s){const r=e+.5;t.beginPath(),t.moveTo(r,0),t.lineTo(r,s),t.closePath(),t.stroke()}return s.prototype.drawLayer=function(e,s,a){if(!s.intervals)return;if(!s.intervals.length)return;const{graph:n}=e,{offscreenGlobalCrossLineCanvas:i}=n,l=i.getContext("2d"),h=i.height,c=this._utils.getXScale(),d=this._utils.toRgbaWithInvertedColor(a.color),g=d.normal,u=new r(a.index,d,this,this._utils),y=t=>{const e=t.start,s=Math.round(c(e)),r={start:e,processedStart:s};o(l,s,h),u.data.push(r)};return{layerIndex:a.index,drawLayer:e=>{if(l.strokeStyle=g,!e)return this._utils.processArrayWithoutUIBlocking(s.intervals,y).then((()=>(n.savedLayerData.set(a.index,u),n.hasDataToDisplay=!0,t.when())));s.intervals.forEach(y),n.savedLayerData.set(a.index,u),n.hasDataToDisplay=!0}}},s.prototype.highlightGlobalCrossLine=function(t,e,s){if(e.intervals&&e.intervals.length){const{onscreenGlobalCrossLineHighlightCanvas:r}=t,a=r.getContext("2d"),n=s||t.savedLayerData.get(e.index).invertedColor,i=r.height,l=this._utils.getXScale(),h=this._utils.getTimeRange(),c=h.start,d=h.end;a.strokeStyle!==n&&(a.strokeStyle=n),e.intervals.forEach((t=>{const e=t.start;if(e>c&&e<d){const t=Math.round(l(e));o(a,t,i)}}))}},s.prototype.highlightSelectionRange=function(t,s){const{onscreenGlobalSelectionCanvas:r}=t,o=r.getContext("2d");.4!==o.globalAlpha&&(o.globalAlpha=.4),o.fillStyle!==e.colors.selectionRangeColor&&(o.fillStyle=e.colors.selectionRangeColor);const a=this._utils.processInterval(s.rangeStart,s.rangeEnd),n=a.start,i=a.width;o.fillRect(n,0,i,r.height)},r.prototype.processHeightResize=function(t,e){return{layerIndex:this.layerIndex,drawLayer:()=>{this._drawGlobalCrossLineLayerWithProcessedX(t,e)}}},r.prototype.restoreLayer=function(t){return{layerIndex:this.layerIndex,drawLayer:()=>{this._drawGlobalCrossLineLayerWithProcessedX(t)}}},r.prototype.processScroll=function(t){return{layerIndex:this.layerIndex,drawLayer:()=>{const e=t.offscreenGlobalCrossLineCanvas.getContext("2d");e.strokeStyle=this.color;const{height:s}=t.offscreenGlobalCrossLineCanvas,r=this._utils.getXScale(),a=this._utils.getTimeRange(),n=a.start,i=a.end;this.data.forEach((t=>{const a=t.start;if(a>n&&a<i){const t=Math.round(r(a));o(e,t,s)}}))}}},{create:t=>new s(t)}}]);
"use strict";angular.module("timelinepane").factory("Hierarchical",["$q","constants","ContextDrawer",function(t,e,i){const{pixelThreshold:s}=e,{intervalFillThreshold:o}=e,r=e.intervalTextOffset;function n(t){this._utils=t,this._textFont=void 0}function l(t,e,i,s){this.hierarchical=!0,this.layerIndex=t,this.data=[],this.selectionData=[],this.visible=!0,this._textFont=e,this._drawer=i,this._utils=s}return n.prototype.drawLayer=function(i,n,a){const{graph:h}=i,{onscreenHierarchCanvas:c}=h,d=i.getClientDefHeight(),u=i.getInfo("currentModeDefHeight"),p=i.getInfo("commonContainerHeight")||u,f=Math.ceil(p);if(!n.intervals.length){if(c&&!c.initialized){const t=c.parentNode;if(this._utils.isZoomed())c.isDisplayed&&(t.style.display="none",c.isDisplayed=!1);else{t.parentNode.removeChild(t),h.onscreenHierarchCanvas=void 0,h.offscreenHierarchCanvas=void 0,h.onscreenHierarchHighlightCanvas=void 0;const e=h.onscreenCanvas.parentNode;e.className+=" default_container",e.style="",this._utils.setLayerAbsenceInBand(i,a.index)}i.setClientHeight(p)}return}const{offscreenHierarchCanvas:g}=h,y=n.maxDepth+1,v=g.getContext("2d"),m=c.queueIntervalHeight=Math.floor(d/e.queueIntervalHeightCoefficient),x=c.queueIntervalHeightTiny=Math.floor(m/2);if(c.initialized){if(y>c.maxDepth){const t=E.call(this),e=c.tightMode?t.tightMode:t.normalMode;i.setClientHeight(e)}}else{const t=E.call(this),e=i.getClientHeight();h.className+=" hierarchical_graph",c.isDisplayed=!0;const s=i.getInfo("tightMode")||!1;let o=s?t.tightMode:t.normalMode;if(o=o<u?u:o,c.tightMode=s,e<=u||e===f||e>t.normalMode)i.setClientHeight(o);else{const{onscreenCanvas:t}=h,{onscreenHighlightCanvas:e}=h,{onscreenSelectionCanvas:i}=h;t&&c&&e&&(t.parentNode.style="height: "+f+"px;",t.height=h.offscreenCanvas.height=e.height=i.height=f,this._utils.setPxStyles({height:f},t,e,i))}c.initialized=!0,c.maxDepth=y}const H=[],C=[],I=[],S=[],_=[];for(let t=0;t<y;t++){const e=t*m,i=t*x;H.push(e),C.push(i),I.push(e+.5),S.push(i+.5),_.push(e+m/2+1)}const{tightMode:M}=c,w={tightMode:{precomputedYIntervalPositions:C,precomputedYIntervalStrokePositions:S,queueIntervalHeight:x},normalMode:{precomputedYIntervalPositions:H,precomputedYIntervalStrokePositions:I,precomputedYTextPositions:_,queueIntervalHeight:m}};c.precomputedYPositions=w;const P=M?w.tightMode:w.normalMode,k=P.precomputedYIntervalPositions,Y=P.precomputedYIntervalStrokePositions,T=P.queueIntervalHeight,L=T-1;let R;const b=new l(a.index,this._textFont,this,this._utils),D=this._textFont;function E(){const{onscreenHierarchHighlightCanvas:t}=h,{onscreenHierarchSelectionCanvas:e}=h,i=m*y;c.parentNode.style="height: "+i+"px",c.height=g.height=t.height=e.height=i,this._utils.setPxStyles({height:i,width:c.width},c,t,e);const s=c.singleMode?0:p+1;return{normalMode:s+i,tightMode:s+x*y}}a.allowToHideStyles&&(R=this._utils.getVisibleStyles(a.styles));const F=t=>{const e=t.start,i=t.end,n=this._utils.processInterval(e,i),l=n.start,h=n.width,{depth:c}=t,d=k[c],u=Y[c],p=this._utils.toRgbaWithStrokeColor(t.colorStyle.color),f=this._utils.getContrastColor(t.colorStyle.color),y=p.fill,m=p.stroke,x=[function(){v.fillStyle!==y&&(v.fillStyle=y);v.fillRect(l,d+.5,h,T-1)}],{hatches:H}=t;let C,I=!1,S=!0;const w={start:e,end:i,processedStart:l,processedWidth:h,fillColor:y,strokeColor:m,textColor:f,style:t.colorStyle.name,hatchStyles:[],stroke:!1,name:void 0,hatches:H,processedHatches:[],depth:c,isMerged:t.isMerged};if(h>s&&!t.isMerged){if(h>o){const{name:e}=t;if(H&&H.length)for(let t=0;t<H.length;t++){const e=this._utils.getHatchPattern(g,v,H[t]);x.push(P(e)),w.hatchStyles.push(H[t].name),w.processedHatches.push(e)}I=!0,e&&(C=this._utils.clipText(v,e,h-2*r),C&&x.push((function(){M||(v.fillStyle=f,"middle"!==v.textBaseline&&(v.textBaseline="middle"),v.font!==D&&(v.font=D),v.fillText(C,l+r,_[c]))})),w.name=e,w.clippedName=C)}x.push((function(){v.strokeStyle!==m&&(v.strokeStyle=m);v.strokeRect(l+.5,u,h-1,L)})),w.stroke=!0}function P(t){return function(){M||(v.fillStyle=t,v.fillRect(l,d,h,T))}}a.allowToHideStyles&&(!I&&H&&H.length&&H.forEach((t=>{w.hatchStyles.push(t.name)})),S=this._utils.checkIntervalVisibility(w.style,w.hatchStyles,R)),w.isVisible=S,S&&x.forEach((t=>{t()})),b.data.push(w)};return{layerIndex:a.index,drawLayer:e=>{if(!e)return this._utils.processArrayWithoutUIBlocking(n.intervals,F).then((()=>(h.savedLayerData.set(a.index,b),t.when())));n.intervals.forEach(F),h.savedLayerData.set(a.index,b)}}},n.prototype.highlightElements=function(t,s,o,r,n){if(!s||!s.length)return;const l=t.getContext("2d"),a=i.create(l,this._textFont,this._utils),{precomputedYPositions:h}=r;if(!h)return;const c=r.tightMode?h.tightMode:h.normalMode,d=c.precomputedYIntervalPositions,u=c.queueIntervalHeight,p=o||e.colors.highlightColor,{start:f,end:g}=this._utils.getTimeRange();s.forEach((t=>{const e=t.start,i=e+t.duration;if(i<=f||e>=g)return;const s=void 0===n?t.depth:n,o=d[s],{start:r,width:l}=this._utils.processInterval(e,i);a.drawInterval(r,o,l,u,p)}))},n.prototype.selectElements=function(t,s,o,r){if(!s||!s.length)return;const n=t.getContext("2d"),l=i.create(n,this._textFont,this._utils),{precomputedYPositions:a}=o;if(!a)return;const h=o.tightMode?a.tightMode:a.normalMode,{precomputedYIntervalPositions:c,queueIntervalHeight:d}=h,{selectionColor:u}=e.colors,{start:p,end:f}=this._utils.getTimeRange();s.forEach((t=>{const e=t.start,i=e+t.duration;if(i<=p||e>=f)return;const s=t.depth,n=c[s],{start:a,width:h}=this._utils.processInterval(e,i),g=r(e,t.duration,s)||void 0;!o.tightMode&&g?l.drawIntervalWithText(a,n,h,d,u,g):l.drawInterval(a,n,h,d,u)}))},n.prototype.filterLayer=function(t,e,i){const s=t.savedLayerData.get(e.index);if(!s)return;return this._utils.filterLayer(s,e,i,(()=>{s.drawHierarchicalLayerWithProcessedX(t)}))},n.prototype.setIntervalTextFontStyle=function(t){this._textFont=t},l.prototype.drawHierarchicalLayerWithProcessedX=function(t){const{offscreenHierarchCanvas:e}=t,i=e.getContext("2d"),s=t.onscreenHierarchCanvas.tightMode,{precomputedYPositions:o}=t.onscreenHierarchCanvas,n=s?o.tightMode:o.normalMode,{precomputedYTextPositions:l}=n,a=n.precomputedYIntervalPositions,h=n.precomputedYIntervalStrokePositions,c=n.queueIntervalHeight,d=c-1;this.data.forEach((t=>{if(t.isVisible){const{processedStart:e}=t,{processedWidth:o}=t,{depth:n}=t,u=a[n],p=h[n],f=t.fillColor,g=t.strokeColor,y=t.textColor;if(i.fillStyle!==f&&(i.fillStyle=f),i.strokeStyle!==g&&(i.strokeStyle=g),i.fillRect(e,u,o,c),t.stroke){if(!s){const s=t.processedHatches;if(s.length)for(let t=0;t<s.length;t++)i.fillStyle=s[t],i.fillRect(e,u,o,c);const a=t.clippedName;a&&(i.fillStyle=y,"middle"!==i.textBaseline&&(i.textBaseline="middle"),i.font!==this._textFont&&(i.font=this._textFont),i.fillText(a,e+r,l[n]))}i.strokeRect(e+.5,p,o-1,d)}}}))},l.prototype.processHeightResize=function(t){return{layerIndex:this.layerIndex,drawLayer:()=>{this.drawHierarchicalLayerWithProcessedX(t)}}},l.prototype.processScroll=function(t){const{offscreenHierarchCanvas:e}=t,i=e.getContext("2d"),{tightMode:n}=t.onscreenHierarchCanvas,l=this._utils.getTimeRange(),a=l.start,h=l.end,{precomputedYPositions:c}=t.onscreenHierarchCanvas,d=n?c.tightMode:c.normalMode,{precomputedYTextPositions:u}=d,p=d.precomputedYIntervalPositions,f=d.precomputedYIntervalStrokePositions,g=d.queueIntervalHeight,y=g-1;return{layerIndex:this.layerIndex,drawLayer:()=>{this.data.forEach((t=>{if(t.isVisible){const l=t.start,c=t.end;if(c>a&&l<h){const a=this._utils.processInterval(l,c),h=a.start,d=a.width,{depth:v}=t,m=p[v],x=f[v],H=t.fillColor,C=t.strokeColor,I=t.textColor;if(i.fillStyle!==H&&(i.fillStyle=H),i.strokeStyle!==C&&(i.strokeStyle=C),i.fillRect(h,m,d,g),d>s&&!t.isMerged){if(d>o&&!n){const{name:s}=t,{hatches:o}=t;if(t.processedHatches.length?t.processedHatches.forEach((t=>{i.fillStyle=t,i.fillRect(h,m,d,g)})):o&&o.length&&o.forEach((t=>{i.fillStyle=this._utils.getHatchPattern(e,i,t),i.fillRect(h,m,d,g)})),s){const t=this._utils.clipText(i,s,d-r);i.fillStyle=I,"middle"!==i.textBaseline&&(i.textBaseline="middle"),i.font!==this._textFont&&(i.font=this._textFont),i.fillText(t,h+r,u[v])}}i.strokeRect(h+.5,x,d-1,y)}}}}))}}},l.prototype.restoreLayer=function(t){return{layerIndex:this.layerIndex,drawLayer:()=>{this.drawHierarchicalLayerWithProcessedX(t)}}},l.prototype.selectLayerObjects=function(t,e){return{layerIndex:this.layerIndex,drawLayer:()=>{e&&e.length&&(void 0!==e[0].isVisible?this._drawer.selectElements(t.onscreenHierarchSelectionCanvas,e.filter((t=>t.isVisible)),t.onscreenHierarchCanvas,this.getIntervalName.bind(this)):this._drawer.selectElements(t.onscreenHierarchSelectionCanvas,e,t.onscreenHierarchCanvas,this.getIntervalName.bind(this)))}}},l.prototype.getIntervalName=function(t,e,i){if(!this.data||!this.data.length)return;const s=this.data.find((s=>s.start===t&&s.end===t+e&&s.depth===i));return s?s.name:void 0},{create:t=>new n(t)}}]);
"use strict";angular.module("timelinepane").factory("Interval",["$q","constants","ContextDrawer",function(t,e,i){const{layersOffset:s}=e,{pixelThreshold:r}=e,{intervalFillThreshold:l}=e,n=e.intervalTextOffset,o=s+.5;function a(t){this._utils=t,this._textFont=void 0}function h(t,e,i,s){this.layerIndex=t,this.data=[],this.selectionData=[],this.visible=!0,this._textFont=e,this._drawer=i,this._utils=s}function c(t){const e=t-s;return{intervalHeight:e,intervalStrokeHeight:e-1,textYPosition:s+e/2+1}}return a.prototype.drawLayer=function(e,i,a){if(!i.intervals||!i.intervals.length)return void this._utils.setLayerAbsenceInBand(e,a.index);const{graph:d}=e,{offscreenCanvas:f}=d,y=f.getContext("2d");let u,g;const p=new h(a.index,this._textFont,this,this._utils),x=this._textFont;a.allowToHideStyles&&(g=this._utils.getVisibleStyles(a.styles));const v=t=>{const e=t.start,i=t.end,h=this._utils.processInterval(e,i),c=h.start,d=h.width,v=this._utils.toRgbaWithStrokeColor(t.colorStyle.color),S=v.fill,_=v.stroke,I=this._utils.getContrastColor(t.colorStyle.color),m=[function(){y.fillStyle!==S&&(y.fillStyle=S);y.fillRect(c,s,d,u.intervalHeight)}],{hatches:w}=t;let C,k=!1,H=!0;const L={start:e,end:i,processedStart:c,processedWidth:d,fillColor:S,strokeColor:_,textColor:I,style:t.colorStyle.name,hatchStyles:[],stroke:!1,name:void 0,hatches:w,processedHatches:[],isMerged:t.isMerged};if(d>r&&!t.isMerged){if(d>l){const{name:e}=t;if(w&&w.length)for(let t=0;t<w.length;t++){const e=this._utils.getHatchPattern(f,y,w[t]);m.push(R(e)),L.hatchStyles.push(w[t].name),L.processedHatches.push(e)}k=!0,e&&(C=this._utils.clipText(y,e,d-2*n),m.push((function(){y.fillStyle=I,"middle"!==y.textBaseline&&(y.textBaseline="middle");y.font!==x&&(y.font=x);y.fillText(C,c+n,u.textYPosition)})),L.name=e,L.clippedName=C)}m.push((function(){y.strokeStyle!==_&&(y.strokeStyle=_);y.strokeRect(c+.5,o,d-1,u.intervalStrokeHeight)})),L.stroke=!0}function R(t){return function(){y.fillStyle=t,y.fillRect(c,s,d,u.intervalHeight)}}a.allowToHideStyles&&(!k&&w&&w.length&&w.forEach((t=>{L.hatchStyles.push(t.name)})),H=this._utils.checkIntervalVisibility(L.style,L.hatchStyles,g)),L.isVisible=H,H&&m.forEach((t=>{t()})),p.data.push(L)};return{layerIndex:a.index,drawLayer:e=>{if(u=c(f.height),!e)return this._utils.processArrayWithoutUIBlocking(i.intervals,v).then((()=>(d.savedLayerData.set(a.index,p),t.when())));i.intervals.forEach(v),d.savedLayerData.set(a.index,p)}}},a.prototype.highlightElements=function(t,r,l){if(r&&r.length){const n=t.getContext("2d"),o=i.create(n,this._textFont,this._utils),a=t.height-s-1,h=l||e.colors.highlightColor,c=this._utils.getTimeRange(),d=c.start,f=c.end;r.forEach((t=>{const e=t.start,i=e+t.duration;if(i>d&&e<f){const t=this._utils.processInterval(e,i),r=t.start,l=t.width;o.drawInterval(r,s,l,a,h)}}))}},a.prototype.selectElements=function(t,r,l){if(!r||!r.length)return;const n=t.getContext("2d"),o=i.create(n,this._textFont,this._utils),a=t.height-s-1,{selectionColor:h}=e.colors,c=this._utils.getTimeRange(),d=c.start,f=c.end;r.forEach((t=>{const e=t.start,i=e+t.duration;if(i<=d||e>=f)return;const r=this._utils.processInterval(e,i),n=r.start,c=r.width,y=l(e,t.duration)||void 0;y?o.drawIntervalWithText(n,s,c,a,h,y):o.drawInterval(n,s,c,a,h)}))},a.prototype.filterLayer=function(t,e,i){const s=t.savedLayerData.get(e.index);if(!s)return;return this._utils.filterLayer(s,e,i,(()=>{s.drawIntervalLayerWithProcessedX(t,s)}))},a.prototype.setIntervalTextFontStyle=function(t){this._textFont=t},h.prototype.drawIntervalLayerWithProcessedX=function(t,e){const{offscreenCanvas:i}=t,s=i.getContext("2d"),r=c(e||i.height);this.data.forEach((t=>{t.isVisible&&this.drawIntervalWithProcessedX(s,t,r)}))},h.prototype.processHeightResize=function(t,e){return{layerIndex:this.layerIndex,drawLayer:()=>{this.drawIntervalLayerWithProcessedX(t,e)}}},h.prototype.processScroll=function(t){return{layerIndex:this.layerIndex,drawLayer:()=>{const{offscreenCanvas:e}=t,i=e.getContext("2d"),{height:a}=e,h=c(a),d=this._utils.getTimeRange(),f=d.start,y=d.end;this.data.forEach((t=>{if(t.isVisible){const a=t.start,c=t.end;if(c>f&&a<y){const d=this._utils.processInterval(a,c),f=d.start,y=d.width,u=t.fillColor,g=t.strokeColor,p=t.textColor;if(i.fillStyle!==u&&(i.fillStyle=u),i.strokeStyle!==g&&(i.strokeStyle=g),i.fillRect(f,s,y,h.intervalHeight),y>r&&!t.isMerged){if(y>l){const{name:r}=t,{hatches:l}=t;if(t.processedHatches.length?t.processedHatches.forEach((t=>{i.fillStyle=t,i.fillRect(f,s,y,h.intervalHeight)})):l&&l.length&&l.forEach((t=>{i.fillStyle=this._utils.getHatchPattern(e,i,t),i.fillRect(f,s,y,h.intervalHeight)})),r){const t=this._utils.clipText(i,r,y-n);i.fillStyle=p,"middle"!==i.textBaseline&&(i.textBaseline="middle"),i.font!==this._textFont&&(i.font=this._textFont),i.fillText(t,f+n,h.textYPosition)}}i.strokeRect(f+.5,o,y-1,h.intervalStrokeHeight)}}}}))}}},h.prototype.restoreLayer=function(t){return{layerIndex:this.layerIndex,drawLayer:()=>{this.drawIntervalLayerWithProcessedX(t)}}},h.prototype.selectLayerObjects=function(t,e){return{layerIndex:this.layerIndex,drawLayer:()=>{e&&e.length&&(void 0!==e[0].isVisible?this._drawer.selectElements(t.onscreenSelectionCanvas,e.filter((t=>t.isVisible)),this.getIntervalName.bind(this)):this._drawer.selectElements(t.onscreenSelectionCanvas,e,this.getIntervalName.bind(this)))}}},h.prototype.drawIntervalWithProcessedX=function(t,e,i){const{processedStart:r}=e,{processedWidth:l}=e,a=e.fillColor,h=e.strokeColor,c=e.textColor;if(t.fillStyle!==a&&(t.fillStyle=a),t.strokeStyle!==h&&(t.strokeStyle=h),t.fillRect(r,s,l,i.intervalHeight),e.stroke){const a=e.processedHatches;if(a.length)for(let e=0;e<a.length;e++)t.fillStyle=a[e],t.fillRect(r,s,l,i.intervalHeight);const{clippedName:h}=e;h&&(t.fillStyle=c,"middle"!==t.textBaseline&&(t.textBaseline="middle"),t.font!==this._textFont&&(t.font=this._textFont),t.fillText(h,r+n,i.textYPosition)),t.strokeRect(r+.5,o,l-1,i.intervalStrokeHeight)}},h.prototype.getIntervalName=function(t,e){if(!this.data||!this.data.length)return;const i=this.data.find((i=>i.start===t&&i.end===t+e));return i?i.name:void 0},{create:t=>new a(t)}}]);
"use strict";angular.module("timelinepane").factory("Overtime",["$q","constants",function(e,s){const{layersOffset:t}=s,r=s.dotBase/2,o=window.d3_main||window.d3;function a(e){this._utils=e}function n(e,a,n,i){this.layerIndex=e.index,this.displayFormat=e.displayFormat,this.drawer=void 0,this.color=[],this.data=[],this.filled=void 0,this.max=a,this.translate=void 0,this.visible=!0,this._drawer=n,this._utils=i,this._drawChartWithProcessedX=(e,a)=>{const{offscreenCanvas:n}=e,i=a||n.height;let c,d;switch(this.displayFormat){case s.chartFormats.SCATTER_PLOT:d=o.scaleLinear().domain([0,this.max]).range([i,r]);const e=[];let a=[];this.data.forEach(((s,t)=>{a=s.map((e=>{const s=e.y;return{x:e.x,y:s,processedX:e.processedX,processedY:Math.round(d(s))}})),c=this.color[t],this.drawer(n,a,c),e.push(a)})),this.data=e;break;case s.chartFormats.HEAT_MAP_CHART:this.data.forEach(((e,s)=>{c=this.color[s],this.drawer(n,e,c)}));break;default:d=o.scaleLinear().domain([0,this.max]).range([i,t]);const h=i-1,{translate:l}=this,u=[];let f=[];this.data.forEach(((e,s)=>{f=e.map((e=>{const s=e.y;return{x:e.x,y:s,processedX:e.processedX,processedY:p(s,d,h,i)+l}})),c=this.color[s],this.drawer(n,f,c),u.push(f)})),this.data=u}}}function i(e,s,t){const r=s.length,[o]=s,a=e.getContext("2d");a.beginPath(),a.moveTo(o.processedX,o.processedY);for(let e=1;e<r;e++){const t=s[e];a.lineTo(t.processedX,t.processedY)}a.lineTo(o.processedX,o.processedY),a.fillStyle=t,a.fill()}function c(e,s,t){const r=s.length,[o]=s,a=e.getContext("2d");"square"!==a.lineCap&&(a.lineCap="square"),a.beginPath(),a.moveTo(o.processedX,o.processedY);for(let e=1;e<r;e++){const t=s[e];a.lineTo(t.processedX,t.processedY)}a.strokeStyle=t,a.stroke()}function d(e,t,r){const o=t.length,a=e.getContext("2d");a.strokeStyle=s.colors.defaultStrokeColor,a.fillStyle=r;const n=s.dotBase/2;for(let e=0;e<o;e++){const s=t[e];l(a,n,s.processedX,s.processedY)}}function h(e,s,t){const r=e.getContext("2d");let o;const a=e.height;let n=0;s.forEach((e=>{!function(e){const{opacity:s}=e;if(0===s)return;const{processedX:i}=e;if(o!==s){const e=[...t,s];r.fillStyle="rgba("+e.join(",")+")",o=s}r.fillRect(n,0,i-n,a),n=i}(e)}))}function l(e,s,t,r){e.beginPath(),e.moveTo(t-s,r),e.lineTo(t,r-s),e.lineTo(t+s,r),e.lineTo(t,r+s),e.lineTo(t-s,r),e.fill()}function p(e,s,t,r){const o=s(e);return o<t?Math.round(o):o<r?t:r}return a.prototype.drawLayer=function(a,l,u){if(!l.seriesData||!l.seriesData.length)return void this._utils.setLayerAbsenceInBand(a,u.index);const f=!u.showSingleSeries,{graph:y}=a,{offscreenCanvas:x}=y,g=l.max,m=this._utils.getXScale();let w,X,T,_,Y,v;const C=new n(u,g,this,this._utils),M=(e,s)=>{let t=.5;const r=[],[,o]=m.range(),a=this._utils.getTimeRange(),n=a.end;if(s){t=0;const s=e[0].x;r.push({x:a.start,y:0,processedX:0,processedY:T}),r.push({x:s,y:0,processedX:Math.round(m(s)),processedY:T})}e.forEach((e=>{const s=e.x,o=e.y,a={x:s,y:o,processedX:Math.round(m(s))+t,processedY:p(o,_,Y,T)+t};r.push(a)}));const i=r[r.length-1];return r.push({x:n,y:i.y,processedX:o,processedY:i.processedY}),s&&r.push({x:n,y:0,processedX:o,processedY:T}),C.data.push(r),C.translate=t,r};let b;switch(u.displayFormat){case s.chartFormats.SCATTER_PLOT:C.drawer=d,X=()=>{S(!0);const s=e.defer(),t=l.seriesData.reverse(),r=l.seriesSet.reverse();let o=0;const a=()=>{const e=t.shift();e.points.length?(v=this._utils.toRgba(r[o++].color),C.color.push(v),w=(e=>{const s=[];return e.forEach((e=>{const t=e.x,r=e.y;s.push({x:t,y:r,processedX:Math.round(m(t)),processedY:Math.round(_(r))})})),C.data.push(s),s})(e.points),d(x,w,v)):o++,t.length>0?a():s.resolve()};return a(),s.promise};break;case s.chartFormats.HEAT_MAP_CHART:C.drawer=h,X=()=>{S();const s=e.defer(),t=l.seriesData.reverse(),r=l.seriesSet.reverse();let o=0;const a=()=>{const e=t.shift();e.points.length&&0!==g?(v=this._utils.toRgb(r[o++].color),C.color.push(v),w=(e=>{const s=[];return e.forEach((e=>{const t=e.x,r=Math.ceil(m(t))+1,o=e.y/g;s.push({x:t,processedX:r,opacity:o})})),C.data.push(s),s})(e.points),h(x,w,v)):o++,t.length>0?a():s.resolve()};return a(),s.promise};break;default:let t,r=!1;u.displayFormat===s.chartFormats.DEFAULT?(t=C.drawer=i,r=!0):t=C.drawer=c,C.filled=r,f&&l.seriesSet.length>1?X=()=>{S();const s=e.defer(),o=l.seriesData.reverse(),a=l.seriesSet.reverse();let n=0;const i=()=>{const e=o.shift();v=this._utils.toRgba(a[n++].color),C.color.push(v),w=M(e.points,r),t(x,w,v),o.length>0?i():s.resolve()};return i(),s.promise}:([b]=l.seriesSet,v=this._utils.toRgba(b.color),C.color.push(v),X=()=>(S(),w=M(l.seriesData[0].points,r),t(x,w,v),e.when()))}function S(e){T=x.height,_=o.scaleLinear().domain([0,g]).range([T,e?r:t]),Y=T-1}y.bandMax&&u.showMaxLabels&&y.bandMax.drawLayerMaximum(u.index,v,g,b),y.bandCaptionAxis&&g&&y.bandCaptionAxis.updateBandCaptionAxis(g,b);return{layerIndex:u.index,drawLayer:s=>{if(!s)return X().then((()=>(y.savedLayerData.set(u.index,C),e.when())));X(s),y.savedLayerData.set(u.index,C)}}},n.prototype.processHeightResize=function(e,s){return{layerIndex:this.layerIndex,drawLayer:()=>{this._drawChartWithProcessedX(e,s)}}},n.prototype.processScroll=function(e){return{layerIndex:this.layerIndex,drawLayer:()=>{const{offscreenCanvas:t}=e;let r,o;const a=this._utils.getXScale(),n=this._utils.getTimeRange(),i=n.start,c=n.end;switch(this.displayFormat){case s.chartFormats.SCATTER_PLOT:this.data.forEach(((e,s)=>{r=[],e.forEach((e=>{const s=e.x;s>=i&&s<=c&&r.push({processedX:Math.round(a(s)),processedY:e.processedY})})),o=this.color[s],this.drawer(t,r,o)}));break;case s.chartFormats.HEAT_MAP_CHART:this.data.forEach(((e,s)=>{r=[],e.find((e=>{const s=e.x;if(s>=i)return r.push({processedX:Math.ceil(a(s)),opacity:e.opacity}),s>c})),o=this.color[s],this.drawer(t,r,o)}));break;default:const{translate:e}=this,n=t.height+e;this.data.forEach(((s,d)=>{const h=s.length-1;if(!h)return;r=this.filled?[{processedX:Math.round(a(i)),processedY:n}]:[];let l,p,u,f=!0,y=!0,x=0;for(;y&&x<=h;)l=s[x],p=l.x,u=l.processedY,f?p>=i&&(p!==i&&0!==x&&r.push({processedX:Math.round(a(i))+e,processedY:u}),r.push({processedX:Math.round(a(p>c?c:p))+e,processedY:u}),f=!1):p<c||x===h?r.push({processedX:Math.round(a(p))+e,processedY:u}):(r.push({processedX:Math.round(a(c))+e,processedY:u}),this.filled&&r.push({processedX:Math.round(a(c))+e,processedY:n}),y=!1),x++;r.length&&(o=this.color[d],this.drawer(t,r,o))}))}}}},n.prototype.restoreLayer=function(e){return{layerIndex:this.layerIndex,drawLayer:()=>{this._drawChartWithProcessedX(e)}}},{create:e=>new a(e)}}]);
"use strict";angular.module("timelinepane").factory("Pause",["$q","constants",function(t,e){const s=e.pauseFillThreshold,a=e.colors.pauseLayerColor,i=e.pauseLayerIndex,r=e.colors.pauseLayerTextColor;function n(t){this._utils=t,this._textFont=void 0,this._pauseText=""}function o(t,e,s,a){this.layerIndex=i,this.pause=!0,this.data=[],this.visible=!0,this._pauseText=e,this._textFont=t,this._drawer=s,this._utils=a,this._drawPauseLayerWithProcessedX=(t,e)=>{const s=t.offscreenGlobalCrossLineCanvas.getContext("2d");"middle"!==s.textBaseline&&(s.textBaseline="middle"),s.font!==this._textFont&&(s.font=this._textFont);const a=e||t.offscreenGlobalCrossLineCanvas.height;this.data.forEach((t=>{l(s,t.processedStart,t.processedWidth,a,t.text)}))}}function l(t,e,s,i,n){t.fillStyle=a,t.fillRect(e,1,s,i),n&&(t.fillStyle=r,t.fillText(n,e+(s-t.measureText(n).width)/2,i/2))}return n.prototype.drawLayer=function(e,a){if(!a)return;if(!a.length)return;const{graph:r}=e,n=r.offscreenGlobalCrossLineCanvas,h=n.getContext("2d"),d=n.height,u=new o(this._textFont,this._pauseText,this,this._utils),c=t=>{const e=t.start,a=t.end,i=this._utils.processInterval(e,a),r=i.start,n=i.width,o={start:e,end:a,processedStart:r,processedWidth:n};if(n>s){const t=this._utils.clipText(h,this._pauseText,n);o.text=t,l(h,r,n,d,t)}else l(h,r,n,d);u.data.push(o)};return{layerIndex:i,drawLayer:e=>{if("middle"!==h.textBaseline&&(h.textBaseline="middle"),h.font!==this._textFont&&(h.font=this._textFont),!e)return this._utils.processArrayWithoutUIBlocking(a,c).then((()=>(r.savedLayerData.set(i,u),r.hasDataToDisplay=!0,t.when())));a.forEach(c),r.savedLayerData.set(i,u),r.hasDataToDisplay=!0}}},n.prototype.setPauseText=function(t){this._pauseText=t},n.prototype.setPauseTextFontStyle=function(t){this._textFont=t},o.prototype.processHeightResize=function(t,e){return{layerIndex:this.layerIndex,drawLayer:()=>{this._drawPauseLayerWithProcessedX(t,e)}}},o.prototype.processScroll=function(t){return{layerIndex:i,drawLayer:()=>{const e=t.offscreenGlobalCrossLineCanvas,a=e.getContext("2d"),{height:i}=e,r=this._utils.getTimeRange(),n=r.start,o=r.end;"middle"!==a.textBaseline&&(a.textBaseline="middle"),a.font!==this._textFont&&(a.font=this._textFont),this.data.forEach((t=>{const e=t.start,r=t.end;if(r>n&&e<o){const t=this._utils.processInterval(e,r),n=t.start,o=t.width;l(a,n,o,i,o>s?this._utils.clipText(a,this._pauseText,o):void 0)}}))}}},o.prototype.restoreLayer=function(t){return{layerIndex:this.layerIndex,drawLayer:()=>{this._drawPauseLayerWithProcessedX(t)}}},{create:t=>new n(t)}}]);
"use strict";angular.module("timelinepane").factory("Running",["$q","constants",function(t,e){const{layersOffset:r}=e,s=r+.5;function i(t){this._utils=t}function o(t,e,i,o){this.layerIndex=t,this.fillColor=e.fillColor,this.strokeColor=e.strokeColor,this.data=[],this.visible=!0,this._drawer=i,this._utils=o,this._drawRunningLayerWithProcessedX=(t,e)=>{const{offscreenCanvas:i}=t,o=i.getContext("2d"),n=(e||i.height)-r,l=n-1;o.fillStyle=this.fillColor,o.strokeStyle=this.strokeColor,this.data.forEach((t=>{const{processedStart:e}=t,{processedWidth:i}=t;t.stroke?(o.fillRect(e,r,i,n),o.strokeRect(e+.5,s,i-1,l)):o.fillRect(e,r,i,n)}))}}return i.prototype.drawLayer=function(i,n,l){if(!n)return void this._utils.setLayerAbsenceInBand(i,l.index);const{graph:a}=i,{offscreenCanvas:h}=a,d=h.getContext("2d"),{fill:c,stroke:f}=this._utils.toRgbaWithStrokeColor(l.color);let y,u;const p=new o(l.index,{fillColor:c,strokeColor:f},this,this._utils),x=t=>{const i=t.start,o=t.end,n=this._utils.getTimeRange();if(o>n.start&&i<n.end){const t=this._utils.processInterval(i,o),n=t.start,l=t.width,a={start:i,end:o,processedStart:n,processedWidth:l,stroke:!1};l>e.pixelThreshold?(d.fillRect(n,r,l,y),d.strokeRect(n+.5,s,l-1,u),a.stroke=!0):d.fillRect(n,r,l,y),p.data.push(a)}};return{layerIndex:l.index,drawLayer:e=>{if(d.fillStyle=c,d.strokeStyle=f,y=h.height-r,u=y-1,!e)return this._utils.processArrayWithoutUIBlocking([n],x).then((()=>(a.savedLayerData.set(l.index,p),t.when())));x(n),a.savedLayerData.set(l.index,p)}}},o.prototype.processHeightResize=function(t,e){return{layerIndex:this.layerIndex,drawLayer:()=>{this._drawRunningLayerWithProcessedX(t,e)}}},o.prototype.processScroll=function(t){return{layerIndex:this.layerIndex,drawLayer:()=>{const{offscreenCanvas:i}=t,o=i.getContext("2d"),n=i.height-r,l=n-1;o.fillStyle=this.fillColor,o.strokeStyle=this.strokeColor,this.data.forEach((t=>{const i=this._utils.processInterval(t.start,t.end),a=i.start,h=i.width;h>e.pixelThreshold?(o.fillRect(a,r,h,n),o.strokeRect(a+.5,s,h-1,l)):o.fillRect(a,r,h,n)}))}}},o.prototype.restoreLayer=function(t){return{layerIndex:this.layerIndex,drawLayer:()=>{this._drawRunningLayerWithProcessedX(t)}}},{create:t=>new i(t)}}]);
"use strict";angular.module("timelinepane").factory("Sample",["$q","constants",function(e,t){const s=.8*t.markerBase,r=t.markerBase,i=t.colors.defaultStrokeColor;function a(e){this._utils=e}function n(e,t,s){this.layerIndex=e,this.strokeColor=i,this.data=[],this.selectionData=[],this.visible=!0,this._drawer=t,this._utils=s}function o(e,t,s,r,i,a,n,o,h){e.fillStyle!==h&&(e.fillStyle=h),l(e,t,s,r,i,a,n,o),e.fill(),e.stroke()}function l(e,t,s,r,i,a,n,o){const l=r+.5,h=i+.5,d=t/2,c=l-d;let y;e.beginPath(),e.moveTo(l,s),e.lineTo(c,n),e.lineTo(c,a),o?(y=h+d,e.lineTo(y,a),e.lineTo(y,n),e.lineTo(h,s)):(y=l+d,e.lineTo(y,a),e.lineTo(y,n)),e.lineTo(l,s)}function h(e){return{markerTopY:Math.ceil(e-s)-.5,markerEdgeY:Math.ceil(e-2*s/3)-.5,translatedCanvasHeight:e-.5}}return a.prototype.drawLayer=function(s,a,l){if(!a.intervals||!a.intervals.length)return void(s.graph.isRulerGraph||this._utils.setLayerAbsenceInBand(s,l.index));const{graph:d}=s,{offscreenCanvas:c}=d,y=c.getContext("2d"),u=this._utils.getXScale();let g,f,p,m;const S=t.markerMergeThreshold;let k,v;const T=new n(l.index,this,this._utils);let x={};l.allowToHideStyles&&(v=this._utils.getVisibleStyles(l.styles));const C=e=>{const t=e.start,s=e.end,i=Math.round(u(t)),a=Math.round(u(s)),n=this._utils.toRgba(e.colorStyle.color),h=e.colorStyle.name,d=!0;if(void 0===g)g=i,f=a,p=n,m=s,x.start=t,x.processedStart=i,x.color=n,x.style=h,x.isVisible=d;else if(i-f<S&&p===n)f=a,m=s;else{l.allowToHideStyles&&(x.isVisible=this._utils.checkIntervalVisibility(x.style,"",v));const e=g!==f;x.isVisible&&o(y,r,k.translatedCanvasHeight,g,f,k.markerTopY,k.markerEdgeY,e,p),x.end=m,x.processedEnd=f,x.isMerged=e,T.data.push(x),g=i,f=a,p=n,m=s,x={start:t,processedStart:i,color:n,style:h,isVisible:d}}};return{layerIndex:l.index,drawLayer:t=>{y.strokeStyle=i,k=h(c.height);const s=()=>{l.allowToHideStyles&&(x.isVisible=this._utils.checkIntervalVisibility(x.style,"",v));const e=g!==f;x.isVisible&&o(y,r,k.translatedCanvasHeight,g,f,k.markerTopY,k.markerEdgeY,e,p),x.end=m,x.processedEnd=f,x.isMerged=e,T.data.push(x),d.savedLayerData.set(l.index,T)};if(!t)return this._utils.processArrayWithoutUIBlocking(a.intervals,C).then((()=>(s(),e.when())));a.intervals.forEach(C),s()}}},a.prototype.highlightElements=function(e,s,i){if(s&&s.length){let a,n;const o=e.getContext("2d"),d=e.height,c=this._utils.getTimeRange(),y=c.start,u=c.end;if(s.forEach(((e,t)=>{const{start:s}=e;t?(a=Math.min(a,s),n=Math.max(n,s)):a=n=s})),n>y&&a<u){const e=h(d),s=this._utils.getXScale(),c=i||t.colors.highlightColor,y=Math.round(s(a)),u=Math.round(s(n));o.fillStyle!==c&&(o.fillStyle=c),1!==o.lineWidth&&(o.lineWidth=1),l(o,r,e.translatedCanvasHeight,y,u,e.markerTopY,e.markerEdgeY,y!==u),o.fill()}}},a.prototype.filterLayer=function(e,t,s){const r=e.savedLayerData.get(t.index);if(r)return this._utils.filterLayer(r,t,s,(function(){r.drawSamplesLayerWithProcessedX(e)}))},n.prototype.drawSamplesLayerWithProcessedX=function(e,t){const{offscreenCanvas:s}=e,i=s.getContext("2d"),a=h(t||s.height);i.strokeStyle=this.strokeColor,this.data.forEach((e=>{e.isVisible&&o(i,r,a.translatedCanvasHeight,e.processedStart,e.processedEnd,a.markerTopY,a.markerEdgeY,e.isMerged,e.color)}))},n.prototype.processHeightResize=function(e,t){return{layerIndex:this.layerIndex,drawLayer:()=>{this.drawSamplesLayerWithProcessedX(e,t)}}},n.prototype.processScroll=function(e){return{layerIndex:this.layerIndex,drawLayer:()=>{const{offscreenCanvas:t}=e,s=t.getContext("2d"),i=h(t.height);s.strokeStyle=this.strokeColor;const a=this._utils.getXScale(),n=this._utils.getTimeRange(),l=n.start,d=n.end;this.data.forEach((e=>{if(e.isVisible){const t=e.start,n=e.end;if(n>=l&&t<=d){const l=Math.round(a(t)),h=Math.round(a(n));o(s,r,i.translatedCanvasHeight,l,h,i.markerTopY,i.markerEdgeY,e.isMerged,e.color)}}}))}}},n.prototype.restoreLayer=function(e){return{layerIndex:this.layerIndex,drawLayer:()=>{this.drawSamplesLayerWithProcessedX(e)}}},n.prototype.selectLayerObjects=function(e,t,s){return{layerIndex:this.layerIndex,drawLayer:()=>{t&&t.length&&(void 0!==t[0].isVisible?this._drawer.highlightElements(e.onscreenSelectionCanvas,t.filter((e=>e.isVisible)),s):this._drawer.highlightElements(e.onscreenSelectionCanvas,t,s))}}},{create:e=>new a(e)}}]);
"use strict";angular.module("timelinepane").factory("Tiny",["$q",function(t){function e(t){this._utils=t}function i(t,e,i,s,a){this.layerIndex=t,this.data=e,this.visible=!0,this._xScale=i,this._drawer=s,this._utils=a,this._drawProcessedTinyLayer=t=>{const{offscreenCanvas:e}=t,i=e.getContext("2d"),{width:s,height:a}=e,r=this.data;n(i),i.drawImage(r,0,0,r.width,r.height,0,0,s,a)},this._drawProcessedTinyLayerWithScroll=t=>{const{offscreenCanvas:e}=t,i=e.getContext("2d"),s=this._xScale,a=this._utils.getXScale(),{start:r,end:o}=this._utils.getTimeRange(),[h,d]=s.domain(),{width:c,height:l}=e,y=this.data;if(n(i),d>r&&h<o){const t=Math.round(s(r)),e=Math.round(s(o));if(t<0||e>this._utils.getTimeBins()){const t=Math.round(a(h)),e=Math.round(a(d));i.drawImage(y,0,0,y.width,y.height,t,0,e-t,l)}else i.drawImage(y,t,0,e-t,y.height,0,0,c,l)}},this._isScrolled=()=>{const{start:t,end:e}=this._utils.getTimeRange(),[i,n]=this._xScale.domain();return t!==i||e!==n}}function n(t){t.imageSmoothingEnabled=!1,t.mozImageSmoothingEnabled=!1,t.webkitImageSmoothingEnabled=!1}return e.prototype.drawLayer=function(e,n,s){if(!n.yBins||!n.yBins.length)return void this._utils.setLayerAbsenceInBand(e,s.index);const{graph:a}=e,{offscreenCanvas:r}=a,o=document.createElement("canvas"),h=o.getContext("2d");let d,c,l,y;const[u,g,w]=this._utils.toRgb(s.color),_=new i(s.index,o,this._utils.getXScale().copy(),this,this._utils);function f(t){const e=t.index*l*4;t.points.forEach((t=>{const{x:i,y:n}=t,s=e+4*i;c[s]=u,c[s+1]=g,c[s+2]=w,c[s+3]=n}))}return{layerIndex:s.index,drawLayer:e=>{if(({width:l,height:y}=r),Object.assign(o,{width:l,height:y}),d=h.getImageData(0,0,l,y),c=d.data,!e)return this._utils.processArrayWithoutUIBlocking(n.yBins,f).then((()=>(i(),t.when())));function i(){h.putImageData(d,0,0),a.savedLayerData.set(s.index,_),r.getContext("2d").drawImage(o,0,0)}n.yBins.forEach(f),i()}}},i.prototype.processHeightResize=function(t){return{layerIndex:this.layerIndex,drawLayer:()=>{(this._isScrolled()?this._drawProcessedTinyLayerWithScroll:this._drawProcessedTinyLayer)(t)}}},i.prototype.processScroll=function(t){return{layerIndex:this.layerIndex,drawLayer:()=>{this._drawProcessedTinyLayerWithScroll(t)}}},i.prototype.restoreLayer=function(t){return{layerIndex:this.layerIndex,drawLayer:()=>{(this._isScrolled()?this._drawProcessedTinyLayerWithScroll:this._drawProcessedTinyLayer)(t)}}},{create:t=>new e(t)}}]);
"use strict";angular.module("timelinepane").factory("Transition",["$q","constants",function(t,e){const{transitionBase:n}=e,d=n/2,i=n/3,a=2*i;function r(t){this._utils=t}function s(t,e,r,s){this.layerIndex=t,this.color=e,this.data=[],this.selectionData=[],this.visible=!0,this._drawer=r,this._utils=s,this._drawTransitionLayerWithProcessedX=(t,e)=>{const{offscreenTransitionsCanvas:r}=t,s=r.getContext("2d");s.fillStyle=s.strokeStyle=this.color,this.data.forEach((r=>{if(r.inRange){if(e&&(r.startBandIndex=l(t.parentAreaLookup,r.startBandId),r.endBandIndex=l(t.parentAreaLookup,r.endBandId)),h(t.parentArea,r),void 0===r.startBandMiddle||void 0===r.endBandMiddle)return;o(s,r.startBandMiddle,r.endBandMiddle,r.processedStart,r.processedEnd,n,d,a,i)}}))}}function o(t,e,n,d,i,a,r,s,o){t.lineWidth=2,t.beginPath(),t.moveTo(d,e+.5),t.lineTo(i,n+.5),t.closePath(),t.stroke(),t.fillRect(d-r,e-1,a,2),t.fillRect(d-1,e-r,2,a),t.fillRect(d-o,e-o,s,s)}function l(t,e){const n=t.bandLookup[e];if(void 0!==n)return t.bands.indexOf(n)}function h(t,e){const{startBandIndex:n,endBandIndex:d}=e;void 0!==n&&void 0!==d||(e.startBandMiddle=void 0,e.endBandMiddle=void 0),e.startBandMiddle=c(t,n),e.endBandMiddle=c(t,d)}function c(t,e){const{heights:n}=t;if(void 0===e)return;const d=n.map.get(e)||n.defHeight;return Math.round(n.getWholeHeight(e,!0)+d/2)}function u(t){const n=t.displayMode===e.displayModes.REGULAR?e.normalModeBandHeight:e.richModeBandHeight;return Math.floor(n/e.queueIntervalHeightCoefficient)}return r.prototype.drawLayer=function(e,r,c,u){if(!e)return;const{graph:f}=r.scrolled,{offscreenTransitionsCanvas:g}=f,y=g.getContext("2d"),M=this._utils.getXScale(),p=this._utils.toRgba(u.color),B=new s(u.index,p,this,this._utils),x=t=>{const s=t.start,c=t.end;if(t.startBandIndex=l(e,t.startBandId),t.endBandIndex=l(e,t.endBandId),h(r,t),void 0===t.startBandMiddle||void 0===t.endBandMiddle)return;t.inRange=!1;const u=this._utils.getTimeRange(),f=u.start,g=u.end;(s>=f&&s<=g||c>=f&&c<=g)&&(t.inRange=!0),t.inRange&&(t.processedStart=Math.round(M(s)),t.processedEnd=Math.round(M(c)),o(y,t.startBandMiddle,t.endBandMiddle,t.processedStart,t.processedEnd,n,d,a,i)),B.data.push(t)};return{layerIndex:u.index,drawLayer:e=>{if(y.fillStyle=y.strokeStyle=p,!e)return this._utils.processArrayWithoutUIBlocking(c,x).then((()=>(f.savedLayerData.set(u.index,B),t.when())));c.forEach(x),f.savedLayerData.set(u.index,B)}}},r.prototype.detectTransitionHit=function(t,n,d,i){const{graph:a}=t.scrolled;if(!a)return;const r=a.savedLayerData,s=e.transitionTooltipHitDelta,o=[];if(r.size){const e=i+t.heights.getWholeHeight(n,!0);r.forEach((t=>{t.visible&&t.data.forEach((t=>{if(t.inRange){const i=this._utils.getInterval(t.startBandIndex,t.endBandIndex);if(n>=i.start&&n<=i.end){const n=t.processedStart,i=t.processedEnd,a=this._utils.getInterval(n,i);if(d>a.start-s&&d<a.end+s){const a=t.startBandMiddle,r=t.endBandMiddle,l=this._utils.getInterval(a,r);if(e>l.start-s&&e<l.end+s)if(n===i)o.push(t);else{const l=(r-a)/(i-n),h=r-l*i;Math.abs(-l*d+e-h)/Math.sqrt(Math.pow(l,2)+1)<=s&&o.push(t)}}}}}))}))}return o},r.prototype.highlightElements=function(t,r,s,c,u,f){if(r&&r.length){const g=t.getContext("2d"),y=this._utils.getXScale(),M=u||e.colors.highlightColor,p=this._utils.getTimeRange(),B=p.start,x=p.end;g.fillStyle!==M&&(g.fillStyle=M),g.strokeStyle!==M&&(g.strokeStyle=M),r.forEach((t=>{const e=t.start,r=t.end;if(r>B&&e<x){const u=Math.round(y(e)),M=Math.round(y(r));if(void 0===t.startBandIndex||void 0===t.endBandIndex||f){if(!s)return void(t.startBandIndex=t.endBandIndex=t.startBandMiddle=t.endBandMiddle=void 0);t.startBandIndex=l(s,t.startBandId),t.endBandIndex=l(s,t.endBandId)}if(h(c,t),void 0===t.startBandMiddle||void 0===t.endBandMiddle)return;o(g,t.startBandMiddle,t.endBandMiddle,u,M,n,d,a,i)}}))}},r.prototype.highlightConnections=function(t,n,d,i){if(!t)return;const{graph:a}=n.scrolled,{onscreenTransitionsSelectionCanvas:r}=a,s=r.getContext("2d"),o=this._utils.getXScale(),h=e.colors.selectionColor,c=d=>{const i=d.start,a=d.end;i.bandIndex=l(t,i.bandId),a.bandIndex=l(t,a.bandId);const r=function(t,e,n){const{heights:d}=e,i=u(t);if(void 0===n.bandIndex)return;return Math.round(d.getWholeHeight(n.bandIndex,!0)+i*(n.depth+1))}(t,n,i),h=function(t,e,n){const{heights:d}=e;if(void 0===n.bandIndex)return;const i=u(t);return Math.round(d.getWholeHeight(n.bandIndex,!0)+i*(n.depth+.5))}(t,n,a);if(void 0===r||void 0===h)return;const{start:c,end:f}=this._utils.getTimeRange(),g=function(t,e,n,d){const i=Math.max(t,n),a=Math.min(t+e,d);if(i>=a)return;return Math.round((i+a)/2)}(i.start,i.duration,c,f),y=Math.min(a.start,f),M=Math.round(o(g)),p=Math.round(o(y));!function(t,n,d,i,a,r,s){t.lineWidth=e.connectionLineWidth,i=Math.min(i,s),t.beginPath(),t.moveTo(n,d-.5);const o={x:n,y:d},l={x:Math.max(i-e.connectionEndpointDistance,r),y:a};t.bezierCurveTo(o.x,o.y,l.x,l.y,i,a),t.stroke(),t.closePath()}(s,M,r,p,h,Math.round(o(c)),Math.round(o(f)))};return{layerIndex:i.index,drawLayer:t=>{if(s.fillStyle=s.strokeStyle=h,!t)return this._utils.processArrayWithoutUIBlocking(d,c);d.forEach(c)}}},s.prototype.processHeightResize=function(t){return{layerIndex:this.layerIndex,drawLayer:()=>{this._drawTransitionLayerWithProcessedX(t)}}},s.prototype.processScroll=function(t){return{layerIndex:this.layerIndex,drawLayer:()=>{const{offscreenTransitionsCanvas:e}=t,r=e.getContext("2d");r.fillStyle=r.strokeStyle=this.color;const s=this._utils.getXScale(),l=this._utils.getTimeRange(),h=l.start,c=l.end;this.data.forEach((t=>{const e=t.start,l=t.end;if(void 0!==t.startBandMiddle&&void 0!==t.endBandMiddle&&(e>=h&&e<=c||l>=h&&l<=c)){const h=Math.round(s(e)),c=Math.round(s(l));o(r,t.startBandMiddle,t.endBandMiddle,h,c,n,d,a,i)}}))}}},s.prototype.restoreLayer=function(t,e){return{layerIndex:this.layerIndex,drawLayer:()=>{this._drawTransitionLayerWithProcessedX(t,e)}}},s.prototype.selectLayerObjects=function(t,e,n,d,i){return{layerIndex:this.layerIndex,drawLayer:()=>{this._drawer.highlightElements(t.onscreenTransitionsSelectionCanvas,e,d,t.parentArea,n,i)}}},{create:t=>new r(t)}}]);
"use strict";angular.module("timelinepane").factory("BandCaptionAxis",["constants","textFormat",function(t,i){const{layersOffset:n}=t,e=window.d3_main||window.d3;function a(t){this._bandObj=t,this._currentMax=void 0,this._formatInfo=void 0,this._textOffset=void 0}function s(){let t=Math.floor(this._bandCaptionSVG.attr("height")/this._fontSize/2);return t<1&&(t=1),t}function o(){const t=s.call(this),[,i]=this._y.domain(),n=[i];if(t>1){const e=i/t,a=t-1;for(let t=1;t<=a;t++)n.push(e*t)}return n}return a.prototype.initBandCaptionAxisContainer=function(){this._fontSize=parseFloat(window.getComputedStyle(this._bandObj.caption,null).getPropertyValue("font-size")),this._textOffset=Math.ceil(this._fontSize/2);const t=Math.ceil(10*this._fontSize),i=Math.ceil(this._bandObj.getClientHeight());this._bandCaptionSVG=e.select(this._bandObj.caption).append("svg").attr("class","svg_band_caption").attr("style",`height: ${i}px; width: ${t}px; top: ${n}px;`).attr("height",i).attr("width",t),this._y=e.scaleLinear().range([i-n,0]),this._yAxis=e.axisLeft(this._y).tickSizeInner(4).tickSizeOuter(0),this._gyAxis=this._bandCaptionSVG.append("g").attr("class","svg_band_caption_axis").attr("transform","translate("+t+", 1)")},a.prototype.updateBandCaptionAxis=function(t,i){t!==this._currentMax&&(this._y.domain([0,t]),this._currentMax=t,this._formatInfo=function(t,i){if(!t)return{};const{format:n}=t,e={format:n};"frequency"===n?e.base=i:"percent"===n?e.base=t.percentBase:void 0===n&&i.toFixed(0).toString().length>10?e.format="scientific":"_double_"===n&&(e.format="double");return e}(i,t),this.drawBandCaptionAxis(),this.refreshCaptionPadding())},a.prototype.drawBandCaptionAxis=function(){const t=this._formatInfo,n=this._textOffset;this._yAxis.tickValues(o.call(this)).tickFormat((n=>i(t.format,"",t.base)(n))),this._gyAxis.call(this._yAxis).selectAll("text").each((function(){this.setAttribute("y",n)}))},a.prototype.processHeightResize=function(t){t=Math.ceil(t);const i=this._bandCaptionSVG.attr("width");this._bandCaptionSVG.attr("height",t).attr("style",`height: ${t}px; width: ${i}px; top: ${n}px;`),this._y.range([t-n,0]),this.drawBandCaptionAxis()},a.prototype.refreshCaptionPadding=function(){const t=this._gyAxis.select("text").node().getComputedTextLength();this._bandObj.caption.style.paddingRight=t+4+"px"},{create:t=>new a(t)}}]);
"use strict";angular.module("timelinepane").factory("BandMax",["textFormat",function(e){function t(e){this._graph=e,this._layerIndexes=[]}return t.prototype.drawLayerMaximum=function(t,a,n,i){const o=e(i.format,"",i.percentBase)(n);this.hasLayer(t)?this.updateMaximumLabel(t,o):this.createMaximumLabel(t,a,o)},t.prototype.createMaximumLabel=function(e,t,a){const n=this.getMaxContainer();if(n){const i=document.createElement("div");i.className="layer_max_label",i.style.color=t,i.dataset.id=e;const o=document.createElement("span");o.className="layer_max_marker",o.style.backgroundColor=t,i.appendChild(o),i.insertAdjacentHTML("beforeend",a),n.appendChild(i),this._layerIndexes.push(e)}},t.prototype.updateMaximumLabel=function(e,t){const a=this.getMaximumLabel(e);a&&(a.childNodes[1].textContent=t)},t.prototype.getMaxContainer=function(){return this._graph.getElementsByClassName("max_container")[0]},t.prototype.hasLayer=function(e){return-1!==this._layerIndexes.indexOf(e)},t.prototype.getMaximumLabel=function(e){e=e.toString();const t=this.getMaxContainer();if(t){const a=t.getElementsByClassName("layer_max_label");return Array.prototype.find.call(a,(t=>t.dataset.id===e))}},t.prototype.showMaximumLabel=function(e){if(this.hasLayer(e)){const t=this.getMaximumLabel(e);t&&(t.style.display="")}},t.prototype.hideMaximumLabel=function(e){if(this.hasLayer(e)){const t=this.getMaximumLabel(e);if(t){t.style.display="none";const e=t.parentNode;e.insertBefore(t,e.firstChild)}}},{create:e=>new t(e)}}]);
"use strict";angular.module("timelinepane").factory("BandSelector",(function(){function e(){this.bands=[]}return e.prototype.setAreas=function(e){this.areas=e},e.prototype.hasSelection=function(){return this.bands.length>0},e.prototype.clearBandSelection=function(){if(!this.areas||void 0===this.areaIndex||this.areaIndex>=this.areas.length)return;const{areaObj:e}=this.areas[this.areaIndex];e&&this.unselectAllBands(e)},e.prototype.getCurrentSelection=function(){return{areaId:this.areaId,areaIndex:this.areaIndex,bands:this.bands}},e.prototype.selectBand=function(e,t,n,s,a){const{bands:i}=t,d=i[s].uid,o=2===a.button;if(this.bands.length<1)this.areaId=t.id,this.areaIndex=t.index,this.addBandToSelection(e,n,s,d);else if(this.areaId!==t.id)this.clearBandSelection(),this.areaId=t.id,this.areaIndex=t.index,this.addBandToSelection(e,n,s,d);else if(a.ctrlKey||a.shiftKey)if(a.shiftKey)if(this.bands.length>0){const n=this.bands[this.bands.length-1].index,a=Math.min(n,s),i=Math.max(n,s),d=e.getVisibleBands();for(let n=a;n<=i;++n){e.setInfo(n,!0,"selected"),this.bands.push({bandId:t.bands[n].uid,index:n});const s=d.find((e=>e.getIndex()===n));s&&this.addClass(s.caption,"timeline_selected_band")}}else this.addBandToSelection(e,n,s,d);else a.ctrlKey&&(e.getInfo(s,"selected")?(e.setInfo(s,!1,"selected"),this.removeClass(n.caption,"timeline_selected_band"),this.bands=this.bands.filter((e=>e.index!==s))):this.addBandToSelection(e,n,s,d));else o&&e.getInfo(s,"selected")||this.unselectAllBands(e),this.addBandToSelection(e,n,s,d)},e.prototype.addBandToSelection=function(e,t,n,s){this.bands.some((e=>e.bandId===s&&e.index===n))||(e.setInfo(n,!0,"selected"),this.bands.push({bandId:s,index:n}),this.addClass(t.caption,"timeline_selected_band"))},e.prototype.unselectAllBands=function(e){this.bands.length&&(e.getVisibleBands().forEach((e=>{this.bands.some((t=>t.index===e.getIndex()))&&this.removeClass(e.caption,"timeline_selected_band")})),this.bands.forEach((t=>{e.setInfo(t.index,!1,"selected")})),this.bands=[])},e.prototype.getSelectedArea=function(){return this.areas[this.areaIndex]},e.prototype.getSelectedAreaIndex=function(){return this.areaIndex},{create:()=>new e}}));
"use strict";angular.module("timelinepane").factory("constants",(function(){return{chartFormats:{DEFAULT:"area",LINE_CHART:"line",HEAT_MAP_CHART:"heatmap",SCATTER_PLOT:"dot"},layerTypes:{INVALID_LAYER:"Invalid",OVERTIME_LAYER:"Overtime",EVENT_MARKER_LAYER:"EventMarker",INTERVAL_LAYER:"Interval",GLOBAL_MARKER_LAYER:"GlobalMarker",GLOBAL_CROSS_LINE:"GlobalCrossLine",HIERARCHICAL_INTERVALS:"HierarchicalInterval",FRAME_LAYER:"Frame",RUNNING_LAYER:"Running",TRANSITION_LAYER:"Transition",PAUSED_LAYER:"Paused",DELIMITER:"|"},colors:{pauseLayerColor:"rgb(240,240,240)",pauseLayerTextColor:"rgb(109,109,109)",defaultStrokeColor:"rgb(0,0,0)",highlightColor:"rgba(0,28,51,0.15)",selectionColor:"rgb(44,165,255)",selectionRangeColor:"rgb(181,213,255)",filteringRangeColor:"rgb(245,245,245)",rulerTimeLabelBgColor:"rgb(255,255,225)",rulerTimeLabelTextColor:"rgb(0,0,0)"},hatches:{BACK_DIAGONAL:"back_diagonal",FORWARD_DIAGONAL:"forward_diagonal",CROSS_DIAGONAL:"cross_diagonal",CROSS:"cross",HORIZONTAL:"horizontal",VERTICAL:"vertical"},hitArea:{Main:"main",Hierarchical:"hierarchical",Frame:"frame",Sample:"sample"},layerVisibleState:{visible:"show",invisible:"hide"},contextMenuTargetTypes:{GRAPH_ELEMENT:"graphElement",RULER_FRAME:"rulerFrame",BAND_CAPTION:"bandCaption",TIME_RANGE:"timeRange",AREA:"area"},displayModes:{REGULAR:"regular",RICH:"rich",SUPER_TINY:"super_tiny"},timelineRequest:{expand:"expand",collapse:"collapse"},defaultTopValue:5,expandAllValue:-1,collapseAllValue:0,richModeBandHeight:40,normalModeBandHeight:24,connectionEndpointDistance:50,connectionLineWidth:4,pauseLayerIndex:150,pauseFillThreshold:10,dotBase:6,transitionBase:6,markerBase:8,frameBase:8,hatchBase:8,pixelThreshold:10,intervalTextOffset:3,markerMergeThreshold:2.1,layersOffset:2,intervalFillThreshold:10,queueIntervalHeightCoefficient:1.3,rulerTimeLabelFontFamily:"'Lato', 'Helvetica Neue', Arial, Helvetica, sans-serif",transitionTooltipHitDelta:2,tooltipTimeoutDuration:50,tooltipEntryLimit:4,defaultLegendWidth:"15em",timeFormat:"time"}}));
"use strict";angular.module("timelinepane").service("Debounce",(function(){function e(e,t){let n;return(...u)=>{clearTimeout(n),n=setTimeout((()=>{e.apply(this,u)}),t)}}return{create:(t,n)=>new e(t,n)}}));
"use strict";angular.module("timelinepane").factory("Ruler",["$q","constants","bigNumber",function(e,t,i){const s=window.d3_main||window.d3;function a(e,i,s,a,r,n,o,l){this.domain=[],this.range=[],this._start=e,this._end=i,this.offsetWidth=void 0,this.offsetHeight=void 0,this.timelineObj=s,this._layers=[],this.rawCharacterSize=void 0,this.ticksFormat=void 0,this.rulerArea=void 0,this.maxTicksCount=10,this.hasSelectedItems=!1,this.selectedFrameLayersToDisplay=[],this.filteringData={},this._frameLayerDrawer=r,this._globalLayerDrawer=n,this._pauseLayerDrawer=o,this._sampleLayerDrawer=a,this._utils=l,this.initialized=!1,this.updateRulerData=!1,this.selectedTimeScale={format:t.timeFormat},this._clipToPixelRange=e=>e<0?0:e>this._utils.getTimeBins()?this._utils.getTimeBins():e}function r(e){const t=["ns","usec","ms","s"];let i=0;const s=t.length-1;let a=10;if(0===e)return{formatTime:t[s],formatDivider:1};for(e/=10;e>1e3&&i<s;)e/=1e3,a*=1e3,i++;return{formatTime:t[i],formatDivider:a}}function n(e,t,i,s){e/=i;let a=Math.round(1e3*e)/1e3;return s||(a+=t),a}return a.prototype.drawRuler=function(e){this.domain=[this._start,this._end];const t=e.getBoundingClientRect();this.offsetWidth=t.width,this.offsetHeight=t.height,this.range=[1,this.offsetWidth-1],this._utils.setTimeBins(this.offsetWidth),this.rulerArea=s.select(e),this.rawCharacterSize=parseFloat(getComputedStyle(e).fontSize)/2,this.rulerArea.select("svg").remove(),this.rulerSVG=this.rulerArea.append("svg").attr("class","svg_ruler").attr("width","100%").attr("height",Math.ceil(this.offsetHeight)),this.rulerArea.node().graph={},this.initAxisDrawers(),this.determineTicksFormat(),this.applyTicksFormat(),this.applyTicksCount(this.calculateTicksCount()),this.createAxisContainers(),this.drawAxis(),this.initGlobalCanvas()},a.prototype.initRuler=function(e){this.initialized=!0,this.initLayers(e)},a.prototype.processScroll=function(e,t,i,s){if(s&&s.skipScrollUpdate)return;if(void 0!==e&&void 0!==t){const i=e,s=i+t;this._start=i,this._end=s,this._utils.setTimeRange(i,s),this.setAxisDomain(i,s)}let a=[];if(this.rulerArea&&(void 0===s||!s.showHideScrollBar)){const e=this.rulerArea.node().graph;if(e){const t=e.onscreenCanvas;if(t){this.clearLastSelectedObjects(!0),t.getContext("2d").clearRect(0,0,t.width,t.height),a=this._utils.getGraphScrollers(e),a.scrollers.length&&(this._utils.processDataArray(a.scrollers,!0),this._utils.moveImageToOnscreenCanvas(e.offscreenCanvas,t));const i=e.savedLayerData;i&&i.size&&i.forEach(((e,t)=>{e.visible||i.delete(t)})),this.redrawVisibleSelectedObjects()}}const{globalCrossLineGraph:t}=this;if(t){const{onscreenGlobalCrossLineCanvas:e}=this.timelineObj.content.graph;e.getContext("2d").clearRect(0,0,e.width,e.height),a=this._utils.getGraphScrollers(t),a.scrollers.length&&(this._utils.processDataArray(a.scrollers,!0),this._utils.moveImageToOnscreenCanvas(t.offscreenGlobalCrossLineCanvas,e)),t.onscreenGlobalFilteringCanvas&&this.redrawTimelineAreasFiltering()}}},a.prototype.processResize=function(e,t,i){const s=i.graphWidth;if(s!==this._utils.getTimeBins()){if(this.offsetWidth=s,this._utils.setTimeBins(s),this.setAxisRange(1,s-1),this.rulerArea&&this.rulerArea.node().graph){const{graph:e}=this.rulerArea.node(),t=e.onscreenCanvas;if(t){const i=e.onscreenHighlightCanvas,a=e.onscreenSelectionCanvas;t.width=e.offscreenCanvas.width=i.width=s,this._utils.setPxStyles({width:s},t,i),a&&(a.width=s,this._utils.setPxStyles({width:s},a))}}if(this.globalCrossLineGraph){const e=void 0===i.contentHeight?Math.ceil(this.timelineObj.content.offsetHeight-this.offsetHeight):i.contentHeight,{onscreenGlobalCrossLineCanvas:t}=this.globalCrossLineGraph,{offscreenGlobalCrossLineCanvas:a}=this.globalCrossLineGraph,{onscreenGlobalCrossLineHighlightCanvas:r}=this.globalCrossLineGraph,{onscreenGlobalSelectionCanvas:n}=this.globalCrossLineGraph,{onscreenGlobalFilteringCanvas:o}=this.globalCrossLineGraph,l={height:e,width:s,left:this.timelineObj.clientOffsets.left};t&&(t.width=a.width=r.width=s,t.height=a.height=r.height=e,this._utils.setPxStyles(l,t,r)),n&&(n.width=s,n.height=e,this._utils.setPxStyles(l,n)),o&&(o.width=s,o.height=e,this._utils.setPxStyles(l,o))}}},a.prototype.processHeightResize=function(e,t,i){if(this.globalCrossLineGraph){const e=void 0===i.contentHeight?Math.ceil(this.timelineObj.content.offsetHeight-this.offsetHeight):i.contentHeight,{onscreenGlobalCrossLineCanvas:t}=this.globalCrossLineGraph,{offscreenGlobalCrossLineCanvas:s}=this.globalCrossLineGraph,{onscreenGlobalCrossLineHighlightCanvas:a}=this.globalCrossLineGraph,{onscreenGlobalSelectionCanvas:r}=this.globalCrossLineGraph,{onscreenGlobalFilteringCanvas:n}=this.globalCrossLineGraph;if(e!==n.height){const o={height:e};if(t&&(t.height=s.height=a.height=e,this._utils.setPxStyles(o,t,a)),r&&(r.height=e,this._utils.setPxStyles(o,r)),n&&(n.height=e,this._utils.setPxStyles(o,n)),i.showHideScrollBar)this.processScroll(void 0,void 0,0,{});else{if(t){const i=this.globalCrossLineGraph.savedLayerData,a=[];i.size&&(i.forEach((t=>{t.visible&&a.push(t.processHeightResize(this.globalCrossLineGraph,e))})),this._utils.processDataArray(a,!0),this._utils.moveImageToOnscreenCanvas(s,t))}n&&this.redrawTimelineAreasFiltering()}}this.globalCrossLineGraph.wasResized=!0}},a.prototype.onUpdate=function(){this.rulerArea&&(this.initialized?this.updateLayers():this.updateRulerData=!0)},a.prototype.initAxisDrawers=function(){this.x=s.scaleLinear().domain(this.domain).range(this.range),this.xAxis=s.axisTop(this.x).tickSizeInner(8).tickSizeOuter(0),this.xAxisExt=s.axisTop(this.x)},a.prototype.convertPixelToTime=function(e){return this._utils.getXScale().invert(e)},a.prototype.applyTicksFormat=function(){if(this.selectedTimeScale.format===t.timeFormat){const e=this;this.xAxis.tickFormat((t=>t/e.ticksFormat.formatDivider+e.ticksFormat.formatTime))}else this.xAxis.tickFormat(this.formatTimestampInSelectedUnits.bind(this))},a.prototype.applyTicksCount=function(e){this.xAxis.ticks(e),this.xAxisExt.ticks(10*e)},a.prototype.createAxisContainers=function(){const e="translate(0,"+Math.ceil(this.offsetHeight)+")";this.gxAxisExt=this.rulerSVG.append("g").attr("class","svg_ruler extend_axis").attr("transform",e),this.gxAxis=this.rulerSVG.append("g").attr("class","svg_ruler axis").attr("transform",e)},a.prototype.drawAxis=function(){this.gxAxis.select("g").empty()||(this.rawCharacterSize=this.getRawCharacterSize(),this.applyTicksCount(this.calculateTicksCount())),this.gxAxis.call(this.xAxis),this.gxAxisExt.call(this.xAxisExt).selectAll("line").each((function(e,t){this.setAttribute("y2",t%2?-3:-4)})),this.alignTicks()},a.prototype.getRawCharacterSize=function(){const e=this.gxAxis.select("text"),t=e.text().length;return e.node().getBBox().width/t},a.prototype.determineTicksFormat=function(){const e=this.domain[1]-this.domain[0];this.ticksFormat=r(e)},a.prototype.calculateTicksCount=function(){let e=0,i=0;if(this.selectedTimeScale.format===t.timeFormat){i=(Math.floor(this.domain[1]/this.ticksFormat.formatDivider).toString().length+this.ticksFormat.formatTime.length+3)*this.rawCharacterSize}else i=this.formatTimestampInSelectedUnits(this.domain[1]).length*this.rawCharacterSize;const s=Math.floor(this.offsetWidth/i);return e=s-Math.ceil(s/2),e>this.maxTicksCount&&(e=this.maxTicksCount),e<1&&(e=1),e},a.prototype.alignTicks=function(){const e=this.gxAxis.selectAll("g"),t=e.size()-1,{rawCharacterSize:i,offsetWidth:a}=this;function r(e){const[t,i]=e.substring(e.indexOf("(")+1,e.length-1).split(",").map((e=>Number.parseFloat(e)));return{x:t,y:i}}e.each((function(e,n){if(0===n){r(this.getAttribute("transform")).x<this.childNodes[1].textContent.length*i/2&&s.select(this).select("text").classed("right_aligned",!0)}else if(n===t){const e=r(this.getAttribute("transform")).x,t=this.childNodes[1].textContent.length*i;a-e-t/2<t/2&&s.select(this).select("text").classed("left_aligned",!0)}}))},a.prototype.setAxisRange=function(e,t){this.range=[e,t],this.x&&(this.x.range(this.range),this.drawAxis())},a.prototype.setAxisDomain=function(e,t){this.domain=[e,t],this.x.domain(this.domain),this.determineTicksFormat(),this.applyTicksFormat(),this.drawAxis()},a.prototype.initLayers=function(e){if(null!=e&&e.length>0){this._layers=e.slice(),this.rulerArea.selectAll("canvas").remove();const i=this.rulerArea.node(),s=document.createElement("canvas"),a=document.createElement("canvas");s.className="idvc_canvas ruler_canvas",a.className="idvc_canvas ruler_canvas highlight_canvas";const r=document.createElement("canvas"),n=Math.max(t.frameBase,t.markerBase);s.width=a.width=r.width=this._utils.getTimeBins(),s.height=a.height=r.height=n,this._utils.setPxStyles({height:n,width:s.width},s,a);const o=new Map;let l=1,h=0,c=!1;if(this._layers.forEach((e=>{if(e.type!==t.layerTypes.EVENT_MARKER_LAYER){if(e.type===t.layerTypes.GLOBAL_CROSS_LINE)return void l++;c=!0}h++})),this.globalCrossLineGraph.globalCrossLineLayersCount=l,i.graph={onscreenCanvas:s,onscreenHighlightCanvas:a,offscreenCanvas:r,savedLayerData:o,isRulerGraph:!0,commonLayersCount:h},i.appendChild(s),i.appendChild(a),c){const e=this.globalCrossLineGraph.onscreenGlobalCrossLineCanvas.height,t=document.createElement("canvas");t.className="idvc_canvas ruler_canvas selection_canvas",t.width=this._utils.getTimeBins(),t.height=n,this._utils.setPxStyles({height:n,width:t.width},t),i.graph.onscreenSelectionCanvas=t,i.appendChild(t);const s=document.createElement("canvas");s.className="idvc_canvas global_canvas selection_canvas",s.width=this._utils.getTimeBins(),s.height=e,this._utils.setPxStyles({height:e,width:this._utils.getTimeBins(),left:this.timelineObj.clientOffsets.left,top:this.offsetHeight},s),this.globalCrossLineGraph.onscreenGlobalSelectionCanvas=s,this.timelineObj.content.appendChild(s)}}this.updateRulerData&&(this.updateLayers(),this.updateRulerData=!1)},a.prototype.updateFilteredRange=function(e){const t=this.filteringData.filteringRange,i=e.range;t&&i.start===t.rangeStart&&i.end===t.rangeEnd||this.filterTimelineAreas({rangeStart:i.start,rangeEnd:i.end},e.filterIn)},a.prototype.refreshGlobalData=function(){return this.requestGlobalData(this._start,this._end,this.offsetWidth,this)},a.prototype.updateLayers=function(){const i=[];for(const e of this._layers)e.visible?i.push(this.requestLayer(e,this._start,this._end,this.offsetWidth,this)):e.type===t.layerTypes.GLOBAL_CROSS_LINE?this.globalCrossLineGraph.savedLayerData.delete(e.index):this.rulerArea.node().graph.savedLayerData.delete(e.index);this.requestGlobalData&&i.push(this.requestGlobalData(this._start,this._end,this.offsetWidth,this)),e.all(i).then((e=>{const{graph:t}=this.rulerArea.node(),{onscreenCanvas:i}=t,{globalCrossLineGraph:s}=this;if(e&&e.length)this._utils.processDataArray(e).then((()=>{if(i&&(i.getContext("2d").clearRect(0,0,i.width,i.height),this._utils.moveImageToOnscreenCanvas(t.offscreenCanvas,i)),s){const{onscreenGlobalCrossLineCanvas:e}=s;e.getContext("2d").clearRect(0,0,e.width,e.height),s.hasDataToDisplay&&(this._utils.moveImageToOnscreenCanvas(s.offscreenGlobalCrossLineCanvas,e),s.hasDataToDisplay=!1)}this.selectedFrameLayersToDisplay.length&&(this.clearLastSelectedObjects(),this.highlightSelectedObjects(this.selectedFrameLayersToDisplay,!0),this.selectedFrameLayersToDisplay=[])}));else if(i&&i.getContext("2d").clearRect(0,0,i.width,i.height),s){const{onscreenGlobalCrossLineCanvas:e}=s;e.getContext("2d").clearRect(0,0,e.width,e.height)}}))},a.prototype.drawLayer=function(e,i){const s=i.type;if(s===t.layerTypes.GLOBAL_CROSS_LINE)return this.globalCrossLineGraph.savedLayerData.delete(i.index),this._globalLayerDrawer.drawLayer(this.timelineObj.content,e,i);if(s===t.layerTypes.PAUSED_LAYER)return this.globalCrossLineGraph.savedLayerData.delete(i.index),this._pauseLayerDrawer.drawLayer(this.timelineObj.content,e);if(this.rulerArea.node().graph.savedLayerData.delete(i.index),s===t.layerTypes.EVENT_MARKER_LAYER)return this._sampleLayerDrawer.drawLayer(this.rulerArea.node(),e,i);if(s===t.layerTypes.FRAME_LAYER){if(e.selection){const t=e.selection.layers;t&&t.length&&(this.selectedFrameLayersToDisplay=this.selectedFrameLayersToDisplay.concat(t))}return this._frameLayerDrawer.drawLayer(this.rulerArea.node(),e,i)}},a.prototype.highlightGlobalCrossLineLayerData=function(e){this.globalCrossLineGraph&&this.globalCrossLineGraph.onscreenGlobalCrossLineHighlightCanvas&&this.globalCrossLineGraph.savedLayerData.size&&this._globalLayerDrawer.highlightGlobalCrossLine(this.globalCrossLineGraph,e)},a.prototype.addLinesToHighlightedRulerFrame=function(e){this.globalCrossLineGraph&&this.globalCrossLineGraph.onscreenGlobalCrossLineHighlightCanvas&&this._globalLayerDrawer.highlightGlobalCrossLine(this.globalCrossLineGraph,e,t.colors.highlightColor)},a.prototype.clearHighlightedGlobalCrossLines=function(){if(this.globalCrossLineGraph&&this.globalCrossLineGraph.onscreenGlobalCrossLineHighlightCanvas){const{onscreenGlobalCrossLineHighlightCanvas:e}=this.globalCrossLineGraph;e.getContext("2d").clearRect(0,0,e.width,e.height)}},a.prototype.selectObjects=function(e){if(e.selection){const t=e.selection.layers;t.length&&this.highlightSelectedObjects(t,!0)}},a.prototype.highlightSelectedObjects=function(e,i){const s=this.rulerArea.node().graph;e.forEach((e=>{if(e.type===t.layerTypes.FRAME_LAYER&&(this._frameLayerDrawer.highlightElements(s.onscreenSelectionCanvas,e.intervals,t.colors.selectionColor),i)){const t=s.savedLayerData.get(e.index);t&&t.selectionData.push({intervals:e.intervals,index:e.index,type:e.type})}}));const a=this.getSelectionRange(!0);a&&(this._globalLayerDrawer.highlightSelectionRange(this.globalCrossLineGraph,a),this.hasSelectedItems=!0)},a.prototype.hasSelection=function(){const e=this.rulerArea.node().graph;let t=!1;return e.savedLayerData&&e.savedLayerData.size&&e.savedLayerData.forEach((e=>{e.visible&&e.selectionData&&e.selectionData.length&&(t=!0)})),t},a.prototype.getSelectionRange=function(e){let t=this._utils.getTimeRange().end,i=0;const s=this.rulerArea.node().graph;let a=!1;if(s.savedLayerData&&s.savedLayerData.size&&s.savedLayerData.forEach((s=>{e&&!s.visible||s.selectionData&&s.selectionData.length&&(a=!0,s.selectionData.forEach((e=>{e.intervals.forEach((e=>{const{start:s}=e,a=s+e.duration;s<t&&(t=s),a>i&&(i=a)}))})))})),a)return{rangeStart:t,rangeEnd:i}},a.prototype.redrawVisibleSelectedObjects=function(e){const t=[];this.rulerArea.node().graph.savedLayerData.forEach((e=>{e.visible&&e.selectionData&&e.selectionData.length&&t.push(e.selectionData[0])})),this.clearLastSelectedObjects(!e),t.length&&this.highlightSelectedObjects(t,e)},a.prototype.clearLastSelectedObjects=function(e){if(this.hasSelectedItems){const t=this.rulerArea.node().graph,{onscreenSelectionCanvas:i}=t;i.getContext("2d").clearRect(0,0,i.width,i.height);const{onscreenGlobalSelectionCanvas:s}=this.globalCrossLineGraph;s.getContext("2d").clearRect(0,0,s.width,s.height),!e&&t.savedLayerData.size&&t.savedLayerData.forEach((e=>{e.selectionData&&e.selectionData.length&&(e.selectionData=[])})),this.hasSelectedItems=!1}},a.prototype.hasObjectsToSelect=function(){return this.selectedFrameLayersToDisplay.length>0},a.prototype.initGlobalCanvas=function(){const e=document.createElement("canvas");e.className="idvc_canvas global_canvas filtering_canvas",e.width=this._utils.getTimeBins();const t=this.timelineObj.content,i=Math.ceil(t.offsetHeight-this.offsetHeight);e.height=i;const s=document.createElement("canvas"),a=document.createElement("canvas"),r=document.createElement("canvas");s.className="idvc_canvas global_canvas",r.className="idvc_canvas global_canvas highlight_canvas",s.width=a.width=r.width=this._utils.getTimeBins(),s.height=a.height=r.height=i,this._utils.setPxStyles({height:i,width:this._utils.getTimeBins(),left:this.timelineObj.clientOffsets.left,top:this.offsetHeight},e,s,r),t.appendChild(s),t.appendChild(r),this.globalCrossLineGraph=t.graph={onscreenGlobalFilteringCanvas:e,onscreenGlobalCrossLineCanvas:s,onscreenGlobalCrossLineHighlightCanvas:r,offscreenGlobalCrossLineCanvas:a,savedLayerData:new Map,hasDataToDisplay:!1},t.appendChild(e)},a.prototype.filterTimelineAreas=function(e,i){if(!e)return;if(void 0===e.rangeStart||void 0===e.rangeEnd)return;this.clearTimelineFiltering();const{onscreenGlobalFilteringCanvas:s}=this.globalCrossLineGraph;if(s){const a=s.getContext("2d"),r=this._utils.getXScale(),n=s.height;.7!==a.globalAlpha&&(a.globalAlpha=.7),a.fillStyle!==t.colors.filteringRangeColor&&(a.fillStyle=t.colors.filteringRangeColor);let o=Math.round(r(e.rangeStart)),l=Math.round(r(e.rangeEnd));o=this._clipToPixelRange(o),l=this._clipToPixelRange(l),i?(o&&a.fillRect(0,0,o,n),l!==this._utils.getTimeBins()&&a.fillRect(l,0,this._utils.getTimeBins()-l,n)):a.fillRect(o,0,l-o,n);const h=this.filteringData;h.filteringRange||(h.filteringRange=e,h.filterIn=i)}},a.prototype.redrawTimelineAreasFiltering=function(){const{onscreenGlobalFilteringCanvas:e}=this.globalCrossLineGraph;if(e){const e=this.filteringData;e.filteringRange&&this.filterTimelineAreas(e.filteringRange,e.filterIn)}},a.prototype.clearTimelineFiltering=function(){const{onscreenGlobalFilteringCanvas:e}=this.globalCrossLineGraph;e&&(e.getContext("2d").clearRect(0,0,e.width,e.height),delete this.filteringData.filteringRange)},a.prototype.isWithinFilteredRange=function(e){if(!this.filteringData.filteringRange)return!1;const t=this._utils.getXScale();let i=t(this.filteringData.filteringRange.rangeStart),s=t(this.filteringData.filteringRange.rangeEnd);if(i=this._clipToPixelRange(i),s=this._clipToPixelRange(s),e>i&&e<s){if(!1===this.filteringData.filterIn)return!0}else if(this.filteringData.filterIn)return!0;return!1},a.prototype.isWithinPausedRange=function(e){let i=!1;if(this.globalCrossLineGraph){const s=this.globalCrossLineGraph.savedLayerData;if(s&&s.size){const a=s.get(t.pauseLayerIndex);if(a){const t=this._utils.getXScale();i=a.data.some((i=>{const s=t(i.start),a=t(i.end);return e>=s&&e<=a}))}}}return i},a.prototype.showRulerLayer=function(e){let i;const s=()=>this.requestLayer(e,this._start,this._end,this.offsetWidth,this);e.type===t.layerTypes.GLOBAL_CROSS_LINE?(i=this.globalCrossLineGraph,this._utils.smartShowLayer(i,i.onscreenGlobalCrossLineCanvas,i.offscreenGlobalCrossLineCanvas,i.globalCrossLineLayersCount,e,s),i.hasDataToDisplay=!1):(i=this.rulerArea.node().graph,this._utils.smartShowLayer(i,i.onscreenCanvas,i.offscreenCanvas,i.commonLayersCount,e,s,i.onscreenSelectionCanvas))},a.prototype.hideRulerLayer=function(e){let i;e.type===t.layerTypes.GLOBAL_CROSS_LINE?(i=this.globalCrossLineGraph,this._utils.smartHideLayer(i,i.onscreenGlobalCrossLineCanvas,i.offscreenGlobalCrossLineCanvas,i.globalCrossLineLayersCount,e)):(i=this.rulerArea.node().graph,this._utils.smartHideLayer(i,i.onscreenCanvas,i.offscreenCanvas,i.commonLayersCount,e,i.onscreenSelectionCanvas))},a.prototype.getTimelineCaptionPadding=function(){return this.timelineObj.clientOffsets.left},a.prototype.getLabel=function(e,i){const s=this._utils.getXScale().invert(e);let a=this.formatTimestampInSelectedUnits(s,this.ticksFormat.formatTime,this.ticksFormat.formatDivider);if(i&&i!==e){const e=this._utils.getXScale().invert(i),t=Math.abs(s-e);a+=" [Duration: "+this.formatDurationInSelectedUnits(t,this.ticksFormat.formatTime,this.ticksFormat.formatDivider)+"]"}return{text:a,fontSize:t.rulerTimeLabelFontSize,fontFamily:t.rulerTimeLabelFontFamily,bkColor:t.colors.rulerTimeLabelBgColor,textColor:t.colors.rulerTimeLabelTextColor}},a.prototype.formatTimestampInSelectedUnits=function(e,s,a,r){if(this.selectedTimeScale.format===t.timeFormat)return n(e,s,a,r);{const t=i(this.selectedTimeScale.timeUnitOffset);return i(e*this.selectedTimeScale.timeUnitCoefficient).decimalPlaces(0).plus(t).toString()}},a.prototype.formatDurationInSelectedUnits=function(e,i,s){return this.selectedTimeScale.format===t.timeFormat?n(e,i,s):Math.round(e*this.selectedTimeScale.timeUnitCoefficient)},a.prototype.formatTimeInRulerUnitsOfMeasure=function(e,t){return this.formatTimestampInSelectedUnits(e,this.ticksFormat.formatTime,this.ticksFormat.formatDivider,t)},a.prototype.formatDurationInRulerTimeScale=function(e){const i=this.selectedTimeScale.format===t.timeFormat?r(e):{};return this.formatDurationInSelectedUnits(e,i.formatTime,i.formatDivider)},a.prototype.setSelectedTimeScale=function(e){e&&(this.selectedTimeScale=e,this.selectedTimeScale.format===t.timeFormat&&this.determineTicksFormat(),this.initAxisDrawers(),this.applyTicksFormat(),this.drawAxis())},{create:(e,t,i,s,r,n,o,l)=>new a(e,t,i,s,r,n,o,l)}}]);
"use strict";angular.module("timelinepane").factory("Utils",["$q","constants",function(e,t){const i=window.d3_main||window.d3;function n(){this._currentStart=void 0,this._currentEnd=void 0,this._numberOfTimeBins=void 0,this._hatches=new Map,this._canvasScale=i.scaleLinear(),this._scroll=void 0,this._newTimeRange=void 0}function s(e){return"number"==typeof e&&Number.isInteger(e)}function r(e){return/^#([0-9A-Fa-f]{6})$/.test(e)}function a(e){return/^rgb\(\s*(\d{1,3}\s*,\s*){2}\d{1,3}\s*\)$/.test(e)}function o(e){return[...this.toRgb(e),s(e)?((4278190080&e)>>>24)/255:1]}function l(e,t){return e.layerIndex-t.layerIndex}return n.prototype.setTimeScale=function(e,t){this._canvasScale.domain([e,t]),this._currentStart=e,this._currentEnd=t},n.prototype.setTimeRange=function(e,t){e===this._currentStart&&t===this._currentEnd||(this._currentStart=e,this._currentEnd=t,this._canvasScale.domain([e,t]))},n.prototype.setTimeBins=function(e){this._numberOfTimeBins=e,this._canvasScale.range([0,e])},n.prototype.setHorzScroll=function(e){this._scroll=e},n.prototype.getXScale=function(){return this._canvasScale},n.prototype.getTimeRange=function(){return{start:this._currentStart,end:this._currentEnd}},n.prototype.getTimeBins=function(){return this._numberOfTimeBins},n.prototype.toRgbaWithStrokeColor=function(e){const[t,i,n,s]=o.call(this,e);return{fill:`rgba(${t},${i},${n},${s})`,stroke:"rgba(255,255,255,1)"}},n.prototype.toRgbaWithInvertedColor=function(e){const[t,i,n,s]=o.call(this,e);return{normal:`rgba(${t},${i},${n},${s})`,inverted:`rgba(${255-t},${255-i},${255-n},${s})`}},n.prototype.toRgba=function(e){const[t,i,n,s]=o.call(this,e);return`rgba(${t},${i},${n},${s})`},n.prototype.getContrastColor=function(e){const[t,i,n]=o.call(this,e);return.299*t+.587*i+.114*n>186?"#000000":"#ffffff"},n.prototype.toRgb=function(e){return r(e)?function(e){if(!r(e))return[0,0,0];const t=parseInt(e.substring(1,3),16),i=parseInt(e.substring(3,5),16),n=parseInt(e.substring(5,7),16);return[t,i,n]}(e):a(e)?function(e){if(!a(e))return[0,0,0];const t=e.match(/\d+/g);if(3!==t.length)return[0,0,0];const i=parseInt(t[0],10),n=parseInt(t[1],10),s=parseInt(t[2],10);return[i,n,s]}(e):s(e)?function(e){const t=255&e,i=(65280&e)>>>8,n=(16711680&e)>>>16;return[n,i,t]}(e):[0,0,0]},n.prototype.clipText=function(e,t,i){if(!t)return"";const n=t.length,s=e.measureText(t).width;if(s<i)return t;{let r=Math.floor(n*i/s),a=t.substring(0,r);const o=e.measureText(a).width;let l=a.slice(0);if(o<=i){let n="";do{a+=n,n=t.charAt(r++),l+=n}while(e.measureText(l)<=i);return a}{let t=0;do{t++,l=l.slice(0,-1)}while(e.measureText(l)>i);return a.slice(0,-t)}}},n.prototype.getInterval=function(e,t){let i,n;return e<t?(i=e,n=t):(i=t,n=e),{start:i,end:n}},n.prototype.buildVerticalHatch=function(e,t){const i=t/2+.5;e.beginPath(),e.moveTo(i,0),e.lineTo(i,t),e.stroke()},n.prototype.buildHorizontalHatch=function(e,t){const i=t/2+.5;e.beginPath(),e.moveTo(0,i),e.lineTo(t,i),e.stroke()},n.prototype.buildCrossHatch=function(e,t){this.buildVerticalHatch(e,t),this.buildHorizontalHatch(e,t)},n.prototype.buildFwdDiagonalHatch=function(e,t){e.beginPath(),e.moveTo(0,t),e.lineTo(t,0),e.stroke()},n.prototype.buildBwdDiagonalHatch=function(e,t){e.beginPath(),e.moveTo(0,0),e.lineTo(t,t),e.stroke()},n.prototype.buildCrossDiagonalHatch=function(e,t){this.buildFwdDiagonalHatch(e,t),this.buildBwdDiagonalHatch(e,t)},n.prototype.getHatch=function(e,t){let i,n=this._hatches.get(t);if(n){let s=n.get(e);return s||(i=this.createNewHatch(e,t),n.set(e,i),s=i),s}return n=new Map,i=this.createNewHatch(e,t),n.set(e,i),this._hatches.set(t,n),i},n.prototype.getHatchPattern=function(e,t,i){let{patterns:n}=e;const s=i.color,{hatchStyle:r}=i,a=r+"_"+s;let o;if(n){const e=n.get(a);return e||(o=t.createPattern(this.getHatch(s,r),"repeat"),n.set(a,o),o)}return e.patterns=n=new Map,o=t.createPattern(this.getHatch(s,r),"repeat"),n.set(a,o),o},n.prototype.createNewHatch=function(e,i){const{hatchBase:n}=t,s=n/2,r=document.createElement("canvas"),a=r.getContext("2d"),{hatches:o}=t;switch(i){case o.BACK_DIAGONAL:r.width=r.height=n,a.strokeStyle=this.toRgba(e),this.buildBwdDiagonalHatch(a,n);break;case o.FORWARD_DIAGONAL:r.width=r.height=n,a.strokeStyle=this.toRgba(e),this.buildFwdDiagonalHatch(a,n);break;case o.CROSS_DIAGONAL:r.width=r.height=n,a.strokeStyle=this.toRgba(e),this.buildCrossDiagonalHatch(a,n);break;case o.CROSS:r.width=r.height=s,a.strokeStyle=this.toRgba(e),this.buildCrossHatch(a,s);break;case o.HORIZONTAL:r.width=r.height=s,a.strokeStyle=this.toRgba(e),this.buildHorizontalHatch(a,s);break;case o.VERTICAL:r.width=r.height=s,a.strokeStyle=this.toRgba(e),this.buildVerticalHatch(a,s)}return r},n.prototype.processArrayWithoutUIBlocking=function(t,i){const n=e.defer();return setTimeout((function e(){const s=(new Date).getTime();do{i(t.shift())}while(t.length>0&&(new Date).getTime()-s<50);t.length>0?setTimeout(e,25):n.resolve()}),25),n.promise},n.prototype.processDataArray=function(t,i){t.sort(l);const n=e.defer(),s=i?function(e){e.drawLayer(i),r()}:function(e){e.drawLayer().then(r)};function r(){t[0]?s(t.shift()):n.resolve()}return r(),n.promise},n.prototype.moveImageToOnscreenCanvas=function(e,t){t.getContext("2d").drawImage(e,0,0),e.getContext("2d").clearRect(0,0,e.width,e.height)},n.prototype.convertHighlightFrameDataToGlobalXLines=function(e){const t=[];return e.intervals.forEach((e=>{const{start:i}=e;t.push({start:i}),t.push({start:i+e.duration})})),{intervals:t}},n.prototype.setElementHidden=function(e){"hidden"!==e.style.visibility&&(e.style.visibility="hidden")},n.prototype.setElementVisible=function(e){"visible"!==e.style.visibility&&(e.style.visibility="visible")},n.prototype.isMaxVisibleLayerIndex=function(e,t){let i=!0;return e.forEach((e=>{e.visible&&e.layerIndex>t&&(i=!1)})),i},n.prototype.smartShowLayer=function(t,i,n,s,r,a,o){const l=e.defer(),c=t.savedLayerData.get(r.index);let h=!1;if(c){if(c.visible=!0,h=c.selectionData&&c.selectionData.length>0,1!==s||t.wasResized)if(this.isMaxVisibleLayerIndex(t.savedLayerData,r.index)){if(c.restoreLayer(t).drawLayer(),this.moveImageToOnscreenCanvas(n,i),o&&h)if(t.isRulerGraph)this.rulerObj.redrawVisibleSelectedObjects();else{const e=[];this.getSelectionDrawers(t,c,e),o.getContext("2d").clearRect(0,0,o.width,o.height),this.processDataArray(e,!0)}}else u.call(this);else this.setCanvasElementsVisible(t,i,o);l.resolve()}else a().then((e=>{e&&(h=void 0!==e.selectObjects||this.rulerObj.hasObjectsToSelect(),1===s||this.isMaxVisibleLayerIndex(t.savedLayerData,r.index)?(e.drawLayer(!0),this.moveImageToOnscreenCanvas(n,i),o&&h&&(t.isRulerGraph?this.rulerObj.redrawVisibleSelectedObjects(!0):e.selectObjects())):u.call(this,e)),l.resolve()}));function u(e){i.getContext("2d").clearRect(0,0,i.width,i.height);const s=[],r=[];e&&(s.push(e),r.push({drawLayer:e.selectObjects,layerIndex:e.layerIndex})),t.savedLayerData.forEach((function(e){e.visible&&(s.push(e.restoreLayer(t)),e.selectionData&&e.selectionData.length&&!t.isRulerGraph&&this.getSelectionDrawers(t,e.selectionData,r))})),this.processDataArray(s,!0),this.moveImageToOnscreenCanvas(n,i),o&&h&&(t.isRulerGraph?this.rulerObj.redrawVisibleSelectedObjects(void 0!==e):(o.getContext("2d").clearRect(0,0,o.width,o.height),this.processDataArray(r,!0)))}return this.setCanvasElementsVisible(t,i,o),t.wasResized=!1,l.promise},n.prototype.smartHideLayer=function(e,i,n,s,r,a){const o=e.savedLayerData.get(r.index),l=[];let c=!1;o&&(o.visible=!1,c=o.selectionData&&o.selectionData.length>0);const h=r.type.split(t.layerTypes.DELIMITER);if(1===s||h.includes(t.layerTypes.HIERARCHICAL_INTERVALS))return this.setCanvasElementsHidden(e,i,a);{i.getContext("2d").clearRect(0,0,i.width,i.height);const t=[];e.savedLayerData.forEach((i=>{i.visible&&!i.hierarchical&&(t.push(i.restoreLayer(e)),i.selectionData&&i.selectionData.length&&!e.isRulerGraph&&this.getSelectionDrawers(e,i.selectionData,l))})),t.length&&(this.processDataArray(t,!0),this.moveImageToOnscreenCanvas(n,i))}a&&c&&(e.isRulerGraph?this.rulerObj.redrawVisibleSelectedObjects():(a.getContext("2d").clearRect(0,0,a.width,a.height),this.processDataArray(l,!0)))},n.prototype.checkIntervalVisibility=function(e,t,i){return!!i.allVisible||(!!i.visibleColorStyles.some((t=>t===e))||!!(t&&t.length&&t.some((e=>i.visibleHatchStyles.some((t=>t===e))))))},n.prototype.getVisibleStyles=function(e){const t=[],i=[];return e.forEach((e=>{e.visible&&e.name.length&&(e.hatchStyle?i.push(e.name):t.push(e.name))})),{visibleColorStyles:t,visibleHatchStyles:i,allVisible:i.length+t.length===e.length}},n.prototype.getGraphScrollers=function(e){const{savedLayerData:t}=e,i=[],n=[];return t.size&&t.forEach((t=>{t.visible&&(i.push(t.processScroll(e)),e.isRulerGraph||this.getSelectionDrawers(e,t,n))})),{scrollers:i,selectionScrollers:n}},n.prototype.getSelectionDrawers=function(e,i,n,s){if(!n)return;const{selectionData:r}=i;r&&r.length&&r.forEach((r=>{n.push(i.selectLayerObjects(e,r.intervals,r.isSelection?t.colors.selectionColor:"",void 0,s))}))},n.prototype.setCanvasElementsVisible=function(e,t,i){this.setElementVisible(t),i&&(this.setElementVisible(i),e.isRulerGraph&&this.setElementVisible(this.rulerObj.globalCrossLineGraph.onscreenGlobalSelectionCanvas))},n.prototype.setCanvasElementsHidden=function(e,t,i){this.setElementHidden(t),i&&(this.setElementHidden(i),e.isRulerGraph&&this.setElementHidden(this.rulerObj.globalCrossLineGraph.onscreenGlobalSelectionCanvas))},n.prototype.checkSelectionData=function(e){return e.highlight&&e.highlight.layers&&e.highlight.layers.length>0||e.selection&&e.selection.layers&&e.selection.layers.length>0||e.correlation&&e.correlation.layers&&e.correlation.layers.length>0},n.prototype.isZoomed=function(){if(this._scroll)return!this._scroll.zoomManager.getZoomState().wholeView},n.prototype.saveNewTimeRange=function(e,t){this._newTimeRange={start:e,end:t}},n.prototype.popNewTimeRange=function(){if(!this._newTimeRange)return;const e={start:this._newTimeRange.start,end:this._newTimeRange.end};return this.clearSavedTimeRange(),e},n.prototype.isTimeRangePendingProcessing=function(){return void 0!==this._newTimeRange},n.prototype.clearSavedTimeRange=function(){delete this._newTimeRange},n.prototype.setLayerAbsenceInBand=function(e,t){const i=e.getInfo("layerNonexistenceArray");i&&(this.isZoomed()||-1!==i.indexOf(t)||i.push(t))},n.prototype.checkLayerAbsenceInBand=function(e,t){const i=e.getInfo("layerNonexistenceArray");return!!i&&-1!==i.indexOf(t)},n.prototype.processInterval=function(e,t,i){const n=void 0===i?1:i,s=e<this._currentStart?-n:Math.round(this._canvasScale(e));let r=t>this._currentEnd?this._numberOfTimeBins-s+n:Math.round(this._canvasScale(t))-s;return 0===r&&(r=1),{start:s,width:r}},n.prototype.filterLayer=function(e,t,i,n){const s=e.data,r=e.selectionData;let a=!1;const o=this.getVisibleStyles(t.styles),l=i.visible?function(e){let t=!1;return e.forEach(((n,s)=>{!n.isVisible&&(n.style===i.name||n.hatchStyles&&n.hatchStyles.some((e=>e===i.name)))&&(e[s].isVisible=!0,t=!0)})),t}:function(e){let t=!1;return e.forEach((function(n,s){if(n.isVisible){let r=!0;n.hatchStyles&&n.hatchStyles.length?r=this.checkIntervalVisibility(n.style,n.hatchStyles,o):n.style===i.name&&(r=!1),r||(e[s].isVisible=!1,t=!0)}}),this),t},c=l.call(this,s);return r.forEach((function(e){a=l.call(this,e.intervals)||a}),this),{layerUpdateDrawer:{layerIndex:e.layerIndex,drawLayer:n},layerUpdate:c,selectionUpdate:a}},n.prototype.setPxStyles=function(e,...t){Object.keys(e).forEach((i=>{const n=e[i];let s;switch(typeof n){case"string":s=n;break;case"number":s=n+"px"}t.forEach((e=>{e&&(e.style[i]=s)}))}))},n.prototype.setAttributes=function(e,...t){t.forEach((t=>{t&&Object.assign(t,e)}))},{create:()=>new n}}]);
"use strict";angular.module("timelinepane").factory("View",["$q","constants","BandMax","BandCaptionAxis",function(e,t,s,a){const n=window.d3_main||window.d3;function i(e,s,a,i,r,o,c,l,h,d,g){this._drawers={},this._lastHighlightedItems={},this.pointerInsideSelectionArea=!1,this._pauseLayerDrawer=h,this._tinyLayerDrawer=l,this._transitionLayerDrawer=c,this._ruler=d,this._utils=g,this._drawers[t.layerTypes.OVERTIME_LAYER]=e,this._drawers[t.layerTypes.INTERVAL_LAYER]=r,this._drawers[t.layerTypes.FRAME_LAYER]=s,this._drawers[t.layerTypes.EVENT_MARKER_LAYER]=i,this._drawers[t.layerTypes.HIERARCHICAL_INTERVALS]=a,this._drawers[t.layerTypes.RUNNING_LAYER]=o,this._highlightSelectedObjects=(e,s,a)=>{const n=new Map,i=a.getVisibleBands(),r=[],o=[];if(e.forEach((e=>{const c=e.type.split(t.layerTypes.DELIMITER),{bands:l}=e;if(l&&l.length)if((c.includes(t.layerTypes.INTERVAL_LAYER)||c.includes(t.layerTypes.HIERARCHICAL_INTERVALS)||c.includes(t.layerTypes.FRAME_LAYER)||c.includes(t.layerTypes.EVENT_MARKER_LAYER))&&l.forEach((a=>{const o=function(e){const t=n.get(e);if(!t){const t=function(e){const{bands:t}=s;return t?t.findIndex((t=>t.uid===e)):-1}(e);if(-1===t)return null;const r=(a=t,i.find((e=>e.getIndex()===a)));return n.set(e,r),r}var a;return t}(a.id);if(!o)return;const{graph:c}=o,{isSelection:l}=e,h=l?t.colors.selectionColor:"",d=c.savedLayerData.get(e.index);if(!d)return;let g=a.intervals;const y=function(e,t){return e.layers.find((e=>e.index===t))}(s,e.index);if(y.allowToHideStyles){const e=this._utils.getVisibleStyles(y.styles);g=a.intervals.map((t=>{const s=t.colorStyle.name,a=t.hatches?t.hatches.map((e=>e.name)):[];return{start:t.start,duration:t.duration,depth:t.depth,style:s,hatchStyles:a,isVisible:this._utils.checkIntervalVisibility(s,a,e)}}))}d.selectionData.push({intervals:g,isSelection:l}),r.push(d.selectLayerObjects(c,g,h))})),e.type===t.layerTypes.TRANSITION_LAYER){const n=a.scrolled.graph,[{intervals:i}]=e.bands,o=e.isSelection?t.colors.selectionColor:"",c=n.savedLayerData.get(e.index);if(!c)return;c.selectionData.push({intervals:i,isSelection:e.isSelection}),r.push(c.selectLayerObjects(n,i,o,s))}else c.includes(t.layerTypes.TRANSITION_LAYER)&&l.forEach((t=>{t.intervals&&t.intervals.length&&t.intervals.forEach((s=>{o.push({bandId:t.id,start:s.start,duration:s.duration,depth:s.depth,layerIndex:e.index})}))}))})),o.length>1){const e=o.shift();let n=e.layerIndex+"";const i=o.map((s=>(n+=t.layerTypes.DELIMITER+s.layerIndex,{start:e,end:s}))),c={index:n,data:i};r.push(this._transitionLayerDrawer.highlightConnections(s,a,i,c))}this._utils.processDataArray(r,!0),n.clear()},this._requestAreaLayer=(e,t)=>{e.layerToLoad=t,this.showAreaLoading(e);const s=this._requestAreaUpdate(e);return e.layerToLoad=void 0,s},this._requestAreaUpdate=e=>e.updateVisibleBands(),this._refreshAreaLoadingOffset=e=>{if(e.scrolled){const t=n.select(e.scrolled).select("div.area_loading");t.size()&&t.style("left",e.captionPadding.style.width)}}}return i.prototype.drawGraph=function(e,n){const{graph:i}=e;let r=!1,o=!1,c=!1,l=!1,h=!1,d=e.getClientDefHeight();const g=n.displayMode;let y;const p=g===t.displayModes.SUPER_TINY;let v=i;const u=this._utils.getTimeBins();if(i.innerHTML="",i.savedLayerData=new Map,g===t.displayModes.RICH&&n.useWideBandsInRichMode&&(d=t.richModeBandHeight),e.setInfo(d,"currentModeDefHeight"),e.getInfo("currentBandMode")!==g&&(e.setInfo(g,"currentBandMode"),e.setInfo(void 0,"commonContainerHeight"),d===t.richModeBandHeight&&(e.setClientHeight(Math.ceil(d)),l=!0)),p){const t=e.getArea();if(t){const s=t.content.clientHeight;0!==s&&(e.setClientHeight(s-1),i.className+=" super_tiny_graph")}}void 0===e.getInfo("layerNonexistenceArray")&&e.setInfo([],"layerNonexistenceArray");const f=document.createElement("canvas"),C=document.createElement("canvas");f.className="idvc_canvas",i.onscreenCanvas=f,i.offscreenCanvas=C;let _=0;if(n.layers.forEach((e=>{if(e.type.split(t.layerTypes.DELIMITER).includes(t.layerTypes.HIERARCHICAL_INTERVALS))return r=!0,void(o=e.visible);e.showMaxLabels&&(h=!0),_++})),c=n.layers.length>0&&0===_,i.commonLayersCount=_,h&&(y=document.createElement("div"),y.className="max_container",i.bandMax=s.create(i)),n.showYScale&&(i.bandCaptionAxis=a.create(e),i.bandCaptionAxis.initBandCaptionAxisContainer()),r){const t=document.createElement("div");t.className="main_canvas_container",v=t,i.appendChild(t),c&&(t.style.display="none");const s=document.createElement("canvas"),a=document.createElement("canvas"),n=document.createElement("canvas");s.className="idvc_canvas hierarch_canvas",a.className="idvc_canvas hierarch_canvas highlight_canvas",n.className="idvc_canvas hierarch_canvas selection_canvas";const r=document.createElement("div"),h=c?"single_layer_mode":"multy_layer_mode";r.className="hierarchical_canvas_container "+h,r.appendChild(s),r.appendChild(a),r.appendChild(n),i.onscreenHierarchCanvas=s,i.onscreenHierarchHighlightCanvas=a,i.onscreenHierarchSelectionCanvas=n,i.appendChild(r),s.initialized=!1,s.isDisplayed=o,s.singleMode=c;const g=document.createElement("canvas");if(i.offscreenHierarchCanvas=g,g.width=s.width=a.width=n.width=u,g.height=s.height=a.height=n.height=0,!o)if(r.style.display="none",l)t.style.height=`${Math.ceil(e.getClientHeight())}px`;else{const t=e.getInfo("commonContainerHeight")||d;e.setClientHeight(Math.ceil(t))}}if(v.appendChild(f),!c){const t={width:u,height:Math.ceil(e.getClientHeight())};if(this._utils.setAttributes(t,f,C),this._utils.setPxStyles(t,f),!p){const e=document.createElement("canvas"),s=document.createElement("canvas");e.className="idvc_canvas highlight_canvas",s.className="idvc_canvas selection_canvas",i.onscreenHighlightCanvas=e,i.onscreenSelectionCanvas=s,v.appendChild(e),v.appendChild(s),this._utils.setAttributes(t,e,s),this._utils.setPxStyles(t,e,s)}}y&&v.appendChild(y)},i.prototype.drawLayer=function(e,s,a){if(a.visible){if(e.getInfo("currentBandMode")===t.displayModes.SUPER_TINY)return this._tinyLayerDrawer.drawLayer(e,s,a);{const n=a.type.split(t.layerTypes.DELIMITER),i=[];for(const t of n){const n=this._drawers[t];n&&i.push(n.drawLayer(e,s,a))}return i}}},i.prototype.displayLayersData=function(e){const{onscreenCanvas:t}=e,{onscreenTransitionsCanvas:s}=e;if(t){t.getContext("2d").clearRect(0,0,t.width,t.height),this._utils.moveImageToOnscreenCanvas(e.offscreenCanvas,t);const{onscreenHierarchCanvas:s}=e;s&&s.isDisplayed&&0!==s.height&&(s.getContext("2d").clearRect(0,0,s.width,s.height),this._utils.moveImageToOnscreenCanvas(e.offscreenHierarchCanvas,s))}else s&&(s.getContext("2d").clearRect(0,0,s.width,s.height),this._utils.moveImageToOnscreenCanvas(e.offscreenTransitionsCanvas,s))},i.prototype.showAreaLayer=function(s,a){let n,i;const r=a.index,o=()=>{const t=e.defer();return this._requestAreaLayer(s,a).then((e=>{const a=e.bandsData;let n;a&&a.length&&(n=a[0].data[0],n.selectObjects=()=>{this.selectObjects(e.selectionData,e.area,s)}),t.resolve(n)})),t.promise},c=(e,t)=>{t&&(t.getContext("2d").clearRect(0,0,t.width,t.height),this._utils.processDataArray(e,!0))},l=e=>e.length>1?e.some((e=>!this._utils.checkLayerAbsenceInBand(e,r)&&d(e))):d(e[0]),h=a.type.split(t.layerTypes.DELIMITER);if(h.includes(t.layerTypes.TRANSITION_LAYER)&&(n=s.scrolled.graph,this._utils.smartShowLayer(n,n.onscreenTransitionsCanvas,n.offscreenTransitionsCanvas,n.transitionLayersCount,a,o,n.onscreenTransitionsSelectionCanvas).finally((()=>{this.hideAreaLoading(s)}))),h.includes(t.layerTypes.HIERARCHICAL_INTERVALS)&&(i=s.getVisibleBands(),l(i)?this._requestAreaLayer(s,a).then((e=>{if(!e)return;const t=this._utils.checkSelectionData(e.selectionData);e.bandsData.forEach((a=>{const n=a.graphObject,{onscreenHierarchCanvas:i}=n;i.getContext("2d").clearRect(0,0,i.width,i.height),a.data[0].drawLayer(!0),this._utils.moveImageToOnscreenCanvas(n.offscreenHierarchCanvas,i),t&&this.selectObjects(e.selectionData,e.area,s),this._utils.setCanvasElementsVisible(n,i,n.onscreenHierarchSelectionCanvas),n.wasResized=!1}))})).finally((()=>{this.refreshTransitionsGraph(s),this.hideAreaLoading(s)})):i.forEach((e=>{const{graph:t}=e,s=t.savedLayerData.get(r);if(s){const e=s.selectionData&&s.selectionData.length>0;if(t.wasResized&&(s.processHeightResize(t).drawLayer(),this._utils.moveImageToOnscreenCanvas(t.offscreenHierarchCanvas,t.onscreenHierarchCanvas),e)){const e=[];this._utils.getSelectionDrawers(t,s,e),c(e,t.onscreenHierarchSelectionCanvas)}this._utils.setCanvasElementsVisible(t,t.onscreenHierarchCanvas,t.onscreenHierarchSelectionCanvas),s.visible=!0}t.wasResized=!1}))),!h.includes(t.layerTypes.TRANSITION_LAYER)&&!h.includes(t.layerTypes.HIERARCHICAL_INTERVALS))if(i=s.getVisibleBands(),l(i)){if(a.inSharedScaleGroup)return this._requestAreaUpdate(s);this._requestAreaLayer(s,a).then((e=>{if(!e)return;const t=this._utils.checkSelectionData(e.selectionData);e.bandsData.forEach((n=>{const i=n.graphObject,{onscreenCanvas:o}=i;if(1===i.commonLayersCount||this._utils.isMaxVisibleLayerIndex(i.savedLayerData,r))n.data.pop().drawLayer(!0),this._utils.moveImageToOnscreenCanvas(i.offscreenCanvas,o),t&&this.selectObjects(e.selectionData,e.area,s);else if(o.getContext("2d").clearRect(0,0,o.width,o.height),this._utils.processDataArray(n.data,!0),this._utils.moveImageToOnscreenCanvas(i.offscreenCanvas,o),t){const{onscreenSelectionCanvas:t}=i,a=[{drawLayer:()=>{this.selectObjects(e.selectionData,e.area,s)},layerIndex:r}];i.savedLayerData.forEach((e=>{e.visible&&!e.hierarchical&&e.selectionData&&e.selectionData.length&&this._utils.getSelectionDrawers(i,e,a)})),c(a,t)}i.bandMax&&a.showMaxLabels&&i.bandMax.showMaximumLabel(r),this._utils.setCanvasElementsVisible(i,o,i.onscreenSelectionCanvas),i.wasResized=!1}))})).finally((()=>{this.hideAreaLoading(s)}))}else i.forEach((e=>{const{graph:t}=e,s=t.savedLayerData.get(r),{onscreenCanvas:n}=t,{onscreenSelectionCanvas:i}=t,o=[];if(s){s.visible=!0;const e=s.selectionData&&s.selectionData.length>0;if(1!==t.commonLayersCount||t.wasResized)if(this._utils.isMaxVisibleLayerIndex(t.savedLayerData,r))s.restoreLayer(t).drawLayer(),this._utils.moveImageToOnscreenCanvas(t.offscreenCanvas,n),e&&(this._utils.getSelectionDrawers(t,s,o),c(o,i));else{const s=[];t.savedLayerData.forEach((e=>{e.visible&&!e.hierarchical&&(s.push(e.restoreLayer(t)),e.selectionData&&e.selectionData.length&&this._utils.getSelectionDrawers(t,o))})),n.getContext("2d").clearRect(0,0,n.width,n.height),this._utils.processDataArray(s,!0),this._utils.moveImageToOnscreenCanvas(t.offscreenCanvas,n),e&&c(o,i)}else this._utils.setCanvasElementsVisible(t,n,t.onscreenSelectionCanvas)}t.bandMax&&a.showMaxLabels&&t.bandMax.showMaximumLabel(r),this._utils.setCanvasElementsVisible(t,n,t.onscreenSelectionCanvas),t.wasResized=!1}));function d(e){let t=!0;const{savedLayerData:s}=e.graph;if(s){const e=s.size;if(e){const a=s.keys();let n=0;for(;t&&n!==e;)a.next().value===r&&(t=!1),n++}}return t}},i.prototype.hideAreaLayer=function(e,s){let a,n;const i=s.type.split(t.layerTypes.DELIMITER);s.type===t.layerTypes.TRANSITION_LAYER?(a=e.scrolled.graph,this._utils.smartHideLayer(a,a.onscreenTransitionsCanvas,a.offscreenTransitionsCanvas,a.transitionLayersCount,s,a.onscreenTransitionsSelectionCanvas)):i.includes(t.layerTypes.HIERARCHICAL_INTERVALS)?(n=e.getVisibleBands(),n.forEach((e=>{const{graph:t}=e,{onscreenHierarchCanvas:a}=t;t.savedLayerData.has(s.index)&&a&&a.isDisplayed&&this._utils.smartHideLayer(t,t.onscreenHierarchCanvas,t.offscreenHierarchCanvas,1,s,t.onscreenHierarchSelectionCanvas)}))):(n=e.getVisibleBands(),n.forEach((e=>{const{graph:t}=e;t.bandMax&&s.showMaxLabels&&t.bandMax.hideMaximumLabel(s.index),this._utils.smartHideLayer(t,t.onscreenCanvas,t.offscreenCanvas,t.commonLayersCount,s,t.onscreenSelectionCanvas)})))},i.prototype.onChangeLayerWithSeries=function(e,t){this._requestAreaLayer(e,t).then((s=>{s.bandsData.length?s.bandsData.forEach((e=>{const t=e.graphObject,{onscreenCanvas:s}=t;s.getContext("2d").clearRect(0,0,s.width,s.height),this._utils.processDataArray(e.data,!0),this._utils.moveImageToOnscreenCanvas(t.offscreenCanvas,s),1===t.commonLayersCount&&this._utils.setCanvasElementsVisible(t,s,t.onscreenSelectionCanvas)})):this.hideAreaLayer(e,t)})).finally((()=>{this.hideAreaLoading(e)}))},i.prototype.onChangeIntervalsStyle=function(e,s,a){e.getVisibleBands().forEach((e=>{const{graph:n}=e,i=this._drawers[s.type].filterLayer(n,s,a);if(i){const e=[i.layerUpdateDrawer],a=[];let r,o,c;this._utils.getSelectionDrawers(n,n.savedLayerData.get(s.index),a);s.type.split(t.layerTypes.DELIMITER).includes(t.layerTypes.HIERARCHICAL_INTERVALS)?(r=n.onscreenHierarchCanvas,o=n.offscreenHierarchCanvas,c=n.onscreenHierarchSelectionCanvas):(r=n.onscreenCanvas,o=n.offscreenCanvas,c=n.onscreenSelectionCanvas,1!==n.commonLayersCount&&n.savedLayerData.forEach((t=>{t.visible&&!t.hierarchical&&t.layerIndex!==s.index&&(e.push(t.restoreLayer(n)),this._utils.getSelectionDrawers(n,t,a))}))),i.layerUpdate&&e.length&&(r.getContext("2d").clearRect(0,0,r.width,r.height),this._utils.processDataArray(e,!0),this._utils.moveImageToOnscreenCanvas(o,r)),i.selectionUpdate&&a.length&&c&&(c.getContext("2d").clearRect(0,0,c.width,c.height),this._utils.processDataArray(a,!0))}}))},i.prototype.highlightHoveredObjects=function(e,s,a,n,i,r){if(this._lastHighlightedItems){if(this.clearLastHighlightedObjects(),s&&s.length){const a=e.onscreenHighlightCanvas||e.children[1];let o=!0;s.forEach((s=>{const c=s.type.split(t.layerTypes.DELIMITER);if(!c.includes(t.layerTypes.OVERTIME_LAYER)){if(o=!1,c.includes(t.layerTypes.GLOBAL_CROSS_LINE))return;if(c.includes(t.layerTypes.TRANSITION_LAYER)){const{onscreenTransitionsHighlightCanvas:e}=r.scrolled.graph;this._lastHighlightedItems.highlightTransitionsCanvas=e,this._transitionLayerDrawer.highlightElements(e,s.intervals,i,r)}e.isRulerGraph&&c.includes(t.layerTypes.FRAME_LAYER)&&this._ruler.addLinesToHighlightedRulerFrame(this._utils.convertHighlightFrameDataToGlobalXLines(s)),c.includes(t.layerTypes.HIERARCHICAL_INTERVALS)?this._drawers[t.layerTypes.HIERARCHICAL_INTERVALS].highlightElements(a,s.intervals,void 0,e.children[0],n):c.includes(t.layerTypes.TRANSITION_LAYER)||this._drawers[c[0]].highlightElements(a,s.intervals)}})),o||(this._lastHighlightedItems.highlightCanvas=a)}a&&a.length&&a.forEach((e=>{this._ruler.highlightGlobalCrossLineLayerData(e)}))}},i.prototype.clearLastHighlightedObjects=function(){if(!this._lastHighlightedItems)return;const e=this._lastHighlightedItems.highlightCanvas;e&&e.getContext("2d").clearRect(0,0,e.width,e.height);const t=this._lastHighlightedItems.highlightTransitionsCanvas;t&&t.getContext("2d").clearRect(0,0,t.width,t.height),this._ruler.clearHighlightedGlobalCrossLines(),this._lastHighlightedItems={}},i.prototype.selectObjects=function(e,t,s){if(e.highlight){const a=e.highlight.layers;a&&a.length&&(this._highlightSelectedObjects(a,t,s),this._utils.areaHolder.hasSelectedItems=!0)}if(e.correlation){const a=e.correlation.layers;a&&a.length&&(this._highlightSelectedObjects(a,t,s),this._utils.areaHolder.hasSelectedItems=!0)}if(e.selection){const a=e.selection.layers;if(a&&a.length){const n=e.selection.bandId;this._highlightSelectedObjects(a.map((e=>({index:e.index,bands:[{id:n,intervals:e.intervals}],type:e.type,isSelection:!0}))),t,s),this._utils.areaHolder.hasSelectedItems=!0}}},i.prototype.clearLastSelectedObjects=function(){const{areaHolder:e}=this._utils;e.hasSelectedItems&&(e.areas.forEach((e=>{this.clearLastSelectedObjectsFromArea(e)})),e.hasSelectedItems=!1),this._ruler.clearLastSelectedObjects()},i.prototype.clearLastSelectedObjectsFromArea=function(e,t,s,a){const n=t&&t.length?t:e.getVisibleBands();n.length&&n.forEach((e=>{this.clearLastSelectedObjectsFromBand(e,s)})),a||this.clearLastSelectedTransitions(e,s)},i.prototype.clearLastSelectedObjectsFromBand=function(e,t){if(!e)return;const{graph:s}=e;if(s&&s.savedLayerData&&s.savedLayerData.size){t||s.savedLayerData.forEach((e=>{e.selectionData&&e.selectionData.length&&(e.selectionData=[])}));const{onscreenSelectionCanvas:e}=s;e&&e.getContext("2d").clearRect(0,0,e.width,e.height);const{onscreenHierarchSelectionCanvas:a}=s;a&&a.getContext("2d").clearRect(0,0,a.width,a.height)}},i.prototype.clearLastSelectedTransitions=function(e,t){if(!e)return;const s=e.scrolled.graph;if(s){s.savedLayerData.size&&!t&&s.savedLayerData.forEach((e=>{e.selectionData.length&&(e.selectionData=[])}));const{onscreenTransitionsSelectionCanvas:e}=s;e.getContext("2d").clearRect(0,0,e.width,e.height)}},i.prototype.drawTransitionsGraph=function(e,s){if(s.bands&&s.bands.length&&(s.bands.length>1||s.bands[0].hasChildren)){let a=0;if(e.layers.forEach((function(e){e.type.split(t.layerTypes.DELIMITER).includes(t.layerTypes.TRANSITION_LAYER)&&a++})),a>0){const t=document.createElement("canvas"),n=document.createElement("canvas"),i=document.createElement("canvas");t.className="idvc_canvas transitions_canvas",n.className="idvc_canvas transitions_canvas highlight_canvas",i.className="idvc_canvas transitions_canvas selection_canvas";const r=document.createElement("canvas");t.width=t.height=n.width=n.height=i.width=i.height=0,t.initialized=!1;const o=e.scrolled;o.appendChild(t),o.appendChild(n),o.appendChild(i),o.graph={onscreenTransitionsCanvas:t,offscreenTransitionsCanvas:r,onscreenTransitionsHighlightCanvas:n,onscreenTransitionsSelectionCanvas:i,savedLayerData:new Map,parentArea:e,parentAreaLookup:s,transitionLayersCount:a}}}},i.prototype.initTransitionsGraph=function(e){if(!e)return;const{graph:t}=e.scrolled;if(t){const{onscreenTransitionsCanvas:s}=t;if(!s.initialized){const{offscreenTransitionsCanvas:a}=t,{onscreenTransitionsHighlightCanvas:n}=t,{onscreenTransitionsSelectionCanvas:i}=t,r=this._utils.getTimeBins(),o=Math.ceil(e.bandHolder.clientHeight);s.width=a.width=n.width=i.width=r,s.height=a.height=n.height=i.height=o,this._utils.setPxStyles({height:o,width:r,left:e.captionPadding.style.width},s,n,i);const c=this._utils;t.scrollEventListener=function(){c.setPxStyles({top:-this.scrollTop},s,n,i)},e.scrolled.addEventListener("scroll",t.scrollEventListener),s.initialized=!0}}},i.prototype.removeTransitionsGraph=function(e){if(!e)return;const t=e.scrolled,s=t.graph;if(s){const{onscreenTransitionsCanvas:e}=s;e&&(t.removeEventListener("scroll",s.scrollEventListener),t.removeChild(e),t.removeChild(s.onscreenTransitionsHighlightCanvas),t.removeChild(s.onscreenTransitionsSelectionCanvas),delete t.graph)}},i.prototype.refreshTransitionsGraph=function(e){if(!e)return;const t=e.scrolled.graph;if(t){const{onscreenTransitionsCanvas:s}=t;if(s){const{onscreenTransitionsHighlightCanvas:a}=t,{onscreenTransitionsSelectionCanvas:n}=t;s.getContext("2d").clearRect(0,0,s.width,s.height),a.getContext("2d").clearRect(0,0,a.width,a.height),n.getContext("2d").clearRect(0,0,n.width,n.height);const i=Math.ceil(e.bandHolder.clientHeight);i!==s.height&&(s.height=a.height=n.height=t.offscreenTransitionsCanvas.height=i,this._utils.setPxStyles({height:i},s,a,n));const r=t.savedLayerData;if(r.size){const e=[],a=[];r.forEach((s=>{s.visible&&(e.push(s.restoreLayer(t,!0)),this._utils.getSelectionDrawers(t,s,a,!0))})),e.length&&(this._utils.processDataArray(e,!0),this._utils.moveImageToOnscreenCanvas(t.offscreenTransitionsCanvas,s)),a.length&&this._utils.processDataArray(a,!0)}}}},i.prototype.drawTransitionsLayer=function(e,t,s,a){return t.scrolled.graph.savedLayerData.delete(a.index),this._transitionLayerDrawer.drawLayer(e,t,s,a)},i.prototype.detectTransitionHit=function(e,t,s,a){return this._transitionLayerDrawer.detectTransitionHit(e,t,s,a)},i.prototype.processScroll=function(e,t){let s=[];this.clearLastSelectedObjectsFromArea(t,e,!0),e.forEach((e=>{if(!e)return;const{graph:t}=e;if(!t)return;const a=t.onscreenCanvas;if(!a)return;a.getContext("2d").clearRect(0,0,a.width,a.height);const{onscreenHierarchCanvas:n}=t;n&&n.getContext("2d").clearRect(0,0,n.width,n.height),s=this._utils.getGraphScrollers(t),s.scrollers.length&&(this._utils.processDataArray(s.scrollers,!0),this._utils.moveImageToOnscreenCanvas(t.offscreenCanvas,t.onscreenCanvas),n&&n.isDisplayed&&this._utils.moveImageToOnscreenCanvas(t.offscreenHierarchCanvas,n)),s.selectionScrollers.length&&this._utils.processDataArray(s.selectionScrollers,!0)}));const a=t.scrolled.graph;if(a){const{onscreenTransitionsCanvas:e}=a;e.getContext("2d").clearRect(0,0,e.width,e.height),s=this._utils.getGraphScrollers(a),s.scrollers.length&&(this._utils.processDataArray(s.scrollers,!0),this._utils.moveImageToOnscreenCanvas(a.offscreenTransitionsCanvas,e)),s.selectionScrollers.length&&this._utils.processDataArray(s.selectionScrollers,!0)}},i.prototype.processResize=function(e,t){const s=e.length,a=this._utils.getTimeBins();for(let t=0;t<s;t++){const{graph:s}=e[t],{onscreenCanvas:n}=s;if(n){const{offscreenCanvas:e}=s,{onscreenHighlightCanvas:t}=s,{onscreenSelectionCanvas:i}=s;this._utils.setAttributes({width:a},n,e,t,i),this._utils.setPxStyles({width:a},n,t,i)}const{onscreenHierarchCanvas:i}=s;if(i){const{offscreenHierarchCanvas:e}=s,{onscreenHierarchHighlightCanvas:t}=s,{onscreenHierarchSelectionCanvas:n}=s;i.width=e.width=t.width=n.width=a,this._utils.setPxStyles({width:a},i,t,n)}}const n=t.scrolled.graph;if(n){const{onscreenTransitionsCanvas:e}=n,{offscreenTransitionsCanvas:s}=n,{onscreenTransitionsHighlightCanvas:i}=n,{onscreenTransitionsSelectionCanvas:r}=n;e.width=s.width=i.width=r.width=a,this._utils.setPxStyles({width:a,left:t.captionPadding.style.width},e,i,r)}this._refreshAreaLoadingOffset(t)},i.prototype.processHeightResize=function(e,s){let a=e.getClientHeight();const{graph:n}=e;n.bandCaptionAxis&&n.bandCaptionAxis.processHeightResize(a);const{onscreenCanvas:i}=n;let r,o,c;if(i){r=Math.ceil(a);const{offscreenCanvas:l}=n,{onscreenHighlightCanvas:h}=n,{onscreenSelectionCanvas:d}=n;({onscreenHierarchCanvas:o}=n);const{onscreenHierarchSelectionCanvas:g}=n;if(o){if(o.isDisplayed){const t=e.getInfo("currentModeDefHeight"),s=o.height,n=a<(o.singleMode?s:t+s);c=n!==o.tightMode,a-=s+1,a<t&&(a=t),c&&(o.getContext("2d").clearRect(0,0,o.width,s),g.getContext("2d").clearRect(0,0,g.width,g.height),o.tightMode=n,e.setInfo(n,"tightMode"))}r=Math.ceil(a),i.parentNode&&(i.parentNode.style.height=r+"px")}e.setInfo(a,"commonContainerHeight"),i.getContext("2d").clearRect(0,0,i.width,i.height),this._utils.setAttributes({height:r},i,l,h,d),this._utils.setPxStyles({height:r},i,h,d),e.getInfo("currentBandMode")===t.displayModes.SUPER_TINY&&(clearTimeout(s.superTinyUpdateTimeout),s.superTinyUpdateTimeout=setTimeout((()=>s.updateVisibleBands()),100))}const{savedLayerData:l}=n,h=[],d=[];l.size&&(l.forEach((e=>{e.visible&&(e.hierarchical?c&&(h.push(e.processHeightResize(n)),this._utils.getSelectionDrawers(n,e,d)):(h.push(e.processHeightResize(n,r)),this._utils.getSelectionDrawers(n,e,d)))})),h.length&&(this._utils.processDataArray(h,!0),this._utils.moveImageToOnscreenCanvas(n.offscreenCanvas,i),c&&this._utils.moveImageToOnscreenCanvas(n.offscreenHierarchCanvas,o)),d.length&&this._utils.processDataArray(d,!0));const g=s.scrolled.graph;if(g){const{onscreenTransitionsCanvas:e}=g,{offscreenTransitionsCanvas:t}=g,{onscreenTransitionsHighlightCanvas:a}=g,{onscreenTransitionsSelectionCanvas:n}=g,i=Math.ceil(s.bandHolder.clientHeight);e.height=t.height=a.height=n.height=i,this._utils.setPxStyles({height:i},e,a,n);const r=g.savedLayerData;r.size&&(r.forEach((e=>{e.visible&&(h.push(e.processHeightResize(g)),this._utils.getSelectionDrawers(g,e,d))})),h.length&&(this._utils.processDataArray(h,!0),this._utils.moveImageToOnscreenCanvas(g.offscreenTransitionsCanvas,e)),d.length&&this._utils.processDataArray(d,!0)),g.wasResized=!0}n.wasResized=!0},i.prototype.showAreaLoading=function(e){if(e.scrolled){const t=n.select(e.scrolled);let s=t.select("div.area_loading");s.size()?s.style("display","inline-flex"):(s=t.append("div").style("left",e.captionPadding.style.width).classed("area_loading",!0),s.append("div").classed("area_loading spinner",!0),s.node().insertAdjacentHTML("beforeend","Loading...")),s.select("div.area_loading.spinner").classed("optimize",!0)}},i.prototype.hideAreaLoading=function(e,t){if((!t||!e.reqId||t===e.reqId)&&(delete e.reqId,e.scrolled)){const t=n.select(e.scrolled).select("div.area_loading");t.size()&&(t.style("display","none"),t.select("div.area_loading.spinner").classed("optimize",!1))}},i.prototype.setCanvasElementsFontStyle=function(){this._drawers[t.layerTypes.INTERVAL_LAYER].setIntervalTextFontStyle(t.intervalTextFontStyle),this._drawers[t.layerTypes.HIERARCHICAL_INTERVALS].setIntervalTextFontStyle(t.intervalTextFontStyle),this._pauseLayerDrawer.setPauseTextFontStyle(t.pauseTextFontStyle)},{create:(e,t,s,a,n,r,o,c,l,h,d)=>new i(e,t,s,a,n,r,o,c,l,h,d)}}]);
"use strict";angular.module("timelinepane").factory("ZoomPanel",(function(){const t=window.d3_main||window.d3;function o(){this._cornerElement=void 0,this._zoomManager=void 0,this._rate=1.5,this._zoomInButton=void 0,this._zoomOutButton=void 0,this._zoomUndoButton=void 0,this._zoomResetButton=void 0,this._drawButton=(t,o,e,n)=>{const s=this._cornerElement.append("div").classed("zoom_button"+(e?" disabled":""),!0);return s.append("span").classed("icon "+t,!0).on("click",o).attr("title",n),s},this._drawZoomPanelLabel=()=>{this._cornerElement.append("div").classed("zoom_label",!0).append("span").classed("icon magnifier-o",!0)},this._setButtonsState=t=>{e(this._zoomInButton,t.set),e(this._zoomOutButton,!t.wholeView),e(this._zoomUndoButton,t.undo),e(this._zoomResetButton,t.cancel)},this._resetZoom=()=>{this._zoomManager.cancelZoom(),this._setButtonsState(this.getZoomState())},this._undoZoom=()=>{this._zoomManager.undoZoom(),this._setButtonsState(this.getZoomState())},this._zoomIn=()=>{this._zoomManager.setZoom(this._rate),this._setButtonsState(this.getZoomState())},this._zoomOut=()=>{this._zoomManager.setZoom(1/this._rate),this._setButtonsState(this.getZoomState())}}function e(t,o){t.classed("disabled",!o)}return o.prototype.getZoomState=function(){return this._zoomManager.getZoomState(this._rate)},o.prototype.initZoomButtonPanel=function(o,e,n){this._cornerElement=t.select(o),this._zoomManager=e.zoomManager,this._drawZoomPanelLabel(),this._zoomInButton=this._drawButton("plus-o",this._zoomIn,!1,n.zoomInButtonTooltip),this._zoomOutButton=this._drawButton("minus-o",this._zoomOut,!0,n.zoomOutButtonTooltip),this._zoomUndoButton=this._drawButton("zoom-undo",this._undoZoom,!0,n.zoomUndoButtonTooltip),this._zoomResetButton=this._drawButton("zoom-reset",this._resetZoom,!0,n.zoomResetButtonTooltip)},o.prototype.onScroll=function(){this._setButtonsState(this.getZoomState())},o.prototype.resetZoom=function(){return this._resetZoom()},o.prototype.undoZoom=function(){return this._undoZoom()},o.prototype.zoomIn=function(){return this._zoomIn()},o.prototype.zoomOut=function(){return this._zoomOut()},{create:()=>new o}}));
"use strict";angular.module("timelinepane").factory("fullContextMenu",["uiSession","localize","jqueryCtxMenu",function(e,n,t){return function(o,i){let l=[];const a={getItems:()=>{const e={};if(o.contextMenuOptions.isBandCaption()||(e.zoomIn={name:l["%ZoomInOnSelectionLabel"],disabled:()=>!(o.contextMenuOptions.isTimeRange()||o.contextMenuOptions.isRulerFrame()),click:o.contextMenuOptions.zoomInOnSelection},e.zoomUndo={name:l["%ZoomUndoLabel"],disabled:()=>!o.contextMenuOptions.isZoomUndoAvailable(),click:o.contextMenuOptions.undoZoom},e.zoomReset={name:l["%ZoomResetLabel"],disabled:()=>!o.contextMenuOptions.isZoomResetAvailable(),click:o.contextMenuOptions.resetZoom},e.fullTimelineCtxMenuSeparator1={type:"cm_separator"},e.zoomInAndFilter={name:l["%ZoomInAndFilterInBySelectionLabel"],disabled:()=>!(o.contextMenuOptions.isRulerFrame()||o.contextMenuOptions.isTimeRange()),click:o.contextMenuOptions.zoomInAndFilterInBySelection}),e.filterIn={name:l["%FilterInBySelectionLabel"],disabled:()=>!o.contextMenuOptions.isFilterInAvailable(),click:()=>o.contextMenuOptions.filterBySelection(!0)},e.filterOut={name:l["%FilterOutBySelectionLabel"],disabled:()=>!o.contextMenuOptions.isFilterInAvailable(),click:()=>o.contextMenuOptions.filterBySelection(!1)},e.removeAllFilters={name:l["%RemoveAllFiltersLabel"],disabled:()=>o.isFilterEmpty,click:o.contextMenuOptions.removeAllFilters},(o.contextMenuOptions.isBandCaption()||o.contextMenuOptions.isArea())&&(e.fullTimelineCtxMenuSeparator2={type:"cm_separator"}),o.contextMenuOptions.shouldShowBandModes()){const n=o.contextMenuOptions.getAreaBandModes();if(n&&n.length){const t=o.contextMenuOptions.getAreaSelectedBandModeId();e.bandModes={name:l["%BandModeLabel"],items:Object.assign({},...n.map(((e,n)=>({["bandMode"+n]:{checked:e.id===t,name:e.name,click:()=>o.contextMenuOptions.changeBandMode(e)}}))))}}}if(o.contextMenuOptions.shouldShowSortBy()){e.sortBy={name:l["%SortByLabel"],items:{}};const n=o.contextMenuOptions.getAreaSortInfos();if(n&&n.length){const t=o.contextMenuOptions.getAreaSelectedSortId();Object.assign(e.sortBy.items,...n.map(((e,n)=>({["sorting"+n]:{checked:e.id===t,name:e.name,click:()=>o.contextMenuOptions.changeSorting(e)}})))),e.sortBy.items.fullTimelineCtxMenuSortByMenuSeparator={type:"cm_separator"},e.sortBy.items.setAscendingOrder={checked:o.contextMenuOptions.getSortOrder(),name:l["%AscendingLabel"],click:()=>o.contextMenuOptions.setSortOrder(!0)},e.sortBy.items.setDescendingOrder={checked:!o.contextMenuOptions.getSortOrder(),name:l["%DescendingLabel"],click:()=>o.contextMenuOptions.setSortOrder(!1)}}}const n=o.contextMenuOptions.timeScale;if(n&&n.length){const t=o.contextMenuOptions.selectedTimeScale.name;e.setTimeScale={name:l["%TimeScaleLabel"],items:Object.assign({},...n.map(((e,n)=>({["timeScale"+n]:{checked:e.name===t,name:e.name,click:()=>o.contextMenuOptions.changeTimeScale(e)}}))))}}return e.fullTimelineCtxMenuSeparator3={type:"cm_separator"},e.expandTopX={disabled:()=>!o.contextMenuOptions.isExpandTopXAvailable(),name:l["%ExpandTopLabel"],click:()=>o.contextMenuOptions.expandTopX()},e.expandAll={disabled:()=>!o.contextMenuOptions.isExpandAllAvailable(),name:l["%ExpandAllLabel"],click:()=>o.contextMenuOptions.expandAll()},e.expandOneMore={disabled:()=>!o.contextMenuOptions.isExpandOneMoreAvailable(),name:l["%MoveChildFromOthersLabel"],click:()=>o.contextMenuOptions.expandOneMore()},e.fullTimelineCtxMenuSeparator4={type:"cm_separator"},e.collapseToOthers={disabled:()=>!o.contextMenuOptions.canCollapseToOthers(),name:l["%MoveAllBelowToOthersLabel"],click:()=>o.contextMenuOptions.collapseToOthers()},e.fullTimelineCtxMenuSeparator5={type:"cm_separator"},e.dismiss={name:l["%DismissMenuLabel"],click:o.contextMenuOptions.dismissMenu},e}};return e.getPartitionSocket(o).then((()=>{n(["%ZoomInOnSelectionLabel","%ZoomUndoLabel","%ZoomResetLabel","%ZoomInAndFilterInBySelectionLabel","%FilterInBySelectionLabel","%FilterOutBySelectionLabel","%RemoveAllFiltersLabel","%BandModeLabel","%SortByLabel","%AscendingLabel","%ExpandAllLabel","%ExpandTopLabel","%MoveChildFromOthersLabel","%MoveAllBelowToOthersLabel","%DescendingLabel","%TimeScaleLabel","%DismissMenuLabel"],"viewpoint").then((e=>{l=e,t($(i),a)}))})),a}}]);
"use strict";angular.module("timelinepane").factory("shortContextMenu",["uiSession","localize","jqueryCtxMenu",function(e,n,t){return function(i,o){let l=[];const c={trigger:"none",getItems:()=>({zoomIn:{name:l["%ZoomInOnSelectionLabel"],click:i.contextMenuOptions.zoomInOnSelection},shortTimelineCtxMenuSeparator1:{type:"cm_separator"},filterIn:{name:l["%FilterInBySelectionLabel"],click:()=>i.contextMenuOptions.filterBySelection(!0)},filterOut:{name:l["%FilterOutBySelectionLabel"],click:()=>i.contextMenuOptions.filterBySelection(!1)},zoomInAndFilter:{name:l["%ZoomInAndFilterInBySelectionLabel"],click:i.contextMenuOptions.zoomInAndFilterInBySelection},shortTimelineCtxMenuSeparator2:{type:"cm_separator"},dismiss:{name:l["%DismissMenuLabel"],click:i.contextMenuOptions.dismissMenu}})};return e.getPartitionSocket(i).then((()=>{n(["%ZoomInOnSelectionLabel","%FilterInBySelectionLabel","%FilterOutBySelectionLabel","%ZoomInAndFilterInBySelectionLabel","%DismissMenuLabel"],"viewpoint").then((e=>{l=e,t(o,c)}))})),c}}]);
"use strict";angular.module("timelinepane").directive("timelinePaneTestHarnessDump",["$timeout","$q","$interval","dumpHelper","dumpDispatcher",function(e,n,t,i,a){return{restrict:"E",scope:{paneId:"=",results:"=",dumpApi:"="},link:function(r){const{paneId:o}=r,c="expand-all-bands",d="expand-band",s="show-top-bands",l="collapse-to-others",u="show-more_band",p=100;function m(){return n((t=>{const a=$(".idvc_timeline_ctrl_area_holder .idvc_timeline_ctrl_area").get();let r=0;const m=[];function f(){a[0]?function(t,a){(function(e){let n=0,t=e.previousSibling;for(;t;)n+=t.offsetHeight,t=t.previousSibling;e.parentElement.scrollTop=n})(a),e((()=>{(function(e,t){let a=$($(t).find(".idvc_timeline_ctrl_caption .idvc_timeline_ctrl_caption_text")[0]).text();a||(a=$($(t).find(".idvc_timeline_ctrl_band_caption")[0]).text());return function(e,t){const a=n.defer(),r=h(t);r.setTopBand(0);const c=r.getBandCount(),m=[];return setTimeout((()=>{f(0)}),p),a.promise;function f(e){const n=r.getVisibleBands();return x(n).then((()=>{const t=n[0].getIndex(),i=n[n.length-1].getIndex();if(i===c-1||e>=c-1&&0!==e){const i=e-t,r=n.length;for(let e=i;e<r;++e)m.push(_(n[e],e));a.resolve(m)}else n.forEach((function(n,t){n.getIndex()>=e&&m.push(_(n,t))})),e=i+1,r.setTopBand(e),setTimeout((()=>{f(e)}),p)}))}function _(n,t){const a=$(n.caption).find(".idvcgrid_widget"),r=!$(a).hasClass("idvcgrid_empty"),c={caption:$(n.caption).text(),index:n.getIndex(),hasChildren:r,actions:{collapseToOthers:{href:i.generateActionURL(l,o)+"&areaIndex="+e+"&bandIndex="+t}}};return r&&(c.expanded=$(a).hasClass("idvcgrid_expanded"),c.actions.showTop={href:i.generateActionURL(s,o)+"&areaIndex="+e+"&bandIndex="+t},c.actions.showMore={href:i.generateActionURL(u,o)+"&areaIndex="+e+"&bandIndex="+t},c.actions.expandBand={href:i.generateActionURL(d,o)+"&areaIndex="+e+"&bandIndex="+t}),c}function x(e){const t=n.defer();return g("visible bands to load",t,100,(()=>!e.some((e=>0===$(e.caption).text().indexOf("Loading..."))))),t.promise}}(e,t).then((function(n){return{caption:a,visible:!$(this).hasClass("hidden"),index:e,bands:n,actions:{expandAllBands:{href:i.generateActionURL(c,o)+"&areaIndex="+e}}}}))})(t,a).then((e=>m.push(e))).then(f)}))}(r++,a.shift()):t(m)}f()}))}function f(){return $(".timeline-legend .legend-block").map((function(e){const n={},[t]=$(this).find(".area-input");t&&(n.checked=t.checked);let[a]=$(this).find(".select-grouping");return a?n.groupings=function(e,n){const t=i.generateActionURL("select-grouping",o)+"&areaIndex="+e;return $(n).find("select option").map((function(e){const i=$(n).find("select").val();return{index:e,value:$(this).text(),selected:$(this).val()===i,select:{href:t+"&option="+e}}})).get()}(e,a):(a=$(this).find(".area")[0],n.caption=$($(a).find(".caption")[0]).text()),n.layers=$(this).find(".legend-item").map((function(){const e={caption:$($(this).find("label")[0]).text()},[n]=$(this).find("input");return n&&(e.checked=n.checked),e})).get(),n})).get()}function h(e){return e.idvcTimelineArea}function g(n,i,a,r){const o=t((()=>{r()&&(i.resolve(),t.cancel(o),e.cancel(c))}),a),c=e((function(){t.cancel(o),i.reject("Timeout on waiting for "+n)}),6e4)}a.addDumpListener({paneId:o,$scope:r},(async function(e){try{await function(){const e=n.defer();return g("loading to complete",e,500,(()=>!$(".icon").hasClass("loading"))),e.promise}();const t={paneId:o,result:r.results};if("layerData"===e.type){const n=Number(e.areaIndex),i=Number(e.bandIndex),a=Number(e.layerIndex),o=String(e.bandName),c=h($(".idvc_timeline_ctrl_area_holder .idvc_timeline_ctrl_area")[n]),d=i>0?i-1:i;c.setTopBand(d),t.dump=r.dumpApi.getLayerInfoForBand(n,a,o)}else t.dump=await async function(){return{areas:await m(),legend:f()}}();return t}catch(e){return{paneId:o,result:r.results,dump:{message:e.message||e,stack:e.stack}}}})),a.addActionListener({paneId:o,$scope:r},(async function(n){try{if("select-grouping"===n.type){const t=Number(n.areaIndex),a=Number(n.option),[r]=$($(".timeline-legend .legend-block")[t]).find(".select-grouping"),o=$(r).children("select");return e((()=>i.chooseOptionFromNativeSelector(o,a)))}if(n.type!==c){const t=function(e){return e===s?r.dumpApi.showTop:e===d?r.dumpApi.expandBand:e===l?r.dumpApi.collapseToOthers:e===u?r.dumpApi.showMore:void 0}(n.type),a=Number(n.areaIndex),o=Number(n.bandIndex),c=$(".idvc_timeline_ctrl_area_holder .idvc_timeline_ctrl_area")[a];return h(c).setTopBand(0),e((()=>{const n=$(c).find(".idvc_timeline_ctrl_band")[o],[r]=$(n).find(".idvc_timeline_ctrl_band_caption");return i.dispatchElementMouseEvent("mousedown",r).then(i.dispatchElementMouseEvent("mouseup",r)).then(e(t(a,n),100))}),100)}r.dumpApi.expandAllBands(Number(n.areaIndex))}catch(e){return{paneId:o,error:e.message||e}}}))}}}]);
"use strict";angular.module("timelinepane").controller("TimelineLegendController",["$scope","constants",function(e,s){e.showHideArea=function(e){e.shown?e.areaObj.show():e.areaObj.hide()},e.shouldShowLayerIcon=function(e){if(!e.styles)return;return!e.styles.filter((e=>e.name)).length||!e.stylesLegend&&!e.showSingleSeries},e.shouldShowLayerStyles=function(e){if(!e.styles)return;return e.styles.filter((e=>e.name)).length&&(!0===e.stylesLegend||void 0!==e.showSingleSeries)},e.canSelectStyle=function(e){return!0===e.allowToHideStyles&&e.styles.length>1},e.showSingleStyle=function(s,t){const l=t.selectedStyle.name;t.styles.forEach((e=>{e.visible=e.name===l})),e.showHideStyle(s,t,t.selectedStyle)},e.getImageForLayer=function(e,t,l){const n=e.type.split(s.layerTypes.DELIMITER);return n.includes(s.layerTypes.INTERVAL_LAYER)||n.includes(s.layerTypes.HIERARCHICAL_INTERVALS)?t&&t.hatchStyle?"assets/"+t.hatchStyle+".png":"assets/interval.png":n.includes(s.layerTypes.FRAME_LAYER)||n.includes(s.layerTypes.GLOBAL_CROSS_LINE)?"assets/frame.png":n.includes(s.layerTypes.EVENT_MARKER_LAYER)||n.includes(s.layerTypes.GLOBAL_MARKER_LAYER)?"assets/sample.png":n.includes(s.layerTypes.TRANSITION_LAYER)?"assets/transitions.png":n.includes(s.layerTypes.OVERTIME_LAYER)?l===s.displayModes.SUPER_TINY?"assets/interval.png":e.displayFormat===s.chartFormats.DEFAULT?"assets/dataovertime.png":e.displayFormat===s.chartFormats.HEAT_MAP_CHART?"assets/interval.png":e.displayFormat===s.chartFormats.SCATTER_PLOT?"assets/dots.png":"assets/dataovertime_line.png":"assets/interval.png"},e.getImageStyle=function(t,l,n){const a=l?l.color:t.color;if(t.type===s.layerTypes.OVERTIME_LAYER&&t.displayFormat===s.chartFormats.HEAT_MAP_CHART||n===s.displayModes.SUPER_TINY)return{background:"linear-gradient(to bottom, "+e.timelineUtils.toRgba(a)+", black)"};if(t.type===s.layerTypes.RUNNING_LAYER)return{"background-color":e.timelineUtils.toRgba(a)};const r=t.type.split(s.layerTypes.DELIMITER);return t.stylization&&!t.stylesLegend&&(r.includes(s.layerTypes.HIERARCHICAL_INTERVALS)||r.includes(s.layerTypes.INTERVAL_LAYER)||r.includes(s.layerTypes.FRAME_LAYER))?{}:{"background-color":e.timelineUtils.toRgba(a)}},e.getAreas=function(){return Object.keys(e.areas).map((s=>e.areas[s]))}}]);
"use strict";angular.module("timelinepane").directive("timelineLegend",(function(){return{restrict:"E",replace:!0,template:'<div class="timeline-legend" localize="localize" default-msg-catalog="viewpoint"><div class="ruler-area" ng-if="::(rulerLayers.length)"><label class="caption">{{::localize(\'%RulerAreaLegendLabel\')}}</label><div class="legend-item" ng-repeat="layer in rulerLayers"><input type="checkbox" ng-model="layer.visible" ng-change="showHideRulerLayer(layer)"> <img class="color-legend" ng-src="{{::getImageForLayer(layer)}}" ng-style="::getImageStyle(layer)"> <label>{{::layer.name}}</label></div></div><div class="areas"><div class="legend-block" ng-repeat="area in ::getAreas() | orderBy: \'index\'"><div class="area" ng-if="::(!area.groupings || area.groupings.length == 1)" overflow-ellipsis="onResize"><input class="area-input" type="checkbox" ng-model="area.shown" ng-change="showHideArea(area)"> <label class="caption">{{::area.name}}</label></div><div class="select-grouping" ng-if="::(area.groupings && area.groupings.length > 1)" data-tour-item="timelineLegendGroupTourItem"><input class="area-input" type="checkbox" ng-model="area.shown" ng-change="showHideArea(area)"> <select ng-model="area.selectedGrouping" ng-options="grouping as grouping.name for grouping in area.groupings" ng-disabled="!area.shown" ng-change="changeGrouping(area, area.index)"></select></div><div class="legend-item" ng-if="area.shown && area.count > 0" ng-repeat="layer in area.layers"><div overflow-ellipsis="onResize"><input type="checkbox" ng-model="layer.visible" ng-if="::(area.layers.length > 1)" ng-change="showHideAreaLayer(area, layer)"><img class="color-legend" ng-if="::(shouldShowLayerIcon(layer))" ng-src="{{::getImageForLayer(layer, undefined, area.bandMode.selectedBandModeId)}}" ng-style="::getImageStyle(layer, undefined, area.bandMode.selectedBandModeId)"> <label>{{::layer.name}}</label></div><div class="styles" ng-if="::(shouldShowLayerStyles(layer))" ng-show="layer.visible"><div class="style" ng-if="::(style.name.length && !layer.showSingleSeries)" ng-repeat="style in layer.styles" overflow-ellipsis="onResize"><input type="checkbox" ng-if="::canSelectStyle(layer)" ng-model="style.visible" ng-change="showHideStyle(area, layer, style)"> <img class="color-legend" ng-if="::(shouldShowLayerStyles(layer))" ng-src="{{::getImageForLayer(layer, style)}}" ng-style="::getImageStyle(layer, style)"> <label>{{::style.name}}</label></div><div class="style select" ng-if="::(layer.showSingleSeries)" overflow-ellipsis="onResize"><img class="color-legend" ng-if="::(shouldShowLayerStyles(layer))" ng-src="{{::getImageForLayer(layer, style)}}" ng-style="::getImageStyle(layer, style)"> <select ng-model="layer.selectedStyle" ng-options="style as style.name for style in layer.styles" ng-change="showSingleStyle(area, layer)"></select></div></div></div></div></div></div>',controller:"TimelineLegendController"}}));
"use strict";angular.module("timelinepane").controller("TimelineController",["$scope","$http","$q","uiSession","error","requestIdentity","constants","$compile",function(e,t,n,i,r,a,o,s){const u=n.defer();let l;e.externalInitializationComplete=n.defer();const d=this;let c,p,f,m=!0,g=[];const h=e.$watch("configuration",(i=>{function s(){const{areas:t}=e.configuration;return t?n.all(t.map(c)):n.reject("Areas config not found.")}function c(e,n){const i=e;return i.areaIndex=n,t.post("api/timelineview/create",i,{params:v(),timeout:u.promise})}function p(e){d.refreshMetadata({areas:e.map((e=>e.data||{})).filter((function(e){return e.layers&&e.layers.length>0&&!function(e){return e.layers&&1===e.layers.length&&e.layers[0].type===o.layerTypes.RUNNING_LAYER}(e)})).map((e=>(b(e),x(e),e))),start:0,end:e.reduce((function(e,t){const n=t.data||{};return n.duration>e?n.duration:e}),0)}),h()}function f(){return t.post("api/timelineview/ruler/create",{},{params:v(),timeout:u.promise})}function m(e){const{data:t}=e;if(t&&!t.error)return d.fillRuler(t)}function g(){return t.get("api/filter",{params:{identity:a.get(e),name:"global"}})}function y(t){e.isFilterEmpty=t.data.isEmpty}i&&(l=i.timelineId,e.externalInitializationComplete.promise.then((()=>{e.loading.start().then(s).then(p).then(f).then(m).then(g).then(y).catch(r.handle(e)).finally(e.loading.stop)})))}));function y(n){if(e.isFilterEmpty=n.filter.isEmpty,e.isFilterEmpty&&d.clearTimelineFiltering(),n.timeFilterChanged){if(e.timelinePane.timelineUtils.isTimeRangePendingProcessing())d.updateZoomAfterFiltering();else if(n.timeFilterChanged&&!p)d.refreshGlobalRulerData();else if(n.timeFilterChanged){const t=e.contextMenuOptions.target.type,n=e.contextMenuOptions.target.object;!n||t!==o.contextMenuTargetTypes.TIME_RANGE&&t!==o.contextMenuTargetTypes.RULER_FRAME||d.filterTimelineAreas(n.start,n.end,n.isFilterIn)}}else d.refreshTimeline(),function(e){const n={globalFilterChanged:e};return t.post("api/timelineview/ruler/refresh",{},{params:v(n),timeout:u.promise}).then(r.validateResponse)}(!0).then(d.updateRulerLayers)}function T(){d.refreshTimeline&&d.refreshTimeline()}function b(e){e.bandLookup={},e&&e.bands&&e.bands.length&&e.bands.forEach((t=>{e.bandLookup[t.uid]=t}))}function x(e){e.layerLookup={},e&&e.layers&&e.layers.length&&e.layers.forEach((t=>{e.layerLookup[t.index]=t}))}function M(e,n){return t.get(e,{params:n,timeout:u.promise}).then(r.validateResponse)}function v(t){return(t=t||{}).identity=a.get(e),t.timelineId=l,t.paneId=e.paneId,t}function I(e,n,i){const a={areaId:e.id,groupingIndex:e.selectedGrouping?e.selectedGrouping.index:0,globalFilterChanged:i};return t.post("api/timelineview/refresh",{},{params:v(a),timeout:u.promise}).then(r.validateResponse).then((function(t){if(t)return b(t),x(t),d.rebuildArea(t,e.areaObj,n)}))}function R(e,t,n,i,r,a,o){const s=v({areaId:t.id,bandId:e,timeBin:n,depth:i,hitAreas:r,requestGroup:l+"/"+o});return a&&a.length&&(s.objectIds=a),s}i.getPartitionSocket(e).then((function(t){t.on("DataChangeCancelEvent",(function(){e.timelinePane.timelineUtils.clearSavedTimeRange()})),t.on("KnobChangedEvent",(()=>{m?T():f=!0}))})),e.$on("result:filter:changed",((e,t)=>{!function(e){e.filter&&"global"===e.filter.name&&(m?y(e):g.push(e),e.timeFilterChanged&&(p=!1))}(t)})),e.$on("pane:deactivated",(()=>{m=!1})),e.$on("pane:activated",(()=>{m=!0,g&&g.forEach(y),f&&T(),g=[],f=!1})),e.$on("$destroy",(function(){h&&h()})),e.contextMenuOptions={target:{},isFilterInAvailable:function(){},isRulerFrame:function(){return e.contextMenuOptions.target.type===o.contextMenuTargetTypes.RULER_FRAME},isTimeRange:function(){return e.contextMenuOptions.target.type===o.contextMenuTargetTypes.TIME_RANGE},isBandCaption:function(){return e.contextMenuOptions.target.type===o.contextMenuTargetTypes.BAND_CAPTION},isArea:function(){return e.contextMenuOptions.target.type===o.contextMenuTargetTypes.AREA},filterBySelection:function(n){const i=e.contextMenuOptions.target.type,r=e.contextMenuOptions.target.object;if(void 0!==r&&void 0!==i)switch(i){case o.contextMenuTargetTypes.TIME_RANGE:if(r.selectionFinisher&&r.selectionFinisher.isPostponed())return r.selectionFinisher.clear(),r.isFilterIn=n,d.clearSortingInfo(),d.requestFilterByTime(r.start,r.end,n);break;case o.contextMenuTargetTypes.RULER_FRAME:if(void 0===r.start||void 0===r.end)return;return r.isFilterIn=n,d.clearSortingInfo(),d.requestFilterByTime(r.start,r.end,n);case o.contextMenuTargetTypes.BAND_CAPTION:return t.post("api/timelineview/filterByBands",{bands:r.bands.map((e=>({id:e.bandId})))},{params:v({areaId:r.areaId,filterOut:!n}),timeout:u.promise})}},zoomInOnSelection:function(){e.contextMenuOptions.target.type===o.contextMenuTargetTypes.TIME_RANGE?e.contextMenuOptions.target.object.selectionFinisher.process():e.contextMenuOptions.target.type===o.contextMenuTargetTypes.RULER_FRAME&&d.zoomInByRulerSelection()},zoomInAndFilterInBySelection:function(){if(e.contextMenuOptions.target.type===o.contextMenuTargetTypes.TIME_RANGE){const t=e.contextMenuOptions.target.object;d.zoomInAndFilterInByTimeRange(t.start,t.end)}else e.contextMenuOptions.target.type===o.contextMenuTargetTypes.RULER_FRAME&&d.zoomInAndFilterInByRulerFrame()},undoZoom:function(){},resetZoom:function(){},removeAllFilters:function(){t.post("api/filter",{to:"global"},{params:v(),timeout:u.promise})},getTargetBand:function(){return void 0!==e.contextMenuOptions.target.object&&void 0!==e.contextMenuOptions.target.object.band?e.contextMenuOptions.target.object.band:void 0},isExpandTopXAvailable:function(){const t=e.contextMenuOptions.getTargetBand();return void 0!==t&&!0===t.hasChildren&&!0!==t.isAggregatedBand&&(t.expandedLimit>o.defaultTopValue||t.expandedLimit<o.defaultTopValue&&!0===t.hasAggregatedBand||0===t.expandedLimit)},isExpandAllAvailable:function(){const t=e.contextMenuOptions.getTargetBand();return void 0!==t&&!0===t.hasChildren&&(!0===t.hasAggregatedBand&&t.expandedLimit>0||0===t.expandedLimit)},isExpandOneMoreAvailable:function(){const t=e.contextMenuOptions.getTargetBand();return void 0!==t&&!0===t.hasChildren&&(!0===t.hasAggregatedBand||!0===t.isAggregatedBand)},dismissMenu:function(){e.contextMenuOptions.target.type===o.contextMenuTargetTypes.TIME_RANGE&&e.contextMenuOptions.target.object.selectionFinisher.clear()},canCollapseToOthers:function(){},getAreaSortInfos:function(){},getAreaSelectedSortId:function(){},changeSorting:function(){},shouldShowSortBy:function(){},getSortOrder:function(){},setSortOrder:function(){},getAreaBandModes:function(){},getAreaSelectedBandMode:function(){},changeBandMode:function(){},shouldShowBandModes:function(){},changeTimeScale:function(){},expandTopX:function(){},expandAll:function(){},collapseToOthers:function(){},expandOneMore:function(){}},e.compiledLegend=s("<timeline-legend></timeline-legend>"),d.refreshMetadata=function(){},d.fillRuler=function(){},d.requestFilterByTime=function(e,n,i){p=!0;const r={start:e,end:n,filterOut:!i};return t.post("api/timelineview/filterByTime",{},{params:v(r),timeout:u.promise})},d.getRulerLayerData=function(n,i,a,o,s){return function(){const e=n.index;return t.get("api/timelineview/ruler/update",{params:v({layerIndex:e,start:i,end:a,numberOfTimeBins:o,requestGroup:l+"/"+e}),timeout:u.promise})}().then((function(e){const t=e.data;return s.applyData(t,n)})).catch(r.handle(e))},d.getGlobalRulerData=function(n,i,a,s){return t.get("api/timelineview/ruler/update",{params:v({start:n,end:i,numberOfTimeBins:a,requestGroup:l+"/global"}),timeout:u.promise}).then(r.validateResponse).then((function(e){e.filteredRange&&s.updateFilteredRange(e.filteredRange);return s.applyData(e.pausedRanges,{type:o.layerTypes.PAUSED_LAYER,index:o.pauseLayerIndex})})).catch(r.handle(e))},d.showHideRulerLayer=function(e,n){const i=e.index;t.post("api/timelineview/ruler/"+n,{},{params:v({layerIndex:i,requestGroup:l+"/"+i}),timeout:u.promise})},d.updateArea=function(i,a,s,c,p,f,m){if(!i)return;if(!i.bands)return;if(!i.bands.length)return;if(!c)return;if(!c.length)return;if(!f)return;c=c.slice();const g={bandUids:new Set,processTransitions:!0};return{loadDataPromise:function(){const e=c.map((e=>(i.bands[e.bandIndex]||{}).uid||""));i.invalidatedRequestDataMap&&i.invalidatedRequestDataMap.size&&i.invalidatedRequestDataMap.forEach((t=>{e&&e.length&&e.forEach((e=>{t.bandUids.add(e)})),t.processTransitions=!1}));return t.post("api/timelineview/update",{bands:e.map((e=>({id:e}))),layers:[...a,...s],areaHeight:i.displayMode===o.displayModes.SUPER_TINY?f.getAreaHeight(c[0].id):void 0},{params:v({areaId:i.id,start:c[0].from,end:c[0].to,numberOfTimeBins:p,requestGroup:[l,i.id,e.join()].join("/")}),timeout:u.promise})}().then(r.validateResponse).then((function(e){if(!e)return;if(!e.bands||!e.bands.length)return;d.updateLayerStyleLegend(i.index,e.layerMetadata);const t=[];if(e.bands.forEach((function(e){if(!e)return;const n=e.id;if(!n||function(e){const t=g.bandUids;if(t&&t.size&&t.has(e))return!0;return!1}(n))return;const r=i.bandLookup[n];if(!r)return;r.name&&r.name.length||(r.name=e.name);const a=i.bands.indexOf(r),o=c.find((e=>e.bandIndex===a));if(!o)return;const u=f.getBand(o.id);if(!u)return;if(f.applyBandCaption(u,r),f.deleteLayersDataFromGraph(u,s),!e.layers)return;if(!e.layers.length)return;let l=[];e.layers.forEach((function(e){if(!e)return;const t=i.layerLookup[e.index];if(!t)return;const n=f.applyData(u,t,e);n&&0!==n.length&&l.push(...n)})),l.length?(m&&(l=[...f.getBandRestorers(u),...l]),t.push({data:l,graphObject:u.graph,bandObject:u})):f.setGraphVisible(u)})),e.transitionLayers&&g.processTransitions){const n=f.area;if(!n)return;e.transitionLayers.length?t.push({data:e.transitionLayers.map((function(e){return f.applyTransitionData(n,e.data,i.layerLookup[e.index])})),graphObject:n.scrolled.graph}):f.clearTransitionData(n)}else s.find((e=>e.type.split(o.layerTypes.DELIMITER).includes(o.layerTypes.TRANSITION_LAYER)))&&f.clearTransitionData(f.area);return n.when({bandsData:t,selectionData:{highlight:e.highlight,selection:e.selection,correlation:e.correlation},area:i})})).catch(r.handle(e)),invalidatedRequestData:g}},d.showHideAreaLayer=function(e,n,i){const r=n.index;t.post("api/timelineview/"+i,{},{params:v({areaId:e.id,layerIndex:r,requestGroup:l+"/"+r}),timeout:u.promise})},d.collapseExpand=function(e,n,i,a){if(n.id&&e)return t.get("api/timelineview/"+a,{params:v({areaId:n.id,bandId:e.uid,directChildLimit:i,currentDirectChildCount:e.expandedLimit||0,requestGroup:l+"/"+n.id+"/"+e.uid}),timeout:u.promise}).then(r.validateResponse).then((t=>function(e,t){const i=e.bands||[],r=n.bands.indexOf(t),a=r+e.visibleCount;if(i.length>0){const e=n.bands.slice(0,a+1).concat(i).concat(n.bands.slice(a+1,n.bands.length));n.bands=e,n.count=e.length}e.removeCount>0&&(n.bands.splice(a+i.length+1,e.removeCount),n.count-=e.removeCount);return t.hasAggregatedBand=i.some((e=>!0===e.isAggregatedBand)),t.expandedLimit=e.visibleCount+i.filter((e=>!1===e.isAggregatedBand)).length,b(n),{insertCount:i.length,removeCount:e.removeCount||0,captionIndex:r,bandIndex:a}}(t,e)))},d.requestAreaTooltip=function(t,n,i,a,s,u,l,d){if(!n.id||!t)return;if(t>0){if(!n.bands.find((e=>e.uid===t)))return{}}const c=R(t,n,i,a,s,u,"tooltip");return c.tooltipLimit=o.tooltipEntryLimit,M("api/timelineview/tooltip",c).then((function(e){return l.applyTooltip(d,e,a)})).catch(r.handle(e))},d.buildTooltip=function(t,n,i){c&&clearTimeout(c),c=setTimeout((()=>{const r=function(t,n,i){const r=e.$new();return r.tooltip=t,r.isSuperTinyMode=i===o.displayModes.SUPER_TINY,r.showTooltip=function(e){d.showTooltip(n,e)},r.timelineRuler=e.timelinePane.timelineRuler,r.localizedMessages=e.messages,r}(n,t,i);s("<timeline-tooltip></timeline-tooltip>")(r)}),o.tooltipTimeoutDuration)},d.requestRulerTooltip=function(e){return M("api/timelineview/ruler/tooltip",v({timeBin:e,tooltipLimit:o.tooltipEntryLimit,requestGroup:l+"/ruler/tooltip"}))},d.changeGrouping=function(e,t){I(e,t,!1)},d.refresh=function(e){const t=[];for(const n in e){const i=e[n];t.push(I(i,n,!0))}return n.all(t)},d.showHideStyle=function(e,n,i){const r=n.index,a=i.visible?o.layerVisibleState.visible:o.layerVisibleState.invisible;return t.post("api/timelineview/"+a,{},{params:v({areaId:e.id,layerIndex:r,styleId:i.name,requestGroup:l+"/"+r}),timeout:u.promise})},d.requestObjectSelection=function(e,t,n,i,r,a){if(!t.id||!e)return;return M("api/timelineview/selection",R(e,t,n,i,r,a,"selection"))},d.requestViewSource=function(t,n,i,r,a,o){if(!n.id||!t)return;return M("api/timelineview/viewSource",R(t,n,i,r,a,o,"viewSource")).then((t=>e.$emit("viewSource",t)))},d.requestRulerSelection=function(e){return M("api/timelineview/ruler/selection",v({timeBin:e,requestGroup:l+"/ruler/selection"}))},d.fireClearSelection=function(){return M("api/timelineview/selection/clear",v())},d.clearSortingInfo=function(){},d.sort=function(e,n){const i={areaId:e.id,sorting:{id:e.sorting.selectedSorting.id,ascending:e.sorting.selectedSorting.ascending}};return t.post("api/timelineview/sort",i,{params:v(),timeout:u.promise}).then(r.validateResponse).then((function(t){if(t)return b(t),x(t),d.rebuildArea(t,e.areaObj,n)}))},d.changeBandDisplayMode=function(e,n){const i={areaId:e.id,displayMode:e.bandMode.selectedBandModeId};return t.post("api/timelineview/changeDisplayMode",i,{params:v(),timeout:u.promise}).then(r.validateResponse).then((function(t){if(t)return b(t),x(t),d.rebuildArea(t,e.areaObj,n)}))},d.expandAllBands=function(e,n){const i={areaId:e.id};return t.post("api/timelineview/expandAllBands",{},{params:v(i),timeout:u.promise}).then(r.validateResponse).then((function(t){return b(t),x(t),d.rebuildArea(t,e.areaObj,n)}))},e.$on("$destroy",(()=>{u.resolve()}))}]);
"use strict";angular.module("timelinepane").directive("timeline",["$q","constants","View","Utils","Ruler","BandSelector","ZoomPanel","Frame","Global","Hierarchical","Interval","Overtime","Pause","Running","Sample","Tiny","Transition","shortContextMenu","fullContextMenu","Debounce",function(e,t,i,n,s,a,r,o,l,d,c,h,p,u,g,m,_,f,x,y){return{restrict:"E",scope:{configuration:"=",dumpApi:"=",isFilterEmpty:"=",loading:"=",messages:"=",paneId:"="},controller:"TimelineController",link:function(T,S,b,M){const A={keepCurrent:!0,tracking:!0,autoHideDelay:200},R=T.timelinePane=new v(S[0]);function v(b){this.timelineRuler=void 0,this.timelineView=void 0,this.timelineUtils=n.create(),this._idvcTimeline=void 0,this._idvcUtils=void 0,this._idvcDataUtils=void 0,this._parentElement=b,this._bandSelector=a.create(),this._zoomPanel=r.create(),this._timeline=void 0,this._frameDrawer=o.create(this.timelineUtils),this._globalDrawer=l.create(this.timelineUtils),this._hierarchicalDrawer=d.create(this.timelineUtils),this._intervalDrawer=c.create(this.timelineUtils),this._overtimeDrawer=h.create(this.timelineUtils),this._pauseDrawer=p.create(this.timelineUtils),this._runningDrawer=u.create(this.timelineUtils),this._sampleDrawer=g.create(this.timelineUtils),this._tinyDrawer=m.create(this.timelineUtils),this._transitionDrawer=_.create(this.timelineUtils),this._metadata=void 0,this._needRefreshView=!1,this._legendScope=T.$new(),this._parentElement.refreshSize=()=>{this._needRefreshView&&this._metadata&&(this._createTimeline(this._metadata),this._needRefreshView=!1),this.timelineRuler&&(this.timelineRuler.initRuler(this._legendScope.rulerLayers),this.timelineRuler.setSelectedTimeScale(T.contextMenuOptions.selectedTimeScale))},T.$on("$destroy",(()=>{this._timeline&&(this._shortContextMenu&&this._shortContextMenu.destroy(),this._fullContextMenu&&this._fullContextMenu.destroy(),this._timeline.hideTooltip(),this._timeline.destroy(),delete this._timeline,delete T.timelinePane)})),this._createTimeline=()=>{this._timeline=this._idvcTimeline.create(this._parentElement),this.timelineRuler=s.create(this._metadata.start,this._metadata.end,this._timeline,this._sampleDrawer,this._frameDrawer,this._globalDrawer,this._pauseDrawer,this.timelineUtils),this.timelineRuler.onFillRuler=this.timelineRuler.drawRuler,this.timelineRuler.onScroll=this.timelineRuler.processScroll,this.timelineRuler.onHorzResize=this.timelineRuler.processResize,this.timelineRuler.onVertResize=this.timelineRuler.processHeightResize,this.timelineRuler.onTooltip=(e,t)=>(e.classList.contains("svg_ruler")&&M.requestRulerTooltip(t).then((t=>{if(!this.timelineView.pointerInsideSelectionArea)return;const{layers:i}=t;i&&this.timelineView.highlightHoveredObjects(e.parentNode.graph,i),M.buildTooltip(e,t)})),A);const e=e=>M.requestRulerSelection(e).then((e=>(this.timelineRuler&&e.selectionChanged&&(this.timelineView.clearLastSelectedObjects(),this.timelineRuler.selectObjects(e)),e)));this.timelineRuler.onContextMenu=(i,n)=>{this.timelineView.clearBandSelection(),this.timelineView.clearTimeSelection(),this._timeline.hideTooltip(),T.contextMenuOptions.target.type=void 0,delete T.contextMenuOptions.target.object,T.$apply(),i.classList.contains("svg_ruler")&&e(n).then((e=>{if(e.selection||!1===e.selectionChanged&&this.timelineRuler.hasSelection()){T.contextMenuOptions.target.type=t.contextMenuTargetTypes.RULER_FRAME;const e=this.timelineRuler.getSelectionRange();e&&(T.contextMenuOptions.target.object={start:e.rangeStart,end:e.rangeEnd}),this._fullContextMenu.update&&this._fullContextMenu.update()}}))};const n=this._timeline.createRuler(this.timelineRuler);n.content.addEventListener("mousedown",(t=>{if(0===t.button&&t.target.classList.contains("svg_ruler")){const i=t.target.getBoundingClientRect(),n=t.clientX-i.left;e(n)}}),!0),n.getClientOffsets=function(){return this._timeline&&this._timeline.clientOffsets?this._timeline.clientOffsets:{left:0,right:0}},M.refreshGlobalRulerData=this.timelineRuler.refreshGlobalData.bind(this.timelineRuler),M.updateRulerLayers=this.timelineRuler.updateLayers.bind(this.timelineRuler),this.timelineUtils.rulerObj=this.timelineRuler;const a=this._timeline.createSelection({onGetLabel:(e,t)=>this.timelineRuler.getLabel(e,t),beforeProcessSelection:(e,i,n,s,a)=>{this.timelineView.clearBandSelection(),this._timeline.hideTooltip(),s.postpone(),T.contextMenuOptions.target.type=t.contextMenuTargetTypes.TIME_RANGE;const r=this.timelineRuler.convertPixelToTime(e),o=this.timelineRuler.convertPixelToTime(e+i);T.contextMenuOptions.target.object={selectionFinisher:s,start:r,end:o},s.isRightMouseButton()||this._shortContextMenu.show&&this._shortContextMenu.show({x:a.pageX,y:a.pageY}),T.$apply()},onStartSelection:()=>{if(this.timelineView.clearBandSelection(),T.contextMenuOptions.isTimeRange()||T.contextMenuOptions.isRulerFrame())T.contextMenuOptions.target.type=void 0,T.contextMenuOptions.target.object={};else{const e=this.timelineRuler.getSelectionRange();e&&(T.contextMenuOptions.target.type=t.contextMenuTargetTypes.RULER_FRAME,T.contextMenuOptions.target.object={start:e.rangeStart,end:e.rangeEnd})}T.$apply()},onClearSelection:()=>{this._shortContextMenu.hide&&this._shortContextMenu.hide()},onMouseLeaveContent:()=>{this.timelineView.pointerInsideSelectionArea=!1,this.timelineView.clearLastHighlightedObjects()},onMouseEnterContent:()=>{this.timelineView.pointerInsideSelectionArea=!0},getSelectionColor:()=>t.colors.selectionRangeColor}),r=this._timeline.createHorzScroll({onScroll:()=>this._zoomPanel.onScroll(),onResize:()=>{}});r.setScrollInfo(this._metadata.start,this._metadata.end),r.connect(a,((e,t)=>t>this.timelineUtils.getTimeBins())),this._zoomPanel.initZoomButtonPanel(n.corner,r,T.messages),T.contextMenuOptions.undoZoom=()=>this._zoomPanel.undoZoom(),T.contextMenuOptions.resetZoom=()=>this._zoomPanel.resetZoom(),T.contextMenuOptions.isZoomUndoAvailable=()=>this._zoomPanel.getZoomState().undo,T.contextMenuOptions.isZoomResetAvailable=()=>this._zoomPanel.getZoomState().cancel,this._legendScope.changeGrouping=(e,t)=>{this.timelineView.clearBandSelection(),this.timelineView.clearTimeSelection(),M.changeGrouping(e,t)},this._legendScope.showHideRulerLayer=e=>{e.visible?(M.showHideRulerLayer(e,t.layerVisibleState.visible),this.timelineRuler.showRulerLayer(e)):(M.showHideRulerLayer(e,t.layerVisibleState.invisible),this.timelineRuler.hideRulerLayer(e))},this._legendScope.showHideAreaLayer=(e,i)=>{i.visible?(M.showHideAreaLayer(e,i,t.layerVisibleState.visible),this.timelineView.showAreaLayer(e.areaObj,i)):(M.showHideAreaLayer(e,i,t.layerVisibleState.invisible),this.timelineView.hideAreaLayer(e.areaObj,i))},this._legendScope.showHideStyle=(e,i,n)=>{M.showHideStyle(e,i,n).then((()=>{i.type===t.layerTypes.OVERTIME_LAYER?this.timelineView.onChangeLayerWithSeries(e.areaObj,i):this.timelineView.onChangeIntervalsStyle(e.areaObj,i,n)}))},this._legendScope.areas={},this._legendScope.timelineUtils=this.timelineUtils;this._timeline.createLegendHolder(t.defaultLegendWidth).appendChild(T.compiledLegend(this._legendScope)[0]),this.timelineView=i.create(this._overtimeDrawer,this._frameDrawer,this._hierarchicalDrawer,this._sampleDrawer,this._intervalDrawer,this._runningDrawer,this._transitionDrawer,this._tinyDrawer,this._pauseDrawer,this.timelineRuler,this.timelineUtils);const o=Math.floor(Number.parseFloat(getComputedStyle(S[0]).fontSize));t.intervalTextFontStyle=`${o}px Arial`,t.pauseTextFontStyle=`${o}px Arial`,t.rulerTimeLabelFontSize=o+2,this.timelineView.setCanvasElementsFontStyle(),this._pauseDrawer.setPauseText(T.messages.pause),this.timelineUtils.setTimeScale(this._metadata.start,this._metadata.end),this.timelineUtils.setHorzScroll(r);const l=this._timeline.createAreaHolder();function d(e){return e.layers.find((e=>e.type.split(t.layerTypes.DELIMITER).includes(t.layerTypes.HIERARCHICAL_INTERVALS)))}function c(e){if(!e)return;return e.find((e=>e.applied))||e[0]}l.hasSelectedItems=!1,this.timelineUtils.areaHolder=l,this._extendTimelineView(),this._metadata.areas.forEach(((e,t)=>{if(!e)return;let i="idvc_timeline_ctrl_area_fixed";e.groupings&&e.groupings.length&&(1===e.groupings.length&&1===e.bands.length&&!e.bands[0].hasChildren&&!d(e)&&this._metadata.areas.length>1?(e.bandPreCaption=e.name,delete e.name):i="scrollable_area");const n=this._addArea(e,i,t);if(!1===e.visible&&n.hide(),n&&e.layers.length){let i=e.bandPreCaption?`${e.bandPreCaption}: ${e.bands[0].name}`:e.name;!i&&e.bands.length&&(i=e.bands[0].name),this._legendScope.areas[t]={name:i,groupings:e.groupings,count:e.count,selectedGrouping:e.groupings?e.groupings[0]:void 0,layers:e.layers,shown:e.visible,areaObj:n,id:e.id,sorting:{sortingInfos:e.sortings,selectedSorting:c(e.sortings)},bandMode:{bandModeInfos:e.displayModes,selectedBandModeId:e.displayMode},index:t}}})),this._bandSelector.addClass=(e,t)=>{this._idvcUtils.addClass(e,t),this._timeline.updateCaptionExpansion()},this._bandSelector.removeClass=(e,t)=>{this._idvcUtils.removeClass(e,t),this._timeline.updateCaptionExpansion()},this._bandSelector.setAreas(this._legendScope.areas),this._mapContextMenuCallbacks(),this._initDumpApi(),this._shortContextMenu=f(T,S),this._fullContextMenu=x(T,this._timeline.content),this._timeline.refresh(),this._timeline.setExpansionContentProcessor((function(e,t){t.innerHTML=Array.prototype.find.call(e.childNodes,(e=>3===e.nodeType)).textContent})),M.clearSortingInfo=()=>{for(const e in this._legendScope.areas){this._legendScope.areas[e].sorting.selectedSorting={ascending:!1}}},M.clearTimelineFiltering=()=>{this.timelineRuler.clearTimelineFiltering()},M.fillRuler=e=>{this.timelineRuler.applyData=this.timelineRuler.drawLayer,this.timelineRuler.requestLayer=M.getRulerLayerData,this.timelineRuler.requestGlobalData=M.getGlobalRulerData,this._legendScope.rulerLayers=e.layers,T.contextMenuOptions.timeScale=e.timeUnits,T.contextMenuOptions.selectedTimeScale=e.timeUnits.find((e=>e.default)),this._parentElement.offsetParent&&(this.timelineRuler.initRuler(e.layers),this.timelineRuler.setSelectedTimeScale(T.contextMenuOptions.selectedTimeScale))},M.filterTimelineAreas=(e,t,i)=>{this.timelineRuler.filterTimelineAreas({rangeStart:e,rangeEnd:t},i)},M.rebuildArea=(e,t,i)=>{e.index=i,t.content.removeEventListener("mousedown",t.mouseDown,!0),!e.groupings||1!==e.groupings.length||1!==e.bands.length||e.bands[0].hasChildren||d(e)||(e.bandPreCaption=e.name,delete e.name);const n=this._createBandBuilder(e);this.timelineView.removeTransitionsGraph(t),t.rebuild(n),this._processAreaSubscription(e,t),e.layers.forEach((e=>{const t=this._legendScope.areas[i].layers.find((t=>t.index===e.index));t&&(e.styles=t.styles,e.selectedStyle=t.selectedStyle)})),this._legendScope.areas[i].layers=e.layers,this._legendScope.areas[i].sorting={sortingInfos:e.sortings,selectedSorting:c(e.sortings)},this._legendScope.areas[i].count=e.count,t.layers=e.layers,this.timelineView.drawTransitionsGraph(t,e),this.timelineView.initTransitionsGraph(t)},M.refreshTimeline=()=>{this.timelineView.clearBandSelection(),this.timelineView.clearTimeSelection(),T.loading.start().then((()=>M.refresh(this._legendScope.areas))).finally(T.loading.stop)},M.showTooltip=(e,t)=>{t.length&&this._timeline.showTooltip(e,t)},M.updateLayerStyleLegend=(e,t)=>{this._legendScope.areas[e]&&t&&this._legendScope.areas[e].layers.forEach((e=>{const i=t.find((t=>t.index===e.index));i?(e.styles&&e.styles.length?i.styles.forEach((t=>{e.styles.find((e=>e.name===t.name&&e.color===t.color&&e.hatchStyle===t.hatchStyle))||e.styles.push(t)})):e.styles=i.styles,e.styles.forEach(((t,i)=>{void 0===t.visible&&(t.visible=0===i||!e.showSingleSeries,e.showSingleSeries&&void 0===e.selectedStyle&&0===i&&(e.selectedStyle=t))}))):e.styles=[]}))},M.updateZoomAfterFiltering=()=>{const e=this.timelineUtils.popNewTimeRange();if(!e)return;M.clearSortingInfo();const i=T.contextMenuOptions.target.type;i===t.contextMenuTargetTypes.TIME_RANGE?T.contextMenuOptions.target.object.selectionFinisher.process():i===t.contextMenuTargetTypes.RULER_FRAME&&r.setScrollPage(e.start,e.end),this.timelineRuler.filterTimelineAreas({rangeStart:e.start,rangeEnd:e.end},!0)},M.zoomInAndFilterInByRulerFrame=()=>{const e=this.timelineRuler.getSelectionRange();return this.timelineUtils.saveNewTimeRange(e.rangeStart,e.rangeEnd),M.requestFilterByTime(e.rangeStart,e.rangeEnd,!0)},M.zoomInAndFilterInByTimeRange=(e,t)=>(this.timelineUtils.saveNewTimeRange(e,t),M.requestFilterByTime(e,t,!0)),M.zoomInByRulerSelection=()=>{const e=this.timelineRuler.getSelectionRange();e&&r.setScrollPage(e.rangeStart,e.rangeEnd)},T.$on("pane:deactivated",(()=>{this._timeline.hideTooltip()}))},this._addArea=(e,t,i)=>{if(!this.timelineUtils.areaHolder||!e)return;const n=(this.timelineUtils.areaHolder.createArea?this.timelineUtils.areaHolder.createArea:this.timelineUtils.areaHolder.addArea).call(this.timelineUtils.areaHolder,this._createBandBuilder(e),t);return n.layers=e.layers,this.timelineView.drawTransitionsGraph(n,e),this._processAreaSubscription(e,n),e.index=i,n},this._processAreaSubscription=(e,t)=>{t.mouseDown=i=>this._processAreaMouseDown(e,t,i),t.content.addEventListener("mousedown",t.mouseDown,!0),t.expandTopX=i=>this.expandTopX(e,t,i),t.expandAll=i=>this.expandAll(e,t,i),t.collapseToOthers=i=>this.collapseToOthers(e,t,i),t.expandOneMore=i=>this.expandOneMore(e,t,i),t.isFilterInAvailable=()=>this.isFilterInAvailable(e),t.canCollapseToOthers=()=>this.canCollapseToOthers(e)},this._createBandBuilder=i=>(i.invalidatedRequestDataMap=new Map,function(i,n,s,a,r,o,l,d){const c=(e,t,i,n,s,a,o)=>{const{bands:l}=t;if(!l||l.length<n)return;const d=l[n].uid,c=r.getHitInfo(e.area,i,n,s,a,o);M.requestAreaTooltip(d,t,Math.round(a),c.depth,c.hitAreas,c.transitionIds,e,s)},h=y.create(((e,t,i,n,s,a,r)=>{c(e,t,i,n,s,a,r)}),20);return i.createStdBandBuilder({getAreaName:function(){return n.name},getBandCount:function(){return n.count},onFillEmptyBand:function(e,t){if(e){const s=n.bands[t];e.caption.innerHTML=r.decorateBandCaption(s)+"Loading...";this.area.getInfo(t,"selected")&&l.addClass(e.caption,"timeline_selected_band"),r.drawGraph(e,n),r.initTransitionsGraph(i.getAreaObj(e.graph))}},onScrollBands:function(e){this.area.layerToLoad||r.processScroll(e,this.area)},onChangeBandHeight:function(e){e&&r.processHeightResize(e,this.area)},onChangeAreaWidth:function(e){e.length&&r.processResize(e,this.area)},onProcessRequest:function(i){if(!a(n))return;const s=i[0].id;if(this.area.reqId=s,this.area.layerToLoad){const s=this.area.layerToLoad.type.split(t.layerTypes.DELIMITER).includes(t.layerTypes.HIERARCHICAL_INTERVALS);return M.updateArea(n,[{index:this.area.layerToLoad.index}],[],i,o.getTimeBins(),this,!s).loadDataPromise||e.when()}{const t=[],a=[];n.layers.forEach((e=>{(e.visible?t:a).push({index:e.index,type:e.type})})),r.clearLastHighlightedObjects();const l=M.updateArea(n,t,a,i,o.getTimeBins(),this);if(!l)return;r.showAreaLoading(this.area);const{loadDataPromise:d}=l;n.loadDataPromise=d,n.invalidatedRequestDataMap&&n.invalidatedRequestDataMap.set(s,l.invalidatedRequestData),d.then((t=>{if(!t)return;const{bandsData:i}=t;if(!i||!i.length)return;const s=[],a=[];let l=!1;const d=e.defer();return e.all(i.map((e=>(s.push(e.graphObject),e.bandObject?a.push(e.bandObject):l=!0,o.processDataArray(e.data))))).then((()=>(r.clearLastSelectedObjectsFromArea(this.area,a,!0,!0),l&&r.clearLastSelectedTransitions(this.area,!0),s.forEach((e=>{r.displayLayersData(e)})),r.selectObjects(t.selectionData,n,this.area),this.area._refreshBands(),d.resolve()))),d.promise})).finally((()=>{r.hideAreaLoading(this.area,s),n.invalidatedRequestDataMap&&n.invalidatedRequestDataMap.delete(s)}))}function a(e){return(d.areas[e.index].id===e.id?d.areas[e.index]:d.areas.find((t=>t.id===e.id))).shown}},applyBandCaption:function(e,t){if(this.area){const i=e.caption;r.applyBandCaption(n,i,t)}},applyData:function(e,t,i){if(this.area)return e.graph.savedLayerData.delete(t.index),r.drawLayer(e,i,t)},onBandTooltip:function(e,t,s,l,d){if(!(d<0)&&n.loadDataPromise&&!n.loadDataPromise.$$state.pending){if(!this.area||s.classList.contains("idvc_timeline_ctrl_band_caption")||s.classList.contains("idvc_timeline_ctrl_caption_padding"))return void r.clearLastHighlightedObjects();if(!e&&-1===t&&s.classList.contains("idvc_timeline_ctrl_scrolled")){let e=a.getTimelineCaptionPadding();const d=i.getElementPosition(s);d&&(e-=d.x);const c=l-e+1;if(r.clearLastHighlightedObjects(),a.isWithinFilteredRange(c))return setTimeout((()=>{M.showTooltip(s,T.messages.filteredOutLabel)}),0),A;if(a.isWithinPausedRange(c))return;if(c>o.getTimeBins())return;return void M.requestAreaTooltip(t,n,c,0,[],[],this,s)}return a.isWithinFilteredRange(l)?(r.clearLastHighlightedObjects(),setTimeout((()=>{M.showTooltip(s,T.messages.filteredOutLabel)}),0),A):a.isWithinPausedRange(l)?void r.clearLastHighlightedObjects():(O(s)?h(this,n,e,t,s,l,d):r.clearLastHighlightedObjects(),A)}},applyTransitionData:function(e,t,i){return r.drawTransitionsLayer(n,e,t,i)},clearTransitionData:function(e){e.scrolled&&e.scrolled.graph&&e.scrolled.graph.savedLayerData.clear()},deleteLayersDataFromGraph:function(e,i){i.length&&i.forEach((i=>{i.type!==t.layerTypes.TRANSITION_LAYER&&e.graph.savedLayerData.delete(i.index)}))},setGraphVisible:function(e){const{graph:t}=e;o.setCanvasElementsVisible(t,t.onscreenCanvas,t.onscreenSelectionCanvas),t.onscreenHierarchCanvas&&o.setCanvasElementsVisible(t,t.onscreenHierarchCanvas,t.onscreenHierarchSelectionCanvas)},getBandRestorers:function(e){const t=[],{graph:i}=e;return i.savedLayerData.forEach((e=>{e.visible&&!e.hierarchical&&t.push(e.restoreLayer(i,e))})),t},onBandClick:function(e,t,i,s,o,l){if(e)if(O(i)){if(a.isWithinFilteredRange(s))return;if(a.isWithinPausedRange(s))return;const{bands:l}=n,d=l[t].uid,c=r.getHitInfo(this.area,e,t,i,s,o);r.requestObjectSelection(d,n,Math.round(s),c.depth,c.hitAreas,c.transitionIds,this.area)}else C(i)&&(r.clearTimeSelection(),r.selectBand(this.area,n,e,t,l),T.$apply());else M.fireClearSelection().then((()=>r.clearLastSelectedObjects()))},onBandDblClick:function(e,t,i,s,o){if(e&&!a.isWithinFilteredRange(s)&&!a.isWithinPausedRange(s)&&O(i)){const{bands:a}=n,l=a[t].uid,d=r.getHitInfo(this.area,e,t,i,s,o);M.requestViewSource(l,n,Math.round(s),d.depth,d.hitAreas,d.transitionIds)}},onBandContextMenu:function(e,i,a,o,l,c){s.hideTooltip(),e&&C(a)?(r.clearTimeSelection(),r.selectBand(this.area,n,e,i,c)):(!e&&function(e){return e.classList.contains("idvc_timeline_ctrl_caption_padding")||e.classList.contains("idvc_timeline_ctrl_scrolled")}(a)||e&&O(a))&&(T.contextMenuOptions.target.type=t.contextMenuTargetTypes.AREA,T.contextMenuOptions.target.object={area:d.areas[n.index],areaIndex:n.index}),T.$apply()},applyTooltip:function(e,t,i){if(!r.pointerInsideSelectionArea)return;const{layers:s}=t,{globalLayers:a}=t;(s||a)&&r.highlightHoveredObjects(e,s,a,i,n,this.area),M.buildTooltip(e,t,n.displayMode)},getAreaHeight:function(e){return this.area.getBand(e).getClientHeight()},captionWidthAsAreaMinHeight:function(){return!1}},s)}(this._idvcTimeline,i,this._timeline,this.timelineRuler,this.timelineView,this.timelineUtils,this._idvcUtils,this._legendScope)),this._extendTimelineView=()=>{this.timelineView.decorateBandCaption=e=>{if(!e)return"";let t;return t=e.hasChildren?0===e.expandedLimit?this._idvcDataUtils.RowState.collapsed:this._idvcDataUtils.RowState.expanded:this._idvcDataUtils.RowState.simple,this._idvcDataUtils.decorateExpand(e.uid,t,e.level)},this.timelineView.applyBandCaption=function(e,t,i){const n=`${e.bandPreCaption?e.bandPreCaption+": ":""}${i.name}`;t.removeChild(t.getElementsByTagName("span")[0]),t.childNodes[0].textContent=n,t.insertAdjacentHTML("afterbegin",this.decorateBandCaption(i))},this.timelineView.getHitInfo=function(e,i,n,s,a,r){const o={hitAreas:[],depth:0,transitionIds:[]};if(s.classList.contains("hierarchical_canvas_container")){o.hitAreas.push(t.hitArea.Hierarchical);const[e]=s.children,n=e.tightMode?e.queueIntervalHeightTiny:e.queueIntervalHeight;o.depth=Math.floor(r/n);r+=i.getInfo("commonContainerHeight")||i.getInfo("currentModeDefHeight")}else{if(r>t.layersOffset&&o.hitAreas.push(t.hitArea.Main),r<t.frameBase)o.hitAreas.push(t.hitArea.Frame);else{(s.onscreenHighlightCanvas||s.children[0]).height-r<t.markerBase&&o.hitAreas.push(t.hitArea.Sample)}i.getInfo("currentBandMode")===t.displayModes.SUPER_TINY&&(o.depth=Math.round(r))}const l=this.detectTransitionHit(e,n,a,r);return o.transitionIds=l?l.map((e=>e.id)):[],o},this.timelineView.requestObjectSelection=function(e,t,i,n,s,a,r){return M.requestObjectSelection(e,t,i,n,s,a).then((e=>(e.selectionChanged&&(this.clearLastSelectedObjects(),this.selectObjects(e,t,r)),e)))},this.timelineView.clearBandSelection=()=>{T.contextMenuOptions.target.type===t.contextMenuTargetTypes.BAND_CAPTION&&(this._bandSelector.clearBandSelection(),T.contextMenuOptions.target.type=void 0,T.contextMenuOptions.target.object={})},this.timelineView.clearTimeSelection=()=>{T.contextMenuOptions.target.type===t.contextMenuTargetTypes.TIME_RANGE&&(T.contextMenuOptions.target.object.selectionFinisher.clear(),T.contextMenuOptions.target.type=void 0,T.contextMenuOptions.target.object={})},this.timelineView.selectBand=(e,i,n,s,a)=>{this._bandSelector.selectBand(e,i,n,s,a);const r=this._bandSelector.hasSelection();T.contextMenuOptions.target.type=r?t.contextMenuTargetTypes.BAND_CAPTION:void 0,T.contextMenuOptions.target.object=r?this._bandSelector.getCurrentSelection():{};const o=T.contextMenuOptions.target.object.bands;void 0!==o&&1===o.length&&(T.contextMenuOptions.target.object.band=i.bands.find((e=>e.uid===o[0].bandId)),T.contextMenuOptions.target.object.band.bandCaptionElement=n.caption)}},this._getTargetArea=()=>T.contextMenuOptions.target.type===t.contextMenuTargetTypes.BAND_CAPTION?this._bandSelector.getSelectedArea():T.contextMenuOptions.target.type===t.contextMenuTargetTypes.AREA?T.contextMenuOptions.target.object.area:void 0,this._processAreaCall=e=>{const t=this._getTargetArea(),i=T.contextMenuOptions.getTargetBand();if(void 0===t||void 0===i||this.timelineUtils.areaHolder.areas.length<=t.index)return;const n=this.timelineUtils.areaHolder.areas[t.index];return n[e]?n[e](i):void 0},this._initDumpApi=()=>{T.dumpApi.expandAllBands=e=>{const t=this._legendScope.areas[e];T.loading.start().then((()=>M.expandAllBands(t,e))).finally(T.loading.stop)},T.dumpApi.getLayerInfoForBand=(e,i,n)=>{let s;const a=this._legendScope.areas[e];if(a){const e=a.layers[i];if(!e)return;const r=e.type.split(t.layerTypes.DELIMITER);if(r.includes(t.layerTypes.INTERVAL_LAYER)||r.includes(t.layerTypes.HIERARCHICAL_INTERVALS)||r.includes(t.layerTypes.FRAME_LAYER)||r.includes(t.layerTypes.EVENT_MARKER_LAYER)){const t=e.index,i=a.areaObj.getVisibleBands().find((e=>e.caption.textContent.replace(/\s/g,"")===n));if(i){const e=i.graph.savedLayerData.get(t);s=e?e.data.map((e=>({start:this.timelineRuler.formatTimeInRulerUnitsOfMeasure(e.start,!0),end:this.timelineRuler.formatTimeInRulerUnitsOfMeasure(e.end,!0),name:e.name}))):`Can't find saved data for layer with index: ${t}`}}}return s},T.dumpApi.showTop=()=>T.loading.start().then(T.contextMenuOptions.expandTopX).finally(T.loading.stop),T.dumpApi.expandBand=()=>T.loading.start().then(T.contextMenuOptions.expandAll).finally(T.loading.stop),T.dumpApi.collapseToOthers=()=>T.loading.start().then(T.contextMenuOptions.collapseToOthers).finally(T.loading.stop),T.dumpApi.showMore=()=>T.loading.start().then(T.contextMenuOptions.expandOneMore).finally(T.loading.stop)},this._mapContextMenuCallbacks=()=>{T.contextMenuOptions.changeBandMode=e=>{const i=this._getTargetArea();if(i){if(i.bandMode.selectedBandModeId===e.id)return;const n=T.contextMenuOptions.target.type===t.contextMenuTargetTypes.BAND_CAPTION?this._bandSelector.getSelectedAreaIndex():T.contextMenuOptions.target.object.areaIndex;i.bandMode.selectedBandModeId=e.id,M.changeBandDisplayMode(i,n)}},T.contextMenuOptions.changeSorting=e=>{const i=this._getTargetArea();if(i){if(i.sorting.selectedSorting.id===e.id)return;const n=T.contextMenuOptions.target.type===t.contextMenuTargetTypes.BAND_CAPTION?this._bandSelector.getSelectedAreaIndex():T.contextMenuOptions.target.object.areaIndex,s=i.sorting.selectedSorting.ascending;i.sorting.selectedSorting=e,i.sorting.selectedSorting.ascending=s,this._bandSelector.clearBandSelection(),M.sort(i,n)}},T.contextMenuOptions.changeTimeScale=e=>{T.contextMenuOptions.selectedTimeScale=e,this.timelineRuler.setSelectedTimeScale(e)},T.contextMenuOptions.getAreaBandModes=()=>{const e=this._getTargetArea();if(e)return e.bandMode.bandModeInfos},T.contextMenuOptions.getAreaSelectedBandModeId=()=>{const e=this._getTargetArea();if(e)return e.bandMode.selectedBandModeId},T.contextMenuOptions.getAreaSelectedSortId=()=>{const e=this._getTargetArea();if(e)return e.sorting.selectedSorting.id},T.contextMenuOptions.getAreaSortInfos=()=>{const e=this._getTargetArea();if(e)return e.sorting.sortingInfos},T.contextMenuOptions.getSortOrder=()=>{const e=this._getTargetArea();if(e)return e.sorting.selectedSorting.ascending},T.contextMenuOptions.setSortOrder=e=>{const i=this._getTargetArea();if(i){if(i.sorting.selectedSorting.ascending===e)return;i.sorting.selectedSorting.ascending=e;const n=T.contextMenuOptions.target.type===t.contextMenuTargetTypes.BAND_CAPTION?this._bandSelector.getSelectedAreaIndex():T.contextMenuOptions.target.object.areaIndex;this._bandSelector.clearBandSelection(),M.sort(i,n)}},T.contextMenuOptions.shouldShowBandModes=()=>{const e=this._getTargetArea();return!!e&&(e.bandMode.bandModeInfos&&e.bandMode.bandModeInfos.length>1)},T.contextMenuOptions.shouldShowSortBy=()=>{const e=this._getTargetArea();return!!e&&(e.groupings&&e.sorting.sortingInfos&&e.sorting.sortingInfos.length>1)},T.contextMenuOptions.expandTopX=()=>this._processAreaCall("expandTopX"),T.contextMenuOptions.expandAll=()=>this._processAreaCall("expandAll"),T.contextMenuOptions.collapseToOthers=()=>this._processAreaCall("collapseToOthers"),T.contextMenuOptions.expandOneMore=()=>this._processAreaCall("expandOneMore"),T.contextMenuOptions.isFilterInAvailable=()=>this._processAreaCall("isFilterInAvailable")||!1,T.contextMenuOptions.canCollapseToOthers=()=>this._processAreaCall("canCollapseToOthers")||!1},this.expandTopX=(e,i,n)=>this.processCollapseExpand(n.uid,i,e,t.defaultTopValue,n.bandCaptionElement),this.expandAll=(e,i,n)=>this.processCollapseExpand(n.uid,i,e,t.expandAllValue,n.bandCaptionElement),this.collapseToOthers=(e,t,i)=>{if(i&&void 0!==i.parentUid){const n=e.bands.findIndex((e=>e.uid===i.uid)),s=e.bands.findIndex((e=>e.uid===i.parentUid));if(void 0!==n&&void 0!==s){const i=e.bands[s];this.processCollapseExpand(i.uid,t,e,n-s,i.bandCaptionElement)}}},this.canCollapseToOthers=e=>{const t=T.contextMenuOptions.getTargetBand();let i=!0;if(t){const n=e.bands.findIndex((e=>e.uid===t.uid));i=void 0!==n&&e.bands.length>n+2&&e.bands[n+1].parentUid===t.parentUid&&e.bands[n+2].parentUid===t.parentUid}return void 0!==t&&void 0!==t.parentUid&&!0!==t.isAggregatedBand&&i},this.expandOneMore=(e,t,i)=>{if(void 0===i)return;let n=i.expandedLimit+1;if(i&&!0===i.isAggregatedBand){const t=e.bands.find((e=>e.uid===i.parentUid));void 0!==t&&(n=t.expandedLimit+1,i=t)}this.processCollapseExpand(i.uid,t,e,n,i.bandCaptionElement)},this.isFilterInAvailable=e=>{const i=T.contextMenuOptions.getTargetBand();return void 0!==T.contextMenuOptions.target.type&&T.contextMenuOptions.target.type!==t.contextMenuTargetTypes.AREA&&(void 0===i||!0!==i.isAggregatedBand)&&e.bands.length>1},this._processAreaMouseDown=(e,i,n)=>{const s=n.target,a=$(s).parent()?$(s).parent()[0]:void 0;if(s.classList.contains("idvcgrid_widget")){if(s.classList.contains("idvcgrid_expand_collapse")){let r=e.bands.find((e=>e.uid===s.id)).expandedLimit>0?t.collapseAllValue:t.defaultTopValue;r=n.shiftKey?t.expandAllValue:r,this.processCollapseExpand(s.id,i,e,r,a)}n.preventDefault(),n.stopPropagation()}},this.processCollapseExpand=(e,i,n,s,a)=>{const r=n.bands.find((t=>t.uid===e));if(r&&!1===r.isAggregatedBand)this.handleCollapseExpandForBand(r,i,n,s,a);else if(r&&void 0!==r.parentUid){const e=n.bands.find((e=>e.uid===r.parentUid));e&&(void 0!==s&&s!==t.expandAllValue&&(s+=e.expandedLimit),this.handleCollapseExpandForBand(e,i,n,s,void 0,t.timelineRequest.expand))}},this.handleCollapseExpandForBand=(e,i,n,s,a,r)=>{i.requestInProgress=i.requestInProgress||new Map,i.requestInProgress.get(e.uid)||(r=r||function(e,i){return void 0===i?e!==t.collapseAllValue?t.timelineRequest.collapse:t.timelineRequest.expand:(e>i||e===t.expandAllValue)&&i!==t.expandAllValue?t.timelineRequest.collapse:t.timelineRequest.expand}(e.expandedLimit,s),i.requestInProgress.set(e.uid,{requestType:r,directChildLimit:s,currentDirectChildCount:e.expandedLimit}),M.collapseExpand(e,n,s,r).then((e=>this._handleExpansionInfo(e,a,n,i))).finally((()=>i.requestInProgress.delete(e.uid))))},this._handleExpansionInfo=(e,t,i,n)=>{if(e.insertCount>0&&n.insertBands(e.bandIndex,e.insertCount),e.removeCount>0){const t=e.insertCount?e.bandIndex+e.insertCount:e.bandIndex;n.removeBands(t,e.removeCount)}if(this.timelineView.refreshTransitionsGraph(n),t){const n=i.bands[e.captionIndex];this.timelineView.applyBandCaption(i,t,n)}}}function O(e){return e.classList.contains("idvc_timeline_ctrl_band_graph")||e.classList.contains("hierarchical_canvas_container")||e.classList.contains("main_canvas_container")}function C(e){return e.classList.contains("idvc_timeline_ctrl_band_caption")}v.prototype.init=function(e,t,i,n){n&&(this._idvcTimeline=e,this._idvcUtils=t,this._idvcDataUtils=i,this._metadata=n,this._parentElement.offsetParent?this._createTimeline():this._needRefreshView=!0)},require(["timeline_ctrl","utils","data_utils"],((e,t,i)=>{M.refreshMetadata=n=>{R.init(e,t,i,n)},T.externalInitializationComplete&&T.externalInitializationComplete.resolve()}))}}}]);
"use strict";angular.module("timelinepane").controller("TimelineTooltipController",["$scope","textFormat","constants",function(t,e,n){const r=t.localizedMessages;function i(e,n){return t.timelineRuler.formatTimeInRulerUnitsOfMeasure(e,n)}t.postfixDict={second:" /sec"},t.tooltipEntryLimit=n.tooltipEntryLimit,t.formatSerieValue=function(t,n){return`${n?t.key+": ":""}${e(t.format,"",t.percentBase)(t.value)}`},t.formatTinySerieValue=function(t,n){return e(t.format,"",t.percentBase)(n)},t.getAllTooltipLayers=function(){return(t.tooltip.layers||[]).concat(t.tooltip.globalLayers||[])},t.getIntervalAttribute=function(t,e){return`${t}: ${e}`},t.getIntervalDuration=function(e){return`${r.startLabel}: ${i(e.start)} ${r.durationLabel}: ${n=e.duration,t.timelineRuler.formatDurationInRulerTimeScale(n)}`;var n},t.getLayerSummary=function(e){return`${t.tooltipEntryLimit} ${r.outOfLabel} ${e.totalCount} ${e.name} ${r.itemsShownLabel}`},t.getTooltipEntries=function(e){return e.slice(0,t.tooltipEntryLimit)},t.getTransitionBandInfo=function(t){return`${t.startBand} ${r.toLabel} ${t.endBand}`},t.getTransitionMetrics=function(t){return`(${i(t.start)} ${r.toLabel} ${i(t.end)})`},t.isIntervalLayer=function(t){const e=t.type.split(n.layerTypes.DELIMITER);return e.includes(n.layerTypes.INTERVAL_LAYER)||e.includes(n.layerTypes.HIERARCHICAL_INTERVALS)||e.includes(n.layerTypes.FRAME_LAYER)||e.includes(n.layerTypes.EVENT_MARKER_LAYER)||e.includes(n.layerTypes.GLOBAL_CROSS_LINE)},t.isOvertimeLayer=function(t){return t.type===n.layerTypes.OVERTIME_LAYER},t.isTransitionLayer=function(t){return t.type===n.layerTypes.TRANSITION_LAYER},t.shouldShowSummary=function(e){return e.totalCount>t.tooltipEntryLimit},this.hasData=function(){return(t.tooltip.globalLayers||[]).some(e)||(t.tooltip.layers||[]).some(e);function e(e){return t.isOvertimeLayer(e)&&e.series.length||t.isTransitionLayer(e)&&e.transitions.length||t.isIntervalLayer(e)&&e.intervals.length}}}]);
"use strict";angular.module("timelinepane").directive("timelineTooltip",(function(){return{restrict:"E",replace:!0,template:'<div class="timeline-tooltip"><div class="tooltip-band-caption" ng-if="::tooltip.name.length"><label>{{::tooltip.name}}</label></div><div class="tooltip-layer-block" ng-repeat="layer in getAllTooltipLayers()"><div class="interval" ng-if="::isIntervalLayer(layer)"><div class="interval-tooltip" ng-repeat="interval in getTooltipEntries(layer.intervals)"><div class="layer-name" ng-if="::layer.name.length"><label>{{::layer.name}}</label></div><div class="interval-duration"><label>{{::getIntervalDuration(interval)}}</label></div><div class="interval-attributes" ng-repeat="attribute in interval.attributes"><label>{{::getIntervalAttribute(attribute.key, attribute.value)}}</label></div></div><div class="interval-summary" ng-if="::shouldShowSummary(layer)"><label>{{::getLayerSummary(layer)}}</label></div></div><div class="overtime" ng-if="::isOvertimeLayer(layer)"><div class="layer-name" ng-if="::(layer.name.length && layer.series.length)"><label>{{::layer.name}}</label></div><div class="non-tiny-mode" ng-if="::(!isSuperTinyMode)"><div class="overtime-tooltip" ng-repeat="serie in layer.series"><label ng-if="::(layer.name === serie.key)">{{::formatSerieValue(serie, false)}}</label> <label ng-if="::(layer.name !== serie.key)">{{::formatSerieValue(serie, true)}}</label> <label ng-if="::serie.postfix">{{::postfixDict[serie.postfix]}}</label></div></div><div class="super-tiny-mode" ng-if="::isSuperTinyMode"><div class="overtime-tooltip" ng-repeat="band in layer.bands"><label>{{::band.name}}:</label><div class="overtime-tooltip" ng-repeat="serie in band.series"><label>{{::formatTinySerieValue(layer.series[$index], serie.value)}}</label></div></div><div class="supertiny-tooltip-summary" ng-if="::shouldShowSummary(layer)"><label>{{::getLayerSummary(layer)}}</label></div></div></div><div class="transition" ng-if="::isTransitionLayer(layer)"><div class="transition-tooltip" ng-repeat="transition in getTooltipEntries(layer.intervals)"><div class="layer-name" ng-if="::layer.name.length"><label>{{::layer.name}}</label></div><label>{{::getTransitionBandInfo(transition)}}</label> <label>{{::getTransitionMetrics(transition)}}</label><div class="transition-attributes" ng-repeat="attribute in transition.attributes"><label>{{::getIntervalAttribute(attribute.key, attribute.value)}}</label></div></div><div class="transition-summary" ng-if="::shouldShowSummary(layer)"><label>{{::getLayerSummary(layer)}}</label></div></div></div></div>',controller:"TimelineTooltipController",link:function(e,i,a,l){setTimeout((()=>{e.$digest(),i.length&&l.hasData()&&e.showTooltip(i[0].innerHTML),e.$destroy()}),0)}}}));
//# sourceMappingURL=timelinepane-631030.js.map
