/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.message.WriteTxnMarkersRequestData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.TransactionResult;
import org.apache.kafka.common.requests.WriteTxnMarkersResponse;

public class WriteTxnMarkersRequest
extends AbstractRequest {
    private final WriteTxnMarkersRequestData data;

    private WriteTxnMarkersRequest(WriteTxnMarkersRequestData data, short version) {
        super(ApiKeys.WRITE_TXN_MARKERS, version);
        this.data = data;
    }

    @Override
    public WriteTxnMarkersRequestData data() {
        return this.data;
    }

    @Override
    public WriteTxnMarkersResponse getErrorResponse(int throttleTimeMs, Throwable e) {
        Errors error = Errors.forException(e);
        HashMap<Long, Map<TopicPartition, Errors>> errors = new HashMap<Long, Map<TopicPartition, Errors>>(this.data.markers().size());
        for (WriteTxnMarkersRequestData.WritableTxnMarker markerEntry : this.data.markers()) {
            HashMap<TopicPartition, Errors> errorsPerPartition = new HashMap<TopicPartition, Errors>();
            for (WriteTxnMarkersRequestData.WritableTxnMarkerTopic topic : markerEntry.topics()) {
                for (Integer partitionIdx : topic.partitionIndexes()) {
                    errorsPerPartition.put(new TopicPartition(topic.name(), partitionIdx), error);
                }
            }
            errors.put(markerEntry.producerId(), errorsPerPartition);
        }
        return new WriteTxnMarkersResponse(errors);
    }

    public List<TxnMarkerEntry> markers() {
        ArrayList<TxnMarkerEntry> markers = new ArrayList<TxnMarkerEntry>();
        for (WriteTxnMarkersRequestData.WritableTxnMarker markerEntry : this.data.markers()) {
            ArrayList<TopicPartition> topicPartitions = new ArrayList<TopicPartition>();
            for (WriteTxnMarkersRequestData.WritableTxnMarkerTopic topic : markerEntry.topics()) {
                for (Integer partitionIdx : topic.partitionIndexes()) {
                    topicPartitions.add(new TopicPartition(topic.name(), partitionIdx));
                }
            }
            short transactionVersion = markerEntry.transactionVersion();
            markers.add(new TxnMarkerEntry(markerEntry.producerId(), markerEntry.producerEpoch(), markerEntry.coordinatorEpoch(), TransactionResult.forId(markerEntry.transactionResult()), topicPartitions, transactionVersion));
        }
        return markers;
    }

    public static WriteTxnMarkersRequest parse(Readable readable, short version) {
        return new WriteTxnMarkersRequest(new WriteTxnMarkersRequestData(readable, version), version);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WriteTxnMarkersRequest that = (WriteTxnMarkersRequest)o;
        return Objects.equals(this.data, that.data);
    }

    public int hashCode() {
        return Objects.hash(this.data);
    }

    public static class TxnMarkerEntry {
        private final long producerId;
        private final short producerEpoch;
        private final int coordinatorEpoch;
        private final TransactionResult result;
        private final List<TopicPartition> partitions;
        private final short transactionVersion;

        public TxnMarkerEntry(long producerId, short producerEpoch, int coordinatorEpoch, TransactionResult result, List<TopicPartition> partitions, short transactionVersion) {
            this.producerId = producerId;
            this.producerEpoch = producerEpoch;
            this.coordinatorEpoch = coordinatorEpoch;
            this.result = result;
            this.partitions = partitions;
            this.transactionVersion = transactionVersion;
        }

        public long producerId() {
            return this.producerId;
        }

        public short producerEpoch() {
            return this.producerEpoch;
        }

        public int coordinatorEpoch() {
            return this.coordinatorEpoch;
        }

        public TransactionResult transactionResult() {
            return this.result;
        }

        public List<TopicPartition> partitions() {
            return this.partitions;
        }

        public short transactionVersion() {
            return this.transactionVersion;
        }

        public String toString() {
            return "TxnMarkerEntry{producerId=" + this.producerId + ", producerEpoch=" + this.producerEpoch + ", coordinatorEpoch=" + this.coordinatorEpoch + ", result=" + String.valueOf((Object)this.result) + ", partitions=" + String.valueOf(this.partitions) + ", transactionVersion=" + this.transactionVersion + "}";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TxnMarkerEntry that = (TxnMarkerEntry)o;
            return this.producerId == that.producerId && this.producerEpoch == that.producerEpoch && this.coordinatorEpoch == that.coordinatorEpoch && this.result == that.result && this.transactionVersion == that.transactionVersion && Objects.equals(this.partitions, that.partitions);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.producerId, this.producerEpoch, this.coordinatorEpoch, this.result, this.partitions, this.transactionVersion});
        }
    }

    public static class Builder
    extends AbstractRequest.Builder<WriteTxnMarkersRequest> {
        public final WriteTxnMarkersRequestData data;

        public Builder(WriteTxnMarkersRequestData data) {
            super(ApiKeys.WRITE_TXN_MARKERS);
            this.data = data;
        }

        public Builder(List<TxnMarkerEntry> markers) {
            super(ApiKeys.WRITE_TXN_MARKERS);
            ArrayList<WriteTxnMarkersRequestData.WritableTxnMarker> dataMarkers = new ArrayList<WriteTxnMarkersRequestData.WritableTxnMarker>();
            for (TxnMarkerEntry marker : markers) {
                HashMap<String, WriteTxnMarkersRequestData.WritableTxnMarkerTopic> topicMap = new HashMap<String, WriteTxnMarkersRequestData.WritableTxnMarkerTopic>();
                for (TopicPartition topicPartition : marker.partitions) {
                    WriteTxnMarkersRequestData.WritableTxnMarkerTopic topic = topicMap.getOrDefault(topicPartition.topic(), new WriteTxnMarkersRequestData.WritableTxnMarkerTopic().setName(topicPartition.topic()));
                    topic.partitionIndexes().add(topicPartition.partition());
                    topicMap.put(topicPartition.topic(), topic);
                }
                WriteTxnMarkersRequestData.WritableTxnMarker writableMarker = new WriteTxnMarkersRequestData.WritableTxnMarker().setProducerId(marker.producerId).setProducerEpoch(marker.producerEpoch).setCoordinatorEpoch(marker.coordinatorEpoch).setTransactionResult(marker.transactionResult().id).setTopics(new ArrayList<WriteTxnMarkersRequestData.WritableTxnMarkerTopic>(topicMap.values()));
                writableMarker.setTransactionVersion((byte)marker.transactionVersion);
                dataMarkers.add(writableMarker);
            }
            this.data = new WriteTxnMarkersRequestData().setMarkers(dataMarkers);
        }

        @Override
        public WriteTxnMarkersRequest build(short version) {
            return new WriteTxnMarkersRequest(this.data, version);
        }
    }
}

