/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.execution.serviceView;

import com.intellij.concurrency.ConcurrentCollectionFactory;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.services.ServiceEventListener;
import com.intellij.execution.services.ServiceViewContributor;
import com.intellij.execution.services.ServiceViewDescriptor;
import com.intellij.execution.services.ServiceViewLocatableDescriptor;
import com.intellij.execution.services.ServiceViewManager;
import com.intellij.execution.services.ServiceViewNonActivatingDescriptor;
import com.intellij.execution.services.ServiceViewToolWindowDescriptor;
import com.intellij.execution.services.ServiceViewToolWindowFactory;
import com.intellij.icons.AllIcons;
import com.intellij.ide.lightEdit.LightEditUtil;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.util.treeView.TreeState;
import com.intellij.idea.AppMode;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.UiDataProvider;
import com.intellij.openapi.application.AppUIExecutor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowContentUiType;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ex.ToolWindowEx;
import com.intellij.openapi.wm.ex.ToolWindowManagerListener;
import com.intellij.platform.execution.serviceView.ServiceModel;
import com.intellij.platform.execution.serviceView.ServiceModelFilter;
import com.intellij.platform.execution.serviceView.ServiceView;
import com.intellij.platform.execution.serviceView.ServiceViewActionProvider;
import com.intellij.platform.execution.serviceView.ServiceViewDragHelper;
import com.intellij.platform.execution.serviceView.ServiceViewHelper;
import com.intellij.platform.execution.serviceView.ServiceViewModel;
import com.intellij.platform.execution.serviceView.ServiceViewSourceScrollHelper;
import com.intellij.platform.execution.serviceView.ServiceViewState;
import com.intellij.toolWindow.InternalDecoratorImpl;
import com.intellij.ui.AppUIUtil;
import com.intellij.ui.AutoScrollToSourceHandler;
import com.intellij.ui.UIBundle;
import com.intellij.ui.components.panels.Wrapper;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.ContentManagerEvent;
import com.intellij.ui.content.ContentManagerListener;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FactoryMap;
import com.intellij.util.containers.SmartHashSet;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.swing.Icon;
import javax.swing.JComponent;
import kotlin.Unit;
import org.jdom.Element;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

@com.intellij.openapi.components.State(name="ServiceViewManager", storages={@Storage(value="$PRODUCT_WORKSPACE_FILE$")}, getStateRequiresEdt=true, defaultStateAsResource=true)
public final class ServiceViewManagerImpl
implements ServiceViewManager,
PersistentStateComponent<State> {
    @NonNls
    private static final String HELP_ID = "services.tool.window";
    private final Project myProject;
    private State myState;
    private final ServiceModel myModel;
    private final ServiceModelFilter myModelFilter;
    private final Map<String, Collection<ServiceViewContributor<?>>> myGroups;
    private final Set<ServiceViewContributor<?>> myNotInitializedContributors;
    private final List<ServiceViewContentHolder> myContentHolders;
    private boolean myActivationActionsRegistered;
    private AutoScrollToSourceHandler myAutoScrollToSourceHandler;
    private final Set<String> myActiveToolWindowIds;
    private boolean myRegisteringToolWindowAvailable;

    public ServiceViewManagerImpl(@NotNull Project project) {
        if (project == null) {
            ServiceViewManagerImpl.$$$reportNull$$$0(0);
        }
        this.myState = new State();
        this.myGroups = new ConcurrentHashMap();
        this.myNotInitializedContributors = ConcurrentHashMap.newKeySet();
        this.myContentHolders = new SmartList();
        this.myActiveToolWindowIds = new SmartHashSet();
        this.myProject = project;
        LightEditUtil.forbidServiceInLightEditMode((Project)project, this.getClass());
        this.myModel = new ServiceModel(this.myProject);
        Disposer.register((Disposable)this.myProject, (Disposable)this.myModel);
        this.myModelFilter = new ServiceModelFilter();
        this.myProject.getMessageBus().connect((Disposable)this.myModel).subscribe(ServiceEventListener.TOPIC, e -> this.myModel.handle(e).onSuccess(o -> this.eventHandled(e)));
        ServiceViewContributor.CONTRIBUTOR_EP_NAME.addExtensionPointListener((ExtensionPointListener)new ServiceViewExtensionPointListener(), (Disposable)this.myModel);
    }

    private void eventHandled(@NotNull ServiceEventListener.ServiceEvent e) {
        boolean initialized;
        String toolWindowId;
        if (e == null) {
            ServiceViewManagerImpl.$$$reportNull$$$0(1);
        }
        if ((toolWindowId = this.getToolWindowId(e.contributorClass)) == null) {
            return;
        }
        ServiceModel.ServiceViewItem eventRoot = (ServiceModel.ServiceViewItem)ContainerUtil.find(this.myModel.getRoots(), root -> e.contributorClass.isInstance(root.getRootContributor()));
        ServiceViewContributor<?> notInitializedContributor = this.findNotInitializedContributor(e.contributorClass, eventRoot);
        boolean bl = initialized = notInitializedContributor == null;
        if (!(initialized || e.type != ServiceEventListener.EventType.RESET && e.type != ServiceEventListener.EventType.UNLOAD_SYNC_RESET)) {
            this.myNotInitializedContributors.remove(notInitializedContributor);
        }
        if (eventRoot != null) {
            boolean show = !(eventRoot.getViewDescriptor() instanceof ServiceViewNonActivatingDescriptor) && initialized;
            this.updateToolWindow(toolWindowId, true, show);
        } else {
            Set<? extends ServiceViewContributor<?>> activeContributors = this.getActiveContributors();
            Collection<ServiceViewContributor<?>> toolWindowContributors = this.myGroups.get(toolWindowId);
            this.updateToolWindow(toolWindowId, ContainerUtil.intersects(activeContributors, toolWindowContributors), false);
        }
    }

    @Nullable
    private ServiceViewContributor<?> findNotInitializedContributor(Class<?> contributorClass, ServiceModel.ServiceViewItem eventRoot) {
        if (eventRoot != null) {
            return this.myNotInitializedContributors.contains(eventRoot.getRootContributor()) ? eventRoot.getRootContributor() : null;
        }
        for (ServiceViewContributor<?> contributor : this.myNotInitializedContributors) {
            if (!contributorClass.isInstance(contributor)) continue;
            return contributor;
        }
        return null;
    }

    private @Unmodifiable Set<? extends ServiceViewContributor<?>> getActiveContributors() {
        return ContainerUtil.map2Set(this.myModel.getRoots(), ServiceModel.ServiceViewItem::getRootContributor);
    }

    @Nullable
    private ServiceViewContentHolder getContentHolder(@NotNull Class<?> contributorClass) {
        if (contributorClass == null) {
            ServiceViewManagerImpl.$$$reportNull$$$0(2);
        }
        for (ServiceViewContentHolder holder : this.myContentHolders) {
            for (ServiceViewContributor<?> rootContributor : holder.rootContributors) {
                if (!contributorClass.isInstance(rootContributor)) continue;
                return holder;
            }
        }
        return null;
    }

    private void registerToolWindows(Collection<String> toolWindowIds) {
        Set<? extends ServiceViewContributor<?>> activeContributors = this.getActiveContributors();
        for (Map.Entry<String, Collection<ServiceViewContributor<?>>> entry : this.myGroups.entrySet()) {
            Collection<ServiceViewContributor<?>> contributors;
            ServiceViewContributor contributor;
            if (!toolWindowIds.contains(entry.getKey()) || (contributor = (ServiceViewContributor)ContainerUtil.getFirstItem(contributors = entry.getValue(), null)) == null) continue;
            ServiceViewToolWindowDescriptor descriptor = "Services".equals(entry.getKey()) ? ServiceViewManagerImpl.getServicesToolWindowDescriptor() : this.getContributorToolWindowDescriptor(contributor);
            this.registerToolWindow(descriptor, !Collections.disjoint(activeContributors, contributors));
        }
    }

    private void registerToolWindow(@NotNull ServiceViewToolWindowDescriptor descriptor, boolean active) {
        if (descriptor == null) {
            ServiceViewManagerImpl.$$$reportNull$$$0(3);
        }
        if (this.myProject.isDefault()) {
            return;
        }
        ToolWindowManager toolWindowManager = ToolWindowManager.getInstance((Project)this.myProject);
        toolWindowManager.invokeLater(() -> {
            String toolWindowId = descriptor.getToolWindowId();
            if (toolWindowManager.getToolWindow(toolWindowId) != null) {
                return;
            }
            if (!this.myActivationActionsRegistered && "Services".equals(toolWindowId)) {
                this.myActivationActionsRegistered = true;
                Collection<ServiceViewContributor<?>> contributors = this.myGroups.get("Services");
                if (contributors != null) {
                    ServiceViewManagerImpl.registerActivateByContributorActions(this.myProject, contributors);
                }
            }
            this.myRegisteringToolWindowAvailable = active;
            try {
                ToolWindow toolWindow = toolWindowManager.registerToolWindow(toolWindowId, builder -> {
                    builder.contentFactory = new ServiceViewToolWindowFactory();
                    builder.icon = descriptor.getToolWindowIcon();
                    builder.hideOnEmptyContent = false;
                    builder.stripeTitle = () -> descriptor.getStripeTitle();
                    return Unit.INSTANCE;
                });
                if (active) {
                    this.myActiveToolWindowIds.add(toolWindowId);
                }
                ServiceViewManagerImpl.restoreBrokenToolWindowIfNeeded(toolWindow);
            }
            finally {
                this.myRegisteringToolWindowAvailable = false;
            }
        });
    }

    @Deprecated(forRemoval=true)
    private static void restoreBrokenToolWindowIfNeeded(@NotNull ToolWindow toolWindow) {
        if (toolWindow == null) {
            ServiceViewManagerImpl.$$$reportNull$$$0(4);
        }
        if (!toolWindow.isShowStripeButton() && toolWindow.isVisible()) {
            toolWindow.hide();
            toolWindow.show();
        }
    }

    private void updateToolWindow(@NotNull String toolWindowId, boolean active, boolean show) {
        if (toolWindowId == null) {
            ServiceViewManagerImpl.$$$reportNull$$$0(5);
        }
        if (this.myProject.isDisposed() || this.myProject.isDefault()) {
            return;
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            ToolWindow toolWindow = ToolWindowManager.getInstance((Project)this.myProject).getToolWindow(toolWindowId);
            if (toolWindow == null) {
                return;
            }
            if (active) {
                boolean doShow = show && !this.myActiveToolWindowIds.contains(toolWindowId);
                this.myActiveToolWindowIds.add(toolWindowId);
                if (doShow) {
                    toolWindow.show();
                }
            } else if (this.myActiveToolWindowIds.remove(toolWindowId)) {
                toolWindow.hide();
            }
        }, ModalityState.nonModal(), this.myProject.getDisposed());
    }

    @ApiStatus.Internal
    public boolean shouldBeAvailable() {
        return this.myRegisteringToolWindowAvailable;
    }

    @ApiStatus.Internal
    public void createToolWindowContent(@NotNull ToolWindow toolWindow) {
        String toolWindowId;
        Collection<ServiceViewContributor<?>> contributors;
        if (toolWindow == null) {
            ServiceViewManagerImpl.$$$reportNull$$$0(6);
        }
        if ((contributors = this.myGroups.get(toolWindowId = toolWindow.getId())) == null) {
            return;
        }
        if (this.myAutoScrollToSourceHandler == null) {
            this.myAutoScrollToSourceHandler = ServiceViewSourceScrollHelper.createAutoScrollToSourceHandler(this.myProject);
        }
        ToolWindowEx toolWindowEx = (ToolWindowEx)toolWindow;
        ServiceViewSourceScrollHelper.installAutoScrollSupport(this.myProject, toolWindowEx, this.myAutoScrollToSourceHandler);
        Pair<ServiceViewState, List<ServiceViewState>> states = this.getServiceViewStates(toolWindowId);
        ServiceViewModel.AllServicesModel mainModel = new ServiceViewModel.AllServicesModel(this.myModel, this.myModelFilter, contributors);
        ServiceView mainView = ServiceView.createView(this.myProject, mainModel, this.prepareViewState((ServiceViewState)states.first));
        mainView.setAutoScrollToSourceHandler(this.myAutoScrollToSourceHandler);
        ContentManager contentManager = toolWindow.getContentManager();
        Wrapper toolWindowHeaderSideComponent = ServiceViewManagerImpl.setToolWindowHeaderSideComponent(toolWindowEx, contentManager);
        final ServiceViewContentHolder holder = new ServiceViewContentHolder(mainView, contentManager, contributors, toolWindowId, toolWindowHeaderSideComponent);
        this.myContentHolders.add(holder);
        contentManager.addContentManagerListener((ContentManagerListener)new ServiceViewContentMangerListener(this.myModelFilter, this.myAutoScrollToSourceHandler, holder));
        this.myProject.getMessageBus().connect((Disposable)contentManager).subscribe(ToolWindowManagerListener.TOPIC, (Object)new ToolWindowManagerListener(){

            public void stateChanged(@NotNull ToolWindowManager toolWindowManager, @NotNull ToolWindow toolWindow, @NotNull ToolWindowManagerListener.ToolWindowManagerEventType changeType) {
                if (toolWindowManager == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (toolWindow == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (changeType == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (!toolWindowId.equals(toolWindow.getId())) {
                    return;
                }
                if (changeType == ToolWindowManagerListener.ToolWindowManagerEventType.SetSideToolAndAnchor) {
                    boolean verticalSplit = !toolWindow.getAnchor().isHorizontal();
                    for (Content content : holder.contentManager.getContents()) {
                        ServiceView serviceView = ServiceViewManagerImpl.getServiceView(content);
                        if (serviceView == null) continue;
                        serviceView.getUi().setSplitOrientation(verticalSplit);
                    }
                    return;
                }
                if (changeType == ToolWindowManagerListener.ToolWindowManagerEventType.SetContentUiType) {
                    ServiceViewManagerImpl.updateNavBar(holder);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "toolWindowManager";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "toolWindow";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "changeType";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/platform/execution/serviceView/ServiceViewManagerImpl$1";
                objectArray[2] = "stateChanged";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        ServiceViewManagerImpl.addMainContent(toolWindow.getContentManager(), mainView);
        ServiceViewDragHelper.installDnDSupport(this.myProject, toolWindowEx.getDecorator(), contentManager);
    }

    private static Wrapper setToolWindowHeaderSideComponent(ToolWindowEx toolWindowEx, ContentManager contentManager) {
        if (!Registry.is((String)"ide.services.tool.window.header.nav.bar", (boolean)true) || AppMode.isRemoteDevHost()) {
            return null;
        }
        InternalDecoratorImpl decorator = (InternalDecoratorImpl)ObjectUtils.tryCast((Object)toolWindowEx.getDecorator(), InternalDecoratorImpl.class);
        if (decorator == null) {
            return null;
        }
        Wrapper wrapper = new Wrapper();
        decorator.getHeader().setSideComponent(UiDataProvider.wrapComponent((JComponent)wrapper, sink -> {
            Content content = contentManager.getSelectedContent();
            ServiceView serviceView = content == null ? null : ServiceViewManagerImpl.getServiceView(content);
            DataSink.uiDataSnapshot((DataSink)sink, (Object)serviceView);
        }));
        return wrapper;
    }

    private static void updateNavBar(ServiceViewContentHolder holder) {
        ServiceView serviceView;
        Wrapper wrapper = holder.toolWindowHeaderSideComponent;
        if (wrapper == null) {
            return;
        }
        ToolWindow toolWindow = ToolWindowManager.getInstance((Project)holder.mainView.getProject()).getToolWindow(holder.toolWindowId);
        if (toolWindow == null) {
            return;
        }
        Content content = holder.contentManager.getSelectedContent();
        ServiceView serviceView2 = serviceView = content == null ? null : ServiceViewManagerImpl.getServiceView(content);
        if (serviceView == null) {
            wrapper.setContent(null);
        } else {
            boolean isSideComponent;
            ToolWindowContentUiType type = toolWindow.getContentUiType();
            boolean bl = isSideComponent = type == ToolWindowContentUiType.COMBO || holder.contentManager.getContentCount() == 1;
            if (isSideComponent) {
                JComponent navBar = serviceView.getUi().updateNavBar(isSideComponent);
                wrapper.setContent(navBar);
            } else {
                wrapper.setContent(null);
                serviceView.getUi().updateNavBar(isSideComponent);
            }
        }
    }

    private static void addMainContent(ContentManager contentManager, ServiceView mainView) {
        Content mainContent = ContentFactory.getInstance().createContent((JComponent)mainView, null, false);
        mainContent.putUserData(ToolWindow.SHOW_CONTENT_ICON, (Object)Boolean.TRUE);
        mainContent.setHelpId(ServiceViewManagerImpl.getToolWindowContextHelpId());
        mainContent.setCloseable(false);
        Disposer.register((Disposable)mainContent, (Disposable)mainView);
        Disposer.register((Disposable)mainContent, (Disposable)mainView.getModel());
        contentManager.addContent(mainContent);
        mainView.getModel().addModelListener(() -> {
            boolean isEmpty = mainView.getModel().getRoots().isEmpty();
            ((AppUIExecutor)AppUIExecutor.onUiThread().expireWith((Disposable)contentManager)).submit(() -> {
                if (isEmpty) {
                    if (contentManager.getIndexOfContent(mainContent) < 0) {
                        if (contentManager.getContentCount() == 0) {
                            contentManager.addContent(mainContent, 0);
                        }
                    } else if (contentManager.getContentCount() > 1) {
                        contentManager.removeContent(mainContent, false);
                    }
                } else if (contentManager.getIndexOfContent(mainContent) < 0) {
                    contentManager.addContent(mainContent, 0);
                }
            });
        });
    }

    private void loadViews(ContentManager contentManager, ServiceView mainView, Collection<? extends ServiceViewContributor<?>> contributors, List<ServiceViewState> viewStates) {
        this.myModel.getInvoker().invokeLater(() -> {
            Map contributorsMap = FactoryMap.create(className -> {
                for (ServiceViewContributor contributor : contributors) {
                    if (!className.equals(contributor.getClass().getName())) continue;
                    return contributor;
                }
                return null;
            });
            ArrayList<ServiceModelFilter.ServiceViewFilter> filters = new ArrayList<ServiceModelFilter.ServiceViewFilter>();
            ArrayList<Pair> loadedModels = new ArrayList<Pair>();
            ServiceViewModel toSelect = null;
            for (ServiceViewState viewState : viewStates) {
                ServiceModelFilter.ServiceViewFilter parentFilter = mainView.getModel().getFilter();
                if (viewState.parentView >= 0 && viewState.parentView < filters.size()) {
                    parentFilter = (ServiceModelFilter.ServiceViewFilter)filters.get(viewState.parentView);
                }
                ServiceModelFilter.ServiceViewFilter filter = parentFilter;
                ServiceViewModel viewModel = ServiceViewModel.loadModel(viewState, this.myModel, this.myModelFilter, parentFilter, contributorsMap);
                if (viewModel != null) {
                    loadedModels.add(Pair.create((Object)viewModel, (Object)viewState));
                    if (viewState.isSelected) {
                        toSelect = viewModel;
                    }
                    filter = viewModel.getFilter();
                }
                filters.add(filter);
            }
            if (!loadedModels.isEmpty()) {
                ServiceViewModel modelToSelect = toSelect;
                ((AppUIExecutor)AppUIExecutor.onUiThread().expireWith((Disposable)contentManager)).submit(() -> {
                    for (Pair pair : loadedModels) {
                        this.extract(contentManager, (ServiceViewModel)pair.first, (ServiceViewState)pair.second, false);
                    }
                    ServiceViewManagerImpl.selectContentByModel(contentManager, modelToSelect);
                });
            }
        });
    }

    @NotNull
    public Promise<Void> select(@NotNull Object service, @NotNull Class<?> contributorClass, boolean activate, boolean focus) {
        if (service == null) {
            ServiceViewManagerImpl.$$$reportNull$$$0(7);
        }
        if (contributorClass == null) {
            ServiceViewManagerImpl.$$$reportNull$$$0(8);
        }
        Promise promise = this.trackingSelect(service, contributorClass, activate, focus).then(result -> null);
        if (promise == null) {
            ServiceViewManagerImpl.$$$reportNull$$$0(9);
        }
        return promise;
    }

    @NotNull
    public Promise<Boolean> trackingSelect(@NotNull Object service, @NotNull Class<?> contributorClass, boolean activate, boolean focus) {
        if (service == null) {
            ServiceViewManagerImpl.$$$reportNull$$$0(10);
        }
        if (contributorClass == null) {
            ServiceViewManagerImpl.$$$reportNull$$$0(11);
        }
        if (!this.myState.selectActiveService) {
            if (activate) {
                String toolWindowId = this.getToolWindowId(contributorClass);
                if (toolWindowId == null) {
                    Promise promise = Promises.rejectedPromise((String)"Contributor group not found");
                    if (promise == null) {
                        ServiceViewManagerImpl.$$$reportNull$$$0(12);
                    }
                    return promise;
                }
                ToolWindowManager.getInstance((Project)this.myProject).invokeLater(() -> {
                    ToolWindow toolWindow = ToolWindowManager.getInstance((Project)this.myProject).getToolWindow(toolWindowId);
                    if (toolWindow != null) {
                        toolWindow.activate(null, focus, focus);
                    }
                });
            }
            Promise promise = this.expand(service, contributorClass).then(o -> false);
            if (promise == null) {
                ServiceViewManagerImpl.$$$reportNull$$$0(13);
            }
            return promise;
        }
        Promise promise = this.doSelect(service, contributorClass, activate, focus).then(o -> true);
        if (promise == null) {
            ServiceViewManagerImpl.$$$reportNull$$$0(14);
        }
        return promise;
    }

    @NotNull
    private Promise<Void> doSelect(@NotNull Object service, @NotNull Class<?> contributorClass, boolean activate, boolean focus) {
        if (service == null) {
            ServiceViewManagerImpl.$$$reportNull$$$0(15);
        }
        if (contributorClass == null) {
            ServiceViewManagerImpl.$$$reportNull$$$0(16);
        }
        AsyncPromise result = new AsyncPromise();
        this.myModel.getInvoker().invoke(() -> AppUIUtil.invokeLaterIfProjectAlive((Project)this.myProject, () -> {
            ToolWindow toolWindow;
            String toolWindowId = this.getToolWindowId(contributorClass);
            if (toolWindowId == null) {
                result.setError("Contributor group not found");
                return;
            }
            Runnable runnable = () -> this.promiseFindView(contributorClass, (AsyncPromise<Void>)result, serviceView -> serviceView.select(service, contributorClass), content -> ServiceViewManagerImpl.selectContent(content, focus, this.myProject));
            ToolWindow toolWindow2 = toolWindow = activate ? ToolWindowManager.getInstance((Project)this.myProject).getToolWindow(toolWindowId) : null;
            if (toolWindow != null) {
                toolWindow.activate(runnable, focus, focus);
            } else {
                runnable.run();
            }
        }));
        AsyncPromise asyncPromise = result;
        if (asyncPromise == null) {
            ServiceViewManagerImpl.$$$reportNull$$$0(17);
        }
        return asyncPromise;
    }

    private void promiseFindView(Class<?> contributorClass, AsyncPromise<Void> result, Function<? super ServiceView, ? extends Promise<?>> action, Consumer<? super Content> onSuccess) {
        ServiceViewContentHolder holder = this.getContentHolder(contributorClass);
        if (holder == null) {
            result.setError("Content manager not initialized");
            return;
        }
        SmartList contents = new SmartList((Object[])holder.contentManager.getContents());
        if (contents.isEmpty()) {
            result.setError("Content not initialized");
            return;
        }
        Collections.reverse(contents);
        ServiceViewManagerImpl.promiseFindView(contents.iterator(), result, action, onSuccess);
    }

    private static void promiseFindView(Iterator<? extends Content> iterator, AsyncPromise<Void> result, Function<? super ServiceView, ? extends Promise<?>> action, Consumer<? super Content> onSuccess) {
        Content content = iterator.next();
        ServiceView serviceView = ServiceViewManagerImpl.getServiceView(content);
        if (serviceView == null || content.getManager() == null) {
            if (iterator.hasNext()) {
                ServiceViewManagerImpl.promiseFindView(iterator, result, action, onSuccess);
            } else {
                result.setError("Not services content");
            }
            return;
        }
        action.apply(serviceView).onSuccess(v -> {
            if (onSuccess != null) {
                onSuccess.accept(content);
            }
            result.setResult(null);
        }).onError(e -> {
            if (iterator.hasNext()) {
                ((AppUIExecutor)AppUIExecutor.onUiThread().expireWith((Disposable)serviceView.getProject())).submit(() -> ServiceViewManagerImpl.promiseFindView(iterator, result, action, onSuccess));
            } else {
                result.setError(e);
            }
        });
    }

    private static void selectContent(Content content, boolean focus, Project project) {
        ((AppUIExecutor)AppUIExecutor.onUiThread().expireWith((Disposable)content)).submit(() -> {
            ContentManager contentManager = content.getManager();
            if (contentManager == null) {
                return;
            }
            if (contentManager.getSelectedContent() != content && contentManager.getIndexOfContent(content) >= 0) {
                contentManager.setSelectedContent(content, focus);
            }
        });
    }

    @NotNull
    public Promise<Void> expand(@NotNull Object service, @NotNull Class<?> contributorClass) {
        if (service == null) {
            ServiceViewManagerImpl.$$$reportNull$$$0(18);
        }
        if (contributorClass == null) {
            ServiceViewManagerImpl.$$$reportNull$$$0(19);
        }
        AsyncPromise result = new AsyncPromise();
        this.myModel.getInvoker().invoke(() -> AppUIUtil.invokeLaterIfProjectAlive((Project)this.myProject, () -> this.promiseFindView(contributorClass, (AsyncPromise<Void>)result, serviceView -> serviceView.expand(service, contributorClass), null)));
        AsyncPromise asyncPromise = result;
        if (asyncPromise == null) {
            ServiceViewManagerImpl.$$$reportNull$$$0(20);
        }
        return asyncPromise;
    }

    @NotNull
    public Promise<Void> extract(@NotNull Object service, @NotNull Class<?> contributorClass) {
        if (service == null) {
            ServiceViewManagerImpl.$$$reportNull$$$0(21);
        }
        if (contributorClass == null) {
            ServiceViewManagerImpl.$$$reportNull$$$0(22);
        }
        AsyncPromise result = new AsyncPromise();
        this.myModel.getInvoker().invoke(() -> AppUIUtil.invokeLaterIfProjectAlive((Project)this.myProject, () -> this.promiseFindView(contributorClass, (AsyncPromise<Void>)result, serviceView -> serviceView.extract(service, contributorClass), null)));
        AsyncPromise asyncPromise = result;
        if (asyncPromise == null) {
            ServiceViewManagerImpl.$$$reportNull$$$0(23);
        }
        return asyncPromise;
    }

    void select(@NotNull VirtualFile virtualFile) {
        if (virtualFile == null) {
            ServiceViewManagerImpl.$$$reportNull$$$0(24);
        }
        SmartList selectedItems = new SmartList();
        for (ServiceViewContentHolder contentHolder : this.myContentHolders) {
            ServiceView serviceView;
            Content content = contentHolder.contentManager.getSelectedContent();
            if (content == null || (serviceView = ServiceViewManagerImpl.getServiceView(content)) == null) continue;
            List<ServiceModel.ServiceViewItem> items = serviceView.getSelectedItems();
            ContainerUtil.addIfNotNull((Collection)selectedItems, (Object)((ServiceModel.ServiceViewItem)ContainerUtil.getOnlyItem(items)));
        }
        ServiceViewHelper.getInstance(this.myProject).findServices(virtualFile, arg_0 -> this.lambda$select$35(virtualFile, (List)selectedItems, arg_0));
    }

    void extract(@NotNull ServiceViewDragHelper.ServiceViewDragBean dragBean) {
        List<ServiceModel.ServiceViewItem> items;
        if (dragBean == null) {
            ServiceViewManagerImpl.$$$reportNull$$$0(25);
        }
        if ((items = dragBean.getItems()).isEmpty()) {
            return;
        }
        ServiceView serviceView = dragBean.getServiceView();
        ServiceViewContentHolder holder = this.getContentHolder(serviceView);
        if (holder == null) {
            return;
        }
        ServiceModelFilter.ServiceViewFilter parentFilter = serviceView.getModel().getFilter();
        ServiceViewModel viewModel = ServiceViewModel.createModel(items, dragBean.getContributor(), this.myModel, this.myModelFilter, parentFilter);
        ServiceViewState state = new ServiceViewState();
        serviceView.saveState(state);
        this.extract(holder.contentManager, viewModel, state, true);
    }

    private void extract(ContentManager contentManager, ServiceViewModel viewModel, ServiceViewState viewState, boolean select) {
        ServiceView serviceView = ServiceView.createView(this.myProject, viewModel, this.prepareViewState(viewState));
        ItemPresentation presentation = ServiceViewManagerImpl.getContentPresentation(this.myProject, viewModel, viewState);
        if (presentation == null) {
            return;
        }
        Content content = ServiceViewManagerImpl.addServiceContent(contentManager, serviceView, presentation, select);
        if (viewModel instanceof ServiceViewModel.GroupModel) {
            ServiceViewManagerImpl.extractGroup((ServiceViewModel.GroupModel)viewModel, content);
        } else if (viewModel instanceof ServiceViewModel.SingeServiceModel) {
            this.extractService((ServiceViewModel.SingeServiceModel)viewModel, content);
        } else if (viewModel instanceof ServiceViewModel.ServiceListModel) {
            ServiceViewManagerImpl.extractList((ServiceViewModel.ServiceListModel)viewModel, content);
        }
    }

    private static void extractGroup(ServiceViewModel.GroupModel viewModel, Content content) {
        viewModel.addModelListener(() -> ServiceViewManagerImpl.updateContentTab(viewModel.getGroup(), content));
        ServiceViewManagerImpl.updateContentTab(viewModel.getGroup(), content);
    }

    private void extractService(ServiceViewModel.SingeServiceModel viewModel, Content content) {
        ContentManager contentManager = content.getManager();
        viewModel.addModelListener(() -> {
            ServiceModel.ServiceViewItem item = viewModel.getService();
            if (item != null && !viewModel.getChildren(item).isEmpty() && contentManager != null) {
                ((AppUIExecutor)AppUIExecutor.onUiThread().expireWith((Disposable)contentManager)).submit(() -> {
                    ServiceModel.ServiceViewItem viewItem = viewModel.getService();
                    if (viewItem == null) {
                        return;
                    }
                    int index = contentManager.getIndexOfContent(content);
                    if (index < 0) {
                        return;
                    }
                    contentManager.removeContent(content, true);
                    ServiceViewModel.ServiceListModel listModel = new ServiceViewModel.ServiceListModel(this.myModel, this.myModelFilter, (List<ServiceModel.ServiceViewItem>)new SmartList((Object)viewItem), viewModel.getFilter().getParent());
                    ServiceView listView = ServiceView.createView(this.myProject, listModel, this.prepareViewState(new ServiceViewState()));
                    Content listContent = ServiceViewManagerImpl.addServiceContent(contentManager, listView, viewItem.getViewDescriptor().getContentPresentation(), true, index);
                    ServiceViewManagerImpl.extractList(listModel, listContent);
                });
            } else {
                ServiceViewManagerImpl.updateContentTab(item, content);
            }
        });
        ServiceViewManagerImpl.updateContentTab(viewModel.getService(), content);
    }

    private static void extractList(ServiceViewModel.ServiceListModel viewModel, Content content) {
        viewModel.addModelListener(() -> ServiceViewManagerImpl.updateContentTab((ServiceModel.ServiceViewItem)ContainerUtil.getOnlyItem(viewModel.getRoots()), content));
        ServiceViewManagerImpl.updateContentTab((ServiceModel.ServiceViewItem)ContainerUtil.getOnlyItem(viewModel.getRoots()), content);
    }

    private static ItemPresentation getContentPresentation(Project project, ServiceViewModel viewModel, ServiceViewState viewState) {
        if (viewModel instanceof ServiceViewModel.ContributorModel) {
            return ((ServiceViewModel.ContributorModel)viewModel).getContributor().getViewDescriptor(project).getContentPresentation();
        }
        if (viewModel instanceof ServiceViewModel.GroupModel) {
            return ((ServiceViewModel.GroupModel)viewModel).getGroup().getViewDescriptor().getContentPresentation();
        }
        if (viewModel instanceof ServiceViewModel.SingeServiceModel) {
            return ((ServiceViewModel.SingeServiceModel)viewModel).getService().getViewDescriptor().getContentPresentation();
        }
        if (viewModel instanceof ServiceViewModel.ServiceListModel) {
            List<ServiceModel.ServiceViewItem> items = ((ServiceViewModel.ServiceListModel)viewModel).getItems();
            if (items.size() == 1) {
                return items.get(0).getViewDescriptor().getContentPresentation();
            }
            String name = viewState.id;
            if (StringUtil.isEmpty((String)name) && StringUtil.isEmpty((String)(name = Messages.showInputDialog((Project)project, (String)ExecutionBundle.message((String)"service.view.group.label", (Object[])new Object[0]), (String)ExecutionBundle.message((String)"service.view.group.title", (Object[])new Object[0]), null, null, null)))) {
                return null;
            }
            return new PresentationData(name, null, AllIcons.Nodes.Folder, null);
        }
        return null;
    }

    private static Content addServiceContent(ContentManager contentManager, ServiceView serviceView, ItemPresentation presentation, boolean select) {
        return ServiceViewManagerImpl.addServiceContent(contentManager, serviceView, presentation, select, -1);
    }

    private static Content addServiceContent(ContentManager contentManager, ServiceView serviceView, ItemPresentation presentation, boolean select, int index) {
        Content content = ContentFactory.getInstance().createContent((JComponent)serviceView, ServiceViewDragHelper.getDisplayName(presentation), false);
        content.putUserData(ToolWindow.SHOW_CONTENT_ICON, (Object)Boolean.TRUE);
        content.setHelpId(ServiceViewManagerImpl.getToolWindowContextHelpId());
        content.setCloseable(true);
        content.setIcon(presentation.getIcon(false));
        Disposer.register((Disposable)content, (Disposable)serviceView);
        Disposer.register((Disposable)content, (Disposable)serviceView.getModel());
        contentManager.addContent(content, index);
        if (select) {
            contentManager.setSelectedContent(content);
        }
        return content;
    }

    private static void updateContentTab(ServiceModel.ServiceViewItem item, Content content) {
        if (item != null) {
            WeakReference<ServiceModel.ServiceViewItem> itemRef = new WeakReference<ServiceModel.ServiceViewItem>(item);
            ((AppUIExecutor)AppUIExecutor.onUiThread().expireWith((Disposable)content)).submit(() -> {
                ServiceModel.ServiceViewItem viewItem = (ServiceModel.ServiceViewItem)itemRef.get();
                if (viewItem == null) {
                    return;
                }
                ItemPresentation itemPresentation = viewItem.getViewDescriptor().getContentPresentation();
                content.setDisplayName(ServiceViewDragHelper.getDisplayName(itemPresentation));
                content.setIcon(itemPresentation.getIcon(false));
                content.setTabColor(viewItem.getColor());
            });
        }
    }

    private void addToGroup(ServiceViewContributor<?> contributor) {
        String id = contributor.getViewDescriptor(this.myProject).getId();
        ServiceViewToolWindowDescriptor descriptor = this.getContributorToolWindowDescriptor(contributor);
        String toolWindowId = "Services";
        if (descriptor.isExcludedByDefault() && !this.myState.included.contains(id) || !descriptor.isExcludedByDefault() && this.myState.excluded.contains(id)) {
            toolWindowId = descriptor.getToolWindowId();
        }
        Collection contributors = this.myGroups.computeIfAbsent(toolWindowId, __ -> ConcurrentCollectionFactory.createConcurrentSet());
        contributors.add(contributor);
    }

    @NotNull
    private Pair<ServiceViewState, List<ServiceViewState>> getServiceViewStates(@NotNull String groupId) {
        if (groupId == null) {
            ServiceViewManagerImpl.$$$reportNull$$$0(26);
        }
        List states = ContainerUtil.filter(this.myState.viewStates, state -> groupId.equals(state.groupId) && !StringUtil.isEmpty((String)state.viewType));
        ServiceViewState mainState = (ServiceViewState)ContainerUtil.find(this.myState.viewStates, state -> groupId.equals(state.groupId) && StringUtil.isEmpty((String)state.viewType));
        if (mainState == null) {
            mainState = new ServiceViewState();
        }
        Pair pair = Pair.create((Object)mainState, (Object)states);
        if (pair == null) {
            ServiceViewManagerImpl.$$$reportNull$$$0(27);
        }
        return pair;
    }

    @NotNull
    public State getState() {
        List services = ContainerUtil.mapNotNull((Collection)this.myGroups.getOrDefault("Services", Collections.emptyList()), contributor -> contributor.getViewDescriptor(this.myProject).getId());
        ArrayList<String> includedByDefault = new ArrayList<String>();
        ArrayList<String> excludedByDefault = new ArrayList<String>();
        for (ServiceViewContributor contributor2 : ServiceViewContributor.CONTRIBUTOR_EP_NAME.getExtensionList()) {
            String id = contributor2.getViewDescriptor(this.myProject).getId();
            if (id == null) continue;
            if (this.getContributorToolWindowDescriptor(contributor2).isExcludedByDefault()) {
                excludedByDefault.add(id);
                continue;
            }
            includedByDefault.add(id);
        }
        this.myState.included.clear();
        this.myState.included.addAll(excludedByDefault);
        this.myState.included.retainAll(services);
        this.myState.excluded.clear();
        this.myState.excluded.addAll(includedByDefault);
        this.myState.excluded.removeAll(services);
        ContainerUtil.retainAll(this.myState.viewStates, state -> this.myGroups.containsKey(state.groupId));
        for (ServiceViewContentHolder holder : this.myContentHolders) {
            ContainerUtil.retainAll(this.myState.viewStates, state -> !holder.toolWindowId.equals(state.groupId));
            ServiceModelFilter.ServiceViewFilter mainFilter = holder.mainView.getModel().getFilter();
            ServiceViewState mainState = new ServiceViewState();
            this.myState.viewStates.add(mainState);
            holder.mainView.saveState(mainState);
            mainState.groupId = holder.toolWindowId;
            mainState.treeStateElement = new Element("root");
            mainState.treeState.writeExternal(mainState.treeStateElement);
            mainState.clearTreeState();
            SmartList processedViews = new SmartList();
            for (Content content : holder.contentManager.getContents()) {
                ServiceModelFilter.ServiceViewFilter parentFilter;
                ServiceView serviceView = ServiceViewManagerImpl.getServiceView(content);
                if (serviceView == null || ServiceViewManagerImpl.isMainView(serviceView)) continue;
                ServiceViewState viewState = new ServiceViewState();
                processedViews.add(serviceView);
                this.myState.viewStates.add(viewState);
                serviceView.saveState(viewState);
                viewState.groupId = holder.toolWindowId;
                viewState.isSelected = holder.contentManager.isSelected(content);
                ServiceViewModel viewModel = serviceView.getModel();
                if (viewModel instanceof ServiceViewModel.ServiceListModel) {
                    viewState.id = content.getDisplayName();
                }
                if ((parentFilter = viewModel.getFilter().getParent()) != null && !parentFilter.equals(mainFilter)) {
                    for (int i = 0; i < processedViews.size(); ++i) {
                        ServiceView parentView = (ServiceView)processedViews.get(i);
                        if (!parentView.getModel().getFilter().equals(parentFilter)) continue;
                        viewState.parentView = i;
                        break;
                    }
                }
                viewState.treeStateElement = new Element("root");
                viewState.treeState.writeExternal(viewState.treeStateElement);
                viewState.clearTreeState();
            }
        }
        State state2 = this.myState;
        if (state2 == null) {
            ServiceViewManagerImpl.$$$reportNull$$$0(28);
        }
        return state2;
    }

    public void loadState(@NotNull State state) {
        if (state == null) {
            ServiceViewManagerImpl.$$$reportNull$$$0(29);
        }
        ServiceViewManagerImpl.clearViewStateIfNeeded(state);
        this.myState = state;
        for (ServiceViewState viewState : this.myState.viewStates) {
            viewState.treeState = TreeState.createFrom((Element)viewState.treeStateElement);
        }
        this.loadGroups();
    }

    public void noStateLoaded() {
        if (!this.myProject.isDefault()) {
            ServiceViewManagerImpl defaultManager = (ServiceViewManagerImpl)ServiceViewManager.getInstance((Project)ProjectManager.getInstance().getDefaultProject());
            this.myState.excluded.addAll(defaultManager.myState.excluded);
            this.myState.included.addAll(defaultManager.myState.included);
        }
        this.loadGroups();
    }

    private void loadGroups() {
        for (ServiceViewContributor contributor : ServiceViewContributor.CONTRIBUTOR_EP_NAME.getExtensionList()) {
            this.addToGroup(contributor);
            this.myNotInitializedContributors.add(contributor);
        }
        this.registerToolWindows(this.myGroups.keySet());
        final Disposable disposable = Disposer.newDisposable();
        Disposer.register((Disposable)this.myProject, (Disposable)disposable);
        this.myProject.getMessageBus().connect(disposable).subscribe(ToolWindowManagerListener.TOPIC, (Object)new ToolWindowManagerListener(){

            public void toolWindowShown(@NotNull ToolWindow toolWindow) {
                String toolWindowId;
                Collection<ServiceViewContributor<?>> contributors;
                if (toolWindow == null) {
                    2.$$$reportNull$$$0(0);
                }
                if ((contributors = ServiceViewManagerImpl.this.myGroups.get(toolWindowId = toolWindow.getId())) != null) {
                    ArrayList promises = new ArrayList();
                    for (ServiceViewContributor<?> contributor : contributors) {
                        if (!ServiceViewManagerImpl.this.myNotInitializedContributors.remove(contributor)) continue;
                        ServiceEventListener.ServiceEvent e = ServiceEventListener.ServiceEvent.createResetEvent((Class)contributor.getClass());
                        promises.add(ServiceViewManagerImpl.this.myModel.handle(e));
                    }
                    Promises.all(promises).onProcessed(ignored -> ApplicationManager.getApplication().invokeLater(() -> {
                        ToolWindow tw = ToolWindowManager.getInstance((Project)ServiceViewManagerImpl.this.myProject).getToolWindow(toolWindowId);
                        if (tw == null) {
                            return;
                        }
                        Pair<ServiceViewState, List<ServiceViewState>> states = ServiceViewManagerImpl.this.getServiceViewStates(toolWindowId);
                        ContentManager contentManager = tw.getContentManager();
                        Content mainContent = ServiceViewManagerImpl.getMainContent(contentManager);
                        if (mainContent == null) {
                            return;
                        }
                        ServiceView mainView = ServiceViewManagerImpl.getServiceView(mainContent);
                        ServiceViewManagerImpl.this.loadViews(contentManager, mainView, contributors, (List)states.second);
                    }, ModalityState.nonModal(), ServiceViewManagerImpl.this.myProject.getDisposed()));
                }
                if (ServiceViewManagerImpl.this.myNotInitializedContributors.isEmpty()) {
                    Disposer.dispose((Disposable)disposable);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolWindow", "com/intellij/platform/execution/serviceView/ServiceViewManagerImpl$2", "toolWindowShown"));
            }
        });
    }

    private static void clearViewStateIfNeeded(@NotNull State state) {
        if (state == null) {
            ServiceViewManagerImpl.$$$reportNull$$$0(30);
        }
        if (state.viewStates == null) {
            state.viewStates = new SmartList();
            return;
        }
        for (ServiceViewState o : state.viewStates) {
            if (o instanceof ServiceViewState) continue;
            state.viewStates = new SmartList();
            return;
        }
    }

    static String getToolWindowContextHelpId() {
        return HELP_ID;
    }

    private ServiceViewState prepareViewState(ServiceViewState state) {
        state.showServicesTree = this.myState.showServicesTree;
        return state;
    }

    boolean isShowServicesTree() {
        return this.myState.showServicesTree;
    }

    void setShowServicesTree(boolean value) {
        this.myState.showServicesTree = value;
        for (ServiceViewContentHolder holder : this.myContentHolders) {
            for (ServiceView serviceView : holder.getServiceViews()) {
                serviceView.getUi().setMasterComponentVisible(value);
            }
        }
    }

    boolean isSelectActiveService() {
        return this.myState.selectActiveService;
    }

    void setSelectActiveService(boolean value) {
        this.myState.selectActiveService = value;
    }

    boolean isSplitByTypeEnabled(@NotNull ServiceView selectedView) {
        if (selectedView == null) {
            ServiceViewManagerImpl.$$$reportNull$$$0(31);
        }
        if (!ServiceViewManagerImpl.isMainView(selectedView) || selectedView.getModel().getVisibleRoots().isEmpty()) {
            return false;
        }
        ServiceViewContentHolder holder = this.getContentHolder(selectedView);
        if (holder == null) {
            return false;
        }
        for (Content content : holder.contentManager.getContents()) {
            ServiceView serviceView = ServiceViewManagerImpl.getServiceView(content);
            if (serviceView == null || serviceView == selectedView || serviceView.getModel() instanceof ServiceViewModel.ContributorModel) continue;
            return false;
        }
        return true;
    }

    void splitByType(@NotNull ServiceView selectedView) {
        ServiceViewContentHolder holder;
        if (selectedView == null) {
            ServiceViewManagerImpl.$$$reportNull$$$0(32);
        }
        if ((holder = this.getContentHolder(selectedView)) == null) {
            return;
        }
        this.myModel.getInvoker().invokeLater(() -> {
            List contributors = ContainerUtil.map(this.myModel.getRoots(), ServiceModel.ServiceViewItem::getRootContributor);
            AppUIUtil.invokeOnEdt(() -> {
                for (ServiceViewContributor contributor : contributors) {
                    this.splitByType(holder.contentManager, contributor);
                }
            });
        });
    }

    private ServiceViewContentHolder getContentHolder(ServiceView serviceView) {
        for (ServiceViewContentHolder holder : this.myContentHolders) {
            if (!holder.getServiceViews().contains(serviceView)) continue;
            return holder;
        }
        return null;
    }

    private void splitByType(ContentManager contentManager, ServiceViewContributor<?> contributor) {
        for (Content content : contentManager.getContents()) {
            ServiceViewModel viewModel;
            ServiceView serviceView = ServiceViewManagerImpl.getServiceView(content);
            if (serviceView == null || !((viewModel = serviceView.getModel()) instanceof ServiceViewModel.ContributorModel) || !contributor.equals(((ServiceViewModel.ContributorModel)viewModel).getContributor())) continue;
            return;
        }
        ServiceViewModel.ContributorModel contributorModel = new ServiceViewModel.ContributorModel(this.myModel, this.myModelFilter, contributor, null);
        this.extract(contentManager, contributorModel, this.prepareViewState(new ServiceViewState()), true);
    }

    @NotNull
    public List<Object> getChildrenSafe(@NotNull AnActionEvent e, @NotNull List<Object> valueSubPath, @NotNull Class<?> contributorClass) {
        ServiceView serviceView;
        if (e == null) {
            ServiceViewManagerImpl.$$$reportNull$$$0(33);
        }
        if (valueSubPath == null) {
            ServiceViewManagerImpl.$$$reportNull$$$0(34);
        }
        if (contributorClass == null) {
            ServiceViewManagerImpl.$$$reportNull$$$0(35);
        }
        List<Object> list = (serviceView = ServiceViewActionProvider.getSelectedView(e)) != null ? serviceView.getChildrenSafe(valueSubPath, contributorClass) : Collections.emptyList();
        if (list == null) {
            ServiceViewManagerImpl.$$$reportNull$$$0(36);
        }
        return list;
    }

    @Nullable
    public String getToolWindowId(@NotNull Class<?> contributorClass) {
        if (contributorClass == null) {
            ServiceViewManagerImpl.$$$reportNull$$$0(37);
        }
        for (Map.Entry<String, Collection<ServiceViewContributor<?>>> entry : this.myGroups.entrySet()) {
            if (!ContainerUtil.exists((Iterable)entry.getValue(), contributorClass::isInstance)) continue;
            return entry.getKey();
        }
        return null;
    }

    private static boolean isMainView(@NotNull ServiceView serviceView) {
        if (serviceView == null) {
            ServiceViewManagerImpl.$$$reportNull$$$0(38);
        }
        return serviceView.getModel() instanceof ServiceViewModel.AllServicesModel;
    }

    @Nullable
    private static Content getMainContent(@NotNull ContentManager contentManager) {
        if (contentManager == null) {
            ServiceViewManagerImpl.$$$reportNull$$$0(39);
        }
        for (Content content : contentManager.getContents()) {
            ServiceView serviceView = ServiceViewManagerImpl.getServiceView(content);
            if (serviceView == null || !ServiceViewManagerImpl.isMainView(serviceView)) continue;
            return content;
        }
        return null;
    }

    @Nullable
    private static ServiceView getServiceView(Content content) {
        JComponent component = content.getComponent();
        return component instanceof ServiceView ? (ServiceView)component : null;
    }

    private static void selectContentByModel(@NotNull ContentManager contentManager, @Nullable ServiceViewModel modelToSelect) {
        if (contentManager == null) {
            ServiceViewManagerImpl.$$$reportNull$$$0(40);
        }
        if (modelToSelect != null) {
            for (Content content : contentManager.getContents()) {
                ServiceView serviceView = ServiceViewManagerImpl.getServiceView(content);
                if (serviceView == null || serviceView.getModel() != modelToSelect) continue;
                contentManager.setSelectedContent(content);
                break;
            }
        } else {
            Content content = ServiceViewManagerImpl.getMainContent(contentManager);
            if (content != null) {
                contentManager.setSelectedContent(content);
            }
        }
    }

    private static void selectContentByContributor(@NotNull ContentManager contentManager, @NotNull ServiceViewContributor<?> contributor) {
        if (contentManager == null) {
            ServiceViewManagerImpl.$$$reportNull$$$0(41);
        }
        if (contributor == null) {
            ServiceViewManagerImpl.$$$reportNull$$$0(42);
        }
        Content mainContent = null;
        for (Content content : contentManager.getContents()) {
            ServiceView serviceView = ServiceViewManagerImpl.getServiceView(content);
            if (serviceView == null) continue;
            if (serviceView.getModel() instanceof ServiceViewModel.ContributorModel && contributor.equals(((ServiceViewModel.ContributorModel)serviceView.getModel()).getContributor())) {
                contentManager.setSelectedContent(content, true);
                return;
            }
            if (!ServiceViewManagerImpl.isMainView(serviceView)) continue;
            mainContent = content;
        }
        if (mainContent != null) {
            contentManager.setSelectedContent(mainContent, true);
        }
    }

    private static void registerActivateByContributorActions(Project project, Collection<? extends ServiceViewContributor<?>> contributors) {
        for (ServiceViewContributor<?> contributor : contributors) {
            Object action;
            ActionManager actionManager = ActionManager.getInstance();
            String actionId = ServiceViewManagerImpl.getActivateContributorActionId(contributor);
            if (actionId == null || (action = actionManager.getAction(actionId)) != null) continue;
            action = new ActivateToolWindowByContributorAction(contributor, contributor.getViewDescriptor(project).getPresentation());
            actionManager.registerAction(actionId, action);
        }
    }

    private static String getActivateContributorActionId(ServiceViewContributor<?> contributor) {
        String name = contributor.getClass().getSimpleName();
        return name.isEmpty() ? null : "ServiceView.Activate" + name;
    }

    private static ServiceViewToolWindowDescriptor getServicesToolWindowDescriptor() {
        return new ServiceViewToolWindowDescriptor(){

            @NotNull
            public String getToolWindowId() {
                return "Services";
            }

            @NotNull
            public Icon getToolWindowIcon() {
                Icon icon = AllIcons.Toolwindows.ToolWindowServices;
                if (icon == null) {
                    3.$$$reportNull$$$0(0);
                }
                return icon;
            }

            @NotNull
            public String getStripeTitle() {
                String string = UIBundle.message((String)"tool.window.name.services", (Object[])new Object[0]);
                if (string == null) {
                    3.$$$reportNull$$$0(1);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "com/intellij/platform/execution/serviceView/ServiceViewManagerImpl$3";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getToolWindowIcon";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getStripeTitle";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        };
    }

    private ServiceViewToolWindowDescriptor getContributorToolWindowDescriptor(ServiceViewContributor<?> rootContributor) {
        ServiceViewDescriptor descriptor = rootContributor.getViewDescriptor(this.myProject);
        if (descriptor instanceof ServiceViewToolWindowDescriptor) {
            return (ServiceViewToolWindowDescriptor)descriptor;
        }
        final @NlsSafe String toolWindowId = descriptor.getId();
        return new ServiceViewToolWindowDescriptor(){

            @NotNull
            public String getToolWindowId() {
                String string = toolWindowId;
                if (string == null) {
                    4.$$$reportNull$$$0(0);
                }
                return string;
            }

            @NotNull
            public Icon getToolWindowIcon() {
                Icon icon = AllIcons.Toolwindows.ToolWindowServices;
                if (icon == null) {
                    4.$$$reportNull$$$0(1);
                }
                return icon;
            }

            @NotNull
            public String getStripeTitle() {
                String string = toolWindowId;
                if (string == null) {
                    4.$$$reportNull$$$0(2);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "com/intellij/platform/execution/serviceView/ServiceViewManagerImpl$4";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getToolWindowId";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getToolWindowIcon";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getStripeTitle";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        };
    }

    void setExcludedContributors(@NotNull Collection<? extends ServiceViewContributor<?>> excluded) {
        if (excluded == null) {
            ServiceViewManagerImpl.$$$reportNull$$$0(43);
        }
        ArrayList toExclude = new ArrayList();
        ArrayList toInclude = new ArrayList();
        Collection<ServiceViewContributor<?>> services = null;
        for (Map.Entry<String, Collection<ServiceViewContributor<?>>> entry : this.myGroups.entrySet()) {
            if ("Services".equals(entry.getKey())) {
                toExclude.addAll(ContainerUtil.filter(entry.getValue(), contributor -> excluded.contains(contributor)));
                services = entry.getValue();
                continue;
            }
            toInclude.addAll(ContainerUtil.filter(entry.getValue(), contributor -> !excluded.contains(contributor)));
        }
        HashSet<String> toolWindowIds = new HashSet<String>();
        toolWindowIds.addAll(this.excludeServices(toExclude, services));
        toolWindowIds.addAll(this.includeServices(toInclude, services));
        this.registerToolWindows(toolWindowIds);
        this.myModel.getInvoker().invokeLater(() -> {
            for (ServiceViewContributor contributor : ServiceViewContributor.CONTRIBUTOR_EP_NAME.getExtensionList()) {
                ServiceEventListener.ServiceEvent e = ServiceEventListener.ServiceEvent.createResetEvent((Class)contributor.getClass());
                this.myModel.notifyListeners(e);
            }
        });
        if (toExclude.isEmpty() && !toInclude.isEmpty()) {
            toolWindowIds.add("Services");
        }
        this.activateToolWindows(toolWindowIds);
    }

    private Set<String> excludeServices(@NotNull List<ServiceViewContributor<?>> toExclude, @Nullable Collection<ServiceViewContributor<?>> services) {
        if (toExclude == null) {
            ServiceViewManagerImpl.$$$reportNull$$$0(44);
        }
        if (toExclude.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<String> toolWindowIds = new HashSet<String>();
        if (services != null) {
            services.removeAll(toExclude);
            if (services.isEmpty()) {
                this.unregisterToolWindow("Services");
            }
        }
        for (ServiceViewContributor<?> contributor : toExclude) {
            ServiceViewManagerImpl.unregisterActivateByContributorActions(contributor);
            ServiceViewToolWindowDescriptor descriptor = this.getContributorToolWindowDescriptor(contributor);
            String toolWindowId = descriptor.getToolWindowId();
            Collection contributors = this.myGroups.computeIfAbsent(toolWindowId, __ -> ConcurrentCollectionFactory.createConcurrentSet());
            if (contributors.isEmpty()) {
                toolWindowIds.add(toolWindowId);
            }
            contributors.add(contributor);
        }
        return toolWindowIds;
    }

    private Set<String> includeServices(@NotNull List<ServiceViewContributor<?>> toInclude, @Nullable Collection<ServiceViewContributor<?>> services) {
        if (toInclude == null) {
            ServiceViewManagerImpl.$$$reportNull$$$0(45);
        }
        if (toInclude.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<String> toolWindowIds = new HashSet<String>();
        block0: for (ServiceViewContributor<?> contributor : toInclude) {
            for (Map.Entry<String, Collection<ServiceViewContributor<?>>> entry : this.myGroups.entrySet()) {
                if ("Services".equals(entry.getKey()) || !entry.getValue().remove(contributor)) continue;
                if (!entry.getValue().isEmpty()) continue block0;
                this.unregisterToolWindow(entry.getKey());
                continue block0;
            }
        }
        if (services == null) {
            Set servicesContributors = ConcurrentCollectionFactory.createConcurrentSet();
            servicesContributors.addAll(toInclude);
            this.myGroups.put("Services", servicesContributors);
            toolWindowIds.add("Services");
        } else {
            services.addAll(toInclude);
            ServiceViewManagerImpl.registerActivateByContributorActions(this.myProject, toInclude);
        }
        return toolWindowIds;
    }

    private void activateToolWindows(Set<String> toolWindowIds) {
        ToolWindowManager toolWindowManager = ToolWindowManager.getInstance((Project)this.myProject);
        toolWindowManager.invokeLater(() -> {
            for (String toolWindowId : toolWindowIds) {
                ToolWindow toolWindow;
                if (!this.myActiveToolWindowIds.contains(toolWindowId) || (toolWindow = toolWindowManager.getToolWindow(toolWindowId)) == null) continue;
                toolWindow.activate(null);
            }
        });
    }

    void includeToolWindow(@NotNull String toolWindowId) {
        if (toolWindowId == null) {
            ServiceViewManagerImpl.$$$reportNull$$$0(46);
        }
        HashSet excluded = new HashSet();
        HashSet toInclude = new HashSet();
        for (Map.Entry<String, Collection<ServiceViewContributor<?>>> entry : this.myGroups.entrySet()) {
            if (toolWindowId.equals(entry.getKey())) {
                toInclude.addAll(entry.getValue());
                continue;
            }
            if ("Services".equals(entry.getKey())) continue;
            excluded.addAll(entry.getValue());
        }
        this.setExcludedContributors(excluded);
        Set<? extends ServiceViewContributor<?>> activeContributors = this.getActiveContributors();
        if (!Collections.disjoint(activeContributors, toInclude)) {
            ToolWindowManager toolWindowManager = ToolWindowManager.getInstance((Project)this.myProject);
            toolWindowManager.invokeLater(() -> {
                ToolWindow toolWindow = ToolWindowManager.getInstance((Project)this.myProject).getToolWindow("Services");
                if (toolWindow != null) {
                    this.myActiveToolWindowIds.add("Services");
                    toolWindow.show();
                }
            });
        }
    }

    private void unregisterToolWindow(String toolWindowId) {
        this.myActiveToolWindowIds.remove(toolWindowId);
        this.myGroups.remove(toolWindowId);
        for (ServiceViewContentHolder holder : this.myContentHolders) {
            if (!holder.toolWindowId.equals(toolWindowId)) continue;
            this.myContentHolders.remove(holder);
            break;
        }
        ToolWindowManager toolWindowManager = ToolWindowManager.getInstance((Project)this.myProject);
        toolWindowManager.invokeLater(() -> {
            if (this.myProject.isDisposed() || this.myProject.isDefault()) {
                return;
            }
            ToolWindow toolWindow = toolWindowManager.getToolWindow(toolWindowId);
            if (toolWindow != null) {
                toolWindow.remove();
            }
        });
    }

    private static void unregisterActivateByContributorActions(ServiceViewContributor<?> extension) {
        ActionManager actionManager;
        AnAction action;
        String actionId = ServiceViewManagerImpl.getActivateContributorActionId(extension);
        if (actionId != null && (action = (actionManager = ActionManager.getInstance()).getAction(actionId)) != null) {
            actionManager.unregisterAction(actionId);
        }
    }

    private /* synthetic */ void lambda$select$35(VirtualFile virtualFile, List selectedItems, Collection fileServices) {
        this.myModel.getInvoker().invoke(() -> {
            Condition fileCondition = item -> {
                ServiceViewLocatableDescriptor locatableDescriptor;
                ServiceViewDescriptor descriptor = item.getViewDescriptor();
                return fileServices.contains(descriptor.getId()) || descriptor instanceof ServiceViewLocatableDescriptor && virtualFile.equals((locatableDescriptor = (ServiceViewLocatableDescriptor)descriptor).getVirtualFile());
            };
            if (ContainerUtil.find((Iterable)selectedItems, (Condition)fileCondition) != null) {
                return;
            }
            ServiceModel.ServiceViewItem fileItem = this.myModel.findItem((Condition<? super ServiceModel.ServiceViewItem>)((Condition)item -> !(item instanceof ServiceModel.ServiceNode) || item.getViewDescriptor() instanceof ServiceViewLocatableDescriptor), (Condition<? super ServiceModel.ServiceViewItem>)fileCondition);
            if (fileItem != null) {
                this.doSelect(fileItem.getValue(), fileItem.getRootContributor().getClass(), false, false);
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 9, 12, 13, 14, 17, 20, 23, 27, 28, 36 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: 
            case 8: 
            case 11: 
            case 16: 
            case 19: 
            case 22: 
            case 35: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contributorClass";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolWindow";
                break;
            }
            case 5: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolWindowId";
                break;
            }
            case 7: 
            case 10: 
            case 15: 
            case 18: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "service";
                break;
            }
            case 9: 
            case 12: 
            case 13: 
            case 14: 
            case 17: 
            case 20: 
            case 23: 
            case 27: 
            case 28: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/platform/execution/serviceView/ServiceViewManagerImpl";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dragBean";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groupId";
                break;
            }
            case 29: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 31: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectedView";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueSubPath";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serviceView";
                break;
            }
            case 39: 
            case 40: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentManager";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contributor";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "excluded";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toExclude";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toInclude";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/platform/execution/serviceView/ServiceViewManagerImpl";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "select";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "trackingSelect";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "doSelect";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "expand";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "extract";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getServiceViewStates";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildrenSafe";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "eventHandled";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getContentHolder";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "registerToolWindow";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "restoreBrokenToolWindowIfNeeded";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "updateToolWindow";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createToolWindowContent";
                break;
            }
            case 7: 
            case 8: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "select";
                break;
            }
            case 9: 
            case 12: 
            case 13: 
            case 14: 
            case 17: 
            case 20: 
            case 23: 
            case 27: 
            case 28: 
            case 36: {
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "trackingSelect";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "doSelect";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "expand";
                break;
            }
            case 21: 
            case 22: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "extract";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getServiceViewStates";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "clearViewStateIfNeeded";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "isSplitByTypeEnabled";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "splitByType";
                break;
            }
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getChildrenSafe";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "getToolWindowId";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "isMainView";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "getMainContent";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "selectContentByModel";
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "selectContentByContributor";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "setExcludedContributors";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "excludeServices";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "includeServices";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "includeToolWindow";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 9, 12, 13, 14, 17, 20, 23, 27, 28, 36 -> new IllegalStateException(string);
        };
    }

    static final class State {
        public List<ServiceViewState> viewStates = new ArrayList<ServiceViewState>();
        public boolean showServicesTree = true;
        public boolean selectActiveService = true;
        public final Set<String> included = new HashSet<String>();
        public final Set<String> excluded = new HashSet<String>();

        State() {
        }
    }

    private final class ServiceViewExtensionPointListener
    implements ExtensionPointListener<ServiceViewContributor<?>> {
        private ServiceViewExtensionPointListener() {
        }

        public void extensionAdded(@NotNull ServiceViewContributor<?> extension, @NotNull PluginDescriptor pluginDescriptor) {
            if (extension == null) {
                ServiceViewExtensionPointListener.$$$reportNull$$$0(0);
            }
            if (pluginDescriptor == null) {
                ServiceViewExtensionPointListener.$$$reportNull$$$0(1);
            }
            ServiceViewManagerImpl.this.addToGroup(extension);
            String toolWindowId = ServiceViewManagerImpl.this.getToolWindowId(extension.getClass());
            boolean register = ServiceViewManagerImpl.this.myGroups.get(toolWindowId).size() == 1;
            ServiceEventListener.ServiceEvent e = ServiceEventListener.ServiceEvent.createResetEvent((Class)extension.getClass());
            ServiceViewManagerImpl.this.myModel.handle(e).onSuccess(o -> {
                if (register) {
                    ServiceModel.ServiceViewItem eventRoot = (ServiceModel.ServiceViewItem)ContainerUtil.find(ServiceViewManagerImpl.this.myModel.getRoots(), root -> extension.getClass().isInstance(root.getRootContributor()));
                    assert (toolWindowId != null);
                    ServiceViewManagerImpl.this.registerToolWindow(ServiceViewManagerImpl.this.getContributorToolWindowDescriptor(extension), eventRoot != null);
                } else {
                    ServiceViewManagerImpl.this.eventHandled(e);
                }
                if ("Services".equals(toolWindowId)) {
                    ((AppUIExecutor)AppUIExecutor.onUiThread().expireWith((Disposable)ServiceViewManagerImpl.this.myProject)).submit(() -> ServiceViewManagerImpl.registerActivateByContributorActions(ServiceViewManagerImpl.this.myProject, new SmartList((Object)extension)));
                }
            });
        }

        public void extensionRemoved(@NotNull ServiceViewContributor<?> extension, @NotNull PluginDescriptor pluginDescriptor) {
            if (extension == null) {
                ServiceViewExtensionPointListener.$$$reportNull$$$0(2);
            }
            if (pluginDescriptor == null) {
                ServiceViewExtensionPointListener.$$$reportNull$$$0(3);
            }
            ServiceViewManagerImpl.this.myNotInitializedContributors.remove(extension);
            ServiceEventListener.ServiceEvent e = ServiceEventListener.ServiceEvent.createUnloadSyncResetEvent((Class)extension.getClass());
            ServiceViewManagerImpl.this.myModel.handle(e).onProcessed(o -> {
                ServiceViewManagerImpl.this.eventHandled(e);
                for (Map.Entry<String, Collection<ServiceViewContributor<?>>> entry : ServiceViewManagerImpl.this.myGroups.entrySet()) {
                    if (!entry.getValue().remove(extension)) continue;
                    if (!entry.getValue().isEmpty()) break;
                    ServiceViewManagerImpl.this.unregisterToolWindow(entry.getKey());
                    break;
                }
                ServiceViewManagerImpl.unregisterActivateByContributorActions(extension);
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "extension";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pluginDescriptor";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/platform/execution/serviceView/ServiceViewManagerImpl$ServiceViewExtensionPointListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "extensionAdded";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "extensionRemoved";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private record ServiceViewContentHolder(ServiceView mainView, ContentManager contentManager, Collection<ServiceViewContributor<?>> rootContributors, String toolWindowId, Wrapper toolWindowHeaderSideComponent) {
        @Unmodifiable @NotNull List<ServiceView> getServiceViews() {
            List views = ContainerUtil.mapNotNull((Object[])this.contentManager.getContents(), ServiceViewManagerImpl::getServiceView);
            if (views.isEmpty()) {
                return new SmartList((Object)this.mainView);
            }
            if (!views.contains(this.mainView)) {
                views = ContainerUtil.prepend((List)views, (Object[])new ServiceView[]{this.mainView});
            }
            List list = views;
            if (list == null) {
                ServiceViewContentHolder.$$$reportNull$$$0(0);
            }
            return list;
        }

        private void processAllModels(Consumer<? super ServiceViewModel> consumer) {
            List models = ContainerUtil.map(this.getServiceViews(), ServiceView::getModel);
            ServiceViewModel model = (ServiceViewModel)ContainerUtil.getFirstItem((List)models);
            if (model != null) {
                model.getInvoker().invokeLater(() -> {
                    for (ServiceViewModel viewModel : models) {
                        consumer.accept(viewModel);
                    }
                });
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/platform/execution/serviceView/ServiceViewManagerImpl$ServiceViewContentHolder", "getServiceViews"));
        }
    }

    private static final class ServiceViewContentMangerListener
    implements ContentManagerListener {
        private final ServiceModelFilter myModelFilter;
        private final AutoScrollToSourceHandler myAutoScrollToSourceHandler;
        private final ServiceViewContentHolder myContentHolder;
        private final ContentManager myContentManager;

        ServiceViewContentMangerListener(@NotNull ServiceModelFilter modelFilter, @NotNull AutoScrollToSourceHandler toSourceHandler, @NotNull ServiceViewContentHolder contentHolder) {
            if (modelFilter == null) {
                ServiceViewContentMangerListener.$$$reportNull$$$0(0);
            }
            if (toSourceHandler == null) {
                ServiceViewContentMangerListener.$$$reportNull$$$0(1);
            }
            if (contentHolder == null) {
                ServiceViewContentMangerListener.$$$reportNull$$$0(2);
            }
            this.myModelFilter = modelFilter;
            this.myAutoScrollToSourceHandler = toSourceHandler;
            this.myContentHolder = contentHolder;
            this.myContentManager = contentHolder.contentManager;
        }

        public void contentAdded(@NotNull ContentManagerEvent event) {
            Content mainContent;
            Content content;
            ServiceView serviceView;
            if (event == null) {
                ServiceViewContentMangerListener.$$$reportNull$$$0(3);
            }
            if ((serviceView = ServiceViewManagerImpl.getServiceView(content = event.getContent())) != null && !ServiceViewManagerImpl.isMainView(serviceView)) {
                serviceView.setAutoScrollToSourceHandler(this.myAutoScrollToSourceHandler);
                this.myModelFilter.addFilter(serviceView.getModel().getFilter());
                this.myContentHolder.processAllModels(ServiceViewModel::filtersChanged);
                serviceView.getModel().addModelListener(() -> {
                    if (serviceView.getModel().getRoots().isEmpty()) {
                        ((AppUIExecutor)AppUIExecutor.onUiThread().expireWith((Disposable)this.myContentManager)).submit(() -> this.myContentManager.removeContent(content, true));
                    }
                });
            }
            if (this.myContentManager.getContentCount() > 1 && (mainContent = ServiceViewManagerImpl.getMainContent(this.myContentManager)) != null) {
                mainContent.setDisplayName(ExecutionBundle.message((String)"service.view.all.services", (Object[])new Object[0]));
            }
            if (serviceView != null) {
                ServiceViewManagerImpl.updateNavBar(this.myContentHolder);
                ToolWindow toolWindow = ToolWindowManager.getInstance((Project)serviceView.getProject()).getToolWindow(this.myContentHolder.toolWindowId);
                if (toolWindow != null) {
                    serviceView.getUi().setSplitOrientation(!toolWindow.getAnchor().isHorizontal());
                }
            }
        }

        public void contentRemoved(@NotNull ContentManagerEvent event) {
            Content mainContent;
            ServiceView serviceView;
            if (event == null) {
                ServiceViewContentMangerListener.$$$reportNull$$$0(4);
            }
            if ((serviceView = ServiceViewManagerImpl.getServiceView(event.getContent())) != null && !ServiceViewManagerImpl.isMainView(serviceView)) {
                this.myModelFilter.removeFilter(serviceView.getModel().getFilter());
                this.myContentHolder.processAllModels(ServiceViewModel::filtersChanged);
            }
            if (this.myContentManager.getContentCount() == 1 && (mainContent = ServiceViewManagerImpl.getMainContent(this.myContentManager)) != null) {
                mainContent.setDisplayName(null);
            }
            if (serviceView != null) {
                ServiceViewManagerImpl.updateNavBar(this.myContentHolder);
            }
        }

        public void selectionChanged(@NotNull ContentManagerEvent event) {
            ServiceView serviceView;
            if (event == null) {
                ServiceViewContentMangerListener.$$$reportNull$$$0(5);
            }
            if ((serviceView = ServiceViewManagerImpl.getServiceView(event.getContent())) == null) {
                return;
            }
            if (event.getOperation() == ContentManagerEvent.ContentOperation.add) {
                serviceView.onViewSelected();
                ServiceViewManagerImpl.updateNavBar(this.myContentHolder);
            } else {
                serviceView.onViewUnselected();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "modelFilter";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "toSourceHandler";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "contentHolder";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/platform/execution/serviceView/ServiceViewManagerImpl$ServiceViewContentMangerListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "contentAdded";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "contentRemoved";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "selectionChanged";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class ActivateToolWindowByContributorAction
    extends DumbAwareAction {
        private final ServiceViewContributor<?> myContributor;

        ActivateToolWindowByContributorAction(ServiceViewContributor<?> contributor, ItemPresentation contributorPresentation) {
            this.myContributor = contributor;
            Presentation templatePresentation = this.getTemplatePresentation();
            templatePresentation.setText(ExecutionBundle.messagePointer((String)"service.view.activate.tool.window.action.name", (Object[])new Object[]{ServiceViewDragHelper.getDisplayName(contributorPresentation)}));
            templatePresentation.setIcon(contributorPresentation.getIcon(false));
            templatePresentation.setDescription(ExecutionBundle.messagePointer((String)"service.view.activate.tool.window.action.description", (Object[])new Object[0]));
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Project project;
            if (e == null) {
                ActivateToolWindowByContributorAction.$$$reportNull$$$0(0);
            }
            if ((project = e.getProject()) == null) {
                return;
            }
            String toolWindowId = ServiceViewManager.getInstance((Project)project).getToolWindowId(this.myContributor.getClass());
            if (toolWindowId == null) {
                return;
            }
            ToolWindow toolWindow = ToolWindowManager.getInstance((Project)project).getToolWindow(toolWindowId);
            if (toolWindow != null) {
                toolWindow.activate(() -> {
                    ServiceViewContentHolder holder = ((ServiceViewManagerImpl)ServiceViewManager.getInstance((Project)project)).getContentHolder(this.myContributor.getClass());
                    if (holder != null) {
                        ServiceViewManagerImpl.selectContentByContributor(holder.contentManager, this.myContributor);
                    }
                });
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/platform/execution/serviceView/ServiceViewManagerImpl$ActivateToolWindowByContributorAction", "actionPerformed"));
        }
    }
}

