/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.openapi.util.text.Strings;
import com.intellij.platform.testFramework.core.FileComparisonFailedError;
import com.intellij.testFramework.EqualsToFile;
import java.io.File;
import junit.framework.TestCase;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u0018\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\f\u0010\u0000\u001a\u00020\u0001*\u00020\u0001H\u0002\u001a\u001e\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0001\u00a8\u0006\b"}, d2={"trimTrailingWhitespacesAndAddNewlineAtEOF", "", "assertEqualsToFile", "", "description", "expected", "Ljava/io/File;", "actual", "intellij.platform.testFramework"})
@JvmName(name="EqualsToFile")
public final class EqualsToFile {
    private static final String trimTrailingWhitespacesAndAddNewlineAtEOF(String $this$trimTrailingWhitespacesAndAddNewlineAtEOF) {
        char[] cArray = new char[]{'\n'};
        String result = SequencesKt.joinToString$default((Sequence)StringsKt.splitToSequence$default((CharSequence)$this$trimTrailingWhitespacesAndAddNewlineAtEOF, (char[])cArray, (boolean)false, (int)0, (int)6, null), (CharSequence)"\n", null, null, (int)0, null, (Function1)trimTrailingWhitespacesAndAddNewlineAtEOF.1.INSTANCE, (int)30, null);
        boolean bl = false;
        return StringsKt.endsWith$default((CharSequence)result, (char)'\n', (boolean)false, (int)2, null) ? result : result + "\n";
    }

    public static final void assertEqualsToFile(@NotNull String description, @NotNull File expected, @NotNull String actual) {
        Intrinsics.checkNotNullParameter((Object)description, (String)"description");
        Intrinsics.checkNotNullParameter((Object)expected, (String)"expected");
        Intrinsics.checkNotNullParameter((Object)actual, (String)"actual");
        if (!expected.exists()) {
            FilesKt.writeText$default((File)expected, (String)actual, null, (int)2, null);
            TestCase.fail((String)("File didn't exist. New file was created (" + expected.getCanonicalPath() + ")."));
        }
        String string = Strings.convertLineSeparators((String)((Object)StringsKt.trim((CharSequence)FilesKt.readText$default((File)expected, null, (int)1, null))).toString());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"convertLineSeparators(...)");
        String expectedText = EqualsToFile.trimTrailingWhitespacesAndAddNewlineAtEOF(string);
        String string2 = Strings.convertLineSeparators((String)((Object)StringsKt.trim((CharSequence)actual)).toString());
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"convertLineSeparators(...)");
        String actualText = EqualsToFile.trimTrailingWhitespacesAndAddNewlineAtEOF(string2);
        if (!Intrinsics.areEqual((Object)expectedText, (Object)actualText)) {
            throw new FileComparisonFailedError(description, expectedText, actualText, expected.getAbsolutePath(), null, 16, null);
        }
    }
}

