/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.preferences;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.core.CoreMessages;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.registry.confirmation.ConfirmationDescriptor;
import org.jkiss.dbeaver.registry.confirmation.ConfirmationRegistry;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.DefaultViewerToolTipSupport;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.CustomCheckboxCellEditor;
import org.jkiss.dbeaver.ui.controls.ListContentProvider;
import org.jkiss.dbeaver.ui.controls.ViewerColumnController;
import org.jkiss.dbeaver.ui.preferences.AbstractPrefPage;
import org.jkiss.dbeaver.utils.PrefUtils;
import org.jkiss.utils.CommonUtils;

public class PrefPageConfirmations
extends AbstractPrefPage
implements IWorkbenchPreferencePage {
    public static final String PAGE_ID = "org.jkiss.dbeaver.preferences.main.confirmations";
    private TableViewer tableViewer;
    private Table confirmTable;
    private List<ConfirmationWithStatus> confirmations = new ArrayList<ConfirmationWithStatus>();
    private Map<ConfirmationDescriptor, String> changedConfirmations = new HashMap<ConfirmationDescriptor, String>();

    public void init(IWorkbench workbench) {
    }

    @NotNull
    protected Control createPreferenceContent(@NotNull Composite parent) {
        Composite composite = UIUtils.createPlaceholder((Composite)parent, (int)1);
        this.tableViewer = new TableViewer(composite, 68352);
        this.confirmTable = this.tableViewer.getTable();
        this.confirmTable.setLayoutData((Object)new GridData(1808));
        this.confirmTable.setHeaderVisible(true);
        this.confirmTable.setLinesVisible(true);
        ViewerColumnController columnsController = new ViewerColumnController("PrefPageConfirmationsEditor", (ColumnViewer)this.tableViewer);
        columnsController.addColumn(CoreMessages.pref_page_confirmations_table_column_confirmation, CoreMessages.pref_page_confirmations_table_column_confirmation_tip, 16384, true, true, (CellLabelProvider)new ColumnLabelProvider(){

            public String getToolTipText(Object element) {
                if (element instanceof ConfirmationWithStatus) {
                    return ((ConfirmationWithStatus)element).confirmation.getDescription();
                }
                return null;
            }

            public String getText(Object element) {
                if (element instanceof ConfirmationWithStatus) {
                    return ((ConfirmationWithStatus)element).confirmation.getTitle();
                }
                return super.getText(element);
            }
        });
        columnsController.addBooleanColumn(CoreMessages.pref_page_confirmations_table_column_value, CoreMessages.pref_page_confirmations_table_column_value_tip, 0x1000000, true, true, item -> {
            if (item instanceof ConfirmationWithStatus) {
                return "prompt".equals(((ConfirmationWithStatus)item).status);
            }
            return false;
        }, new EditingSupport((ColumnViewer)this.tableViewer){

            protected CellEditor getCellEditor(Object element) {
                return new CustomCheckboxCellEditor((Composite)PrefPageConfirmations.this.tableViewer.getTable());
            }

            protected boolean canEdit(Object element) {
                return true;
            }

            protected Object getValue(Object element) {
                if (element instanceof ConfirmationWithStatus) {
                    return "prompt".equals(((ConfirmationWithStatus)element).status);
                }
                return false;
            }

            protected void setValue(Object element, Object value) {
                if (element instanceof ConfirmationWithStatus) {
                    ConfirmationWithStatus confirmation = (ConfirmationWithStatus)element;
                    boolean enabled = CommonUtils.getBoolean((Object)value, (boolean)true);
                    if (enabled && !"prompt".equals(confirmation.status)) {
                        confirmation.status = "prompt";
                        PrefPageConfirmations.this.changedConfirmations.put(confirmation.confirmation, "prompt");
                    } else if (!enabled) {
                        confirmation.status = "always";
                        PrefPageConfirmations.this.changedConfirmations.put(confirmation.confirmation, "always");
                    }
                }
            }
        });
        columnsController.addBooleanColumn(CoreMessages.pref_page_confirmations_table_column_confirm, CoreMessages.pref_page_confirmations_table_column_confirm_tip, 0x1000000, true, true, item -> {
            if (item instanceof ConfirmationWithStatus) {
                return !"never".equals(((ConfirmationWithStatus)item).status);
            }
            return false;
        }, new EditingSupport((ColumnViewer)this.tableViewer){

            protected CellEditor getCellEditor(Object element) {
                return new CustomCheckboxCellEditor((Composite)PrefPageConfirmations.this.tableViewer.getTable());
            }

            protected boolean canEdit(Object element) {
                if (element instanceof ConfirmationWithStatus) {
                    return !"prompt".equals(((ConfirmationWithStatus)element).status);
                }
                return false;
            }

            protected Object getValue(Object element) {
                if (element instanceof ConfirmationWithStatus) {
                    return !"never".equals(((ConfirmationWithStatus)element).status);
                }
                return false;
            }

            protected void setValue(Object element, Object value) {
                if (element instanceof ConfirmationWithStatus) {
                    ConfirmationWithStatus confirmation = (ConfirmationWithStatus)element;
                    if ("prompt".equals(confirmation.status)) {
                        return;
                    }
                    boolean enabled = CommonUtils.getBoolean((Object)value, (boolean)true);
                    if (enabled && !"always".equals(confirmation.status)) {
                        confirmation.status = "always";
                        PrefPageConfirmations.this.changedConfirmations.put(confirmation.confirmation, "always");
                    } else if (!enabled && !"never".equals(confirmation.status)) {
                        confirmation.status = "never";
                        PrefPageConfirmations.this.changedConfirmations.put(confirmation.confirmation, "never");
                    }
                }
            }
        });
        columnsController.addColumn(CoreMessages.pref_page_confirmations_table_column_group, CoreMessages.pref_page_confirmations_table_column_group, 131072, true, true, (CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof ConfirmationWithStatus) {
                    return ((ConfirmationWithStatus)element).confirmation.getGroup();
                }
                return super.getText(element);
            }
        });
        columnsController.createColumns(false);
        this.tableViewer.setContentProvider((IContentProvider)new ListContentProvider());
        new DefaultViewerToolTipSupport((ColumnViewer)this.tableViewer);
        Collection descriptors = ConfirmationRegistry.getInstance().getConfirmations().stream().filter(item -> CommonUtils.isNotEmpty((String)item.getToggleMessage())).sorted(Comparator.comparing(ConfirmationDescriptor::getGroup)).collect(Collectors.toList());
        for (ConfirmationDescriptor confirmation : descriptors) {
            this.confirmations.add(new ConfirmationWithStatus(confirmation, this.getCurrentConfirmValue(confirmation.getId())));
        }
        this.tableViewer.setInput(this.confirmations);
        this.tableViewer.refresh();
        UIUtils.asyncExec(() -> UIUtils.packColumns((Table)this.confirmTable, (boolean)true));
        return composite;
    }

    private String getCurrentConfirmValue(String id) {
        DBPPreferenceStore store = DBWorkbench.getPlatform().getPreferenceStore();
        String value = store.getString("org.jkiss.dbeaver.core.confirm." + id);
        if (CommonUtils.isEmpty((String)value)) {
            return "prompt";
        }
        if ("never".equals(value) || "always".equals(value)) {
            return value;
        }
        return "prompt";
    }

    public boolean performOk() {
        DBPPreferenceStore store = DBWorkbench.getPlatform().getPreferenceStore();
        for (Map.Entry<ConfirmationDescriptor, String> entry : this.changedConfirmations.entrySet()) {
            String id = entry.getKey().getId();
            store.setValue("org.jkiss.dbeaver.core.confirm." + id, entry.getValue());
        }
        PrefUtils.savePreferenceStore((DBPPreferenceStore)store);
        return super.performOk();
    }

    protected void performDefaults() {
        for (ConfirmationWithStatus confirmation : this.confirmations) {
            if ("prompt".equals(confirmation.status)) continue;
            confirmation.status = "prompt";
            this.changedConfirmations.put(confirmation.confirmation, "prompt");
        }
        this.tableViewer.refresh();
        UIUtils.asyncExec(() -> UIUtils.packColumns((Table)this.confirmTable, (boolean)true));
        super.performDefaults();
    }

    private class ConfirmationWithStatus {
        private ConfirmationDescriptor confirmation;
        private String status;

        ConfirmationWithStatus(ConfirmationDescriptor confirmation, String status) {
            this.confirmation = confirmation;
            this.status = status;
        }
    }
}

