/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.icon.mindmapmode;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.stream.Stream;
import org.freeplane.features.icon.mindmapmode.TagSelection;

public class TagCategorySelection
implements Transferable {
    public static final DataFlavor tagCategoryFlavor = new DataFlavor("application/x-freeplane-tag-category; class=java.lang.String", "Freeplane Tag Categories");
    public static final DataFlavor stringFlavor = DataFlavor.stringFlavor;
    private static final DataFlavor tagFlavor = TagSelection.tagFlavor;
    private static final DataFlavor uuidFlavor = TagSelection.uuidFlavor;
    private static final DataFlavor[] flavors = new DataFlavor[]{tagCategoryFlavor, tagFlavor, uuidFlavor, stringFlavor};
    private final String id;
    private final String tagCategorySelection;
    private final String tagSelection;

    public TagCategorySelection(String id, String tagCategoryData, String tagData) {
        this.id = id;
        this.tagCategorySelection = tagCategoryData;
        this.tagSelection = tagData;
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        return (DataFlavor[])flavors.clone();
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor flavor) {
        return Stream.of(flavors).anyMatch(flavor::equals);
    }

    @Override
    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
        if (flavor.equals(tagFlavor)) {
            return this.tagSelection;
        }
        if (flavor.equals(uuidFlavor)) {
            return this.id;
        }
        return this.tagCategorySelection;
    }

    public String getId() {
        return this.id;
    }
}

