/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.resolve.processors.inference;

import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.impl.source.resolve.graphInference.constraints.ConstraintFormula;
import java.util.Collection;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.psi.api.GrFunctionalExpression;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.resolve.processors.inference.GrConstraintFormula;
import org.jetbrains.plugins.groovy.lang.resolve.processors.inference.GroovyInferenceSession;
import org.jetbrains.plugins.groovy.lang.resolve.processors.inference.TypeConstraint;
import org.jetbrains.plugins.groovy.lang.sam.SamConversionKt;
import org.jetbrains.plugins.groovy.lang.typing.GroovyClosureType;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u000e\u0010\f\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u000e0\rH\u0016J\u0010\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u0005H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011\u00b2\u0006\u0011\u0010\u0012\u001a\t\u0018\u00010\u0005\u00a2\u0006\u0002\b\u0013X\u008a\u0084\u0002"}, d2={"Lorg/jetbrains/plugins/groovy/lang/resolve/processors/inference/FunctionalExpressionConstraint;", "Lorg/jetbrains/plugins/groovy/lang/resolve/processors/inference/GrConstraintFormula;", "expression", "Lorg/jetbrains/plugins/groovy/lang/psi/api/GrFunctionalExpression;", "leftType", "Lcom/intellij/psi/PsiType;", "<init>", "(Lorg/jetbrains/plugins/groovy/lang/psi/api/GrFunctionalExpression;Lcom/intellij/psi/PsiType;)V", "reduce", "", "session", "Lorg/jetbrains/plugins/groovy/lang/resolve/processors/inference/GroovyInferenceSession;", "constraints", "", "Lcom/intellij/psi/impl/source/resolve/graphInference/constraints/ConstraintFormula;", "unwrapWildcard", "type", "intellij.groovy.psi", "returnType", "Lorg/jetbrains/annotations/Nullable;"})
public final class FunctionalExpressionConstraint
extends GrConstraintFormula {
    @NotNull
    private final GrFunctionalExpression expression;
    @NotNull
    private final PsiType leftType;

    public FunctionalExpressionConstraint(@NotNull GrFunctionalExpression expression, @NotNull PsiType leftType) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)leftType, (String)"leftType");
        this.expression = expression;
        this.leftType = leftType;
    }

    @Override
    public boolean reduce(@NotNull GroovyInferenceSession session, @NotNull List<? super ConstraintFormula> constraints) {
        Intrinsics.checkNotNullParameter((Object)((Object)session), (String)"session");
        Intrinsics.checkNotNullParameter(constraints, (String)"constraints");
        if (!(this.leftType instanceof PsiClassType)) {
            return true;
        }
        Lazy returnType$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, () -> FunctionalExpressionConstraint.reduce$lambda$0(this));
        if (TypesUtil.isClassType(this.leftType, "groovy.lang.Closure")) {
            PsiType[] psiTypeArray = ((PsiClassType)this.leftType).getParameters();
            Intrinsics.checkNotNullExpressionValue((Object)psiTypeArray, (String)"getParameters(...)");
            PsiType[] parameters = psiTypeArray;
            if (parameters.length != 1) {
                return true;
            }
            if (FunctionalExpressionConstraint.reduce$lambda$1((Lazy<? extends PsiType>)returnType$delegate) == null || Intrinsics.areEqual((Object)FunctionalExpressionConstraint.reduce$lambda$1((Lazy<? extends PsiType>)returnType$delegate), (Object)PsiTypes.voidType())) {
                return true;
            }
            PsiType psiType = parameters[0];
            Intrinsics.checkNotNullExpressionValue((Object)psiType, (String)"get(...)");
            constraints.add(new TypeConstraint(this.unwrapWildcard(psiType), FunctionalExpressionConstraint.reduce$lambda$1((Lazy<? extends PsiType>)returnType$delegate), this.expression));
        } else {
            PsiType psiType = this.expression.getType();
            GroovyClosureType groovyClosureType = psiType instanceof GroovyClosureType ? (GroovyClosureType)psiType : null;
            if (groovyClosureType == null) {
                return true;
            }
            GroovyClosureType closureType = groovyClosureType;
            CollectionsKt.addAll((Collection)constraints, (Iterable)SamConversionKt.processSAMConversion(this.leftType, closureType, this.expression));
        }
        return true;
    }

    private final PsiType unwrapWildcard(PsiType type) {
        if (type instanceof PsiWildcardType && ((PsiWildcardType)type).isExtends()) {
            PsiType psiType = ((PsiWildcardType)type).getExtendsBound();
            Intrinsics.checkNotNullExpressionValue((Object)psiType, (String)"getExtendsBound(...)");
            return psiType;
        }
        return type;
    }

    private static final PsiType reduce$lambda$0(FunctionalExpressionConstraint this$0) {
        return this$0.expression.getReturnType();
    }

    private static final PsiType reduce$lambda$1(Lazy<? extends PsiType> $returnType$delegate) {
        Lazy<? extends PsiType> lazy = $returnType$delegate;
        return (PsiType)lazy.getValue();
    }
}

