/*
 * Decompiled with CFR 0.152.
 */
package git4idea.update;

import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.update.AbstractCommonUpdateAction;
import com.intellij.openapi.vcs.update.ActionInfo;
import com.intellij.openapi.vcs.update.SequentialUpdatesContext;
import com.intellij.openapi.vcs.update.UpdateEnvironment;
import com.intellij.openapi.vcs.update.UpdateSession;
import git4idea.GitBranch;
import git4idea.GitLocalBranch;
import git4idea.branch.GitBranchPair;
import git4idea.commands.Git;
import git4idea.commands.GitCommand;
import git4idea.commands.GitCommandResult;
import git4idea.commands.GitLineHandler;
import git4idea.config.UpdateMethod;
import git4idea.i18n.GitBundle;
import git4idea.repo.GitRepository;
import git4idea.update.GitUpdateEnvironment;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B]\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0018\u0010\u0004\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u0005\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\n\u0012\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u0005\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\b\b\u0002\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0004\b\u0012\u0010\u0013J6\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001dH\u0014J\u0018\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\f2\u0006\u0010\"\u001a\u00020\rH\u0002R\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\nX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0014R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lgit4idea/update/UpdateExecution;", "Lcom/intellij/openapi/vcs/update/AbstractCommonUpdateAction$Updater;", "project", "Lcom/intellij/openapi/project/Project;", "vcsToRoots", "", "Lcom/intellij/openapi/vcs/AbstractVcs;", "", "Lcom/intellij/openapi/vcs/FilePath;", "roots", "", "updateConfig", "Lgit4idea/repo/GitRepository;", "Lgit4idea/branch/GitBranchPair;", "updateMethod", "Lgit4idea/config/UpdateMethod;", "shouldSetAsUpstream", "", "<init>", "(Lcom/intellij/openapi/project/Project;Ljava/util/Map;[Lcom/intellij/openapi/vcs/FilePath;Ljava/util/Map;Lgit4idea/config/UpdateMethod;Z)V", "[Lcom/intellij/openapi/vcs/FilePath;", "performUpdate", "Lcom/intellij/openapi/vcs/update/UpdateSession;", "progressIndicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "updateEnvironment", "Lcom/intellij/openapi/vcs/update/UpdateEnvironment;", "files", "refContext", "Lcom/intellij/openapi/util/Ref;", "Lcom/intellij/openapi/vcs/update/SequentialUpdatesContext;", "setBranchUpstream", "", "repository", "branchConfig", "intellij.vcs.git"})
@SourceDebugExtension(value={"SMAP\nGitUpdateExecutionProcess.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitUpdateExecutionProcess.kt\ngit4idea/update/UpdateExecution\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,97:1\n216#2,2:98\n*S KotlinDebug\n*F\n+ 1 GitUpdateExecutionProcess.kt\ngit4idea/update/UpdateExecution\n*L\n77#1:98,2\n*E\n"})
final class UpdateExecution
extends AbstractCommonUpdateAction.Updater {
    @NotNull
    private final FilePath[] roots;
    @NotNull
    private final Map<GitRepository, GitBranchPair> updateConfig;
    @NotNull
    private final UpdateMethod updateMethod;
    private final boolean shouldSetAsUpstream;

    public UpdateExecution(@NotNull Project project, @NotNull Map<AbstractVcs, ? extends Collection<? extends FilePath>> vcsToRoots, @NotNull FilePath[] roots, @NotNull Map<GitRepository, GitBranchPair> updateConfig, @NotNull UpdateMethod updateMethod, boolean shouldSetAsUpstream) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(vcsToRoots, (String)"vcsToRoots");
        Intrinsics.checkNotNullParameter((Object)roots, (String)"roots");
        Intrinsics.checkNotNullParameter(updateConfig, (String)"updateConfig");
        Intrinsics.checkNotNullParameter((Object)((Object)updateMethod), (String)"updateMethod");
        ActionInfo actionInfo = ActionInfo.UPDATE;
        Intrinsics.checkNotNullExpressionValue((Object)actionInfo, (String)"UPDATE");
        String string = GitBundle.message("progress.title.update", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        super(project, roots, vcsToRoots, actionInfo, string);
        this.roots = roots;
        this.updateConfig = updateConfig;
        this.updateMethod = updateMethod;
        this.shouldSetAsUpstream = shouldSetAsUpstream;
    }

    public /* synthetic */ UpdateExecution(Project project, Map map2, FilePath[] filePathArray, Map map3, UpdateMethod updateMethod, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x20) != 0) {
            bl = false;
        }
        this(project, map2, filePathArray, map3, updateMethod, bl);
    }

    @NotNull
    protected UpdateSession performUpdate(@Nullable ProgressIndicator progressIndicator, @NotNull UpdateEnvironment updateEnvironment, @NotNull Collection<? extends FilePath> files, @NotNull Ref<SequentialUpdatesContext> refContext) {
        Intrinsics.checkNotNullParameter((Object)updateEnvironment, (String)"updateEnvironment");
        Intrinsics.checkNotNullParameter(files, (String)"files");
        Intrinsics.checkNotNullParameter(refContext, (String)"refContext");
        if (this.shouldSetAsUpstream) {
            Map<GitRepository, GitBranchPair> $this$forEach$iv = this.updateConfig;
            boolean $i$f$forEach = false;
            Iterator<Map.Entry<GitRepository, GitBranchPair>> iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<GitRepository, GitBranchPair> element$iv;
                Map.Entry<GitRepository, GitBranchPair> entry = element$iv = iterator.next();
                boolean bl = false;
                GitRepository repository2 = entry.getKey();
                GitBranchPair branchPair = entry.getValue();
                this.setBranchUpstream(repository2, branchPair);
            }
        }
        UpdateSession updateSession = GitUpdateEnvironment.performUpdate(this.getProject(), this.roots, this.getUpdatedFiles(), progressIndicator, this.updateMethod, this.updateConfig);
        Intrinsics.checkNotNullExpressionValue((Object)updateSession, (String)"performUpdate(...)");
        return updateSession;
    }

    private final void setBranchUpstream(GitRepository repository2, GitBranchPair branchConfig) {
        GitLineHandler handler = new GitLineHandler(this.getProject(), repository2.getRoot(), GitCommand.BRANCH);
        handler.setSilent(false);
        GitLocalBranch local = branchConfig.component1();
        GitBranch remote = branchConfig.component2();
        String[] stringArray = new String[]{"--set-upstream-to", remote.getName(), local.getName()};
        handler.addParameters(stringArray);
        GitCommandResult gitCommandResult = Git.getInstance().runCommand(handler);
        Intrinsics.checkNotNullExpressionValue((Object)gitCommandResult, (String)"runCommand(...)");
        GitCommandResult result2 = gitCommandResult;
        if (!result2.success()) {
            VcsNotifier.getInstance((Project)this.getProject()).notifyError("git.branch.set.upstream.failed", GitBundle.message("update.process.error.notification.title", new Object[0]), result2.getErrorOutputAsHtmlString(), true);
        }
    }
}

