/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream;

import java.time.Duration;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.kafka.streams.internals.ApiUtils;
import org.apache.kafka.streams.kstream.Windows;
import org.apache.kafka.streams.kstream.internals.TimeWindow;

public final class TimeWindows
extends Windows<TimeWindow> {
    public final long sizeMs;
    public final long advanceMs;
    private final long graceMs;

    private TimeWindows(long sizeMs, long advanceMs, long graceMs) {
        this.sizeMs = sizeMs;
        this.advanceMs = advanceMs;
        this.graceMs = graceMs;
        if (sizeMs <= 0L) {
            throw new IllegalArgumentException("Window size (sizeMs) must be larger than zero.");
        }
        if (advanceMs <= 0L || advanceMs > sizeMs) {
            throw new IllegalArgumentException(String.format("Window advancement interval should be more than zero and less than window duration which is %d ms, but given advancement interval is: %d ms", sizeMs, advanceMs));
        }
        if (graceMs < 0L) {
            throw new IllegalArgumentException("Grace period must not be negative.");
        }
    }

    public static TimeWindows ofSizeWithNoGrace(Duration size) throws IllegalArgumentException {
        return TimeWindows.ofSizeAndGrace(size, Duration.ofMillis(0L));
    }

    public static TimeWindows ofSizeAndGrace(Duration size, Duration afterWindowEnd) throws IllegalArgumentException {
        String sizeMsgPrefix = ApiUtils.prepareMillisCheckFailMsgPrefix(size, "size");
        long sizeMs = ApiUtils.validateMillisecondDuration(size, sizeMsgPrefix);
        String afterWindowEndMsgPrefix = ApiUtils.prepareMillisCheckFailMsgPrefix(afterWindowEnd, "afterWindowEnd");
        long afterWindowEndMs = ApiUtils.validateMillisecondDuration(afterWindowEnd, afterWindowEndMsgPrefix);
        return new TimeWindows(sizeMs, sizeMs, afterWindowEndMs);
    }

    public TimeWindows advanceBy(Duration advance) {
        String msgPrefix = ApiUtils.prepareMillisCheckFailMsgPrefix(advance, "advance");
        long advanceMs = ApiUtils.validateMillisecondDuration(advance, msgPrefix);
        return new TimeWindows(this.sizeMs, advanceMs, this.graceMs);
    }

    @Override
    public Map<Long, TimeWindow> windowsFor(long timestamp) {
        LinkedHashMap<Long, TimeWindow> windows = new LinkedHashMap<Long, TimeWindow>();
        for (long windowStart = Math.max(0L, timestamp - this.sizeMs + this.advanceMs) / this.advanceMs * this.advanceMs; windowStart <= timestamp; windowStart += this.advanceMs) {
            TimeWindow window = new TimeWindow(windowStart, windowStart + this.sizeMs);
            windows.put(windowStart, window);
        }
        return windows;
    }

    @Override
    public long size() {
        return this.sizeMs;
    }

    @Override
    public long gracePeriodMs() {
        return this.graceMs;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TimeWindows that = (TimeWindows)o;
        return this.sizeMs == that.sizeMs && this.advanceMs == that.advanceMs && this.graceMs == that.graceMs;
    }

    public int hashCode() {
        return Objects.hash(this.sizeMs, this.advanceMs, this.graceMs);
    }

    public String toString() {
        return "TimeWindows{, sizeMs=" + this.sizeMs + ", advanceMs=" + this.advanceMs + ", graceMs=" + this.graceMs + "}";
    }
}

