/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.SQLException;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.ResultSetAccessor;
import oracle.jdbc.driver.T2CConnection;

class T2CResultSetAccessor
extends ResultSetAccessor {
    T2CResultSetAccessor(OracleStatement stmt, int max_len, short form, int external_type, boolean isOutBind) throws SQLException {
        super(stmt, max_len * 2, form, external_type, isOutBind, true);
    }

    T2CResultSetAccessor(OracleStatement stmt, int max_len, boolean nullable, int flags, int precision, int scale, long contflag, int total_elems, short form) throws SQLException {
        super(stmt, max_len * 2, nullable, flags, precision, scale, contflag, total_elems, form);
    }

    @Override
    byte[] getBytes(int currentRow) throws SQLException {
        byte[] result = null;
        if (this.isNull(currentRow)) {
            return null;
        }
        int len = this.getLength(currentRow);
        byte align = ((T2CConnection)this.statement.connection).byteAlign;
        long adjusted_Offset = this.getOffset(currentRow) + (long)(align - 1) & (long)(~(align - 1));
        this.rowData.setPosition(adjusted_Offset);
        result = this.rowData.getBytes(len);
        return result;
    }
}

