/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.ko.dict;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.apache.lucene.util.IOSupplier;
import org.apache.lucene.util.IOUtils;

public final class ConnectionCosts
extends org.apache.lucene.analysis.morph.ConnectionCosts {
    public ConnectionCosts(Path connectionCostsFile) throws IOException {
        this((IOSupplier<InputStream>)((IOSupplier)() -> Files.newInputStream(connectionCostsFile, new OpenOption[0])));
    }

    public ConnectionCosts(URL connectionCostsUrl) throws IOException {
        this((IOSupplier<InputStream>)((IOSupplier)() -> connectionCostsUrl.openStream()));
    }

    private ConnectionCosts() throws IOException {
        this((IOSupplier<InputStream>)((IOSupplier)ConnectionCosts::getClassResource));
    }

    private ConnectionCosts(IOSupplier<InputStream> connectionCostResource) throws IOException {
        super(connectionCostResource, "ko_cc", 1);
    }

    private static InputStream getClassResource() throws IOException {
        String resourcePath = ConnectionCosts.class.getSimpleName() + ".dat";
        return (InputStream)IOUtils.requireResourceNonNull((Object)ConnectionCosts.class.getResourceAsStream(resourcePath), (String)resourcePath);
    }

    public static ConnectionCosts getInstance() {
        return SingletonHolder.INSTANCE;
    }

    private static class SingletonHolder {
        static final ConnectionCosts INSTANCE;

        private SingletonHolder() {
        }

        static {
            try {
                INSTANCE = new ConnectionCosts();
            }
            catch (IOException ioe) {
                throw new RuntimeException("Cannot load ConnectionCosts.", ioe);
            }
        }
    }
}

