/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.core;

import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nonnull;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch.core.field_caps.FieldCapability;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class FieldCapsResponse
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, FieldCapsResponse> {
    @Nonnull
    private final Map<String, Map<String, FieldCapability>> fields;
    @Nonnull
    private final List<String> indices;
    public static final JsonpDeserializer<FieldCapsResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, FieldCapsResponse::setupFieldCapsResponseDeserializer);

    private FieldCapsResponse(Builder builder) {
        this.fields = ApiTypeHelper.unmodifiableRequired(builder.fields, (Object)this, "fields");
        this.indices = ApiTypeHelper.unmodifiableRequired(builder.indices, (Object)this, "indices");
    }

    public static FieldCapsResponse of(Function<Builder, ObjectBuilder<FieldCapsResponse>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nonnull
    public final Map<String, Map<String, FieldCapability>> fields() {
        return this.fields;
    }

    @Nonnull
    public final List<String> indices() {
        return this.indices;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("fields");
        generator.writeStartObject();
        for (Map.Entry<String, Map<String, FieldCapability>> entry : this.fields.entrySet()) {
            generator.writeKey(entry.getKey());
            generator.writeStartObject();
            for (Map.Entry<String, FieldCapability> item1 : entry.getValue().entrySet()) {
                generator.writeKey(item1.getKey());
                item1.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        generator.writeEnd();
        generator.writeKey("indices");
        generator.writeStartArray();
        for (String string : this.indices) {
            generator.write(string);
        }
        generator.writeEnd();
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupFieldCapsResponseDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::fields, JsonpDeserializer.stringMapDeserializer(JsonpDeserializer.stringMapDeserializer(FieldCapability._DESERIALIZER)), "fields");
        op.add(Builder::indices, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "indices");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.fields.hashCode();
        result = 31 * result + this.indices.hashCode();
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FieldCapsResponse other = (FieldCapsResponse)o;
        return this.fields.equals(other.fields) && this.indices.equals(other.indices);
    }

    public static class Builder
    extends ObjectBuilderBase
    implements CopyableBuilder<Builder, FieldCapsResponse> {
        private Map<String, Map<String, FieldCapability>> fields;
        private List<String> indices;

        public Builder() {
        }

        private Builder(FieldCapsResponse o) {
            this.fields = Builder._mapCopy(o.fields);
            this.indices = Builder._listCopy(o.indices);
        }

        private Builder(Builder o) {
            this.fields = Builder._mapCopy(o.fields);
            this.indices = Builder._listCopy(o.indices);
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Nonnull
        public final Builder fields(Map<String, Map<String, FieldCapability>> map) {
            this.fields = Builder._mapPutAll(this.fields, map);
            return this;
        }

        @Nonnull
        public final Builder fields(String key, Map<String, FieldCapability> value) {
            this.fields = Builder._mapPut(this.fields, key, value);
            return this;
        }

        @Nonnull
        public final Builder indices(List<String> list) {
            this.indices = Builder._listAddAll(this.indices, list);
            return this;
        }

        @Nonnull
        public final Builder indices(String value, String ... values) {
            this.indices = Builder._listAdd(this.indices, value, values);
            return this;
        }

        @Override
        @Nonnull
        public FieldCapsResponse build() {
            this._checkSingleUse();
            return new FieldCapsResponse(this);
        }
    }
}

