﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/lambda/Lambda_EXPORTS.h>
#include <aws/lambda/model/ErrorObject.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace Lambda {
namespace Model {

/**
 * <p>Contains details about a callback operation in a durable execution, including
 * the callback token and timeout configuration.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/CallbackDetails">AWS
 * API Reference</a></p>
 */
class CallbackDetails {
 public:
  AWS_LAMBDA_API CallbackDetails() = default;
  AWS_LAMBDA_API CallbackDetails(Aws::Utils::Json::JsonView jsonValue);
  AWS_LAMBDA_API CallbackDetails& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_LAMBDA_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The callback ID. Callback IDs are generated by the
   * <code>DurableContext</code> when a durable function calls
   * <code>ctx.waitForCallback</code>.</p>
   */
  inline const Aws::String& GetCallbackId() const { return m_callbackId; }
  inline bool CallbackIdHasBeenSet() const { return m_callbackIdHasBeenSet; }
  template <typename CallbackIdT = Aws::String>
  void SetCallbackId(CallbackIdT&& value) {
    m_callbackIdHasBeenSet = true;
    m_callbackId = std::forward<CallbackIdT>(value);
  }
  template <typename CallbackIdT = Aws::String>
  CallbackDetails& WithCallbackId(CallbackIdT&& value) {
    SetCallbackId(std::forward<CallbackIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The response payload from the callback operation as a string.</p>
   */
  inline const Aws::String& GetResult() const { return m_result; }
  inline bool ResultHasBeenSet() const { return m_resultHasBeenSet; }
  template <typename ResultT = Aws::String>
  void SetResult(ResultT&& value) {
    m_resultHasBeenSet = true;
    m_result = std::forward<ResultT>(value);
  }
  template <typename ResultT = Aws::String>
  CallbackDetails& WithResult(ResultT&& value) {
    SetResult(std::forward<ResultT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>An error object that contains details about the failure.</p>
   */
  inline const ErrorObject& GetError() const { return m_error; }
  inline bool ErrorHasBeenSet() const { return m_errorHasBeenSet; }
  template <typename ErrorT = ErrorObject>
  void SetError(ErrorT&& value) {
    m_errorHasBeenSet = true;
    m_error = std::forward<ErrorT>(value);
  }
  template <typename ErrorT = ErrorObject>
  CallbackDetails& WithError(ErrorT&& value) {
    SetError(std::forward<ErrorT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_callbackId;

  Aws::String m_result;

  ErrorObject m_error;
  bool m_callbackIdHasBeenSet = false;
  bool m_resultHasBeenSet = false;
  bool m_errorHasBeenSet = false;
};

}  // namespace Model
}  // namespace Lambda
}  // namespace Aws
