﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/pi/PI_EXPORTS.h>
#include <aws/pi/model/DimensionGroupDetail.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace PI {
namespace Model {

/**
 * <p>The available dimension information for a metric type.</p><p><h3>See
 * Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/pi-2018-02-27/MetricDimensionGroups">AWS
 * API Reference</a></p>
 */
class MetricDimensionGroups {
 public:
  AWS_PI_API MetricDimensionGroups() = default;
  AWS_PI_API MetricDimensionGroups(Aws::Utils::Json::JsonView jsonValue);
  AWS_PI_API MetricDimensionGroups& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_PI_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The metric type to which the dimension information belongs.</p>
   */
  inline const Aws::String& GetMetric() const { return m_metric; }
  inline bool MetricHasBeenSet() const { return m_metricHasBeenSet; }
  template <typename MetricT = Aws::String>
  void SetMetric(MetricT&& value) {
    m_metricHasBeenSet = true;
    m_metric = std::forward<MetricT>(value);
  }
  template <typename MetricT = Aws::String>
  MetricDimensionGroups& WithMetric(MetricT&& value) {
    SetMetric(std::forward<MetricT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The available dimension groups for a metric type.</p>
   */
  inline const Aws::Vector<DimensionGroupDetail>& GetGroups() const { return m_groups; }
  inline bool GroupsHasBeenSet() const { return m_groupsHasBeenSet; }
  template <typename GroupsT = Aws::Vector<DimensionGroupDetail>>
  void SetGroups(GroupsT&& value) {
    m_groupsHasBeenSet = true;
    m_groups = std::forward<GroupsT>(value);
  }
  template <typename GroupsT = Aws::Vector<DimensionGroupDetail>>
  MetricDimensionGroups& WithGroups(GroupsT&& value) {
    SetGroups(std::forward<GroupsT>(value));
    return *this;
  }
  template <typename GroupsT = DimensionGroupDetail>
  MetricDimensionGroups& AddGroups(GroupsT&& value) {
    m_groupsHasBeenSet = true;
    m_groups.emplace_back(std::forward<GroupsT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_metric;

  Aws::Vector<DimensionGroupDetail> m_groups;
  bool m_metricHasBeenSet = false;
  bool m_groupsHasBeenSet = false;
};

}  // namespace Model
}  // namespace PI
}  // namespace Aws
