﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/DateTime.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/secretsmanager/SecretsManager_EXPORTS.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace SecretsManager {
namespace Model {
class DeleteSecretResult {
 public:
  AWS_SECRETSMANAGER_API DeleteSecretResult() = default;
  AWS_SECRETSMANAGER_API DeleteSecretResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_SECRETSMANAGER_API DeleteSecretResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>The ARN of the secret.</p>
   */
  inline const Aws::String& GetARN() const { return m_aRN; }
  template <typename ARNT = Aws::String>
  void SetARN(ARNT&& value) {
    m_aRNHasBeenSet = true;
    m_aRN = std::forward<ARNT>(value);
  }
  template <typename ARNT = Aws::String>
  DeleteSecretResult& WithARN(ARNT&& value) {
    SetARN(std::forward<ARNT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The name of the secret.</p>
   */
  inline const Aws::String& GetName() const { return m_name; }
  template <typename NameT = Aws::String>
  void SetName(NameT&& value) {
    m_nameHasBeenSet = true;
    m_name = std::forward<NameT>(value);
  }
  template <typename NameT = Aws::String>
  DeleteSecretResult& WithName(NameT&& value) {
    SetName(std::forward<NameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The date and time after which this secret Secrets Manager can permanently
   * delete this secret, and it can no longer be restored. This value is the date and
   * time of the delete request plus the number of days in
   * <code>RecoveryWindowInDays</code>.</p>
   */
  inline const Aws::Utils::DateTime& GetDeletionDate() const { return m_deletionDate; }
  template <typename DeletionDateT = Aws::Utils::DateTime>
  void SetDeletionDate(DeletionDateT&& value) {
    m_deletionDateHasBeenSet = true;
    m_deletionDate = std::forward<DeletionDateT>(value);
  }
  template <typename DeletionDateT = Aws::Utils::DateTime>
  DeleteSecretResult& WithDeletionDate(DeletionDateT&& value) {
    SetDeletionDate(std::forward<DeletionDateT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  DeleteSecretResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_aRN;

  Aws::String m_name;

  Aws::Utils::DateTime m_deletionDate{};

  Aws::String m_requestId;
  bool m_aRNHasBeenSet = false;
  bool m_nameHasBeenSet = false;
  bool m_deletionDateHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace SecretsManager
}  // namespace Aws
