# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
from typing import Dict, List, Optional, Union

from azure.core.exceptions import HttpResponseError
import msrest.serialization

from ._cdn_management_client_enums import *


class ActivatedResourceReference(msrest.serialization.Model):
    """Reference to another resource along with its state.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar is_active: Whether the resource is active or inactive.
    :vartype is_active: bool
    """

    _validation = {
        'is_active': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'is_active': {'key': 'isActive', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword id: Resource ID.
        :paramtype id: str
        """
        super(ActivatedResourceReference, self).__init__(**kwargs)
        self.id = id
        self.is_active = None


class Resource(msrest.serialization.Model):
    """The core properties of ARM resources.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar system_data: Read only system data.
    :vartype system_data: ~azure.mgmt.cdn.models.SystemData
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(Resource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.system_data = None


class ProxyResource(Resource):
    """The resource model definition for a ARM proxy resource. It will have everything other than required location and tags.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar system_data: Read only system data.
    :vartype system_data: ~azure.mgmt.cdn.models.SystemData
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(ProxyResource, self).__init__(**kwargs)


class AFDDomain(ProxyResource):
    """Friendly domain name mapping to the endpoint hostname that the customer provides for branding purposes, e.g. www.contoso.com.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar system_data: Read only system data.
    :vartype system_data: ~azure.mgmt.cdn.models.SystemData
    :ivar profile_name: The name of the profile which holds the domain.
    :vartype profile_name: str
    :ivar tls_settings: The configuration specifying how to enable HTTPS for the domain - using
     AzureFrontDoor managed certificate or user's own certificate. If not specified, enabling ssl
     uses AzureFrontDoor managed certificate by default.
    :vartype tls_settings: ~azure.mgmt.cdn.models.AFDDomainHttpsParameters
    :ivar azure_dns_zone: Resource reference to the Azure DNS zone.
    :vartype azure_dns_zone: ~azure.mgmt.cdn.models.ResourceReference
    :ivar pre_validated_custom_domain_resource_id: Resource reference to the Azure resource where
     custom domain ownership was prevalidated.
    :vartype pre_validated_custom_domain_resource_id: ~azure.mgmt.cdn.models.ResourceReference
    :ivar provisioning_state: Provisioning status. Possible values include: "Succeeded", "Failed",
     "Updating", "Deleting", "Creating".
    :vartype provisioning_state: str or ~azure.mgmt.cdn.models.AfdProvisioningState
    :ivar deployment_status: Possible values include: "NotStarted", "InProgress", "Succeeded",
     "Failed".
    :vartype deployment_status: str or ~azure.mgmt.cdn.models.DeploymentStatus
    :ivar domain_validation_state: Provisioning substate shows the progress of custom HTTPS
     enabling/disabling process step by step. DCV stands for DomainControlValidation. Possible
     values include: "Unknown", "Submitting", "Pending", "Rejected", "TimedOut",
     "PendingRevalidation", "Approved", "RefreshingValidationToken", "InternalError".
    :vartype domain_validation_state: str or ~azure.mgmt.cdn.models.DomainValidationState
    :ivar host_name: The host name of the domain. Must be a domain name.
    :vartype host_name: str
    :ivar validation_properties: Values the customer needs to validate domain ownership.
    :vartype validation_properties: ~azure.mgmt.cdn.models.DomainValidationProperties
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'profile_name': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'deployment_status': {'readonly': True},
        'domain_validation_state': {'readonly': True},
        'validation_properties': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'profile_name': {'key': 'properties.profileName', 'type': 'str'},
        'tls_settings': {'key': 'properties.tlsSettings', 'type': 'AFDDomainHttpsParameters'},
        'azure_dns_zone': {'key': 'properties.azureDnsZone', 'type': 'ResourceReference'},
        'pre_validated_custom_domain_resource_id': {'key': 'properties.preValidatedCustomDomainResourceId', 'type': 'ResourceReference'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'deployment_status': {'key': 'properties.deploymentStatus', 'type': 'str'},
        'domain_validation_state': {'key': 'properties.domainValidationState', 'type': 'str'},
        'host_name': {'key': 'properties.hostName', 'type': 'str'},
        'validation_properties': {'key': 'properties.validationProperties', 'type': 'DomainValidationProperties'},
    }

    def __init__(
        self,
        *,
        tls_settings: Optional["AFDDomainHttpsParameters"] = None,
        azure_dns_zone: Optional["ResourceReference"] = None,
        pre_validated_custom_domain_resource_id: Optional["ResourceReference"] = None,
        host_name: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword tls_settings: The configuration specifying how to enable HTTPS for the domain - using
         AzureFrontDoor managed certificate or user's own certificate. If not specified, enabling ssl
         uses AzureFrontDoor managed certificate by default.
        :paramtype tls_settings: ~azure.mgmt.cdn.models.AFDDomainHttpsParameters
        :keyword azure_dns_zone: Resource reference to the Azure DNS zone.
        :paramtype azure_dns_zone: ~azure.mgmt.cdn.models.ResourceReference
        :keyword pre_validated_custom_domain_resource_id: Resource reference to the Azure resource
         where custom domain ownership was prevalidated.
        :paramtype pre_validated_custom_domain_resource_id: ~azure.mgmt.cdn.models.ResourceReference
        :keyword host_name: The host name of the domain. Must be a domain name.
        :paramtype host_name: str
        """
        super(AFDDomain, self).__init__(**kwargs)
        self.profile_name = None
        self.tls_settings = tls_settings
        self.azure_dns_zone = azure_dns_zone
        self.pre_validated_custom_domain_resource_id = pre_validated_custom_domain_resource_id
        self.provisioning_state = None
        self.deployment_status = None
        self.domain_validation_state = None
        self.host_name = host_name
        self.validation_properties = None


class AFDDomainHttpsParameters(msrest.serialization.Model):
    """The JSON object that contains the properties to secure a domain.

    All required parameters must be populated in order to send to Azure.

    :ivar certificate_type: Required. Defines the source of the SSL certificate. Possible values
     include: "CustomerCertificate", "ManagedCertificate", "AzureFirstPartyManagedCertificate".
    :vartype certificate_type: str or ~azure.mgmt.cdn.models.AfdCertificateType
    :ivar minimum_tls_version: TLS protocol version that will be used for Https. Possible values
     include: "TLS10", "TLS12".
    :vartype minimum_tls_version: str or ~azure.mgmt.cdn.models.AfdMinimumTlsVersion
    :ivar secret: Resource reference to the secret. ie. subs/rg/profile/secret.
    :vartype secret: ~azure.mgmt.cdn.models.ResourceReference
    """

    _validation = {
        'certificate_type': {'required': True},
    }

    _attribute_map = {
        'certificate_type': {'key': 'certificateType', 'type': 'str'},
        'minimum_tls_version': {'key': 'minimumTlsVersion', 'type': 'str'},
        'secret': {'key': 'secret', 'type': 'ResourceReference'},
    }

    def __init__(
        self,
        *,
        certificate_type: Union[str, "AfdCertificateType"],
        minimum_tls_version: Optional[Union[str, "AfdMinimumTlsVersion"]] = None,
        secret: Optional["ResourceReference"] = None,
        **kwargs
    ):
        """
        :keyword certificate_type: Required. Defines the source of the SSL certificate. Possible values
         include: "CustomerCertificate", "ManagedCertificate", "AzureFirstPartyManagedCertificate".
        :paramtype certificate_type: str or ~azure.mgmt.cdn.models.AfdCertificateType
        :keyword minimum_tls_version: TLS protocol version that will be used for Https. Possible values
         include: "TLS10", "TLS12".
        :paramtype minimum_tls_version: str or ~azure.mgmt.cdn.models.AfdMinimumTlsVersion
        :keyword secret: Resource reference to the secret. ie. subs/rg/profile/secret.
        :paramtype secret: ~azure.mgmt.cdn.models.ResourceReference
        """
        super(AFDDomainHttpsParameters, self).__init__(**kwargs)
        self.certificate_type = certificate_type
        self.minimum_tls_version = minimum_tls_version
        self.secret = secret


class AFDDomainListResult(msrest.serialization.Model):
    """Result of the request to list domains. It contains a list of domain objects and a URL link to get the next set of results.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of AzureFrontDoor domains within a profile.
    :vartype value: list[~azure.mgmt.cdn.models.AFDDomain]
    :ivar next_link: URL to get the next set of domain objects if there are any.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[AFDDomain]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        next_link: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword next_link: URL to get the next set of domain objects if there are any.
        :paramtype next_link: str
        """
        super(AFDDomainListResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = next_link


class AFDStateProperties(msrest.serialization.Model):
    """The tracking states for afd resources.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar provisioning_state: Provisioning status. Possible values include: "Succeeded", "Failed",
     "Updating", "Deleting", "Creating".
    :vartype provisioning_state: str or ~azure.mgmt.cdn.models.AfdProvisioningState
    :ivar deployment_status: Possible values include: "NotStarted", "InProgress", "Succeeded",
     "Failed".
    :vartype deployment_status: str or ~azure.mgmt.cdn.models.DeploymentStatus
    """

    _validation = {
        'provisioning_state': {'readonly': True},
        'deployment_status': {'readonly': True},
    }

    _attribute_map = {
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
        'deployment_status': {'key': 'deploymentStatus', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(AFDStateProperties, self).__init__(**kwargs)
        self.provisioning_state = None
        self.deployment_status = None


class AFDDomainUpdatePropertiesParameters(msrest.serialization.Model):
    """The JSON object that contains the properties of the domain to create.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar profile_name: The name of the profile which holds the domain.
    :vartype profile_name: str
    :ivar tls_settings: The configuration specifying how to enable HTTPS for the domain - using
     AzureFrontDoor managed certificate or user's own certificate. If not specified, enabling ssl
     uses AzureFrontDoor managed certificate by default.
    :vartype tls_settings: ~azure.mgmt.cdn.models.AFDDomainHttpsParameters
    :ivar azure_dns_zone: Resource reference to the Azure DNS zone.
    :vartype azure_dns_zone: ~azure.mgmt.cdn.models.ResourceReference
    :ivar pre_validated_custom_domain_resource_id: Resource reference to the Azure resource where
     custom domain ownership was prevalidated.
    :vartype pre_validated_custom_domain_resource_id: ~azure.mgmt.cdn.models.ResourceReference
    """

    _validation = {
        'profile_name': {'readonly': True},
    }

    _attribute_map = {
        'profile_name': {'key': 'profileName', 'type': 'str'},
        'tls_settings': {'key': 'tlsSettings', 'type': 'AFDDomainHttpsParameters'},
        'azure_dns_zone': {'key': 'azureDnsZone', 'type': 'ResourceReference'},
        'pre_validated_custom_domain_resource_id': {'key': 'preValidatedCustomDomainResourceId', 'type': 'ResourceReference'},
    }

    def __init__(
        self,
        *,
        tls_settings: Optional["AFDDomainHttpsParameters"] = None,
        azure_dns_zone: Optional["ResourceReference"] = None,
        pre_validated_custom_domain_resource_id: Optional["ResourceReference"] = None,
        **kwargs
    ):
        """
        :keyword tls_settings: The configuration specifying how to enable HTTPS for the domain - using
         AzureFrontDoor managed certificate or user's own certificate. If not specified, enabling ssl
         uses AzureFrontDoor managed certificate by default.
        :paramtype tls_settings: ~azure.mgmt.cdn.models.AFDDomainHttpsParameters
        :keyword azure_dns_zone: Resource reference to the Azure DNS zone.
        :paramtype azure_dns_zone: ~azure.mgmt.cdn.models.ResourceReference
        :keyword pre_validated_custom_domain_resource_id: Resource reference to the Azure resource
         where custom domain ownership was prevalidated.
        :paramtype pre_validated_custom_domain_resource_id: ~azure.mgmt.cdn.models.ResourceReference
        """
        super(AFDDomainUpdatePropertiesParameters, self).__init__(**kwargs)
        self.profile_name = None
        self.tls_settings = tls_settings
        self.azure_dns_zone = azure_dns_zone
        self.pre_validated_custom_domain_resource_id = pre_validated_custom_domain_resource_id


class AFDDomainProperties(AFDDomainUpdatePropertiesParameters, AFDStateProperties):
    """The JSON object that contains the properties of the domain to create.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar provisioning_state: Provisioning status. Possible values include: "Succeeded", "Failed",
     "Updating", "Deleting", "Creating".
    :vartype provisioning_state: str or ~azure.mgmt.cdn.models.AfdProvisioningState
    :ivar deployment_status: Possible values include: "NotStarted", "InProgress", "Succeeded",
     "Failed".
    :vartype deployment_status: str or ~azure.mgmt.cdn.models.DeploymentStatus
    :ivar profile_name: The name of the profile which holds the domain.
    :vartype profile_name: str
    :ivar tls_settings: The configuration specifying how to enable HTTPS for the domain - using
     AzureFrontDoor managed certificate or user's own certificate. If not specified, enabling ssl
     uses AzureFrontDoor managed certificate by default.
    :vartype tls_settings: ~azure.mgmt.cdn.models.AFDDomainHttpsParameters
    :ivar azure_dns_zone: Resource reference to the Azure DNS zone.
    :vartype azure_dns_zone: ~azure.mgmt.cdn.models.ResourceReference
    :ivar pre_validated_custom_domain_resource_id: Resource reference to the Azure resource where
     custom domain ownership was prevalidated.
    :vartype pre_validated_custom_domain_resource_id: ~azure.mgmt.cdn.models.ResourceReference
    :ivar domain_validation_state: Provisioning substate shows the progress of custom HTTPS
     enabling/disabling process step by step. DCV stands for DomainControlValidation. Possible
     values include: "Unknown", "Submitting", "Pending", "Rejected", "TimedOut",
     "PendingRevalidation", "Approved", "RefreshingValidationToken", "InternalError".
    :vartype domain_validation_state: str or ~azure.mgmt.cdn.models.DomainValidationState
    :ivar host_name: Required. The host name of the domain. Must be a domain name.
    :vartype host_name: str
    :ivar validation_properties: Values the customer needs to validate domain ownership.
    :vartype validation_properties: ~azure.mgmt.cdn.models.DomainValidationProperties
    """

    _validation = {
        'provisioning_state': {'readonly': True},
        'deployment_status': {'readonly': True},
        'profile_name': {'readonly': True},
        'domain_validation_state': {'readonly': True},
        'host_name': {'required': True},
        'validation_properties': {'readonly': True},
    }

    _attribute_map = {
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
        'deployment_status': {'key': 'deploymentStatus', 'type': 'str'},
        'profile_name': {'key': 'profileName', 'type': 'str'},
        'tls_settings': {'key': 'tlsSettings', 'type': 'AFDDomainHttpsParameters'},
        'azure_dns_zone': {'key': 'azureDnsZone', 'type': 'ResourceReference'},
        'pre_validated_custom_domain_resource_id': {'key': 'preValidatedCustomDomainResourceId', 'type': 'ResourceReference'},
        'domain_validation_state': {'key': 'domainValidationState', 'type': 'str'},
        'host_name': {'key': 'hostName', 'type': 'str'},
        'validation_properties': {'key': 'validationProperties', 'type': 'DomainValidationProperties'},
    }

    def __init__(
        self,
        *,
        host_name: str,
        tls_settings: Optional["AFDDomainHttpsParameters"] = None,
        azure_dns_zone: Optional["ResourceReference"] = None,
        pre_validated_custom_domain_resource_id: Optional["ResourceReference"] = None,
        **kwargs
    ):
        """
        :keyword tls_settings: The configuration specifying how to enable HTTPS for the domain - using
         AzureFrontDoor managed certificate or user's own certificate. If not specified, enabling ssl
         uses AzureFrontDoor managed certificate by default.
        :paramtype tls_settings: ~azure.mgmt.cdn.models.AFDDomainHttpsParameters
        :keyword azure_dns_zone: Resource reference to the Azure DNS zone.
        :paramtype azure_dns_zone: ~azure.mgmt.cdn.models.ResourceReference
        :keyword pre_validated_custom_domain_resource_id: Resource reference to the Azure resource
         where custom domain ownership was prevalidated.
        :paramtype pre_validated_custom_domain_resource_id: ~azure.mgmt.cdn.models.ResourceReference
        :keyword host_name: Required. The host name of the domain. Must be a domain name.
        :paramtype host_name: str
        """
        super(AFDDomainProperties, self).__init__(tls_settings=tls_settings, azure_dns_zone=azure_dns_zone, pre_validated_custom_domain_resource_id=pre_validated_custom_domain_resource_id, **kwargs)
        self.provisioning_state = None
        self.deployment_status = None
        self.domain_validation_state = None
        self.host_name = host_name
        self.validation_properties = None
        self.profile_name = None
        self.tls_settings = tls_settings
        self.azure_dns_zone = azure_dns_zone
        self.pre_validated_custom_domain_resource_id = pre_validated_custom_domain_resource_id
        self.domain_validation_state = None
        self.host_name = host_name
        self.validation_properties = None


class AFDDomainUpdateParameters(msrest.serialization.Model):
    """The domain JSON object required for domain creation or update.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar profile_name: The name of the profile which holds the domain.
    :vartype profile_name: str
    :ivar tls_settings: The configuration specifying how to enable HTTPS for the domain - using
     AzureFrontDoor managed certificate or user's own certificate. If not specified, enabling ssl
     uses AzureFrontDoor managed certificate by default.
    :vartype tls_settings: ~azure.mgmt.cdn.models.AFDDomainHttpsParameters
    :ivar azure_dns_zone: Resource reference to the Azure DNS zone.
    :vartype azure_dns_zone: ~azure.mgmt.cdn.models.ResourceReference
    :ivar pre_validated_custom_domain_resource_id: Resource reference to the Azure resource where
     custom domain ownership was prevalidated.
    :vartype pre_validated_custom_domain_resource_id: ~azure.mgmt.cdn.models.ResourceReference
    """

    _validation = {
        'profile_name': {'readonly': True},
    }

    _attribute_map = {
        'profile_name': {'key': 'properties.profileName', 'type': 'str'},
        'tls_settings': {'key': 'properties.tlsSettings', 'type': 'AFDDomainHttpsParameters'},
        'azure_dns_zone': {'key': 'properties.azureDnsZone', 'type': 'ResourceReference'},
        'pre_validated_custom_domain_resource_id': {'key': 'properties.preValidatedCustomDomainResourceId', 'type': 'ResourceReference'},
    }

    def __init__(
        self,
        *,
        tls_settings: Optional["AFDDomainHttpsParameters"] = None,
        azure_dns_zone: Optional["ResourceReference"] = None,
        pre_validated_custom_domain_resource_id: Optional["ResourceReference"] = None,
        **kwargs
    ):
        """
        :keyword tls_settings: The configuration specifying how to enable HTTPS for the domain - using
         AzureFrontDoor managed certificate or user's own certificate. If not specified, enabling ssl
         uses AzureFrontDoor managed certificate by default.
        :paramtype tls_settings: ~azure.mgmt.cdn.models.AFDDomainHttpsParameters
        :keyword azure_dns_zone: Resource reference to the Azure DNS zone.
        :paramtype azure_dns_zone: ~azure.mgmt.cdn.models.ResourceReference
        :keyword pre_validated_custom_domain_resource_id: Resource reference to the Azure resource
         where custom domain ownership was prevalidated.
        :paramtype pre_validated_custom_domain_resource_id: ~azure.mgmt.cdn.models.ResourceReference
        """
        super(AFDDomainUpdateParameters, self).__init__(**kwargs)
        self.profile_name = None
        self.tls_settings = tls_settings
        self.azure_dns_zone = azure_dns_zone
        self.pre_validated_custom_domain_resource_id = pre_validated_custom_domain_resource_id


class TrackedResource(Resource):
    """The resource model definition for a ARM tracked top level resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar system_data: Read only system data.
    :vartype system_data: ~azure.mgmt.cdn.models.SystemData
    :ivar location: Required. Resource location.
    :vartype location: str
    :ivar tags: A set of tags. Resource tags.
    :vartype tags: dict[str, str]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'location': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        """
        :keyword location: Required. Resource location.
        :paramtype location: str
        :keyword tags: A set of tags. Resource tags.
        :paramtype tags: dict[str, str]
        """
        super(TrackedResource, self).__init__(**kwargs)
        self.location = location
        self.tags = tags


class AFDEndpoint(TrackedResource):
    """CDN endpoint is the entity within a CDN profile containing configuration information such as origin, protocol, content caching and delivery behavior. The AzureFrontDoor endpoint uses the URL format :code:`<endpointname>`.azureedge.net.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar system_data: Read only system data.
    :vartype system_data: ~azure.mgmt.cdn.models.SystemData
    :ivar location: Required. Resource location.
    :vartype location: str
    :ivar tags: A set of tags. Resource tags.
    :vartype tags: dict[str, str]
    :ivar profile_name: The name of the profile which holds the endpoint.
    :vartype profile_name: str
    :ivar enabled_state: Whether to enable use of this rule. Permitted values are 'Enabled' or
     'Disabled'. Possible values include: "Enabled", "Disabled".
    :vartype enabled_state: str or ~azure.mgmt.cdn.models.EnabledState
    :ivar provisioning_state: Provisioning status. Possible values include: "Succeeded", "Failed",
     "Updating", "Deleting", "Creating".
    :vartype provisioning_state: str or ~azure.mgmt.cdn.models.AfdProvisioningState
    :ivar deployment_status: Possible values include: "NotStarted", "InProgress", "Succeeded",
     "Failed".
    :vartype deployment_status: str or ~azure.mgmt.cdn.models.DeploymentStatus
    :ivar host_name: The host name of the endpoint structured as {endpointName}.{DNSZone}, e.g.
     contoso.azureedge.net.
    :vartype host_name: str
    :ivar auto_generated_domain_name_label_scope: Indicates the endpoint name reuse scope. The
     default value is TenantReuse. Possible values include: "TenantReuse", "SubscriptionReuse",
     "ResourceGroupReuse", "NoReuse".
    :vartype auto_generated_domain_name_label_scope: str or
     ~azure.mgmt.cdn.models.AutoGeneratedDomainNameLabelScope
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'location': {'required': True},
        'profile_name': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'deployment_status': {'readonly': True},
        'host_name': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'profile_name': {'key': 'properties.profileName', 'type': 'str'},
        'enabled_state': {'key': 'properties.enabledState', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'deployment_status': {'key': 'properties.deploymentStatus', 'type': 'str'},
        'host_name': {'key': 'properties.hostName', 'type': 'str'},
        'auto_generated_domain_name_label_scope': {'key': 'properties.autoGeneratedDomainNameLabelScope', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        enabled_state: Optional[Union[str, "EnabledState"]] = None,
        auto_generated_domain_name_label_scope: Optional[Union[str, "AutoGeneratedDomainNameLabelScope"]] = None,
        **kwargs
    ):
        """
        :keyword location: Required. Resource location.
        :paramtype location: str
        :keyword tags: A set of tags. Resource tags.
        :paramtype tags: dict[str, str]
        :keyword enabled_state: Whether to enable use of this rule. Permitted values are 'Enabled' or
         'Disabled'. Possible values include: "Enabled", "Disabled".
        :paramtype enabled_state: str or ~azure.mgmt.cdn.models.EnabledState
        :keyword auto_generated_domain_name_label_scope: Indicates the endpoint name reuse scope. The
         default value is TenantReuse. Possible values include: "TenantReuse", "SubscriptionReuse",
         "ResourceGroupReuse", "NoReuse".
        :paramtype auto_generated_domain_name_label_scope: str or
         ~azure.mgmt.cdn.models.AutoGeneratedDomainNameLabelScope
        """
        super(AFDEndpoint, self).__init__(location=location, tags=tags, **kwargs)
        self.profile_name = None
        self.enabled_state = enabled_state
        self.provisioning_state = None
        self.deployment_status = None
        self.host_name = None
        self.auto_generated_domain_name_label_scope = auto_generated_domain_name_label_scope


class AFDEndpointListResult(msrest.serialization.Model):
    """Result of the request to list endpoints. It contains a list of endpoint objects and a URL link to get the next set of results.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of AzureFrontDoor endpoints within a profile.
    :vartype value: list[~azure.mgmt.cdn.models.AFDEndpoint]
    :ivar next_link: URL to get the next set of endpoint objects if there is any.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[AFDEndpoint]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        next_link: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword next_link: URL to get the next set of endpoint objects if there is any.
        :paramtype next_link: str
        """
        super(AFDEndpointListResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = next_link


class AFDEndpointPropertiesUpdateParameters(msrest.serialization.Model):
    """The JSON object containing endpoint update parameters.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar profile_name: The name of the profile which holds the endpoint.
    :vartype profile_name: str
    :ivar enabled_state: Whether to enable use of this rule. Permitted values are 'Enabled' or
     'Disabled'. Possible values include: "Enabled", "Disabled".
    :vartype enabled_state: str or ~azure.mgmt.cdn.models.EnabledState
    """

    _validation = {
        'profile_name': {'readonly': True},
    }

    _attribute_map = {
        'profile_name': {'key': 'profileName', 'type': 'str'},
        'enabled_state': {'key': 'enabledState', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        enabled_state: Optional[Union[str, "EnabledState"]] = None,
        **kwargs
    ):
        """
        :keyword enabled_state: Whether to enable use of this rule. Permitted values are 'Enabled' or
         'Disabled'. Possible values include: "Enabled", "Disabled".
        :paramtype enabled_state: str or ~azure.mgmt.cdn.models.EnabledState
        """
        super(AFDEndpointPropertiesUpdateParameters, self).__init__(**kwargs)
        self.profile_name = None
        self.enabled_state = enabled_state


class AFDEndpointProperties(AFDStateProperties, AFDEndpointPropertiesUpdateParameters):
    """The JSON object that contains the properties required to create an endpoint.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar profile_name: The name of the profile which holds the endpoint.
    :vartype profile_name: str
    :ivar enabled_state: Whether to enable use of this rule. Permitted values are 'Enabled' or
     'Disabled'. Possible values include: "Enabled", "Disabled".
    :vartype enabled_state: str or ~azure.mgmt.cdn.models.EnabledState
    :ivar provisioning_state: Provisioning status. Possible values include: "Succeeded", "Failed",
     "Updating", "Deleting", "Creating".
    :vartype provisioning_state: str or ~azure.mgmt.cdn.models.AfdProvisioningState
    :ivar deployment_status: Possible values include: "NotStarted", "InProgress", "Succeeded",
     "Failed".
    :vartype deployment_status: str or ~azure.mgmt.cdn.models.DeploymentStatus
    :ivar host_name: The host name of the endpoint structured as {endpointName}.{DNSZone}, e.g.
     contoso.azureedge.net.
    :vartype host_name: str
    :ivar auto_generated_domain_name_label_scope: Indicates the endpoint name reuse scope. The
     default value is TenantReuse. Possible values include: "TenantReuse", "SubscriptionReuse",
     "ResourceGroupReuse", "NoReuse".
    :vartype auto_generated_domain_name_label_scope: str or
     ~azure.mgmt.cdn.models.AutoGeneratedDomainNameLabelScope
    """

    _validation = {
        'profile_name': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'deployment_status': {'readonly': True},
        'host_name': {'readonly': True},
    }

    _attribute_map = {
        'profile_name': {'key': 'profileName', 'type': 'str'},
        'enabled_state': {'key': 'enabledState', 'type': 'str'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
        'deployment_status': {'key': 'deploymentStatus', 'type': 'str'},
        'host_name': {'key': 'hostName', 'type': 'str'},
        'auto_generated_domain_name_label_scope': {'key': 'autoGeneratedDomainNameLabelScope', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        enabled_state: Optional[Union[str, "EnabledState"]] = None,
        auto_generated_domain_name_label_scope: Optional[Union[str, "AutoGeneratedDomainNameLabelScope"]] = None,
        **kwargs
    ):
        """
        :keyword enabled_state: Whether to enable use of this rule. Permitted values are 'Enabled' or
         'Disabled'. Possible values include: "Enabled", "Disabled".
        :paramtype enabled_state: str or ~azure.mgmt.cdn.models.EnabledState
        :keyword auto_generated_domain_name_label_scope: Indicates the endpoint name reuse scope. The
         default value is TenantReuse. Possible values include: "TenantReuse", "SubscriptionReuse",
         "ResourceGroupReuse", "NoReuse".
        :paramtype auto_generated_domain_name_label_scope: str or
         ~azure.mgmt.cdn.models.AutoGeneratedDomainNameLabelScope
        """
        super(AFDEndpointProperties, self).__init__(enabled_state=enabled_state, **kwargs)
        self.profile_name = None
        self.enabled_state = enabled_state
        self.host_name = None
        self.auto_generated_domain_name_label_scope = auto_generated_domain_name_label_scope
        self.provisioning_state = None
        self.deployment_status = None
        self.host_name = None
        self.auto_generated_domain_name_label_scope = auto_generated_domain_name_label_scope


class AFDEndpointUpdateParameters(msrest.serialization.Model):
    """Properties required to create or update an endpoint.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar tags: A set of tags. Endpoint tags.
    :vartype tags: dict[str, str]
    :ivar profile_name: The name of the profile which holds the endpoint.
    :vartype profile_name: str
    :ivar enabled_state: Whether to enable use of this rule. Permitted values are 'Enabled' or
     'Disabled'. Possible values include: "Enabled", "Disabled".
    :vartype enabled_state: str or ~azure.mgmt.cdn.models.EnabledState
    """

    _validation = {
        'profile_name': {'readonly': True},
    }

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
        'profile_name': {'key': 'properties.profileName', 'type': 'str'},
        'enabled_state': {'key': 'properties.enabledState', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        enabled_state: Optional[Union[str, "EnabledState"]] = None,
        **kwargs
    ):
        """
        :keyword tags: A set of tags. Endpoint tags.
        :paramtype tags: dict[str, str]
        :keyword enabled_state: Whether to enable use of this rule. Permitted values are 'Enabled' or
         'Disabled'. Possible values include: "Enabled", "Disabled".
        :paramtype enabled_state: str or ~azure.mgmt.cdn.models.EnabledState
        """
        super(AFDEndpointUpdateParameters, self).__init__(**kwargs)
        self.tags = tags
        self.profile_name = None
        self.enabled_state = enabled_state


class AfdErrorResponse(msrest.serialization.Model):
    """Common error response for all Azure Resource Manager APIs to return error details for failed operations. (This also follows the OData error response format.).

    :ivar error: The error object.
    :vartype error: ~azure.mgmt.cdn.models.ErrorDetail
    """

    _attribute_map = {
        'error': {'key': 'error', 'type': 'ErrorDetail'},
    }

    def __init__(
        self,
        *,
        error: Optional["ErrorDetail"] = None,
        **kwargs
    ):
        """
        :keyword error: The error object.
        :paramtype error: ~azure.mgmt.cdn.models.ErrorDetail
        """
        super(AfdErrorResponse, self).__init__(**kwargs)
        self.error = error


class AFDOrigin(ProxyResource):
    """CDN origin is the source of the content being delivered via CDN. When the edge nodes represented by an endpoint do not have the requested content cached, they attempt to fetch it from one or more of the configured origins.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar system_data: Read only system data.
    :vartype system_data: ~azure.mgmt.cdn.models.SystemData
    :ivar origin_group_name: The name of the origin group which contains this origin.
    :vartype origin_group_name: str
    :ivar azure_origin: Resource reference to the Azure origin resource.
    :vartype azure_origin: ~azure.mgmt.cdn.models.ResourceReference
    :ivar host_name: The address of the origin. Domain names, IPv4 addresses, and IPv6 addresses
     are supported.This should be unique across all origins in an endpoint.
    :vartype host_name: str
    :ivar http_port: The value of the HTTP port. Must be between 1 and 65535.
    :vartype http_port: int
    :ivar https_port: The value of the HTTPS port. Must be between 1 and 65535.
    :vartype https_port: int
    :ivar origin_host_header: The host header value sent to the origin with each request. If you
     leave this blank, the request hostname determines this value. Azure CDN origins, such as Web
     Apps, Blob Storage, and Cloud Services require this host header value to match the origin
     hostname by default. This overrides the host header defined at Endpoint.
    :vartype origin_host_header: str
    :ivar priority: Priority of origin in given origin group for load balancing. Higher priorities
     will not be used for load balancing if any lower priority origin is healthy.Must be between 1
     and 5.
    :vartype priority: int
    :ivar weight: Weight of the origin in given origin group for load balancing. Must be between 1
     and 1000.
    :vartype weight: int
    :ivar shared_private_link_resource: The properties of the private link resource for private
     origin.
    :vartype shared_private_link_resource:
     ~azure.mgmt.cdn.models.SharedPrivateLinkResourceProperties
    :ivar enabled_state: Whether to enable health probes to be made against backends defined under
     backendPools. Health probes can only be disabled if there is a single enabled backend in single
     enabled backend pool. Possible values include: "Enabled", "Disabled".
    :vartype enabled_state: str or ~azure.mgmt.cdn.models.EnabledState
    :ivar enforce_certificate_name_check: Whether to enable certificate name check at origin level.
    :vartype enforce_certificate_name_check: bool
    :ivar provisioning_state: Provisioning status. Possible values include: "Succeeded", "Failed",
     "Updating", "Deleting", "Creating".
    :vartype provisioning_state: str or ~azure.mgmt.cdn.models.AfdProvisioningState
    :ivar deployment_status: Possible values include: "NotStarted", "InProgress", "Succeeded",
     "Failed".
    :vartype deployment_status: str or ~azure.mgmt.cdn.models.DeploymentStatus
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'origin_group_name': {'readonly': True},
        'http_port': {'maximum': 65535, 'minimum': 1},
        'https_port': {'maximum': 65535, 'minimum': 1},
        'priority': {'maximum': 5, 'minimum': 1},
        'weight': {'maximum': 1000, 'minimum': 1},
        'provisioning_state': {'readonly': True},
        'deployment_status': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'origin_group_name': {'key': 'properties.originGroupName', 'type': 'str'},
        'azure_origin': {'key': 'properties.azureOrigin', 'type': 'ResourceReference'},
        'host_name': {'key': 'properties.hostName', 'type': 'str'},
        'http_port': {'key': 'properties.httpPort', 'type': 'int'},
        'https_port': {'key': 'properties.httpsPort', 'type': 'int'},
        'origin_host_header': {'key': 'properties.originHostHeader', 'type': 'str'},
        'priority': {'key': 'properties.priority', 'type': 'int'},
        'weight': {'key': 'properties.weight', 'type': 'int'},
        'shared_private_link_resource': {'key': 'properties.sharedPrivateLinkResource', 'type': 'SharedPrivateLinkResourceProperties'},
        'enabled_state': {'key': 'properties.enabledState', 'type': 'str'},
        'enforce_certificate_name_check': {'key': 'properties.enforceCertificateNameCheck', 'type': 'bool'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'deployment_status': {'key': 'properties.deploymentStatus', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        azure_origin: Optional["ResourceReference"] = None,
        host_name: Optional[str] = None,
        http_port: Optional[int] = None,
        https_port: Optional[int] = None,
        origin_host_header: Optional[str] = None,
        priority: Optional[int] = None,
        weight: Optional[int] = None,
        shared_private_link_resource: Optional["SharedPrivateLinkResourceProperties"] = None,
        enabled_state: Optional[Union[str, "EnabledState"]] = None,
        enforce_certificate_name_check: Optional[bool] = True,
        **kwargs
    ):
        """
        :keyword azure_origin: Resource reference to the Azure origin resource.
        :paramtype azure_origin: ~azure.mgmt.cdn.models.ResourceReference
        :keyword host_name: The address of the origin. Domain names, IPv4 addresses, and IPv6 addresses
         are supported.This should be unique across all origins in an endpoint.
        :paramtype host_name: str
        :keyword http_port: The value of the HTTP port. Must be between 1 and 65535.
        :paramtype http_port: int
        :keyword https_port: The value of the HTTPS port. Must be between 1 and 65535.
        :paramtype https_port: int
        :keyword origin_host_header: The host header value sent to the origin with each request. If you
         leave this blank, the request hostname determines this value. Azure CDN origins, such as Web
         Apps, Blob Storage, and Cloud Services require this host header value to match the origin
         hostname by default. This overrides the host header defined at Endpoint.
        :paramtype origin_host_header: str
        :keyword priority: Priority of origin in given origin group for load balancing. Higher
         priorities will not be used for load balancing if any lower priority origin is healthy.Must be
         between 1 and 5.
        :paramtype priority: int
        :keyword weight: Weight of the origin in given origin group for load balancing. Must be between
         1 and 1000.
        :paramtype weight: int
        :keyword shared_private_link_resource: The properties of the private link resource for private
         origin.
        :paramtype shared_private_link_resource:
         ~azure.mgmt.cdn.models.SharedPrivateLinkResourceProperties
        :keyword enabled_state: Whether to enable health probes to be made against backends defined
         under backendPools. Health probes can only be disabled if there is a single enabled backend in
         single enabled backend pool. Possible values include: "Enabled", "Disabled".
        :paramtype enabled_state: str or ~azure.mgmt.cdn.models.EnabledState
        :keyword enforce_certificate_name_check: Whether to enable certificate name check at origin
         level.
        :paramtype enforce_certificate_name_check: bool
        """
        super(AFDOrigin, self).__init__(**kwargs)
        self.origin_group_name = None
        self.azure_origin = azure_origin
        self.host_name = host_name
        self.http_port = http_port
        self.https_port = https_port
        self.origin_host_header = origin_host_header
        self.priority = priority
        self.weight = weight
        self.shared_private_link_resource = shared_private_link_resource
        self.enabled_state = enabled_state
        self.enforce_certificate_name_check = enforce_certificate_name_check
        self.provisioning_state = None
        self.deployment_status = None


class AFDOriginGroup(ProxyResource):
    """AFDOrigin group comprising of origins is used for load balancing to origins when the content cannot be served from CDN.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar system_data: Read only system data.
    :vartype system_data: ~azure.mgmt.cdn.models.SystemData
    :ivar profile_name: The name of the profile which holds the origin group.
    :vartype profile_name: str
    :ivar load_balancing_settings: Load balancing settings for a backend pool.
    :vartype load_balancing_settings: ~azure.mgmt.cdn.models.LoadBalancingSettingsParameters
    :ivar health_probe_settings: Health probe settings to the origin that is used to determine the
     health of the origin.
    :vartype health_probe_settings: ~azure.mgmt.cdn.models.HealthProbeParameters
    :ivar traffic_restoration_time_to_healed_or_new_endpoints_in_minutes: Time in minutes to shift
     the traffic to the endpoint gradually when an unhealthy endpoint comes healthy or a new
     endpoint is added. Default is 10 mins. This property is currently not supported.
    :vartype traffic_restoration_time_to_healed_or_new_endpoints_in_minutes: int
    :ivar session_affinity_state: Whether to allow session affinity on this host. Valid options are
     'Enabled' or 'Disabled'. Possible values include: "Enabled", "Disabled".
    :vartype session_affinity_state: str or ~azure.mgmt.cdn.models.EnabledState
    :ivar provisioning_state: Provisioning status. Possible values include: "Succeeded", "Failed",
     "Updating", "Deleting", "Creating".
    :vartype provisioning_state: str or ~azure.mgmt.cdn.models.AfdProvisioningState
    :ivar deployment_status: Possible values include: "NotStarted", "InProgress", "Succeeded",
     "Failed".
    :vartype deployment_status: str or ~azure.mgmt.cdn.models.DeploymentStatus
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'profile_name': {'readonly': True},
        'traffic_restoration_time_to_healed_or_new_endpoints_in_minutes': {'maximum': 50, 'minimum': 0},
        'provisioning_state': {'readonly': True},
        'deployment_status': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'profile_name': {'key': 'properties.profileName', 'type': 'str'},
        'load_balancing_settings': {'key': 'properties.loadBalancingSettings', 'type': 'LoadBalancingSettingsParameters'},
        'health_probe_settings': {'key': 'properties.healthProbeSettings', 'type': 'HealthProbeParameters'},
        'traffic_restoration_time_to_healed_or_new_endpoints_in_minutes': {'key': 'properties.trafficRestorationTimeToHealedOrNewEndpointsInMinutes', 'type': 'int'},
        'session_affinity_state': {'key': 'properties.sessionAffinityState', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'deployment_status': {'key': 'properties.deploymentStatus', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        load_balancing_settings: Optional["LoadBalancingSettingsParameters"] = None,
        health_probe_settings: Optional["HealthProbeParameters"] = None,
        traffic_restoration_time_to_healed_or_new_endpoints_in_minutes: Optional[int] = None,
        session_affinity_state: Optional[Union[str, "EnabledState"]] = None,
        **kwargs
    ):
        """
        :keyword load_balancing_settings: Load balancing settings for a backend pool.
        :paramtype load_balancing_settings: ~azure.mgmt.cdn.models.LoadBalancingSettingsParameters
        :keyword health_probe_settings: Health probe settings to the origin that is used to determine
         the health of the origin.
        :paramtype health_probe_settings: ~azure.mgmt.cdn.models.HealthProbeParameters
        :keyword traffic_restoration_time_to_healed_or_new_endpoints_in_minutes: Time in minutes to
         shift the traffic to the endpoint gradually when an unhealthy endpoint comes healthy or a new
         endpoint is added. Default is 10 mins. This property is currently not supported.
        :paramtype traffic_restoration_time_to_healed_or_new_endpoints_in_minutes: int
        :keyword session_affinity_state: Whether to allow session affinity on this host. Valid options
         are 'Enabled' or 'Disabled'. Possible values include: "Enabled", "Disabled".
        :paramtype session_affinity_state: str or ~azure.mgmt.cdn.models.EnabledState
        """
        super(AFDOriginGroup, self).__init__(**kwargs)
        self.profile_name = None
        self.load_balancing_settings = load_balancing_settings
        self.health_probe_settings = health_probe_settings
        self.traffic_restoration_time_to_healed_or_new_endpoints_in_minutes = traffic_restoration_time_to_healed_or_new_endpoints_in_minutes
        self.session_affinity_state = session_affinity_state
        self.provisioning_state = None
        self.deployment_status = None


class AFDOriginGroupListResult(msrest.serialization.Model):
    """Result of the request to list origin groups. It contains a list of origin groups objects and a URL link to get the next set of results.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of CDN origin groups within an endpoint.
    :vartype value: list[~azure.mgmt.cdn.models.AFDOriginGroup]
    :ivar next_link: URL to get the next set of origin objects if there are any.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[AFDOriginGroup]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        next_link: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword next_link: URL to get the next set of origin objects if there are any.
        :paramtype next_link: str
        """
        super(AFDOriginGroupListResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = next_link


class AFDOriginGroupUpdatePropertiesParameters(msrest.serialization.Model):
    """The JSON object that contains the properties of the origin group.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar profile_name: The name of the profile which holds the origin group.
    :vartype profile_name: str
    :ivar load_balancing_settings: Load balancing settings for a backend pool.
    :vartype load_balancing_settings: ~azure.mgmt.cdn.models.LoadBalancingSettingsParameters
    :ivar health_probe_settings: Health probe settings to the origin that is used to determine the
     health of the origin.
    :vartype health_probe_settings: ~azure.mgmt.cdn.models.HealthProbeParameters
    :ivar traffic_restoration_time_to_healed_or_new_endpoints_in_minutes: Time in minutes to shift
     the traffic to the endpoint gradually when an unhealthy endpoint comes healthy or a new
     endpoint is added. Default is 10 mins. This property is currently not supported.
    :vartype traffic_restoration_time_to_healed_or_new_endpoints_in_minutes: int
    :ivar session_affinity_state: Whether to allow session affinity on this host. Valid options are
     'Enabled' or 'Disabled'. Possible values include: "Enabled", "Disabled".
    :vartype session_affinity_state: str or ~azure.mgmt.cdn.models.EnabledState
    """

    _validation = {
        'profile_name': {'readonly': True},
        'traffic_restoration_time_to_healed_or_new_endpoints_in_minutes': {'maximum': 50, 'minimum': 0},
    }

    _attribute_map = {
        'profile_name': {'key': 'profileName', 'type': 'str'},
        'load_balancing_settings': {'key': 'loadBalancingSettings', 'type': 'LoadBalancingSettingsParameters'},
        'health_probe_settings': {'key': 'healthProbeSettings', 'type': 'HealthProbeParameters'},
        'traffic_restoration_time_to_healed_or_new_endpoints_in_minutes': {'key': 'trafficRestorationTimeToHealedOrNewEndpointsInMinutes', 'type': 'int'},
        'session_affinity_state': {'key': 'sessionAffinityState', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        load_balancing_settings: Optional["LoadBalancingSettingsParameters"] = None,
        health_probe_settings: Optional["HealthProbeParameters"] = None,
        traffic_restoration_time_to_healed_or_new_endpoints_in_minutes: Optional[int] = None,
        session_affinity_state: Optional[Union[str, "EnabledState"]] = None,
        **kwargs
    ):
        """
        :keyword load_balancing_settings: Load balancing settings for a backend pool.
        :paramtype load_balancing_settings: ~azure.mgmt.cdn.models.LoadBalancingSettingsParameters
        :keyword health_probe_settings: Health probe settings to the origin that is used to determine
         the health of the origin.
        :paramtype health_probe_settings: ~azure.mgmt.cdn.models.HealthProbeParameters
        :keyword traffic_restoration_time_to_healed_or_new_endpoints_in_minutes: Time in minutes to
         shift the traffic to the endpoint gradually when an unhealthy endpoint comes healthy or a new
         endpoint is added. Default is 10 mins. This property is currently not supported.
        :paramtype traffic_restoration_time_to_healed_or_new_endpoints_in_minutes: int
        :keyword session_affinity_state: Whether to allow session affinity on this host. Valid options
         are 'Enabled' or 'Disabled'. Possible values include: "Enabled", "Disabled".
        :paramtype session_affinity_state: str or ~azure.mgmt.cdn.models.EnabledState
        """
        super(AFDOriginGroupUpdatePropertiesParameters, self).__init__(**kwargs)
        self.profile_name = None
        self.load_balancing_settings = load_balancing_settings
        self.health_probe_settings = health_probe_settings
        self.traffic_restoration_time_to_healed_or_new_endpoints_in_minutes = traffic_restoration_time_to_healed_or_new_endpoints_in_minutes
        self.session_affinity_state = session_affinity_state


class AFDOriginGroupProperties(AFDStateProperties, AFDOriginGroupUpdatePropertiesParameters):
    """The JSON object that contains the properties of the origin group.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar profile_name: The name of the profile which holds the origin group.
    :vartype profile_name: str
    :ivar load_balancing_settings: Load balancing settings for a backend pool.
    :vartype load_balancing_settings: ~azure.mgmt.cdn.models.LoadBalancingSettingsParameters
    :ivar health_probe_settings: Health probe settings to the origin that is used to determine the
     health of the origin.
    :vartype health_probe_settings: ~azure.mgmt.cdn.models.HealthProbeParameters
    :ivar traffic_restoration_time_to_healed_or_new_endpoints_in_minutes: Time in minutes to shift
     the traffic to the endpoint gradually when an unhealthy endpoint comes healthy or a new
     endpoint is added. Default is 10 mins. This property is currently not supported.
    :vartype traffic_restoration_time_to_healed_or_new_endpoints_in_minutes: int
    :ivar session_affinity_state: Whether to allow session affinity on this host. Valid options are
     'Enabled' or 'Disabled'. Possible values include: "Enabled", "Disabled".
    :vartype session_affinity_state: str or ~azure.mgmt.cdn.models.EnabledState
    :ivar provisioning_state: Provisioning status. Possible values include: "Succeeded", "Failed",
     "Updating", "Deleting", "Creating".
    :vartype provisioning_state: str or ~azure.mgmt.cdn.models.AfdProvisioningState
    :ivar deployment_status: Possible values include: "NotStarted", "InProgress", "Succeeded",
     "Failed".
    :vartype deployment_status: str or ~azure.mgmt.cdn.models.DeploymentStatus
    """

    _validation = {
        'profile_name': {'readonly': True},
        'traffic_restoration_time_to_healed_or_new_endpoints_in_minutes': {'maximum': 50, 'minimum': 0},
        'provisioning_state': {'readonly': True},
        'deployment_status': {'readonly': True},
    }

    _attribute_map = {
        'profile_name': {'key': 'profileName', 'type': 'str'},
        'load_balancing_settings': {'key': 'loadBalancingSettings', 'type': 'LoadBalancingSettingsParameters'},
        'health_probe_settings': {'key': 'healthProbeSettings', 'type': 'HealthProbeParameters'},
        'traffic_restoration_time_to_healed_or_new_endpoints_in_minutes': {'key': 'trafficRestorationTimeToHealedOrNewEndpointsInMinutes', 'type': 'int'},
        'session_affinity_state': {'key': 'sessionAffinityState', 'type': 'str'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
        'deployment_status': {'key': 'deploymentStatus', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        load_balancing_settings: Optional["LoadBalancingSettingsParameters"] = None,
        health_probe_settings: Optional["HealthProbeParameters"] = None,
        traffic_restoration_time_to_healed_or_new_endpoints_in_minutes: Optional[int] = None,
        session_affinity_state: Optional[Union[str, "EnabledState"]] = None,
        **kwargs
    ):
        """
        :keyword load_balancing_settings: Load balancing settings for a backend pool.
        :paramtype load_balancing_settings: ~azure.mgmt.cdn.models.LoadBalancingSettingsParameters
        :keyword health_probe_settings: Health probe settings to the origin that is used to determine
         the health of the origin.
        :paramtype health_probe_settings: ~azure.mgmt.cdn.models.HealthProbeParameters
        :keyword traffic_restoration_time_to_healed_or_new_endpoints_in_minutes: Time in minutes to
         shift the traffic to the endpoint gradually when an unhealthy endpoint comes healthy or a new
         endpoint is added. Default is 10 mins. This property is currently not supported.
        :paramtype traffic_restoration_time_to_healed_or_new_endpoints_in_minutes: int
        :keyword session_affinity_state: Whether to allow session affinity on this host. Valid options
         are 'Enabled' or 'Disabled'. Possible values include: "Enabled", "Disabled".
        :paramtype session_affinity_state: str or ~azure.mgmt.cdn.models.EnabledState
        """
        super(AFDOriginGroupProperties, self).__init__(load_balancing_settings=load_balancing_settings, health_probe_settings=health_probe_settings, traffic_restoration_time_to_healed_or_new_endpoints_in_minutes=traffic_restoration_time_to_healed_or_new_endpoints_in_minutes, session_affinity_state=session_affinity_state, **kwargs)
        self.profile_name = None
        self.load_balancing_settings = load_balancing_settings
        self.health_probe_settings = health_probe_settings
        self.traffic_restoration_time_to_healed_or_new_endpoints_in_minutes = traffic_restoration_time_to_healed_or_new_endpoints_in_minutes
        self.session_affinity_state = session_affinity_state
        self.provisioning_state = None
        self.deployment_status = None


class AFDOriginGroupUpdateParameters(msrest.serialization.Model):
    """AFDOrigin group properties needed for origin group creation or update.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar profile_name: The name of the profile which holds the origin group.
    :vartype profile_name: str
    :ivar load_balancing_settings: Load balancing settings for a backend pool.
    :vartype load_balancing_settings: ~azure.mgmt.cdn.models.LoadBalancingSettingsParameters
    :ivar health_probe_settings: Health probe settings to the origin that is used to determine the
     health of the origin.
    :vartype health_probe_settings: ~azure.mgmt.cdn.models.HealthProbeParameters
    :ivar traffic_restoration_time_to_healed_or_new_endpoints_in_minutes: Time in minutes to shift
     the traffic to the endpoint gradually when an unhealthy endpoint comes healthy or a new
     endpoint is added. Default is 10 mins. This property is currently not supported.
    :vartype traffic_restoration_time_to_healed_or_new_endpoints_in_minutes: int
    :ivar session_affinity_state: Whether to allow session affinity on this host. Valid options are
     'Enabled' or 'Disabled'. Possible values include: "Enabled", "Disabled".
    :vartype session_affinity_state: str or ~azure.mgmt.cdn.models.EnabledState
    """

    _validation = {
        'profile_name': {'readonly': True},
        'traffic_restoration_time_to_healed_or_new_endpoints_in_minutes': {'maximum': 50, 'minimum': 0},
    }

    _attribute_map = {
        'profile_name': {'key': 'properties.profileName', 'type': 'str'},
        'load_balancing_settings': {'key': 'properties.loadBalancingSettings', 'type': 'LoadBalancingSettingsParameters'},
        'health_probe_settings': {'key': 'properties.healthProbeSettings', 'type': 'HealthProbeParameters'},
        'traffic_restoration_time_to_healed_or_new_endpoints_in_minutes': {'key': 'properties.trafficRestorationTimeToHealedOrNewEndpointsInMinutes', 'type': 'int'},
        'session_affinity_state': {'key': 'properties.sessionAffinityState', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        load_balancing_settings: Optional["LoadBalancingSettingsParameters"] = None,
        health_probe_settings: Optional["HealthProbeParameters"] = None,
        traffic_restoration_time_to_healed_or_new_endpoints_in_minutes: Optional[int] = None,
        session_affinity_state: Optional[Union[str, "EnabledState"]] = None,
        **kwargs
    ):
        """
        :keyword load_balancing_settings: Load balancing settings for a backend pool.
        :paramtype load_balancing_settings: ~azure.mgmt.cdn.models.LoadBalancingSettingsParameters
        :keyword health_probe_settings: Health probe settings to the origin that is used to determine
         the health of the origin.
        :paramtype health_probe_settings: ~azure.mgmt.cdn.models.HealthProbeParameters
        :keyword traffic_restoration_time_to_healed_or_new_endpoints_in_minutes: Time in minutes to
         shift the traffic to the endpoint gradually when an unhealthy endpoint comes healthy or a new
         endpoint is added. Default is 10 mins. This property is currently not supported.
        :paramtype traffic_restoration_time_to_healed_or_new_endpoints_in_minutes: int
        :keyword session_affinity_state: Whether to allow session affinity on this host. Valid options
         are 'Enabled' or 'Disabled'. Possible values include: "Enabled", "Disabled".
        :paramtype session_affinity_state: str or ~azure.mgmt.cdn.models.EnabledState
        """
        super(AFDOriginGroupUpdateParameters, self).__init__(**kwargs)
        self.profile_name = None
        self.load_balancing_settings = load_balancing_settings
        self.health_probe_settings = health_probe_settings
        self.traffic_restoration_time_to_healed_or_new_endpoints_in_minutes = traffic_restoration_time_to_healed_or_new_endpoints_in_minutes
        self.session_affinity_state = session_affinity_state


class AFDOriginListResult(msrest.serialization.Model):
    """Result of the request to list origins. It contains a list of origin objects and a URL link to get the next set of results.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of CDN origins within an endpoint.
    :vartype value: list[~azure.mgmt.cdn.models.AFDOrigin]
    :ivar next_link: URL to get the next set of origin objects if there are any.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[AFDOrigin]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        next_link: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword next_link: URL to get the next set of origin objects if there are any.
        :paramtype next_link: str
        """
        super(AFDOriginListResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = next_link


class AFDOriginUpdatePropertiesParameters(msrest.serialization.Model):
    """The JSON object that contains the properties of the origin.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar origin_group_name: The name of the origin group which contains this origin.
    :vartype origin_group_name: str
    :ivar azure_origin: Resource reference to the Azure origin resource.
    :vartype azure_origin: ~azure.mgmt.cdn.models.ResourceReference
    :ivar host_name: The address of the origin. Domain names, IPv4 addresses, and IPv6 addresses
     are supported.This should be unique across all origins in an endpoint.
    :vartype host_name: str
    :ivar http_port: The value of the HTTP port. Must be between 1 and 65535.
    :vartype http_port: int
    :ivar https_port: The value of the HTTPS port. Must be between 1 and 65535.
    :vartype https_port: int
    :ivar origin_host_header: The host header value sent to the origin with each request. If you
     leave this blank, the request hostname determines this value. Azure CDN origins, such as Web
     Apps, Blob Storage, and Cloud Services require this host header value to match the origin
     hostname by default. This overrides the host header defined at Endpoint.
    :vartype origin_host_header: str
    :ivar priority: Priority of origin in given origin group for load balancing. Higher priorities
     will not be used for load balancing if any lower priority origin is healthy.Must be between 1
     and 5.
    :vartype priority: int
    :ivar weight: Weight of the origin in given origin group for load balancing. Must be between 1
     and 1000.
    :vartype weight: int
    :ivar shared_private_link_resource: The properties of the private link resource for private
     origin.
    :vartype shared_private_link_resource:
     ~azure.mgmt.cdn.models.SharedPrivateLinkResourceProperties
    :ivar enabled_state: Whether to enable health probes to be made against backends defined under
     backendPools. Health probes can only be disabled if there is a single enabled backend in single
     enabled backend pool. Possible values include: "Enabled", "Disabled".
    :vartype enabled_state: str or ~azure.mgmt.cdn.models.EnabledState
    :ivar enforce_certificate_name_check: Whether to enable certificate name check at origin level.
    :vartype enforce_certificate_name_check: bool
    """

    _validation = {
        'origin_group_name': {'readonly': True},
        'http_port': {'maximum': 65535, 'minimum': 1},
        'https_port': {'maximum': 65535, 'minimum': 1},
        'priority': {'maximum': 5, 'minimum': 1},
        'weight': {'maximum': 1000, 'minimum': 1},
    }

    _attribute_map = {
        'origin_group_name': {'key': 'originGroupName', 'type': 'str'},
        'azure_origin': {'key': 'azureOrigin', 'type': 'ResourceReference'},
        'host_name': {'key': 'hostName', 'type': 'str'},
        'http_port': {'key': 'httpPort', 'type': 'int'},
        'https_port': {'key': 'httpsPort', 'type': 'int'},
        'origin_host_header': {'key': 'originHostHeader', 'type': 'str'},
        'priority': {'key': 'priority', 'type': 'int'},
        'weight': {'key': 'weight', 'type': 'int'},
        'shared_private_link_resource': {'key': 'sharedPrivateLinkResource', 'type': 'SharedPrivateLinkResourceProperties'},
        'enabled_state': {'key': 'enabledState', 'type': 'str'},
        'enforce_certificate_name_check': {'key': 'enforceCertificateNameCheck', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        azure_origin: Optional["ResourceReference"] = None,
        host_name: Optional[str] = None,
        http_port: Optional[int] = None,
        https_port: Optional[int] = None,
        origin_host_header: Optional[str] = None,
        priority: Optional[int] = None,
        weight: Optional[int] = None,
        shared_private_link_resource: Optional["SharedPrivateLinkResourceProperties"] = None,
        enabled_state: Optional[Union[str, "EnabledState"]] = None,
        enforce_certificate_name_check: Optional[bool] = True,
        **kwargs
    ):
        """
        :keyword azure_origin: Resource reference to the Azure origin resource.
        :paramtype azure_origin: ~azure.mgmt.cdn.models.ResourceReference
        :keyword host_name: The address of the origin. Domain names, IPv4 addresses, and IPv6 addresses
         are supported.This should be unique across all origins in an endpoint.
        :paramtype host_name: str
        :keyword http_port: The value of the HTTP port. Must be between 1 and 65535.
        :paramtype http_port: int
        :keyword https_port: The value of the HTTPS port. Must be between 1 and 65535.
        :paramtype https_port: int
        :keyword origin_host_header: The host header value sent to the origin with each request. If you
         leave this blank, the request hostname determines this value. Azure CDN origins, such as Web
         Apps, Blob Storage, and Cloud Services require this host header value to match the origin
         hostname by default. This overrides the host header defined at Endpoint.
        :paramtype origin_host_header: str
        :keyword priority: Priority of origin in given origin group for load balancing. Higher
         priorities will not be used for load balancing if any lower priority origin is healthy.Must be
         between 1 and 5.
        :paramtype priority: int
        :keyword weight: Weight of the origin in given origin group for load balancing. Must be between
         1 and 1000.
        :paramtype weight: int
        :keyword shared_private_link_resource: The properties of the private link resource for private
         origin.
        :paramtype shared_private_link_resource:
         ~azure.mgmt.cdn.models.SharedPrivateLinkResourceProperties
        :keyword enabled_state: Whether to enable health probes to be made against backends defined
         under backendPools. Health probes can only be disabled if there is a single enabled backend in
         single enabled backend pool. Possible values include: "Enabled", "Disabled".
        :paramtype enabled_state: str or ~azure.mgmt.cdn.models.EnabledState
        :keyword enforce_certificate_name_check: Whether to enable certificate name check at origin
         level.
        :paramtype enforce_certificate_name_check: bool
        """
        super(AFDOriginUpdatePropertiesParameters, self).__init__(**kwargs)
        self.origin_group_name = None
        self.azure_origin = azure_origin
        self.host_name = host_name
        self.http_port = http_port
        self.https_port = https_port
        self.origin_host_header = origin_host_header
        self.priority = priority
        self.weight = weight
        self.shared_private_link_resource = shared_private_link_resource
        self.enabled_state = enabled_state
        self.enforce_certificate_name_check = enforce_certificate_name_check


class AFDOriginProperties(AFDStateProperties, AFDOriginUpdatePropertiesParameters):
    """The JSON object that contains the properties of the origin.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar origin_group_name: The name of the origin group which contains this origin.
    :vartype origin_group_name: str
    :ivar azure_origin: Resource reference to the Azure origin resource.
    :vartype azure_origin: ~azure.mgmt.cdn.models.ResourceReference
    :ivar host_name: The address of the origin. Domain names, IPv4 addresses, and IPv6 addresses
     are supported.This should be unique across all origins in an endpoint.
    :vartype host_name: str
    :ivar http_port: The value of the HTTP port. Must be between 1 and 65535.
    :vartype http_port: int
    :ivar https_port: The value of the HTTPS port. Must be between 1 and 65535.
    :vartype https_port: int
    :ivar origin_host_header: The host header value sent to the origin with each request. If you
     leave this blank, the request hostname determines this value. Azure CDN origins, such as Web
     Apps, Blob Storage, and Cloud Services require this host header value to match the origin
     hostname by default. This overrides the host header defined at Endpoint.
    :vartype origin_host_header: str
    :ivar priority: Priority of origin in given origin group for load balancing. Higher priorities
     will not be used for load balancing if any lower priority origin is healthy.Must be between 1
     and 5.
    :vartype priority: int
    :ivar weight: Weight of the origin in given origin group for load balancing. Must be between 1
     and 1000.
    :vartype weight: int
    :ivar shared_private_link_resource: The properties of the private link resource for private
     origin.
    :vartype shared_private_link_resource:
     ~azure.mgmt.cdn.models.SharedPrivateLinkResourceProperties
    :ivar enabled_state: Whether to enable health probes to be made against backends defined under
     backendPools. Health probes can only be disabled if there is a single enabled backend in single
     enabled backend pool. Possible values include: "Enabled", "Disabled".
    :vartype enabled_state: str or ~azure.mgmt.cdn.models.EnabledState
    :ivar enforce_certificate_name_check: Whether to enable certificate name check at origin level.
    :vartype enforce_certificate_name_check: bool
    :ivar provisioning_state: Provisioning status. Possible values include: "Succeeded", "Failed",
     "Updating", "Deleting", "Creating".
    :vartype provisioning_state: str or ~azure.mgmt.cdn.models.AfdProvisioningState
    :ivar deployment_status: Possible values include: "NotStarted", "InProgress", "Succeeded",
     "Failed".
    :vartype deployment_status: str or ~azure.mgmt.cdn.models.DeploymentStatus
    """

    _validation = {
        'origin_group_name': {'readonly': True},
        'http_port': {'maximum': 65535, 'minimum': 1},
        'https_port': {'maximum': 65535, 'minimum': 1},
        'priority': {'maximum': 5, 'minimum': 1},
        'weight': {'maximum': 1000, 'minimum': 1},
        'provisioning_state': {'readonly': True},
        'deployment_status': {'readonly': True},
    }

    _attribute_map = {
        'origin_group_name': {'key': 'originGroupName', 'type': 'str'},
        'azure_origin': {'key': 'azureOrigin', 'type': 'ResourceReference'},
        'host_name': {'key': 'hostName', 'type': 'str'},
        'http_port': {'key': 'httpPort', 'type': 'int'},
        'https_port': {'key': 'httpsPort', 'type': 'int'},
        'origin_host_header': {'key': 'originHostHeader', 'type': 'str'},
        'priority': {'key': 'priority', 'type': 'int'},
        'weight': {'key': 'weight', 'type': 'int'},
        'shared_private_link_resource': {'key': 'sharedPrivateLinkResource', 'type': 'SharedPrivateLinkResourceProperties'},
        'enabled_state': {'key': 'enabledState', 'type': 'str'},
        'enforce_certificate_name_check': {'key': 'enforceCertificateNameCheck', 'type': 'bool'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
        'deployment_status': {'key': 'deploymentStatus', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        azure_origin: Optional["ResourceReference"] = None,
        host_name: Optional[str] = None,
        http_port: Optional[int] = None,
        https_port: Optional[int] = None,
        origin_host_header: Optional[str] = None,
        priority: Optional[int] = None,
        weight: Optional[int] = None,
        shared_private_link_resource: Optional["SharedPrivateLinkResourceProperties"] = None,
        enabled_state: Optional[Union[str, "EnabledState"]] = None,
        enforce_certificate_name_check: Optional[bool] = True,
        **kwargs
    ):
        """
        :keyword azure_origin: Resource reference to the Azure origin resource.
        :paramtype azure_origin: ~azure.mgmt.cdn.models.ResourceReference
        :keyword host_name: The address of the origin. Domain names, IPv4 addresses, and IPv6 addresses
         are supported.This should be unique across all origins in an endpoint.
        :paramtype host_name: str
        :keyword http_port: The value of the HTTP port. Must be between 1 and 65535.
        :paramtype http_port: int
        :keyword https_port: The value of the HTTPS port. Must be between 1 and 65535.
        :paramtype https_port: int
        :keyword origin_host_header: The host header value sent to the origin with each request. If you
         leave this blank, the request hostname determines this value. Azure CDN origins, such as Web
         Apps, Blob Storage, and Cloud Services require this host header value to match the origin
         hostname by default. This overrides the host header defined at Endpoint.
        :paramtype origin_host_header: str
        :keyword priority: Priority of origin in given origin group for load balancing. Higher
         priorities will not be used for load balancing if any lower priority origin is healthy.Must be
         between 1 and 5.
        :paramtype priority: int
        :keyword weight: Weight of the origin in given origin group for load balancing. Must be between
         1 and 1000.
        :paramtype weight: int
        :keyword shared_private_link_resource: The properties of the private link resource for private
         origin.
        :paramtype shared_private_link_resource:
         ~azure.mgmt.cdn.models.SharedPrivateLinkResourceProperties
        :keyword enabled_state: Whether to enable health probes to be made against backends defined
         under backendPools. Health probes can only be disabled if there is a single enabled backend in
         single enabled backend pool. Possible values include: "Enabled", "Disabled".
        :paramtype enabled_state: str or ~azure.mgmt.cdn.models.EnabledState
        :keyword enforce_certificate_name_check: Whether to enable certificate name check at origin
         level.
        :paramtype enforce_certificate_name_check: bool
        """
        super(AFDOriginProperties, self).__init__(azure_origin=azure_origin, host_name=host_name, http_port=http_port, https_port=https_port, origin_host_header=origin_host_header, priority=priority, weight=weight, shared_private_link_resource=shared_private_link_resource, enabled_state=enabled_state, enforce_certificate_name_check=enforce_certificate_name_check, **kwargs)
        self.origin_group_name = None
        self.azure_origin = azure_origin
        self.host_name = host_name
        self.http_port = http_port
        self.https_port = https_port
        self.origin_host_header = origin_host_header
        self.priority = priority
        self.weight = weight
        self.shared_private_link_resource = shared_private_link_resource
        self.enabled_state = enabled_state
        self.enforce_certificate_name_check = enforce_certificate_name_check
        self.provisioning_state = None
        self.deployment_status = None


class AFDOriginUpdateParameters(msrest.serialization.Model):
    """AFDOrigin properties needed for origin update.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar origin_group_name: The name of the origin group which contains this origin.
    :vartype origin_group_name: str
    :ivar azure_origin: Resource reference to the Azure origin resource.
    :vartype azure_origin: ~azure.mgmt.cdn.models.ResourceReference
    :ivar host_name: The address of the origin. Domain names, IPv4 addresses, and IPv6 addresses
     are supported.This should be unique across all origins in an endpoint.
    :vartype host_name: str
    :ivar http_port: The value of the HTTP port. Must be between 1 and 65535.
    :vartype http_port: int
    :ivar https_port: The value of the HTTPS port. Must be between 1 and 65535.
    :vartype https_port: int
    :ivar origin_host_header: The host header value sent to the origin with each request. If you
     leave this blank, the request hostname determines this value. Azure CDN origins, such as Web
     Apps, Blob Storage, and Cloud Services require this host header value to match the origin
     hostname by default. This overrides the host header defined at Endpoint.
    :vartype origin_host_header: str
    :ivar priority: Priority of origin in given origin group for load balancing. Higher priorities
     will not be used for load balancing if any lower priority origin is healthy.Must be between 1
     and 5.
    :vartype priority: int
    :ivar weight: Weight of the origin in given origin group for load balancing. Must be between 1
     and 1000.
    :vartype weight: int
    :ivar shared_private_link_resource: The properties of the private link resource for private
     origin.
    :vartype shared_private_link_resource:
     ~azure.mgmt.cdn.models.SharedPrivateLinkResourceProperties
    :ivar enabled_state: Whether to enable health probes to be made against backends defined under
     backendPools. Health probes can only be disabled if there is a single enabled backend in single
     enabled backend pool. Possible values include: "Enabled", "Disabled".
    :vartype enabled_state: str or ~azure.mgmt.cdn.models.EnabledState
    :ivar enforce_certificate_name_check: Whether to enable certificate name check at origin level.
    :vartype enforce_certificate_name_check: bool
    """

    _validation = {
        'origin_group_name': {'readonly': True},
        'http_port': {'maximum': 65535, 'minimum': 1},
        'https_port': {'maximum': 65535, 'minimum': 1},
        'priority': {'maximum': 5, 'minimum': 1},
        'weight': {'maximum': 1000, 'minimum': 1},
    }

    _attribute_map = {
        'origin_group_name': {'key': 'properties.originGroupName', 'type': 'str'},
        'azure_origin': {'key': 'properties.azureOrigin', 'type': 'ResourceReference'},
        'host_name': {'key': 'properties.hostName', 'type': 'str'},
        'http_port': {'key': 'properties.httpPort', 'type': 'int'},
        'https_port': {'key': 'properties.httpsPort', 'type': 'int'},
        'origin_host_header': {'key': 'properties.originHostHeader', 'type': 'str'},
        'priority': {'key': 'properties.priority', 'type': 'int'},
        'weight': {'key': 'properties.weight', 'type': 'int'},
        'shared_private_link_resource': {'key': 'properties.sharedPrivateLinkResource', 'type': 'SharedPrivateLinkResourceProperties'},
        'enabled_state': {'key': 'properties.enabledState', 'type': 'str'},
        'enforce_certificate_name_check': {'key': 'properties.enforceCertificateNameCheck', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        azure_origin: Optional["ResourceReference"] = None,
        host_name: Optional[str] = None,
        http_port: Optional[int] = None,
        https_port: Optional[int] = None,
        origin_host_header: Optional[str] = None,
        priority: Optional[int] = None,
        weight: Optional[int] = None,
        shared_private_link_resource: Optional["SharedPrivateLinkResourceProperties"] = None,
        enabled_state: Optional[Union[str, "EnabledState"]] = None,
        enforce_certificate_name_check: Optional[bool] = True,
        **kwargs
    ):
        """
        :keyword azure_origin: Resource reference to the Azure origin resource.
        :paramtype azure_origin: ~azure.mgmt.cdn.models.ResourceReference
        :keyword host_name: The address of the origin. Domain names, IPv4 addresses, and IPv6 addresses
         are supported.This should be unique across all origins in an endpoint.
        :paramtype host_name: str
        :keyword http_port: The value of the HTTP port. Must be between 1 and 65535.
        :paramtype http_port: int
        :keyword https_port: The value of the HTTPS port. Must be between 1 and 65535.
        :paramtype https_port: int
        :keyword origin_host_header: The host header value sent to the origin with each request. If you
         leave this blank, the request hostname determines this value. Azure CDN origins, such as Web
         Apps, Blob Storage, and Cloud Services require this host header value to match the origin
         hostname by default. This overrides the host header defined at Endpoint.
        :paramtype origin_host_header: str
        :keyword priority: Priority of origin in given origin group for load balancing. Higher
         priorities will not be used for load balancing if any lower priority origin is healthy.Must be
         between 1 and 5.
        :paramtype priority: int
        :keyword weight: Weight of the origin in given origin group for load balancing. Must be between
         1 and 1000.
        :paramtype weight: int
        :keyword shared_private_link_resource: The properties of the private link resource for private
         origin.
        :paramtype shared_private_link_resource:
         ~azure.mgmt.cdn.models.SharedPrivateLinkResourceProperties
        :keyword enabled_state: Whether to enable health probes to be made against backends defined
         under backendPools. Health probes can only be disabled if there is a single enabled backend in
         single enabled backend pool. Possible values include: "Enabled", "Disabled".
        :paramtype enabled_state: str or ~azure.mgmt.cdn.models.EnabledState
        :keyword enforce_certificate_name_check: Whether to enable certificate name check at origin
         level.
        :paramtype enforce_certificate_name_check: bool
        """
        super(AFDOriginUpdateParameters, self).__init__(**kwargs)
        self.origin_group_name = None
        self.azure_origin = azure_origin
        self.host_name = host_name
        self.http_port = http_port
        self.https_port = https_port
        self.origin_host_header = origin_host_header
        self.priority = priority
        self.weight = weight
        self.shared_private_link_resource = shared_private_link_resource
        self.enabled_state = enabled_state
        self.enforce_certificate_name_check = enforce_certificate_name_check


class AfdPurgeParameters(msrest.serialization.Model):
    """Parameters required for content purge.

    All required parameters must be populated in order to send to Azure.

    :ivar content_paths: Required. The path to the content to be purged. Can describe a file path
     or a wild card directory.
    :vartype content_paths: list[str]
    :ivar domains: List of domains.
    :vartype domains: list[str]
    """

    _validation = {
        'content_paths': {'required': True},
    }

    _attribute_map = {
        'content_paths': {'key': 'contentPaths', 'type': '[str]'},
        'domains': {'key': 'domains', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        content_paths: List[str],
        domains: Optional[List[str]] = None,
        **kwargs
    ):
        """
        :keyword content_paths: Required. The path to the content to be purged. Can describe a file
         path or a wild card directory.
        :paramtype content_paths: list[str]
        :keyword domains: List of domains.
        :paramtype domains: list[str]
        """
        super(AfdPurgeParameters, self).__init__(**kwargs)
        self.content_paths = content_paths
        self.domains = domains


class AfdRouteCacheConfiguration(msrest.serialization.Model):
    """Caching settings for a caching-type route. To disable caching, do not provide a cacheConfiguration object.

    :ivar query_string_caching_behavior: Defines how Frontdoor caches requests that include query
     strings. You can ignore any query strings when caching, ignore specific query strings, cache
     every request with a unique URL, or cache specific query strings. Possible values include:
     "IgnoreQueryString", "UseQueryString", "IgnoreSpecifiedQueryStrings",
     "IncludeSpecifiedQueryStrings".
    :vartype query_string_caching_behavior: str or
     ~azure.mgmt.cdn.models.AfdQueryStringCachingBehavior
    :ivar query_parameters: query parameters to include or exclude (comma separated).
    :vartype query_parameters: str
    :ivar compression_settings: compression settings.
    :vartype compression_settings: ~azure.mgmt.cdn.models.CompressionSettings
    """

    _attribute_map = {
        'query_string_caching_behavior': {'key': 'queryStringCachingBehavior', 'type': 'str'},
        'query_parameters': {'key': 'queryParameters', 'type': 'str'},
        'compression_settings': {'key': 'compressionSettings', 'type': 'CompressionSettings'},
    }

    def __init__(
        self,
        *,
        query_string_caching_behavior: Optional[Union[str, "AfdQueryStringCachingBehavior"]] = None,
        query_parameters: Optional[str] = None,
        compression_settings: Optional["CompressionSettings"] = None,
        **kwargs
    ):
        """
        :keyword query_string_caching_behavior: Defines how Frontdoor caches requests that include
         query strings. You can ignore any query strings when caching, ignore specific query strings,
         cache every request with a unique URL, or cache specific query strings. Possible values
         include: "IgnoreQueryString", "UseQueryString", "IgnoreSpecifiedQueryStrings",
         "IncludeSpecifiedQueryStrings".
        :paramtype query_string_caching_behavior: str or
         ~azure.mgmt.cdn.models.AfdQueryStringCachingBehavior
        :keyword query_parameters: query parameters to include or exclude (comma separated).
        :paramtype query_parameters: str
        :keyword compression_settings: compression settings.
        :paramtype compression_settings: ~azure.mgmt.cdn.models.CompressionSettings
        """
        super(AfdRouteCacheConfiguration, self).__init__(**kwargs)
        self.query_string_caching_behavior = query_string_caching_behavior
        self.query_parameters = query_parameters
        self.compression_settings = compression_settings


class Certificate(msrest.serialization.Model):
    """Certificate used for https.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: The type of the secret resource. Possible values include: "UrlSigningKey",
     "CustomerCertificate", "ManagedCertificate", "AzureFirstPartyManagedCertificate".
    :vartype type: str or ~azure.mgmt.cdn.models.SecretType
    :ivar subject: Subject name in the certificate.
    :vartype subject: str
    :ivar expiration_date: Certificate expiration date.
    :vartype expiration_date: str
    """

    _validation = {
        'subject': {'readonly': True},
        'expiration_date': {'readonly': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'subject': {'key': 'subject', 'type': 'str'},
        'expiration_date': {'key': 'expirationDate', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        type: Optional[Union[str, "SecretType"]] = None,
        **kwargs
    ):
        """
        :keyword type: The type of the secret resource. Possible values include: "UrlSigningKey",
         "CustomerCertificate", "ManagedCertificate", "AzureFirstPartyManagedCertificate".
        :paramtype type: str or ~azure.mgmt.cdn.models.SecretType
        """
        super(Certificate, self).__init__(**kwargs)
        self.type = type
        self.subject = None
        self.expiration_date = None


class AzureFirstPartyManagedCertificate(Certificate):
    """Azure FirstParty Managed Certificate provided by other first party resource providers to enable HTTPS.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: The type of the secret resource. Possible values include: "UrlSigningKey",
     "CustomerCertificate", "ManagedCertificate", "AzureFirstPartyManagedCertificate".
    :vartype type: str or ~azure.mgmt.cdn.models.SecretType
    :ivar subject: Subject name in the certificate.
    :vartype subject: str
    :ivar expiration_date: Certificate expiration date.
    :vartype expiration_date: str
    """

    _validation = {
        'subject': {'readonly': True},
        'expiration_date': {'readonly': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'subject': {'key': 'subject', 'type': 'str'},
        'expiration_date': {'key': 'expirationDate', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        type: Optional[Union[str, "SecretType"]] = None,
        **kwargs
    ):
        """
        :keyword type: The type of the secret resource. Possible values include: "UrlSigningKey",
         "CustomerCertificate", "ManagedCertificate", "AzureFirstPartyManagedCertificate".
        :paramtype type: str or ~azure.mgmt.cdn.models.SecretType
        """
        super(AzureFirstPartyManagedCertificate, self).__init__(type=type, **kwargs)


class SecretParameters(msrest.serialization.Model):
    """The json object containing secret parameters.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: AzureFirstPartyManagedCertificateParameters, CustomerCertificateParameters, ManagedCertificateParameters, UrlSigningKeyParameters.

    All required parameters must be populated in order to send to Azure.

    :ivar type: Required. The type of the secret resource.Constant filled by server. Possible
     values include: "UrlSigningKey", "CustomerCertificate", "ManagedCertificate",
     "AzureFirstPartyManagedCertificate".
    :vartype type: str or ~azure.mgmt.cdn.models.SecretType
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
    }

    _subtype_map = {
        'type': {'AzureFirstPartyManagedCertificate': 'AzureFirstPartyManagedCertificateParameters', 'CustomerCertificate': 'CustomerCertificateParameters', 'ManagedCertificate': 'ManagedCertificateParameters', 'UrlSigningKey': 'UrlSigningKeyParameters'}
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(SecretParameters, self).__init__(**kwargs)
        self.type = None  # type: Optional[str]


class AzureFirstPartyManagedCertificateParameters(SecretParameters):
    """Azure FirstParty Managed Certificate provided by other first party resource providers to enable HTTPS.

    All required parameters must be populated in order to send to Azure.

    :ivar type: Required. The type of the secret resource.Constant filled by server. Possible
     values include: "UrlSigningKey", "CustomerCertificate", "ManagedCertificate",
     "AzureFirstPartyManagedCertificate".
    :vartype type: str or ~azure.mgmt.cdn.models.SecretType
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(AzureFirstPartyManagedCertificateParameters, self).__init__(**kwargs)
        self.type = 'AzureFirstPartyManagedCertificate'  # type: str


class CacheConfiguration(msrest.serialization.Model):
    """Caching settings for a caching-type route. To disable caching, do not provide a cacheConfiguration object.

    :ivar query_string_caching_behavior: Defines how Frontdoor caches requests that include query
     strings. You can ignore any query strings when caching, ignore specific query strings, cache
     every request with a unique URL, or cache specific query strings. Possible values include:
     "IgnoreQueryString", "UseQueryString", "IgnoreSpecifiedQueryStrings",
     "IncludeSpecifiedQueryStrings".
    :vartype query_string_caching_behavior: str or
     ~azure.mgmt.cdn.models.RuleQueryStringCachingBehavior
    :ivar query_parameters: query parameters to include or exclude (comma separated).
    :vartype query_parameters: str
    :ivar is_compression_enabled: Indicates whether content compression is enabled. If compression
     is enabled, content will be served as compressed if user requests for a compressed version.
     Content won't be compressed on AzureFrontDoor when requested content is smaller than 1 byte or
     larger than 1 MB. Possible values include: "Enabled", "Disabled".
    :vartype is_compression_enabled: str or ~azure.mgmt.cdn.models.RuleIsCompressionEnabled
    :ivar cache_behavior: Caching behavior for the requests. Possible values include:
     "HonorOrigin", "OverrideAlways", "OverrideIfOriginMissing".
    :vartype cache_behavior: str or ~azure.mgmt.cdn.models.RuleCacheBehavior
    :ivar cache_duration: The duration for which the content needs to be cached. Allowed format is
     [d.]hh:mm:ss.
    :vartype cache_duration: str
    """

    _attribute_map = {
        'query_string_caching_behavior': {'key': 'queryStringCachingBehavior', 'type': 'str'},
        'query_parameters': {'key': 'queryParameters', 'type': 'str'},
        'is_compression_enabled': {'key': 'isCompressionEnabled', 'type': 'str'},
        'cache_behavior': {'key': 'cacheBehavior', 'type': 'str'},
        'cache_duration': {'key': 'cacheDuration', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        query_string_caching_behavior: Optional[Union[str, "RuleQueryStringCachingBehavior"]] = None,
        query_parameters: Optional[str] = None,
        is_compression_enabled: Optional[Union[str, "RuleIsCompressionEnabled"]] = None,
        cache_behavior: Optional[Union[str, "RuleCacheBehavior"]] = None,
        cache_duration: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword query_string_caching_behavior: Defines how Frontdoor caches requests that include
         query strings. You can ignore any query strings when caching, ignore specific query strings,
         cache every request with a unique URL, or cache specific query strings. Possible values
         include: "IgnoreQueryString", "UseQueryString", "IgnoreSpecifiedQueryStrings",
         "IncludeSpecifiedQueryStrings".
        :paramtype query_string_caching_behavior: str or
         ~azure.mgmt.cdn.models.RuleQueryStringCachingBehavior
        :keyword query_parameters: query parameters to include or exclude (comma separated).
        :paramtype query_parameters: str
        :keyword is_compression_enabled: Indicates whether content compression is enabled. If
         compression is enabled, content will be served as compressed if user requests for a compressed
         version. Content won't be compressed on AzureFrontDoor when requested content is smaller than 1
         byte or larger than 1 MB. Possible values include: "Enabled", "Disabled".
        :paramtype is_compression_enabled: str or ~azure.mgmt.cdn.models.RuleIsCompressionEnabled
        :keyword cache_behavior: Caching behavior for the requests. Possible values include:
         "HonorOrigin", "OverrideAlways", "OverrideIfOriginMissing".
        :paramtype cache_behavior: str or ~azure.mgmt.cdn.models.RuleCacheBehavior
        :keyword cache_duration: The duration for which the content needs to be cached. Allowed format
         is [d.]hh:mm:ss.
        :paramtype cache_duration: str
        """
        super(CacheConfiguration, self).__init__(**kwargs)
        self.query_string_caching_behavior = query_string_caching_behavior
        self.query_parameters = query_parameters
        self.is_compression_enabled = is_compression_enabled
        self.cache_behavior = cache_behavior
        self.cache_duration = cache_duration


class CacheExpirationActionParameters(msrest.serialization.Model):
    """Defines the parameters for the cache expiration action.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar type_name:  Has constant value: "DeliveryRuleCacheExpirationActionParameters".
    :vartype type_name: str
    :ivar cache_behavior: Required. Caching behavior for the requests. Possible values include:
     "BypassCache", "Override", "SetIfMissing".
    :vartype cache_behavior: str or ~azure.mgmt.cdn.models.CacheBehavior
    :ivar cache_type: Required. The level at which the content needs to be cached. Possible values
     include: "All".
    :vartype cache_type: str or ~azure.mgmt.cdn.models.CacheType
    :ivar cache_duration: The duration for which the content needs to be cached. Allowed format is
     [d.]hh:mm:ss.
    :vartype cache_duration: str
    """

    _validation = {
        'type_name': {'required': True, 'constant': True},
        'cache_behavior': {'required': True},
        'cache_type': {'required': True},
    }

    _attribute_map = {
        'type_name': {'key': 'typeName', 'type': 'str'},
        'cache_behavior': {'key': 'cacheBehavior', 'type': 'str'},
        'cache_type': {'key': 'cacheType', 'type': 'str'},
        'cache_duration': {'key': 'cacheDuration', 'type': 'str'},
    }

    type_name = "DeliveryRuleCacheExpirationActionParameters"

    def __init__(
        self,
        *,
        cache_behavior: Union[str, "CacheBehavior"],
        cache_type: Union[str, "CacheType"],
        cache_duration: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword cache_behavior: Required. Caching behavior for the requests. Possible values include:
         "BypassCache", "Override", "SetIfMissing".
        :paramtype cache_behavior: str or ~azure.mgmt.cdn.models.CacheBehavior
        :keyword cache_type: Required. The level at which the content needs to be cached. Possible
         values include: "All".
        :paramtype cache_type: str or ~azure.mgmt.cdn.models.CacheType
        :keyword cache_duration: The duration for which the content needs to be cached. Allowed format
         is [d.]hh:mm:ss.
        :paramtype cache_duration: str
        """
        super(CacheExpirationActionParameters, self).__init__(**kwargs)
        self.cache_behavior = cache_behavior
        self.cache_type = cache_type
        self.cache_duration = cache_duration


class CacheKeyQueryStringActionParameters(msrest.serialization.Model):
    """Defines the parameters for the cache-key query string action.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar type_name:  Has constant value:
     "DeliveryRuleCacheKeyQueryStringBehaviorActionParameters".
    :vartype type_name: str
    :ivar query_string_behavior: Required. Caching behavior for the requests. Possible values
     include: "Include", "IncludeAll", "Exclude", "ExcludeAll".
    :vartype query_string_behavior: str or ~azure.mgmt.cdn.models.QueryStringBehavior
    :ivar query_parameters: query parameters to include or exclude (comma separated).
    :vartype query_parameters: str
    """

    _validation = {
        'type_name': {'required': True, 'constant': True},
        'query_string_behavior': {'required': True},
    }

    _attribute_map = {
        'type_name': {'key': 'typeName', 'type': 'str'},
        'query_string_behavior': {'key': 'queryStringBehavior', 'type': 'str'},
        'query_parameters': {'key': 'queryParameters', 'type': 'str'},
    }

    type_name = "DeliveryRuleCacheKeyQueryStringBehaviorActionParameters"

    def __init__(
        self,
        *,
        query_string_behavior: Union[str, "QueryStringBehavior"],
        query_parameters: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword query_string_behavior: Required. Caching behavior for the requests. Possible values
         include: "Include", "IncludeAll", "Exclude", "ExcludeAll".
        :paramtype query_string_behavior: str or ~azure.mgmt.cdn.models.QueryStringBehavior
        :keyword query_parameters: query parameters to include or exclude (comma separated).
        :paramtype query_parameters: str
        """
        super(CacheKeyQueryStringActionParameters, self).__init__(**kwargs)
        self.query_string_behavior = query_string_behavior
        self.query_parameters = query_parameters


class CdnCertificateSourceParameters(msrest.serialization.Model):
    """Defines the parameters for using CDN managed certificate for securing custom domain.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar type_name:  Has constant value: "CdnCertificateSourceParameters".
    :vartype type_name: str
    :ivar certificate_type: Required. Type of certificate used. Possible values include: "Shared",
     "Dedicated".
    :vartype certificate_type: str or ~azure.mgmt.cdn.models.CertificateType
    """

    _validation = {
        'type_name': {'required': True, 'constant': True},
        'certificate_type': {'required': True},
    }

    _attribute_map = {
        'type_name': {'key': 'typeName', 'type': 'str'},
        'certificate_type': {'key': 'certificateType', 'type': 'str'},
    }

    type_name = "CdnCertificateSourceParameters"

    def __init__(
        self,
        *,
        certificate_type: Union[str, "CertificateType"],
        **kwargs
    ):
        """
        :keyword certificate_type: Required. Type of certificate used. Possible values include:
         "Shared", "Dedicated".
        :paramtype certificate_type: str or ~azure.mgmt.cdn.models.CertificateType
        """
        super(CdnCertificateSourceParameters, self).__init__(**kwargs)
        self.certificate_type = certificate_type


class CdnEndpoint(msrest.serialization.Model):
    """Defines the ARM Resource ID for the linked endpoints.

    :ivar id: ARM Resource ID string.
    :vartype id: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword id: ARM Resource ID string.
        :paramtype id: str
        """
        super(CdnEndpoint, self).__init__(**kwargs)
        self.id = id


class CustomDomainHttpsParameters(msrest.serialization.Model):
    """The JSON object that contains the properties to secure a custom domain.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: UserManagedHttpsParameters, CdnManagedHttpsParameters.

    All required parameters must be populated in order to send to Azure.

    :ivar certificate_source: Required. Defines the source of the SSL certificate.Constant filled
     by server. Possible values include: "AzureKeyVault", "Cdn".
    :vartype certificate_source: str or ~azure.mgmt.cdn.models.CertificateSource
    :ivar protocol_type: Required. Defines the TLS extension protocol that is used for secure
     delivery. Possible values include: "ServerNameIndication", "IPBased".
    :vartype protocol_type: str or ~azure.mgmt.cdn.models.ProtocolType
    :ivar minimum_tls_version: TLS protocol version that will be used for Https. Possible values
     include: "None", "TLS10", "TLS12".
    :vartype minimum_tls_version: str or ~azure.mgmt.cdn.models.MinimumTlsVersion
    """

    _validation = {
        'certificate_source': {'required': True},
        'protocol_type': {'required': True},
    }

    _attribute_map = {
        'certificate_source': {'key': 'certificateSource', 'type': 'str'},
        'protocol_type': {'key': 'protocolType', 'type': 'str'},
        'minimum_tls_version': {'key': 'minimumTlsVersion', 'type': 'str'},
    }

    _subtype_map = {
        'certificate_source': {'AzureKeyVault': 'UserManagedHttpsParameters', 'Cdn': 'CdnManagedHttpsParameters'}
    }

    def __init__(
        self,
        *,
        protocol_type: Union[str, "ProtocolType"],
        minimum_tls_version: Optional[Union[str, "MinimumTlsVersion"]] = None,
        **kwargs
    ):
        """
        :keyword protocol_type: Required. Defines the TLS extension protocol that is used for secure
         delivery. Possible values include: "ServerNameIndication", "IPBased".
        :paramtype protocol_type: str or ~azure.mgmt.cdn.models.ProtocolType
        :keyword minimum_tls_version: TLS protocol version that will be used for Https. Possible values
         include: "None", "TLS10", "TLS12".
        :paramtype minimum_tls_version: str or ~azure.mgmt.cdn.models.MinimumTlsVersion
        """
        super(CustomDomainHttpsParameters, self).__init__(**kwargs)
        self.certificate_source = None  # type: Optional[str]
        self.protocol_type = protocol_type
        self.minimum_tls_version = minimum_tls_version


class CdnManagedHttpsParameters(CustomDomainHttpsParameters):
    """Defines the certificate source parameters using CDN managed certificate for enabling SSL.

    All required parameters must be populated in order to send to Azure.

    :ivar certificate_source: Required. Defines the source of the SSL certificate.Constant filled
     by server. Possible values include: "AzureKeyVault", "Cdn".
    :vartype certificate_source: str or ~azure.mgmt.cdn.models.CertificateSource
    :ivar protocol_type: Required. Defines the TLS extension protocol that is used for secure
     delivery. Possible values include: "ServerNameIndication", "IPBased".
    :vartype protocol_type: str or ~azure.mgmt.cdn.models.ProtocolType
    :ivar minimum_tls_version: TLS protocol version that will be used for Https. Possible values
     include: "None", "TLS10", "TLS12".
    :vartype minimum_tls_version: str or ~azure.mgmt.cdn.models.MinimumTlsVersion
    :ivar certificate_source_parameters: Required. Defines the certificate source parameters using
     CDN managed certificate for enabling SSL.
    :vartype certificate_source_parameters: ~azure.mgmt.cdn.models.CdnCertificateSourceParameters
    """

    _validation = {
        'certificate_source': {'required': True},
        'protocol_type': {'required': True},
        'certificate_source_parameters': {'required': True},
    }

    _attribute_map = {
        'certificate_source': {'key': 'certificateSource', 'type': 'str'},
        'protocol_type': {'key': 'protocolType', 'type': 'str'},
        'minimum_tls_version': {'key': 'minimumTlsVersion', 'type': 'str'},
        'certificate_source_parameters': {'key': 'certificateSourceParameters', 'type': 'CdnCertificateSourceParameters'},
    }

    def __init__(
        self,
        *,
        protocol_type: Union[str, "ProtocolType"],
        certificate_source_parameters: "CdnCertificateSourceParameters",
        minimum_tls_version: Optional[Union[str, "MinimumTlsVersion"]] = None,
        **kwargs
    ):
        """
        :keyword protocol_type: Required. Defines the TLS extension protocol that is used for secure
         delivery. Possible values include: "ServerNameIndication", "IPBased".
        :paramtype protocol_type: str or ~azure.mgmt.cdn.models.ProtocolType
        :keyword minimum_tls_version: TLS protocol version that will be used for Https. Possible values
         include: "None", "TLS10", "TLS12".
        :paramtype minimum_tls_version: str or ~azure.mgmt.cdn.models.MinimumTlsVersion
        :keyword certificate_source_parameters: Required. Defines the certificate source parameters
         using CDN managed certificate for enabling SSL.
        :paramtype certificate_source_parameters: ~azure.mgmt.cdn.models.CdnCertificateSourceParameters
        """
        super(CdnManagedHttpsParameters, self).__init__(protocol_type=protocol_type, minimum_tls_version=minimum_tls_version, **kwargs)
        self.certificate_source = 'Cdn'  # type: str
        self.certificate_source_parameters = certificate_source_parameters


class CdnWebApplicationFirewallPolicy(TrackedResource):
    """Defines web application firewall policy for Azure CDN.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar system_data: Read only system data.
    :vartype system_data: ~azure.mgmt.cdn.models.SystemData
    :ivar location: Required. Resource location.
    :vartype location: str
    :ivar tags: A set of tags. Resource tags.
    :vartype tags: dict[str, str]
    :ivar etag: Gets a unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar sku: Required. The pricing tier (defines a CDN provider, feature list and rate) of the
     CdnWebApplicationFirewallPolicy.
    :vartype sku: ~azure.mgmt.cdn.models.Sku
    :ivar policy_settings: Describes  policySettings for policy.
    :vartype policy_settings: ~azure.mgmt.cdn.models.PolicySettings
    :ivar rate_limit_rules: Describes rate limit rules inside the policy.
    :vartype rate_limit_rules: ~azure.mgmt.cdn.models.RateLimitRuleList
    :ivar custom_rules: Describes custom rules inside the policy.
    :vartype custom_rules: ~azure.mgmt.cdn.models.CustomRuleList
    :ivar managed_rules: Describes managed rules inside the policy.
    :vartype managed_rules: ~azure.mgmt.cdn.models.ManagedRuleSetList
    :ivar endpoint_links: Describes Azure CDN endpoints associated with this Web Application
     Firewall policy.
    :vartype endpoint_links: list[~azure.mgmt.cdn.models.CdnEndpoint]
    :ivar provisioning_state: Provisioning state of the WebApplicationFirewallPolicy. Possible
     values include: "Creating", "Succeeded", "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.cdn.models.ProvisioningState
    :ivar resource_state: Resource status of the policy. Possible values include: "Creating",
     "Enabling", "Enabled", "Disabling", "Disabled", "Deleting".
    :vartype resource_state: str or ~azure.mgmt.cdn.models.PolicyResourceState
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'location': {'required': True},
        'sku': {'required': True},
        'endpoint_links': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'resource_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'etag': {'key': 'etag', 'type': 'str'},
        'sku': {'key': 'sku', 'type': 'Sku'},
        'policy_settings': {'key': 'properties.policySettings', 'type': 'PolicySettings'},
        'rate_limit_rules': {'key': 'properties.rateLimitRules', 'type': 'RateLimitRuleList'},
        'custom_rules': {'key': 'properties.customRules', 'type': 'CustomRuleList'},
        'managed_rules': {'key': 'properties.managedRules', 'type': 'ManagedRuleSetList'},
        'endpoint_links': {'key': 'properties.endpointLinks', 'type': '[CdnEndpoint]'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'resource_state': {'key': 'properties.resourceState', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        location: str,
        sku: "Sku",
        tags: Optional[Dict[str, str]] = None,
        etag: Optional[str] = None,
        policy_settings: Optional["PolicySettings"] = None,
        rate_limit_rules: Optional["RateLimitRuleList"] = None,
        custom_rules: Optional["CustomRuleList"] = None,
        managed_rules: Optional["ManagedRuleSetList"] = None,
        **kwargs
    ):
        """
        :keyword location: Required. Resource location.
        :paramtype location: str
        :keyword tags: A set of tags. Resource tags.
        :paramtype tags: dict[str, str]
        :keyword etag: Gets a unique read-only string that changes whenever the resource is updated.
        :paramtype etag: str
        :keyword sku: Required. The pricing tier (defines a CDN provider, feature list and rate) of the
         CdnWebApplicationFirewallPolicy.
        :paramtype sku: ~azure.mgmt.cdn.models.Sku
        :keyword policy_settings: Describes  policySettings for policy.
        :paramtype policy_settings: ~azure.mgmt.cdn.models.PolicySettings
        :keyword rate_limit_rules: Describes rate limit rules inside the policy.
        :paramtype rate_limit_rules: ~azure.mgmt.cdn.models.RateLimitRuleList
        :keyword custom_rules: Describes custom rules inside the policy.
        :paramtype custom_rules: ~azure.mgmt.cdn.models.CustomRuleList
        :keyword managed_rules: Describes managed rules inside the policy.
        :paramtype managed_rules: ~azure.mgmt.cdn.models.ManagedRuleSetList
        """
        super(CdnWebApplicationFirewallPolicy, self).__init__(location=location, tags=tags, **kwargs)
        self.etag = etag
        self.sku = sku
        self.policy_settings = policy_settings
        self.rate_limit_rules = rate_limit_rules
        self.custom_rules = custom_rules
        self.managed_rules = managed_rules
        self.endpoint_links = None
        self.provisioning_state = None
        self.resource_state = None


class CdnWebApplicationFirewallPolicyList(msrest.serialization.Model):
    """Defines a list of WebApplicationFirewallPolicies for Azure CDN. It contains a list of WebApplicationFirewallPolicy objects and a URL link to get the next set of results.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of Azure CDN WebApplicationFirewallPolicies within a resource group.
    :vartype value: list[~azure.mgmt.cdn.models.CdnWebApplicationFirewallPolicy]
    :ivar next_link: URL to get the next set of WebApplicationFirewallPolicy objects if there are
     any.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[CdnWebApplicationFirewallPolicy]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        next_link: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword next_link: URL to get the next set of WebApplicationFirewallPolicy objects if there
         are any.
        :paramtype next_link: str
        """
        super(CdnWebApplicationFirewallPolicyList, self).__init__(**kwargs)
        self.value = None
        self.next_link = next_link


class CdnWebApplicationFirewallPolicyPatchParameters(msrest.serialization.Model):
    """Properties required to update a CdnWebApplicationFirewallPolicy.

    :ivar tags: A set of tags. CdnWebApplicationFirewallPolicy tags.
    :vartype tags: dict[str, str]
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        """
        :keyword tags: A set of tags. CdnWebApplicationFirewallPolicy tags.
        :paramtype tags: dict[str, str]
        """
        super(CdnWebApplicationFirewallPolicyPatchParameters, self).__init__(**kwargs)
        self.tags = tags


class CheckEndpointNameAvailabilityInput(msrest.serialization.Model):
    """Input of CheckNameAvailability API.

    All required parameters must be populated in order to send to Azure.

    :ivar name: Required. The resource name to validate.
    :vartype name: str
    :ivar type: Required. The type of the resource whose name is to be validated. Possible values
     include: "Microsoft.Cdn/Profiles/Endpoints", "Microsoft.Cdn/Profiles/AfdEndpoints".
    :vartype type: str or ~azure.mgmt.cdn.models.ResourceType
    :ivar auto_generated_domain_name_label_scope: Indicates the endpoint name reuse scope. The
     default value is TenantReuse. Possible values include: "TenantReuse", "SubscriptionReuse",
     "ResourceGroupReuse", "NoReuse".
    :vartype auto_generated_domain_name_label_scope: str or
     ~azure.mgmt.cdn.models.AutoGeneratedDomainNameLabelScope
    """

    _validation = {
        'name': {'required': True},
        'type': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'auto_generated_domain_name_label_scope': {'key': 'autoGeneratedDomainNameLabelScope', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: str,
        type: Union[str, "ResourceType"],
        auto_generated_domain_name_label_scope: Optional[Union[str, "AutoGeneratedDomainNameLabelScope"]] = None,
        **kwargs
    ):
        """
        :keyword name: Required. The resource name to validate.
        :paramtype name: str
        :keyword type: Required. The type of the resource whose name is to be validated. Possible
         values include: "Microsoft.Cdn/Profiles/Endpoints", "Microsoft.Cdn/Profiles/AfdEndpoints".
        :paramtype type: str or ~azure.mgmt.cdn.models.ResourceType
        :keyword auto_generated_domain_name_label_scope: Indicates the endpoint name reuse scope. The
         default value is TenantReuse. Possible values include: "TenantReuse", "SubscriptionReuse",
         "ResourceGroupReuse", "NoReuse".
        :paramtype auto_generated_domain_name_label_scope: str or
         ~azure.mgmt.cdn.models.AutoGeneratedDomainNameLabelScope
        """
        super(CheckEndpointNameAvailabilityInput, self).__init__(**kwargs)
        self.name = name
        self.type = type
        self.auto_generated_domain_name_label_scope = auto_generated_domain_name_label_scope


class CheckEndpointNameAvailabilityOutput(msrest.serialization.Model):
    """Output of check name availability API.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name_available: Indicates whether the name is available.
    :vartype name_available: bool
    :ivar available_hostname: Returns the available hostname generated based on the
     AutoGeneratedDomainNameLabelScope when the name is available, otherwise it returns empty
     string.
    :vartype available_hostname: str
    :ivar reason: The reason why the name is not available.
    :vartype reason: str
    :ivar message: The detailed error message describing why the name is not available.
    :vartype message: str
    """

    _validation = {
        'name_available': {'readonly': True},
        'available_hostname': {'readonly': True},
        'reason': {'readonly': True},
        'message': {'readonly': True},
    }

    _attribute_map = {
        'name_available': {'key': 'nameAvailable', 'type': 'bool'},
        'available_hostname': {'key': 'availableHostname', 'type': 'str'},
        'reason': {'key': 'reason', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(CheckEndpointNameAvailabilityOutput, self).__init__(**kwargs)
        self.name_available = None
        self.available_hostname = None
        self.reason = None
        self.message = None


class CheckHostNameAvailabilityInput(msrest.serialization.Model):
    """Input of CheckHostNameAvailability API.

    All required parameters must be populated in order to send to Azure.

    :ivar host_name: Required. The host name to validate.
    :vartype host_name: str
    """

    _validation = {
        'host_name': {'required': True},
    }

    _attribute_map = {
        'host_name': {'key': 'hostName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        host_name: str,
        **kwargs
    ):
        """
        :keyword host_name: Required. The host name to validate.
        :paramtype host_name: str
        """
        super(CheckHostNameAvailabilityInput, self).__init__(**kwargs)
        self.host_name = host_name


class CheckNameAvailabilityInput(msrest.serialization.Model):
    """Input of CheckNameAvailability API.

    All required parameters must be populated in order to send to Azure.

    :ivar name: Required. The resource name to validate.
    :vartype name: str
    :ivar type: Required. The type of the resource whose name is to be validated. Possible values
     include: "Microsoft.Cdn/Profiles/Endpoints", "Microsoft.Cdn/Profiles/AfdEndpoints".
    :vartype type: str or ~azure.mgmt.cdn.models.ResourceType
    """

    _validation = {
        'name': {'required': True},
        'type': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: str,
        type: Union[str, "ResourceType"],
        **kwargs
    ):
        """
        :keyword name: Required. The resource name to validate.
        :paramtype name: str
        :keyword type: Required. The type of the resource whose name is to be validated. Possible
         values include: "Microsoft.Cdn/Profiles/Endpoints", "Microsoft.Cdn/Profiles/AfdEndpoints".
        :paramtype type: str or ~azure.mgmt.cdn.models.ResourceType
        """
        super(CheckNameAvailabilityInput, self).__init__(**kwargs)
        self.name = name
        self.type = type


class CheckNameAvailabilityOutput(msrest.serialization.Model):
    """Output of check name availability API.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name_available: Indicates whether the name is available.
    :vartype name_available: bool
    :ivar reason: The reason why the name is not available.
    :vartype reason: str
    :ivar message: The detailed error message describing why the name is not available.
    :vartype message: str
    """

    _validation = {
        'name_available': {'readonly': True},
        'reason': {'readonly': True},
        'message': {'readonly': True},
    }

    _attribute_map = {
        'name_available': {'key': 'nameAvailable', 'type': 'bool'},
        'reason': {'key': 'reason', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(CheckNameAvailabilityOutput, self).__init__(**kwargs)
        self.name_available = None
        self.reason = None
        self.message = None


class CidrIpAddress(msrest.serialization.Model):
    """CIDR Ip address.

    :ivar base_ip_address: Ip address itself.
    :vartype base_ip_address: str
    :ivar prefix_length: The length of the prefix of the ip address.
    :vartype prefix_length: int
    """

    _attribute_map = {
        'base_ip_address': {'key': 'baseIpAddress', 'type': 'str'},
        'prefix_length': {'key': 'prefixLength', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        base_ip_address: Optional[str] = None,
        prefix_length: Optional[int] = None,
        **kwargs
    ):
        """
        :keyword base_ip_address: Ip address itself.
        :paramtype base_ip_address: str
        :keyword prefix_length: The length of the prefix of the ip address.
        :paramtype prefix_length: int
        """
        super(CidrIpAddress, self).__init__(**kwargs)
        self.base_ip_address = base_ip_address
        self.prefix_length = prefix_length


class ClientPortMatchConditionParameters(msrest.serialization.Model):
    """Defines the parameters for ClientPort match conditions.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar type_name:  Has constant value: "DeliveryRuleClientPortConditionParameters".
    :vartype type_name: str
    :ivar operator: Required. Describes operator to be matched. Possible values include: "Any",
     "Equal", "Contains", "BeginsWith", "EndsWith", "LessThan", "LessThanOrEqual", "GreaterThan",
     "GreaterThanOrEqual", "RegEx".
    :vartype operator: str or ~azure.mgmt.cdn.models.ClientPortOperator
    :ivar negate_condition: Describes if this is negate condition or not.
    :vartype negate_condition: bool
    :ivar match_values: The match value for the condition of the delivery rule.
    :vartype match_values: list[str]
    :ivar transforms: List of transforms.
    :vartype transforms: list[str or ~azure.mgmt.cdn.models.Transform]
    """

    _validation = {
        'type_name': {'required': True, 'constant': True},
        'operator': {'required': True},
    }

    _attribute_map = {
        'type_name': {'key': 'typeName', 'type': 'str'},
        'operator': {'key': 'operator', 'type': 'str'},
        'negate_condition': {'key': 'negateCondition', 'type': 'bool'},
        'match_values': {'key': 'matchValues', 'type': '[str]'},
        'transforms': {'key': 'transforms', 'type': '[str]'},
    }

    type_name = "DeliveryRuleClientPortConditionParameters"

    def __init__(
        self,
        *,
        operator: Union[str, "ClientPortOperator"],
        negate_condition: Optional[bool] = None,
        match_values: Optional[List[str]] = None,
        transforms: Optional[List[Union[str, "Transform"]]] = None,
        **kwargs
    ):
        """
        :keyword operator: Required. Describes operator to be matched. Possible values include: "Any",
         "Equal", "Contains", "BeginsWith", "EndsWith", "LessThan", "LessThanOrEqual", "GreaterThan",
         "GreaterThanOrEqual", "RegEx".
        :paramtype operator: str or ~azure.mgmt.cdn.models.ClientPortOperator
        :keyword negate_condition: Describes if this is negate condition or not.
        :paramtype negate_condition: bool
        :keyword match_values: The match value for the condition of the delivery rule.
        :paramtype match_values: list[str]
        :keyword transforms: List of transforms.
        :paramtype transforms: list[str or ~azure.mgmt.cdn.models.Transform]
        """
        super(ClientPortMatchConditionParameters, self).__init__(**kwargs)
        self.operator = operator
        self.negate_condition = negate_condition
        self.match_values = match_values
        self.transforms = transforms


class Components18OrqelSchemasWafmetricsresponsePropertiesSeriesItemsPropertiesDataItems(msrest.serialization.Model):
    """Components18OrqelSchemasWafmetricsresponsePropertiesSeriesItemsPropertiesDataItems.

    :ivar date_time:
    :vartype date_time: ~datetime.datetime
    :ivar value:
    :vartype value: float
    """

    _attribute_map = {
        'date_time': {'key': 'dateTime', 'type': 'iso-8601'},
        'value': {'key': 'value', 'type': 'float'},
    }

    def __init__(
        self,
        *,
        date_time: Optional[datetime.datetime] = None,
        value: Optional[float] = None,
        **kwargs
    ):
        """
        :keyword date_time:
        :paramtype date_time: ~datetime.datetime
        :keyword value:
        :paramtype value: float
        """
        super(Components18OrqelSchemasWafmetricsresponsePropertiesSeriesItemsPropertiesDataItems, self).__init__(**kwargs)
        self.date_time = date_time
        self.value = value


class Components1Gs0LlpSchemasMetricsresponsePropertiesSeriesItemsPropertiesDataItems(msrest.serialization.Model):
    """Components1Gs0LlpSchemasMetricsresponsePropertiesSeriesItemsPropertiesDataItems.

    :ivar date_time:
    :vartype date_time: ~datetime.datetime
    :ivar value:
    :vartype value: float
    """

    _attribute_map = {
        'date_time': {'key': 'dateTime', 'type': 'iso-8601'},
        'value': {'key': 'value', 'type': 'float'},
    }

    def __init__(
        self,
        *,
        date_time: Optional[datetime.datetime] = None,
        value: Optional[float] = None,
        **kwargs
    ):
        """
        :keyword date_time:
        :paramtype date_time: ~datetime.datetime
        :keyword value:
        :paramtype value: float
        """
        super(Components1Gs0LlpSchemasMetricsresponsePropertiesSeriesItemsPropertiesDataItems, self).__init__(**kwargs)
        self.date_time = date_time
        self.value = value


class ComponentsKpo1PjSchemasWafrankingsresponsePropertiesDataItemsPropertiesMetricsItems(msrest.serialization.Model):
    """ComponentsKpo1PjSchemasWafrankingsresponsePropertiesDataItemsPropertiesMetricsItems.

    :ivar metric:
    :vartype metric: str
    :ivar value:
    :vartype value: long
    :ivar percentage:
    :vartype percentage: float
    """

    _attribute_map = {
        'metric': {'key': 'metric', 'type': 'str'},
        'value': {'key': 'value', 'type': 'long'},
        'percentage': {'key': 'percentage', 'type': 'float'},
    }

    def __init__(
        self,
        *,
        metric: Optional[str] = None,
        value: Optional[int] = None,
        percentage: Optional[float] = None,
        **kwargs
    ):
        """
        :keyword metric:
        :paramtype metric: str
        :keyword value:
        :paramtype value: long
        :keyword percentage:
        :paramtype percentage: float
        """
        super(ComponentsKpo1PjSchemasWafrankingsresponsePropertiesDataItemsPropertiesMetricsItems, self).__init__(**kwargs)
        self.metric = metric
        self.value = value
        self.percentage = percentage


class CompressionSettings(msrest.serialization.Model):
    """settings for compression.

    :ivar content_types_to_compress: List of content types on which compression applies. The value
     should be a valid MIME type.
    :vartype content_types_to_compress: list[str]
    :ivar is_compression_enabled: Indicates whether content compression is enabled on
     AzureFrontDoor. Default value is false. If compression is enabled, content will be served as
     compressed if user requests for a compressed version. Content won't be compressed on
     AzureFrontDoor when requested content is smaller than 1 byte or larger than 1 MB.
    :vartype is_compression_enabled: bool
    """

    _attribute_map = {
        'content_types_to_compress': {'key': 'contentTypesToCompress', 'type': '[str]'},
        'is_compression_enabled': {'key': 'isCompressionEnabled', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        content_types_to_compress: Optional[List[str]] = None,
        is_compression_enabled: Optional[bool] = None,
        **kwargs
    ):
        """
        :keyword content_types_to_compress: List of content types on which compression applies. The
         value should be a valid MIME type.
        :paramtype content_types_to_compress: list[str]
        :keyword is_compression_enabled: Indicates whether content compression is enabled on
         AzureFrontDoor. Default value is false. If compression is enabled, content will be served as
         compressed if user requests for a compressed version. Content won't be compressed on
         AzureFrontDoor when requested content is smaller than 1 byte or larger than 1 MB.
        :paramtype is_compression_enabled: bool
        """
        super(CompressionSettings, self).__init__(**kwargs)
        self.content_types_to_compress = content_types_to_compress
        self.is_compression_enabled = is_compression_enabled


class ContinentsResponse(msrest.serialization.Model):
    """Continents Response.

    :ivar continents:
    :vartype continents: list[~azure.mgmt.cdn.models.ContinentsResponseContinentsItem]
    :ivar country_or_regions:
    :vartype country_or_regions:
     list[~azure.mgmt.cdn.models.ContinentsResponseCountryOrRegionsItem]
    """

    _attribute_map = {
        'continents': {'key': 'continents', 'type': '[ContinentsResponseContinentsItem]'},
        'country_or_regions': {'key': 'countryOrRegions', 'type': '[ContinentsResponseCountryOrRegionsItem]'},
    }

    def __init__(
        self,
        *,
        continents: Optional[List["ContinentsResponseContinentsItem"]] = None,
        country_or_regions: Optional[List["ContinentsResponseCountryOrRegionsItem"]] = None,
        **kwargs
    ):
        """
        :keyword continents:
        :paramtype continents: list[~azure.mgmt.cdn.models.ContinentsResponseContinentsItem]
        :keyword country_or_regions:
        :paramtype country_or_regions:
         list[~azure.mgmt.cdn.models.ContinentsResponseCountryOrRegionsItem]
        """
        super(ContinentsResponse, self).__init__(**kwargs)
        self.continents = continents
        self.country_or_regions = country_or_regions


class ContinentsResponseContinentsItem(msrest.serialization.Model):
    """ContinentsResponseContinentsItem.

    :ivar id:
    :vartype id: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword id:
        :paramtype id: str
        """
        super(ContinentsResponseContinentsItem, self).__init__(**kwargs)
        self.id = id


class ContinentsResponseCountryOrRegionsItem(msrest.serialization.Model):
    """ContinentsResponseCountryOrRegionsItem.

    :ivar id:
    :vartype id: str
    :ivar continent_id:
    :vartype continent_id: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'continent_id': {'key': 'continentId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        continent_id: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword id:
        :paramtype id: str
        :keyword continent_id:
        :paramtype continent_id: str
        """
        super(ContinentsResponseCountryOrRegionsItem, self).__init__(**kwargs)
        self.id = id
        self.continent_id = continent_id


class CookiesMatchConditionParameters(msrest.serialization.Model):
    """Defines the parameters for Cookies match conditions.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar type_name:  Has constant value: "DeliveryRuleCookiesConditionParameters".
    :vartype type_name: str
    :ivar selector: Name of Cookies to be matched.
    :vartype selector: str
    :ivar operator: Required. Describes operator to be matched. Possible values include: "Any",
     "Equal", "Contains", "BeginsWith", "EndsWith", "LessThan", "LessThanOrEqual", "GreaterThan",
     "GreaterThanOrEqual", "RegEx".
    :vartype operator: str or ~azure.mgmt.cdn.models.CookiesOperator
    :ivar negate_condition: Describes if this is negate condition or not.
    :vartype negate_condition: bool
    :ivar match_values: The match value for the condition of the delivery rule.
    :vartype match_values: list[str]
    :ivar transforms: List of transforms.
    :vartype transforms: list[str or ~azure.mgmt.cdn.models.Transform]
    """

    _validation = {
        'type_name': {'required': True, 'constant': True},
        'operator': {'required': True},
    }

    _attribute_map = {
        'type_name': {'key': 'typeName', 'type': 'str'},
        'selector': {'key': 'selector', 'type': 'str'},
        'operator': {'key': 'operator', 'type': 'str'},
        'negate_condition': {'key': 'negateCondition', 'type': 'bool'},
        'match_values': {'key': 'matchValues', 'type': '[str]'},
        'transforms': {'key': 'transforms', 'type': '[str]'},
    }

    type_name = "DeliveryRuleCookiesConditionParameters"

    def __init__(
        self,
        *,
        operator: Union[str, "CookiesOperator"],
        selector: Optional[str] = None,
        negate_condition: Optional[bool] = None,
        match_values: Optional[List[str]] = None,
        transforms: Optional[List[Union[str, "Transform"]]] = None,
        **kwargs
    ):
        """
        :keyword selector: Name of Cookies to be matched.
        :paramtype selector: str
        :keyword operator: Required. Describes operator to be matched. Possible values include: "Any",
         "Equal", "Contains", "BeginsWith", "EndsWith", "LessThan", "LessThanOrEqual", "GreaterThan",
         "GreaterThanOrEqual", "RegEx".
        :paramtype operator: str or ~azure.mgmt.cdn.models.CookiesOperator
        :keyword negate_condition: Describes if this is negate condition or not.
        :paramtype negate_condition: bool
        :keyword match_values: The match value for the condition of the delivery rule.
        :paramtype match_values: list[str]
        :keyword transforms: List of transforms.
        :paramtype transforms: list[str or ~azure.mgmt.cdn.models.Transform]
        """
        super(CookiesMatchConditionParameters, self).__init__(**kwargs)
        self.selector = selector
        self.operator = operator
        self.negate_condition = negate_condition
        self.match_values = match_values
        self.transforms = transforms


class CustomDomain(ProxyResource):
    """Friendly domain name mapping to the endpoint hostname that the customer provides for branding purposes, e.g. www.contoso.com.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar system_data: Read only system data.
    :vartype system_data: ~azure.mgmt.cdn.models.SystemData
    :ivar host_name: The host name of the custom domain. Must be a domain name.
    :vartype host_name: str
    :ivar resource_state: Resource status of the custom domain. Possible values include:
     "Creating", "Active", "Deleting".
    :vartype resource_state: str or ~azure.mgmt.cdn.models.CustomDomainResourceState
    :ivar custom_https_provisioning_state: Provisioning status of Custom Https of the custom
     domain. Possible values include: "Enabling", "Enabled", "Disabling", "Disabled", "Failed".
    :vartype custom_https_provisioning_state: str or
     ~azure.mgmt.cdn.models.CustomHttpsProvisioningState
    :ivar custom_https_provisioning_substate: Provisioning substate shows the progress of custom
     HTTPS enabling/disabling process step by step. Possible values include:
     "SubmittingDomainControlValidationRequest", "PendingDomainControlValidationREquestApproval",
     "DomainControlValidationRequestApproved", "DomainControlValidationRequestRejected",
     "DomainControlValidationRequestTimedOut", "IssuingCertificate", "DeployingCertificate",
     "CertificateDeployed", "DeletingCertificate", "CertificateDeleted".
    :vartype custom_https_provisioning_substate: str or
     ~azure.mgmt.cdn.models.CustomHttpsProvisioningSubstate
    :ivar custom_https_parameters: Certificate parameters for securing custom HTTPS.
    :vartype custom_https_parameters: ~azure.mgmt.cdn.models.CustomDomainHttpsParameters
    :ivar validation_data: Special validation or data may be required when delivering CDN to some
     regions due to local compliance reasons. E.g. ICP license number of a custom domain is required
     to deliver content in China.
    :vartype validation_data: str
    :ivar provisioning_state: Provisioning status of the custom domain.
    :vartype provisioning_state: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'resource_state': {'readonly': True},
        'custom_https_provisioning_state': {'readonly': True},
        'custom_https_provisioning_substate': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'host_name': {'key': 'properties.hostName', 'type': 'str'},
        'resource_state': {'key': 'properties.resourceState', 'type': 'str'},
        'custom_https_provisioning_state': {'key': 'properties.customHttpsProvisioningState', 'type': 'str'},
        'custom_https_provisioning_substate': {'key': 'properties.customHttpsProvisioningSubstate', 'type': 'str'},
        'custom_https_parameters': {'key': 'properties.customHttpsParameters', 'type': 'CustomDomainHttpsParameters'},
        'validation_data': {'key': 'properties.validationData', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        host_name: Optional[str] = None,
        custom_https_parameters: Optional["CustomDomainHttpsParameters"] = None,
        validation_data: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword host_name: The host name of the custom domain. Must be a domain name.
        :paramtype host_name: str
        :keyword custom_https_parameters: Certificate parameters for securing custom HTTPS.
        :paramtype custom_https_parameters: ~azure.mgmt.cdn.models.CustomDomainHttpsParameters
        :keyword validation_data: Special validation or data may be required when delivering CDN to
         some regions due to local compliance reasons. E.g. ICP license number of a custom domain is
         required to deliver content in China.
        :paramtype validation_data: str
        """
        super(CustomDomain, self).__init__(**kwargs)
        self.host_name = host_name
        self.resource_state = None
        self.custom_https_provisioning_state = None
        self.custom_https_provisioning_substate = None
        self.custom_https_parameters = custom_https_parameters
        self.validation_data = validation_data
        self.provisioning_state = None


class CustomDomainListResult(msrest.serialization.Model):
    """Result of the request to list custom domains. It contains a list of custom domain objects and a URL link to get the next set of results.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of CDN CustomDomains within an endpoint.
    :vartype value: list[~azure.mgmt.cdn.models.CustomDomain]
    :ivar next_link: URL to get the next set of custom domain objects if there are any.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[CustomDomain]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        next_link: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword next_link: URL to get the next set of custom domain objects if there are any.
        :paramtype next_link: str
        """
        super(CustomDomainListResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = next_link


class CustomDomainParameters(msrest.serialization.Model):
    """The customDomain JSON object required for custom domain creation or update.

    :ivar host_name: The host name of the custom domain. Must be a domain name.
    :vartype host_name: str
    """

    _attribute_map = {
        'host_name': {'key': 'properties.hostName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        host_name: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword host_name: The host name of the custom domain. Must be a domain name.
        :paramtype host_name: str
        """
        super(CustomDomainParameters, self).__init__(**kwargs)
        self.host_name = host_name


class CustomerCertificate(Certificate):
    """Customer Certificate used for https.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: The type of the secret resource. Possible values include: "UrlSigningKey",
     "CustomerCertificate", "ManagedCertificate", "AzureFirstPartyManagedCertificate".
    :vartype type: str or ~azure.mgmt.cdn.models.SecretType
    :ivar subject: Subject name in the certificate.
    :vartype subject: str
    :ivar expiration_date: Certificate expiration date.
    :vartype expiration_date: str
    :ivar secret_source: Resource reference to the Azure Key Vault certificate. Expected to be in
     format of
     /subscriptions/{​​​​​​​​​subscriptionId}​​​​​​​​​/resourceGroups/{​​​​​​​​​resourceGroupName}​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​/providers/Microsoft.KeyVault/vaults/{vaultName}​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​/secrets/{certificateName}​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​.
    :vartype secret_source: ~azure.mgmt.cdn.models.ResourceReference
    :ivar secret_version: Certificate version.
    :vartype secret_version: str
    :ivar certificate_authority: Certificate issuing authority.
    :vartype certificate_authority: str
    :ivar use_latest_version: Whether to use the latest version for the certificate.
    :vartype use_latest_version: bool
    :ivar subject_alternative_names: The list of SANs.
    :vartype subject_alternative_names: list[str]
    :ivar thumbprint: Certificate thumbprint.
    :vartype thumbprint: str
    """

    _validation = {
        'subject': {'readonly': True},
        'expiration_date': {'readonly': True},
        'certificate_authority': {'readonly': True},
        'thumbprint': {'readonly': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'subject': {'key': 'subject', 'type': 'str'},
        'expiration_date': {'key': 'expirationDate', 'type': 'str'},
        'secret_source': {'key': 'secretSource', 'type': 'ResourceReference'},
        'secret_version': {'key': 'secretVersion', 'type': 'str'},
        'certificate_authority': {'key': 'certificateAuthority', 'type': 'str'},
        'use_latest_version': {'key': 'useLatestVersion', 'type': 'bool'},
        'subject_alternative_names': {'key': 'subjectAlternativeNames', 'type': '[str]'},
        'thumbprint': {'key': 'thumbprint', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        type: Optional[Union[str, "SecretType"]] = None,
        secret_source: Optional["ResourceReference"] = None,
        secret_version: Optional[str] = None,
        use_latest_version: Optional[bool] = None,
        subject_alternative_names: Optional[List[str]] = None,
        **kwargs
    ):
        """
        :keyword type: The type of the secret resource. Possible values include: "UrlSigningKey",
         "CustomerCertificate", "ManagedCertificate", "AzureFirstPartyManagedCertificate".
        :paramtype type: str or ~azure.mgmt.cdn.models.SecretType
        :keyword secret_source: Resource reference to the Azure Key Vault certificate. Expected to be
         in format of
         /subscriptions/{​​​​​​​​​subscriptionId}​​​​​​​​​/resourceGroups/{​​​​​​​​​resourceGroupName}​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​/providers/Microsoft.KeyVault/vaults/{vaultName}​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​/secrets/{certificateName}​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​.
        :paramtype secret_source: ~azure.mgmt.cdn.models.ResourceReference
        :keyword secret_version: Certificate version.
        :paramtype secret_version: str
        :keyword use_latest_version: Whether to use the latest version for the certificate.
        :paramtype use_latest_version: bool
        :keyword subject_alternative_names: The list of SANs.
        :paramtype subject_alternative_names: list[str]
        """
        super(CustomerCertificate, self).__init__(type=type, **kwargs)
        self.secret_source = secret_source
        self.secret_version = secret_version
        self.certificate_authority = None
        self.use_latest_version = use_latest_version
        self.subject_alternative_names = subject_alternative_names
        self.thumbprint = None


class CustomerCertificateParameters(SecretParameters):
    """Customer Certificate used for https.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar type: Required. The type of the secret resource.Constant filled by server. Possible
     values include: "UrlSigningKey", "CustomerCertificate", "ManagedCertificate",
     "AzureFirstPartyManagedCertificate".
    :vartype type: str or ~azure.mgmt.cdn.models.SecretType
    :ivar secret_source: Required. Resource reference to the Azure Key Vault certificate. Expected
     to be in format of
     /subscriptions/{​​​​​​​​​subscriptionId}​​​​​​​​​/resourceGroups/{​​​​​​​​​resourceGroupName}​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​/providers/Microsoft.KeyVault/vaults/{vaultName}​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​/secrets/{certificateName}​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​.
    :vartype secret_source: ~azure.mgmt.cdn.models.ResourceReference
    :ivar secret_version: Version of the secret to be used.
    :vartype secret_version: str
    :ivar use_latest_version: Whether to use the latest version for the certificate.
    :vartype use_latest_version: bool
    :ivar subject: Subject name in the certificate.
    :vartype subject: str
    :ivar expiration_date: Certificate expiration date.
    :vartype expiration_date: str
    :ivar certificate_authority: Certificate issuing authority.
    :vartype certificate_authority: str
    :ivar subject_alternative_names: The list of SANs.
    :vartype subject_alternative_names: list[str]
    :ivar thumbprint: Certificate thumbprint.
    :vartype thumbprint: str
    """

    _validation = {
        'type': {'required': True},
        'secret_source': {'required': True},
        'subject': {'readonly': True},
        'expiration_date': {'readonly': True},
        'certificate_authority': {'readonly': True},
        'thumbprint': {'readonly': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'secret_source': {'key': 'secretSource', 'type': 'ResourceReference'},
        'secret_version': {'key': 'secretVersion', 'type': 'str'},
        'use_latest_version': {'key': 'useLatestVersion', 'type': 'bool'},
        'subject': {'key': 'subject', 'type': 'str'},
        'expiration_date': {'key': 'expirationDate', 'type': 'str'},
        'certificate_authority': {'key': 'certificateAuthority', 'type': 'str'},
        'subject_alternative_names': {'key': 'subjectAlternativeNames', 'type': '[str]'},
        'thumbprint': {'key': 'thumbprint', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        secret_source: "ResourceReference",
        secret_version: Optional[str] = None,
        use_latest_version: Optional[bool] = None,
        subject_alternative_names: Optional[List[str]] = None,
        **kwargs
    ):
        """
        :keyword secret_source: Required. Resource reference to the Azure Key Vault certificate.
         Expected to be in format of
         /subscriptions/{​​​​​​​​​subscriptionId}​​​​​​​​​/resourceGroups/{​​​​​​​​​resourceGroupName}​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​/providers/Microsoft.KeyVault/vaults/{vaultName}​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​/secrets/{certificateName}​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​.
        :paramtype secret_source: ~azure.mgmt.cdn.models.ResourceReference
        :keyword secret_version: Version of the secret to be used.
        :paramtype secret_version: str
        :keyword use_latest_version: Whether to use the latest version for the certificate.
        :paramtype use_latest_version: bool
        :keyword subject_alternative_names: The list of SANs.
        :paramtype subject_alternative_names: list[str]
        """
        super(CustomerCertificateParameters, self).__init__(**kwargs)
        self.type = 'CustomerCertificate'  # type: str
        self.secret_source = secret_source
        self.secret_version = secret_version
        self.use_latest_version = use_latest_version
        self.subject = None
        self.expiration_date = None
        self.certificate_authority = None
        self.subject_alternative_names = subject_alternative_names
        self.thumbprint = None


class CustomRule(msrest.serialization.Model):
    """Defines the common attributes for a custom rule that can be included in a waf policy.

    All required parameters must be populated in order to send to Azure.

    :ivar name: Required. Defines the name of the custom rule.
    :vartype name: str
    :ivar enabled_state: Describes if the custom rule is in enabled or disabled state. Defaults to
     Enabled if not specified. Possible values include: "Disabled", "Enabled".
    :vartype enabled_state: str or ~azure.mgmt.cdn.models.CustomRuleEnabledState
    :ivar priority: Required. Defines in what order this rule be evaluated in the overall list of
     custom rules.
    :vartype priority: int
    :ivar match_conditions: Required. List of match conditions.
    :vartype match_conditions: list[~azure.mgmt.cdn.models.MatchCondition]
    :ivar action: Required. Describes what action to be applied when rule matches. Possible values
     include: "Allow", "Block", "Log", "Redirect".
    :vartype action: str or ~azure.mgmt.cdn.models.ActionType
    """

    _validation = {
        'name': {'required': True},
        'priority': {'required': True, 'maximum': 1000, 'minimum': 0},
        'match_conditions': {'required': True},
        'action': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'enabled_state': {'key': 'enabledState', 'type': 'str'},
        'priority': {'key': 'priority', 'type': 'int'},
        'match_conditions': {'key': 'matchConditions', 'type': '[MatchCondition]'},
        'action': {'key': 'action', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: str,
        priority: int,
        match_conditions: List["MatchCondition"],
        action: Union[str, "ActionType"],
        enabled_state: Optional[Union[str, "CustomRuleEnabledState"]] = None,
        **kwargs
    ):
        """
        :keyword name: Required. Defines the name of the custom rule.
        :paramtype name: str
        :keyword enabled_state: Describes if the custom rule is in enabled or disabled state. Defaults
         to Enabled if not specified. Possible values include: "Disabled", "Enabled".
        :paramtype enabled_state: str or ~azure.mgmt.cdn.models.CustomRuleEnabledState
        :keyword priority: Required. Defines in what order this rule be evaluated in the overall list
         of custom rules.
        :paramtype priority: int
        :keyword match_conditions: Required. List of match conditions.
        :paramtype match_conditions: list[~azure.mgmt.cdn.models.MatchCondition]
        :keyword action: Required. Describes what action to be applied when rule matches. Possible
         values include: "Allow", "Block", "Log", "Redirect".
        :paramtype action: str or ~azure.mgmt.cdn.models.ActionType
        """
        super(CustomRule, self).__init__(**kwargs)
        self.name = name
        self.enabled_state = enabled_state
        self.priority = priority
        self.match_conditions = match_conditions
        self.action = action


class CustomRuleList(msrest.serialization.Model):
    """Defines contents of custom rules.

    :ivar rules: List of rules.
    :vartype rules: list[~azure.mgmt.cdn.models.CustomRule]
    """

    _attribute_map = {
        'rules': {'key': 'rules', 'type': '[CustomRule]'},
    }

    def __init__(
        self,
        *,
        rules: Optional[List["CustomRule"]] = None,
        **kwargs
    ):
        """
        :keyword rules: List of rules.
        :paramtype rules: list[~azure.mgmt.cdn.models.CustomRule]
        """
        super(CustomRuleList, self).__init__(**kwargs)
        self.rules = rules


class DeepCreatedOrigin(msrest.serialization.Model):
    """The main origin of CDN content which is added when creating a CDN endpoint.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar name: Required. Origin name which must be unique within the endpoint.
    :vartype name: str
    :ivar host_name: The address of the origin. It can be a domain name, IPv4 address, or IPv6
     address. This should be unique across all origins in an endpoint.
    :vartype host_name: str
    :ivar http_port: The value of the HTTP port. Must be between 1 and 65535.
    :vartype http_port: int
    :ivar https_port: The value of the HTTPS port. Must be between 1 and 65535.
    :vartype https_port: int
    :ivar origin_host_header: The host header value sent to the origin with each request. If you
     leave this blank, the request hostname determines this value. Azure CDN origins, such as Web
     Apps, Blob Storage, and Cloud Services require this host header value to match the origin
     hostname by default.
    :vartype origin_host_header: str
    :ivar priority: Priority of origin in given origin group for load balancing. Higher priorities
     will not be used for load balancing if any lower priority origin is healthy.Must be between 1
     and 5.
    :vartype priority: int
    :ivar weight: Weight of the origin in given origin group for load balancing. Must be between 1
     and 1000.
    :vartype weight: int
    :ivar enabled: Origin is enabled for load balancing or not. By default, origin is always
     enabled.
    :vartype enabled: bool
    :ivar private_link_alias: The Alias of the Private Link resource. Populating this optional
     field indicates that this origin is 'Private'.
    :vartype private_link_alias: str
    :ivar private_link_resource_id: The Resource Id of the Private Link resource. Populating this
     optional field indicates that this backend is 'Private'.
    :vartype private_link_resource_id: str
    :ivar private_link_location: The location of the Private Link resource. Required only if
     'privateLinkResourceId' is populated.
    :vartype private_link_location: str
    :ivar private_link_approval_message: A custom message to be included in the approval request to
     connect to the Private Link.
    :vartype private_link_approval_message: str
    :ivar private_endpoint_status: The approval status for the connection to the Private Link.
     Possible values include: "Pending", "Approved", "Rejected", "Disconnected", "Timeout".
    :vartype private_endpoint_status: str or ~azure.mgmt.cdn.models.PrivateEndpointStatus
    """

    _validation = {
        'name': {'required': True},
        'http_port': {'maximum': 65535, 'minimum': 1},
        'https_port': {'maximum': 65535, 'minimum': 1},
        'priority': {'maximum': 5, 'minimum': 1},
        'weight': {'maximum': 1000, 'minimum': 1},
        'private_endpoint_status': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'host_name': {'key': 'properties.hostName', 'type': 'str'},
        'http_port': {'key': 'properties.httpPort', 'type': 'int'},
        'https_port': {'key': 'properties.httpsPort', 'type': 'int'},
        'origin_host_header': {'key': 'properties.originHostHeader', 'type': 'str'},
        'priority': {'key': 'properties.priority', 'type': 'int'},
        'weight': {'key': 'properties.weight', 'type': 'int'},
        'enabled': {'key': 'properties.enabled', 'type': 'bool'},
        'private_link_alias': {'key': 'properties.privateLinkAlias', 'type': 'str'},
        'private_link_resource_id': {'key': 'properties.privateLinkResourceId', 'type': 'str'},
        'private_link_location': {'key': 'properties.privateLinkLocation', 'type': 'str'},
        'private_link_approval_message': {'key': 'properties.privateLinkApprovalMessage', 'type': 'str'},
        'private_endpoint_status': {'key': 'properties.privateEndpointStatus', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: str,
        host_name: Optional[str] = None,
        http_port: Optional[int] = None,
        https_port: Optional[int] = None,
        origin_host_header: Optional[str] = None,
        priority: Optional[int] = None,
        weight: Optional[int] = None,
        enabled: Optional[bool] = None,
        private_link_alias: Optional[str] = None,
        private_link_resource_id: Optional[str] = None,
        private_link_location: Optional[str] = None,
        private_link_approval_message: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword name: Required. Origin name which must be unique within the endpoint.
        :paramtype name: str
        :keyword host_name: The address of the origin. It can be a domain name, IPv4 address, or IPv6
         address. This should be unique across all origins in an endpoint.
        :paramtype host_name: str
        :keyword http_port: The value of the HTTP port. Must be between 1 and 65535.
        :paramtype http_port: int
        :keyword https_port: The value of the HTTPS port. Must be between 1 and 65535.
        :paramtype https_port: int
        :keyword origin_host_header: The host header value sent to the origin with each request. If you
         leave this blank, the request hostname determines this value. Azure CDN origins, such as Web
         Apps, Blob Storage, and Cloud Services require this host header value to match the origin
         hostname by default.
        :paramtype origin_host_header: str
        :keyword priority: Priority of origin in given origin group for load balancing. Higher
         priorities will not be used for load balancing if any lower priority origin is healthy.Must be
         between 1 and 5.
        :paramtype priority: int
        :keyword weight: Weight of the origin in given origin group for load balancing. Must be between
         1 and 1000.
        :paramtype weight: int
        :keyword enabled: Origin is enabled for load balancing or not. By default, origin is always
         enabled.
        :paramtype enabled: bool
        :keyword private_link_alias: The Alias of the Private Link resource. Populating this optional
         field indicates that this origin is 'Private'.
        :paramtype private_link_alias: str
        :keyword private_link_resource_id: The Resource Id of the Private Link resource. Populating
         this optional field indicates that this backend is 'Private'.
        :paramtype private_link_resource_id: str
        :keyword private_link_location: The location of the Private Link resource. Required only if
         'privateLinkResourceId' is populated.
        :paramtype private_link_location: str
        :keyword private_link_approval_message: A custom message to be included in the approval request
         to connect to the Private Link.
        :paramtype private_link_approval_message: str
        """
        super(DeepCreatedOrigin, self).__init__(**kwargs)
        self.name = name
        self.host_name = host_name
        self.http_port = http_port
        self.https_port = https_port
        self.origin_host_header = origin_host_header
        self.priority = priority
        self.weight = weight
        self.enabled = enabled
        self.private_link_alias = private_link_alias
        self.private_link_resource_id = private_link_resource_id
        self.private_link_location = private_link_location
        self.private_link_approval_message = private_link_approval_message
        self.private_endpoint_status = None


class DeepCreatedOriginGroup(msrest.serialization.Model):
    """The origin group for CDN content which is added when creating a CDN endpoint. Traffic is sent to the origins within the origin group based on origin health.

    All required parameters must be populated in order to send to Azure.

    :ivar name: Required. Origin group name which must be unique within the endpoint.
    :vartype name: str
    :ivar health_probe_settings: Health probe settings to the origin that is used to determine the
     health of the origin.
    :vartype health_probe_settings: ~azure.mgmt.cdn.models.HealthProbeParameters
    :ivar origins: The source of the content being delivered via CDN within given origin group.
    :vartype origins: list[~azure.mgmt.cdn.models.ResourceReference]
    :ivar traffic_restoration_time_to_healed_or_new_endpoints_in_minutes: Time in minutes to shift
     the traffic to the endpoint gradually when an unhealthy endpoint comes healthy or a new
     endpoint is added. Default is 10 mins. This property is currently not supported.
    :vartype traffic_restoration_time_to_healed_or_new_endpoints_in_minutes: int
    :ivar response_based_origin_error_detection_settings: The JSON object that contains the
     properties to determine origin health using real requests/responses.This property is currently
     not supported.
    :vartype response_based_origin_error_detection_settings:
     ~azure.mgmt.cdn.models.ResponseBasedOriginErrorDetectionParameters
    """

    _validation = {
        'name': {'required': True},
        'traffic_restoration_time_to_healed_or_new_endpoints_in_minutes': {'maximum': 50, 'minimum': 0},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'health_probe_settings': {'key': 'properties.healthProbeSettings', 'type': 'HealthProbeParameters'},
        'origins': {'key': 'properties.origins', 'type': '[ResourceReference]'},
        'traffic_restoration_time_to_healed_or_new_endpoints_in_minutes': {'key': 'properties.trafficRestorationTimeToHealedOrNewEndpointsInMinutes', 'type': 'int'},
        'response_based_origin_error_detection_settings': {'key': 'properties.responseBasedOriginErrorDetectionSettings', 'type': 'ResponseBasedOriginErrorDetectionParameters'},
    }

    def __init__(
        self,
        *,
        name: str,
        health_probe_settings: Optional["HealthProbeParameters"] = None,
        origins: Optional[List["ResourceReference"]] = None,
        traffic_restoration_time_to_healed_or_new_endpoints_in_minutes: Optional[int] = None,
        response_based_origin_error_detection_settings: Optional["ResponseBasedOriginErrorDetectionParameters"] = None,
        **kwargs
    ):
        """
        :keyword name: Required. Origin group name which must be unique within the endpoint.
        :paramtype name: str
        :keyword health_probe_settings: Health probe settings to the origin that is used to determine
         the health of the origin.
        :paramtype health_probe_settings: ~azure.mgmt.cdn.models.HealthProbeParameters
        :keyword origins: The source of the content being delivered via CDN within given origin group.
        :paramtype origins: list[~azure.mgmt.cdn.models.ResourceReference]
        :keyword traffic_restoration_time_to_healed_or_new_endpoints_in_minutes: Time in minutes to
         shift the traffic to the endpoint gradually when an unhealthy endpoint comes healthy or a new
         endpoint is added. Default is 10 mins. This property is currently not supported.
        :paramtype traffic_restoration_time_to_healed_or_new_endpoints_in_minutes: int
        :keyword response_based_origin_error_detection_settings: The JSON object that contains the
         properties to determine origin health using real requests/responses.This property is currently
         not supported.
        :paramtype response_based_origin_error_detection_settings:
         ~azure.mgmt.cdn.models.ResponseBasedOriginErrorDetectionParameters
        """
        super(DeepCreatedOriginGroup, self).__init__(**kwargs)
        self.name = name
        self.health_probe_settings = health_probe_settings
        self.origins = origins
        self.traffic_restoration_time_to_healed_or_new_endpoints_in_minutes = traffic_restoration_time_to_healed_or_new_endpoints_in_minutes
        self.response_based_origin_error_detection_settings = response_based_origin_error_detection_settings


class DeliveryRule(msrest.serialization.Model):
    """A rule that specifies a set of actions and conditions.

    All required parameters must be populated in order to send to Azure.

    :ivar name: Name of the rule.
    :vartype name: str
    :ivar order: Required. The order in which the rules are applied for the endpoint. Possible
     values {0,1,2,3,………}. A rule with a lesser order will be applied before a rule with a greater
     order. Rule with order 0 is a special rule. It does not require any condition and actions
     listed in it will always be applied.
    :vartype order: int
    :ivar conditions: A list of conditions that must be matched for the actions to be executed.
    :vartype conditions: list[~azure.mgmt.cdn.models.DeliveryRuleCondition]
    :ivar actions: Required. A list of actions that are executed when all the conditions of a rule
     are satisfied.
    :vartype actions: list[~azure.mgmt.cdn.models.DeliveryRuleAction]
    """

    _validation = {
        'order': {'required': True},
        'actions': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'order': {'key': 'order', 'type': 'int'},
        'conditions': {'key': 'conditions', 'type': '[DeliveryRuleCondition]'},
        'actions': {'key': 'actions', 'type': '[DeliveryRuleAction]'},
    }

    def __init__(
        self,
        *,
        order: int,
        actions: List["DeliveryRuleAction"],
        name: Optional[str] = None,
        conditions: Optional[List["DeliveryRuleCondition"]] = None,
        **kwargs
    ):
        """
        :keyword name: Name of the rule.
        :paramtype name: str
        :keyword order: Required. The order in which the rules are applied for the endpoint. Possible
         values {0,1,2,3,………}. A rule with a lesser order will be applied before a rule with a greater
         order. Rule with order 0 is a special rule. It does not require any condition and actions
         listed in it will always be applied.
        :paramtype order: int
        :keyword conditions: A list of conditions that must be matched for the actions to be executed.
        :paramtype conditions: list[~azure.mgmt.cdn.models.DeliveryRuleCondition]
        :keyword actions: Required. A list of actions that are executed when all the conditions of a
         rule are satisfied.
        :paramtype actions: list[~azure.mgmt.cdn.models.DeliveryRuleAction]
        """
        super(DeliveryRule, self).__init__(**kwargs)
        self.name = name
        self.order = order
        self.conditions = conditions
        self.actions = actions


class DeliveryRuleAction(msrest.serialization.Model):
    """An action for the delivery rule.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: DeliveryRuleCacheExpirationAction, DeliveryRuleCacheKeyQueryStringAction, DeliveryRuleRequestHeaderAction, DeliveryRuleResponseHeaderAction, OriginGroupOverrideAction, DeliveryRuleRouteConfigurationOverrideAction, UrlRedirectAction, UrlRewriteAction, UrlSigningAction.

    All required parameters must be populated in order to send to Azure.

    :ivar name: Required. The name of the action for the delivery rule.Constant filled by server.
     Possible values include: "CacheExpiration", "CacheKeyQueryString", "ModifyRequestHeader",
     "ModifyResponseHeader", "UrlRedirect", "UrlRewrite", "UrlSigning", "OriginGroupOverride",
     "RouteConfigurationOverride".
    :vartype name: str or ~azure.mgmt.cdn.models.DeliveryRuleActionEnum
    """

    _validation = {
        'name': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
    }

    _subtype_map = {
        'name': {'CacheExpiration': 'DeliveryRuleCacheExpirationAction', 'CacheKeyQueryString': 'DeliveryRuleCacheKeyQueryStringAction', 'ModifyRequestHeader': 'DeliveryRuleRequestHeaderAction', 'ModifyResponseHeader': 'DeliveryRuleResponseHeaderAction', 'OriginGroupOverride': 'OriginGroupOverrideAction', 'RouteConfigurationOverride': 'DeliveryRuleRouteConfigurationOverrideAction', 'UrlRedirect': 'UrlRedirectAction', 'UrlRewrite': 'UrlRewriteAction', 'UrlSigning': 'UrlSigningAction'}
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(DeliveryRuleAction, self).__init__(**kwargs)
        self.name = None  # type: Optional[str]


class DeliveryRuleCacheExpirationAction(DeliveryRuleAction):
    """Defines the cache expiration action for the delivery rule.

    All required parameters must be populated in order to send to Azure.

    :ivar name: Required. The name of the action for the delivery rule.Constant filled by server.
     Possible values include: "CacheExpiration", "CacheKeyQueryString", "ModifyRequestHeader",
     "ModifyResponseHeader", "UrlRedirect", "UrlRewrite", "UrlSigning", "OriginGroupOverride",
     "RouteConfigurationOverride".
    :vartype name: str or ~azure.mgmt.cdn.models.DeliveryRuleActionEnum
    :ivar parameters: Required. Defines the parameters for the action.
    :vartype parameters: ~azure.mgmt.cdn.models.CacheExpirationActionParameters
    """

    _validation = {
        'name': {'required': True},
        'parameters': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': 'CacheExpirationActionParameters'},
    }

    def __init__(
        self,
        *,
        parameters: "CacheExpirationActionParameters",
        **kwargs
    ):
        """
        :keyword parameters: Required. Defines the parameters for the action.
        :paramtype parameters: ~azure.mgmt.cdn.models.CacheExpirationActionParameters
        """
        super(DeliveryRuleCacheExpirationAction, self).__init__(**kwargs)
        self.name = 'CacheExpiration'  # type: str
        self.parameters = parameters


class DeliveryRuleCacheKeyQueryStringAction(DeliveryRuleAction):
    """Defines the cache-key query string action for the delivery rule.

    All required parameters must be populated in order to send to Azure.

    :ivar name: Required. The name of the action for the delivery rule.Constant filled by server.
     Possible values include: "CacheExpiration", "CacheKeyQueryString", "ModifyRequestHeader",
     "ModifyResponseHeader", "UrlRedirect", "UrlRewrite", "UrlSigning", "OriginGroupOverride",
     "RouteConfigurationOverride".
    :vartype name: str or ~azure.mgmt.cdn.models.DeliveryRuleActionEnum
    :ivar parameters: Required. Defines the parameters for the action.
    :vartype parameters: ~azure.mgmt.cdn.models.CacheKeyQueryStringActionParameters
    """

    _validation = {
        'name': {'required': True},
        'parameters': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': 'CacheKeyQueryStringActionParameters'},
    }

    def __init__(
        self,
        *,
        parameters: "CacheKeyQueryStringActionParameters",
        **kwargs
    ):
        """
        :keyword parameters: Required. Defines the parameters for the action.
        :paramtype parameters: ~azure.mgmt.cdn.models.CacheKeyQueryStringActionParameters
        """
        super(DeliveryRuleCacheKeyQueryStringAction, self).__init__(**kwargs)
        self.name = 'CacheKeyQueryString'  # type: str
        self.parameters = parameters


class DeliveryRuleCondition(msrest.serialization.Model):
    """A condition for the delivery rule.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: DeliveryRuleClientPortCondition, DeliveryRuleCookiesCondition, DeliveryRuleHostNameCondition, DeliveryRuleHttpVersionCondition, DeliveryRuleIsDeviceCondition, DeliveryRulePostArgsCondition, DeliveryRuleQueryStringCondition, DeliveryRuleRemoteAddressCondition, DeliveryRuleRequestBodyCondition, DeliveryRuleRequestHeaderCondition, DeliveryRuleRequestMethodCondition, DeliveryRuleRequestSchemeCondition, DeliveryRuleRequestUriCondition, DeliveryRuleServerPortCondition, DeliveryRuleSocketAddrCondition, DeliveryRuleSslProtocolCondition, DeliveryRuleUrlFileExtensionCondition, DeliveryRuleUrlFileNameCondition, DeliveryRuleUrlPathCondition.

    All required parameters must be populated in order to send to Azure.

    :ivar name: Required. The name of the condition for the delivery rule.Constant filled by
     server. Possible values include: "RemoteAddress", "RequestMethod", "QueryString", "PostArgs",
     "RequestUri", "RequestHeader", "RequestBody", "RequestScheme", "UrlPath", "UrlFileExtension",
     "UrlFileName", "HttpVersion", "Cookies", "IsDevice", "SocketAddr", "ClientPort", "ServerPort",
     "HostName", "SslProtocol".
    :vartype name: str or ~azure.mgmt.cdn.models.MatchVariable
    """

    _validation = {
        'name': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
    }

    _subtype_map = {
        'name': {'ClientPort': 'DeliveryRuleClientPortCondition', 'Cookies': 'DeliveryRuleCookiesCondition', 'HostName': 'DeliveryRuleHostNameCondition', 'HttpVersion': 'DeliveryRuleHttpVersionCondition', 'IsDevice': 'DeliveryRuleIsDeviceCondition', 'PostArgs': 'DeliveryRulePostArgsCondition', 'QueryString': 'DeliveryRuleQueryStringCondition', 'RemoteAddress': 'DeliveryRuleRemoteAddressCondition', 'RequestBody': 'DeliveryRuleRequestBodyCondition', 'RequestHeader': 'DeliveryRuleRequestHeaderCondition', 'RequestMethod': 'DeliveryRuleRequestMethodCondition', 'RequestScheme': 'DeliveryRuleRequestSchemeCondition', 'RequestUri': 'DeliveryRuleRequestUriCondition', 'ServerPort': 'DeliveryRuleServerPortCondition', 'SocketAddr': 'DeliveryRuleSocketAddrCondition', 'SslProtocol': 'DeliveryRuleSslProtocolCondition', 'UrlFileExtension': 'DeliveryRuleUrlFileExtensionCondition', 'UrlFileName': 'DeliveryRuleUrlFileNameCondition', 'UrlPath': 'DeliveryRuleUrlPathCondition'}
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(DeliveryRuleCondition, self).__init__(**kwargs)
        self.name = None  # type: Optional[str]


class DeliveryRuleClientPortCondition(DeliveryRuleCondition):
    """Defines the ClientPort condition for the delivery rule.

    All required parameters must be populated in order to send to Azure.

    :ivar name: Required. The name of the condition for the delivery rule.Constant filled by
     server. Possible values include: "RemoteAddress", "RequestMethod", "QueryString", "PostArgs",
     "RequestUri", "RequestHeader", "RequestBody", "RequestScheme", "UrlPath", "UrlFileExtension",
     "UrlFileName", "HttpVersion", "Cookies", "IsDevice", "SocketAddr", "ClientPort", "ServerPort",
     "HostName", "SslProtocol".
    :vartype name: str or ~azure.mgmt.cdn.models.MatchVariable
    :ivar parameters: Required. Defines the parameters for the condition.
    :vartype parameters: ~azure.mgmt.cdn.models.ClientPortMatchConditionParameters
    """

    _validation = {
        'name': {'required': True},
        'parameters': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': 'ClientPortMatchConditionParameters'},
    }

    def __init__(
        self,
        *,
        parameters: "ClientPortMatchConditionParameters",
        **kwargs
    ):
        """
        :keyword parameters: Required. Defines the parameters for the condition.
        :paramtype parameters: ~azure.mgmt.cdn.models.ClientPortMatchConditionParameters
        """
        super(DeliveryRuleClientPortCondition, self).__init__(**kwargs)
        self.name = 'ClientPort'  # type: str
        self.parameters = parameters


class DeliveryRuleCookiesCondition(DeliveryRuleCondition):
    """Defines the Cookies condition for the delivery rule.

    All required parameters must be populated in order to send to Azure.

    :ivar name: Required. The name of the condition for the delivery rule.Constant filled by
     server. Possible values include: "RemoteAddress", "RequestMethod", "QueryString", "PostArgs",
     "RequestUri", "RequestHeader", "RequestBody", "RequestScheme", "UrlPath", "UrlFileExtension",
     "UrlFileName", "HttpVersion", "Cookies", "IsDevice", "SocketAddr", "ClientPort", "ServerPort",
     "HostName", "SslProtocol".
    :vartype name: str or ~azure.mgmt.cdn.models.MatchVariable
    :ivar parameters: Required. Defines the parameters for the condition.
    :vartype parameters: ~azure.mgmt.cdn.models.CookiesMatchConditionParameters
    """

    _validation = {
        'name': {'required': True},
        'parameters': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': 'CookiesMatchConditionParameters'},
    }

    def __init__(
        self,
        *,
        parameters: "CookiesMatchConditionParameters",
        **kwargs
    ):
        """
        :keyword parameters: Required. Defines the parameters for the condition.
        :paramtype parameters: ~azure.mgmt.cdn.models.CookiesMatchConditionParameters
        """
        super(DeliveryRuleCookiesCondition, self).__init__(**kwargs)
        self.name = 'Cookies'  # type: str
        self.parameters = parameters


class DeliveryRuleHostNameCondition(DeliveryRuleCondition):
    """Defines the HostName condition for the delivery rule.

    All required parameters must be populated in order to send to Azure.

    :ivar name: Required. The name of the condition for the delivery rule.Constant filled by
     server. Possible values include: "RemoteAddress", "RequestMethod", "QueryString", "PostArgs",
     "RequestUri", "RequestHeader", "RequestBody", "RequestScheme", "UrlPath", "UrlFileExtension",
     "UrlFileName", "HttpVersion", "Cookies", "IsDevice", "SocketAddr", "ClientPort", "ServerPort",
     "HostName", "SslProtocol".
    :vartype name: str or ~azure.mgmt.cdn.models.MatchVariable
    :ivar parameters: Required. Defines the parameters for the condition.
    :vartype parameters: ~azure.mgmt.cdn.models.HostNameMatchConditionParameters
    """

    _validation = {
        'name': {'required': True},
        'parameters': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': 'HostNameMatchConditionParameters'},
    }

    def __init__(
        self,
        *,
        parameters: "HostNameMatchConditionParameters",
        **kwargs
    ):
        """
        :keyword parameters: Required. Defines the parameters for the condition.
        :paramtype parameters: ~azure.mgmt.cdn.models.HostNameMatchConditionParameters
        """
        super(DeliveryRuleHostNameCondition, self).__init__(**kwargs)
        self.name = 'HostName'  # type: str
        self.parameters = parameters


class DeliveryRuleHttpVersionCondition(DeliveryRuleCondition):
    """Defines the HttpVersion condition for the delivery rule.

    All required parameters must be populated in order to send to Azure.

    :ivar name: Required. The name of the condition for the delivery rule.Constant filled by
     server. Possible values include: "RemoteAddress", "RequestMethod", "QueryString", "PostArgs",
     "RequestUri", "RequestHeader", "RequestBody", "RequestScheme", "UrlPath", "UrlFileExtension",
     "UrlFileName", "HttpVersion", "Cookies", "IsDevice", "SocketAddr", "ClientPort", "ServerPort",
     "HostName", "SslProtocol".
    :vartype name: str or ~azure.mgmt.cdn.models.MatchVariable
    :ivar parameters: Required. Defines the parameters for the condition.
    :vartype parameters: ~azure.mgmt.cdn.models.HttpVersionMatchConditionParameters
    """

    _validation = {
        'name': {'required': True},
        'parameters': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': 'HttpVersionMatchConditionParameters'},
    }

    def __init__(
        self,
        *,
        parameters: "HttpVersionMatchConditionParameters",
        **kwargs
    ):
        """
        :keyword parameters: Required. Defines the parameters for the condition.
        :paramtype parameters: ~azure.mgmt.cdn.models.HttpVersionMatchConditionParameters
        """
        super(DeliveryRuleHttpVersionCondition, self).__init__(**kwargs)
        self.name = 'HttpVersion'  # type: str
        self.parameters = parameters


class DeliveryRuleIsDeviceCondition(DeliveryRuleCondition):
    """Defines the IsDevice condition for the delivery rule.

    All required parameters must be populated in order to send to Azure.

    :ivar name: Required. The name of the condition for the delivery rule.Constant filled by
     server. Possible values include: "RemoteAddress", "RequestMethod", "QueryString", "PostArgs",
     "RequestUri", "RequestHeader", "RequestBody", "RequestScheme", "UrlPath", "UrlFileExtension",
     "UrlFileName", "HttpVersion", "Cookies", "IsDevice", "SocketAddr", "ClientPort", "ServerPort",
     "HostName", "SslProtocol".
    :vartype name: str or ~azure.mgmt.cdn.models.MatchVariable
    :ivar parameters: Required. Defines the parameters for the condition.
    :vartype parameters: ~azure.mgmt.cdn.models.IsDeviceMatchConditionParameters
    """

    _validation = {
        'name': {'required': True},
        'parameters': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': 'IsDeviceMatchConditionParameters'},
    }

    def __init__(
        self,
        *,
        parameters: "IsDeviceMatchConditionParameters",
        **kwargs
    ):
        """
        :keyword parameters: Required. Defines the parameters for the condition.
        :paramtype parameters: ~azure.mgmt.cdn.models.IsDeviceMatchConditionParameters
        """
        super(DeliveryRuleIsDeviceCondition, self).__init__(**kwargs)
        self.name = 'IsDevice'  # type: str
        self.parameters = parameters


class DeliveryRulePostArgsCondition(DeliveryRuleCondition):
    """Defines the PostArgs condition for the delivery rule.

    All required parameters must be populated in order to send to Azure.

    :ivar name: Required. The name of the condition for the delivery rule.Constant filled by
     server. Possible values include: "RemoteAddress", "RequestMethod", "QueryString", "PostArgs",
     "RequestUri", "RequestHeader", "RequestBody", "RequestScheme", "UrlPath", "UrlFileExtension",
     "UrlFileName", "HttpVersion", "Cookies", "IsDevice", "SocketAddr", "ClientPort", "ServerPort",
     "HostName", "SslProtocol".
    :vartype name: str or ~azure.mgmt.cdn.models.MatchVariable
    :ivar parameters: Required. Defines the parameters for the condition.
    :vartype parameters: ~azure.mgmt.cdn.models.PostArgsMatchConditionParameters
    """

    _validation = {
        'name': {'required': True},
        'parameters': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': 'PostArgsMatchConditionParameters'},
    }

    def __init__(
        self,
        *,
        parameters: "PostArgsMatchConditionParameters",
        **kwargs
    ):
        """
        :keyword parameters: Required. Defines the parameters for the condition.
        :paramtype parameters: ~azure.mgmt.cdn.models.PostArgsMatchConditionParameters
        """
        super(DeliveryRulePostArgsCondition, self).__init__(**kwargs)
        self.name = 'PostArgs'  # type: str
        self.parameters = parameters


class DeliveryRuleQueryStringCondition(DeliveryRuleCondition):
    """Defines the QueryString condition for the delivery rule.

    All required parameters must be populated in order to send to Azure.

    :ivar name: Required. The name of the condition for the delivery rule.Constant filled by
     server. Possible values include: "RemoteAddress", "RequestMethod", "QueryString", "PostArgs",
     "RequestUri", "RequestHeader", "RequestBody", "RequestScheme", "UrlPath", "UrlFileExtension",
     "UrlFileName", "HttpVersion", "Cookies", "IsDevice", "SocketAddr", "ClientPort", "ServerPort",
     "HostName", "SslProtocol".
    :vartype name: str or ~azure.mgmt.cdn.models.MatchVariable
    :ivar parameters: Required. Defines the parameters for the condition.
    :vartype parameters: ~azure.mgmt.cdn.models.QueryStringMatchConditionParameters
    """

    _validation = {
        'name': {'required': True},
        'parameters': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': 'QueryStringMatchConditionParameters'},
    }

    def __init__(
        self,
        *,
        parameters: "QueryStringMatchConditionParameters",
        **kwargs
    ):
        """
        :keyword parameters: Required. Defines the parameters for the condition.
        :paramtype parameters: ~azure.mgmt.cdn.models.QueryStringMatchConditionParameters
        """
        super(DeliveryRuleQueryStringCondition, self).__init__(**kwargs)
        self.name = 'QueryString'  # type: str
        self.parameters = parameters


class DeliveryRuleRemoteAddressCondition(DeliveryRuleCondition):
    """Defines the RemoteAddress condition for the delivery rule.

    All required parameters must be populated in order to send to Azure.

    :ivar name: Required. The name of the condition for the delivery rule.Constant filled by
     server. Possible values include: "RemoteAddress", "RequestMethod", "QueryString", "PostArgs",
     "RequestUri", "RequestHeader", "RequestBody", "RequestScheme", "UrlPath", "UrlFileExtension",
     "UrlFileName", "HttpVersion", "Cookies", "IsDevice", "SocketAddr", "ClientPort", "ServerPort",
     "HostName", "SslProtocol".
    :vartype name: str or ~azure.mgmt.cdn.models.MatchVariable
    :ivar parameters: Required. Defines the parameters for the condition.
    :vartype parameters: ~azure.mgmt.cdn.models.RemoteAddressMatchConditionParameters
    """

    _validation = {
        'name': {'required': True},
        'parameters': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': 'RemoteAddressMatchConditionParameters'},
    }

    def __init__(
        self,
        *,
        parameters: "RemoteAddressMatchConditionParameters",
        **kwargs
    ):
        """
        :keyword parameters: Required. Defines the parameters for the condition.
        :paramtype parameters: ~azure.mgmt.cdn.models.RemoteAddressMatchConditionParameters
        """
        super(DeliveryRuleRemoteAddressCondition, self).__init__(**kwargs)
        self.name = 'RemoteAddress'  # type: str
        self.parameters = parameters


class DeliveryRuleRequestBodyCondition(DeliveryRuleCondition):
    """Defines the RequestBody condition for the delivery rule.

    All required parameters must be populated in order to send to Azure.

    :ivar name: Required. The name of the condition for the delivery rule.Constant filled by
     server. Possible values include: "RemoteAddress", "RequestMethod", "QueryString", "PostArgs",
     "RequestUri", "RequestHeader", "RequestBody", "RequestScheme", "UrlPath", "UrlFileExtension",
     "UrlFileName", "HttpVersion", "Cookies", "IsDevice", "SocketAddr", "ClientPort", "ServerPort",
     "HostName", "SslProtocol".
    :vartype name: str or ~azure.mgmt.cdn.models.MatchVariable
    :ivar parameters: Required. Defines the parameters for the condition.
    :vartype parameters: ~azure.mgmt.cdn.models.RequestBodyMatchConditionParameters
    """

    _validation = {
        'name': {'required': True},
        'parameters': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': 'RequestBodyMatchConditionParameters'},
    }

    def __init__(
        self,
        *,
        parameters: "RequestBodyMatchConditionParameters",
        **kwargs
    ):
        """
        :keyword parameters: Required. Defines the parameters for the condition.
        :paramtype parameters: ~azure.mgmt.cdn.models.RequestBodyMatchConditionParameters
        """
        super(DeliveryRuleRequestBodyCondition, self).__init__(**kwargs)
        self.name = 'RequestBody'  # type: str
        self.parameters = parameters


class DeliveryRuleRequestHeaderAction(DeliveryRuleAction):
    """Defines the request header action for the delivery rule.

    All required parameters must be populated in order to send to Azure.

    :ivar name: Required. The name of the action for the delivery rule.Constant filled by server.
     Possible values include: "CacheExpiration", "CacheKeyQueryString", "ModifyRequestHeader",
     "ModifyResponseHeader", "UrlRedirect", "UrlRewrite", "UrlSigning", "OriginGroupOverride",
     "RouteConfigurationOverride".
    :vartype name: str or ~azure.mgmt.cdn.models.DeliveryRuleActionEnum
    :ivar parameters: Required. Defines the parameters for the action.
    :vartype parameters: ~azure.mgmt.cdn.models.HeaderActionParameters
    """

    _validation = {
        'name': {'required': True},
        'parameters': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': 'HeaderActionParameters'},
    }

    def __init__(
        self,
        *,
        parameters: "HeaderActionParameters",
        **kwargs
    ):
        """
        :keyword parameters: Required. Defines the parameters for the action.
        :paramtype parameters: ~azure.mgmt.cdn.models.HeaderActionParameters
        """
        super(DeliveryRuleRequestHeaderAction, self).__init__(**kwargs)
        self.name = 'ModifyRequestHeader'  # type: str
        self.parameters = parameters


class DeliveryRuleRequestHeaderCondition(DeliveryRuleCondition):
    """Defines the RequestHeader condition for the delivery rule.

    All required parameters must be populated in order to send to Azure.

    :ivar name: Required. The name of the condition for the delivery rule.Constant filled by
     server. Possible values include: "RemoteAddress", "RequestMethod", "QueryString", "PostArgs",
     "RequestUri", "RequestHeader", "RequestBody", "RequestScheme", "UrlPath", "UrlFileExtension",
     "UrlFileName", "HttpVersion", "Cookies", "IsDevice", "SocketAddr", "ClientPort", "ServerPort",
     "HostName", "SslProtocol".
    :vartype name: str or ~azure.mgmt.cdn.models.MatchVariable
    :ivar parameters: Required. Defines the parameters for the condition.
    :vartype parameters: ~azure.mgmt.cdn.models.RequestHeaderMatchConditionParameters
    """

    _validation = {
        'name': {'required': True},
        'parameters': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': 'RequestHeaderMatchConditionParameters'},
    }

    def __init__(
        self,
        *,
        parameters: "RequestHeaderMatchConditionParameters",
        **kwargs
    ):
        """
        :keyword parameters: Required. Defines the parameters for the condition.
        :paramtype parameters: ~azure.mgmt.cdn.models.RequestHeaderMatchConditionParameters
        """
        super(DeliveryRuleRequestHeaderCondition, self).__init__(**kwargs)
        self.name = 'RequestHeader'  # type: str
        self.parameters = parameters


class DeliveryRuleRequestMethodCondition(DeliveryRuleCondition):
    """Defines the RequestMethod condition for the delivery rule.

    All required parameters must be populated in order to send to Azure.

    :ivar name: Required. The name of the condition for the delivery rule.Constant filled by
     server. Possible values include: "RemoteAddress", "RequestMethod", "QueryString", "PostArgs",
     "RequestUri", "RequestHeader", "RequestBody", "RequestScheme", "UrlPath", "UrlFileExtension",
     "UrlFileName", "HttpVersion", "Cookies", "IsDevice", "SocketAddr", "ClientPort", "ServerPort",
     "HostName", "SslProtocol".
    :vartype name: str or ~azure.mgmt.cdn.models.MatchVariable
    :ivar parameters: Required. Defines the parameters for the condition.
    :vartype parameters: ~azure.mgmt.cdn.models.RequestMethodMatchConditionParameters
    """

    _validation = {
        'name': {'required': True},
        'parameters': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': 'RequestMethodMatchConditionParameters'},
    }

    def __init__(
        self,
        *,
        parameters: "RequestMethodMatchConditionParameters",
        **kwargs
    ):
        """
        :keyword parameters: Required. Defines the parameters for the condition.
        :paramtype parameters: ~azure.mgmt.cdn.models.RequestMethodMatchConditionParameters
        """
        super(DeliveryRuleRequestMethodCondition, self).__init__(**kwargs)
        self.name = 'RequestMethod'  # type: str
        self.parameters = parameters


class DeliveryRuleRequestSchemeCondition(DeliveryRuleCondition):
    """Defines the RequestScheme condition for the delivery rule.

    All required parameters must be populated in order to send to Azure.

    :ivar name: Required. The name of the condition for the delivery rule.Constant filled by
     server. Possible values include: "RemoteAddress", "RequestMethod", "QueryString", "PostArgs",
     "RequestUri", "RequestHeader", "RequestBody", "RequestScheme", "UrlPath", "UrlFileExtension",
     "UrlFileName", "HttpVersion", "Cookies", "IsDevice", "SocketAddr", "ClientPort", "ServerPort",
     "HostName", "SslProtocol".
    :vartype name: str or ~azure.mgmt.cdn.models.MatchVariable
    :ivar parameters: Required. Defines the parameters for the condition.
    :vartype parameters: ~azure.mgmt.cdn.models.RequestSchemeMatchConditionParameters
    """

    _validation = {
        'name': {'required': True},
        'parameters': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': 'RequestSchemeMatchConditionParameters'},
    }

    def __init__(
        self,
        *,
        parameters: "RequestSchemeMatchConditionParameters",
        **kwargs
    ):
        """
        :keyword parameters: Required. Defines the parameters for the condition.
        :paramtype parameters: ~azure.mgmt.cdn.models.RequestSchemeMatchConditionParameters
        """
        super(DeliveryRuleRequestSchemeCondition, self).__init__(**kwargs)
        self.name = 'RequestScheme'  # type: str
        self.parameters = parameters


class DeliveryRuleRequestUriCondition(DeliveryRuleCondition):
    """Defines the RequestUri condition for the delivery rule.

    All required parameters must be populated in order to send to Azure.

    :ivar name: Required. The name of the condition for the delivery rule.Constant filled by
     server. Possible values include: "RemoteAddress", "RequestMethod", "QueryString", "PostArgs",
     "RequestUri", "RequestHeader", "RequestBody", "RequestScheme", "UrlPath", "UrlFileExtension",
     "UrlFileName", "HttpVersion", "Cookies", "IsDevice", "SocketAddr", "ClientPort", "ServerPort",
     "HostName", "SslProtocol".
    :vartype name: str or ~azure.mgmt.cdn.models.MatchVariable
    :ivar parameters: Required. Defines the parameters for the condition.
    :vartype parameters: ~azure.mgmt.cdn.models.RequestUriMatchConditionParameters
    """

    _validation = {
        'name': {'required': True},
        'parameters': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': 'RequestUriMatchConditionParameters'},
    }

    def __init__(
        self,
        *,
        parameters: "RequestUriMatchConditionParameters",
        **kwargs
    ):
        """
        :keyword parameters: Required. Defines the parameters for the condition.
        :paramtype parameters: ~azure.mgmt.cdn.models.RequestUriMatchConditionParameters
        """
        super(DeliveryRuleRequestUriCondition, self).__init__(**kwargs)
        self.name = 'RequestUri'  # type: str
        self.parameters = parameters


class DeliveryRuleResponseHeaderAction(DeliveryRuleAction):
    """Defines the response header action for the delivery rule.

    All required parameters must be populated in order to send to Azure.

    :ivar name: Required. The name of the action for the delivery rule.Constant filled by server.
     Possible values include: "CacheExpiration", "CacheKeyQueryString", "ModifyRequestHeader",
     "ModifyResponseHeader", "UrlRedirect", "UrlRewrite", "UrlSigning", "OriginGroupOverride",
     "RouteConfigurationOverride".
    :vartype name: str or ~azure.mgmt.cdn.models.DeliveryRuleActionEnum
    :ivar parameters: Required. Defines the parameters for the action.
    :vartype parameters: ~azure.mgmt.cdn.models.HeaderActionParameters
    """

    _validation = {
        'name': {'required': True},
        'parameters': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': 'HeaderActionParameters'},
    }

    def __init__(
        self,
        *,
        parameters: "HeaderActionParameters",
        **kwargs
    ):
        """
        :keyword parameters: Required. Defines the parameters for the action.
        :paramtype parameters: ~azure.mgmt.cdn.models.HeaderActionParameters
        """
        super(DeliveryRuleResponseHeaderAction, self).__init__(**kwargs)
        self.name = 'ModifyResponseHeader'  # type: str
        self.parameters = parameters


class DeliveryRuleRouteConfigurationOverrideAction(DeliveryRuleAction):
    """Defines the route configuration override action for the delivery rule. Only applicable to Frontdoor Standard/Premium Profiles.

    All required parameters must be populated in order to send to Azure.

    :ivar name: Required. The name of the action for the delivery rule.Constant filled by server.
     Possible values include: "CacheExpiration", "CacheKeyQueryString", "ModifyRequestHeader",
     "ModifyResponseHeader", "UrlRedirect", "UrlRewrite", "UrlSigning", "OriginGroupOverride",
     "RouteConfigurationOverride".
    :vartype name: str or ~azure.mgmt.cdn.models.DeliveryRuleActionEnum
    :ivar parameters: Required. Defines the parameters for the action.
    :vartype parameters: ~azure.mgmt.cdn.models.RouteConfigurationOverrideActionParameters
    """

    _validation = {
        'name': {'required': True},
        'parameters': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': 'RouteConfigurationOverrideActionParameters'},
    }

    def __init__(
        self,
        *,
        parameters: "RouteConfigurationOverrideActionParameters",
        **kwargs
    ):
        """
        :keyword parameters: Required. Defines the parameters for the action.
        :paramtype parameters: ~azure.mgmt.cdn.models.RouteConfigurationOverrideActionParameters
        """
        super(DeliveryRuleRouteConfigurationOverrideAction, self).__init__(**kwargs)
        self.name = 'RouteConfigurationOverride'  # type: str
        self.parameters = parameters


class DeliveryRuleServerPortCondition(DeliveryRuleCondition):
    """Defines the ServerPort condition for the delivery rule.

    All required parameters must be populated in order to send to Azure.

    :ivar name: Required. The name of the condition for the delivery rule.Constant filled by
     server. Possible values include: "RemoteAddress", "RequestMethod", "QueryString", "PostArgs",
     "RequestUri", "RequestHeader", "RequestBody", "RequestScheme", "UrlPath", "UrlFileExtension",
     "UrlFileName", "HttpVersion", "Cookies", "IsDevice", "SocketAddr", "ClientPort", "ServerPort",
     "HostName", "SslProtocol".
    :vartype name: str or ~azure.mgmt.cdn.models.MatchVariable
    :ivar parameters: Required. Defines the parameters for the condition.
    :vartype parameters: ~azure.mgmt.cdn.models.ServerPortMatchConditionParameters
    """

    _validation = {
        'name': {'required': True},
        'parameters': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': 'ServerPortMatchConditionParameters'},
    }

    def __init__(
        self,
        *,
        parameters: "ServerPortMatchConditionParameters",
        **kwargs
    ):
        """
        :keyword parameters: Required. Defines the parameters for the condition.
        :paramtype parameters: ~azure.mgmt.cdn.models.ServerPortMatchConditionParameters
        """
        super(DeliveryRuleServerPortCondition, self).__init__(**kwargs)
        self.name = 'ServerPort'  # type: str
        self.parameters = parameters


class DeliveryRuleSocketAddrCondition(DeliveryRuleCondition):
    """Defines the SocketAddress condition for the delivery rule.

    All required parameters must be populated in order to send to Azure.

    :ivar name: Required. The name of the condition for the delivery rule.Constant filled by
     server. Possible values include: "RemoteAddress", "RequestMethod", "QueryString", "PostArgs",
     "RequestUri", "RequestHeader", "RequestBody", "RequestScheme", "UrlPath", "UrlFileExtension",
     "UrlFileName", "HttpVersion", "Cookies", "IsDevice", "SocketAddr", "ClientPort", "ServerPort",
     "HostName", "SslProtocol".
    :vartype name: str or ~azure.mgmt.cdn.models.MatchVariable
    :ivar parameters: Required. Defines the parameters for the condition.
    :vartype parameters: ~azure.mgmt.cdn.models.SocketAddrMatchConditionParameters
    """

    _validation = {
        'name': {'required': True},
        'parameters': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': 'SocketAddrMatchConditionParameters'},
    }

    def __init__(
        self,
        *,
        parameters: "SocketAddrMatchConditionParameters",
        **kwargs
    ):
        """
        :keyword parameters: Required. Defines the parameters for the condition.
        :paramtype parameters: ~azure.mgmt.cdn.models.SocketAddrMatchConditionParameters
        """
        super(DeliveryRuleSocketAddrCondition, self).__init__(**kwargs)
        self.name = 'SocketAddr'  # type: str
        self.parameters = parameters


class DeliveryRuleSslProtocolCondition(DeliveryRuleCondition):
    """Defines the SslProtocol condition for the delivery rule.

    All required parameters must be populated in order to send to Azure.

    :ivar name: Required. The name of the condition for the delivery rule.Constant filled by
     server. Possible values include: "RemoteAddress", "RequestMethod", "QueryString", "PostArgs",
     "RequestUri", "RequestHeader", "RequestBody", "RequestScheme", "UrlPath", "UrlFileExtension",
     "UrlFileName", "HttpVersion", "Cookies", "IsDevice", "SocketAddr", "ClientPort", "ServerPort",
     "HostName", "SslProtocol".
    :vartype name: str or ~azure.mgmt.cdn.models.MatchVariable
    :ivar parameters: Required. Defines the parameters for the condition.
    :vartype parameters: ~azure.mgmt.cdn.models.SslProtocolMatchConditionParameters
    """

    _validation = {
        'name': {'required': True},
        'parameters': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': 'SslProtocolMatchConditionParameters'},
    }

    def __init__(
        self,
        *,
        parameters: "SslProtocolMatchConditionParameters",
        **kwargs
    ):
        """
        :keyword parameters: Required. Defines the parameters for the condition.
        :paramtype parameters: ~azure.mgmt.cdn.models.SslProtocolMatchConditionParameters
        """
        super(DeliveryRuleSslProtocolCondition, self).__init__(**kwargs)
        self.name = 'SslProtocol'  # type: str
        self.parameters = parameters


class DeliveryRuleUrlFileExtensionCondition(DeliveryRuleCondition):
    """Defines the UrlFileExtension condition for the delivery rule.

    All required parameters must be populated in order to send to Azure.

    :ivar name: Required. The name of the condition for the delivery rule.Constant filled by
     server. Possible values include: "RemoteAddress", "RequestMethod", "QueryString", "PostArgs",
     "RequestUri", "RequestHeader", "RequestBody", "RequestScheme", "UrlPath", "UrlFileExtension",
     "UrlFileName", "HttpVersion", "Cookies", "IsDevice", "SocketAddr", "ClientPort", "ServerPort",
     "HostName", "SslProtocol".
    :vartype name: str or ~azure.mgmt.cdn.models.MatchVariable
    :ivar parameters: Required. Defines the parameters for the condition.
    :vartype parameters: ~azure.mgmt.cdn.models.UrlFileExtensionMatchConditionParameters
    """

    _validation = {
        'name': {'required': True},
        'parameters': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': 'UrlFileExtensionMatchConditionParameters'},
    }

    def __init__(
        self,
        *,
        parameters: "UrlFileExtensionMatchConditionParameters",
        **kwargs
    ):
        """
        :keyword parameters: Required. Defines the parameters for the condition.
        :paramtype parameters: ~azure.mgmt.cdn.models.UrlFileExtensionMatchConditionParameters
        """
        super(DeliveryRuleUrlFileExtensionCondition, self).__init__(**kwargs)
        self.name = 'UrlFileExtension'  # type: str
        self.parameters = parameters


class DeliveryRuleUrlFileNameCondition(DeliveryRuleCondition):
    """Defines the UrlFileName condition for the delivery rule.

    All required parameters must be populated in order to send to Azure.

    :ivar name: Required. The name of the condition for the delivery rule.Constant filled by
     server. Possible values include: "RemoteAddress", "RequestMethod", "QueryString", "PostArgs",
     "RequestUri", "RequestHeader", "RequestBody", "RequestScheme", "UrlPath", "UrlFileExtension",
     "UrlFileName", "HttpVersion", "Cookies", "IsDevice", "SocketAddr", "ClientPort", "ServerPort",
     "HostName", "SslProtocol".
    :vartype name: str or ~azure.mgmt.cdn.models.MatchVariable
    :ivar parameters: Required. Defines the parameters for the condition.
    :vartype parameters: ~azure.mgmt.cdn.models.UrlFileNameMatchConditionParameters
    """

    _validation = {
        'name': {'required': True},
        'parameters': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': 'UrlFileNameMatchConditionParameters'},
    }

    def __init__(
        self,
        *,
        parameters: "UrlFileNameMatchConditionParameters",
        **kwargs
    ):
        """
        :keyword parameters: Required. Defines the parameters for the condition.
        :paramtype parameters: ~azure.mgmt.cdn.models.UrlFileNameMatchConditionParameters
        """
        super(DeliveryRuleUrlFileNameCondition, self).__init__(**kwargs)
        self.name = 'UrlFileName'  # type: str
        self.parameters = parameters


class DeliveryRuleUrlPathCondition(DeliveryRuleCondition):
    """Defines the UrlPath condition for the delivery rule.

    All required parameters must be populated in order to send to Azure.

    :ivar name: Required. The name of the condition for the delivery rule.Constant filled by
     server. Possible values include: "RemoteAddress", "RequestMethod", "QueryString", "PostArgs",
     "RequestUri", "RequestHeader", "RequestBody", "RequestScheme", "UrlPath", "UrlFileExtension",
     "UrlFileName", "HttpVersion", "Cookies", "IsDevice", "SocketAddr", "ClientPort", "ServerPort",
     "HostName", "SslProtocol".
    :vartype name: str or ~azure.mgmt.cdn.models.MatchVariable
    :ivar parameters: Required. Defines the parameters for the condition.
    :vartype parameters: ~azure.mgmt.cdn.models.UrlPathMatchConditionParameters
    """

    _validation = {
        'name': {'required': True},
        'parameters': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': 'UrlPathMatchConditionParameters'},
    }

    def __init__(
        self,
        *,
        parameters: "UrlPathMatchConditionParameters",
        **kwargs
    ):
        """
        :keyword parameters: Required. Defines the parameters for the condition.
        :paramtype parameters: ~azure.mgmt.cdn.models.UrlPathMatchConditionParameters
        """
        super(DeliveryRuleUrlPathCondition, self).__init__(**kwargs)
        self.name = 'UrlPath'  # type: str
        self.parameters = parameters


class DimensionProperties(msrest.serialization.Model):
    """Type of operation: get, read, delete, etc.

    :ivar name: Name of dimension.
    :vartype name: str
    :ivar display_name: Display name of dimension.
    :vartype display_name: str
    :ivar internal_name: Internal name of dimension.
    :vartype internal_name: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'internal_name': {'key': 'internalName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        display_name: Optional[str] = None,
        internal_name: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword name: Name of dimension.
        :paramtype name: str
        :keyword display_name: Display name of dimension.
        :paramtype display_name: str
        :keyword internal_name: Internal name of dimension.
        :paramtype internal_name: str
        """
        super(DimensionProperties, self).__init__(**kwargs)
        self.name = name
        self.display_name = display_name
        self.internal_name = internal_name


class DomainValidationProperties(msrest.serialization.Model):
    """The JSON object that contains the properties to validate a domain.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar validation_token: Challenge used for DNS TXT record or file based validation.
    :vartype validation_token: str
    :ivar expiration_date: The date time that the token expires.
    :vartype expiration_date: str
    """

    _validation = {
        'validation_token': {'readonly': True},
        'expiration_date': {'readonly': True},
    }

    _attribute_map = {
        'validation_token': {'key': 'validationToken', 'type': 'str'},
        'expiration_date': {'key': 'expirationDate', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(DomainValidationProperties, self).__init__(**kwargs)
        self.validation_token = None
        self.expiration_date = None


class EdgeNode(ProxyResource):
    """Edgenode is a global Point of Presence (POP) location used to deliver CDN content to end users.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar system_data: Read only system data.
    :vartype system_data: ~azure.mgmt.cdn.models.SystemData
    :ivar ip_address_groups: List of ip address groups.
    :vartype ip_address_groups: list[~azure.mgmt.cdn.models.IpAddressGroup]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'ip_address_groups': {'key': 'properties.ipAddressGroups', 'type': '[IpAddressGroup]'},
    }

    def __init__(
        self,
        *,
        ip_address_groups: Optional[List["IpAddressGroup"]] = None,
        **kwargs
    ):
        """
        :keyword ip_address_groups: List of ip address groups.
        :paramtype ip_address_groups: list[~azure.mgmt.cdn.models.IpAddressGroup]
        """
        super(EdgeNode, self).__init__(**kwargs)
        self.ip_address_groups = ip_address_groups


class EdgenodeResult(msrest.serialization.Model):
    """Result of the request to list CDN edgenodes. It contains a list of ip address group and a URL link to get the next set of results.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Edge node of CDN service.
    :vartype value: list[~azure.mgmt.cdn.models.EdgeNode]
    :ivar next_link: URL to get the next set of edgenode list results if there are any.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[EdgeNode]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        next_link: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword next_link: URL to get the next set of edgenode list results if there are any.
        :paramtype next_link: str
        """
        super(EdgenodeResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = next_link


class Endpoint(TrackedResource):
    """CDN endpoint is the entity within a CDN profile containing configuration information such as origin, protocol, content caching and delivery behavior. The CDN endpoint uses the URL format :code:`<endpointname>`.azureedge.net.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar system_data: Read only system data.
    :vartype system_data: ~azure.mgmt.cdn.models.SystemData
    :ivar location: Required. Resource location.
    :vartype location: str
    :ivar tags: A set of tags. Resource tags.
    :vartype tags: dict[str, str]
    :ivar origin_path: A directory path on the origin that CDN can use to retrieve content from,
     e.g. contoso.cloudapp.net/originpath.
    :vartype origin_path: str
    :ivar content_types_to_compress: List of content types on which compression applies. The value
     should be a valid MIME type.
    :vartype content_types_to_compress: list[str]
    :ivar origin_host_header: The host header value sent to the origin with each request. This
     property at Endpoint is only allowed when endpoint uses single origin and can be overridden by
     the same property specified at origin.If you leave this blank, the request hostname determines
     this value. Azure CDN origins, such as Web Apps, Blob Storage, and Cloud Services require this
     host header value to match the origin hostname by default.
    :vartype origin_host_header: str
    :ivar is_compression_enabled: Indicates whether content compression is enabled on CDN. Default
     value is false. If compression is enabled, content will be served as compressed if user
     requests for a compressed version. Content won't be compressed on CDN when requested content is
     smaller than 1 byte or larger than 1 MB.
    :vartype is_compression_enabled: bool
    :ivar is_http_allowed: Indicates whether HTTP traffic is allowed on the endpoint. Default value
     is true. At least one protocol (HTTP or HTTPS) must be allowed.
    :vartype is_http_allowed: bool
    :ivar is_https_allowed: Indicates whether HTTPS traffic is allowed on the endpoint. Default
     value is true. At least one protocol (HTTP or HTTPS) must be allowed.
    :vartype is_https_allowed: bool
    :ivar query_string_caching_behavior: Defines how CDN caches requests that include query
     strings. You can ignore any query strings when caching, bypass caching to prevent requests that
     contain query strings from being cached, or cache every request with a unique URL. Possible
     values include: "IgnoreQueryString", "BypassCaching", "UseQueryString", "NotSet".
    :vartype query_string_caching_behavior: str or
     ~azure.mgmt.cdn.models.QueryStringCachingBehavior
    :ivar optimization_type: Specifies what scenario the customer wants this CDN endpoint to
     optimize for, e.g. Download, Media services. With this information, CDN can apply scenario
     driven optimization. Possible values include: "GeneralWebDelivery", "GeneralMediaStreaming",
     "VideoOnDemandMediaStreaming", "LargeFileDownload", "DynamicSiteAcceleration".
    :vartype optimization_type: str or ~azure.mgmt.cdn.models.OptimizationType
    :ivar probe_path: Path to a file hosted on the origin which helps accelerate delivery of the
     dynamic content and calculate the most optimal routes for the CDN. This is relative to the
     origin path. This property is only relevant when using a single origin.
    :vartype probe_path: str
    :ivar geo_filters: List of rules defining the user's geo access within a CDN endpoint. Each geo
     filter defines an access rule to a specified path or content, e.g. block APAC for path
     /pictures/.
    :vartype geo_filters: list[~azure.mgmt.cdn.models.GeoFilter]
    :ivar default_origin_group: A reference to the origin group.
    :vartype default_origin_group: ~azure.mgmt.cdn.models.ResourceReference
    :ivar url_signing_keys: List of keys used to validate the signed URL hashes.
    :vartype url_signing_keys: list[~azure.mgmt.cdn.models.UrlSigningKey]
    :ivar delivery_policy: A policy that specifies the delivery rules to be used for an endpoint.
    :vartype delivery_policy:
     ~azure.mgmt.cdn.models.EndpointPropertiesUpdateParametersDeliveryPolicy
    :ivar web_application_firewall_policy_link: Defines the Web Application Firewall policy for the
     endpoint (if applicable).
    :vartype web_application_firewall_policy_link:
     ~azure.mgmt.cdn.models.EndpointPropertiesUpdateParametersWebApplicationFirewallPolicyLink
    :ivar host_name: The host name of the endpoint structured as {endpointName}.{DNSZone}, e.g.
     contoso.azureedge.net.
    :vartype host_name: str
    :ivar origins: The source of the content being delivered via CDN.
    :vartype origins: list[~azure.mgmt.cdn.models.DeepCreatedOrigin]
    :ivar origin_groups: The origin groups comprising of origins that are used for load balancing
     the traffic based on availability.
    :vartype origin_groups: list[~azure.mgmt.cdn.models.DeepCreatedOriginGroup]
    :ivar custom_domains: The custom domains under the endpoint.
    :vartype custom_domains: list[~azure.mgmt.cdn.models.CustomDomain]
    :ivar resource_state: Resource status of the endpoint. Possible values include: "Creating",
     "Deleting", "Running", "Starting", "Stopped", "Stopping".
    :vartype resource_state: str or ~azure.mgmt.cdn.models.EndpointResourceState
    :ivar provisioning_state: Provisioning status of the endpoint.
    :vartype provisioning_state: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'location': {'required': True},
        'host_name': {'readonly': True},
        'custom_domains': {'readonly': True},
        'resource_state': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'origin_path': {'key': 'properties.originPath', 'type': 'str'},
        'content_types_to_compress': {'key': 'properties.contentTypesToCompress', 'type': '[str]'},
        'origin_host_header': {'key': 'properties.originHostHeader', 'type': 'str'},
        'is_compression_enabled': {'key': 'properties.isCompressionEnabled', 'type': 'bool'},
        'is_http_allowed': {'key': 'properties.isHttpAllowed', 'type': 'bool'},
        'is_https_allowed': {'key': 'properties.isHttpsAllowed', 'type': 'bool'},
        'query_string_caching_behavior': {'key': 'properties.queryStringCachingBehavior', 'type': 'str'},
        'optimization_type': {'key': 'properties.optimizationType', 'type': 'str'},
        'probe_path': {'key': 'properties.probePath', 'type': 'str'},
        'geo_filters': {'key': 'properties.geoFilters', 'type': '[GeoFilter]'},
        'default_origin_group': {'key': 'properties.defaultOriginGroup', 'type': 'ResourceReference'},
        'url_signing_keys': {'key': 'properties.urlSigningKeys', 'type': '[UrlSigningKey]'},
        'delivery_policy': {'key': 'properties.deliveryPolicy', 'type': 'EndpointPropertiesUpdateParametersDeliveryPolicy'},
        'web_application_firewall_policy_link': {'key': 'properties.webApplicationFirewallPolicyLink', 'type': 'EndpointPropertiesUpdateParametersWebApplicationFirewallPolicyLink'},
        'host_name': {'key': 'properties.hostName', 'type': 'str'},
        'origins': {'key': 'properties.origins', 'type': '[DeepCreatedOrigin]'},
        'origin_groups': {'key': 'properties.originGroups', 'type': '[DeepCreatedOriginGroup]'},
        'custom_domains': {'key': 'properties.customDomains', 'type': '[CustomDomain]'},
        'resource_state': {'key': 'properties.resourceState', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        origin_path: Optional[str] = None,
        content_types_to_compress: Optional[List[str]] = None,
        origin_host_header: Optional[str] = None,
        is_compression_enabled: Optional[bool] = None,
        is_http_allowed: Optional[bool] = None,
        is_https_allowed: Optional[bool] = None,
        query_string_caching_behavior: Optional[Union[str, "QueryStringCachingBehavior"]] = None,
        optimization_type: Optional[Union[str, "OptimizationType"]] = None,
        probe_path: Optional[str] = None,
        geo_filters: Optional[List["GeoFilter"]] = None,
        default_origin_group: Optional["ResourceReference"] = None,
        url_signing_keys: Optional[List["UrlSigningKey"]] = None,
        delivery_policy: Optional["EndpointPropertiesUpdateParametersDeliveryPolicy"] = None,
        web_application_firewall_policy_link: Optional["EndpointPropertiesUpdateParametersWebApplicationFirewallPolicyLink"] = None,
        origins: Optional[List["DeepCreatedOrigin"]] = None,
        origin_groups: Optional[List["DeepCreatedOriginGroup"]] = None,
        **kwargs
    ):
        """
        :keyword location: Required. Resource location.
        :paramtype location: str
        :keyword tags: A set of tags. Resource tags.
        :paramtype tags: dict[str, str]
        :keyword origin_path: A directory path on the origin that CDN can use to retrieve content from,
         e.g. contoso.cloudapp.net/originpath.
        :paramtype origin_path: str
        :keyword content_types_to_compress: List of content types on which compression applies. The
         value should be a valid MIME type.
        :paramtype content_types_to_compress: list[str]
        :keyword origin_host_header: The host header value sent to the origin with each request. This
         property at Endpoint is only allowed when endpoint uses single origin and can be overridden by
         the same property specified at origin.If you leave this blank, the request hostname determines
         this value. Azure CDN origins, such as Web Apps, Blob Storage, and Cloud Services require this
         host header value to match the origin hostname by default.
        :paramtype origin_host_header: str
        :keyword is_compression_enabled: Indicates whether content compression is enabled on CDN.
         Default value is false. If compression is enabled, content will be served as compressed if user
         requests for a compressed version. Content won't be compressed on CDN when requested content is
         smaller than 1 byte or larger than 1 MB.
        :paramtype is_compression_enabled: bool
        :keyword is_http_allowed: Indicates whether HTTP traffic is allowed on the endpoint. Default
         value is true. At least one protocol (HTTP or HTTPS) must be allowed.
        :paramtype is_http_allowed: bool
        :keyword is_https_allowed: Indicates whether HTTPS traffic is allowed on the endpoint. Default
         value is true. At least one protocol (HTTP or HTTPS) must be allowed.
        :paramtype is_https_allowed: bool
        :keyword query_string_caching_behavior: Defines how CDN caches requests that include query
         strings. You can ignore any query strings when caching, bypass caching to prevent requests that
         contain query strings from being cached, or cache every request with a unique URL. Possible
         values include: "IgnoreQueryString", "BypassCaching", "UseQueryString", "NotSet".
        :paramtype query_string_caching_behavior: str or
         ~azure.mgmt.cdn.models.QueryStringCachingBehavior
        :keyword optimization_type: Specifies what scenario the customer wants this CDN endpoint to
         optimize for, e.g. Download, Media services. With this information, CDN can apply scenario
         driven optimization. Possible values include: "GeneralWebDelivery", "GeneralMediaStreaming",
         "VideoOnDemandMediaStreaming", "LargeFileDownload", "DynamicSiteAcceleration".
        :paramtype optimization_type: str or ~azure.mgmt.cdn.models.OptimizationType
        :keyword probe_path: Path to a file hosted on the origin which helps accelerate delivery of the
         dynamic content and calculate the most optimal routes for the CDN. This is relative to the
         origin path. This property is only relevant when using a single origin.
        :paramtype probe_path: str
        :keyword geo_filters: List of rules defining the user's geo access within a CDN endpoint. Each
         geo filter defines an access rule to a specified path or content, e.g. block APAC for path
         /pictures/.
        :paramtype geo_filters: list[~azure.mgmt.cdn.models.GeoFilter]
        :keyword default_origin_group: A reference to the origin group.
        :paramtype default_origin_group: ~azure.mgmt.cdn.models.ResourceReference
        :keyword url_signing_keys: List of keys used to validate the signed URL hashes.
        :paramtype url_signing_keys: list[~azure.mgmt.cdn.models.UrlSigningKey]
        :keyword delivery_policy: A policy that specifies the delivery rules to be used for an
         endpoint.
        :paramtype delivery_policy:
         ~azure.mgmt.cdn.models.EndpointPropertiesUpdateParametersDeliveryPolicy
        :keyword web_application_firewall_policy_link: Defines the Web Application Firewall policy for
         the endpoint (if applicable).
        :paramtype web_application_firewall_policy_link:
         ~azure.mgmt.cdn.models.EndpointPropertiesUpdateParametersWebApplicationFirewallPolicyLink
        :keyword origins: The source of the content being delivered via CDN.
        :paramtype origins: list[~azure.mgmt.cdn.models.DeepCreatedOrigin]
        :keyword origin_groups: The origin groups comprising of origins that are used for load
         balancing the traffic based on availability.
        :paramtype origin_groups: list[~azure.mgmt.cdn.models.DeepCreatedOriginGroup]
        """
        super(Endpoint, self).__init__(location=location, tags=tags, **kwargs)
        self.origin_path = origin_path
        self.content_types_to_compress = content_types_to_compress
        self.origin_host_header = origin_host_header
        self.is_compression_enabled = is_compression_enabled
        self.is_http_allowed = is_http_allowed
        self.is_https_allowed = is_https_allowed
        self.query_string_caching_behavior = query_string_caching_behavior
        self.optimization_type = optimization_type
        self.probe_path = probe_path
        self.geo_filters = geo_filters
        self.default_origin_group = default_origin_group
        self.url_signing_keys = url_signing_keys
        self.delivery_policy = delivery_policy
        self.web_application_firewall_policy_link = web_application_firewall_policy_link
        self.host_name = None
        self.origins = origins
        self.origin_groups = origin_groups
        self.custom_domains = None
        self.resource_state = None
        self.provisioning_state = None


class EndpointListResult(msrest.serialization.Model):
    """Result of the request to list endpoints. It contains a list of endpoint objects and a URL link to get the next set of results.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of CDN endpoints within a profile.
    :vartype value: list[~azure.mgmt.cdn.models.Endpoint]
    :ivar next_link: URL to get the next set of endpoint objects if there is any.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Endpoint]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        next_link: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword next_link: URL to get the next set of endpoint objects if there is any.
        :paramtype next_link: str
        """
        super(EndpointListResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = next_link


class EndpointPropertiesUpdateParameters(msrest.serialization.Model):
    """The JSON object containing endpoint update parameters.

    :ivar origin_path: A directory path on the origin that CDN can use to retrieve content from,
     e.g. contoso.cloudapp.net/originpath.
    :vartype origin_path: str
    :ivar content_types_to_compress: List of content types on which compression applies. The value
     should be a valid MIME type.
    :vartype content_types_to_compress: list[str]
    :ivar origin_host_header: The host header value sent to the origin with each request. This
     property at Endpoint is only allowed when endpoint uses single origin and can be overridden by
     the same property specified at origin.If you leave this blank, the request hostname determines
     this value. Azure CDN origins, such as Web Apps, Blob Storage, and Cloud Services require this
     host header value to match the origin hostname by default.
    :vartype origin_host_header: str
    :ivar is_compression_enabled: Indicates whether content compression is enabled on CDN. Default
     value is false. If compression is enabled, content will be served as compressed if user
     requests for a compressed version. Content won't be compressed on CDN when requested content is
     smaller than 1 byte or larger than 1 MB.
    :vartype is_compression_enabled: bool
    :ivar is_http_allowed: Indicates whether HTTP traffic is allowed on the endpoint. Default value
     is true. At least one protocol (HTTP or HTTPS) must be allowed.
    :vartype is_http_allowed: bool
    :ivar is_https_allowed: Indicates whether HTTPS traffic is allowed on the endpoint. Default
     value is true. At least one protocol (HTTP or HTTPS) must be allowed.
    :vartype is_https_allowed: bool
    :ivar query_string_caching_behavior: Defines how CDN caches requests that include query
     strings. You can ignore any query strings when caching, bypass caching to prevent requests that
     contain query strings from being cached, or cache every request with a unique URL. Possible
     values include: "IgnoreQueryString", "BypassCaching", "UseQueryString", "NotSet".
    :vartype query_string_caching_behavior: str or
     ~azure.mgmt.cdn.models.QueryStringCachingBehavior
    :ivar optimization_type: Specifies what scenario the customer wants this CDN endpoint to
     optimize for, e.g. Download, Media services. With this information, CDN can apply scenario
     driven optimization. Possible values include: "GeneralWebDelivery", "GeneralMediaStreaming",
     "VideoOnDemandMediaStreaming", "LargeFileDownload", "DynamicSiteAcceleration".
    :vartype optimization_type: str or ~azure.mgmt.cdn.models.OptimizationType
    :ivar probe_path: Path to a file hosted on the origin which helps accelerate delivery of the
     dynamic content and calculate the most optimal routes for the CDN. This is relative to the
     origin path. This property is only relevant when using a single origin.
    :vartype probe_path: str
    :ivar geo_filters: List of rules defining the user's geo access within a CDN endpoint. Each geo
     filter defines an access rule to a specified path or content, e.g. block APAC for path
     /pictures/.
    :vartype geo_filters: list[~azure.mgmt.cdn.models.GeoFilter]
    :ivar default_origin_group: A reference to the origin group.
    :vartype default_origin_group: ~azure.mgmt.cdn.models.ResourceReference
    :ivar url_signing_keys: List of keys used to validate the signed URL hashes.
    :vartype url_signing_keys: list[~azure.mgmt.cdn.models.UrlSigningKey]
    :ivar delivery_policy: A policy that specifies the delivery rules to be used for an endpoint.
    :vartype delivery_policy:
     ~azure.mgmt.cdn.models.EndpointPropertiesUpdateParametersDeliveryPolicy
    :ivar web_application_firewall_policy_link: Defines the Web Application Firewall policy for the
     endpoint (if applicable).
    :vartype web_application_firewall_policy_link:
     ~azure.mgmt.cdn.models.EndpointPropertiesUpdateParametersWebApplicationFirewallPolicyLink
    """

    _attribute_map = {
        'origin_path': {'key': 'originPath', 'type': 'str'},
        'content_types_to_compress': {'key': 'contentTypesToCompress', 'type': '[str]'},
        'origin_host_header': {'key': 'originHostHeader', 'type': 'str'},
        'is_compression_enabled': {'key': 'isCompressionEnabled', 'type': 'bool'},
        'is_http_allowed': {'key': 'isHttpAllowed', 'type': 'bool'},
        'is_https_allowed': {'key': 'isHttpsAllowed', 'type': 'bool'},
        'query_string_caching_behavior': {'key': 'queryStringCachingBehavior', 'type': 'str'},
        'optimization_type': {'key': 'optimizationType', 'type': 'str'},
        'probe_path': {'key': 'probePath', 'type': 'str'},
        'geo_filters': {'key': 'geoFilters', 'type': '[GeoFilter]'},
        'default_origin_group': {'key': 'defaultOriginGroup', 'type': 'ResourceReference'},
        'url_signing_keys': {'key': 'urlSigningKeys', 'type': '[UrlSigningKey]'},
        'delivery_policy': {'key': 'deliveryPolicy', 'type': 'EndpointPropertiesUpdateParametersDeliveryPolicy'},
        'web_application_firewall_policy_link': {'key': 'webApplicationFirewallPolicyLink', 'type': 'EndpointPropertiesUpdateParametersWebApplicationFirewallPolicyLink'},
    }

    def __init__(
        self,
        *,
        origin_path: Optional[str] = None,
        content_types_to_compress: Optional[List[str]] = None,
        origin_host_header: Optional[str] = None,
        is_compression_enabled: Optional[bool] = None,
        is_http_allowed: Optional[bool] = None,
        is_https_allowed: Optional[bool] = None,
        query_string_caching_behavior: Optional[Union[str, "QueryStringCachingBehavior"]] = None,
        optimization_type: Optional[Union[str, "OptimizationType"]] = None,
        probe_path: Optional[str] = None,
        geo_filters: Optional[List["GeoFilter"]] = None,
        default_origin_group: Optional["ResourceReference"] = None,
        url_signing_keys: Optional[List["UrlSigningKey"]] = None,
        delivery_policy: Optional["EndpointPropertiesUpdateParametersDeliveryPolicy"] = None,
        web_application_firewall_policy_link: Optional["EndpointPropertiesUpdateParametersWebApplicationFirewallPolicyLink"] = None,
        **kwargs
    ):
        """
        :keyword origin_path: A directory path on the origin that CDN can use to retrieve content from,
         e.g. contoso.cloudapp.net/originpath.
        :paramtype origin_path: str
        :keyword content_types_to_compress: List of content types on which compression applies. The
         value should be a valid MIME type.
        :paramtype content_types_to_compress: list[str]
        :keyword origin_host_header: The host header value sent to the origin with each request. This
         property at Endpoint is only allowed when endpoint uses single origin and can be overridden by
         the same property specified at origin.If you leave this blank, the request hostname determines
         this value. Azure CDN origins, such as Web Apps, Blob Storage, and Cloud Services require this
         host header value to match the origin hostname by default.
        :paramtype origin_host_header: str
        :keyword is_compression_enabled: Indicates whether content compression is enabled on CDN.
         Default value is false. If compression is enabled, content will be served as compressed if user
         requests for a compressed version. Content won't be compressed on CDN when requested content is
         smaller than 1 byte or larger than 1 MB.
        :paramtype is_compression_enabled: bool
        :keyword is_http_allowed: Indicates whether HTTP traffic is allowed on the endpoint. Default
         value is true. At least one protocol (HTTP or HTTPS) must be allowed.
        :paramtype is_http_allowed: bool
        :keyword is_https_allowed: Indicates whether HTTPS traffic is allowed on the endpoint. Default
         value is true. At least one protocol (HTTP or HTTPS) must be allowed.
        :paramtype is_https_allowed: bool
        :keyword query_string_caching_behavior: Defines how CDN caches requests that include query
         strings. You can ignore any query strings when caching, bypass caching to prevent requests that
         contain query strings from being cached, or cache every request with a unique URL. Possible
         values include: "IgnoreQueryString", "BypassCaching", "UseQueryString", "NotSet".
        :paramtype query_string_caching_behavior: str or
         ~azure.mgmt.cdn.models.QueryStringCachingBehavior
        :keyword optimization_type: Specifies what scenario the customer wants this CDN endpoint to
         optimize for, e.g. Download, Media services. With this information, CDN can apply scenario
         driven optimization. Possible values include: "GeneralWebDelivery", "GeneralMediaStreaming",
         "VideoOnDemandMediaStreaming", "LargeFileDownload", "DynamicSiteAcceleration".
        :paramtype optimization_type: str or ~azure.mgmt.cdn.models.OptimizationType
        :keyword probe_path: Path to a file hosted on the origin which helps accelerate delivery of the
         dynamic content and calculate the most optimal routes for the CDN. This is relative to the
         origin path. This property is only relevant when using a single origin.
        :paramtype probe_path: str
        :keyword geo_filters: List of rules defining the user's geo access within a CDN endpoint. Each
         geo filter defines an access rule to a specified path or content, e.g. block APAC for path
         /pictures/.
        :paramtype geo_filters: list[~azure.mgmt.cdn.models.GeoFilter]
        :keyword default_origin_group: A reference to the origin group.
        :paramtype default_origin_group: ~azure.mgmt.cdn.models.ResourceReference
        :keyword url_signing_keys: List of keys used to validate the signed URL hashes.
        :paramtype url_signing_keys: list[~azure.mgmt.cdn.models.UrlSigningKey]
        :keyword delivery_policy: A policy that specifies the delivery rules to be used for an
         endpoint.
        :paramtype delivery_policy:
         ~azure.mgmt.cdn.models.EndpointPropertiesUpdateParametersDeliveryPolicy
        :keyword web_application_firewall_policy_link: Defines the Web Application Firewall policy for
         the endpoint (if applicable).
        :paramtype web_application_firewall_policy_link:
         ~azure.mgmt.cdn.models.EndpointPropertiesUpdateParametersWebApplicationFirewallPolicyLink
        """
        super(EndpointPropertiesUpdateParameters, self).__init__(**kwargs)
        self.origin_path = origin_path
        self.content_types_to_compress = content_types_to_compress
        self.origin_host_header = origin_host_header
        self.is_compression_enabled = is_compression_enabled
        self.is_http_allowed = is_http_allowed
        self.is_https_allowed = is_https_allowed
        self.query_string_caching_behavior = query_string_caching_behavior
        self.optimization_type = optimization_type
        self.probe_path = probe_path
        self.geo_filters = geo_filters
        self.default_origin_group = default_origin_group
        self.url_signing_keys = url_signing_keys
        self.delivery_policy = delivery_policy
        self.web_application_firewall_policy_link = web_application_firewall_policy_link


class EndpointProperties(EndpointPropertiesUpdateParameters):
    """The JSON object that contains the properties required to create an endpoint.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar origin_path: A directory path on the origin that CDN can use to retrieve content from,
     e.g. contoso.cloudapp.net/originpath.
    :vartype origin_path: str
    :ivar content_types_to_compress: List of content types on which compression applies. The value
     should be a valid MIME type.
    :vartype content_types_to_compress: list[str]
    :ivar origin_host_header: The host header value sent to the origin with each request. This
     property at Endpoint is only allowed when endpoint uses single origin and can be overridden by
     the same property specified at origin.If you leave this blank, the request hostname determines
     this value. Azure CDN origins, such as Web Apps, Blob Storage, and Cloud Services require this
     host header value to match the origin hostname by default.
    :vartype origin_host_header: str
    :ivar is_compression_enabled: Indicates whether content compression is enabled on CDN. Default
     value is false. If compression is enabled, content will be served as compressed if user
     requests for a compressed version. Content won't be compressed on CDN when requested content is
     smaller than 1 byte or larger than 1 MB.
    :vartype is_compression_enabled: bool
    :ivar is_http_allowed: Indicates whether HTTP traffic is allowed on the endpoint. Default value
     is true. At least one protocol (HTTP or HTTPS) must be allowed.
    :vartype is_http_allowed: bool
    :ivar is_https_allowed: Indicates whether HTTPS traffic is allowed on the endpoint. Default
     value is true. At least one protocol (HTTP or HTTPS) must be allowed.
    :vartype is_https_allowed: bool
    :ivar query_string_caching_behavior: Defines how CDN caches requests that include query
     strings. You can ignore any query strings when caching, bypass caching to prevent requests that
     contain query strings from being cached, or cache every request with a unique URL. Possible
     values include: "IgnoreQueryString", "BypassCaching", "UseQueryString", "NotSet".
    :vartype query_string_caching_behavior: str or
     ~azure.mgmt.cdn.models.QueryStringCachingBehavior
    :ivar optimization_type: Specifies what scenario the customer wants this CDN endpoint to
     optimize for, e.g. Download, Media services. With this information, CDN can apply scenario
     driven optimization. Possible values include: "GeneralWebDelivery", "GeneralMediaStreaming",
     "VideoOnDemandMediaStreaming", "LargeFileDownload", "DynamicSiteAcceleration".
    :vartype optimization_type: str or ~azure.mgmt.cdn.models.OptimizationType
    :ivar probe_path: Path to a file hosted on the origin which helps accelerate delivery of the
     dynamic content and calculate the most optimal routes for the CDN. This is relative to the
     origin path. This property is only relevant when using a single origin.
    :vartype probe_path: str
    :ivar geo_filters: List of rules defining the user's geo access within a CDN endpoint. Each geo
     filter defines an access rule to a specified path or content, e.g. block APAC for path
     /pictures/.
    :vartype geo_filters: list[~azure.mgmt.cdn.models.GeoFilter]
    :ivar default_origin_group: A reference to the origin group.
    :vartype default_origin_group: ~azure.mgmt.cdn.models.ResourceReference
    :ivar url_signing_keys: List of keys used to validate the signed URL hashes.
    :vartype url_signing_keys: list[~azure.mgmt.cdn.models.UrlSigningKey]
    :ivar delivery_policy: A policy that specifies the delivery rules to be used for an endpoint.
    :vartype delivery_policy:
     ~azure.mgmt.cdn.models.EndpointPropertiesUpdateParametersDeliveryPolicy
    :ivar web_application_firewall_policy_link: Defines the Web Application Firewall policy for the
     endpoint (if applicable).
    :vartype web_application_firewall_policy_link:
     ~azure.mgmt.cdn.models.EndpointPropertiesUpdateParametersWebApplicationFirewallPolicyLink
    :ivar host_name: The host name of the endpoint structured as {endpointName}.{DNSZone}, e.g.
     contoso.azureedge.net.
    :vartype host_name: str
    :ivar origins: Required. The source of the content being delivered via CDN.
    :vartype origins: list[~azure.mgmt.cdn.models.DeepCreatedOrigin]
    :ivar origin_groups: The origin groups comprising of origins that are used for load balancing
     the traffic based on availability.
    :vartype origin_groups: list[~azure.mgmt.cdn.models.DeepCreatedOriginGroup]
    :ivar custom_domains: The custom domains under the endpoint.
    :vartype custom_domains: list[~azure.mgmt.cdn.models.CustomDomain]
    :ivar resource_state: Resource status of the endpoint. Possible values include: "Creating",
     "Deleting", "Running", "Starting", "Stopped", "Stopping".
    :vartype resource_state: str or ~azure.mgmt.cdn.models.EndpointResourceState
    :ivar provisioning_state: Provisioning status of the endpoint.
    :vartype provisioning_state: str
    """

    _validation = {
        'host_name': {'readonly': True},
        'origins': {'required': True},
        'custom_domains': {'readonly': True},
        'resource_state': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'origin_path': {'key': 'originPath', 'type': 'str'},
        'content_types_to_compress': {'key': 'contentTypesToCompress', 'type': '[str]'},
        'origin_host_header': {'key': 'originHostHeader', 'type': 'str'},
        'is_compression_enabled': {'key': 'isCompressionEnabled', 'type': 'bool'},
        'is_http_allowed': {'key': 'isHttpAllowed', 'type': 'bool'},
        'is_https_allowed': {'key': 'isHttpsAllowed', 'type': 'bool'},
        'query_string_caching_behavior': {'key': 'queryStringCachingBehavior', 'type': 'str'},
        'optimization_type': {'key': 'optimizationType', 'type': 'str'},
        'probe_path': {'key': 'probePath', 'type': 'str'},
        'geo_filters': {'key': 'geoFilters', 'type': '[GeoFilter]'},
        'default_origin_group': {'key': 'defaultOriginGroup', 'type': 'ResourceReference'},
        'url_signing_keys': {'key': 'urlSigningKeys', 'type': '[UrlSigningKey]'},
        'delivery_policy': {'key': 'deliveryPolicy', 'type': 'EndpointPropertiesUpdateParametersDeliveryPolicy'},
        'web_application_firewall_policy_link': {'key': 'webApplicationFirewallPolicyLink', 'type': 'EndpointPropertiesUpdateParametersWebApplicationFirewallPolicyLink'},
        'host_name': {'key': 'hostName', 'type': 'str'},
        'origins': {'key': 'origins', 'type': '[DeepCreatedOrigin]'},
        'origin_groups': {'key': 'originGroups', 'type': '[DeepCreatedOriginGroup]'},
        'custom_domains': {'key': 'customDomains', 'type': '[CustomDomain]'},
        'resource_state': {'key': 'resourceState', 'type': 'str'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        origins: List["DeepCreatedOrigin"],
        origin_path: Optional[str] = None,
        content_types_to_compress: Optional[List[str]] = None,
        origin_host_header: Optional[str] = None,
        is_compression_enabled: Optional[bool] = None,
        is_http_allowed: Optional[bool] = None,
        is_https_allowed: Optional[bool] = None,
        query_string_caching_behavior: Optional[Union[str, "QueryStringCachingBehavior"]] = None,
        optimization_type: Optional[Union[str, "OptimizationType"]] = None,
        probe_path: Optional[str] = None,
        geo_filters: Optional[List["GeoFilter"]] = None,
        default_origin_group: Optional["ResourceReference"] = None,
        url_signing_keys: Optional[List["UrlSigningKey"]] = None,
        delivery_policy: Optional["EndpointPropertiesUpdateParametersDeliveryPolicy"] = None,
        web_application_firewall_policy_link: Optional["EndpointPropertiesUpdateParametersWebApplicationFirewallPolicyLink"] = None,
        origin_groups: Optional[List["DeepCreatedOriginGroup"]] = None,
        **kwargs
    ):
        """
        :keyword origin_path: A directory path on the origin that CDN can use to retrieve content from,
         e.g. contoso.cloudapp.net/originpath.
        :paramtype origin_path: str
        :keyword content_types_to_compress: List of content types on which compression applies. The
         value should be a valid MIME type.
        :paramtype content_types_to_compress: list[str]
        :keyword origin_host_header: The host header value sent to the origin with each request. This
         property at Endpoint is only allowed when endpoint uses single origin and can be overridden by
         the same property specified at origin.If you leave this blank, the request hostname determines
         this value. Azure CDN origins, such as Web Apps, Blob Storage, and Cloud Services require this
         host header value to match the origin hostname by default.
        :paramtype origin_host_header: str
        :keyword is_compression_enabled: Indicates whether content compression is enabled on CDN.
         Default value is false. If compression is enabled, content will be served as compressed if user
         requests for a compressed version. Content won't be compressed on CDN when requested content is
         smaller than 1 byte or larger than 1 MB.
        :paramtype is_compression_enabled: bool
        :keyword is_http_allowed: Indicates whether HTTP traffic is allowed on the endpoint. Default
         value is true. At least one protocol (HTTP or HTTPS) must be allowed.
        :paramtype is_http_allowed: bool
        :keyword is_https_allowed: Indicates whether HTTPS traffic is allowed on the endpoint. Default
         value is true. At least one protocol (HTTP or HTTPS) must be allowed.
        :paramtype is_https_allowed: bool
        :keyword query_string_caching_behavior: Defines how CDN caches requests that include query
         strings. You can ignore any query strings when caching, bypass caching to prevent requests that
         contain query strings from being cached, or cache every request with a unique URL. Possible
         values include: "IgnoreQueryString", "BypassCaching", "UseQueryString", "NotSet".
        :paramtype query_string_caching_behavior: str or
         ~azure.mgmt.cdn.models.QueryStringCachingBehavior
        :keyword optimization_type: Specifies what scenario the customer wants this CDN endpoint to
         optimize for, e.g. Download, Media services. With this information, CDN can apply scenario
         driven optimization. Possible values include: "GeneralWebDelivery", "GeneralMediaStreaming",
         "VideoOnDemandMediaStreaming", "LargeFileDownload", "DynamicSiteAcceleration".
        :paramtype optimization_type: str or ~azure.mgmt.cdn.models.OptimizationType
        :keyword probe_path: Path to a file hosted on the origin which helps accelerate delivery of the
         dynamic content and calculate the most optimal routes for the CDN. This is relative to the
         origin path. This property is only relevant when using a single origin.
        :paramtype probe_path: str
        :keyword geo_filters: List of rules defining the user's geo access within a CDN endpoint. Each
         geo filter defines an access rule to a specified path or content, e.g. block APAC for path
         /pictures/.
        :paramtype geo_filters: list[~azure.mgmt.cdn.models.GeoFilter]
        :keyword default_origin_group: A reference to the origin group.
        :paramtype default_origin_group: ~azure.mgmt.cdn.models.ResourceReference
        :keyword url_signing_keys: List of keys used to validate the signed URL hashes.
        :paramtype url_signing_keys: list[~azure.mgmt.cdn.models.UrlSigningKey]
        :keyword delivery_policy: A policy that specifies the delivery rules to be used for an
         endpoint.
        :paramtype delivery_policy:
         ~azure.mgmt.cdn.models.EndpointPropertiesUpdateParametersDeliveryPolicy
        :keyword web_application_firewall_policy_link: Defines the Web Application Firewall policy for
         the endpoint (if applicable).
        :paramtype web_application_firewall_policy_link:
         ~azure.mgmt.cdn.models.EndpointPropertiesUpdateParametersWebApplicationFirewallPolicyLink
        :keyword origins: Required. The source of the content being delivered via CDN.
        :paramtype origins: list[~azure.mgmt.cdn.models.DeepCreatedOrigin]
        :keyword origin_groups: The origin groups comprising of origins that are used for load
         balancing the traffic based on availability.
        :paramtype origin_groups: list[~azure.mgmt.cdn.models.DeepCreatedOriginGroup]
        """
        super(EndpointProperties, self).__init__(origin_path=origin_path, content_types_to_compress=content_types_to_compress, origin_host_header=origin_host_header, is_compression_enabled=is_compression_enabled, is_http_allowed=is_http_allowed, is_https_allowed=is_https_allowed, query_string_caching_behavior=query_string_caching_behavior, optimization_type=optimization_type, probe_path=probe_path, geo_filters=geo_filters, default_origin_group=default_origin_group, url_signing_keys=url_signing_keys, delivery_policy=delivery_policy, web_application_firewall_policy_link=web_application_firewall_policy_link, **kwargs)
        self.host_name = None
        self.origins = origins
        self.origin_groups = origin_groups
        self.custom_domains = None
        self.resource_state = None
        self.provisioning_state = None


class EndpointPropertiesUpdateParametersDeliveryPolicy(msrest.serialization.Model):
    """A policy that specifies the delivery rules to be used for an endpoint.

    All required parameters must be populated in order to send to Azure.

    :ivar description: User-friendly description of the policy.
    :vartype description: str
    :ivar rules: Required. A list of the delivery rules.
    :vartype rules: list[~azure.mgmt.cdn.models.DeliveryRule]
    """

    _validation = {
        'rules': {'required': True},
    }

    _attribute_map = {
        'description': {'key': 'description', 'type': 'str'},
        'rules': {'key': 'rules', 'type': '[DeliveryRule]'},
    }

    def __init__(
        self,
        *,
        rules: List["DeliveryRule"],
        description: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword description: User-friendly description of the policy.
        :paramtype description: str
        :keyword rules: Required. A list of the delivery rules.
        :paramtype rules: list[~azure.mgmt.cdn.models.DeliveryRule]
        """
        super(EndpointPropertiesUpdateParametersDeliveryPolicy, self).__init__(**kwargs)
        self.description = description
        self.rules = rules


class EndpointPropertiesUpdateParametersWebApplicationFirewallPolicyLink(msrest.serialization.Model):
    """Defines the Web Application Firewall policy for the endpoint (if applicable).

    :ivar id: Resource ID.
    :vartype id: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword id: Resource ID.
        :paramtype id: str
        """
        super(EndpointPropertiesUpdateParametersWebApplicationFirewallPolicyLink, self).__init__(**kwargs)
        self.id = id


class EndpointUpdateParameters(msrest.serialization.Model):
    """Properties required to create or update an endpoint.

    :ivar tags: A set of tags. Endpoint tags.
    :vartype tags: dict[str, str]
    :ivar origin_path: A directory path on the origin that CDN can use to retrieve content from,
     e.g. contoso.cloudapp.net/originpath.
    :vartype origin_path: str
    :ivar content_types_to_compress: List of content types on which compression applies. The value
     should be a valid MIME type.
    :vartype content_types_to_compress: list[str]
    :ivar origin_host_header: The host header value sent to the origin with each request. This
     property at Endpoint is only allowed when endpoint uses single origin and can be overridden by
     the same property specified at origin.If you leave this blank, the request hostname determines
     this value. Azure CDN origins, such as Web Apps, Blob Storage, and Cloud Services require this
     host header value to match the origin hostname by default.
    :vartype origin_host_header: str
    :ivar is_compression_enabled: Indicates whether content compression is enabled on CDN. Default
     value is false. If compression is enabled, content will be served as compressed if user
     requests for a compressed version. Content won't be compressed on CDN when requested content is
     smaller than 1 byte or larger than 1 MB.
    :vartype is_compression_enabled: bool
    :ivar is_http_allowed: Indicates whether HTTP traffic is allowed on the endpoint. Default value
     is true. At least one protocol (HTTP or HTTPS) must be allowed.
    :vartype is_http_allowed: bool
    :ivar is_https_allowed: Indicates whether HTTPS traffic is allowed on the endpoint. Default
     value is true. At least one protocol (HTTP or HTTPS) must be allowed.
    :vartype is_https_allowed: bool
    :ivar query_string_caching_behavior: Defines how CDN caches requests that include query
     strings. You can ignore any query strings when caching, bypass caching to prevent requests that
     contain query strings from being cached, or cache every request with a unique URL. Possible
     values include: "IgnoreQueryString", "BypassCaching", "UseQueryString", "NotSet".
    :vartype query_string_caching_behavior: str or
     ~azure.mgmt.cdn.models.QueryStringCachingBehavior
    :ivar optimization_type: Specifies what scenario the customer wants this CDN endpoint to
     optimize for, e.g. Download, Media services. With this information, CDN can apply scenario
     driven optimization. Possible values include: "GeneralWebDelivery", "GeneralMediaStreaming",
     "VideoOnDemandMediaStreaming", "LargeFileDownload", "DynamicSiteAcceleration".
    :vartype optimization_type: str or ~azure.mgmt.cdn.models.OptimizationType
    :ivar probe_path: Path to a file hosted on the origin which helps accelerate delivery of the
     dynamic content and calculate the most optimal routes for the CDN. This is relative to the
     origin path. This property is only relevant when using a single origin.
    :vartype probe_path: str
    :ivar geo_filters: List of rules defining the user's geo access within a CDN endpoint. Each geo
     filter defines an access rule to a specified path or content, e.g. block APAC for path
     /pictures/.
    :vartype geo_filters: list[~azure.mgmt.cdn.models.GeoFilter]
    :ivar default_origin_group: A reference to the origin group.
    :vartype default_origin_group: ~azure.mgmt.cdn.models.ResourceReference
    :ivar url_signing_keys: List of keys used to validate the signed URL hashes.
    :vartype url_signing_keys: list[~azure.mgmt.cdn.models.UrlSigningKey]
    :ivar delivery_policy: A policy that specifies the delivery rules to be used for an endpoint.
    :vartype delivery_policy:
     ~azure.mgmt.cdn.models.EndpointPropertiesUpdateParametersDeliveryPolicy
    :ivar web_application_firewall_policy_link: Defines the Web Application Firewall policy for the
     endpoint (if applicable).
    :vartype web_application_firewall_policy_link:
     ~azure.mgmt.cdn.models.EndpointPropertiesUpdateParametersWebApplicationFirewallPolicyLink
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
        'origin_path': {'key': 'properties.originPath', 'type': 'str'},
        'content_types_to_compress': {'key': 'properties.contentTypesToCompress', 'type': '[str]'},
        'origin_host_header': {'key': 'properties.originHostHeader', 'type': 'str'},
        'is_compression_enabled': {'key': 'properties.isCompressionEnabled', 'type': 'bool'},
        'is_http_allowed': {'key': 'properties.isHttpAllowed', 'type': 'bool'},
        'is_https_allowed': {'key': 'properties.isHttpsAllowed', 'type': 'bool'},
        'query_string_caching_behavior': {'key': 'properties.queryStringCachingBehavior', 'type': 'str'},
        'optimization_type': {'key': 'properties.optimizationType', 'type': 'str'},
        'probe_path': {'key': 'properties.probePath', 'type': 'str'},
        'geo_filters': {'key': 'properties.geoFilters', 'type': '[GeoFilter]'},
        'default_origin_group': {'key': 'properties.defaultOriginGroup', 'type': 'ResourceReference'},
        'url_signing_keys': {'key': 'properties.urlSigningKeys', 'type': '[UrlSigningKey]'},
        'delivery_policy': {'key': 'properties.deliveryPolicy', 'type': 'EndpointPropertiesUpdateParametersDeliveryPolicy'},
        'web_application_firewall_policy_link': {'key': 'properties.webApplicationFirewallPolicyLink', 'type': 'EndpointPropertiesUpdateParametersWebApplicationFirewallPolicyLink'},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        origin_path: Optional[str] = None,
        content_types_to_compress: Optional[List[str]] = None,
        origin_host_header: Optional[str] = None,
        is_compression_enabled: Optional[bool] = None,
        is_http_allowed: Optional[bool] = None,
        is_https_allowed: Optional[bool] = None,
        query_string_caching_behavior: Optional[Union[str, "QueryStringCachingBehavior"]] = None,
        optimization_type: Optional[Union[str, "OptimizationType"]] = None,
        probe_path: Optional[str] = None,
        geo_filters: Optional[List["GeoFilter"]] = None,
        default_origin_group: Optional["ResourceReference"] = None,
        url_signing_keys: Optional[List["UrlSigningKey"]] = None,
        delivery_policy: Optional["EndpointPropertiesUpdateParametersDeliveryPolicy"] = None,
        web_application_firewall_policy_link: Optional["EndpointPropertiesUpdateParametersWebApplicationFirewallPolicyLink"] = None,
        **kwargs
    ):
        """
        :keyword tags: A set of tags. Endpoint tags.
        :paramtype tags: dict[str, str]
        :keyword origin_path: A directory path on the origin that CDN can use to retrieve content from,
         e.g. contoso.cloudapp.net/originpath.
        :paramtype origin_path: str
        :keyword content_types_to_compress: List of content types on which compression applies. The
         value should be a valid MIME type.
        :paramtype content_types_to_compress: list[str]
        :keyword origin_host_header: The host header value sent to the origin with each request. This
         property at Endpoint is only allowed when endpoint uses single origin and can be overridden by
         the same property specified at origin.If you leave this blank, the request hostname determines
         this value. Azure CDN origins, such as Web Apps, Blob Storage, and Cloud Services require this
         host header value to match the origin hostname by default.
        :paramtype origin_host_header: str
        :keyword is_compression_enabled: Indicates whether content compression is enabled on CDN.
         Default value is false. If compression is enabled, content will be served as compressed if user
         requests for a compressed version. Content won't be compressed on CDN when requested content is
         smaller than 1 byte or larger than 1 MB.
        :paramtype is_compression_enabled: bool
        :keyword is_http_allowed: Indicates whether HTTP traffic is allowed on the endpoint. Default
         value is true. At least one protocol (HTTP or HTTPS) must be allowed.
        :paramtype is_http_allowed: bool
        :keyword is_https_allowed: Indicates whether HTTPS traffic is allowed on the endpoint. Default
         value is true. At least one protocol (HTTP or HTTPS) must be allowed.
        :paramtype is_https_allowed: bool
        :keyword query_string_caching_behavior: Defines how CDN caches requests that include query
         strings. You can ignore any query strings when caching, bypass caching to prevent requests that
         contain query strings from being cached, or cache every request with a unique URL. Possible
         values include: "IgnoreQueryString", "BypassCaching", "UseQueryString", "NotSet".
        :paramtype query_string_caching_behavior: str or
         ~azure.mgmt.cdn.models.QueryStringCachingBehavior
        :keyword optimization_type: Specifies what scenario the customer wants this CDN endpoint to
         optimize for, e.g. Download, Media services. With this information, CDN can apply scenario
         driven optimization. Possible values include: "GeneralWebDelivery", "GeneralMediaStreaming",
         "VideoOnDemandMediaStreaming", "LargeFileDownload", "DynamicSiteAcceleration".
        :paramtype optimization_type: str or ~azure.mgmt.cdn.models.OptimizationType
        :keyword probe_path: Path to a file hosted on the origin which helps accelerate delivery of the
         dynamic content and calculate the most optimal routes for the CDN. This is relative to the
         origin path. This property is only relevant when using a single origin.
        :paramtype probe_path: str
        :keyword geo_filters: List of rules defining the user's geo access within a CDN endpoint. Each
         geo filter defines an access rule to a specified path or content, e.g. block APAC for path
         /pictures/.
        :paramtype geo_filters: list[~azure.mgmt.cdn.models.GeoFilter]
        :keyword default_origin_group: A reference to the origin group.
        :paramtype default_origin_group: ~azure.mgmt.cdn.models.ResourceReference
        :keyword url_signing_keys: List of keys used to validate the signed URL hashes.
        :paramtype url_signing_keys: list[~azure.mgmt.cdn.models.UrlSigningKey]
        :keyword delivery_policy: A policy that specifies the delivery rules to be used for an
         endpoint.
        :paramtype delivery_policy:
         ~azure.mgmt.cdn.models.EndpointPropertiesUpdateParametersDeliveryPolicy
        :keyword web_application_firewall_policy_link: Defines the Web Application Firewall policy for
         the endpoint (if applicable).
        :paramtype web_application_firewall_policy_link:
         ~azure.mgmt.cdn.models.EndpointPropertiesUpdateParametersWebApplicationFirewallPolicyLink
        """
        super(EndpointUpdateParameters, self).__init__(**kwargs)
        self.tags = tags
        self.origin_path = origin_path
        self.content_types_to_compress = content_types_to_compress
        self.origin_host_header = origin_host_header
        self.is_compression_enabled = is_compression_enabled
        self.is_http_allowed = is_http_allowed
        self.is_https_allowed = is_https_allowed
        self.query_string_caching_behavior = query_string_caching_behavior
        self.optimization_type = optimization_type
        self.probe_path = probe_path
        self.geo_filters = geo_filters
        self.default_origin_group = default_origin_group
        self.url_signing_keys = url_signing_keys
        self.delivery_policy = delivery_policy
        self.web_application_firewall_policy_link = web_application_firewall_policy_link


class ErrorAdditionalInfo(msrest.serialization.Model):
    """The resource management error additional info.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: The additional info type.
    :vartype type: str
    :ivar info: The additional info.
    :vartype info: any
    """

    _validation = {
        'type': {'readonly': True},
        'info': {'readonly': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'info': {'key': 'info', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(ErrorAdditionalInfo, self).__init__(**kwargs)
        self.type = None
        self.info = None


class ErrorDetail(msrest.serialization.Model):
    """The error detail.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar details: The error details.
    :vartype details: list[~azure.mgmt.cdn.models.ErrorDetail]
    :ivar additional_info: The error additional info.
    :vartype additional_info: list[~azure.mgmt.cdn.models.ErrorAdditionalInfo]
    """

    _validation = {
        'code': {'readonly': True},
        'message': {'readonly': True},
        'target': {'readonly': True},
        'details': {'readonly': True},
        'additional_info': {'readonly': True},
    }

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'target': {'key': 'target', 'type': 'str'},
        'details': {'key': 'details', 'type': '[ErrorDetail]'},
        'additional_info': {'key': 'additionalInfo', 'type': '[ErrorAdditionalInfo]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(ErrorDetail, self).__init__(**kwargs)
        self.code = None
        self.message = None
        self.target = None
        self.details = None
        self.additional_info = None


class ErrorResponse(msrest.serialization.Model):
    """Error response indicates Azure Front Door Standard or Azure Front Door Premium or CDN service is not able to process the incoming request. The reason is provided in the error message.

    :ivar error: The error object.
    :vartype error: ~azure.mgmt.cdn.models.ErrorDetail
    """

    _attribute_map = {
        'error': {'key': 'error', 'type': 'ErrorDetail'},
    }

    def __init__(
        self,
        *,
        error: Optional["ErrorDetail"] = None,
        **kwargs
    ):
        """
        :keyword error: The error object.
        :paramtype error: ~azure.mgmt.cdn.models.ErrorDetail
        """
        super(ErrorResponse, self).__init__(**kwargs)
        self.error = error


class GeoFilter(msrest.serialization.Model):
    """Rules defining user's geo access within a CDN endpoint.

    All required parameters must be populated in order to send to Azure.

    :ivar relative_path: Required. Relative path applicable to geo filter. (e.g. '/mypictures',
     '/mypicture/kitty.jpg', and etc.).
    :vartype relative_path: str
    :ivar action: Required. Action of the geo filter, i.e. allow or block access. Possible values
     include: "Block", "Allow".
    :vartype action: str or ~azure.mgmt.cdn.models.GeoFilterActions
    :ivar country_codes: Required. Two letter country or region codes defining user country or
     region access in a geo filter, e.g. AU, MX, US.
    :vartype country_codes: list[str]
    """

    _validation = {
        'relative_path': {'required': True},
        'action': {'required': True},
        'country_codes': {'required': True},
    }

    _attribute_map = {
        'relative_path': {'key': 'relativePath', 'type': 'str'},
        'action': {'key': 'action', 'type': 'str'},
        'country_codes': {'key': 'countryCodes', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        relative_path: str,
        action: Union[str, "GeoFilterActions"],
        country_codes: List[str],
        **kwargs
    ):
        """
        :keyword relative_path: Required. Relative path applicable to geo filter. (e.g. '/mypictures',
         '/mypicture/kitty.jpg', and etc.).
        :paramtype relative_path: str
        :keyword action: Required. Action of the geo filter, i.e. allow or block access. Possible
         values include: "Block", "Allow".
        :paramtype action: str or ~azure.mgmt.cdn.models.GeoFilterActions
        :keyword country_codes: Required. Two letter country or region codes defining user country or
         region access in a geo filter, e.g. AU, MX, US.
        :paramtype country_codes: list[str]
        """
        super(GeoFilter, self).__init__(**kwargs)
        self.relative_path = relative_path
        self.action = action
        self.country_codes = country_codes


class HeaderActionParameters(msrest.serialization.Model):
    """Defines the parameters for the request header action.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar type_name:  Has constant value: "DeliveryRuleHeaderActionParameters".
    :vartype type_name: str
    :ivar header_action: Required. Action to perform. Possible values include: "Append",
     "Overwrite", "Delete".
    :vartype header_action: str or ~azure.mgmt.cdn.models.HeaderAction
    :ivar header_name: Required. Name of the header to modify.
    :vartype header_name: str
    :ivar value: Value for the specified action.
    :vartype value: str
    """

    _validation = {
        'type_name': {'required': True, 'constant': True},
        'header_action': {'required': True},
        'header_name': {'required': True},
    }

    _attribute_map = {
        'type_name': {'key': 'typeName', 'type': 'str'},
        'header_action': {'key': 'headerAction', 'type': 'str'},
        'header_name': {'key': 'headerName', 'type': 'str'},
        'value': {'key': 'value', 'type': 'str'},
    }

    type_name = "DeliveryRuleHeaderActionParameters"

    def __init__(
        self,
        *,
        header_action: Union[str, "HeaderAction"],
        header_name: str,
        value: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword header_action: Required. Action to perform. Possible values include: "Append",
         "Overwrite", "Delete".
        :paramtype header_action: str or ~azure.mgmt.cdn.models.HeaderAction
        :keyword header_name: Required. Name of the header to modify.
        :paramtype header_name: str
        :keyword value: Value for the specified action.
        :paramtype value: str
        """
        super(HeaderActionParameters, self).__init__(**kwargs)
        self.header_action = header_action
        self.header_name = header_name
        self.value = value


class HealthProbeParameters(msrest.serialization.Model):
    """The JSON object that contains the properties to send health probes to origin.

    :ivar probe_path: The path relative to the origin that is used to determine the health of the
     origin.
    :vartype probe_path: str
    :ivar probe_request_type: The type of health probe request that is made. Possible values
     include: "NotSet", "GET", "HEAD".
    :vartype probe_request_type: str or ~azure.mgmt.cdn.models.HealthProbeRequestType
    :ivar probe_protocol: Protocol to use for health probe. Possible values include: "NotSet",
     "Http", "Https".
    :vartype probe_protocol: str or ~azure.mgmt.cdn.models.ProbeProtocol
    :ivar probe_interval_in_seconds: The number of seconds between health probes.Default is 240sec.
    :vartype probe_interval_in_seconds: int
    """

    _validation = {
        'probe_interval_in_seconds': {'maximum': 255, 'minimum': 1},
    }

    _attribute_map = {
        'probe_path': {'key': 'probePath', 'type': 'str'},
        'probe_request_type': {'key': 'probeRequestType', 'type': 'str'},
        'probe_protocol': {'key': 'probeProtocol', 'type': 'str'},
        'probe_interval_in_seconds': {'key': 'probeIntervalInSeconds', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        probe_path: Optional[str] = None,
        probe_request_type: Optional[Union[str, "HealthProbeRequestType"]] = None,
        probe_protocol: Optional[Union[str, "ProbeProtocol"]] = None,
        probe_interval_in_seconds: Optional[int] = None,
        **kwargs
    ):
        """
        :keyword probe_path: The path relative to the origin that is used to determine the health of
         the origin.
        :paramtype probe_path: str
        :keyword probe_request_type: The type of health probe request that is made. Possible values
         include: "NotSet", "GET", "HEAD".
        :paramtype probe_request_type: str or ~azure.mgmt.cdn.models.HealthProbeRequestType
        :keyword probe_protocol: Protocol to use for health probe. Possible values include: "NotSet",
         "Http", "Https".
        :paramtype probe_protocol: str or ~azure.mgmt.cdn.models.ProbeProtocol
        :keyword probe_interval_in_seconds: The number of seconds between health probes.Default is
         240sec.
        :paramtype probe_interval_in_seconds: int
        """
        super(HealthProbeParameters, self).__init__(**kwargs)
        self.probe_path = probe_path
        self.probe_request_type = probe_request_type
        self.probe_protocol = probe_protocol
        self.probe_interval_in_seconds = probe_interval_in_seconds


class HostNameMatchConditionParameters(msrest.serialization.Model):
    """Defines the parameters for HostName match conditions.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar type_name:  Has constant value: "DeliveryRuleHostNameConditionParameters".
    :vartype type_name: str
    :ivar operator: Required. Describes operator to be matched. Possible values include: "Any",
     "Equal", "Contains", "BeginsWith", "EndsWith", "LessThan", "LessThanOrEqual", "GreaterThan",
     "GreaterThanOrEqual", "RegEx".
    :vartype operator: str or ~azure.mgmt.cdn.models.HostNameOperator
    :ivar negate_condition: Describes if this is negate condition or not.
    :vartype negate_condition: bool
    :ivar match_values: The match value for the condition of the delivery rule.
    :vartype match_values: list[str]
    :ivar transforms: List of transforms.
    :vartype transforms: list[str or ~azure.mgmt.cdn.models.Transform]
    """

    _validation = {
        'type_name': {'required': True, 'constant': True},
        'operator': {'required': True},
    }

    _attribute_map = {
        'type_name': {'key': 'typeName', 'type': 'str'},
        'operator': {'key': 'operator', 'type': 'str'},
        'negate_condition': {'key': 'negateCondition', 'type': 'bool'},
        'match_values': {'key': 'matchValues', 'type': '[str]'},
        'transforms': {'key': 'transforms', 'type': '[str]'},
    }

    type_name = "DeliveryRuleHostNameConditionParameters"

    def __init__(
        self,
        *,
        operator: Union[str, "HostNameOperator"],
        negate_condition: Optional[bool] = None,
        match_values: Optional[List[str]] = None,
        transforms: Optional[List[Union[str, "Transform"]]] = None,
        **kwargs
    ):
        """
        :keyword operator: Required. Describes operator to be matched. Possible values include: "Any",
         "Equal", "Contains", "BeginsWith", "EndsWith", "LessThan", "LessThanOrEqual", "GreaterThan",
         "GreaterThanOrEqual", "RegEx".
        :paramtype operator: str or ~azure.mgmt.cdn.models.HostNameOperator
        :keyword negate_condition: Describes if this is negate condition or not.
        :paramtype negate_condition: bool
        :keyword match_values: The match value for the condition of the delivery rule.
        :paramtype match_values: list[str]
        :keyword transforms: List of transforms.
        :paramtype transforms: list[str or ~azure.mgmt.cdn.models.Transform]
        """
        super(HostNameMatchConditionParameters, self).__init__(**kwargs)
        self.operator = operator
        self.negate_condition = negate_condition
        self.match_values = match_values
        self.transforms = transforms


class HttpErrorRangeParameters(msrest.serialization.Model):
    """The JSON object that represents the range for http status codes.

    :ivar begin: The inclusive start of the http status code range.
    :vartype begin: int
    :ivar end: The inclusive end of the http status code range.
    :vartype end: int
    """

    _validation = {
        'begin': {'maximum': 999, 'minimum': 100},
        'end': {'maximum': 999, 'minimum': 100},
    }

    _attribute_map = {
        'begin': {'key': 'begin', 'type': 'int'},
        'end': {'key': 'end', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        begin: Optional[int] = None,
        end: Optional[int] = None,
        **kwargs
    ):
        """
        :keyword begin: The inclusive start of the http status code range.
        :paramtype begin: int
        :keyword end: The inclusive end of the http status code range.
        :paramtype end: int
        """
        super(HttpErrorRangeParameters, self).__init__(**kwargs)
        self.begin = begin
        self.end = end


class HttpVersionMatchConditionParameters(msrest.serialization.Model):
    """Defines the parameters for HttpVersion match conditions.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar type_name:  Has constant value: "DeliveryRuleHttpVersionConditionParameters".
    :vartype type_name: str
    :ivar operator: Required. Describes operator to be matched. Possible values include: "Equal".
    :vartype operator: str or ~azure.mgmt.cdn.models.HttpVersionOperator
    :ivar negate_condition: Describes if this is negate condition or not.
    :vartype negate_condition: bool
    :ivar match_values: The match value for the condition of the delivery rule.
    :vartype match_values: list[str]
    :ivar transforms: List of transforms.
    :vartype transforms: list[str or ~azure.mgmt.cdn.models.Transform]
    """

    _validation = {
        'type_name': {'required': True, 'constant': True},
        'operator': {'required': True},
    }

    _attribute_map = {
        'type_name': {'key': 'typeName', 'type': 'str'},
        'operator': {'key': 'operator', 'type': 'str'},
        'negate_condition': {'key': 'negateCondition', 'type': 'bool'},
        'match_values': {'key': 'matchValues', 'type': '[str]'},
        'transforms': {'key': 'transforms', 'type': '[str]'},
    }

    type_name = "DeliveryRuleHttpVersionConditionParameters"

    def __init__(
        self,
        *,
        operator: Union[str, "HttpVersionOperator"],
        negate_condition: Optional[bool] = None,
        match_values: Optional[List[str]] = None,
        transforms: Optional[List[Union[str, "Transform"]]] = None,
        **kwargs
    ):
        """
        :keyword operator: Required. Describes operator to be matched. Possible values include:
         "Equal".
        :paramtype operator: str or ~azure.mgmt.cdn.models.HttpVersionOperator
        :keyword negate_condition: Describes if this is negate condition or not.
        :paramtype negate_condition: bool
        :keyword match_values: The match value for the condition of the delivery rule.
        :paramtype match_values: list[str]
        :keyword transforms: List of transforms.
        :paramtype transforms: list[str or ~azure.mgmt.cdn.models.Transform]
        """
        super(HttpVersionMatchConditionParameters, self).__init__(**kwargs)
        self.operator = operator
        self.negate_condition = negate_condition
        self.match_values = match_values
        self.transforms = transforms


class IpAddressGroup(msrest.serialization.Model):
    """CDN Ip address group.

    :ivar delivery_region: The delivery region of the ip address group.
    :vartype delivery_region: str
    :ivar ipv4_addresses: The list of ip v4 addresses.
    :vartype ipv4_addresses: list[~azure.mgmt.cdn.models.CidrIpAddress]
    :ivar ipv6_addresses: The list of ip v6 addresses.
    :vartype ipv6_addresses: list[~azure.mgmt.cdn.models.CidrIpAddress]
    """

    _attribute_map = {
        'delivery_region': {'key': 'deliveryRegion', 'type': 'str'},
        'ipv4_addresses': {'key': 'ipv4Addresses', 'type': '[CidrIpAddress]'},
        'ipv6_addresses': {'key': 'ipv6Addresses', 'type': '[CidrIpAddress]'},
    }

    def __init__(
        self,
        *,
        delivery_region: Optional[str] = None,
        ipv4_addresses: Optional[List["CidrIpAddress"]] = None,
        ipv6_addresses: Optional[List["CidrIpAddress"]] = None,
        **kwargs
    ):
        """
        :keyword delivery_region: The delivery region of the ip address group.
        :paramtype delivery_region: str
        :keyword ipv4_addresses: The list of ip v4 addresses.
        :paramtype ipv4_addresses: list[~azure.mgmt.cdn.models.CidrIpAddress]
        :keyword ipv6_addresses: The list of ip v6 addresses.
        :paramtype ipv6_addresses: list[~azure.mgmt.cdn.models.CidrIpAddress]
        """
        super(IpAddressGroup, self).__init__(**kwargs)
        self.delivery_region = delivery_region
        self.ipv4_addresses = ipv4_addresses
        self.ipv6_addresses = ipv6_addresses


class IsDeviceMatchConditionParameters(msrest.serialization.Model):
    """Defines the parameters for IsDevice match conditions.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar type_name:  Has constant value: "DeliveryRuleIsDeviceConditionParameters".
    :vartype type_name: str
    :ivar operator: Required. Describes operator to be matched. Possible values include: "Equal".
    :vartype operator: str or ~azure.mgmt.cdn.models.IsDeviceOperator
    :ivar negate_condition: Describes if this is negate condition or not.
    :vartype negate_condition: bool
    :ivar match_values: The match value for the condition of the delivery rule.
    :vartype match_values: list[str or
     ~azure.mgmt.cdn.models.IsDeviceMatchConditionParametersMatchValuesItem]
    :ivar transforms: List of transforms.
    :vartype transforms: list[str or ~azure.mgmt.cdn.models.Transform]
    """

    _validation = {
        'type_name': {'required': True, 'constant': True},
        'operator': {'required': True},
    }

    _attribute_map = {
        'type_name': {'key': 'typeName', 'type': 'str'},
        'operator': {'key': 'operator', 'type': 'str'},
        'negate_condition': {'key': 'negateCondition', 'type': 'bool'},
        'match_values': {'key': 'matchValues', 'type': '[str]'},
        'transforms': {'key': 'transforms', 'type': '[str]'},
    }

    type_name = "DeliveryRuleIsDeviceConditionParameters"

    def __init__(
        self,
        *,
        operator: Union[str, "IsDeviceOperator"],
        negate_condition: Optional[bool] = None,
        match_values: Optional[List[Union[str, "IsDeviceMatchConditionParametersMatchValuesItem"]]] = None,
        transforms: Optional[List[Union[str, "Transform"]]] = None,
        **kwargs
    ):
        """
        :keyword operator: Required. Describes operator to be matched. Possible values include:
         "Equal".
        :paramtype operator: str or ~azure.mgmt.cdn.models.IsDeviceOperator
        :keyword negate_condition: Describes if this is negate condition or not.
        :paramtype negate_condition: bool
        :keyword match_values: The match value for the condition of the delivery rule.
        :paramtype match_values: list[str or
         ~azure.mgmt.cdn.models.IsDeviceMatchConditionParametersMatchValuesItem]
        :keyword transforms: List of transforms.
        :paramtype transforms: list[str or ~azure.mgmt.cdn.models.Transform]
        """
        super(IsDeviceMatchConditionParameters, self).__init__(**kwargs)
        self.operator = operator
        self.negate_condition = negate_condition
        self.match_values = match_values
        self.transforms = transforms


class KeyVaultCertificateSourceParameters(msrest.serialization.Model):
    """Describes the parameters for using a user's KeyVault certificate for securing custom domain.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar type_name:  Has constant value: "KeyVaultCertificateSourceParameters".
    :vartype type_name: str
    :ivar subscription_id: Required. Subscription Id of the user's Key Vault containing the SSL
     certificate.
    :vartype subscription_id: str
    :ivar resource_group_name: Required. Resource group of the user's Key Vault containing the SSL
     certificate.
    :vartype resource_group_name: str
    :ivar vault_name: Required. The name of the user's Key Vault containing the SSL certificate.
    :vartype vault_name: str
    :ivar secret_name: Required. The name of Key Vault Secret (representing the full certificate
     PFX) in Key Vault.
    :vartype secret_name: str
    :ivar secret_version: The version(GUID) of Key Vault Secret in Key Vault.
    :vartype secret_version: str
    :ivar update_rule: Required. Describes the action that shall be taken when the certificate is
     updated in Key Vault. Possible values include: "NoAction".
    :vartype update_rule: str or ~azure.mgmt.cdn.models.UpdateRule
    :ivar delete_rule: Required. Describes the action that shall be taken when the certificate is
     removed from Key Vault. Possible values include: "NoAction".
    :vartype delete_rule: str or ~azure.mgmt.cdn.models.DeleteRule
    """

    _validation = {
        'type_name': {'required': True, 'constant': True},
        'subscription_id': {'required': True},
        'resource_group_name': {'required': True},
        'vault_name': {'required': True},
        'secret_name': {'required': True},
        'update_rule': {'required': True},
        'delete_rule': {'required': True},
    }

    _attribute_map = {
        'type_name': {'key': 'typeName', 'type': 'str'},
        'subscription_id': {'key': 'subscriptionId', 'type': 'str'},
        'resource_group_name': {'key': 'resourceGroupName', 'type': 'str'},
        'vault_name': {'key': 'vaultName', 'type': 'str'},
        'secret_name': {'key': 'secretName', 'type': 'str'},
        'secret_version': {'key': 'secretVersion', 'type': 'str'},
        'update_rule': {'key': 'updateRule', 'type': 'str'},
        'delete_rule': {'key': 'deleteRule', 'type': 'str'},
    }

    type_name = "KeyVaultCertificateSourceParameters"

    def __init__(
        self,
        *,
        subscription_id: str,
        resource_group_name: str,
        vault_name: str,
        secret_name: str,
        update_rule: Union[str, "UpdateRule"],
        delete_rule: Union[str, "DeleteRule"],
        secret_version: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword subscription_id: Required. Subscription Id of the user's Key Vault containing the SSL
         certificate.
        :paramtype subscription_id: str
        :keyword resource_group_name: Required. Resource group of the user's Key Vault containing the
         SSL certificate.
        :paramtype resource_group_name: str
        :keyword vault_name: Required. The name of the user's Key Vault containing the SSL certificate.
        :paramtype vault_name: str
        :keyword secret_name: Required. The name of Key Vault Secret (representing the full certificate
         PFX) in Key Vault.
        :paramtype secret_name: str
        :keyword secret_version: The version(GUID) of Key Vault Secret in Key Vault.
        :paramtype secret_version: str
        :keyword update_rule: Required. Describes the action that shall be taken when the certificate
         is updated in Key Vault. Possible values include: "NoAction".
        :paramtype update_rule: str or ~azure.mgmt.cdn.models.UpdateRule
        :keyword delete_rule: Required. Describes the action that shall be taken when the certificate
         is removed from Key Vault. Possible values include: "NoAction".
        :paramtype delete_rule: str or ~azure.mgmt.cdn.models.DeleteRule
        """
        super(KeyVaultCertificateSourceParameters, self).__init__(**kwargs)
        self.subscription_id = subscription_id
        self.resource_group_name = resource_group_name
        self.vault_name = vault_name
        self.secret_name = secret_name
        self.secret_version = secret_version
        self.update_rule = update_rule
        self.delete_rule = delete_rule


class KeyVaultSigningKeyParameters(msrest.serialization.Model):
    """Describes the parameters for using a user's KeyVault for URL Signing Key.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar type_name:  Has constant value: "KeyVaultSigningKeyParameters".
    :vartype type_name: str
    :ivar subscription_id: Required. Subscription Id of the user's Key Vault containing the secret.
    :vartype subscription_id: str
    :ivar resource_group_name: Required. Resource group of the user's Key Vault containing the
     secret.
    :vartype resource_group_name: str
    :ivar vault_name: Required. The name of the user's Key Vault containing the secret.
    :vartype vault_name: str
    :ivar secret_name: Required. The name of secret in Key Vault.
    :vartype secret_name: str
    :ivar secret_version: Required. The version(GUID) of secret in Key Vault.
    :vartype secret_version: str
    """

    _validation = {
        'type_name': {'required': True, 'constant': True},
        'subscription_id': {'required': True},
        'resource_group_name': {'required': True},
        'vault_name': {'required': True},
        'secret_name': {'required': True},
        'secret_version': {'required': True},
    }

    _attribute_map = {
        'type_name': {'key': 'typeName', 'type': 'str'},
        'subscription_id': {'key': 'subscriptionId', 'type': 'str'},
        'resource_group_name': {'key': 'resourceGroupName', 'type': 'str'},
        'vault_name': {'key': 'vaultName', 'type': 'str'},
        'secret_name': {'key': 'secretName', 'type': 'str'},
        'secret_version': {'key': 'secretVersion', 'type': 'str'},
    }

    type_name = "KeyVaultSigningKeyParameters"

    def __init__(
        self,
        *,
        subscription_id: str,
        resource_group_name: str,
        vault_name: str,
        secret_name: str,
        secret_version: str,
        **kwargs
    ):
        """
        :keyword subscription_id: Required. Subscription Id of the user's Key Vault containing the
         secret.
        :paramtype subscription_id: str
        :keyword resource_group_name: Required. Resource group of the user's Key Vault containing the
         secret.
        :paramtype resource_group_name: str
        :keyword vault_name: Required. The name of the user's Key Vault containing the secret.
        :paramtype vault_name: str
        :keyword secret_name: Required. The name of secret in Key Vault.
        :paramtype secret_name: str
        :keyword secret_version: Required. The version(GUID) of secret in Key Vault.
        :paramtype secret_version: str
        """
        super(KeyVaultSigningKeyParameters, self).__init__(**kwargs)
        self.subscription_id = subscription_id
        self.resource_group_name = resource_group_name
        self.vault_name = vault_name
        self.secret_name = secret_name
        self.secret_version = secret_version


class LoadBalancingSettingsParameters(msrest.serialization.Model):
    """Round-Robin load balancing settings for a backend pool.

    :ivar sample_size: The number of samples to consider for load balancing decisions.
    :vartype sample_size: int
    :ivar successful_samples_required: The number of samples within the sample period that must
     succeed.
    :vartype successful_samples_required: int
    :ivar additional_latency_in_milliseconds: The additional latency in milliseconds for probes to
     fall into the lowest latency bucket.
    :vartype additional_latency_in_milliseconds: int
    """

    _attribute_map = {
        'sample_size': {'key': 'sampleSize', 'type': 'int'},
        'successful_samples_required': {'key': 'successfulSamplesRequired', 'type': 'int'},
        'additional_latency_in_milliseconds': {'key': 'additionalLatencyInMilliseconds', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        sample_size: Optional[int] = None,
        successful_samples_required: Optional[int] = None,
        additional_latency_in_milliseconds: Optional[int] = None,
        **kwargs
    ):
        """
        :keyword sample_size: The number of samples to consider for load balancing decisions.
        :paramtype sample_size: int
        :keyword successful_samples_required: The number of samples within the sample period that must
         succeed.
        :paramtype successful_samples_required: int
        :keyword additional_latency_in_milliseconds: The additional latency in milliseconds for probes
         to fall into the lowest latency bucket.
        :paramtype additional_latency_in_milliseconds: int
        """
        super(LoadBalancingSettingsParameters, self).__init__(**kwargs)
        self.sample_size = sample_size
        self.successful_samples_required = successful_samples_required
        self.additional_latency_in_milliseconds = additional_latency_in_milliseconds


class LoadParameters(msrest.serialization.Model):
    """Parameters required for content load.

    All required parameters must be populated in order to send to Azure.

    :ivar content_paths: Required. The path to the content to be loaded. Path should be a relative
     file URL of the origin.
    :vartype content_paths: list[str]
    """

    _validation = {
        'content_paths': {'required': True},
    }

    _attribute_map = {
        'content_paths': {'key': 'contentPaths', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        content_paths: List[str],
        **kwargs
    ):
        """
        :keyword content_paths: Required. The path to the content to be loaded. Path should be a
         relative file URL of the origin.
        :paramtype content_paths: list[str]
        """
        super(LoadParameters, self).__init__(**kwargs)
        self.content_paths = content_paths


class LogSpecification(msrest.serialization.Model):
    """Log specification of operation.

    :ivar name: Name of log specification.
    :vartype name: str
    :ivar display_name: Display name of log specification.
    :vartype display_name: str
    :ivar blob_duration: Blob duration of specification.
    :vartype blob_duration: str
    :ivar log_filter_pattern: Pattern to filter based on name.
    :vartype log_filter_pattern: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'blob_duration': {'key': 'blobDuration', 'type': 'str'},
        'log_filter_pattern': {'key': 'logFilterPattern', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        display_name: Optional[str] = None,
        blob_duration: Optional[str] = None,
        log_filter_pattern: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword name: Name of log specification.
        :paramtype name: str
        :keyword display_name: Display name of log specification.
        :paramtype display_name: str
        :keyword blob_duration: Blob duration of specification.
        :paramtype blob_duration: str
        :keyword log_filter_pattern: Pattern to filter based on name.
        :paramtype log_filter_pattern: str
        """
        super(LogSpecification, self).__init__(**kwargs)
        self.name = name
        self.display_name = display_name
        self.blob_duration = blob_duration
        self.log_filter_pattern = log_filter_pattern


class ManagedCertificate(Certificate):
    """Managed Certificate used for https.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: The type of the secret resource. Possible values include: "UrlSigningKey",
     "CustomerCertificate", "ManagedCertificate", "AzureFirstPartyManagedCertificate".
    :vartype type: str or ~azure.mgmt.cdn.models.SecretType
    :ivar subject: Subject name in the certificate.
    :vartype subject: str
    :ivar expiration_date: Certificate expiration date.
    :vartype expiration_date: str
    """

    _validation = {
        'subject': {'readonly': True},
        'expiration_date': {'readonly': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'subject': {'key': 'subject', 'type': 'str'},
        'expiration_date': {'key': 'expirationDate', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        type: Optional[Union[str, "SecretType"]] = None,
        **kwargs
    ):
        """
        :keyword type: The type of the secret resource. Possible values include: "UrlSigningKey",
         "CustomerCertificate", "ManagedCertificate", "AzureFirstPartyManagedCertificate".
        :paramtype type: str or ~azure.mgmt.cdn.models.SecretType
        """
        super(ManagedCertificate, self).__init__(type=type, **kwargs)


class ManagedCertificateParameters(SecretParameters):
    """Managed Certificate used for https.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar type: Required. The type of the secret resource.Constant filled by server. Possible
     values include: "UrlSigningKey", "CustomerCertificate", "ManagedCertificate",
     "AzureFirstPartyManagedCertificate".
    :vartype type: str or ~azure.mgmt.cdn.models.SecretType
    :ivar subject: Subject name in the certificate.
    :vartype subject: str
    :ivar expiration_date: Certificate expiration date.
    :vartype expiration_date: str
    """

    _validation = {
        'type': {'required': True},
        'subject': {'readonly': True},
        'expiration_date': {'readonly': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'subject': {'key': 'subject', 'type': 'str'},
        'expiration_date': {'key': 'expirationDate', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(ManagedCertificateParameters, self).__init__(**kwargs)
        self.type = 'ManagedCertificate'  # type: str
        self.subject = None
        self.expiration_date = None


class ManagedRuleDefinition(msrest.serialization.Model):
    """Describes a managed rule definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar rule_id: Identifier for the managed rule.
    :vartype rule_id: str
    :ivar description: Describes the functionality of the managed rule.
    :vartype description: str
    """

    _validation = {
        'rule_id': {'readonly': True},
        'description': {'readonly': True},
    }

    _attribute_map = {
        'rule_id': {'key': 'ruleId', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(ManagedRuleDefinition, self).__init__(**kwargs)
        self.rule_id = None
        self.description = None


class ManagedRuleGroupDefinition(msrest.serialization.Model):
    """Describes a managed rule group.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar rule_group_name: Name of the managed rule group.
    :vartype rule_group_name: str
    :ivar description: Description of the managed rule group.
    :vartype description: str
    :ivar rules: List of rules within the managed rule group.
    :vartype rules: list[~azure.mgmt.cdn.models.ManagedRuleDefinition]
    """

    _validation = {
        'rule_group_name': {'readonly': True},
        'description': {'readonly': True},
        'rules': {'readonly': True},
    }

    _attribute_map = {
        'rule_group_name': {'key': 'ruleGroupName', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'rules': {'key': 'rules', 'type': '[ManagedRuleDefinition]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(ManagedRuleGroupDefinition, self).__init__(**kwargs)
        self.rule_group_name = None
        self.description = None
        self.rules = None


class ManagedRuleGroupOverride(msrest.serialization.Model):
    """Defines a managed rule group override setting.

    All required parameters must be populated in order to send to Azure.

    :ivar rule_group_name: Required. Describes the managed rule group within the rule set to
     override.
    :vartype rule_group_name: str
    :ivar rules: List of rules that will be disabled. If none specified, all rules in the group
     will be disabled.
    :vartype rules: list[~azure.mgmt.cdn.models.ManagedRuleOverride]
    """

    _validation = {
        'rule_group_name': {'required': True},
    }

    _attribute_map = {
        'rule_group_name': {'key': 'ruleGroupName', 'type': 'str'},
        'rules': {'key': 'rules', 'type': '[ManagedRuleOverride]'},
    }

    def __init__(
        self,
        *,
        rule_group_name: str,
        rules: Optional[List["ManagedRuleOverride"]] = None,
        **kwargs
    ):
        """
        :keyword rule_group_name: Required. Describes the managed rule group within the rule set to
         override.
        :paramtype rule_group_name: str
        :keyword rules: List of rules that will be disabled. If none specified, all rules in the group
         will be disabled.
        :paramtype rules: list[~azure.mgmt.cdn.models.ManagedRuleOverride]
        """
        super(ManagedRuleGroupOverride, self).__init__(**kwargs)
        self.rule_group_name = rule_group_name
        self.rules = rules


class ManagedRuleOverride(msrest.serialization.Model):
    """Defines a managed rule group override setting.

    All required parameters must be populated in order to send to Azure.

    :ivar rule_id: Required. Identifier for the managed rule.
    :vartype rule_id: str
    :ivar enabled_state: Describes if the managed rule is in enabled or disabled state. Defaults to
     Disabled if not specified. Possible values include: "Disabled", "Enabled".
    :vartype enabled_state: str or ~azure.mgmt.cdn.models.ManagedRuleEnabledState
    :ivar action: Describes the override action to be applied when rule matches. Possible values
     include: "Allow", "Block", "Log", "Redirect".
    :vartype action: str or ~azure.mgmt.cdn.models.ActionType
    """

    _validation = {
        'rule_id': {'required': True},
    }

    _attribute_map = {
        'rule_id': {'key': 'ruleId', 'type': 'str'},
        'enabled_state': {'key': 'enabledState', 'type': 'str'},
        'action': {'key': 'action', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        rule_id: str,
        enabled_state: Optional[Union[str, "ManagedRuleEnabledState"]] = None,
        action: Optional[Union[str, "ActionType"]] = None,
        **kwargs
    ):
        """
        :keyword rule_id: Required. Identifier for the managed rule.
        :paramtype rule_id: str
        :keyword enabled_state: Describes if the managed rule is in enabled or disabled state. Defaults
         to Disabled if not specified. Possible values include: "Disabled", "Enabled".
        :paramtype enabled_state: str or ~azure.mgmt.cdn.models.ManagedRuleEnabledState
        :keyword action: Describes the override action to be applied when rule matches. Possible values
         include: "Allow", "Block", "Log", "Redirect".
        :paramtype action: str or ~azure.mgmt.cdn.models.ActionType
        """
        super(ManagedRuleOverride, self).__init__(**kwargs)
        self.rule_id = rule_id
        self.enabled_state = enabled_state
        self.action = action


class ManagedRuleSet(msrest.serialization.Model):
    """Defines a managed rule set.

    All required parameters must be populated in order to send to Azure.

    :ivar rule_set_type: Required. Defines the rule set type to use.
    :vartype rule_set_type: str
    :ivar rule_set_version: Required. Defines the version of the rule set to use.
    :vartype rule_set_version: str
    :ivar anomaly_score: Verizon only : If the rule set supports anomaly detection mode, this
     describes the threshold for blocking requests.
    :vartype anomaly_score: int
    :ivar rule_group_overrides: Defines the rule overrides to apply to the rule set.
    :vartype rule_group_overrides: list[~azure.mgmt.cdn.models.ManagedRuleGroupOverride]
    """

    _validation = {
        'rule_set_type': {'required': True},
        'rule_set_version': {'required': True},
        'anomaly_score': {'maximum': 20, 'minimum': 0},
    }

    _attribute_map = {
        'rule_set_type': {'key': 'ruleSetType', 'type': 'str'},
        'rule_set_version': {'key': 'ruleSetVersion', 'type': 'str'},
        'anomaly_score': {'key': 'anomalyScore', 'type': 'int'},
        'rule_group_overrides': {'key': 'ruleGroupOverrides', 'type': '[ManagedRuleGroupOverride]'},
    }

    def __init__(
        self,
        *,
        rule_set_type: str,
        rule_set_version: str,
        anomaly_score: Optional[int] = None,
        rule_group_overrides: Optional[List["ManagedRuleGroupOverride"]] = None,
        **kwargs
    ):
        """
        :keyword rule_set_type: Required. Defines the rule set type to use.
        :paramtype rule_set_type: str
        :keyword rule_set_version: Required. Defines the version of the rule set to use.
        :paramtype rule_set_version: str
        :keyword anomaly_score: Verizon only : If the rule set supports anomaly detection mode, this
         describes the threshold for blocking requests.
        :paramtype anomaly_score: int
        :keyword rule_group_overrides: Defines the rule overrides to apply to the rule set.
        :paramtype rule_group_overrides: list[~azure.mgmt.cdn.models.ManagedRuleGroupOverride]
        """
        super(ManagedRuleSet, self).__init__(**kwargs)
        self.rule_set_type = rule_set_type
        self.rule_set_version = rule_set_version
        self.anomaly_score = anomaly_score
        self.rule_group_overrides = rule_group_overrides


class ManagedRuleSetDefinition(Resource):
    """Describes a managed rule set definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar system_data: Read only system data.
    :vartype system_data: ~azure.mgmt.cdn.models.SystemData
    :ivar sku: The pricing tier (defines a CDN provider, feature list and rate) of the
     CdnWebApplicationFirewallPolicy.
    :vartype sku: ~azure.mgmt.cdn.models.Sku
    :ivar provisioning_state: Provisioning state of the managed rule set.
    :vartype provisioning_state: str
    :ivar rule_set_type: Type of the managed rule set.
    :vartype rule_set_type: str
    :ivar rule_set_version: Version of the managed rule set type.
    :vartype rule_set_version: str
    :ivar rule_groups: Rule groups of the managed rule set.
    :vartype rule_groups: list[~azure.mgmt.cdn.models.ManagedRuleGroupDefinition]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'rule_set_type': {'readonly': True},
        'rule_set_version': {'readonly': True},
        'rule_groups': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'sku': {'key': 'sku', 'type': 'Sku'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'rule_set_type': {'key': 'properties.ruleSetType', 'type': 'str'},
        'rule_set_version': {'key': 'properties.ruleSetVersion', 'type': 'str'},
        'rule_groups': {'key': 'properties.ruleGroups', 'type': '[ManagedRuleGroupDefinition]'},
    }

    def __init__(
        self,
        *,
        sku: Optional["Sku"] = None,
        **kwargs
    ):
        """
        :keyword sku: The pricing tier (defines a CDN provider, feature list and rate) of the
         CdnWebApplicationFirewallPolicy.
        :paramtype sku: ~azure.mgmt.cdn.models.Sku
        """
        super(ManagedRuleSetDefinition, self).__init__(**kwargs)
        self.sku = sku
        self.provisioning_state = None
        self.rule_set_type = None
        self.rule_set_version = None
        self.rule_groups = None


class ManagedRuleSetDefinitionList(msrest.serialization.Model):
    """List of managed rule set definitions available for use in a policy.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of managed rule set definitions.
    :vartype value: list[~azure.mgmt.cdn.models.ManagedRuleSetDefinition]
    :ivar next_link: URL to retrieve next set of managed rule set definitions.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ManagedRuleSetDefinition]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        next_link: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword next_link: URL to retrieve next set of managed rule set definitions.
        :paramtype next_link: str
        """
        super(ManagedRuleSetDefinitionList, self).__init__(**kwargs)
        self.value = None
        self.next_link = next_link


class ManagedRuleSetList(msrest.serialization.Model):
    """Defines the list of managed rule sets for the policy.

    :ivar managed_rule_sets: List of rule sets.
    :vartype managed_rule_sets: list[~azure.mgmt.cdn.models.ManagedRuleSet]
    """

    _attribute_map = {
        'managed_rule_sets': {'key': 'managedRuleSets', 'type': '[ManagedRuleSet]'},
    }

    def __init__(
        self,
        *,
        managed_rule_sets: Optional[List["ManagedRuleSet"]] = None,
        **kwargs
    ):
        """
        :keyword managed_rule_sets: List of rule sets.
        :paramtype managed_rule_sets: list[~azure.mgmt.cdn.models.ManagedRuleSet]
        """
        super(ManagedRuleSetList, self).__init__(**kwargs)
        self.managed_rule_sets = managed_rule_sets


class MatchCondition(msrest.serialization.Model):
    """Define match conditions.

    All required parameters must be populated in order to send to Azure.

    :ivar match_variable: Required. Match variable to compare against. Possible values include:
     "RemoteAddr", "SocketAddr", "RequestMethod", "RequestHeader", "RequestUri", "QueryString",
     "RequestBody", "Cookies", "PostArgs".
    :vartype match_variable: str or ~azure.mgmt.cdn.models.WafMatchVariable
    :ivar selector: Selector can used to match a specific key for QueryString, Cookies,
     RequestHeader or PostArgs.
    :vartype selector: str
    :ivar operator: Required. Describes operator to be matched. Possible values include: "Any",
     "IPMatch", "GeoMatch", "Equal", "Contains", "LessThan", "GreaterThan", "LessThanOrEqual",
     "GreaterThanOrEqual", "BeginsWith", "EndsWith", "RegEx".
    :vartype operator: str or ~azure.mgmt.cdn.models.Operator
    :ivar negate_condition: Describes if the result of this condition should be negated.
    :vartype negate_condition: bool
    :ivar match_value: Required. List of possible match values.
    :vartype match_value: list[str]
    :ivar transforms: List of transforms.
    :vartype transforms: list[str or ~azure.mgmt.cdn.models.TransformType]
    """

    _validation = {
        'match_variable': {'required': True},
        'operator': {'required': True},
        'match_value': {'required': True},
    }

    _attribute_map = {
        'match_variable': {'key': 'matchVariable', 'type': 'str'},
        'selector': {'key': 'selector', 'type': 'str'},
        'operator': {'key': 'operator', 'type': 'str'},
        'negate_condition': {'key': 'negateCondition', 'type': 'bool'},
        'match_value': {'key': 'matchValue', 'type': '[str]'},
        'transforms': {'key': 'transforms', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        match_variable: Union[str, "WafMatchVariable"],
        operator: Union[str, "Operator"],
        match_value: List[str],
        selector: Optional[str] = None,
        negate_condition: Optional[bool] = None,
        transforms: Optional[List[Union[str, "TransformType"]]] = None,
        **kwargs
    ):
        """
        :keyword match_variable: Required. Match variable to compare against. Possible values include:
         "RemoteAddr", "SocketAddr", "RequestMethod", "RequestHeader", "RequestUri", "QueryString",
         "RequestBody", "Cookies", "PostArgs".
        :paramtype match_variable: str or ~azure.mgmt.cdn.models.WafMatchVariable
        :keyword selector: Selector can used to match a specific key for QueryString, Cookies,
         RequestHeader or PostArgs.
        :paramtype selector: str
        :keyword operator: Required. Describes operator to be matched. Possible values include: "Any",
         "IPMatch", "GeoMatch", "Equal", "Contains", "LessThan", "GreaterThan", "LessThanOrEqual",
         "GreaterThanOrEqual", "BeginsWith", "EndsWith", "RegEx".
        :paramtype operator: str or ~azure.mgmt.cdn.models.Operator
        :keyword negate_condition: Describes if the result of this condition should be negated.
        :paramtype negate_condition: bool
        :keyword match_value: Required. List of possible match values.
        :paramtype match_value: list[str]
        :keyword transforms: List of transforms.
        :paramtype transforms: list[str or ~azure.mgmt.cdn.models.TransformType]
        """
        super(MatchCondition, self).__init__(**kwargs)
        self.match_variable = match_variable
        self.selector = selector
        self.operator = operator
        self.negate_condition = negate_condition
        self.match_value = match_value
        self.transforms = transforms


class MetricAvailability(msrest.serialization.Model):
    """Retention policy of a resource metric.

    :ivar time_grain:
    :vartype time_grain: str
    :ivar blob_duration:
    :vartype blob_duration: str
    """

    _attribute_map = {
        'time_grain': {'key': 'timeGrain', 'type': 'str'},
        'blob_duration': {'key': 'blobDuration', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        time_grain: Optional[str] = None,
        blob_duration: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword time_grain:
        :paramtype time_grain: str
        :keyword blob_duration:
        :paramtype blob_duration: str
        """
        super(MetricAvailability, self).__init__(**kwargs)
        self.time_grain = time_grain
        self.blob_duration = blob_duration


class MetricSpecification(msrest.serialization.Model):
    """Metric specification of operation.

    :ivar name: Name of metric specification.
    :vartype name: str
    :ivar display_name: Display name of metric specification.
    :vartype display_name: str
    :ivar display_description: Display description of metric specification.
    :vartype display_description: str
    :ivar unit: The metric unit. Possible values include: 'Bytes', 'Count', 'Milliseconds'.
    :vartype unit: str
    :ivar aggregation_type: The metric aggregation type. Possible values include: 'Average',
     'Count', 'Total'.
    :vartype aggregation_type: str
    :ivar availabilities: Retention policies of a resource metric.
    :vartype availabilities: list[~azure.mgmt.cdn.models.MetricAvailability]
    :ivar supported_time_grain_types: The supported time grain types for the metrics.
    :vartype supported_time_grain_types: list[str]
    :ivar dimensions: The dimensions of metric.
    :vartype dimensions: list[~azure.mgmt.cdn.models.DimensionProperties]
    :ivar fill_gap_with_zero: Property to specify whether to fill gap with zero.
    :vartype fill_gap_with_zero: bool
    :ivar metric_filter_pattern: Pattern to filter based on name.
    :vartype metric_filter_pattern: str
    :ivar is_internal: Property to specify metric is internal or not.
    :vartype is_internal: bool
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'display_description': {'key': 'displayDescription', 'type': 'str'},
        'unit': {'key': 'unit', 'type': 'str'},
        'aggregation_type': {'key': 'aggregationType', 'type': 'str'},
        'availabilities': {'key': 'availabilities', 'type': '[MetricAvailability]'},
        'supported_time_grain_types': {'key': 'supportedTimeGrainTypes', 'type': '[str]'},
        'dimensions': {'key': 'dimensions', 'type': '[DimensionProperties]'},
        'fill_gap_with_zero': {'key': 'fillGapWithZero', 'type': 'bool'},
        'metric_filter_pattern': {'key': 'metricFilterPattern', 'type': 'str'},
        'is_internal': {'key': 'isInternal', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        display_name: Optional[str] = None,
        display_description: Optional[str] = None,
        unit: Optional[str] = None,
        aggregation_type: Optional[str] = None,
        availabilities: Optional[List["MetricAvailability"]] = None,
        supported_time_grain_types: Optional[List[str]] = None,
        dimensions: Optional[List["DimensionProperties"]] = None,
        fill_gap_with_zero: Optional[bool] = None,
        metric_filter_pattern: Optional[str] = None,
        is_internal: Optional[bool] = None,
        **kwargs
    ):
        """
        :keyword name: Name of metric specification.
        :paramtype name: str
        :keyword display_name: Display name of metric specification.
        :paramtype display_name: str
        :keyword display_description: Display description of metric specification.
        :paramtype display_description: str
        :keyword unit: The metric unit. Possible values include: 'Bytes', 'Count', 'Milliseconds'.
        :paramtype unit: str
        :keyword aggregation_type: The metric aggregation type. Possible values include: 'Average',
         'Count', 'Total'.
        :paramtype aggregation_type: str
        :keyword availabilities: Retention policies of a resource metric.
        :paramtype availabilities: list[~azure.mgmt.cdn.models.MetricAvailability]
        :keyword supported_time_grain_types: The supported time grain types for the metrics.
        :paramtype supported_time_grain_types: list[str]
        :keyword dimensions: The dimensions of metric.
        :paramtype dimensions: list[~azure.mgmt.cdn.models.DimensionProperties]
        :keyword fill_gap_with_zero: Property to specify whether to fill gap with zero.
        :paramtype fill_gap_with_zero: bool
        :keyword metric_filter_pattern: Pattern to filter based on name.
        :paramtype metric_filter_pattern: str
        :keyword is_internal: Property to specify metric is internal or not.
        :paramtype is_internal: bool
        """
        super(MetricSpecification, self).__init__(**kwargs)
        self.name = name
        self.display_name = display_name
        self.display_description = display_description
        self.unit = unit
        self.aggregation_type = aggregation_type
        self.availabilities = availabilities
        self.supported_time_grain_types = supported_time_grain_types
        self.dimensions = dimensions
        self.fill_gap_with_zero = fill_gap_with_zero
        self.metric_filter_pattern = metric_filter_pattern
        self.is_internal = is_internal


class MetricsResponse(msrest.serialization.Model):
    """Metrics Response.

    :ivar date_time_begin:
    :vartype date_time_begin: ~datetime.datetime
    :ivar date_time_end:
    :vartype date_time_end: ~datetime.datetime
    :ivar granularity: Possible values include: "PT5M", "PT1H", "P1D".
    :vartype granularity: str or ~azure.mgmt.cdn.models.MetricsResponseGranularity
    :ivar series:
    :vartype series: list[~azure.mgmt.cdn.models.MetricsResponseSeriesItem]
    """

    _attribute_map = {
        'date_time_begin': {'key': 'dateTimeBegin', 'type': 'iso-8601'},
        'date_time_end': {'key': 'dateTimeEnd', 'type': 'iso-8601'},
        'granularity': {'key': 'granularity', 'type': 'str'},
        'series': {'key': 'series', 'type': '[MetricsResponseSeriesItem]'},
    }

    def __init__(
        self,
        *,
        date_time_begin: Optional[datetime.datetime] = None,
        date_time_end: Optional[datetime.datetime] = None,
        granularity: Optional[Union[str, "MetricsResponseGranularity"]] = None,
        series: Optional[List["MetricsResponseSeriesItem"]] = None,
        **kwargs
    ):
        """
        :keyword date_time_begin:
        :paramtype date_time_begin: ~datetime.datetime
        :keyword date_time_end:
        :paramtype date_time_end: ~datetime.datetime
        :keyword granularity: Possible values include: "PT5M", "PT1H", "P1D".
        :paramtype granularity: str or ~azure.mgmt.cdn.models.MetricsResponseGranularity
        :keyword series:
        :paramtype series: list[~azure.mgmt.cdn.models.MetricsResponseSeriesItem]
        """
        super(MetricsResponse, self).__init__(**kwargs)
        self.date_time_begin = date_time_begin
        self.date_time_end = date_time_end
        self.granularity = granularity
        self.series = series


class MetricsResponseSeriesItem(msrest.serialization.Model):
    """MetricsResponseSeriesItem.

    :ivar metric:
    :vartype metric: str
    :ivar unit: Possible values include: "count", "bytes", "bitsPerSecond", "milliSeconds".
    :vartype unit: str or ~azure.mgmt.cdn.models.MetricsResponseSeriesItemUnit
    :ivar groups:
    :vartype groups: list[~azure.mgmt.cdn.models.MetricsResponseSeriesPropertiesItemsItem]
    :ivar data:
    :vartype data:
     list[~azure.mgmt.cdn.models.Components1Gs0LlpSchemasMetricsresponsePropertiesSeriesItemsPropertiesDataItems]
    """

    _attribute_map = {
        'metric': {'key': 'metric', 'type': 'str'},
        'unit': {'key': 'unit', 'type': 'str'},
        'groups': {'key': 'groups', 'type': '[MetricsResponseSeriesPropertiesItemsItem]'},
        'data': {'key': 'data', 'type': '[Components1Gs0LlpSchemasMetricsresponsePropertiesSeriesItemsPropertiesDataItems]'},
    }

    def __init__(
        self,
        *,
        metric: Optional[str] = None,
        unit: Optional[Union[str, "MetricsResponseSeriesItemUnit"]] = None,
        groups: Optional[List["MetricsResponseSeriesPropertiesItemsItem"]] = None,
        data: Optional[List["Components1Gs0LlpSchemasMetricsresponsePropertiesSeriesItemsPropertiesDataItems"]] = None,
        **kwargs
    ):
        """
        :keyword metric:
        :paramtype metric: str
        :keyword unit: Possible values include: "count", "bytes", "bitsPerSecond", "milliSeconds".
        :paramtype unit: str or ~azure.mgmt.cdn.models.MetricsResponseSeriesItemUnit
        :keyword groups:
        :paramtype groups: list[~azure.mgmt.cdn.models.MetricsResponseSeriesPropertiesItemsItem]
        :keyword data:
        :paramtype data:
         list[~azure.mgmt.cdn.models.Components1Gs0LlpSchemasMetricsresponsePropertiesSeriesItemsPropertiesDataItems]
        """
        super(MetricsResponseSeriesItem, self).__init__(**kwargs)
        self.metric = metric
        self.unit = unit
        self.groups = groups
        self.data = data


class MetricsResponseSeriesPropertiesItemsItem(msrest.serialization.Model):
    """MetricsResponseSeriesPropertiesItemsItem.

    :ivar name:
    :vartype name: str
    :ivar value:
    :vartype value: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'value': {'key': 'value', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        value: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword name:
        :paramtype name: str
        :keyword value:
        :paramtype value: str
        """
        super(MetricsResponseSeriesPropertiesItemsItem, self).__init__(**kwargs)
        self.name = name
        self.value = value


class Operation(msrest.serialization.Model):
    """CDN REST API operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: Operation name: {provider}/{resource}/{operation}.
    :vartype name: str
    :ivar is_data_action: Indicates whether the operation is a data action.
    :vartype is_data_action: bool
    :ivar display: The object that represents the operation.
    :vartype display: ~azure.mgmt.cdn.models.OperationDisplay
    :ivar origin: The origin of operations.
    :vartype origin: str
    :ivar service_specification: One property of operation, include metric specifications.
    :vartype service_specification: ~azure.mgmt.cdn.models.ServiceSpecification
    """

    _validation = {
        'name': {'readonly': True},
        'origin': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'is_data_action': {'key': 'isDataAction', 'type': 'bool'},
        'display': {'key': 'display', 'type': 'OperationDisplay'},
        'origin': {'key': 'origin', 'type': 'str'},
        'service_specification': {'key': 'properties.serviceSpecification', 'type': 'ServiceSpecification'},
    }

    def __init__(
        self,
        *,
        is_data_action: Optional[bool] = None,
        display: Optional["OperationDisplay"] = None,
        service_specification: Optional["ServiceSpecification"] = None,
        **kwargs
    ):
        """
        :keyword is_data_action: Indicates whether the operation is a data action.
        :paramtype is_data_action: bool
        :keyword display: The object that represents the operation.
        :paramtype display: ~azure.mgmt.cdn.models.OperationDisplay
        :keyword service_specification: One property of operation, include metric specifications.
        :paramtype service_specification: ~azure.mgmt.cdn.models.ServiceSpecification
        """
        super(Operation, self).__init__(**kwargs)
        self.name = None
        self.is_data_action = is_data_action
        self.display = display
        self.origin = None
        self.service_specification = service_specification


class OperationDisplay(msrest.serialization.Model):
    """The object that represents the operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar provider: Service provider: Microsoft.Cdn.
    :vartype provider: str
    :ivar resource: Resource on which the operation is performed: Profile, endpoint, etc.
    :vartype resource: str
    :ivar operation: Operation type: Read, write, delete, etc.
    :vartype operation: str
    :ivar description: Description of operation.
    :vartype description: str
    """

    _validation = {
        'provider': {'readonly': True},
        'resource': {'readonly': True},
        'operation': {'readonly': True},
        'description': {'readonly': True},
    }

    _attribute_map = {
        'provider': {'key': 'provider', 'type': 'str'},
        'resource': {'key': 'resource', 'type': 'str'},
        'operation': {'key': 'operation', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(OperationDisplay, self).__init__(**kwargs)
        self.provider = None
        self.resource = None
        self.operation = None
        self.description = None


class OperationsListResult(msrest.serialization.Model):
    """Result of the request to list CDN operations. It contains a list of operations and a URL link to get the next set of results.

    :ivar value: List of CDN operations supported by the CDN resource provider.
    :vartype value: list[~azure.mgmt.cdn.models.Operation]
    :ivar next_link: URL to get the next set of operation list results if there are any.
    :vartype next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Operation]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["Operation"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword value: List of CDN operations supported by the CDN resource provider.
        :paramtype value: list[~azure.mgmt.cdn.models.Operation]
        :keyword next_link: URL to get the next set of operation list results if there are any.
        :paramtype next_link: str
        """
        super(OperationsListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class Origin(ProxyResource):
    """CDN origin is the source of the content being delivered via CDN. When the edge nodes represented by an endpoint do not have the requested content cached, they attempt to fetch it from one or more of the configured origins.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar system_data: Read only system data.
    :vartype system_data: ~azure.mgmt.cdn.models.SystemData
    :ivar host_name: The address of the origin. Domain names, IPv4 addresses, and IPv6 addresses
     are supported.This should be unique across all origins in an endpoint.
    :vartype host_name: str
    :ivar http_port: The value of the HTTP port. Must be between 1 and 65535.
    :vartype http_port: int
    :ivar https_port: The value of the HTTPS port. Must be between 1 and 65535.
    :vartype https_port: int
    :ivar origin_host_header: The host header value sent to the origin with each request. If you
     leave this blank, the request hostname determines this value. Azure CDN origins, such as Web
     Apps, Blob Storage, and Cloud Services require this host header value to match the origin
     hostname by default. This overrides the host header defined at Endpoint.
    :vartype origin_host_header: str
    :ivar priority: Priority of origin in given origin group for load balancing. Higher priorities
     will not be used for load balancing if any lower priority origin is healthy.Must be between 1
     and 5.
    :vartype priority: int
    :ivar weight: Weight of the origin in given origin group for load balancing. Must be between 1
     and 1000.
    :vartype weight: int
    :ivar enabled: Origin is enabled for load balancing or not.
    :vartype enabled: bool
    :ivar private_link_alias: The Alias of the Private Link resource. Populating this optional
     field indicates that this origin is 'Private'.
    :vartype private_link_alias: str
    :ivar private_link_resource_id: The Resource Id of the Private Link resource. Populating this
     optional field indicates that this backend is 'Private'.
    :vartype private_link_resource_id: str
    :ivar private_link_location: The location of the Private Link resource. Required only if
     'privateLinkResourceId' is populated.
    :vartype private_link_location: str
    :ivar private_link_approval_message: A custom message to be included in the approval request to
     connect to the Private Link.
    :vartype private_link_approval_message: str
    :ivar resource_state: Resource status of the origin. Possible values include: "Creating",
     "Active", "Deleting".
    :vartype resource_state: str or ~azure.mgmt.cdn.models.OriginResourceState
    :ivar provisioning_state: Provisioning status of the origin.
    :vartype provisioning_state: str
    :ivar private_endpoint_status: The approval status for the connection to the Private Link.
     Possible values include: "Pending", "Approved", "Rejected", "Disconnected", "Timeout".
    :vartype private_endpoint_status: str or ~azure.mgmt.cdn.models.PrivateEndpointStatus
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'http_port': {'maximum': 65535, 'minimum': 1},
        'https_port': {'maximum': 65535, 'minimum': 1},
        'priority': {'maximum': 5, 'minimum': 1},
        'weight': {'maximum': 1000, 'minimum': 1},
        'resource_state': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'private_endpoint_status': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'host_name': {'key': 'properties.hostName', 'type': 'str'},
        'http_port': {'key': 'properties.httpPort', 'type': 'int'},
        'https_port': {'key': 'properties.httpsPort', 'type': 'int'},
        'origin_host_header': {'key': 'properties.originHostHeader', 'type': 'str'},
        'priority': {'key': 'properties.priority', 'type': 'int'},
        'weight': {'key': 'properties.weight', 'type': 'int'},
        'enabled': {'key': 'properties.enabled', 'type': 'bool'},
        'private_link_alias': {'key': 'properties.privateLinkAlias', 'type': 'str'},
        'private_link_resource_id': {'key': 'properties.privateLinkResourceId', 'type': 'str'},
        'private_link_location': {'key': 'properties.privateLinkLocation', 'type': 'str'},
        'private_link_approval_message': {'key': 'properties.privateLinkApprovalMessage', 'type': 'str'},
        'resource_state': {'key': 'properties.resourceState', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'private_endpoint_status': {'key': 'properties.privateEndpointStatus', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        host_name: Optional[str] = None,
        http_port: Optional[int] = None,
        https_port: Optional[int] = None,
        origin_host_header: Optional[str] = None,
        priority: Optional[int] = None,
        weight: Optional[int] = None,
        enabled: Optional[bool] = None,
        private_link_alias: Optional[str] = None,
        private_link_resource_id: Optional[str] = None,
        private_link_location: Optional[str] = None,
        private_link_approval_message: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword host_name: The address of the origin. Domain names, IPv4 addresses, and IPv6 addresses
         are supported.This should be unique across all origins in an endpoint.
        :paramtype host_name: str
        :keyword http_port: The value of the HTTP port. Must be between 1 and 65535.
        :paramtype http_port: int
        :keyword https_port: The value of the HTTPS port. Must be between 1 and 65535.
        :paramtype https_port: int
        :keyword origin_host_header: The host header value sent to the origin with each request. If you
         leave this blank, the request hostname determines this value. Azure CDN origins, such as Web
         Apps, Blob Storage, and Cloud Services require this host header value to match the origin
         hostname by default. This overrides the host header defined at Endpoint.
        :paramtype origin_host_header: str
        :keyword priority: Priority of origin in given origin group for load balancing. Higher
         priorities will not be used for load balancing if any lower priority origin is healthy.Must be
         between 1 and 5.
        :paramtype priority: int
        :keyword weight: Weight of the origin in given origin group for load balancing. Must be between
         1 and 1000.
        :paramtype weight: int
        :keyword enabled: Origin is enabled for load balancing or not.
        :paramtype enabled: bool
        :keyword private_link_alias: The Alias of the Private Link resource. Populating this optional
         field indicates that this origin is 'Private'.
        :paramtype private_link_alias: str
        :keyword private_link_resource_id: The Resource Id of the Private Link resource. Populating
         this optional field indicates that this backend is 'Private'.
        :paramtype private_link_resource_id: str
        :keyword private_link_location: The location of the Private Link resource. Required only if
         'privateLinkResourceId' is populated.
        :paramtype private_link_location: str
        :keyword private_link_approval_message: A custom message to be included in the approval request
         to connect to the Private Link.
        :paramtype private_link_approval_message: str
        """
        super(Origin, self).__init__(**kwargs)
        self.host_name = host_name
        self.http_port = http_port
        self.https_port = https_port
        self.origin_host_header = origin_host_header
        self.priority = priority
        self.weight = weight
        self.enabled = enabled
        self.private_link_alias = private_link_alias
        self.private_link_resource_id = private_link_resource_id
        self.private_link_location = private_link_location
        self.private_link_approval_message = private_link_approval_message
        self.resource_state = None
        self.provisioning_state = None
        self.private_endpoint_status = None


class OriginGroup(ProxyResource):
    """Origin group comprising of origins is used for load balancing to origins when the content cannot be served from CDN.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar system_data: Read only system data.
    :vartype system_data: ~azure.mgmt.cdn.models.SystemData
    :ivar health_probe_settings: Health probe settings to the origin that is used to determine the
     health of the origin.
    :vartype health_probe_settings: ~azure.mgmt.cdn.models.HealthProbeParameters
    :ivar origins: The source of the content being delivered via CDN within given origin group.
    :vartype origins: list[~azure.mgmt.cdn.models.ResourceReference]
    :ivar traffic_restoration_time_to_healed_or_new_endpoints_in_minutes: Time in minutes to shift
     the traffic to the endpoint gradually when an unhealthy endpoint comes healthy or a new
     endpoint is added. Default is 10 mins. This property is currently not supported.
    :vartype traffic_restoration_time_to_healed_or_new_endpoints_in_minutes: int
    :ivar response_based_origin_error_detection_settings: The JSON object that contains the
     properties to determine origin health using real requests/responses. This property is currently
     not supported.
    :vartype response_based_origin_error_detection_settings:
     ~azure.mgmt.cdn.models.ResponseBasedOriginErrorDetectionParameters
    :ivar resource_state: Resource status of the origin group. Possible values include: "Creating",
     "Active", "Deleting".
    :vartype resource_state: str or ~azure.mgmt.cdn.models.OriginGroupResourceState
    :ivar provisioning_state: Provisioning status of the origin group.
    :vartype provisioning_state: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'traffic_restoration_time_to_healed_or_new_endpoints_in_minutes': {'maximum': 50, 'minimum': 0},
        'resource_state': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'health_probe_settings': {'key': 'properties.healthProbeSettings', 'type': 'HealthProbeParameters'},
        'origins': {'key': 'properties.origins', 'type': '[ResourceReference]'},
        'traffic_restoration_time_to_healed_or_new_endpoints_in_minutes': {'key': 'properties.trafficRestorationTimeToHealedOrNewEndpointsInMinutes', 'type': 'int'},
        'response_based_origin_error_detection_settings': {'key': 'properties.responseBasedOriginErrorDetectionSettings', 'type': 'ResponseBasedOriginErrorDetectionParameters'},
        'resource_state': {'key': 'properties.resourceState', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        health_probe_settings: Optional["HealthProbeParameters"] = None,
        origins: Optional[List["ResourceReference"]] = None,
        traffic_restoration_time_to_healed_or_new_endpoints_in_minutes: Optional[int] = None,
        response_based_origin_error_detection_settings: Optional["ResponseBasedOriginErrorDetectionParameters"] = None,
        **kwargs
    ):
        """
        :keyword health_probe_settings: Health probe settings to the origin that is used to determine
         the health of the origin.
        :paramtype health_probe_settings: ~azure.mgmt.cdn.models.HealthProbeParameters
        :keyword origins: The source of the content being delivered via CDN within given origin group.
        :paramtype origins: list[~azure.mgmt.cdn.models.ResourceReference]
        :keyword traffic_restoration_time_to_healed_or_new_endpoints_in_minutes: Time in minutes to
         shift the traffic to the endpoint gradually when an unhealthy endpoint comes healthy or a new
         endpoint is added. Default is 10 mins. This property is currently not supported.
        :paramtype traffic_restoration_time_to_healed_or_new_endpoints_in_minutes: int
        :keyword response_based_origin_error_detection_settings: The JSON object that contains the
         properties to determine origin health using real requests/responses. This property is currently
         not supported.
        :paramtype response_based_origin_error_detection_settings:
         ~azure.mgmt.cdn.models.ResponseBasedOriginErrorDetectionParameters
        """
        super(OriginGroup, self).__init__(**kwargs)
        self.health_probe_settings = health_probe_settings
        self.origins = origins
        self.traffic_restoration_time_to_healed_or_new_endpoints_in_minutes = traffic_restoration_time_to_healed_or_new_endpoints_in_minutes
        self.response_based_origin_error_detection_settings = response_based_origin_error_detection_settings
        self.resource_state = None
        self.provisioning_state = None


class OriginGroupListResult(msrest.serialization.Model):
    """Result of the request to list origin groups. It contains a list of origin groups objects and a URL link to get the next set of results.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of CDN origin groups within an endpoint.
    :vartype value: list[~azure.mgmt.cdn.models.OriginGroup]
    :ivar next_link: URL to get the next set of origin objects if there are any.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[OriginGroup]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        next_link: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword next_link: URL to get the next set of origin objects if there are any.
        :paramtype next_link: str
        """
        super(OriginGroupListResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = next_link


class OriginGroupOverride(msrest.serialization.Model):
    """Defines the parameters for the origin group override configuration.

    :ivar origin_group: defines the OriginGroup that would override the DefaultOriginGroup on
     route.
    :vartype origin_group: ~azure.mgmt.cdn.models.ResourceReference
    :ivar forwarding_protocol: Protocol this rule will use when forwarding traffic to backends.
     Possible values include: "HttpOnly", "HttpsOnly", "MatchRequest".
    :vartype forwarding_protocol: str or ~azure.mgmt.cdn.models.ForwardingProtocol
    """

    _attribute_map = {
        'origin_group': {'key': 'originGroup', 'type': 'ResourceReference'},
        'forwarding_protocol': {'key': 'forwardingProtocol', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        origin_group: Optional["ResourceReference"] = None,
        forwarding_protocol: Optional[Union[str, "ForwardingProtocol"]] = None,
        **kwargs
    ):
        """
        :keyword origin_group: defines the OriginGroup that would override the DefaultOriginGroup on
         route.
        :paramtype origin_group: ~azure.mgmt.cdn.models.ResourceReference
        :keyword forwarding_protocol: Protocol this rule will use when forwarding traffic to backends.
         Possible values include: "HttpOnly", "HttpsOnly", "MatchRequest".
        :paramtype forwarding_protocol: str or ~azure.mgmt.cdn.models.ForwardingProtocol
        """
        super(OriginGroupOverride, self).__init__(**kwargs)
        self.origin_group = origin_group
        self.forwarding_protocol = forwarding_protocol


class OriginGroupOverrideAction(DeliveryRuleAction):
    """Defines the origin group override action for the delivery rule.

    All required parameters must be populated in order to send to Azure.

    :ivar name: Required. The name of the action for the delivery rule.Constant filled by server.
     Possible values include: "CacheExpiration", "CacheKeyQueryString", "ModifyRequestHeader",
     "ModifyResponseHeader", "UrlRedirect", "UrlRewrite", "UrlSigning", "OriginGroupOverride",
     "RouteConfigurationOverride".
    :vartype name: str or ~azure.mgmt.cdn.models.DeliveryRuleActionEnum
    :ivar parameters: Required. Defines the parameters for the action.
    :vartype parameters: ~azure.mgmt.cdn.models.OriginGroupOverrideActionParameters
    """

    _validation = {
        'name': {'required': True},
        'parameters': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': 'OriginGroupOverrideActionParameters'},
    }

    def __init__(
        self,
        *,
        parameters: "OriginGroupOverrideActionParameters",
        **kwargs
    ):
        """
        :keyword parameters: Required. Defines the parameters for the action.
        :paramtype parameters: ~azure.mgmt.cdn.models.OriginGroupOverrideActionParameters
        """
        super(OriginGroupOverrideAction, self).__init__(**kwargs)
        self.name = 'OriginGroupOverride'  # type: str
        self.parameters = parameters


class OriginGroupOverrideActionParameters(msrest.serialization.Model):
    """Defines the parameters for the origin group override action.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar type_name:  Has constant value: "DeliveryRuleOriginGroupOverrideActionParameters".
    :vartype type_name: str
    :ivar origin_group: Required. defines the OriginGroup that would override the
     DefaultOriginGroup.
    :vartype origin_group: ~azure.mgmt.cdn.models.ResourceReference
    """

    _validation = {
        'type_name': {'required': True, 'constant': True},
        'origin_group': {'required': True},
    }

    _attribute_map = {
        'type_name': {'key': 'typeName', 'type': 'str'},
        'origin_group': {'key': 'originGroup', 'type': 'ResourceReference'},
    }

    type_name = "DeliveryRuleOriginGroupOverrideActionParameters"

    def __init__(
        self,
        *,
        origin_group: "ResourceReference",
        **kwargs
    ):
        """
        :keyword origin_group: Required. defines the OriginGroup that would override the
         DefaultOriginGroup.
        :paramtype origin_group: ~azure.mgmt.cdn.models.ResourceReference
        """
        super(OriginGroupOverrideActionParameters, self).__init__(**kwargs)
        self.origin_group = origin_group


class OriginGroupUpdatePropertiesParameters(msrest.serialization.Model):
    """The JSON object that contains the properties of the origin group.

    :ivar health_probe_settings: Health probe settings to the origin that is used to determine the
     health of the origin.
    :vartype health_probe_settings: ~azure.mgmt.cdn.models.HealthProbeParameters
    :ivar origins: The source of the content being delivered via CDN within given origin group.
    :vartype origins: list[~azure.mgmt.cdn.models.ResourceReference]
    :ivar traffic_restoration_time_to_healed_or_new_endpoints_in_minutes: Time in minutes to shift
     the traffic to the endpoint gradually when an unhealthy endpoint comes healthy or a new
     endpoint is added. Default is 10 mins. This property is currently not supported.
    :vartype traffic_restoration_time_to_healed_or_new_endpoints_in_minutes: int
    :ivar response_based_origin_error_detection_settings: The JSON object that contains the
     properties to determine origin health using real requests/responses. This property is currently
     not supported.
    :vartype response_based_origin_error_detection_settings:
     ~azure.mgmt.cdn.models.ResponseBasedOriginErrorDetectionParameters
    """

    _validation = {
        'traffic_restoration_time_to_healed_or_new_endpoints_in_minutes': {'maximum': 50, 'minimum': 0},
    }

    _attribute_map = {
        'health_probe_settings': {'key': 'healthProbeSettings', 'type': 'HealthProbeParameters'},
        'origins': {'key': 'origins', 'type': '[ResourceReference]'},
        'traffic_restoration_time_to_healed_or_new_endpoints_in_minutes': {'key': 'trafficRestorationTimeToHealedOrNewEndpointsInMinutes', 'type': 'int'},
        'response_based_origin_error_detection_settings': {'key': 'responseBasedOriginErrorDetectionSettings', 'type': 'ResponseBasedOriginErrorDetectionParameters'},
    }

    def __init__(
        self,
        *,
        health_probe_settings: Optional["HealthProbeParameters"] = None,
        origins: Optional[List["ResourceReference"]] = None,
        traffic_restoration_time_to_healed_or_new_endpoints_in_minutes: Optional[int] = None,
        response_based_origin_error_detection_settings: Optional["ResponseBasedOriginErrorDetectionParameters"] = None,
        **kwargs
    ):
        """
        :keyword health_probe_settings: Health probe settings to the origin that is used to determine
         the health of the origin.
        :paramtype health_probe_settings: ~azure.mgmt.cdn.models.HealthProbeParameters
        :keyword origins: The source of the content being delivered via CDN within given origin group.
        :paramtype origins: list[~azure.mgmt.cdn.models.ResourceReference]
        :keyword traffic_restoration_time_to_healed_or_new_endpoints_in_minutes: Time in minutes to
         shift the traffic to the endpoint gradually when an unhealthy endpoint comes healthy or a new
         endpoint is added. Default is 10 mins. This property is currently not supported.
        :paramtype traffic_restoration_time_to_healed_or_new_endpoints_in_minutes: int
        :keyword response_based_origin_error_detection_settings: The JSON object that contains the
         properties to determine origin health using real requests/responses. This property is currently
         not supported.
        :paramtype response_based_origin_error_detection_settings:
         ~azure.mgmt.cdn.models.ResponseBasedOriginErrorDetectionParameters
        """
        super(OriginGroupUpdatePropertiesParameters, self).__init__(**kwargs)
        self.health_probe_settings = health_probe_settings
        self.origins = origins
        self.traffic_restoration_time_to_healed_or_new_endpoints_in_minutes = traffic_restoration_time_to_healed_or_new_endpoints_in_minutes
        self.response_based_origin_error_detection_settings = response_based_origin_error_detection_settings


class OriginGroupProperties(OriginGroupUpdatePropertiesParameters):
    """The JSON object that contains the properties of the origin group.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar health_probe_settings: Health probe settings to the origin that is used to determine the
     health of the origin.
    :vartype health_probe_settings: ~azure.mgmt.cdn.models.HealthProbeParameters
    :ivar origins: The source of the content being delivered via CDN within given origin group.
    :vartype origins: list[~azure.mgmt.cdn.models.ResourceReference]
    :ivar traffic_restoration_time_to_healed_or_new_endpoints_in_minutes: Time in minutes to shift
     the traffic to the endpoint gradually when an unhealthy endpoint comes healthy or a new
     endpoint is added. Default is 10 mins. This property is currently not supported.
    :vartype traffic_restoration_time_to_healed_or_new_endpoints_in_minutes: int
    :ivar response_based_origin_error_detection_settings: The JSON object that contains the
     properties to determine origin health using real requests/responses. This property is currently
     not supported.
    :vartype response_based_origin_error_detection_settings:
     ~azure.mgmt.cdn.models.ResponseBasedOriginErrorDetectionParameters
    :ivar resource_state: Resource status of the origin group. Possible values include: "Creating",
     "Active", "Deleting".
    :vartype resource_state: str or ~azure.mgmt.cdn.models.OriginGroupResourceState
    :ivar provisioning_state: Provisioning status of the origin group.
    :vartype provisioning_state: str
    """

    _validation = {
        'traffic_restoration_time_to_healed_or_new_endpoints_in_minutes': {'maximum': 50, 'minimum': 0},
        'resource_state': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'health_probe_settings': {'key': 'healthProbeSettings', 'type': 'HealthProbeParameters'},
        'origins': {'key': 'origins', 'type': '[ResourceReference]'},
        'traffic_restoration_time_to_healed_or_new_endpoints_in_minutes': {'key': 'trafficRestorationTimeToHealedOrNewEndpointsInMinutes', 'type': 'int'},
        'response_based_origin_error_detection_settings': {'key': 'responseBasedOriginErrorDetectionSettings', 'type': 'ResponseBasedOriginErrorDetectionParameters'},
        'resource_state': {'key': 'resourceState', 'type': 'str'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        health_probe_settings: Optional["HealthProbeParameters"] = None,
        origins: Optional[List["ResourceReference"]] = None,
        traffic_restoration_time_to_healed_or_new_endpoints_in_minutes: Optional[int] = None,
        response_based_origin_error_detection_settings: Optional["ResponseBasedOriginErrorDetectionParameters"] = None,
        **kwargs
    ):
        """
        :keyword health_probe_settings: Health probe settings to the origin that is used to determine
         the health of the origin.
        :paramtype health_probe_settings: ~azure.mgmt.cdn.models.HealthProbeParameters
        :keyword origins: The source of the content being delivered via CDN within given origin group.
        :paramtype origins: list[~azure.mgmt.cdn.models.ResourceReference]
        :keyword traffic_restoration_time_to_healed_or_new_endpoints_in_minutes: Time in minutes to
         shift the traffic to the endpoint gradually when an unhealthy endpoint comes healthy or a new
         endpoint is added. Default is 10 mins. This property is currently not supported.
        :paramtype traffic_restoration_time_to_healed_or_new_endpoints_in_minutes: int
        :keyword response_based_origin_error_detection_settings: The JSON object that contains the
         properties to determine origin health using real requests/responses. This property is currently
         not supported.
        :paramtype response_based_origin_error_detection_settings:
         ~azure.mgmt.cdn.models.ResponseBasedOriginErrorDetectionParameters
        """
        super(OriginGroupProperties, self).__init__(health_probe_settings=health_probe_settings, origins=origins, traffic_restoration_time_to_healed_or_new_endpoints_in_minutes=traffic_restoration_time_to_healed_or_new_endpoints_in_minutes, response_based_origin_error_detection_settings=response_based_origin_error_detection_settings, **kwargs)
        self.resource_state = None
        self.provisioning_state = None


class OriginGroupUpdateParameters(msrest.serialization.Model):
    """Origin group properties needed for origin group creation or update.

    :ivar health_probe_settings: Health probe settings to the origin that is used to determine the
     health of the origin.
    :vartype health_probe_settings: ~azure.mgmt.cdn.models.HealthProbeParameters
    :ivar origins: The source of the content being delivered via CDN within given origin group.
    :vartype origins: list[~azure.mgmt.cdn.models.ResourceReference]
    :ivar traffic_restoration_time_to_healed_or_new_endpoints_in_minutes: Time in minutes to shift
     the traffic to the endpoint gradually when an unhealthy endpoint comes healthy or a new
     endpoint is added. Default is 10 mins. This property is currently not supported.
    :vartype traffic_restoration_time_to_healed_or_new_endpoints_in_minutes: int
    :ivar response_based_origin_error_detection_settings: The JSON object that contains the
     properties to determine origin health using real requests/responses. This property is currently
     not supported.
    :vartype response_based_origin_error_detection_settings:
     ~azure.mgmt.cdn.models.ResponseBasedOriginErrorDetectionParameters
    """

    _validation = {
        'traffic_restoration_time_to_healed_or_new_endpoints_in_minutes': {'maximum': 50, 'minimum': 0},
    }

    _attribute_map = {
        'health_probe_settings': {'key': 'properties.healthProbeSettings', 'type': 'HealthProbeParameters'},
        'origins': {'key': 'properties.origins', 'type': '[ResourceReference]'},
        'traffic_restoration_time_to_healed_or_new_endpoints_in_minutes': {'key': 'properties.trafficRestorationTimeToHealedOrNewEndpointsInMinutes', 'type': 'int'},
        'response_based_origin_error_detection_settings': {'key': 'properties.responseBasedOriginErrorDetectionSettings', 'type': 'ResponseBasedOriginErrorDetectionParameters'},
    }

    def __init__(
        self,
        *,
        health_probe_settings: Optional["HealthProbeParameters"] = None,
        origins: Optional[List["ResourceReference"]] = None,
        traffic_restoration_time_to_healed_or_new_endpoints_in_minutes: Optional[int] = None,
        response_based_origin_error_detection_settings: Optional["ResponseBasedOriginErrorDetectionParameters"] = None,
        **kwargs
    ):
        """
        :keyword health_probe_settings: Health probe settings to the origin that is used to determine
         the health of the origin.
        :paramtype health_probe_settings: ~azure.mgmt.cdn.models.HealthProbeParameters
        :keyword origins: The source of the content being delivered via CDN within given origin group.
        :paramtype origins: list[~azure.mgmt.cdn.models.ResourceReference]
        :keyword traffic_restoration_time_to_healed_or_new_endpoints_in_minutes: Time in minutes to
         shift the traffic to the endpoint gradually when an unhealthy endpoint comes healthy or a new
         endpoint is added. Default is 10 mins. This property is currently not supported.
        :paramtype traffic_restoration_time_to_healed_or_new_endpoints_in_minutes: int
        :keyword response_based_origin_error_detection_settings: The JSON object that contains the
         properties to determine origin health using real requests/responses. This property is currently
         not supported.
        :paramtype response_based_origin_error_detection_settings:
         ~azure.mgmt.cdn.models.ResponseBasedOriginErrorDetectionParameters
        """
        super(OriginGroupUpdateParameters, self).__init__(**kwargs)
        self.health_probe_settings = health_probe_settings
        self.origins = origins
        self.traffic_restoration_time_to_healed_or_new_endpoints_in_minutes = traffic_restoration_time_to_healed_or_new_endpoints_in_minutes
        self.response_based_origin_error_detection_settings = response_based_origin_error_detection_settings


class OriginListResult(msrest.serialization.Model):
    """Result of the request to list origins. It contains a list of origin objects and a URL link to get the next set of results.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of CDN origins within an endpoint.
    :vartype value: list[~azure.mgmt.cdn.models.Origin]
    :ivar next_link: URL to get the next set of origin objects if there are any.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Origin]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        next_link: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword next_link: URL to get the next set of origin objects if there are any.
        :paramtype next_link: str
        """
        super(OriginListResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = next_link


class OriginUpdatePropertiesParameters(msrest.serialization.Model):
    """The JSON object that contains the properties of the origin.

    :ivar host_name: The address of the origin. Domain names, IPv4 addresses, and IPv6 addresses
     are supported.This should be unique across all origins in an endpoint.
    :vartype host_name: str
    :ivar http_port: The value of the HTTP port. Must be between 1 and 65535.
    :vartype http_port: int
    :ivar https_port: The value of the HTTPS port. Must be between 1 and 65535.
    :vartype https_port: int
    :ivar origin_host_header: The host header value sent to the origin with each request. If you
     leave this blank, the request hostname determines this value. Azure CDN origins, such as Web
     Apps, Blob Storage, and Cloud Services require this host header value to match the origin
     hostname by default. This overrides the host header defined at Endpoint.
    :vartype origin_host_header: str
    :ivar priority: Priority of origin in given origin group for load balancing. Higher priorities
     will not be used for load balancing if any lower priority origin is healthy.Must be between 1
     and 5.
    :vartype priority: int
    :ivar weight: Weight of the origin in given origin group for load balancing. Must be between 1
     and 1000.
    :vartype weight: int
    :ivar enabled: Origin is enabled for load balancing or not.
    :vartype enabled: bool
    :ivar private_link_alias: The Alias of the Private Link resource. Populating this optional
     field indicates that this origin is 'Private'.
    :vartype private_link_alias: str
    :ivar private_link_resource_id: The Resource Id of the Private Link resource. Populating this
     optional field indicates that this backend is 'Private'.
    :vartype private_link_resource_id: str
    :ivar private_link_location: The location of the Private Link resource. Required only if
     'privateLinkResourceId' is populated.
    :vartype private_link_location: str
    :ivar private_link_approval_message: A custom message to be included in the approval request to
     connect to the Private Link.
    :vartype private_link_approval_message: str
    """

    _validation = {
        'http_port': {'maximum': 65535, 'minimum': 1},
        'https_port': {'maximum': 65535, 'minimum': 1},
        'priority': {'maximum': 5, 'minimum': 1},
        'weight': {'maximum': 1000, 'minimum': 1},
    }

    _attribute_map = {
        'host_name': {'key': 'hostName', 'type': 'str'},
        'http_port': {'key': 'httpPort', 'type': 'int'},
        'https_port': {'key': 'httpsPort', 'type': 'int'},
        'origin_host_header': {'key': 'originHostHeader', 'type': 'str'},
        'priority': {'key': 'priority', 'type': 'int'},
        'weight': {'key': 'weight', 'type': 'int'},
        'enabled': {'key': 'enabled', 'type': 'bool'},
        'private_link_alias': {'key': 'privateLinkAlias', 'type': 'str'},
        'private_link_resource_id': {'key': 'privateLinkResourceId', 'type': 'str'},
        'private_link_location': {'key': 'privateLinkLocation', 'type': 'str'},
        'private_link_approval_message': {'key': 'privateLinkApprovalMessage', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        host_name: Optional[str] = None,
        http_port: Optional[int] = None,
        https_port: Optional[int] = None,
        origin_host_header: Optional[str] = None,
        priority: Optional[int] = None,
        weight: Optional[int] = None,
        enabled: Optional[bool] = None,
        private_link_alias: Optional[str] = None,
        private_link_resource_id: Optional[str] = None,
        private_link_location: Optional[str] = None,
        private_link_approval_message: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword host_name: The address of the origin. Domain names, IPv4 addresses, and IPv6 addresses
         are supported.This should be unique across all origins in an endpoint.
        :paramtype host_name: str
        :keyword http_port: The value of the HTTP port. Must be between 1 and 65535.
        :paramtype http_port: int
        :keyword https_port: The value of the HTTPS port. Must be between 1 and 65535.
        :paramtype https_port: int
        :keyword origin_host_header: The host header value sent to the origin with each request. If you
         leave this blank, the request hostname determines this value. Azure CDN origins, such as Web
         Apps, Blob Storage, and Cloud Services require this host header value to match the origin
         hostname by default. This overrides the host header defined at Endpoint.
        :paramtype origin_host_header: str
        :keyword priority: Priority of origin in given origin group for load balancing. Higher
         priorities will not be used for load balancing if any lower priority origin is healthy.Must be
         between 1 and 5.
        :paramtype priority: int
        :keyword weight: Weight of the origin in given origin group for load balancing. Must be between
         1 and 1000.
        :paramtype weight: int
        :keyword enabled: Origin is enabled for load balancing or not.
        :paramtype enabled: bool
        :keyword private_link_alias: The Alias of the Private Link resource. Populating this optional
         field indicates that this origin is 'Private'.
        :paramtype private_link_alias: str
        :keyword private_link_resource_id: The Resource Id of the Private Link resource. Populating
         this optional field indicates that this backend is 'Private'.
        :paramtype private_link_resource_id: str
        :keyword private_link_location: The location of the Private Link resource. Required only if
         'privateLinkResourceId' is populated.
        :paramtype private_link_location: str
        :keyword private_link_approval_message: A custom message to be included in the approval request
         to connect to the Private Link.
        :paramtype private_link_approval_message: str
        """
        super(OriginUpdatePropertiesParameters, self).__init__(**kwargs)
        self.host_name = host_name
        self.http_port = http_port
        self.https_port = https_port
        self.origin_host_header = origin_host_header
        self.priority = priority
        self.weight = weight
        self.enabled = enabled
        self.private_link_alias = private_link_alias
        self.private_link_resource_id = private_link_resource_id
        self.private_link_location = private_link_location
        self.private_link_approval_message = private_link_approval_message


class OriginProperties(OriginUpdatePropertiesParameters):
    """The JSON object that contains the properties of the origin.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar host_name: The address of the origin. Domain names, IPv4 addresses, and IPv6 addresses
     are supported.This should be unique across all origins in an endpoint.
    :vartype host_name: str
    :ivar http_port: The value of the HTTP port. Must be between 1 and 65535.
    :vartype http_port: int
    :ivar https_port: The value of the HTTPS port. Must be between 1 and 65535.
    :vartype https_port: int
    :ivar origin_host_header: The host header value sent to the origin with each request. If you
     leave this blank, the request hostname determines this value. Azure CDN origins, such as Web
     Apps, Blob Storage, and Cloud Services require this host header value to match the origin
     hostname by default. This overrides the host header defined at Endpoint.
    :vartype origin_host_header: str
    :ivar priority: Priority of origin in given origin group for load balancing. Higher priorities
     will not be used for load balancing if any lower priority origin is healthy.Must be between 1
     and 5.
    :vartype priority: int
    :ivar weight: Weight of the origin in given origin group for load balancing. Must be between 1
     and 1000.
    :vartype weight: int
    :ivar enabled: Origin is enabled for load balancing or not.
    :vartype enabled: bool
    :ivar private_link_alias: The Alias of the Private Link resource. Populating this optional
     field indicates that this origin is 'Private'.
    :vartype private_link_alias: str
    :ivar private_link_resource_id: The Resource Id of the Private Link resource. Populating this
     optional field indicates that this backend is 'Private'.
    :vartype private_link_resource_id: str
    :ivar private_link_location: The location of the Private Link resource. Required only if
     'privateLinkResourceId' is populated.
    :vartype private_link_location: str
    :ivar private_link_approval_message: A custom message to be included in the approval request to
     connect to the Private Link.
    :vartype private_link_approval_message: str
    :ivar resource_state: Resource status of the origin. Possible values include: "Creating",
     "Active", "Deleting".
    :vartype resource_state: str or ~azure.mgmt.cdn.models.OriginResourceState
    :ivar provisioning_state: Provisioning status of the origin.
    :vartype provisioning_state: str
    :ivar private_endpoint_status: The approval status for the connection to the Private Link.
     Possible values include: "Pending", "Approved", "Rejected", "Disconnected", "Timeout".
    :vartype private_endpoint_status: str or ~azure.mgmt.cdn.models.PrivateEndpointStatus
    """

    _validation = {
        'http_port': {'maximum': 65535, 'minimum': 1},
        'https_port': {'maximum': 65535, 'minimum': 1},
        'priority': {'maximum': 5, 'minimum': 1},
        'weight': {'maximum': 1000, 'minimum': 1},
        'resource_state': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'private_endpoint_status': {'readonly': True},
    }

    _attribute_map = {
        'host_name': {'key': 'hostName', 'type': 'str'},
        'http_port': {'key': 'httpPort', 'type': 'int'},
        'https_port': {'key': 'httpsPort', 'type': 'int'},
        'origin_host_header': {'key': 'originHostHeader', 'type': 'str'},
        'priority': {'key': 'priority', 'type': 'int'},
        'weight': {'key': 'weight', 'type': 'int'},
        'enabled': {'key': 'enabled', 'type': 'bool'},
        'private_link_alias': {'key': 'privateLinkAlias', 'type': 'str'},
        'private_link_resource_id': {'key': 'privateLinkResourceId', 'type': 'str'},
        'private_link_location': {'key': 'privateLinkLocation', 'type': 'str'},
        'private_link_approval_message': {'key': 'privateLinkApprovalMessage', 'type': 'str'},
        'resource_state': {'key': 'resourceState', 'type': 'str'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
        'private_endpoint_status': {'key': 'privateEndpointStatus', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        host_name: Optional[str] = None,
        http_port: Optional[int] = None,
        https_port: Optional[int] = None,
        origin_host_header: Optional[str] = None,
        priority: Optional[int] = None,
        weight: Optional[int] = None,
        enabled: Optional[bool] = None,
        private_link_alias: Optional[str] = None,
        private_link_resource_id: Optional[str] = None,
        private_link_location: Optional[str] = None,
        private_link_approval_message: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword host_name: The address of the origin. Domain names, IPv4 addresses, and IPv6 addresses
         are supported.This should be unique across all origins in an endpoint.
        :paramtype host_name: str
        :keyword http_port: The value of the HTTP port. Must be between 1 and 65535.
        :paramtype http_port: int
        :keyword https_port: The value of the HTTPS port. Must be between 1 and 65535.
        :paramtype https_port: int
        :keyword origin_host_header: The host header value sent to the origin with each request. If you
         leave this blank, the request hostname determines this value. Azure CDN origins, such as Web
         Apps, Blob Storage, and Cloud Services require this host header value to match the origin
         hostname by default. This overrides the host header defined at Endpoint.
        :paramtype origin_host_header: str
        :keyword priority: Priority of origin in given origin group for load balancing. Higher
         priorities will not be used for load balancing if any lower priority origin is healthy.Must be
         between 1 and 5.
        :paramtype priority: int
        :keyword weight: Weight of the origin in given origin group for load balancing. Must be between
         1 and 1000.
        :paramtype weight: int
        :keyword enabled: Origin is enabled for load balancing or not.
        :paramtype enabled: bool
        :keyword private_link_alias: The Alias of the Private Link resource. Populating this optional
         field indicates that this origin is 'Private'.
        :paramtype private_link_alias: str
        :keyword private_link_resource_id: The Resource Id of the Private Link resource. Populating
         this optional field indicates that this backend is 'Private'.
        :paramtype private_link_resource_id: str
        :keyword private_link_location: The location of the Private Link resource. Required only if
         'privateLinkResourceId' is populated.
        :paramtype private_link_location: str
        :keyword private_link_approval_message: A custom message to be included in the approval request
         to connect to the Private Link.
        :paramtype private_link_approval_message: str
        """
        super(OriginProperties, self).__init__(host_name=host_name, http_port=http_port, https_port=https_port, origin_host_header=origin_host_header, priority=priority, weight=weight, enabled=enabled, private_link_alias=private_link_alias, private_link_resource_id=private_link_resource_id, private_link_location=private_link_location, private_link_approval_message=private_link_approval_message, **kwargs)
        self.resource_state = None
        self.provisioning_state = None
        self.private_endpoint_status = None


class OriginUpdateParameters(msrest.serialization.Model):
    """Origin properties needed for origin update.

    :ivar host_name: The address of the origin. Domain names, IPv4 addresses, and IPv6 addresses
     are supported.This should be unique across all origins in an endpoint.
    :vartype host_name: str
    :ivar http_port: The value of the HTTP port. Must be between 1 and 65535.
    :vartype http_port: int
    :ivar https_port: The value of the HTTPS port. Must be between 1 and 65535.
    :vartype https_port: int
    :ivar origin_host_header: The host header value sent to the origin with each request. If you
     leave this blank, the request hostname determines this value. Azure CDN origins, such as Web
     Apps, Blob Storage, and Cloud Services require this host header value to match the origin
     hostname by default. This overrides the host header defined at Endpoint.
    :vartype origin_host_header: str
    :ivar priority: Priority of origin in given origin group for load balancing. Higher priorities
     will not be used for load balancing if any lower priority origin is healthy.Must be between 1
     and 5.
    :vartype priority: int
    :ivar weight: Weight of the origin in given origin group for load balancing. Must be between 1
     and 1000.
    :vartype weight: int
    :ivar enabled: Origin is enabled for load balancing or not.
    :vartype enabled: bool
    :ivar private_link_alias: The Alias of the Private Link resource. Populating this optional
     field indicates that this origin is 'Private'.
    :vartype private_link_alias: str
    :ivar private_link_resource_id: The Resource Id of the Private Link resource. Populating this
     optional field indicates that this backend is 'Private'.
    :vartype private_link_resource_id: str
    :ivar private_link_location: The location of the Private Link resource. Required only if
     'privateLinkResourceId' is populated.
    :vartype private_link_location: str
    :ivar private_link_approval_message: A custom message to be included in the approval request to
     connect to the Private Link.
    :vartype private_link_approval_message: str
    """

    _validation = {
        'http_port': {'maximum': 65535, 'minimum': 1},
        'https_port': {'maximum': 65535, 'minimum': 1},
        'priority': {'maximum': 5, 'minimum': 1},
        'weight': {'maximum': 1000, 'minimum': 1},
    }

    _attribute_map = {
        'host_name': {'key': 'properties.hostName', 'type': 'str'},
        'http_port': {'key': 'properties.httpPort', 'type': 'int'},
        'https_port': {'key': 'properties.httpsPort', 'type': 'int'},
        'origin_host_header': {'key': 'properties.originHostHeader', 'type': 'str'},
        'priority': {'key': 'properties.priority', 'type': 'int'},
        'weight': {'key': 'properties.weight', 'type': 'int'},
        'enabled': {'key': 'properties.enabled', 'type': 'bool'},
        'private_link_alias': {'key': 'properties.privateLinkAlias', 'type': 'str'},
        'private_link_resource_id': {'key': 'properties.privateLinkResourceId', 'type': 'str'},
        'private_link_location': {'key': 'properties.privateLinkLocation', 'type': 'str'},
        'private_link_approval_message': {'key': 'properties.privateLinkApprovalMessage', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        host_name: Optional[str] = None,
        http_port: Optional[int] = None,
        https_port: Optional[int] = None,
        origin_host_header: Optional[str] = None,
        priority: Optional[int] = None,
        weight: Optional[int] = None,
        enabled: Optional[bool] = None,
        private_link_alias: Optional[str] = None,
        private_link_resource_id: Optional[str] = None,
        private_link_location: Optional[str] = None,
        private_link_approval_message: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword host_name: The address of the origin. Domain names, IPv4 addresses, and IPv6 addresses
         are supported.This should be unique across all origins in an endpoint.
        :paramtype host_name: str
        :keyword http_port: The value of the HTTP port. Must be between 1 and 65535.
        :paramtype http_port: int
        :keyword https_port: The value of the HTTPS port. Must be between 1 and 65535.
        :paramtype https_port: int
        :keyword origin_host_header: The host header value sent to the origin with each request. If you
         leave this blank, the request hostname determines this value. Azure CDN origins, such as Web
         Apps, Blob Storage, and Cloud Services require this host header value to match the origin
         hostname by default. This overrides the host header defined at Endpoint.
        :paramtype origin_host_header: str
        :keyword priority: Priority of origin in given origin group for load balancing. Higher
         priorities will not be used for load balancing if any lower priority origin is healthy.Must be
         between 1 and 5.
        :paramtype priority: int
        :keyword weight: Weight of the origin in given origin group for load balancing. Must be between
         1 and 1000.
        :paramtype weight: int
        :keyword enabled: Origin is enabled for load balancing or not.
        :paramtype enabled: bool
        :keyword private_link_alias: The Alias of the Private Link resource. Populating this optional
         field indicates that this origin is 'Private'.
        :paramtype private_link_alias: str
        :keyword private_link_resource_id: The Resource Id of the Private Link resource. Populating
         this optional field indicates that this backend is 'Private'.
        :paramtype private_link_resource_id: str
        :keyword private_link_location: The location of the Private Link resource. Required only if
         'privateLinkResourceId' is populated.
        :paramtype private_link_location: str
        :keyword private_link_approval_message: A custom message to be included in the approval request
         to connect to the Private Link.
        :paramtype private_link_approval_message: str
        """
        super(OriginUpdateParameters, self).__init__(**kwargs)
        self.host_name = host_name
        self.http_port = http_port
        self.https_port = https_port
        self.origin_host_header = origin_host_header
        self.priority = priority
        self.weight = weight
        self.enabled = enabled
        self.private_link_alias = private_link_alias
        self.private_link_resource_id = private_link_resource_id
        self.private_link_location = private_link_location
        self.private_link_approval_message = private_link_approval_message


class PolicySettings(msrest.serialization.Model):
    """Defines contents of a web application firewall global configuration.

    :ivar enabled_state: describes if the policy is in enabled state or disabled state. Possible
     values include: "Disabled", "Enabled".
    :vartype enabled_state: str or ~azure.mgmt.cdn.models.PolicyEnabledState
    :ivar mode: Describes if it is in detection mode or prevention mode at policy level. Possible
     values include: "Prevention", "Detection".
    :vartype mode: str or ~azure.mgmt.cdn.models.PolicyMode
    :ivar default_redirect_url: If action type is redirect, this field represents the default
     redirect URL for the client.
    :vartype default_redirect_url: str
    :ivar default_custom_block_response_status_code: If the action type is block, this field
     defines the default customer overridable http response status code. Possible values include:
     200, 403, 405, 406, 429.
    :vartype default_custom_block_response_status_code: int or
     ~azure.mgmt.cdn.models.PolicySettingsDefaultCustomBlockResponseStatusCode
    :ivar default_custom_block_response_body: If the action type is block, customer can override
     the response body. The body must be specified in base64 encoding.
    :vartype default_custom_block_response_body: str
    """

    _validation = {
        'default_custom_block_response_body': {'pattern': r'^(?:[A-Za-z0-9+/]{4})*(?:[A-Za-z0-9+/]{2}==|[A-Za-z0-9+/]{3}=|[A-Za-z0-9+/]{4})$'},
    }

    _attribute_map = {
        'enabled_state': {'key': 'enabledState', 'type': 'str'},
        'mode': {'key': 'mode', 'type': 'str'},
        'default_redirect_url': {'key': 'defaultRedirectUrl', 'type': 'str'},
        'default_custom_block_response_status_code': {'key': 'defaultCustomBlockResponseStatusCode', 'type': 'int'},
        'default_custom_block_response_body': {'key': 'defaultCustomBlockResponseBody', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        enabled_state: Optional[Union[str, "PolicyEnabledState"]] = None,
        mode: Optional[Union[str, "PolicyMode"]] = None,
        default_redirect_url: Optional[str] = None,
        default_custom_block_response_status_code: Optional[Union[int, "PolicySettingsDefaultCustomBlockResponseStatusCode"]] = None,
        default_custom_block_response_body: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword enabled_state: describes if the policy is in enabled state or disabled state. Possible
         values include: "Disabled", "Enabled".
        :paramtype enabled_state: str or ~azure.mgmt.cdn.models.PolicyEnabledState
        :keyword mode: Describes if it is in detection mode or prevention mode at policy level.
         Possible values include: "Prevention", "Detection".
        :paramtype mode: str or ~azure.mgmt.cdn.models.PolicyMode
        :keyword default_redirect_url: If action type is redirect, this field represents the default
         redirect URL for the client.
        :paramtype default_redirect_url: str
        :keyword default_custom_block_response_status_code: If the action type is block, this field
         defines the default customer overridable http response status code. Possible values include:
         200, 403, 405, 406, 429.
        :paramtype default_custom_block_response_status_code: int or
         ~azure.mgmt.cdn.models.PolicySettingsDefaultCustomBlockResponseStatusCode
        :keyword default_custom_block_response_body: If the action type is block, customer can override
         the response body. The body must be specified in base64 encoding.
        :paramtype default_custom_block_response_body: str
        """
        super(PolicySettings, self).__init__(**kwargs)
        self.enabled_state = enabled_state
        self.mode = mode
        self.default_redirect_url = default_redirect_url
        self.default_custom_block_response_status_code = default_custom_block_response_status_code
        self.default_custom_block_response_body = default_custom_block_response_body


class PostArgsMatchConditionParameters(msrest.serialization.Model):
    """Defines the parameters for PostArgs match conditions.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar type_name:  Has constant value: "DeliveryRulePostArgsConditionParameters".
    :vartype type_name: str
    :ivar selector: Name of PostArg to be matched.
    :vartype selector: str
    :ivar operator: Required. Describes operator to be matched. Possible values include: "Any",
     "Equal", "Contains", "BeginsWith", "EndsWith", "LessThan", "LessThanOrEqual", "GreaterThan",
     "GreaterThanOrEqual", "RegEx".
    :vartype operator: str or ~azure.mgmt.cdn.models.PostArgsOperator
    :ivar negate_condition: Describes if this is negate condition or not.
    :vartype negate_condition: bool
    :ivar match_values: The match value for the condition of the delivery rule.
    :vartype match_values: list[str]
    :ivar transforms: List of transforms.
    :vartype transforms: list[str or ~azure.mgmt.cdn.models.Transform]
    """

    _validation = {
        'type_name': {'required': True, 'constant': True},
        'operator': {'required': True},
    }

    _attribute_map = {
        'type_name': {'key': 'typeName', 'type': 'str'},
        'selector': {'key': 'selector', 'type': 'str'},
        'operator': {'key': 'operator', 'type': 'str'},
        'negate_condition': {'key': 'negateCondition', 'type': 'bool'},
        'match_values': {'key': 'matchValues', 'type': '[str]'},
        'transforms': {'key': 'transforms', 'type': '[str]'},
    }

    type_name = "DeliveryRulePostArgsConditionParameters"

    def __init__(
        self,
        *,
        operator: Union[str, "PostArgsOperator"],
        selector: Optional[str] = None,
        negate_condition: Optional[bool] = None,
        match_values: Optional[List[str]] = None,
        transforms: Optional[List[Union[str, "Transform"]]] = None,
        **kwargs
    ):
        """
        :keyword selector: Name of PostArg to be matched.
        :paramtype selector: str
        :keyword operator: Required. Describes operator to be matched. Possible values include: "Any",
         "Equal", "Contains", "BeginsWith", "EndsWith", "LessThan", "LessThanOrEqual", "GreaterThan",
         "GreaterThanOrEqual", "RegEx".
        :paramtype operator: str or ~azure.mgmt.cdn.models.PostArgsOperator
        :keyword negate_condition: Describes if this is negate condition or not.
        :paramtype negate_condition: bool
        :keyword match_values: The match value for the condition of the delivery rule.
        :paramtype match_values: list[str]
        :keyword transforms: List of transforms.
        :paramtype transforms: list[str or ~azure.mgmt.cdn.models.Transform]
        """
        super(PostArgsMatchConditionParameters, self).__init__(**kwargs)
        self.selector = selector
        self.operator = operator
        self.negate_condition = negate_condition
        self.match_values = match_values
        self.transforms = transforms


class Profile(TrackedResource):
    """A profile is a logical grouping of endpoints that share the same settings.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar system_data: Read only system data.
    :vartype system_data: ~azure.mgmt.cdn.models.SystemData
    :ivar location: Required. Resource location.
    :vartype location: str
    :ivar tags: A set of tags. Resource tags.
    :vartype tags: dict[str, str]
    :ivar sku: Required. The pricing tier (defines Azure Front Door Standard or Premium or a CDN
     provider, feature list and rate) of the profile.
    :vartype sku: ~azure.mgmt.cdn.models.Sku
    :ivar kind: Kind of the profile. Used by portal to differentiate traditional CDN profile and
     new AFD profile.
    :vartype kind: str
    :ivar resource_state: Resource status of the profile. Possible values include: "Creating",
     "Active", "Deleting", "Disabled".
    :vartype resource_state: str or ~azure.mgmt.cdn.models.ProfileResourceState
    :ivar provisioning_state: Provisioning status of the profile.
    :vartype provisioning_state: str
    :ivar front_door_id: The Id of the frontdoor.
    :vartype front_door_id: str
    :ivar origin_response_timeout_seconds: Send and receive timeout on forwarding request to the
     origin. When timeout is reached, the request fails and returns.
    :vartype origin_response_timeout_seconds: int
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'location': {'required': True},
        'sku': {'required': True},
        'kind': {'readonly': True},
        'resource_state': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'front_door_id': {'readonly': True},
        'origin_response_timeout_seconds': {'minimum': 16},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'sku': {'key': 'sku', 'type': 'Sku'},
        'kind': {'key': 'kind', 'type': 'str'},
        'resource_state': {'key': 'properties.resourceState', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'front_door_id': {'key': 'properties.frontDoorId', 'type': 'str'},
        'origin_response_timeout_seconds': {'key': 'properties.originResponseTimeoutSeconds', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        location: str,
        sku: "Sku",
        tags: Optional[Dict[str, str]] = None,
        origin_response_timeout_seconds: Optional[int] = None,
        **kwargs
    ):
        """
        :keyword location: Required. Resource location.
        :paramtype location: str
        :keyword tags: A set of tags. Resource tags.
        :paramtype tags: dict[str, str]
        :keyword sku: Required. The pricing tier (defines Azure Front Door Standard or Premium or a CDN
         provider, feature list and rate) of the profile.
        :paramtype sku: ~azure.mgmt.cdn.models.Sku
        :keyword origin_response_timeout_seconds: Send and receive timeout on forwarding request to the
         origin. When timeout is reached, the request fails and returns.
        :paramtype origin_response_timeout_seconds: int
        """
        super(Profile, self).__init__(location=location, tags=tags, **kwargs)
        self.sku = sku
        self.kind = None
        self.resource_state = None
        self.provisioning_state = None
        self.front_door_id = None
        self.origin_response_timeout_seconds = origin_response_timeout_seconds


class ProfileListResult(msrest.serialization.Model):
    """Result of the request to list profiles. It contains a list of profile objects and a URL link to get the next set of results.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of CDN profiles within a resource group.
    :vartype value: list[~azure.mgmt.cdn.models.Profile]
    :ivar next_link: URL to get the next set of profile objects if there are any.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Profile]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        next_link: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword next_link: URL to get the next set of profile objects if there are any.
        :paramtype next_link: str
        """
        super(ProfileListResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = next_link


class ProfileUpdateParameters(msrest.serialization.Model):
    """Properties required to update a profile.

    :ivar tags: A set of tags. Profile tags.
    :vartype tags: dict[str, str]
    :ivar origin_response_timeout_seconds: Send and receive timeout on forwarding request to the
     origin. When timeout is reached, the request fails and returns.
    :vartype origin_response_timeout_seconds: int
    """

    _validation = {
        'origin_response_timeout_seconds': {'minimum': 16},
    }

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
        'origin_response_timeout_seconds': {'key': 'properties.originResponseTimeoutSeconds', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        origin_response_timeout_seconds: Optional[int] = None,
        **kwargs
    ):
        """
        :keyword tags: A set of tags. Profile tags.
        :paramtype tags: dict[str, str]
        :keyword origin_response_timeout_seconds: Send and receive timeout on forwarding request to the
         origin. When timeout is reached, the request fails and returns.
        :paramtype origin_response_timeout_seconds: int
        """
        super(ProfileUpdateParameters, self).__init__(**kwargs)
        self.tags = tags
        self.origin_response_timeout_seconds = origin_response_timeout_seconds


class PurgeParameters(msrest.serialization.Model):
    """Parameters required for content purge.

    All required parameters must be populated in order to send to Azure.

    :ivar content_paths: Required. The path to the content to be purged. Can describe a file path
     or a wild card directory.
    :vartype content_paths: list[str]
    """

    _validation = {
        'content_paths': {'required': True},
    }

    _attribute_map = {
        'content_paths': {'key': 'contentPaths', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        content_paths: List[str],
        **kwargs
    ):
        """
        :keyword content_paths: Required. The path to the content to be purged. Can describe a file
         path or a wild card directory.
        :paramtype content_paths: list[str]
        """
        super(PurgeParameters, self).__init__(**kwargs)
        self.content_paths = content_paths


class QueryStringMatchConditionParameters(msrest.serialization.Model):
    """Defines the parameters for QueryString match conditions.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar type_name:  Has constant value: "DeliveryRuleQueryStringConditionParameters".
    :vartype type_name: str
    :ivar operator: Required. Describes operator to be matched. Possible values include: "Any",
     "Equal", "Contains", "BeginsWith", "EndsWith", "LessThan", "LessThanOrEqual", "GreaterThan",
     "GreaterThanOrEqual", "RegEx".
    :vartype operator: str or ~azure.mgmt.cdn.models.QueryStringOperator
    :ivar negate_condition: Describes if this is negate condition or not.
    :vartype negate_condition: bool
    :ivar match_values: The match value for the condition of the delivery rule.
    :vartype match_values: list[str]
    :ivar transforms: List of transforms.
    :vartype transforms: list[str or ~azure.mgmt.cdn.models.Transform]
    """

    _validation = {
        'type_name': {'required': True, 'constant': True},
        'operator': {'required': True},
    }

    _attribute_map = {
        'type_name': {'key': 'typeName', 'type': 'str'},
        'operator': {'key': 'operator', 'type': 'str'},
        'negate_condition': {'key': 'negateCondition', 'type': 'bool'},
        'match_values': {'key': 'matchValues', 'type': '[str]'},
        'transforms': {'key': 'transforms', 'type': '[str]'},
    }

    type_name = "DeliveryRuleQueryStringConditionParameters"

    def __init__(
        self,
        *,
        operator: Union[str, "QueryStringOperator"],
        negate_condition: Optional[bool] = None,
        match_values: Optional[List[str]] = None,
        transforms: Optional[List[Union[str, "Transform"]]] = None,
        **kwargs
    ):
        """
        :keyword operator: Required. Describes operator to be matched. Possible values include: "Any",
         "Equal", "Contains", "BeginsWith", "EndsWith", "LessThan", "LessThanOrEqual", "GreaterThan",
         "GreaterThanOrEqual", "RegEx".
        :paramtype operator: str or ~azure.mgmt.cdn.models.QueryStringOperator
        :keyword negate_condition: Describes if this is negate condition or not.
        :paramtype negate_condition: bool
        :keyword match_values: The match value for the condition of the delivery rule.
        :paramtype match_values: list[str]
        :keyword transforms: List of transforms.
        :paramtype transforms: list[str or ~azure.mgmt.cdn.models.Transform]
        """
        super(QueryStringMatchConditionParameters, self).__init__(**kwargs)
        self.operator = operator
        self.negate_condition = negate_condition
        self.match_values = match_values
        self.transforms = transforms


class RankingsResponse(msrest.serialization.Model):
    """Rankings Response.

    :ivar date_time_begin:
    :vartype date_time_begin: ~datetime.datetime
    :ivar date_time_end:
    :vartype date_time_end: ~datetime.datetime
    :ivar tables:
    :vartype tables: list[~azure.mgmt.cdn.models.RankingsResponseTablesItem]
    """

    _attribute_map = {
        'date_time_begin': {'key': 'dateTimeBegin', 'type': 'iso-8601'},
        'date_time_end': {'key': 'dateTimeEnd', 'type': 'iso-8601'},
        'tables': {'key': 'tables', 'type': '[RankingsResponseTablesItem]'},
    }

    def __init__(
        self,
        *,
        date_time_begin: Optional[datetime.datetime] = None,
        date_time_end: Optional[datetime.datetime] = None,
        tables: Optional[List["RankingsResponseTablesItem"]] = None,
        **kwargs
    ):
        """
        :keyword date_time_begin:
        :paramtype date_time_begin: ~datetime.datetime
        :keyword date_time_end:
        :paramtype date_time_end: ~datetime.datetime
        :keyword tables:
        :paramtype tables: list[~azure.mgmt.cdn.models.RankingsResponseTablesItem]
        """
        super(RankingsResponse, self).__init__(**kwargs)
        self.date_time_begin = date_time_begin
        self.date_time_end = date_time_end
        self.tables = tables


class RankingsResponseTablesItem(msrest.serialization.Model):
    """RankingsResponseTablesItem.

    :ivar ranking:
    :vartype ranking: str
    :ivar data:
    :vartype data: list[~azure.mgmt.cdn.models.RankingsResponseTablesPropertiesItemsItem]
    """

    _attribute_map = {
        'ranking': {'key': 'ranking', 'type': 'str'},
        'data': {'key': 'data', 'type': '[RankingsResponseTablesPropertiesItemsItem]'},
    }

    def __init__(
        self,
        *,
        ranking: Optional[str] = None,
        data: Optional[List["RankingsResponseTablesPropertiesItemsItem"]] = None,
        **kwargs
    ):
        """
        :keyword ranking:
        :paramtype ranking: str
        :keyword data:
        :paramtype data: list[~azure.mgmt.cdn.models.RankingsResponseTablesPropertiesItemsItem]
        """
        super(RankingsResponseTablesItem, self).__init__(**kwargs)
        self.ranking = ranking
        self.data = data


class RankingsResponseTablesPropertiesItemsItem(msrest.serialization.Model):
    """RankingsResponseTablesPropertiesItemsItem.

    :ivar name:
    :vartype name: str
    :ivar metrics:
    :vartype metrics: list[~azure.mgmt.cdn.models.RankingsResponseTablesPropertiesItemsMetricsItem]
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'metrics': {'key': 'metrics', 'type': '[RankingsResponseTablesPropertiesItemsMetricsItem]'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        metrics: Optional[List["RankingsResponseTablesPropertiesItemsMetricsItem"]] = None,
        **kwargs
    ):
        """
        :keyword name:
        :paramtype name: str
        :keyword metrics:
        :paramtype metrics:
         list[~azure.mgmt.cdn.models.RankingsResponseTablesPropertiesItemsMetricsItem]
        """
        super(RankingsResponseTablesPropertiesItemsItem, self).__init__(**kwargs)
        self.name = name
        self.metrics = metrics


class RankingsResponseTablesPropertiesItemsMetricsItem(msrest.serialization.Model):
    """RankingsResponseTablesPropertiesItemsMetricsItem.

    :ivar metric:
    :vartype metric: str
    :ivar value:
    :vartype value: long
    :ivar percentage:
    :vartype percentage: float
    """

    _attribute_map = {
        'metric': {'key': 'metric', 'type': 'str'},
        'value': {'key': 'value', 'type': 'long'},
        'percentage': {'key': 'percentage', 'type': 'float'},
    }

    def __init__(
        self,
        *,
        metric: Optional[str] = None,
        value: Optional[int] = None,
        percentage: Optional[float] = None,
        **kwargs
    ):
        """
        :keyword metric:
        :paramtype metric: str
        :keyword value:
        :paramtype value: long
        :keyword percentage:
        :paramtype percentage: float
        """
        super(RankingsResponseTablesPropertiesItemsMetricsItem, self).__init__(**kwargs)
        self.metric = metric
        self.value = value
        self.percentage = percentage


class RateLimitRule(CustomRule):
    """Defines a rate limiting rule that can be included in a waf policy.

    All required parameters must be populated in order to send to Azure.

    :ivar name: Required. Defines the name of the custom rule.
    :vartype name: str
    :ivar enabled_state: Describes if the custom rule is in enabled or disabled state. Defaults to
     Enabled if not specified. Possible values include: "Disabled", "Enabled".
    :vartype enabled_state: str or ~azure.mgmt.cdn.models.CustomRuleEnabledState
    :ivar priority: Required. Defines in what order this rule be evaluated in the overall list of
     custom rules.
    :vartype priority: int
    :ivar match_conditions: Required. List of match conditions.
    :vartype match_conditions: list[~azure.mgmt.cdn.models.MatchCondition]
    :ivar action: Required. Describes what action to be applied when rule matches. Possible values
     include: "Allow", "Block", "Log", "Redirect".
    :vartype action: str or ~azure.mgmt.cdn.models.ActionType
    :ivar rate_limit_threshold: Required. Defines rate limit threshold.
    :vartype rate_limit_threshold: int
    :ivar rate_limit_duration_in_minutes: Required. Defines rate limit duration. Default is 1
     minute.
    :vartype rate_limit_duration_in_minutes: int
    """

    _validation = {
        'name': {'required': True},
        'priority': {'required': True, 'maximum': 1000, 'minimum': 0},
        'match_conditions': {'required': True},
        'action': {'required': True},
        'rate_limit_threshold': {'required': True, 'minimum': 0},
        'rate_limit_duration_in_minutes': {'required': True, 'maximum': 60, 'minimum': 0},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'enabled_state': {'key': 'enabledState', 'type': 'str'},
        'priority': {'key': 'priority', 'type': 'int'},
        'match_conditions': {'key': 'matchConditions', 'type': '[MatchCondition]'},
        'action': {'key': 'action', 'type': 'str'},
        'rate_limit_threshold': {'key': 'rateLimitThreshold', 'type': 'int'},
        'rate_limit_duration_in_minutes': {'key': 'rateLimitDurationInMinutes', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        name: str,
        priority: int,
        match_conditions: List["MatchCondition"],
        action: Union[str, "ActionType"],
        rate_limit_threshold: int,
        rate_limit_duration_in_minutes: int,
        enabled_state: Optional[Union[str, "CustomRuleEnabledState"]] = None,
        **kwargs
    ):
        """
        :keyword name: Required. Defines the name of the custom rule.
        :paramtype name: str
        :keyword enabled_state: Describes if the custom rule is in enabled or disabled state. Defaults
         to Enabled if not specified. Possible values include: "Disabled", "Enabled".
        :paramtype enabled_state: str or ~azure.mgmt.cdn.models.CustomRuleEnabledState
        :keyword priority: Required. Defines in what order this rule be evaluated in the overall list
         of custom rules.
        :paramtype priority: int
        :keyword match_conditions: Required. List of match conditions.
        :paramtype match_conditions: list[~azure.mgmt.cdn.models.MatchCondition]
        :keyword action: Required. Describes what action to be applied when rule matches. Possible
         values include: "Allow", "Block", "Log", "Redirect".
        :paramtype action: str or ~azure.mgmt.cdn.models.ActionType
        :keyword rate_limit_threshold: Required. Defines rate limit threshold.
        :paramtype rate_limit_threshold: int
        :keyword rate_limit_duration_in_minutes: Required. Defines rate limit duration. Default is 1
         minute.
        :paramtype rate_limit_duration_in_minutes: int
        """
        super(RateLimitRule, self).__init__(name=name, enabled_state=enabled_state, priority=priority, match_conditions=match_conditions, action=action, **kwargs)
        self.rate_limit_threshold = rate_limit_threshold
        self.rate_limit_duration_in_minutes = rate_limit_duration_in_minutes


class RateLimitRuleList(msrest.serialization.Model):
    """Defines contents of rate limit rules.

    :ivar rules: List of rules.
    :vartype rules: list[~azure.mgmt.cdn.models.RateLimitRule]
    """

    _attribute_map = {
        'rules': {'key': 'rules', 'type': '[RateLimitRule]'},
    }

    def __init__(
        self,
        *,
        rules: Optional[List["RateLimitRule"]] = None,
        **kwargs
    ):
        """
        :keyword rules: List of rules.
        :paramtype rules: list[~azure.mgmt.cdn.models.RateLimitRule]
        """
        super(RateLimitRuleList, self).__init__(**kwargs)
        self.rules = rules


class RemoteAddressMatchConditionParameters(msrest.serialization.Model):
    """Defines the parameters for RemoteAddress match conditions.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar type_name:  Has constant value: "DeliveryRuleRemoteAddressConditionParameters".
    :vartype type_name: str
    :ivar operator: Required. Describes operator to be matched. Possible values include: "Any",
     "IPMatch", "GeoMatch".
    :vartype operator: str or ~azure.mgmt.cdn.models.RemoteAddressOperator
    :ivar negate_condition: Describes if this is negate condition or not.
    :vartype negate_condition: bool
    :ivar match_values: Match values to match against. The operator will apply to each value in
     here with OR semantics. If any of them match the variable with the given operator this match
     condition is considered a match.
    :vartype match_values: list[str]
    :ivar transforms: List of transforms.
    :vartype transforms: list[str or ~azure.mgmt.cdn.models.Transform]
    """

    _validation = {
        'type_name': {'required': True, 'constant': True},
        'operator': {'required': True},
    }

    _attribute_map = {
        'type_name': {'key': 'typeName', 'type': 'str'},
        'operator': {'key': 'operator', 'type': 'str'},
        'negate_condition': {'key': 'negateCondition', 'type': 'bool'},
        'match_values': {'key': 'matchValues', 'type': '[str]'},
        'transforms': {'key': 'transforms', 'type': '[str]'},
    }

    type_name = "DeliveryRuleRemoteAddressConditionParameters"

    def __init__(
        self,
        *,
        operator: Union[str, "RemoteAddressOperator"],
        negate_condition: Optional[bool] = None,
        match_values: Optional[List[str]] = None,
        transforms: Optional[List[Union[str, "Transform"]]] = None,
        **kwargs
    ):
        """
        :keyword operator: Required. Describes operator to be matched. Possible values include: "Any",
         "IPMatch", "GeoMatch".
        :paramtype operator: str or ~azure.mgmt.cdn.models.RemoteAddressOperator
        :keyword negate_condition: Describes if this is negate condition or not.
        :paramtype negate_condition: bool
        :keyword match_values: Match values to match against. The operator will apply to each value in
         here with OR semantics. If any of them match the variable with the given operator this match
         condition is considered a match.
        :paramtype match_values: list[str]
        :keyword transforms: List of transforms.
        :paramtype transforms: list[str or ~azure.mgmt.cdn.models.Transform]
        """
        super(RemoteAddressMatchConditionParameters, self).__init__(**kwargs)
        self.operator = operator
        self.negate_condition = negate_condition
        self.match_values = match_values
        self.transforms = transforms


class RequestBodyMatchConditionParameters(msrest.serialization.Model):
    """Defines the parameters for RequestBody match conditions.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar type_name:  Has constant value: "DeliveryRuleRequestBodyConditionParameters".
    :vartype type_name: str
    :ivar operator: Required. Describes operator to be matched. Possible values include: "Any",
     "Equal", "Contains", "BeginsWith", "EndsWith", "LessThan", "LessThanOrEqual", "GreaterThan",
     "GreaterThanOrEqual", "RegEx".
    :vartype operator: str or ~azure.mgmt.cdn.models.RequestBodyOperator
    :ivar negate_condition: Describes if this is negate condition or not.
    :vartype negate_condition: bool
    :ivar match_values: The match value for the condition of the delivery rule.
    :vartype match_values: list[str]
    :ivar transforms: List of transforms.
    :vartype transforms: list[str or ~azure.mgmt.cdn.models.Transform]
    """

    _validation = {
        'type_name': {'required': True, 'constant': True},
        'operator': {'required': True},
    }

    _attribute_map = {
        'type_name': {'key': 'typeName', 'type': 'str'},
        'operator': {'key': 'operator', 'type': 'str'},
        'negate_condition': {'key': 'negateCondition', 'type': 'bool'},
        'match_values': {'key': 'matchValues', 'type': '[str]'},
        'transforms': {'key': 'transforms', 'type': '[str]'},
    }

    type_name = "DeliveryRuleRequestBodyConditionParameters"

    def __init__(
        self,
        *,
        operator: Union[str, "RequestBodyOperator"],
        negate_condition: Optional[bool] = None,
        match_values: Optional[List[str]] = None,
        transforms: Optional[List[Union[str, "Transform"]]] = None,
        **kwargs
    ):
        """
        :keyword operator: Required. Describes operator to be matched. Possible values include: "Any",
         "Equal", "Contains", "BeginsWith", "EndsWith", "LessThan", "LessThanOrEqual", "GreaterThan",
         "GreaterThanOrEqual", "RegEx".
        :paramtype operator: str or ~azure.mgmt.cdn.models.RequestBodyOperator
        :keyword negate_condition: Describes if this is negate condition or not.
        :paramtype negate_condition: bool
        :keyword match_values: The match value for the condition of the delivery rule.
        :paramtype match_values: list[str]
        :keyword transforms: List of transforms.
        :paramtype transforms: list[str or ~azure.mgmt.cdn.models.Transform]
        """
        super(RequestBodyMatchConditionParameters, self).__init__(**kwargs)
        self.operator = operator
        self.negate_condition = negate_condition
        self.match_values = match_values
        self.transforms = transforms


class RequestHeaderMatchConditionParameters(msrest.serialization.Model):
    """Defines the parameters for RequestHeader match conditions.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar type_name:  Has constant value: "DeliveryRuleRequestHeaderConditionParameters".
    :vartype type_name: str
    :ivar selector: Name of Header to be matched.
    :vartype selector: str
    :ivar operator: Required. Describes operator to be matched. Possible values include: "Any",
     "Equal", "Contains", "BeginsWith", "EndsWith", "LessThan", "LessThanOrEqual", "GreaterThan",
     "GreaterThanOrEqual", "RegEx".
    :vartype operator: str or ~azure.mgmt.cdn.models.RequestHeaderOperator
    :ivar negate_condition: Describes if this is negate condition or not.
    :vartype negate_condition: bool
    :ivar match_values: The match value for the condition of the delivery rule.
    :vartype match_values: list[str]
    :ivar transforms: List of transforms.
    :vartype transforms: list[str or ~azure.mgmt.cdn.models.Transform]
    """

    _validation = {
        'type_name': {'required': True, 'constant': True},
        'operator': {'required': True},
    }

    _attribute_map = {
        'type_name': {'key': 'typeName', 'type': 'str'},
        'selector': {'key': 'selector', 'type': 'str'},
        'operator': {'key': 'operator', 'type': 'str'},
        'negate_condition': {'key': 'negateCondition', 'type': 'bool'},
        'match_values': {'key': 'matchValues', 'type': '[str]'},
        'transforms': {'key': 'transforms', 'type': '[str]'},
    }

    type_name = "DeliveryRuleRequestHeaderConditionParameters"

    def __init__(
        self,
        *,
        operator: Union[str, "RequestHeaderOperator"],
        selector: Optional[str] = None,
        negate_condition: Optional[bool] = None,
        match_values: Optional[List[str]] = None,
        transforms: Optional[List[Union[str, "Transform"]]] = None,
        **kwargs
    ):
        """
        :keyword selector: Name of Header to be matched.
        :paramtype selector: str
        :keyword operator: Required. Describes operator to be matched. Possible values include: "Any",
         "Equal", "Contains", "BeginsWith", "EndsWith", "LessThan", "LessThanOrEqual", "GreaterThan",
         "GreaterThanOrEqual", "RegEx".
        :paramtype operator: str or ~azure.mgmt.cdn.models.RequestHeaderOperator
        :keyword negate_condition: Describes if this is negate condition or not.
        :paramtype negate_condition: bool
        :keyword match_values: The match value for the condition of the delivery rule.
        :paramtype match_values: list[str]
        :keyword transforms: List of transforms.
        :paramtype transforms: list[str or ~azure.mgmt.cdn.models.Transform]
        """
        super(RequestHeaderMatchConditionParameters, self).__init__(**kwargs)
        self.selector = selector
        self.operator = operator
        self.negate_condition = negate_condition
        self.match_values = match_values
        self.transforms = transforms


class RequestMethodMatchConditionParameters(msrest.serialization.Model):
    """Defines the parameters for RequestMethod match conditions.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar type_name:  Has constant value: "DeliveryRuleRequestMethodConditionParameters".
    :vartype type_name: str
    :ivar operator: Required. Describes operator to be matched. Possible values include: "Equal".
    :vartype operator: str or ~azure.mgmt.cdn.models.RequestMethodOperator
    :ivar negate_condition: Describes if this is negate condition or not.
    :vartype negate_condition: bool
    :ivar transforms: List of transforms.
    :vartype transforms: list[str or ~azure.mgmt.cdn.models.Transform]
    :ivar match_values: The match value for the condition of the delivery rule.
    :vartype match_values: list[str or
     ~azure.mgmt.cdn.models.RequestMethodMatchConditionParametersMatchValuesItem]
    """

    _validation = {
        'type_name': {'required': True, 'constant': True},
        'operator': {'required': True},
    }

    _attribute_map = {
        'type_name': {'key': 'typeName', 'type': 'str'},
        'operator': {'key': 'operator', 'type': 'str'},
        'negate_condition': {'key': 'negateCondition', 'type': 'bool'},
        'transforms': {'key': 'transforms', 'type': '[str]'},
        'match_values': {'key': 'matchValues', 'type': '[str]'},
    }

    type_name = "DeliveryRuleRequestMethodConditionParameters"

    def __init__(
        self,
        *,
        operator: Union[str, "RequestMethodOperator"],
        negate_condition: Optional[bool] = None,
        transforms: Optional[List[Union[str, "Transform"]]] = None,
        match_values: Optional[List[Union[str, "RequestMethodMatchConditionParametersMatchValuesItem"]]] = None,
        **kwargs
    ):
        """
        :keyword operator: Required. Describes operator to be matched. Possible values include:
         "Equal".
        :paramtype operator: str or ~azure.mgmt.cdn.models.RequestMethodOperator
        :keyword negate_condition: Describes if this is negate condition or not.
        :paramtype negate_condition: bool
        :keyword transforms: List of transforms.
        :paramtype transforms: list[str or ~azure.mgmt.cdn.models.Transform]
        :keyword match_values: The match value for the condition of the delivery rule.
        :paramtype match_values: list[str or
         ~azure.mgmt.cdn.models.RequestMethodMatchConditionParametersMatchValuesItem]
        """
        super(RequestMethodMatchConditionParameters, self).__init__(**kwargs)
        self.operator = operator
        self.negate_condition = negate_condition
        self.transforms = transforms
        self.match_values = match_values


class RequestSchemeMatchConditionParameters(msrest.serialization.Model):
    """Defines the parameters for RequestScheme match conditions.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar type_name:  Has constant value: "DeliveryRuleRequestSchemeConditionParameters".
    :vartype type_name: str
    :ivar operator: Describes operator to be matched. Has constant value: "Equal".
    :vartype operator: str
    :ivar negate_condition: Describes if this is negate condition or not.
    :vartype negate_condition: bool
    :ivar transforms: List of transforms.
    :vartype transforms: list[str or ~azure.mgmt.cdn.models.Transform]
    :ivar match_values: The match value for the condition of the delivery rule.
    :vartype match_values: list[str or
     ~azure.mgmt.cdn.models.RequestSchemeMatchConditionParametersMatchValuesItem]
    """

    _validation = {
        'type_name': {'required': True, 'constant': True},
        'operator': {'required': True, 'constant': True},
    }

    _attribute_map = {
        'type_name': {'key': 'typeName', 'type': 'str'},
        'operator': {'key': 'operator', 'type': 'str'},
        'negate_condition': {'key': 'negateCondition', 'type': 'bool'},
        'transforms': {'key': 'transforms', 'type': '[str]'},
        'match_values': {'key': 'matchValues', 'type': '[str]'},
    }

    type_name = "DeliveryRuleRequestSchemeConditionParameters"
    operator = "Equal"

    def __init__(
        self,
        *,
        negate_condition: Optional[bool] = None,
        transforms: Optional[List[Union[str, "Transform"]]] = None,
        match_values: Optional[List[Union[str, "RequestSchemeMatchConditionParametersMatchValuesItem"]]] = None,
        **kwargs
    ):
        """
        :keyword negate_condition: Describes if this is negate condition or not.
        :paramtype negate_condition: bool
        :keyword transforms: List of transforms.
        :paramtype transforms: list[str or ~azure.mgmt.cdn.models.Transform]
        :keyword match_values: The match value for the condition of the delivery rule.
        :paramtype match_values: list[str or
         ~azure.mgmt.cdn.models.RequestSchemeMatchConditionParametersMatchValuesItem]
        """
        super(RequestSchemeMatchConditionParameters, self).__init__(**kwargs)
        self.negate_condition = negate_condition
        self.transforms = transforms
        self.match_values = match_values


class RequestUriMatchConditionParameters(msrest.serialization.Model):
    """Defines the parameters for RequestUri match conditions.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar type_name:  Has constant value: "DeliveryRuleRequestUriConditionParameters".
    :vartype type_name: str
    :ivar operator: Required. Describes operator to be matched. Possible values include: "Any",
     "Equal", "Contains", "BeginsWith", "EndsWith", "LessThan", "LessThanOrEqual", "GreaterThan",
     "GreaterThanOrEqual", "RegEx".
    :vartype operator: str or ~azure.mgmt.cdn.models.RequestUriOperator
    :ivar negate_condition: Describes if this is negate condition or not.
    :vartype negate_condition: bool
    :ivar match_values: The match value for the condition of the delivery rule.
    :vartype match_values: list[str]
    :ivar transforms: List of transforms.
    :vartype transforms: list[str or ~azure.mgmt.cdn.models.Transform]
    """

    _validation = {
        'type_name': {'required': True, 'constant': True},
        'operator': {'required': True},
    }

    _attribute_map = {
        'type_name': {'key': 'typeName', 'type': 'str'},
        'operator': {'key': 'operator', 'type': 'str'},
        'negate_condition': {'key': 'negateCondition', 'type': 'bool'},
        'match_values': {'key': 'matchValues', 'type': '[str]'},
        'transforms': {'key': 'transforms', 'type': '[str]'},
    }

    type_name = "DeliveryRuleRequestUriConditionParameters"

    def __init__(
        self,
        *,
        operator: Union[str, "RequestUriOperator"],
        negate_condition: Optional[bool] = None,
        match_values: Optional[List[str]] = None,
        transforms: Optional[List[Union[str, "Transform"]]] = None,
        **kwargs
    ):
        """
        :keyword operator: Required. Describes operator to be matched. Possible values include: "Any",
         "Equal", "Contains", "BeginsWith", "EndsWith", "LessThan", "LessThanOrEqual", "GreaterThan",
         "GreaterThanOrEqual", "RegEx".
        :paramtype operator: str or ~azure.mgmt.cdn.models.RequestUriOperator
        :keyword negate_condition: Describes if this is negate condition or not.
        :paramtype negate_condition: bool
        :keyword match_values: The match value for the condition of the delivery rule.
        :paramtype match_values: list[str]
        :keyword transforms: List of transforms.
        :paramtype transforms: list[str or ~azure.mgmt.cdn.models.Transform]
        """
        super(RequestUriMatchConditionParameters, self).__init__(**kwargs)
        self.operator = operator
        self.negate_condition = negate_condition
        self.match_values = match_values
        self.transforms = transforms


class ResourceReference(msrest.serialization.Model):
    """Reference to another resource.

    :ivar id: Resource ID.
    :vartype id: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword id: Resource ID.
        :paramtype id: str
        """
        super(ResourceReference, self).__init__(**kwargs)
        self.id = id


class ResourcesResponse(msrest.serialization.Model):
    """Resources Response.

    :ivar endpoints:
    :vartype endpoints: list[~azure.mgmt.cdn.models.ResourcesResponseEndpointsItem]
    :ivar custom_domains:
    :vartype custom_domains: list[~azure.mgmt.cdn.models.ResourcesResponseCustomDomainsItem]
    """

    _attribute_map = {
        'endpoints': {'key': 'endpoints', 'type': '[ResourcesResponseEndpointsItem]'},
        'custom_domains': {'key': 'customDomains', 'type': '[ResourcesResponseCustomDomainsItem]'},
    }

    def __init__(
        self,
        *,
        endpoints: Optional[List["ResourcesResponseEndpointsItem"]] = None,
        custom_domains: Optional[List["ResourcesResponseCustomDomainsItem"]] = None,
        **kwargs
    ):
        """
        :keyword endpoints:
        :paramtype endpoints: list[~azure.mgmt.cdn.models.ResourcesResponseEndpointsItem]
        :keyword custom_domains:
        :paramtype custom_domains: list[~azure.mgmt.cdn.models.ResourcesResponseCustomDomainsItem]
        """
        super(ResourcesResponse, self).__init__(**kwargs)
        self.endpoints = endpoints
        self.custom_domains = custom_domains


class ResourcesResponseCustomDomainsItem(msrest.serialization.Model):
    """ResourcesResponseCustomDomainsItem.

    :ivar id:
    :vartype id: str
    :ivar name:
    :vartype name: str
    :ivar endpoint_id:
    :vartype endpoint_id: str
    :ivar history:
    :vartype history: bool
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'endpoint_id': {'key': 'endpointId', 'type': 'str'},
        'history': {'key': 'history', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        name: Optional[str] = None,
        endpoint_id: Optional[str] = None,
        history: Optional[bool] = None,
        **kwargs
    ):
        """
        :keyword id:
        :paramtype id: str
        :keyword name:
        :paramtype name: str
        :keyword endpoint_id:
        :paramtype endpoint_id: str
        :keyword history:
        :paramtype history: bool
        """
        super(ResourcesResponseCustomDomainsItem, self).__init__(**kwargs)
        self.id = id
        self.name = name
        self.endpoint_id = endpoint_id
        self.history = history


class ResourcesResponseEndpointsItem(msrest.serialization.Model):
    """ResourcesResponseEndpointsItem.

    :ivar id:
    :vartype id: str
    :ivar name:
    :vartype name: str
    :ivar history:
    :vartype history: bool
    :ivar custom_domains:
    :vartype custom_domains:
     list[~azure.mgmt.cdn.models.ResourcesResponseEndpointsPropertiesItemsItem]
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'history': {'key': 'history', 'type': 'bool'},
        'custom_domains': {'key': 'customDomains', 'type': '[ResourcesResponseEndpointsPropertiesItemsItem]'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        name: Optional[str] = None,
        history: Optional[bool] = None,
        custom_domains: Optional[List["ResourcesResponseEndpointsPropertiesItemsItem"]] = None,
        **kwargs
    ):
        """
        :keyword id:
        :paramtype id: str
        :keyword name:
        :paramtype name: str
        :keyword history:
        :paramtype history: bool
        :keyword custom_domains:
        :paramtype custom_domains:
         list[~azure.mgmt.cdn.models.ResourcesResponseEndpointsPropertiesItemsItem]
        """
        super(ResourcesResponseEndpointsItem, self).__init__(**kwargs)
        self.id = id
        self.name = name
        self.history = history
        self.custom_domains = custom_domains


class ResourcesResponseEndpointsPropertiesItemsItem(msrest.serialization.Model):
    """ResourcesResponseEndpointsPropertiesItemsItem.

    :ivar id:
    :vartype id: str
    :ivar name:
    :vartype name: str
    :ivar endpoint_id:
    :vartype endpoint_id: str
    :ivar history:
    :vartype history: bool
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'endpoint_id': {'key': 'endpointId', 'type': 'str'},
        'history': {'key': 'history', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        name: Optional[str] = None,
        endpoint_id: Optional[str] = None,
        history: Optional[bool] = None,
        **kwargs
    ):
        """
        :keyword id:
        :paramtype id: str
        :keyword name:
        :paramtype name: str
        :keyword endpoint_id:
        :paramtype endpoint_id: str
        :keyword history:
        :paramtype history: bool
        """
        super(ResourcesResponseEndpointsPropertiesItemsItem, self).__init__(**kwargs)
        self.id = id
        self.name = name
        self.endpoint_id = endpoint_id
        self.history = history


class ResourceUsage(msrest.serialization.Model):
    """Output of check resource usage API.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar resource_type: Resource type for which the usage is provided.
    :vartype resource_type: str
    :ivar unit: Unit of the usage. e.g. Count.
    :vartype unit: str
    :ivar current_value: Actual value of usage on the specified resource type.
    :vartype current_value: int
    :ivar limit: Quota of the specified resource type.
    :vartype limit: int
    """

    _validation = {
        'resource_type': {'readonly': True},
        'unit': {'readonly': True},
        'current_value': {'readonly': True},
        'limit': {'readonly': True},
    }

    _attribute_map = {
        'resource_type': {'key': 'resourceType', 'type': 'str'},
        'unit': {'key': 'unit', 'type': 'str'},
        'current_value': {'key': 'currentValue', 'type': 'int'},
        'limit': {'key': 'limit', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(ResourceUsage, self).__init__(**kwargs)
        self.resource_type = None
        self.unit = None
        self.current_value = None
        self.limit = None


class ResourceUsageListResult(msrest.serialization.Model):
    """Output of check resource usage API.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of resource usages.
    :vartype value: list[~azure.mgmt.cdn.models.ResourceUsage]
    :ivar next_link: URL to get the next set of custom domain objects if there are any.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ResourceUsage]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        next_link: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword next_link: URL to get the next set of custom domain objects if there are any.
        :paramtype next_link: str
        """
        super(ResourceUsageListResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = next_link


class ResponseBasedOriginErrorDetectionParameters(msrest.serialization.Model):
    """The JSON object that contains the properties to determine origin health using real requests/responses.

    :ivar response_based_detected_error_types: Type of response errors for real user requests for
     which origin will be deemed unhealthy. Possible values include: "None", "TcpErrorsOnly",
     "TcpAndHttpErrors".
    :vartype response_based_detected_error_types: str or
     ~azure.mgmt.cdn.models.ResponseBasedDetectedErrorTypes
    :ivar response_based_failover_threshold_percentage: The percentage of failed requests in the
     sample where failover should trigger.
    :vartype response_based_failover_threshold_percentage: int
    :ivar http_error_ranges: The list of Http status code ranges that are considered as server
     errors for origin and it is marked as unhealthy.
    :vartype http_error_ranges: list[~azure.mgmt.cdn.models.HttpErrorRangeParameters]
    """

    _validation = {
        'response_based_failover_threshold_percentage': {'maximum': 100, 'minimum': 0},
    }

    _attribute_map = {
        'response_based_detected_error_types': {'key': 'responseBasedDetectedErrorTypes', 'type': 'str'},
        'response_based_failover_threshold_percentage': {'key': 'responseBasedFailoverThresholdPercentage', 'type': 'int'},
        'http_error_ranges': {'key': 'httpErrorRanges', 'type': '[HttpErrorRangeParameters]'},
    }

    def __init__(
        self,
        *,
        response_based_detected_error_types: Optional[Union[str, "ResponseBasedDetectedErrorTypes"]] = None,
        response_based_failover_threshold_percentage: Optional[int] = None,
        http_error_ranges: Optional[List["HttpErrorRangeParameters"]] = None,
        **kwargs
    ):
        """
        :keyword response_based_detected_error_types: Type of response errors for real user requests
         for which origin will be deemed unhealthy. Possible values include: "None", "TcpErrorsOnly",
         "TcpAndHttpErrors".
        :paramtype response_based_detected_error_types: str or
         ~azure.mgmt.cdn.models.ResponseBasedDetectedErrorTypes
        :keyword response_based_failover_threshold_percentage: The percentage of failed requests in the
         sample where failover should trigger.
        :paramtype response_based_failover_threshold_percentage: int
        :keyword http_error_ranges: The list of Http status code ranges that are considered as server
         errors for origin and it is marked as unhealthy.
        :paramtype http_error_ranges: list[~azure.mgmt.cdn.models.HttpErrorRangeParameters]
        """
        super(ResponseBasedOriginErrorDetectionParameters, self).__init__(**kwargs)
        self.response_based_detected_error_types = response_based_detected_error_types
        self.response_based_failover_threshold_percentage = response_based_failover_threshold_percentage
        self.http_error_ranges = http_error_ranges


class Route(ProxyResource):
    """Friendly Routes name mapping to the any Routes or secret related information.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar system_data: Read only system data.
    :vartype system_data: ~azure.mgmt.cdn.models.SystemData
    :ivar endpoint_name: The name of the endpoint which holds the route.
    :vartype endpoint_name: str
    :ivar custom_domains: Domains referenced by this endpoint.
    :vartype custom_domains: list[~azure.mgmt.cdn.models.ActivatedResourceReference]
    :ivar origin_group: A reference to the origin group.
    :vartype origin_group: ~azure.mgmt.cdn.models.ResourceReference
    :ivar origin_path: A directory path on the origin that AzureFrontDoor can use to retrieve
     content from, e.g. contoso.cloudapp.net/originpath.
    :vartype origin_path: str
    :ivar rule_sets: rule sets referenced by this endpoint.
    :vartype rule_sets: list[~azure.mgmt.cdn.models.ResourceReference]
    :ivar supported_protocols: List of supported protocols for this route.
    :vartype supported_protocols: list[str or ~azure.mgmt.cdn.models.AFDEndpointProtocols]
    :ivar patterns_to_match: The route patterns of the rule.
    :vartype patterns_to_match: list[str]
    :ivar cache_configuration: The caching configuration for this route. To disable caching, do not
     provide a cacheConfiguration object.
    :vartype cache_configuration: ~azure.mgmt.cdn.models.AfdRouteCacheConfiguration
    :ivar forwarding_protocol: Protocol this rule will use when forwarding traffic to backends.
     Possible values include: "HttpOnly", "HttpsOnly", "MatchRequest".
    :vartype forwarding_protocol: str or ~azure.mgmt.cdn.models.ForwardingProtocol
    :ivar link_to_default_domain: whether this route will be linked to the default endpoint domain.
     Possible values include: "Enabled", "Disabled".
    :vartype link_to_default_domain: str or ~azure.mgmt.cdn.models.LinkToDefaultDomain
    :ivar https_redirect: Whether to automatically redirect HTTP traffic to HTTPS traffic. Note
     that this is a easy way to set up this rule and it will be the first rule that gets executed.
     Possible values include: "Enabled", "Disabled".
    :vartype https_redirect: str or ~azure.mgmt.cdn.models.HttpsRedirect
    :ivar enabled_state: Whether to enable use of this rule. Permitted values are 'Enabled' or
     'Disabled'. Possible values include: "Enabled", "Disabled".
    :vartype enabled_state: str or ~azure.mgmt.cdn.models.EnabledState
    :ivar provisioning_state: Provisioning status. Possible values include: "Succeeded", "Failed",
     "Updating", "Deleting", "Creating".
    :vartype provisioning_state: str or ~azure.mgmt.cdn.models.AfdProvisioningState
    :ivar deployment_status: Possible values include: "NotStarted", "InProgress", "Succeeded",
     "Failed".
    :vartype deployment_status: str or ~azure.mgmt.cdn.models.DeploymentStatus
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'endpoint_name': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'deployment_status': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'endpoint_name': {'key': 'properties.endpointName', 'type': 'str'},
        'custom_domains': {'key': 'properties.customDomains', 'type': '[ActivatedResourceReference]'},
        'origin_group': {'key': 'properties.originGroup', 'type': 'ResourceReference'},
        'origin_path': {'key': 'properties.originPath', 'type': 'str'},
        'rule_sets': {'key': 'properties.ruleSets', 'type': '[ResourceReference]'},
        'supported_protocols': {'key': 'properties.supportedProtocols', 'type': '[str]'},
        'patterns_to_match': {'key': 'properties.patternsToMatch', 'type': '[str]'},
        'cache_configuration': {'key': 'properties.cacheConfiguration', 'type': 'AfdRouteCacheConfiguration'},
        'forwarding_protocol': {'key': 'properties.forwardingProtocol', 'type': 'str'},
        'link_to_default_domain': {'key': 'properties.linkToDefaultDomain', 'type': 'str'},
        'https_redirect': {'key': 'properties.httpsRedirect', 'type': 'str'},
        'enabled_state': {'key': 'properties.enabledState', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'deployment_status': {'key': 'properties.deploymentStatus', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        custom_domains: Optional[List["ActivatedResourceReference"]] = None,
        origin_group: Optional["ResourceReference"] = None,
        origin_path: Optional[str] = None,
        rule_sets: Optional[List["ResourceReference"]] = None,
        supported_protocols: Optional[List[Union[str, "AFDEndpointProtocols"]]] = None,
        patterns_to_match: Optional[List[str]] = None,
        cache_configuration: Optional["AfdRouteCacheConfiguration"] = None,
        forwarding_protocol: Optional[Union[str, "ForwardingProtocol"]] = None,
        link_to_default_domain: Optional[Union[str, "LinkToDefaultDomain"]] = None,
        https_redirect: Optional[Union[str, "HttpsRedirect"]] = None,
        enabled_state: Optional[Union[str, "EnabledState"]] = None,
        **kwargs
    ):
        """
        :keyword custom_domains: Domains referenced by this endpoint.
        :paramtype custom_domains: list[~azure.mgmt.cdn.models.ActivatedResourceReference]
        :keyword origin_group: A reference to the origin group.
        :paramtype origin_group: ~azure.mgmt.cdn.models.ResourceReference
        :keyword origin_path: A directory path on the origin that AzureFrontDoor can use to retrieve
         content from, e.g. contoso.cloudapp.net/originpath.
        :paramtype origin_path: str
        :keyword rule_sets: rule sets referenced by this endpoint.
        :paramtype rule_sets: list[~azure.mgmt.cdn.models.ResourceReference]
        :keyword supported_protocols: List of supported protocols for this route.
        :paramtype supported_protocols: list[str or ~azure.mgmt.cdn.models.AFDEndpointProtocols]
        :keyword patterns_to_match: The route patterns of the rule.
        :paramtype patterns_to_match: list[str]
        :keyword cache_configuration: The caching configuration for this route. To disable caching, do
         not provide a cacheConfiguration object.
        :paramtype cache_configuration: ~azure.mgmt.cdn.models.AfdRouteCacheConfiguration
        :keyword forwarding_protocol: Protocol this rule will use when forwarding traffic to backends.
         Possible values include: "HttpOnly", "HttpsOnly", "MatchRequest".
        :paramtype forwarding_protocol: str or ~azure.mgmt.cdn.models.ForwardingProtocol
        :keyword link_to_default_domain: whether this route will be linked to the default endpoint
         domain. Possible values include: "Enabled", "Disabled".
        :paramtype link_to_default_domain: str or ~azure.mgmt.cdn.models.LinkToDefaultDomain
        :keyword https_redirect: Whether to automatically redirect HTTP traffic to HTTPS traffic. Note
         that this is a easy way to set up this rule and it will be the first rule that gets executed.
         Possible values include: "Enabled", "Disabled".
        :paramtype https_redirect: str or ~azure.mgmt.cdn.models.HttpsRedirect
        :keyword enabled_state: Whether to enable use of this rule. Permitted values are 'Enabled' or
         'Disabled'. Possible values include: "Enabled", "Disabled".
        :paramtype enabled_state: str or ~azure.mgmt.cdn.models.EnabledState
        """
        super(Route, self).__init__(**kwargs)
        self.endpoint_name = None
        self.custom_domains = custom_domains
        self.origin_group = origin_group
        self.origin_path = origin_path
        self.rule_sets = rule_sets
        self.supported_protocols = supported_protocols
        self.patterns_to_match = patterns_to_match
        self.cache_configuration = cache_configuration
        self.forwarding_protocol = forwarding_protocol
        self.link_to_default_domain = link_to_default_domain
        self.https_redirect = https_redirect
        self.enabled_state = enabled_state
        self.provisioning_state = None
        self.deployment_status = None


class RouteConfigurationOverrideActionParameters(msrest.serialization.Model):
    """Defines the parameters for the route configuration override action.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar type_name:  Has constant value: "DeliveryRuleRouteConfigurationOverrideActionParameters".
    :vartype type_name: str
    :ivar origin_group_override: A reference to the origin group override configuration. Leave
     empty to use the default origin group on route.
    :vartype origin_group_override: ~azure.mgmt.cdn.models.OriginGroupOverride
    :ivar cache_configuration: The caching configuration associated with this rule. To disable
     caching, do not provide a cacheConfiguration object.
    :vartype cache_configuration: ~azure.mgmt.cdn.models.CacheConfiguration
    """

    _validation = {
        'type_name': {'required': True, 'constant': True},
    }

    _attribute_map = {
        'type_name': {'key': 'typeName', 'type': 'str'},
        'origin_group_override': {'key': 'originGroupOverride', 'type': 'OriginGroupOverride'},
        'cache_configuration': {'key': 'cacheConfiguration', 'type': 'CacheConfiguration'},
    }

    type_name = "DeliveryRuleRouteConfigurationOverrideActionParameters"

    def __init__(
        self,
        *,
        origin_group_override: Optional["OriginGroupOverride"] = None,
        cache_configuration: Optional["CacheConfiguration"] = None,
        **kwargs
    ):
        """
        :keyword origin_group_override: A reference to the origin group override configuration. Leave
         empty to use the default origin group on route.
        :paramtype origin_group_override: ~azure.mgmt.cdn.models.OriginGroupOverride
        :keyword cache_configuration: The caching configuration associated with this rule. To disable
         caching, do not provide a cacheConfiguration object.
        :paramtype cache_configuration: ~azure.mgmt.cdn.models.CacheConfiguration
        """
        super(RouteConfigurationOverrideActionParameters, self).__init__(**kwargs)
        self.origin_group_override = origin_group_override
        self.cache_configuration = cache_configuration


class RouteListResult(msrest.serialization.Model):
    """Result of the request to list routes. It contains a list of route objects and a URL link to get the next set of results.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of AzureFrontDoor routes within a profile.
    :vartype value: list[~azure.mgmt.cdn.models.Route]
    :ivar next_link: URL to get the next set of route objects if there are any.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Route]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        next_link: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword next_link: URL to get the next set of route objects if there are any.
        :paramtype next_link: str
        """
        super(RouteListResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = next_link


class RouteUpdatePropertiesParameters(msrest.serialization.Model):
    """The JSON object that contains the properties of the domain to create.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar endpoint_name: The name of the endpoint which holds the route.
    :vartype endpoint_name: str
    :ivar custom_domains: Domains referenced by this endpoint.
    :vartype custom_domains: list[~azure.mgmt.cdn.models.ActivatedResourceReference]
    :ivar origin_group: A reference to the origin group.
    :vartype origin_group: ~azure.mgmt.cdn.models.ResourceReference
    :ivar origin_path: A directory path on the origin that AzureFrontDoor can use to retrieve
     content from, e.g. contoso.cloudapp.net/originpath.
    :vartype origin_path: str
    :ivar rule_sets: rule sets referenced by this endpoint.
    :vartype rule_sets: list[~azure.mgmt.cdn.models.ResourceReference]
    :ivar supported_protocols: List of supported protocols for this route.
    :vartype supported_protocols: list[str or ~azure.mgmt.cdn.models.AFDEndpointProtocols]
    :ivar patterns_to_match: The route patterns of the rule.
    :vartype patterns_to_match: list[str]
    :ivar cache_configuration: The caching configuration for this route. To disable caching, do not
     provide a cacheConfiguration object.
    :vartype cache_configuration: ~azure.mgmt.cdn.models.AfdRouteCacheConfiguration
    :ivar forwarding_protocol: Protocol this rule will use when forwarding traffic to backends.
     Possible values include: "HttpOnly", "HttpsOnly", "MatchRequest".
    :vartype forwarding_protocol: str or ~azure.mgmt.cdn.models.ForwardingProtocol
    :ivar link_to_default_domain: whether this route will be linked to the default endpoint domain.
     Possible values include: "Enabled", "Disabled".
    :vartype link_to_default_domain: str or ~azure.mgmt.cdn.models.LinkToDefaultDomain
    :ivar https_redirect: Whether to automatically redirect HTTP traffic to HTTPS traffic. Note
     that this is a easy way to set up this rule and it will be the first rule that gets executed.
     Possible values include: "Enabled", "Disabled".
    :vartype https_redirect: str or ~azure.mgmt.cdn.models.HttpsRedirect
    :ivar enabled_state: Whether to enable use of this rule. Permitted values are 'Enabled' or
     'Disabled'. Possible values include: "Enabled", "Disabled".
    :vartype enabled_state: str or ~azure.mgmt.cdn.models.EnabledState
    """

    _validation = {
        'endpoint_name': {'readonly': True},
    }

    _attribute_map = {
        'endpoint_name': {'key': 'endpointName', 'type': 'str'},
        'custom_domains': {'key': 'customDomains', 'type': '[ActivatedResourceReference]'},
        'origin_group': {'key': 'originGroup', 'type': 'ResourceReference'},
        'origin_path': {'key': 'originPath', 'type': 'str'},
        'rule_sets': {'key': 'ruleSets', 'type': '[ResourceReference]'},
        'supported_protocols': {'key': 'supportedProtocols', 'type': '[str]'},
        'patterns_to_match': {'key': 'patternsToMatch', 'type': '[str]'},
        'cache_configuration': {'key': 'cacheConfiguration', 'type': 'AfdRouteCacheConfiguration'},
        'forwarding_protocol': {'key': 'forwardingProtocol', 'type': 'str'},
        'link_to_default_domain': {'key': 'linkToDefaultDomain', 'type': 'str'},
        'https_redirect': {'key': 'httpsRedirect', 'type': 'str'},
        'enabled_state': {'key': 'enabledState', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        custom_domains: Optional[List["ActivatedResourceReference"]] = None,
        origin_group: Optional["ResourceReference"] = None,
        origin_path: Optional[str] = None,
        rule_sets: Optional[List["ResourceReference"]] = None,
        supported_protocols: Optional[List[Union[str, "AFDEndpointProtocols"]]] = None,
        patterns_to_match: Optional[List[str]] = None,
        cache_configuration: Optional["AfdRouteCacheConfiguration"] = None,
        forwarding_protocol: Optional[Union[str, "ForwardingProtocol"]] = None,
        link_to_default_domain: Optional[Union[str, "LinkToDefaultDomain"]] = None,
        https_redirect: Optional[Union[str, "HttpsRedirect"]] = None,
        enabled_state: Optional[Union[str, "EnabledState"]] = None,
        **kwargs
    ):
        """
        :keyword custom_domains: Domains referenced by this endpoint.
        :paramtype custom_domains: list[~azure.mgmt.cdn.models.ActivatedResourceReference]
        :keyword origin_group: A reference to the origin group.
        :paramtype origin_group: ~azure.mgmt.cdn.models.ResourceReference
        :keyword origin_path: A directory path on the origin that AzureFrontDoor can use to retrieve
         content from, e.g. contoso.cloudapp.net/originpath.
        :paramtype origin_path: str
        :keyword rule_sets: rule sets referenced by this endpoint.
        :paramtype rule_sets: list[~azure.mgmt.cdn.models.ResourceReference]
        :keyword supported_protocols: List of supported protocols for this route.
        :paramtype supported_protocols: list[str or ~azure.mgmt.cdn.models.AFDEndpointProtocols]
        :keyword patterns_to_match: The route patterns of the rule.
        :paramtype patterns_to_match: list[str]
        :keyword cache_configuration: The caching configuration for this route. To disable caching, do
         not provide a cacheConfiguration object.
        :paramtype cache_configuration: ~azure.mgmt.cdn.models.AfdRouteCacheConfiguration
        :keyword forwarding_protocol: Protocol this rule will use when forwarding traffic to backends.
         Possible values include: "HttpOnly", "HttpsOnly", "MatchRequest".
        :paramtype forwarding_protocol: str or ~azure.mgmt.cdn.models.ForwardingProtocol
        :keyword link_to_default_domain: whether this route will be linked to the default endpoint
         domain. Possible values include: "Enabled", "Disabled".
        :paramtype link_to_default_domain: str or ~azure.mgmt.cdn.models.LinkToDefaultDomain
        :keyword https_redirect: Whether to automatically redirect HTTP traffic to HTTPS traffic. Note
         that this is a easy way to set up this rule and it will be the first rule that gets executed.
         Possible values include: "Enabled", "Disabled".
        :paramtype https_redirect: str or ~azure.mgmt.cdn.models.HttpsRedirect
        :keyword enabled_state: Whether to enable use of this rule. Permitted values are 'Enabled' or
         'Disabled'. Possible values include: "Enabled", "Disabled".
        :paramtype enabled_state: str or ~azure.mgmt.cdn.models.EnabledState
        """
        super(RouteUpdatePropertiesParameters, self).__init__(**kwargs)
        self.endpoint_name = None
        self.custom_domains = custom_domains
        self.origin_group = origin_group
        self.origin_path = origin_path
        self.rule_sets = rule_sets
        self.supported_protocols = supported_protocols
        self.patterns_to_match = patterns_to_match
        self.cache_configuration = cache_configuration
        self.forwarding_protocol = forwarding_protocol
        self.link_to_default_domain = link_to_default_domain
        self.https_redirect = https_redirect
        self.enabled_state = enabled_state


class RouteProperties(AFDStateProperties, RouteUpdatePropertiesParameters):
    """The JSON object that contains the properties of the Routes to create.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar endpoint_name: The name of the endpoint which holds the route.
    :vartype endpoint_name: str
    :ivar custom_domains: Domains referenced by this endpoint.
    :vartype custom_domains: list[~azure.mgmt.cdn.models.ActivatedResourceReference]
    :ivar origin_group: A reference to the origin group.
    :vartype origin_group: ~azure.mgmt.cdn.models.ResourceReference
    :ivar origin_path: A directory path on the origin that AzureFrontDoor can use to retrieve
     content from, e.g. contoso.cloudapp.net/originpath.
    :vartype origin_path: str
    :ivar rule_sets: rule sets referenced by this endpoint.
    :vartype rule_sets: list[~azure.mgmt.cdn.models.ResourceReference]
    :ivar supported_protocols: List of supported protocols for this route.
    :vartype supported_protocols: list[str or ~azure.mgmt.cdn.models.AFDEndpointProtocols]
    :ivar patterns_to_match: The route patterns of the rule.
    :vartype patterns_to_match: list[str]
    :ivar cache_configuration: The caching configuration for this route. To disable caching, do not
     provide a cacheConfiguration object.
    :vartype cache_configuration: ~azure.mgmt.cdn.models.AfdRouteCacheConfiguration
    :ivar forwarding_protocol: Protocol this rule will use when forwarding traffic to backends.
     Possible values include: "HttpOnly", "HttpsOnly", "MatchRequest".
    :vartype forwarding_protocol: str or ~azure.mgmt.cdn.models.ForwardingProtocol
    :ivar link_to_default_domain: whether this route will be linked to the default endpoint domain.
     Possible values include: "Enabled", "Disabled".
    :vartype link_to_default_domain: str or ~azure.mgmt.cdn.models.LinkToDefaultDomain
    :ivar https_redirect: Whether to automatically redirect HTTP traffic to HTTPS traffic. Note
     that this is a easy way to set up this rule and it will be the first rule that gets executed.
     Possible values include: "Enabled", "Disabled".
    :vartype https_redirect: str or ~azure.mgmt.cdn.models.HttpsRedirect
    :ivar enabled_state: Whether to enable use of this rule. Permitted values are 'Enabled' or
     'Disabled'. Possible values include: "Enabled", "Disabled".
    :vartype enabled_state: str or ~azure.mgmt.cdn.models.EnabledState
    :ivar provisioning_state: Provisioning status. Possible values include: "Succeeded", "Failed",
     "Updating", "Deleting", "Creating".
    :vartype provisioning_state: str or ~azure.mgmt.cdn.models.AfdProvisioningState
    :ivar deployment_status: Possible values include: "NotStarted", "InProgress", "Succeeded",
     "Failed".
    :vartype deployment_status: str or ~azure.mgmt.cdn.models.DeploymentStatus
    """

    _validation = {
        'endpoint_name': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'deployment_status': {'readonly': True},
    }

    _attribute_map = {
        'endpoint_name': {'key': 'endpointName', 'type': 'str'},
        'custom_domains': {'key': 'customDomains', 'type': '[ActivatedResourceReference]'},
        'origin_group': {'key': 'originGroup', 'type': 'ResourceReference'},
        'origin_path': {'key': 'originPath', 'type': 'str'},
        'rule_sets': {'key': 'ruleSets', 'type': '[ResourceReference]'},
        'supported_protocols': {'key': 'supportedProtocols', 'type': '[str]'},
        'patterns_to_match': {'key': 'patternsToMatch', 'type': '[str]'},
        'cache_configuration': {'key': 'cacheConfiguration', 'type': 'AfdRouteCacheConfiguration'},
        'forwarding_protocol': {'key': 'forwardingProtocol', 'type': 'str'},
        'link_to_default_domain': {'key': 'linkToDefaultDomain', 'type': 'str'},
        'https_redirect': {'key': 'httpsRedirect', 'type': 'str'},
        'enabled_state': {'key': 'enabledState', 'type': 'str'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
        'deployment_status': {'key': 'deploymentStatus', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        custom_domains: Optional[List["ActivatedResourceReference"]] = None,
        origin_group: Optional["ResourceReference"] = None,
        origin_path: Optional[str] = None,
        rule_sets: Optional[List["ResourceReference"]] = None,
        supported_protocols: Optional[List[Union[str, "AFDEndpointProtocols"]]] = None,
        patterns_to_match: Optional[List[str]] = None,
        cache_configuration: Optional["AfdRouteCacheConfiguration"] = None,
        forwarding_protocol: Optional[Union[str, "ForwardingProtocol"]] = None,
        link_to_default_domain: Optional[Union[str, "LinkToDefaultDomain"]] = None,
        https_redirect: Optional[Union[str, "HttpsRedirect"]] = None,
        enabled_state: Optional[Union[str, "EnabledState"]] = None,
        **kwargs
    ):
        """
        :keyword custom_domains: Domains referenced by this endpoint.
        :paramtype custom_domains: list[~azure.mgmt.cdn.models.ActivatedResourceReference]
        :keyword origin_group: A reference to the origin group.
        :paramtype origin_group: ~azure.mgmt.cdn.models.ResourceReference
        :keyword origin_path: A directory path on the origin that AzureFrontDoor can use to retrieve
         content from, e.g. contoso.cloudapp.net/originpath.
        :paramtype origin_path: str
        :keyword rule_sets: rule sets referenced by this endpoint.
        :paramtype rule_sets: list[~azure.mgmt.cdn.models.ResourceReference]
        :keyword supported_protocols: List of supported protocols for this route.
        :paramtype supported_protocols: list[str or ~azure.mgmt.cdn.models.AFDEndpointProtocols]
        :keyword patterns_to_match: The route patterns of the rule.
        :paramtype patterns_to_match: list[str]
        :keyword cache_configuration: The caching configuration for this route. To disable caching, do
         not provide a cacheConfiguration object.
        :paramtype cache_configuration: ~azure.mgmt.cdn.models.AfdRouteCacheConfiguration
        :keyword forwarding_protocol: Protocol this rule will use when forwarding traffic to backends.
         Possible values include: "HttpOnly", "HttpsOnly", "MatchRequest".
        :paramtype forwarding_protocol: str or ~azure.mgmt.cdn.models.ForwardingProtocol
        :keyword link_to_default_domain: whether this route will be linked to the default endpoint
         domain. Possible values include: "Enabled", "Disabled".
        :paramtype link_to_default_domain: str or ~azure.mgmt.cdn.models.LinkToDefaultDomain
        :keyword https_redirect: Whether to automatically redirect HTTP traffic to HTTPS traffic. Note
         that this is a easy way to set up this rule and it will be the first rule that gets executed.
         Possible values include: "Enabled", "Disabled".
        :paramtype https_redirect: str or ~azure.mgmt.cdn.models.HttpsRedirect
        :keyword enabled_state: Whether to enable use of this rule. Permitted values are 'Enabled' or
         'Disabled'. Possible values include: "Enabled", "Disabled".
        :paramtype enabled_state: str or ~azure.mgmt.cdn.models.EnabledState
        """
        super(RouteProperties, self).__init__(custom_domains=custom_domains, origin_group=origin_group, origin_path=origin_path, rule_sets=rule_sets, supported_protocols=supported_protocols, patterns_to_match=patterns_to_match, cache_configuration=cache_configuration, forwarding_protocol=forwarding_protocol, link_to_default_domain=link_to_default_domain, https_redirect=https_redirect, enabled_state=enabled_state, **kwargs)
        self.endpoint_name = None
        self.custom_domains = custom_domains
        self.origin_group = origin_group
        self.origin_path = origin_path
        self.rule_sets = rule_sets
        self.supported_protocols = supported_protocols
        self.patterns_to_match = patterns_to_match
        self.cache_configuration = cache_configuration
        self.forwarding_protocol = forwarding_protocol
        self.link_to_default_domain = link_to_default_domain
        self.https_redirect = https_redirect
        self.enabled_state = enabled_state
        self.provisioning_state = None
        self.deployment_status = None


class RouteUpdateParameters(msrest.serialization.Model):
    """The domain JSON object required for domain creation or update.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar endpoint_name: The name of the endpoint which holds the route.
    :vartype endpoint_name: str
    :ivar custom_domains: Domains referenced by this endpoint.
    :vartype custom_domains: list[~azure.mgmt.cdn.models.ActivatedResourceReference]
    :ivar origin_group: A reference to the origin group.
    :vartype origin_group: ~azure.mgmt.cdn.models.ResourceReference
    :ivar origin_path: A directory path on the origin that AzureFrontDoor can use to retrieve
     content from, e.g. contoso.cloudapp.net/originpath.
    :vartype origin_path: str
    :ivar rule_sets: rule sets referenced by this endpoint.
    :vartype rule_sets: list[~azure.mgmt.cdn.models.ResourceReference]
    :ivar supported_protocols: List of supported protocols for this route.
    :vartype supported_protocols: list[str or ~azure.mgmt.cdn.models.AFDEndpointProtocols]
    :ivar patterns_to_match: The route patterns of the rule.
    :vartype patterns_to_match: list[str]
    :ivar cache_configuration: The caching configuration for this route. To disable caching, do not
     provide a cacheConfiguration object.
    :vartype cache_configuration: ~azure.mgmt.cdn.models.AfdRouteCacheConfiguration
    :ivar forwarding_protocol: Protocol this rule will use when forwarding traffic to backends.
     Possible values include: "HttpOnly", "HttpsOnly", "MatchRequest".
    :vartype forwarding_protocol: str or ~azure.mgmt.cdn.models.ForwardingProtocol
    :ivar link_to_default_domain: whether this route will be linked to the default endpoint domain.
     Possible values include: "Enabled", "Disabled".
    :vartype link_to_default_domain: str or ~azure.mgmt.cdn.models.LinkToDefaultDomain
    :ivar https_redirect: Whether to automatically redirect HTTP traffic to HTTPS traffic. Note
     that this is a easy way to set up this rule and it will be the first rule that gets executed.
     Possible values include: "Enabled", "Disabled".
    :vartype https_redirect: str or ~azure.mgmt.cdn.models.HttpsRedirect
    :ivar enabled_state: Whether to enable use of this rule. Permitted values are 'Enabled' or
     'Disabled'. Possible values include: "Enabled", "Disabled".
    :vartype enabled_state: str or ~azure.mgmt.cdn.models.EnabledState
    """

    _validation = {
        'endpoint_name': {'readonly': True},
    }

    _attribute_map = {
        'endpoint_name': {'key': 'properties.endpointName', 'type': 'str'},
        'custom_domains': {'key': 'properties.customDomains', 'type': '[ActivatedResourceReference]'},
        'origin_group': {'key': 'properties.originGroup', 'type': 'ResourceReference'},
        'origin_path': {'key': 'properties.originPath', 'type': 'str'},
        'rule_sets': {'key': 'properties.ruleSets', 'type': '[ResourceReference]'},
        'supported_protocols': {'key': 'properties.supportedProtocols', 'type': '[str]'},
        'patterns_to_match': {'key': 'properties.patternsToMatch', 'type': '[str]'},
        'cache_configuration': {'key': 'properties.cacheConfiguration', 'type': 'AfdRouteCacheConfiguration'},
        'forwarding_protocol': {'key': 'properties.forwardingProtocol', 'type': 'str'},
        'link_to_default_domain': {'key': 'properties.linkToDefaultDomain', 'type': 'str'},
        'https_redirect': {'key': 'properties.httpsRedirect', 'type': 'str'},
        'enabled_state': {'key': 'properties.enabledState', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        custom_domains: Optional[List["ActivatedResourceReference"]] = None,
        origin_group: Optional["ResourceReference"] = None,
        origin_path: Optional[str] = None,
        rule_sets: Optional[List["ResourceReference"]] = None,
        supported_protocols: Optional[List[Union[str, "AFDEndpointProtocols"]]] = None,
        patterns_to_match: Optional[List[str]] = None,
        cache_configuration: Optional["AfdRouteCacheConfiguration"] = None,
        forwarding_protocol: Optional[Union[str, "ForwardingProtocol"]] = None,
        link_to_default_domain: Optional[Union[str, "LinkToDefaultDomain"]] = None,
        https_redirect: Optional[Union[str, "HttpsRedirect"]] = None,
        enabled_state: Optional[Union[str, "EnabledState"]] = None,
        **kwargs
    ):
        """
        :keyword custom_domains: Domains referenced by this endpoint.
        :paramtype custom_domains: list[~azure.mgmt.cdn.models.ActivatedResourceReference]
        :keyword origin_group: A reference to the origin group.
        :paramtype origin_group: ~azure.mgmt.cdn.models.ResourceReference
        :keyword origin_path: A directory path on the origin that AzureFrontDoor can use to retrieve
         content from, e.g. contoso.cloudapp.net/originpath.
        :paramtype origin_path: str
        :keyword rule_sets: rule sets referenced by this endpoint.
        :paramtype rule_sets: list[~azure.mgmt.cdn.models.ResourceReference]
        :keyword supported_protocols: List of supported protocols for this route.
        :paramtype supported_protocols: list[str or ~azure.mgmt.cdn.models.AFDEndpointProtocols]
        :keyword patterns_to_match: The route patterns of the rule.
        :paramtype patterns_to_match: list[str]
        :keyword cache_configuration: The caching configuration for this route. To disable caching, do
         not provide a cacheConfiguration object.
        :paramtype cache_configuration: ~azure.mgmt.cdn.models.AfdRouteCacheConfiguration
        :keyword forwarding_protocol: Protocol this rule will use when forwarding traffic to backends.
         Possible values include: "HttpOnly", "HttpsOnly", "MatchRequest".
        :paramtype forwarding_protocol: str or ~azure.mgmt.cdn.models.ForwardingProtocol
        :keyword link_to_default_domain: whether this route will be linked to the default endpoint
         domain. Possible values include: "Enabled", "Disabled".
        :paramtype link_to_default_domain: str or ~azure.mgmt.cdn.models.LinkToDefaultDomain
        :keyword https_redirect: Whether to automatically redirect HTTP traffic to HTTPS traffic. Note
         that this is a easy way to set up this rule and it will be the first rule that gets executed.
         Possible values include: "Enabled", "Disabled".
        :paramtype https_redirect: str or ~azure.mgmt.cdn.models.HttpsRedirect
        :keyword enabled_state: Whether to enable use of this rule. Permitted values are 'Enabled' or
         'Disabled'. Possible values include: "Enabled", "Disabled".
        :paramtype enabled_state: str or ~azure.mgmt.cdn.models.EnabledState
        """
        super(RouteUpdateParameters, self).__init__(**kwargs)
        self.endpoint_name = None
        self.custom_domains = custom_domains
        self.origin_group = origin_group
        self.origin_path = origin_path
        self.rule_sets = rule_sets
        self.supported_protocols = supported_protocols
        self.patterns_to_match = patterns_to_match
        self.cache_configuration = cache_configuration
        self.forwarding_protocol = forwarding_protocol
        self.link_to_default_domain = link_to_default_domain
        self.https_redirect = https_redirect
        self.enabled_state = enabled_state


class Rule(ProxyResource):
    """Friendly Rules name mapping to the any Rules or secret related information.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar system_data: Read only system data.
    :vartype system_data: ~azure.mgmt.cdn.models.SystemData
    :ivar rule_set_name: The name of the rule set containing the rule.
    :vartype rule_set_name: str
    :ivar order: The order in which the rules are applied for the endpoint. Possible values
     {0,1,2,3,………}. A rule with a lesser order will be applied before a rule with a greater order.
     Rule with order 0 is a special rule. It does not require any condition and actions listed in it
     will always be applied.
    :vartype order: int
    :ivar conditions: A list of conditions that must be matched for the actions to be executed.
    :vartype conditions: list[~azure.mgmt.cdn.models.DeliveryRuleCondition]
    :ivar actions: A list of actions that are executed when all the conditions of a rule are
     satisfied.
    :vartype actions: list[~azure.mgmt.cdn.models.DeliveryRuleAction]
    :ivar match_processing_behavior: If this rule is a match should the rules engine continue
     running the remaining rules or stop. If not present, defaults to Continue. Possible values
     include: "Continue", "Stop".
    :vartype match_processing_behavior: str or ~azure.mgmt.cdn.models.MatchProcessingBehavior
    :ivar provisioning_state: Provisioning status. Possible values include: "Succeeded", "Failed",
     "Updating", "Deleting", "Creating".
    :vartype provisioning_state: str or ~azure.mgmt.cdn.models.AfdProvisioningState
    :ivar deployment_status: Possible values include: "NotStarted", "InProgress", "Succeeded",
     "Failed".
    :vartype deployment_status: str or ~azure.mgmt.cdn.models.DeploymentStatus
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'rule_set_name': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'deployment_status': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'rule_set_name': {'key': 'properties.ruleSetName', 'type': 'str'},
        'order': {'key': 'properties.order', 'type': 'int'},
        'conditions': {'key': 'properties.conditions', 'type': '[DeliveryRuleCondition]'},
        'actions': {'key': 'properties.actions', 'type': '[DeliveryRuleAction]'},
        'match_processing_behavior': {'key': 'properties.matchProcessingBehavior', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'deployment_status': {'key': 'properties.deploymentStatus', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        order: Optional[int] = None,
        conditions: Optional[List["DeliveryRuleCondition"]] = None,
        actions: Optional[List["DeliveryRuleAction"]] = None,
        match_processing_behavior: Optional[Union[str, "MatchProcessingBehavior"]] = None,
        **kwargs
    ):
        """
        :keyword order: The order in which the rules are applied for the endpoint. Possible values
         {0,1,2,3,………}. A rule with a lesser order will be applied before a rule with a greater order.
         Rule with order 0 is a special rule. It does not require any condition and actions listed in it
         will always be applied.
        :paramtype order: int
        :keyword conditions: A list of conditions that must be matched for the actions to be executed.
        :paramtype conditions: list[~azure.mgmt.cdn.models.DeliveryRuleCondition]
        :keyword actions: A list of actions that are executed when all the conditions of a rule are
         satisfied.
        :paramtype actions: list[~azure.mgmt.cdn.models.DeliveryRuleAction]
        :keyword match_processing_behavior: If this rule is a match should the rules engine continue
         running the remaining rules or stop. If not present, defaults to Continue. Possible values
         include: "Continue", "Stop".
        :paramtype match_processing_behavior: str or ~azure.mgmt.cdn.models.MatchProcessingBehavior
        """
        super(Rule, self).__init__(**kwargs)
        self.rule_set_name = None
        self.order = order
        self.conditions = conditions
        self.actions = actions
        self.match_processing_behavior = match_processing_behavior
        self.provisioning_state = None
        self.deployment_status = None


class RuleListResult(msrest.serialization.Model):
    """Result of the request to list rules. It contains a list of rule objects and a URL link to get the next set of results.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of AzureFrontDoor rules within a rule set.
    :vartype value: list[~azure.mgmt.cdn.models.Rule]
    :ivar next_link: URL to get the next set of rule objects if there are any.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Rule]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        next_link: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword next_link: URL to get the next set of rule objects if there are any.
        :paramtype next_link: str
        """
        super(RuleListResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = next_link


class RuleUpdatePropertiesParameters(msrest.serialization.Model):
    """The JSON object that contains the properties of the rule to update.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar rule_set_name: The name of the rule set containing the rule.
    :vartype rule_set_name: str
    :ivar order: The order in which the rules are applied for the endpoint. Possible values
     {0,1,2,3,………}. A rule with a lesser order will be applied before a rule with a greater order.
     Rule with order 0 is a special rule. It does not require any condition and actions listed in it
     will always be applied.
    :vartype order: int
    :ivar conditions: A list of conditions that must be matched for the actions to be executed.
    :vartype conditions: list[~azure.mgmt.cdn.models.DeliveryRuleCondition]
    :ivar actions: A list of actions that are executed when all the conditions of a rule are
     satisfied.
    :vartype actions: list[~azure.mgmt.cdn.models.DeliveryRuleAction]
    :ivar match_processing_behavior: If this rule is a match should the rules engine continue
     running the remaining rules or stop. If not present, defaults to Continue. Possible values
     include: "Continue", "Stop".
    :vartype match_processing_behavior: str or ~azure.mgmt.cdn.models.MatchProcessingBehavior
    """

    _validation = {
        'rule_set_name': {'readonly': True},
    }

    _attribute_map = {
        'rule_set_name': {'key': 'ruleSetName', 'type': 'str'},
        'order': {'key': 'order', 'type': 'int'},
        'conditions': {'key': 'conditions', 'type': '[DeliveryRuleCondition]'},
        'actions': {'key': 'actions', 'type': '[DeliveryRuleAction]'},
        'match_processing_behavior': {'key': 'matchProcessingBehavior', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        order: Optional[int] = None,
        conditions: Optional[List["DeliveryRuleCondition"]] = None,
        actions: Optional[List["DeliveryRuleAction"]] = None,
        match_processing_behavior: Optional[Union[str, "MatchProcessingBehavior"]] = None,
        **kwargs
    ):
        """
        :keyword order: The order in which the rules are applied for the endpoint. Possible values
         {0,1,2,3,………}. A rule with a lesser order will be applied before a rule with a greater order.
         Rule with order 0 is a special rule. It does not require any condition and actions listed in it
         will always be applied.
        :paramtype order: int
        :keyword conditions: A list of conditions that must be matched for the actions to be executed.
        :paramtype conditions: list[~azure.mgmt.cdn.models.DeliveryRuleCondition]
        :keyword actions: A list of actions that are executed when all the conditions of a rule are
         satisfied.
        :paramtype actions: list[~azure.mgmt.cdn.models.DeliveryRuleAction]
        :keyword match_processing_behavior: If this rule is a match should the rules engine continue
         running the remaining rules or stop. If not present, defaults to Continue. Possible values
         include: "Continue", "Stop".
        :paramtype match_processing_behavior: str or ~azure.mgmt.cdn.models.MatchProcessingBehavior
        """
        super(RuleUpdatePropertiesParameters, self).__init__(**kwargs)
        self.rule_set_name = None
        self.order = order
        self.conditions = conditions
        self.actions = actions
        self.match_processing_behavior = match_processing_behavior


class RuleProperties(AFDStateProperties, RuleUpdatePropertiesParameters):
    """The JSON object that contains the properties of the Rules to create.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar rule_set_name: The name of the rule set containing the rule.
    :vartype rule_set_name: str
    :ivar order: The order in which the rules are applied for the endpoint. Possible values
     {0,1,2,3,………}. A rule with a lesser order will be applied before a rule with a greater order.
     Rule with order 0 is a special rule. It does not require any condition and actions listed in it
     will always be applied.
    :vartype order: int
    :ivar conditions: A list of conditions that must be matched for the actions to be executed.
    :vartype conditions: list[~azure.mgmt.cdn.models.DeliveryRuleCondition]
    :ivar actions: A list of actions that are executed when all the conditions of a rule are
     satisfied.
    :vartype actions: list[~azure.mgmt.cdn.models.DeliveryRuleAction]
    :ivar match_processing_behavior: If this rule is a match should the rules engine continue
     running the remaining rules or stop. If not present, defaults to Continue. Possible values
     include: "Continue", "Stop".
    :vartype match_processing_behavior: str or ~azure.mgmt.cdn.models.MatchProcessingBehavior
    :ivar provisioning_state: Provisioning status. Possible values include: "Succeeded", "Failed",
     "Updating", "Deleting", "Creating".
    :vartype provisioning_state: str or ~azure.mgmt.cdn.models.AfdProvisioningState
    :ivar deployment_status: Possible values include: "NotStarted", "InProgress", "Succeeded",
     "Failed".
    :vartype deployment_status: str or ~azure.mgmt.cdn.models.DeploymentStatus
    """

    _validation = {
        'rule_set_name': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'deployment_status': {'readonly': True},
    }

    _attribute_map = {
        'rule_set_name': {'key': 'ruleSetName', 'type': 'str'},
        'order': {'key': 'order', 'type': 'int'},
        'conditions': {'key': 'conditions', 'type': '[DeliveryRuleCondition]'},
        'actions': {'key': 'actions', 'type': '[DeliveryRuleAction]'},
        'match_processing_behavior': {'key': 'matchProcessingBehavior', 'type': 'str'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
        'deployment_status': {'key': 'deploymentStatus', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        order: Optional[int] = None,
        conditions: Optional[List["DeliveryRuleCondition"]] = None,
        actions: Optional[List["DeliveryRuleAction"]] = None,
        match_processing_behavior: Optional[Union[str, "MatchProcessingBehavior"]] = None,
        **kwargs
    ):
        """
        :keyword order: The order in which the rules are applied for the endpoint. Possible values
         {0,1,2,3,………}. A rule with a lesser order will be applied before a rule with a greater order.
         Rule with order 0 is a special rule. It does not require any condition and actions listed in it
         will always be applied.
        :paramtype order: int
        :keyword conditions: A list of conditions that must be matched for the actions to be executed.
        :paramtype conditions: list[~azure.mgmt.cdn.models.DeliveryRuleCondition]
        :keyword actions: A list of actions that are executed when all the conditions of a rule are
         satisfied.
        :paramtype actions: list[~azure.mgmt.cdn.models.DeliveryRuleAction]
        :keyword match_processing_behavior: If this rule is a match should the rules engine continue
         running the remaining rules or stop. If not present, defaults to Continue. Possible values
         include: "Continue", "Stop".
        :paramtype match_processing_behavior: str or ~azure.mgmt.cdn.models.MatchProcessingBehavior
        """
        super(RuleProperties, self).__init__(order=order, conditions=conditions, actions=actions, match_processing_behavior=match_processing_behavior, **kwargs)
        self.rule_set_name = None
        self.order = order
        self.conditions = conditions
        self.actions = actions
        self.match_processing_behavior = match_processing_behavior
        self.provisioning_state = None
        self.deployment_status = None


class RuleSet(ProxyResource):
    """Friendly RuleSet name mapping to the any RuleSet or secret related information.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar system_data: Read only system data.
    :vartype system_data: ~azure.mgmt.cdn.models.SystemData
    :ivar provisioning_state: Provisioning status. Possible values include: "Succeeded", "Failed",
     "Updating", "Deleting", "Creating".
    :vartype provisioning_state: str or ~azure.mgmt.cdn.models.AfdProvisioningState
    :ivar deployment_status: Possible values include: "NotStarted", "InProgress", "Succeeded",
     "Failed".
    :vartype deployment_status: str or ~azure.mgmt.cdn.models.DeploymentStatus
    :ivar profile_name: The name of the profile which holds the rule set.
    :vartype profile_name: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'deployment_status': {'readonly': True},
        'profile_name': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'deployment_status': {'key': 'properties.deploymentStatus', 'type': 'str'},
        'profile_name': {'key': 'properties.profileName', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(RuleSet, self).__init__(**kwargs)
        self.provisioning_state = None
        self.deployment_status = None
        self.profile_name = None


class RuleSetListResult(msrest.serialization.Model):
    """Result of the request to list rule sets. It contains a list of rule set objects and a URL link to get the next set of results.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of AzureFrontDoor rule sets within a profile.
    :vartype value: list[~azure.mgmt.cdn.models.RuleSet]
    :ivar next_link: URL to get the next set of rule set objects if there are any.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[RuleSet]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        next_link: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword next_link: URL to get the next set of rule set objects if there are any.
        :paramtype next_link: str
        """
        super(RuleSetListResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = next_link


class RuleSetProperties(AFDStateProperties):
    """The JSON object that contains the properties of the Rule Set to create.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar provisioning_state: Provisioning status. Possible values include: "Succeeded", "Failed",
     "Updating", "Deleting", "Creating".
    :vartype provisioning_state: str or ~azure.mgmt.cdn.models.AfdProvisioningState
    :ivar deployment_status: Possible values include: "NotStarted", "InProgress", "Succeeded",
     "Failed".
    :vartype deployment_status: str or ~azure.mgmt.cdn.models.DeploymentStatus
    :ivar profile_name: The name of the profile which holds the rule set.
    :vartype profile_name: str
    """

    _validation = {
        'provisioning_state': {'readonly': True},
        'deployment_status': {'readonly': True},
        'profile_name': {'readonly': True},
    }

    _attribute_map = {
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
        'deployment_status': {'key': 'deploymentStatus', 'type': 'str'},
        'profile_name': {'key': 'profileName', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(RuleSetProperties, self).__init__(**kwargs)
        self.profile_name = None


class RuleUpdateParameters(msrest.serialization.Model):
    """The domain JSON object required for domain creation or update.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar rule_set_name: The name of the rule set containing the rule.
    :vartype rule_set_name: str
    :ivar order: The order in which the rules are applied for the endpoint. Possible values
     {0,1,2,3,………}. A rule with a lesser order will be applied before a rule with a greater order.
     Rule with order 0 is a special rule. It does not require any condition and actions listed in it
     will always be applied.
    :vartype order: int
    :ivar conditions: A list of conditions that must be matched for the actions to be executed.
    :vartype conditions: list[~azure.mgmt.cdn.models.DeliveryRuleCondition]
    :ivar actions: A list of actions that are executed when all the conditions of a rule are
     satisfied.
    :vartype actions: list[~azure.mgmt.cdn.models.DeliveryRuleAction]
    :ivar match_processing_behavior: If this rule is a match should the rules engine continue
     running the remaining rules or stop. If not present, defaults to Continue. Possible values
     include: "Continue", "Stop".
    :vartype match_processing_behavior: str or ~azure.mgmt.cdn.models.MatchProcessingBehavior
    """

    _validation = {
        'rule_set_name': {'readonly': True},
    }

    _attribute_map = {
        'rule_set_name': {'key': 'properties.ruleSetName', 'type': 'str'},
        'order': {'key': 'properties.order', 'type': 'int'},
        'conditions': {'key': 'properties.conditions', 'type': '[DeliveryRuleCondition]'},
        'actions': {'key': 'properties.actions', 'type': '[DeliveryRuleAction]'},
        'match_processing_behavior': {'key': 'properties.matchProcessingBehavior', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        order: Optional[int] = None,
        conditions: Optional[List["DeliveryRuleCondition"]] = None,
        actions: Optional[List["DeliveryRuleAction"]] = None,
        match_processing_behavior: Optional[Union[str, "MatchProcessingBehavior"]] = None,
        **kwargs
    ):
        """
        :keyword order: The order in which the rules are applied for the endpoint. Possible values
         {0,1,2,3,………}. A rule with a lesser order will be applied before a rule with a greater order.
         Rule with order 0 is a special rule. It does not require any condition and actions listed in it
         will always be applied.
        :paramtype order: int
        :keyword conditions: A list of conditions that must be matched for the actions to be executed.
        :paramtype conditions: list[~azure.mgmt.cdn.models.DeliveryRuleCondition]
        :keyword actions: A list of actions that are executed when all the conditions of a rule are
         satisfied.
        :paramtype actions: list[~azure.mgmt.cdn.models.DeliveryRuleAction]
        :keyword match_processing_behavior: If this rule is a match should the rules engine continue
         running the remaining rules or stop. If not present, defaults to Continue. Possible values
         include: "Continue", "Stop".
        :paramtype match_processing_behavior: str or ~azure.mgmt.cdn.models.MatchProcessingBehavior
        """
        super(RuleUpdateParameters, self).__init__(**kwargs)
        self.rule_set_name = None
        self.order = order
        self.conditions = conditions
        self.actions = actions
        self.match_processing_behavior = match_processing_behavior


class Secret(ProxyResource):
    """Friendly Secret name mapping to the any Secret or secret related information.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar system_data: Read only system data.
    :vartype system_data: ~azure.mgmt.cdn.models.SystemData
    :ivar provisioning_state: Provisioning status. Possible values include: "Succeeded", "Failed",
     "Updating", "Deleting", "Creating".
    :vartype provisioning_state: str or ~azure.mgmt.cdn.models.AfdProvisioningState
    :ivar deployment_status: Possible values include: "NotStarted", "InProgress", "Succeeded",
     "Failed".
    :vartype deployment_status: str or ~azure.mgmt.cdn.models.DeploymentStatus
    :ivar profile_name: The name of the profile which holds the secret.
    :vartype profile_name: str
    :ivar parameters: object which contains secret parameters.
    :vartype parameters: ~azure.mgmt.cdn.models.SecretParameters
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'deployment_status': {'readonly': True},
        'profile_name': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'deployment_status': {'key': 'properties.deploymentStatus', 'type': 'str'},
        'profile_name': {'key': 'properties.profileName', 'type': 'str'},
        'parameters': {'key': 'properties.parameters', 'type': 'SecretParameters'},
    }

    def __init__(
        self,
        *,
        parameters: Optional["SecretParameters"] = None,
        **kwargs
    ):
        """
        :keyword parameters: object which contains secret parameters.
        :paramtype parameters: ~azure.mgmt.cdn.models.SecretParameters
        """
        super(Secret, self).__init__(**kwargs)
        self.provisioning_state = None
        self.deployment_status = None
        self.profile_name = None
        self.parameters = parameters


class SecretListResult(msrest.serialization.Model):
    """Result of the request to list secrets. It contains a list of Secret objects and a URL link to get the next set of results.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of AzureFrontDoor secrets within a profile.
    :vartype value: list[~azure.mgmt.cdn.models.Secret]
    :ivar next_link: URL to get the next set of Secret objects if there are any.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Secret]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        next_link: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword next_link: URL to get the next set of Secret objects if there are any.
        :paramtype next_link: str
        """
        super(SecretListResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = next_link


class SecretProperties(AFDStateProperties):
    """The JSON object that contains the properties of the Secret to create.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar provisioning_state: Provisioning status. Possible values include: "Succeeded", "Failed",
     "Updating", "Deleting", "Creating".
    :vartype provisioning_state: str or ~azure.mgmt.cdn.models.AfdProvisioningState
    :ivar deployment_status: Possible values include: "NotStarted", "InProgress", "Succeeded",
     "Failed".
    :vartype deployment_status: str or ~azure.mgmt.cdn.models.DeploymentStatus
    :ivar profile_name: The name of the profile which holds the secret.
    :vartype profile_name: str
    :ivar parameters: object which contains secret parameters.
    :vartype parameters: ~azure.mgmt.cdn.models.SecretParameters
    """

    _validation = {
        'provisioning_state': {'readonly': True},
        'deployment_status': {'readonly': True},
        'profile_name': {'readonly': True},
    }

    _attribute_map = {
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
        'deployment_status': {'key': 'deploymentStatus', 'type': 'str'},
        'profile_name': {'key': 'profileName', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': 'SecretParameters'},
    }

    def __init__(
        self,
        *,
        parameters: Optional["SecretParameters"] = None,
        **kwargs
    ):
        """
        :keyword parameters: object which contains secret parameters.
        :paramtype parameters: ~azure.mgmt.cdn.models.SecretParameters
        """
        super(SecretProperties, self).__init__(**kwargs)
        self.profile_name = None
        self.parameters = parameters


class SecurityPolicy(ProxyResource):
    """SecurityPolicy association for AzureFrontDoor profile.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar system_data: Read only system data.
    :vartype system_data: ~azure.mgmt.cdn.models.SystemData
    :ivar provisioning_state: Provisioning status. Possible values include: "Succeeded", "Failed",
     "Updating", "Deleting", "Creating".
    :vartype provisioning_state: str or ~azure.mgmt.cdn.models.AfdProvisioningState
    :ivar deployment_status: Possible values include: "NotStarted", "InProgress", "Succeeded",
     "Failed".
    :vartype deployment_status: str or ~azure.mgmt.cdn.models.DeploymentStatus
    :ivar profile_name: The name of the profile which holds the security policy.
    :vartype profile_name: str
    :ivar parameters: object which contains security policy parameters.
    :vartype parameters: ~azure.mgmt.cdn.models.SecurityPolicyPropertiesParameters
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'deployment_status': {'readonly': True},
        'profile_name': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'deployment_status': {'key': 'properties.deploymentStatus', 'type': 'str'},
        'profile_name': {'key': 'properties.profileName', 'type': 'str'},
        'parameters': {'key': 'properties.parameters', 'type': 'SecurityPolicyPropertiesParameters'},
    }

    def __init__(
        self,
        *,
        parameters: Optional["SecurityPolicyPropertiesParameters"] = None,
        **kwargs
    ):
        """
        :keyword parameters: object which contains security policy parameters.
        :paramtype parameters: ~azure.mgmt.cdn.models.SecurityPolicyPropertiesParameters
        """
        super(SecurityPolicy, self).__init__(**kwargs)
        self.provisioning_state = None
        self.deployment_status = None
        self.profile_name = None
        self.parameters = parameters


class SecurityPolicyListResult(msrest.serialization.Model):
    """Result of the request to list security policies. It contains a list of security policy objects and a URL link to get the next set of results.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of Security policies within a profile.
    :vartype value: list[~azure.mgmt.cdn.models.SecurityPolicy]
    :ivar next_link: URL to get the next set of security policy objects if there is any.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[SecurityPolicy]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        next_link: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword next_link: URL to get the next set of security policy objects if there is any.
        :paramtype next_link: str
        """
        super(SecurityPolicyListResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = next_link


class SecurityPolicyProperties(AFDStateProperties):
    """The json object that contains properties required to create a security policy.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar provisioning_state: Provisioning status. Possible values include: "Succeeded", "Failed",
     "Updating", "Deleting", "Creating".
    :vartype provisioning_state: str or ~azure.mgmt.cdn.models.AfdProvisioningState
    :ivar deployment_status: Possible values include: "NotStarted", "InProgress", "Succeeded",
     "Failed".
    :vartype deployment_status: str or ~azure.mgmt.cdn.models.DeploymentStatus
    :ivar profile_name: The name of the profile which holds the security policy.
    :vartype profile_name: str
    :ivar parameters: object which contains security policy parameters.
    :vartype parameters: ~azure.mgmt.cdn.models.SecurityPolicyPropertiesParameters
    """

    _validation = {
        'provisioning_state': {'readonly': True},
        'deployment_status': {'readonly': True},
        'profile_name': {'readonly': True},
    }

    _attribute_map = {
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
        'deployment_status': {'key': 'deploymentStatus', 'type': 'str'},
        'profile_name': {'key': 'profileName', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': 'SecurityPolicyPropertiesParameters'},
    }

    def __init__(
        self,
        *,
        parameters: Optional["SecurityPolicyPropertiesParameters"] = None,
        **kwargs
    ):
        """
        :keyword parameters: object which contains security policy parameters.
        :paramtype parameters: ~azure.mgmt.cdn.models.SecurityPolicyPropertiesParameters
        """
        super(SecurityPolicyProperties, self).__init__(**kwargs)
        self.profile_name = None
        self.parameters = parameters


class SecurityPolicyPropertiesParameters(msrest.serialization.Model):
    """The json object containing security policy parameters.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: SecurityPolicyWebApplicationFirewallParameters.

    All required parameters must be populated in order to send to Azure.

    :ivar type: Required. The type of the Security policy to create.Constant filled by server.
     Possible values include: "WebApplicationFirewall".
    :vartype type: str or ~azure.mgmt.cdn.models.SecurityPolicyType
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
    }

    _subtype_map = {
        'type': {'WebApplicationFirewall': 'SecurityPolicyWebApplicationFirewallParameters'}
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(SecurityPolicyPropertiesParameters, self).__init__(**kwargs)
        self.type = None  # type: Optional[str]


class SecurityPolicyUpdateParameters(msrest.serialization.Model):
    """The JSON object containing security policy update parameters.

    :ivar parameters: object which contains security policy parameters.
    :vartype parameters: ~azure.mgmt.cdn.models.SecurityPolicyPropertiesParameters
    """

    _attribute_map = {
        'parameters': {'key': 'properties.parameters', 'type': 'SecurityPolicyPropertiesParameters'},
    }

    def __init__(
        self,
        *,
        parameters: Optional["SecurityPolicyPropertiesParameters"] = None,
        **kwargs
    ):
        """
        :keyword parameters: object which contains security policy parameters.
        :paramtype parameters: ~azure.mgmt.cdn.models.SecurityPolicyPropertiesParameters
        """
        super(SecurityPolicyUpdateParameters, self).__init__(**kwargs)
        self.parameters = parameters


class SecurityPolicyWebApplicationFirewallAssociation(msrest.serialization.Model):
    """settings for security policy patterns to match.

    :ivar domains: List of domains.
    :vartype domains: list[~azure.mgmt.cdn.models.ActivatedResourceReference]
    :ivar patterns_to_match: List of paths.
    :vartype patterns_to_match: list[str]
    """

    _attribute_map = {
        'domains': {'key': 'domains', 'type': '[ActivatedResourceReference]'},
        'patterns_to_match': {'key': 'patternsToMatch', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        domains: Optional[List["ActivatedResourceReference"]] = None,
        patterns_to_match: Optional[List[str]] = None,
        **kwargs
    ):
        """
        :keyword domains: List of domains.
        :paramtype domains: list[~azure.mgmt.cdn.models.ActivatedResourceReference]
        :keyword patterns_to_match: List of paths.
        :paramtype patterns_to_match: list[str]
        """
        super(SecurityPolicyWebApplicationFirewallAssociation, self).__init__(**kwargs)
        self.domains = domains
        self.patterns_to_match = patterns_to_match


class SecurityPolicyWebApplicationFirewallParameters(SecurityPolicyPropertiesParameters):
    """The json object containing security policy waf parameters.

    All required parameters must be populated in order to send to Azure.

    :ivar type: Required. The type of the Security policy to create.Constant filled by server.
     Possible values include: "WebApplicationFirewall".
    :vartype type: str or ~azure.mgmt.cdn.models.SecurityPolicyType
    :ivar waf_policy: Resource ID.
    :vartype waf_policy: ~azure.mgmt.cdn.models.ResourceReference
    :ivar associations: Waf associations.
    :vartype associations:
     list[~azure.mgmt.cdn.models.SecurityPolicyWebApplicationFirewallAssociation]
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'waf_policy': {'key': 'wafPolicy', 'type': 'ResourceReference'},
        'associations': {'key': 'associations', 'type': '[SecurityPolicyWebApplicationFirewallAssociation]'},
    }

    def __init__(
        self,
        *,
        waf_policy: Optional["ResourceReference"] = None,
        associations: Optional[List["SecurityPolicyWebApplicationFirewallAssociation"]] = None,
        **kwargs
    ):
        """
        :keyword waf_policy: Resource ID.
        :paramtype waf_policy: ~azure.mgmt.cdn.models.ResourceReference
        :keyword associations: Waf associations.
        :paramtype associations:
         list[~azure.mgmt.cdn.models.SecurityPolicyWebApplicationFirewallAssociation]
        """
        super(SecurityPolicyWebApplicationFirewallParameters, self).__init__(**kwargs)
        self.type = 'WebApplicationFirewall'  # type: str
        self.waf_policy = waf_policy
        self.associations = associations


class ServerPortMatchConditionParameters(msrest.serialization.Model):
    """Defines the parameters for ServerPort match conditions.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar type_name:  Has constant value: "DeliveryRuleServerPortConditionParameters".
    :vartype type_name: str
    :ivar operator: Required. Describes operator to be matched. Possible values include: "Any",
     "Equal", "Contains", "BeginsWith", "EndsWith", "LessThan", "LessThanOrEqual", "GreaterThan",
     "GreaterThanOrEqual", "RegEx".
    :vartype operator: str or ~azure.mgmt.cdn.models.ServerPortOperator
    :ivar negate_condition: Describes if this is negate condition or not.
    :vartype negate_condition: bool
    :ivar match_values: The match value for the condition of the delivery rule.
    :vartype match_values: list[str]
    :ivar transforms: List of transforms.
    :vartype transforms: list[str or ~azure.mgmt.cdn.models.Transform]
    """

    _validation = {
        'type_name': {'required': True, 'constant': True},
        'operator': {'required': True},
    }

    _attribute_map = {
        'type_name': {'key': 'typeName', 'type': 'str'},
        'operator': {'key': 'operator', 'type': 'str'},
        'negate_condition': {'key': 'negateCondition', 'type': 'bool'},
        'match_values': {'key': 'matchValues', 'type': '[str]'},
        'transforms': {'key': 'transforms', 'type': '[str]'},
    }

    type_name = "DeliveryRuleServerPortConditionParameters"

    def __init__(
        self,
        *,
        operator: Union[str, "ServerPortOperator"],
        negate_condition: Optional[bool] = None,
        match_values: Optional[List[str]] = None,
        transforms: Optional[List[Union[str, "Transform"]]] = None,
        **kwargs
    ):
        """
        :keyword operator: Required. Describes operator to be matched. Possible values include: "Any",
         "Equal", "Contains", "BeginsWith", "EndsWith", "LessThan", "LessThanOrEqual", "GreaterThan",
         "GreaterThanOrEqual", "RegEx".
        :paramtype operator: str or ~azure.mgmt.cdn.models.ServerPortOperator
        :keyword negate_condition: Describes if this is negate condition or not.
        :paramtype negate_condition: bool
        :keyword match_values: The match value for the condition of the delivery rule.
        :paramtype match_values: list[str]
        :keyword transforms: List of transforms.
        :paramtype transforms: list[str or ~azure.mgmt.cdn.models.Transform]
        """
        super(ServerPortMatchConditionParameters, self).__init__(**kwargs)
        self.operator = operator
        self.negate_condition = negate_condition
        self.match_values = match_values
        self.transforms = transforms


class ServiceSpecification(msrest.serialization.Model):
    """One property of operation, include log specifications.

    :ivar log_specifications: Log specifications of operation.
    :vartype log_specifications: list[~azure.mgmt.cdn.models.LogSpecification]
    :ivar metric_specifications: Metric specifications of operation.
    :vartype metric_specifications: list[~azure.mgmt.cdn.models.MetricSpecification]
    """

    _attribute_map = {
        'log_specifications': {'key': 'logSpecifications', 'type': '[LogSpecification]'},
        'metric_specifications': {'key': 'metricSpecifications', 'type': '[MetricSpecification]'},
    }

    def __init__(
        self,
        *,
        log_specifications: Optional[List["LogSpecification"]] = None,
        metric_specifications: Optional[List["MetricSpecification"]] = None,
        **kwargs
    ):
        """
        :keyword log_specifications: Log specifications of operation.
        :paramtype log_specifications: list[~azure.mgmt.cdn.models.LogSpecification]
        :keyword metric_specifications: Metric specifications of operation.
        :paramtype metric_specifications: list[~azure.mgmt.cdn.models.MetricSpecification]
        """
        super(ServiceSpecification, self).__init__(**kwargs)
        self.log_specifications = log_specifications
        self.metric_specifications = metric_specifications


class SharedPrivateLinkResourceProperties(msrest.serialization.Model):
    """Describes the properties of an existing Shared Private Link Resource to use when connecting to a private origin.

    :ivar private_link: The resource id of the resource the shared private link resource is for.
    :vartype private_link: ~azure.mgmt.cdn.models.ResourceReference
    :ivar private_link_location: The location of the shared private link resource.
    :vartype private_link_location: str
    :ivar group_id: The group id from the provider of resource the shared private link resource is
     for.
    :vartype group_id: str
    :ivar request_message: The request message for requesting approval of the shared private link
     resource.
    :vartype request_message: str
    :ivar status: Status of the shared private link resource. Can be Pending, Approved, Rejected,
     Disconnected, or Timeout. Possible values include: "Pending", "Approved", "Rejected",
     "Disconnected", "Timeout".
    :vartype status: str or ~azure.mgmt.cdn.models.SharedPrivateLinkResourceStatus
    """

    _attribute_map = {
        'private_link': {'key': 'privateLink', 'type': 'ResourceReference'},
        'private_link_location': {'key': 'privateLinkLocation', 'type': 'str'},
        'group_id': {'key': 'groupId', 'type': 'str'},
        'request_message': {'key': 'requestMessage', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        private_link: Optional["ResourceReference"] = None,
        private_link_location: Optional[str] = None,
        group_id: Optional[str] = None,
        request_message: Optional[str] = None,
        status: Optional[Union[str, "SharedPrivateLinkResourceStatus"]] = None,
        **kwargs
    ):
        """
        :keyword private_link: The resource id of the resource the shared private link resource is for.
        :paramtype private_link: ~azure.mgmt.cdn.models.ResourceReference
        :keyword private_link_location: The location of the shared private link resource.
        :paramtype private_link_location: str
        :keyword group_id: The group id from the provider of resource the shared private link resource
         is for.
        :paramtype group_id: str
        :keyword request_message: The request message for requesting approval of the shared private
         link resource.
        :paramtype request_message: str
        :keyword status: Status of the shared private link resource. Can be Pending, Approved,
         Rejected, Disconnected, or Timeout. Possible values include: "Pending", "Approved", "Rejected",
         "Disconnected", "Timeout".
        :paramtype status: str or ~azure.mgmt.cdn.models.SharedPrivateLinkResourceStatus
        """
        super(SharedPrivateLinkResourceProperties, self).__init__(**kwargs)
        self.private_link = private_link
        self.private_link_location = private_link_location
        self.group_id = group_id
        self.request_message = request_message
        self.status = status


class Sku(msrest.serialization.Model):
    """Standard_Verizon = The SKU name for a Standard Verizon CDN profile.
Premium_Verizon = The SKU name for a Premium Verizon CDN profile.
Custom_Verizon = The SKU name for a Custom Verizon CDN profile.
Standard_Akamai = The SKU name for an Akamai CDN profile.
Standard_ChinaCdn = The SKU name for a China CDN profile for VOD, Web and download scenarios using GB based billing model.
Standard_Microsoft = The SKU name for a Standard Microsoft CDN profile.
Standard_AzureFrontDoor =  The SKU name for an Azure Front Door Standard profile.
Premium_AzureFrontDoor = The SKU name for an Azure Front Door Premium profile.
Standard_955BandWidth_ChinaCdn = The SKU name for a China CDN profile for VOD, Web and download scenarios using 95-5 peak bandwidth billing model.
Standard_AvgBandWidth_ChinaCdn = The SKU name for a China CDN profile for VOD, Web and download scenarios using monthly average peak bandwidth billing model.
StandardPlus_ChinaCdn = The SKU name for a China CDN profile for live-streaming using GB based billing model.
StandardPlus_955BandWidth_ChinaCdn = The SKU name for a China CDN live-streaming profile using 95-5 peak bandwidth billing model.
StandardPlus_AvgBandWidth_ChinaCdn = The SKU name for a China CDN live-streaming profile using monthly average peak bandwidth billing model.

    :ivar name: Name of the pricing tier. Possible values include: "Standard_Verizon",
     "Premium_Verizon", "Custom_Verizon", "Standard_Akamai", "Standard_ChinaCdn",
     "Standard_Microsoft", "Standard_AzureFrontDoor", "Premium_AzureFrontDoor",
     "Standard_955BandWidth_ChinaCdn", "Standard_AvgBandWidth_ChinaCdn", "StandardPlus_ChinaCdn",
     "StandardPlus_955BandWidth_ChinaCdn", "StandardPlus_AvgBandWidth_ChinaCdn".
    :vartype name: str or ~azure.mgmt.cdn.models.SkuName
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: Optional[Union[str, "SkuName"]] = None,
        **kwargs
    ):
        """
        :keyword name: Name of the pricing tier. Possible values include: "Standard_Verizon",
         "Premium_Verizon", "Custom_Verizon", "Standard_Akamai", "Standard_ChinaCdn",
         "Standard_Microsoft", "Standard_AzureFrontDoor", "Premium_AzureFrontDoor",
         "Standard_955BandWidth_ChinaCdn", "Standard_AvgBandWidth_ChinaCdn", "StandardPlus_ChinaCdn",
         "StandardPlus_955BandWidth_ChinaCdn", "StandardPlus_AvgBandWidth_ChinaCdn".
        :paramtype name: str or ~azure.mgmt.cdn.models.SkuName
        """
        super(Sku, self).__init__(**kwargs)
        self.name = name


class SocketAddrMatchConditionParameters(msrest.serialization.Model):
    """Defines the parameters for SocketAddress match conditions.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar type_name:  Has constant value: "DeliveryRuleSocketAddrConditionParameters".
    :vartype type_name: str
    :ivar operator: Required. Describes operator to be matched. Possible values include: "Any",
     "IPMatch".
    :vartype operator: str or ~azure.mgmt.cdn.models.SocketAddrOperator
    :ivar negate_condition: Describes if this is negate condition or not.
    :vartype negate_condition: bool
    :ivar match_values: The match value for the condition of the delivery rule.
    :vartype match_values: list[str]
    :ivar transforms: List of transforms.
    :vartype transforms: list[str or ~azure.mgmt.cdn.models.Transform]
    """

    _validation = {
        'type_name': {'required': True, 'constant': True},
        'operator': {'required': True},
    }

    _attribute_map = {
        'type_name': {'key': 'typeName', 'type': 'str'},
        'operator': {'key': 'operator', 'type': 'str'},
        'negate_condition': {'key': 'negateCondition', 'type': 'bool'},
        'match_values': {'key': 'matchValues', 'type': '[str]'},
        'transforms': {'key': 'transforms', 'type': '[str]'},
    }

    type_name = "DeliveryRuleSocketAddrConditionParameters"

    def __init__(
        self,
        *,
        operator: Union[str, "SocketAddrOperator"],
        negate_condition: Optional[bool] = None,
        match_values: Optional[List[str]] = None,
        transforms: Optional[List[Union[str, "Transform"]]] = None,
        **kwargs
    ):
        """
        :keyword operator: Required. Describes operator to be matched. Possible values include: "Any",
         "IPMatch".
        :paramtype operator: str or ~azure.mgmt.cdn.models.SocketAddrOperator
        :keyword negate_condition: Describes if this is negate condition or not.
        :paramtype negate_condition: bool
        :keyword match_values: The match value for the condition of the delivery rule.
        :paramtype match_values: list[str]
        :keyword transforms: List of transforms.
        :paramtype transforms: list[str or ~azure.mgmt.cdn.models.Transform]
        """
        super(SocketAddrMatchConditionParameters, self).__init__(**kwargs)
        self.operator = operator
        self.negate_condition = negate_condition
        self.match_values = match_values
        self.transforms = transforms


class SslProtocolMatchConditionParameters(msrest.serialization.Model):
    """Defines the parameters for SslProtocol match conditions.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar type_name:  Has constant value: "DeliveryRuleSslProtocolConditionParameters".
    :vartype type_name: str
    :ivar operator: Required. Describes operator to be matched. Possible values include: "Equal".
    :vartype operator: str or ~azure.mgmt.cdn.models.SslProtocolOperator
    :ivar negate_condition: Describes if this is negate condition or not.
    :vartype negate_condition: bool
    :ivar match_values: The match value for the condition of the delivery rule.
    :vartype match_values: list[str or ~azure.mgmt.cdn.models.SslProtocol]
    :ivar transforms: List of transforms.
    :vartype transforms: list[str or ~azure.mgmt.cdn.models.Transform]
    """

    _validation = {
        'type_name': {'required': True, 'constant': True},
        'operator': {'required': True},
    }

    _attribute_map = {
        'type_name': {'key': 'typeName', 'type': 'str'},
        'operator': {'key': 'operator', 'type': 'str'},
        'negate_condition': {'key': 'negateCondition', 'type': 'bool'},
        'match_values': {'key': 'matchValues', 'type': '[str]'},
        'transforms': {'key': 'transforms', 'type': '[str]'},
    }

    type_name = "DeliveryRuleSslProtocolConditionParameters"

    def __init__(
        self,
        *,
        operator: Union[str, "SslProtocolOperator"],
        negate_condition: Optional[bool] = None,
        match_values: Optional[List[Union[str, "SslProtocol"]]] = None,
        transforms: Optional[List[Union[str, "Transform"]]] = None,
        **kwargs
    ):
        """
        :keyword operator: Required. Describes operator to be matched. Possible values include:
         "Equal".
        :paramtype operator: str or ~azure.mgmt.cdn.models.SslProtocolOperator
        :keyword negate_condition: Describes if this is negate condition or not.
        :paramtype negate_condition: bool
        :keyword match_values: The match value for the condition of the delivery rule.
        :paramtype match_values: list[str or ~azure.mgmt.cdn.models.SslProtocol]
        :keyword transforms: List of transforms.
        :paramtype transforms: list[str or ~azure.mgmt.cdn.models.Transform]
        """
        super(SslProtocolMatchConditionParameters, self).__init__(**kwargs)
        self.operator = operator
        self.negate_condition = negate_condition
        self.match_values = match_values
        self.transforms = transforms


class SsoUri(msrest.serialization.Model):
    """The URI required to login to the supplemental portal from the Azure portal.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar sso_uri_value: The URI used to login to the supplemental portal.
    :vartype sso_uri_value: str
    """

    _validation = {
        'sso_uri_value': {'readonly': True},
    }

    _attribute_map = {
        'sso_uri_value': {'key': 'ssoUriValue', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(SsoUri, self).__init__(**kwargs)
        self.sso_uri_value = None


class SupportedOptimizationTypesListResult(msrest.serialization.Model):
    """The result of the GetSupportedOptimizationTypes API.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar supported_optimization_types: Supported optimization types for a profile.
    :vartype supported_optimization_types: list[str or ~azure.mgmt.cdn.models.OptimizationType]
    """

    _validation = {
        'supported_optimization_types': {'readonly': True},
    }

    _attribute_map = {
        'supported_optimization_types': {'key': 'supportedOptimizationTypes', 'type': '[str]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(SupportedOptimizationTypesListResult, self).__init__(**kwargs)
        self.supported_optimization_types = None


class SystemData(msrest.serialization.Model):
    """Read only system data.

    :ivar created_by: An identifier for the identity that created the resource.
    :vartype created_by: str
    :ivar created_by_type: The type of identity that created the resource. Possible values include:
     "user", "application", "managedIdentity", "key".
    :vartype created_by_type: str or ~azure.mgmt.cdn.models.IdentityType
    :ivar created_at: The timestamp of resource creation (UTC).
    :vartype created_at: ~datetime.datetime
    :ivar last_modified_by: An identifier for the identity that last modified the resource.
    :vartype last_modified_by: str
    :ivar last_modified_by_type: The type of identity that last modified the resource. Possible
     values include: "user", "application", "managedIdentity", "key".
    :vartype last_modified_by_type: str or ~azure.mgmt.cdn.models.IdentityType
    :ivar last_modified_at: The timestamp of resource last modification (UTC).
    :vartype last_modified_at: ~datetime.datetime
    """

    _attribute_map = {
        'created_by': {'key': 'createdBy', 'type': 'str'},
        'created_by_type': {'key': 'createdByType', 'type': 'str'},
        'created_at': {'key': 'createdAt', 'type': 'iso-8601'},
        'last_modified_by': {'key': 'lastModifiedBy', 'type': 'str'},
        'last_modified_by_type': {'key': 'lastModifiedByType', 'type': 'str'},
        'last_modified_at': {'key': 'lastModifiedAt', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        *,
        created_by: Optional[str] = None,
        created_by_type: Optional[Union[str, "IdentityType"]] = None,
        created_at: Optional[datetime.datetime] = None,
        last_modified_by: Optional[str] = None,
        last_modified_by_type: Optional[Union[str, "IdentityType"]] = None,
        last_modified_at: Optional[datetime.datetime] = None,
        **kwargs
    ):
        """
        :keyword created_by: An identifier for the identity that created the resource.
        :paramtype created_by: str
        :keyword created_by_type: The type of identity that created the resource. Possible values
         include: "user", "application", "managedIdentity", "key".
        :paramtype created_by_type: str or ~azure.mgmt.cdn.models.IdentityType
        :keyword created_at: The timestamp of resource creation (UTC).
        :paramtype created_at: ~datetime.datetime
        :keyword last_modified_by: An identifier for the identity that last modified the resource.
        :paramtype last_modified_by: str
        :keyword last_modified_by_type: The type of identity that last modified the resource. Possible
         values include: "user", "application", "managedIdentity", "key".
        :paramtype last_modified_by_type: str or ~azure.mgmt.cdn.models.IdentityType
        :keyword last_modified_at: The timestamp of resource last modification (UTC).
        :paramtype last_modified_at: ~datetime.datetime
        """
        super(SystemData, self).__init__(**kwargs)
        self.created_by = created_by
        self.created_by_type = created_by_type
        self.created_at = created_at
        self.last_modified_by = last_modified_by
        self.last_modified_by_type = last_modified_by_type
        self.last_modified_at = last_modified_at


class UrlFileExtensionMatchConditionParameters(msrest.serialization.Model):
    """Defines the parameters for UrlFileExtension match conditions.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar type_name:  Has constant value: "DeliveryRuleUrlFileExtensionMatchConditionParameters".
    :vartype type_name: str
    :ivar operator: Required. Describes operator to be matched. Possible values include: "Any",
     "Equal", "Contains", "BeginsWith", "EndsWith", "LessThan", "LessThanOrEqual", "GreaterThan",
     "GreaterThanOrEqual", "RegEx".
    :vartype operator: str or ~azure.mgmt.cdn.models.UrlFileExtensionOperator
    :ivar negate_condition: Describes if this is negate condition or not.
    :vartype negate_condition: bool
    :ivar match_values: The match value for the condition of the delivery rule.
    :vartype match_values: list[str]
    :ivar transforms: List of transforms.
    :vartype transforms: list[str or ~azure.mgmt.cdn.models.Transform]
    """

    _validation = {
        'type_name': {'required': True, 'constant': True},
        'operator': {'required': True},
    }

    _attribute_map = {
        'type_name': {'key': 'typeName', 'type': 'str'},
        'operator': {'key': 'operator', 'type': 'str'},
        'negate_condition': {'key': 'negateCondition', 'type': 'bool'},
        'match_values': {'key': 'matchValues', 'type': '[str]'},
        'transforms': {'key': 'transforms', 'type': '[str]'},
    }

    type_name = "DeliveryRuleUrlFileExtensionMatchConditionParameters"

    def __init__(
        self,
        *,
        operator: Union[str, "UrlFileExtensionOperator"],
        negate_condition: Optional[bool] = None,
        match_values: Optional[List[str]] = None,
        transforms: Optional[List[Union[str, "Transform"]]] = None,
        **kwargs
    ):
        """
        :keyword operator: Required. Describes operator to be matched. Possible values include: "Any",
         "Equal", "Contains", "BeginsWith", "EndsWith", "LessThan", "LessThanOrEqual", "GreaterThan",
         "GreaterThanOrEqual", "RegEx".
        :paramtype operator: str or ~azure.mgmt.cdn.models.UrlFileExtensionOperator
        :keyword negate_condition: Describes if this is negate condition or not.
        :paramtype negate_condition: bool
        :keyword match_values: The match value for the condition of the delivery rule.
        :paramtype match_values: list[str]
        :keyword transforms: List of transforms.
        :paramtype transforms: list[str or ~azure.mgmt.cdn.models.Transform]
        """
        super(UrlFileExtensionMatchConditionParameters, self).__init__(**kwargs)
        self.operator = operator
        self.negate_condition = negate_condition
        self.match_values = match_values
        self.transforms = transforms


class UrlFileNameMatchConditionParameters(msrest.serialization.Model):
    """Defines the parameters for UrlFilename match conditions.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar type_name:  Has constant value: "DeliveryRuleUrlFilenameConditionParameters".
    :vartype type_name: str
    :ivar operator: Required. Describes operator to be matched. Possible values include: "Any",
     "Equal", "Contains", "BeginsWith", "EndsWith", "LessThan", "LessThanOrEqual", "GreaterThan",
     "GreaterThanOrEqual", "RegEx".
    :vartype operator: str or ~azure.mgmt.cdn.models.UrlFileNameOperator
    :ivar negate_condition: Describes if this is negate condition or not.
    :vartype negate_condition: bool
    :ivar match_values: The match value for the condition of the delivery rule.
    :vartype match_values: list[str]
    :ivar transforms: List of transforms.
    :vartype transforms: list[str or ~azure.mgmt.cdn.models.Transform]
    """

    _validation = {
        'type_name': {'required': True, 'constant': True},
        'operator': {'required': True},
    }

    _attribute_map = {
        'type_name': {'key': 'typeName', 'type': 'str'},
        'operator': {'key': 'operator', 'type': 'str'},
        'negate_condition': {'key': 'negateCondition', 'type': 'bool'},
        'match_values': {'key': 'matchValues', 'type': '[str]'},
        'transforms': {'key': 'transforms', 'type': '[str]'},
    }

    type_name = "DeliveryRuleUrlFilenameConditionParameters"

    def __init__(
        self,
        *,
        operator: Union[str, "UrlFileNameOperator"],
        negate_condition: Optional[bool] = None,
        match_values: Optional[List[str]] = None,
        transforms: Optional[List[Union[str, "Transform"]]] = None,
        **kwargs
    ):
        """
        :keyword operator: Required. Describes operator to be matched. Possible values include: "Any",
         "Equal", "Contains", "BeginsWith", "EndsWith", "LessThan", "LessThanOrEqual", "GreaterThan",
         "GreaterThanOrEqual", "RegEx".
        :paramtype operator: str or ~azure.mgmt.cdn.models.UrlFileNameOperator
        :keyword negate_condition: Describes if this is negate condition or not.
        :paramtype negate_condition: bool
        :keyword match_values: The match value for the condition of the delivery rule.
        :paramtype match_values: list[str]
        :keyword transforms: List of transforms.
        :paramtype transforms: list[str or ~azure.mgmt.cdn.models.Transform]
        """
        super(UrlFileNameMatchConditionParameters, self).__init__(**kwargs)
        self.operator = operator
        self.negate_condition = negate_condition
        self.match_values = match_values
        self.transforms = transforms


class UrlPathMatchConditionParameters(msrest.serialization.Model):
    """Defines the parameters for UrlPath match conditions.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar type_name:  Has constant value: "DeliveryRuleUrlPathMatchConditionParameters".
    :vartype type_name: str
    :ivar operator: Required. Describes operator to be matched. Possible values include: "Any",
     "Equal", "Contains", "BeginsWith", "EndsWith", "LessThan", "LessThanOrEqual", "GreaterThan",
     "GreaterThanOrEqual", "Wildcard", "RegEx".
    :vartype operator: str or ~azure.mgmt.cdn.models.UrlPathOperator
    :ivar negate_condition: Describes if this is negate condition or not.
    :vartype negate_condition: bool
    :ivar match_values: The match value for the condition of the delivery rule.
    :vartype match_values: list[str]
    :ivar transforms: List of transforms.
    :vartype transforms: list[str or ~azure.mgmt.cdn.models.Transform]
    """

    _validation = {
        'type_name': {'required': True, 'constant': True},
        'operator': {'required': True},
    }

    _attribute_map = {
        'type_name': {'key': 'typeName', 'type': 'str'},
        'operator': {'key': 'operator', 'type': 'str'},
        'negate_condition': {'key': 'negateCondition', 'type': 'bool'},
        'match_values': {'key': 'matchValues', 'type': '[str]'},
        'transforms': {'key': 'transforms', 'type': '[str]'},
    }

    type_name = "DeliveryRuleUrlPathMatchConditionParameters"

    def __init__(
        self,
        *,
        operator: Union[str, "UrlPathOperator"],
        negate_condition: Optional[bool] = None,
        match_values: Optional[List[str]] = None,
        transforms: Optional[List[Union[str, "Transform"]]] = None,
        **kwargs
    ):
        """
        :keyword operator: Required. Describes operator to be matched. Possible values include: "Any",
         "Equal", "Contains", "BeginsWith", "EndsWith", "LessThan", "LessThanOrEqual", "GreaterThan",
         "GreaterThanOrEqual", "Wildcard", "RegEx".
        :paramtype operator: str or ~azure.mgmt.cdn.models.UrlPathOperator
        :keyword negate_condition: Describes if this is negate condition or not.
        :paramtype negate_condition: bool
        :keyword match_values: The match value for the condition of the delivery rule.
        :paramtype match_values: list[str]
        :keyword transforms: List of transforms.
        :paramtype transforms: list[str or ~azure.mgmt.cdn.models.Transform]
        """
        super(UrlPathMatchConditionParameters, self).__init__(**kwargs)
        self.operator = operator
        self.negate_condition = negate_condition
        self.match_values = match_values
        self.transforms = transforms


class UrlRedirectAction(DeliveryRuleAction):
    """Defines the url redirect action for the delivery rule.

    All required parameters must be populated in order to send to Azure.

    :ivar name: Required. The name of the action for the delivery rule.Constant filled by server.
     Possible values include: "CacheExpiration", "CacheKeyQueryString", "ModifyRequestHeader",
     "ModifyResponseHeader", "UrlRedirect", "UrlRewrite", "UrlSigning", "OriginGroupOverride",
     "RouteConfigurationOverride".
    :vartype name: str or ~azure.mgmt.cdn.models.DeliveryRuleActionEnum
    :ivar parameters: Required. Defines the parameters for the action.
    :vartype parameters: ~azure.mgmt.cdn.models.UrlRedirectActionParameters
    """

    _validation = {
        'name': {'required': True},
        'parameters': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': 'UrlRedirectActionParameters'},
    }

    def __init__(
        self,
        *,
        parameters: "UrlRedirectActionParameters",
        **kwargs
    ):
        """
        :keyword parameters: Required. Defines the parameters for the action.
        :paramtype parameters: ~azure.mgmt.cdn.models.UrlRedirectActionParameters
        """
        super(UrlRedirectAction, self).__init__(**kwargs)
        self.name = 'UrlRedirect'  # type: str
        self.parameters = parameters


class UrlRedirectActionParameters(msrest.serialization.Model):
    """Defines the parameters for the url redirect action.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar type_name:  Has constant value: "DeliveryRuleUrlRedirectActionParameters".
    :vartype type_name: str
    :ivar redirect_type: Required. The redirect type the rule will use when redirecting traffic.
     Possible values include: "Moved", "Found", "TemporaryRedirect", "PermanentRedirect".
    :vartype redirect_type: str or ~azure.mgmt.cdn.models.RedirectType
    :ivar destination_protocol: Protocol to use for the redirect. The default value is
     MatchRequest. Possible values include: "MatchRequest", "Http", "Https".
    :vartype destination_protocol: str or ~azure.mgmt.cdn.models.DestinationProtocol
    :ivar custom_path: The full path to redirect. Path cannot be empty and must start with /. Leave
     empty to use the incoming path as destination path.
    :vartype custom_path: str
    :ivar custom_hostname: Host to redirect. Leave empty to use the incoming host as the
     destination host.
    :vartype custom_hostname: str
    :ivar custom_query_string: The set of query strings to be placed in the redirect URL. Setting
     this value would replace any existing query string; leave empty to preserve the incoming query
     string. Query string must be in :code:`<key>`=:code:`<value>` format. ? and & will be added
     automatically so do not include them.
    :vartype custom_query_string: str
    :ivar custom_fragment: Fragment to add to the redirect URL. Fragment is the part of the URL
     that comes after #. Do not include the #.
    :vartype custom_fragment: str
    """

    _validation = {
        'type_name': {'required': True, 'constant': True},
        'redirect_type': {'required': True},
    }

    _attribute_map = {
        'type_name': {'key': 'typeName', 'type': 'str'},
        'redirect_type': {'key': 'redirectType', 'type': 'str'},
        'destination_protocol': {'key': 'destinationProtocol', 'type': 'str'},
        'custom_path': {'key': 'customPath', 'type': 'str'},
        'custom_hostname': {'key': 'customHostname', 'type': 'str'},
        'custom_query_string': {'key': 'customQueryString', 'type': 'str'},
        'custom_fragment': {'key': 'customFragment', 'type': 'str'},
    }

    type_name = "DeliveryRuleUrlRedirectActionParameters"

    def __init__(
        self,
        *,
        redirect_type: Union[str, "RedirectType"],
        destination_protocol: Optional[Union[str, "DestinationProtocol"]] = None,
        custom_path: Optional[str] = None,
        custom_hostname: Optional[str] = None,
        custom_query_string: Optional[str] = None,
        custom_fragment: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword redirect_type: Required. The redirect type the rule will use when redirecting traffic.
         Possible values include: "Moved", "Found", "TemporaryRedirect", "PermanentRedirect".
        :paramtype redirect_type: str or ~azure.mgmt.cdn.models.RedirectType
        :keyword destination_protocol: Protocol to use for the redirect. The default value is
         MatchRequest. Possible values include: "MatchRequest", "Http", "Https".
        :paramtype destination_protocol: str or ~azure.mgmt.cdn.models.DestinationProtocol
        :keyword custom_path: The full path to redirect. Path cannot be empty and must start with /.
         Leave empty to use the incoming path as destination path.
        :paramtype custom_path: str
        :keyword custom_hostname: Host to redirect. Leave empty to use the incoming host as the
         destination host.
        :paramtype custom_hostname: str
        :keyword custom_query_string: The set of query strings to be placed in the redirect URL.
         Setting this value would replace any existing query string; leave empty to preserve the
         incoming query string. Query string must be in :code:`<key>`=:code:`<value>` format. ? and &
         will be added automatically so do not include them.
        :paramtype custom_query_string: str
        :keyword custom_fragment: Fragment to add to the redirect URL. Fragment is the part of the URL
         that comes after #. Do not include the #.
        :paramtype custom_fragment: str
        """
        super(UrlRedirectActionParameters, self).__init__(**kwargs)
        self.redirect_type = redirect_type
        self.destination_protocol = destination_protocol
        self.custom_path = custom_path
        self.custom_hostname = custom_hostname
        self.custom_query_string = custom_query_string
        self.custom_fragment = custom_fragment


class UrlRewriteAction(DeliveryRuleAction):
    """Defines the url rewrite action for the delivery rule.

    All required parameters must be populated in order to send to Azure.

    :ivar name: Required. The name of the action for the delivery rule.Constant filled by server.
     Possible values include: "CacheExpiration", "CacheKeyQueryString", "ModifyRequestHeader",
     "ModifyResponseHeader", "UrlRedirect", "UrlRewrite", "UrlSigning", "OriginGroupOverride",
     "RouteConfigurationOverride".
    :vartype name: str or ~azure.mgmt.cdn.models.DeliveryRuleActionEnum
    :ivar parameters: Required. Defines the parameters for the action.
    :vartype parameters: ~azure.mgmt.cdn.models.UrlRewriteActionParameters
    """

    _validation = {
        'name': {'required': True},
        'parameters': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': 'UrlRewriteActionParameters'},
    }

    def __init__(
        self,
        *,
        parameters: "UrlRewriteActionParameters",
        **kwargs
    ):
        """
        :keyword parameters: Required. Defines the parameters for the action.
        :paramtype parameters: ~azure.mgmt.cdn.models.UrlRewriteActionParameters
        """
        super(UrlRewriteAction, self).__init__(**kwargs)
        self.name = 'UrlRewrite'  # type: str
        self.parameters = parameters


class UrlRewriteActionParameters(msrest.serialization.Model):
    """Defines the parameters for the url rewrite action.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar type_name:  Has constant value: "DeliveryRuleUrlRewriteActionParameters".
    :vartype type_name: str
    :ivar source_pattern: Required. define a request URI pattern that identifies the type of
     requests that may be rewritten. If value is blank, all strings are matched.
    :vartype source_pattern: str
    :ivar destination: Required. Define the relative URL to which the above requests will be
     rewritten by.
    :vartype destination: str
    :ivar preserve_unmatched_path: Whether to preserve unmatched path. Default value is true.
    :vartype preserve_unmatched_path: bool
    """

    _validation = {
        'type_name': {'required': True, 'constant': True},
        'source_pattern': {'required': True},
        'destination': {'required': True},
    }

    _attribute_map = {
        'type_name': {'key': 'typeName', 'type': 'str'},
        'source_pattern': {'key': 'sourcePattern', 'type': 'str'},
        'destination': {'key': 'destination', 'type': 'str'},
        'preserve_unmatched_path': {'key': 'preserveUnmatchedPath', 'type': 'bool'},
    }

    type_name = "DeliveryRuleUrlRewriteActionParameters"

    def __init__(
        self,
        *,
        source_pattern: str,
        destination: str,
        preserve_unmatched_path: Optional[bool] = None,
        **kwargs
    ):
        """
        :keyword source_pattern: Required. define a request URI pattern that identifies the type of
         requests that may be rewritten. If value is blank, all strings are matched.
        :paramtype source_pattern: str
        :keyword destination: Required. Define the relative URL to which the above requests will be
         rewritten by.
        :paramtype destination: str
        :keyword preserve_unmatched_path: Whether to preserve unmatched path. Default value is true.
        :paramtype preserve_unmatched_path: bool
        """
        super(UrlRewriteActionParameters, self).__init__(**kwargs)
        self.source_pattern = source_pattern
        self.destination = destination
        self.preserve_unmatched_path = preserve_unmatched_path


class UrlSigningAction(DeliveryRuleAction):
    """Defines the url signing action for the delivery rule.

    All required parameters must be populated in order to send to Azure.

    :ivar name: Required. The name of the action for the delivery rule.Constant filled by server.
     Possible values include: "CacheExpiration", "CacheKeyQueryString", "ModifyRequestHeader",
     "ModifyResponseHeader", "UrlRedirect", "UrlRewrite", "UrlSigning", "OriginGroupOverride",
     "RouteConfigurationOverride".
    :vartype name: str or ~azure.mgmt.cdn.models.DeliveryRuleActionEnum
    :ivar parameters: Required. Defines the parameters for the action.
    :vartype parameters: ~azure.mgmt.cdn.models.UrlSigningActionParameters
    """

    _validation = {
        'name': {'required': True},
        'parameters': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': 'UrlSigningActionParameters'},
    }

    def __init__(
        self,
        *,
        parameters: "UrlSigningActionParameters",
        **kwargs
    ):
        """
        :keyword parameters: Required. Defines the parameters for the action.
        :paramtype parameters: ~azure.mgmt.cdn.models.UrlSigningActionParameters
        """
        super(UrlSigningAction, self).__init__(**kwargs)
        self.name = 'UrlSigning'  # type: str
        self.parameters = parameters


class UrlSigningActionParameters(msrest.serialization.Model):
    """Defines the parameters for the Url Signing action.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar type_name:  Has constant value: "DeliveryRuleUrlSigningActionParameters".
    :vartype type_name: str
    :ivar algorithm: Algorithm to use for URL signing. Possible values include: "SHA256".
    :vartype algorithm: str or ~azure.mgmt.cdn.models.Algorithm
    :ivar parameter_name_override: Defines which query string parameters in the url to be
     considered for expires, key id etc.
    :vartype parameter_name_override: list[~azure.mgmt.cdn.models.UrlSigningParamIdentifier]
    """

    _validation = {
        'type_name': {'required': True, 'constant': True},
    }

    _attribute_map = {
        'type_name': {'key': 'typeName', 'type': 'str'},
        'algorithm': {'key': 'algorithm', 'type': 'str'},
        'parameter_name_override': {'key': 'parameterNameOverride', 'type': '[UrlSigningParamIdentifier]'},
    }

    type_name = "DeliveryRuleUrlSigningActionParameters"

    def __init__(
        self,
        *,
        algorithm: Optional[Union[str, "Algorithm"]] = None,
        parameter_name_override: Optional[List["UrlSigningParamIdentifier"]] = None,
        **kwargs
    ):
        """
        :keyword algorithm: Algorithm to use for URL signing. Possible values include: "SHA256".
        :paramtype algorithm: str or ~azure.mgmt.cdn.models.Algorithm
        :keyword parameter_name_override: Defines which query string parameters in the url to be
         considered for expires, key id etc.
        :paramtype parameter_name_override: list[~azure.mgmt.cdn.models.UrlSigningParamIdentifier]
        """
        super(UrlSigningActionParameters, self).__init__(**kwargs)
        self.algorithm = algorithm
        self.parameter_name_override = parameter_name_override


class UrlSigningKey(msrest.serialization.Model):
    """Url signing key.

    All required parameters must be populated in order to send to Azure.

    :ivar key_id: Required. Defines the customer defined key Id. This id will exist in the incoming
     request to indicate the key used to form the hash.
    :vartype key_id: str
    :ivar key_source_parameters: Required. Defines the parameters for using customer key vault for
     Url Signing Key.
    :vartype key_source_parameters: ~azure.mgmt.cdn.models.KeyVaultSigningKeyParameters
    """

    _validation = {
        'key_id': {'required': True},
        'key_source_parameters': {'required': True},
    }

    _attribute_map = {
        'key_id': {'key': 'keyId', 'type': 'str'},
        'key_source_parameters': {'key': 'keySourceParameters', 'type': 'KeyVaultSigningKeyParameters'},
    }

    def __init__(
        self,
        *,
        key_id: str,
        key_source_parameters: "KeyVaultSigningKeyParameters",
        **kwargs
    ):
        """
        :keyword key_id: Required. Defines the customer defined key Id. This id will exist in the
         incoming request to indicate the key used to form the hash.
        :paramtype key_id: str
        :keyword key_source_parameters: Required. Defines the parameters for using customer key vault
         for Url Signing Key.
        :paramtype key_source_parameters: ~azure.mgmt.cdn.models.KeyVaultSigningKeyParameters
        """
        super(UrlSigningKey, self).__init__(**kwargs)
        self.key_id = key_id
        self.key_source_parameters = key_source_parameters


class UrlSigningKeyParameters(SecretParameters):
    """Url signing key parameters.

    All required parameters must be populated in order to send to Azure.

    :ivar type: Required. The type of the secret resource.Constant filled by server. Possible
     values include: "UrlSigningKey", "CustomerCertificate", "ManagedCertificate",
     "AzureFirstPartyManagedCertificate".
    :vartype type: str or ~azure.mgmt.cdn.models.SecretType
    :ivar key_id: Required. Defines the customer defined key Id. This id will exist in the incoming
     request to indicate the key used to form the hash.
    :vartype key_id: str
    :ivar secret_source: Required. Resource reference to the Azure Key Vault secret. Expected to be
     in format of
     /subscriptions/{​​​​​​​​​subscriptionId}​​​​​​​​​/resourceGroups/{​​​​​​​​​resourceGroupName}​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​/providers/Microsoft.KeyVault/vaults/{vaultName}​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​/secrets/{secretName}​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​.
    :vartype secret_source: ~azure.mgmt.cdn.models.ResourceReference
    :ivar secret_version: Version of the secret to be used.
    :vartype secret_version: str
    """

    _validation = {
        'type': {'required': True},
        'key_id': {'required': True},
        'secret_source': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'key_id': {'key': 'keyId', 'type': 'str'},
        'secret_source': {'key': 'secretSource', 'type': 'ResourceReference'},
        'secret_version': {'key': 'secretVersion', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        key_id: str,
        secret_source: "ResourceReference",
        secret_version: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword key_id: Required. Defines the customer defined key Id. This id will exist in the
         incoming request to indicate the key used to form the hash.
        :paramtype key_id: str
        :keyword secret_source: Required. Resource reference to the Azure Key Vault secret. Expected to
         be in format of
         /subscriptions/{​​​​​​​​​subscriptionId}​​​​​​​​​/resourceGroups/{​​​​​​​​​resourceGroupName}​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​/providers/Microsoft.KeyVault/vaults/{vaultName}​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​/secrets/{secretName}​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​.
        :paramtype secret_source: ~azure.mgmt.cdn.models.ResourceReference
        :keyword secret_version: Version of the secret to be used.
        :paramtype secret_version: str
        """
        super(UrlSigningKeyParameters, self).__init__(**kwargs)
        self.type = 'UrlSigningKey'  # type: str
        self.key_id = key_id
        self.secret_source = secret_source
        self.secret_version = secret_version


class UrlSigningParamIdentifier(msrest.serialization.Model):
    """Defines how to identify a parameter for a specific purpose e.g. expires.

    All required parameters must be populated in order to send to Azure.

    :ivar param_indicator: Required. Indicates the purpose of the parameter. Possible values
     include: "Expires", "KeyId", "Signature".
    :vartype param_indicator: str or ~azure.mgmt.cdn.models.ParamIndicator
    :ivar param_name: Required. Parameter name.
    :vartype param_name: str
    """

    _validation = {
        'param_indicator': {'required': True},
        'param_name': {'required': True},
    }

    _attribute_map = {
        'param_indicator': {'key': 'paramIndicator', 'type': 'str'},
        'param_name': {'key': 'paramName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        param_indicator: Union[str, "ParamIndicator"],
        param_name: str,
        **kwargs
    ):
        """
        :keyword param_indicator: Required. Indicates the purpose of the parameter. Possible values
         include: "Expires", "KeyId", "Signature".
        :paramtype param_indicator: str or ~azure.mgmt.cdn.models.ParamIndicator
        :keyword param_name: Required. Parameter name.
        :paramtype param_name: str
        """
        super(UrlSigningParamIdentifier, self).__init__(**kwargs)
        self.param_indicator = param_indicator
        self.param_name = param_name


class Usage(msrest.serialization.Model):
    """Describes resource usage.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource identifier.
    :vartype id: str
    :ivar unit: Required. An enum describing the unit of measurement. Possible values include:
     "Count".
    :vartype unit: str or ~azure.mgmt.cdn.models.UsageUnit
    :ivar current_value: Required. The current value of the usage.
    :vartype current_value: long
    :ivar limit: Required. The limit of usage.
    :vartype limit: long
    :ivar name: Required. The name of the type of usage.
    :vartype name: ~azure.mgmt.cdn.models.UsageName
    """

    _validation = {
        'id': {'readonly': True},
        'unit': {'required': True},
        'current_value': {'required': True},
        'limit': {'required': True},
        'name': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'unit': {'key': 'unit', 'type': 'str'},
        'current_value': {'key': 'currentValue', 'type': 'long'},
        'limit': {'key': 'limit', 'type': 'long'},
        'name': {'key': 'name', 'type': 'UsageName'},
    }

    def __init__(
        self,
        *,
        unit: Union[str, "UsageUnit"],
        current_value: int,
        limit: int,
        name: "UsageName",
        **kwargs
    ):
        """
        :keyword unit: Required. An enum describing the unit of measurement. Possible values include:
         "Count".
        :paramtype unit: str or ~azure.mgmt.cdn.models.UsageUnit
        :keyword current_value: Required. The current value of the usage.
        :paramtype current_value: long
        :keyword limit: Required. The limit of usage.
        :paramtype limit: long
        :keyword name: Required. The name of the type of usage.
        :paramtype name: ~azure.mgmt.cdn.models.UsageName
        """
        super(Usage, self).__init__(**kwargs)
        self.id = None
        self.unit = unit
        self.current_value = current_value
        self.limit = limit
        self.name = name


class UsageName(msrest.serialization.Model):
    """The usage names.

    :ivar value: A string describing the resource name.
    :vartype value: str
    :ivar localized_value: A localized string describing the resource name.
    :vartype localized_value: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': 'str'},
        'localized_value': {'key': 'localizedValue', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[str] = None,
        localized_value: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword value: A string describing the resource name.
        :paramtype value: str
        :keyword localized_value: A localized string describing the resource name.
        :paramtype localized_value: str
        """
        super(UsageName, self).__init__(**kwargs)
        self.value = value
        self.localized_value = localized_value


class UsagesListResult(msrest.serialization.Model):
    """The list usages operation response.

    :ivar value: The list of resource usages.
    :vartype value: list[~azure.mgmt.cdn.models.Usage]
    :ivar next_link: URL to get the next set of results.
    :vartype next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Usage]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["Usage"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword value: The list of resource usages.
        :paramtype value: list[~azure.mgmt.cdn.models.Usage]
        :keyword next_link: URL to get the next set of results.
        :paramtype next_link: str
        """
        super(UsagesListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class UserManagedHttpsParameters(CustomDomainHttpsParameters):
    """Defines the certificate source parameters using user's keyvault certificate for enabling SSL.

    All required parameters must be populated in order to send to Azure.

    :ivar certificate_source: Required. Defines the source of the SSL certificate.Constant filled
     by server. Possible values include: "AzureKeyVault", "Cdn".
    :vartype certificate_source: str or ~azure.mgmt.cdn.models.CertificateSource
    :ivar protocol_type: Required. Defines the TLS extension protocol that is used for secure
     delivery. Possible values include: "ServerNameIndication", "IPBased".
    :vartype protocol_type: str or ~azure.mgmt.cdn.models.ProtocolType
    :ivar minimum_tls_version: TLS protocol version that will be used for Https. Possible values
     include: "None", "TLS10", "TLS12".
    :vartype minimum_tls_version: str or ~azure.mgmt.cdn.models.MinimumTlsVersion
    :ivar certificate_source_parameters: Required. Defines the certificate source parameters using
     user's keyvault certificate for enabling SSL.
    :vartype certificate_source_parameters:
     ~azure.mgmt.cdn.models.KeyVaultCertificateSourceParameters
    """

    _validation = {
        'certificate_source': {'required': True},
        'protocol_type': {'required': True},
        'certificate_source_parameters': {'required': True},
    }

    _attribute_map = {
        'certificate_source': {'key': 'certificateSource', 'type': 'str'},
        'protocol_type': {'key': 'protocolType', 'type': 'str'},
        'minimum_tls_version': {'key': 'minimumTlsVersion', 'type': 'str'},
        'certificate_source_parameters': {'key': 'certificateSourceParameters', 'type': 'KeyVaultCertificateSourceParameters'},
    }

    def __init__(
        self,
        *,
        protocol_type: Union[str, "ProtocolType"],
        certificate_source_parameters: "KeyVaultCertificateSourceParameters",
        minimum_tls_version: Optional[Union[str, "MinimumTlsVersion"]] = None,
        **kwargs
    ):
        """
        :keyword protocol_type: Required. Defines the TLS extension protocol that is used for secure
         delivery. Possible values include: "ServerNameIndication", "IPBased".
        :paramtype protocol_type: str or ~azure.mgmt.cdn.models.ProtocolType
        :keyword minimum_tls_version: TLS protocol version that will be used for Https. Possible values
         include: "None", "TLS10", "TLS12".
        :paramtype minimum_tls_version: str or ~azure.mgmt.cdn.models.MinimumTlsVersion
        :keyword certificate_source_parameters: Required. Defines the certificate source parameters
         using user's keyvault certificate for enabling SSL.
        :paramtype certificate_source_parameters:
         ~azure.mgmt.cdn.models.KeyVaultCertificateSourceParameters
        """
        super(UserManagedHttpsParameters, self).__init__(protocol_type=protocol_type, minimum_tls_version=minimum_tls_version, **kwargs)
        self.certificate_source = 'AzureKeyVault'  # type: str
        self.certificate_source_parameters = certificate_source_parameters


class ValidateCustomDomainInput(msrest.serialization.Model):
    """Input of the custom domain to be validated for DNS mapping.

    All required parameters must be populated in order to send to Azure.

    :ivar host_name: Required. The host name of the custom domain. Must be a domain name.
    :vartype host_name: str
    """

    _validation = {
        'host_name': {'required': True},
    }

    _attribute_map = {
        'host_name': {'key': 'hostName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        host_name: str,
        **kwargs
    ):
        """
        :keyword host_name: Required. The host name of the custom domain. Must be a domain name.
        :paramtype host_name: str
        """
        super(ValidateCustomDomainInput, self).__init__(**kwargs)
        self.host_name = host_name


class ValidateCustomDomainOutput(msrest.serialization.Model):
    """Output of custom domain validation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar custom_domain_validated: Indicates whether the custom domain is valid or not.
    :vartype custom_domain_validated: bool
    :ivar reason: The reason why the custom domain is not valid.
    :vartype reason: str
    :ivar message: Error message describing why the custom domain is not valid.
    :vartype message: str
    """

    _validation = {
        'custom_domain_validated': {'readonly': True},
        'reason': {'readonly': True},
        'message': {'readonly': True},
    }

    _attribute_map = {
        'custom_domain_validated': {'key': 'customDomainValidated', 'type': 'bool'},
        'reason': {'key': 'reason', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(ValidateCustomDomainOutput, self).__init__(**kwargs)
        self.custom_domain_validated = None
        self.reason = None
        self.message = None


class ValidateProbeInput(msrest.serialization.Model):
    """Input of the validate probe API.

    All required parameters must be populated in order to send to Azure.

    :ivar probe_url: Required. The probe URL to validate.
    :vartype probe_url: str
    """

    _validation = {
        'probe_url': {'required': True},
    }

    _attribute_map = {
        'probe_url': {'key': 'probeURL', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        probe_url: str,
        **kwargs
    ):
        """
        :keyword probe_url: Required. The probe URL to validate.
        :paramtype probe_url: str
        """
        super(ValidateProbeInput, self).__init__(**kwargs)
        self.probe_url = probe_url


class ValidateProbeOutput(msrest.serialization.Model):
    """Output of the validate probe API.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar is_valid: Indicates whether the probe URL is accepted or not.
    :vartype is_valid: bool
    :ivar error_code: Specifies the error code when the probe url is not accepted.
    :vartype error_code: str
    :ivar message: The detailed error message describing why the probe URL is not accepted.
    :vartype message: str
    """

    _validation = {
        'is_valid': {'readonly': True},
        'error_code': {'readonly': True},
        'message': {'readonly': True},
    }

    _attribute_map = {
        'is_valid': {'key': 'isValid', 'type': 'bool'},
        'error_code': {'key': 'errorCode', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(ValidateProbeOutput, self).__init__(**kwargs)
        self.is_valid = None
        self.error_code = None
        self.message = None


class ValidateSecretInput(msrest.serialization.Model):
    """Input of the secret to be validated.

    All required parameters must be populated in order to send to Azure.

    :ivar secret_type: Required. The secret type. Possible values include: "UrlSigningKey",
     "CustomerCertificate", "ManagedCertificate", "AzureFirstPartyManagedCertificate".
    :vartype secret_type: str or ~azure.mgmt.cdn.models.SecretType
    :ivar secret_source: Required. Resource reference to the Azure Key Vault secret. Expected to be
     in format of
     /subscriptions/{​​​​​​​​​subscriptionId}​​​​​​​​​/resourceGroups/{​​​​​​​​​resourceGroupName}​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​/providers/Microsoft.KeyVault/vaults/{vaultName}​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​/secrets/{secretName}​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​.
    :vartype secret_source: ~azure.mgmt.cdn.models.ResourceReference
    :ivar secret_version: Secret version, if customer is using a specific version.
    :vartype secret_version: str
    """

    _validation = {
        'secret_type': {'required': True},
        'secret_source': {'required': True},
    }

    _attribute_map = {
        'secret_type': {'key': 'secretType', 'type': 'str'},
        'secret_source': {'key': 'secretSource', 'type': 'ResourceReference'},
        'secret_version': {'key': 'secretVersion', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        secret_type: Union[str, "SecretType"],
        secret_source: "ResourceReference",
        secret_version: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword secret_type: Required. The secret type. Possible values include: "UrlSigningKey",
         "CustomerCertificate", "ManagedCertificate", "AzureFirstPartyManagedCertificate".
        :paramtype secret_type: str or ~azure.mgmt.cdn.models.SecretType
        :keyword secret_source: Required. Resource reference to the Azure Key Vault secret. Expected to
         be in format of
         /subscriptions/{​​​​​​​​​subscriptionId}​​​​​​​​​/resourceGroups/{​​​​​​​​​resourceGroupName}​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​/providers/Microsoft.KeyVault/vaults/{vaultName}​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​/secrets/{secretName}​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​.
        :paramtype secret_source: ~azure.mgmt.cdn.models.ResourceReference
        :keyword secret_version: Secret version, if customer is using a specific version.
        :paramtype secret_version: str
        """
        super(ValidateSecretInput, self).__init__(**kwargs)
        self.secret_type = secret_type
        self.secret_source = secret_source
        self.secret_version = secret_version


class ValidateSecretOutput(msrest.serialization.Model):
    """Output of the validated secret.

    :ivar status: The validation status. Possible values include: "Valid", "Invalid",
     "AccessDenied", "CertificateExpired".
    :vartype status: str or ~azure.mgmt.cdn.models.Status
    :ivar message: Detailed error message.
    :vartype message: str
    """

    _attribute_map = {
        'status': {'key': 'status', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        status: Optional[Union[str, "Status"]] = None,
        message: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword status: The validation status. Possible values include: "Valid", "Invalid",
         "AccessDenied", "CertificateExpired".
        :paramtype status: str or ~azure.mgmt.cdn.models.Status
        :keyword message: Detailed error message.
        :paramtype message: str
        """
        super(ValidateSecretOutput, self).__init__(**kwargs)
        self.status = status
        self.message = message


class ValidationToken(msrest.serialization.Model):
    """The validation token.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar token:
    :vartype token: str
    """

    _validation = {
        'token': {'readonly': True},
    }

    _attribute_map = {
        'token': {'key': 'token', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(ValidationToken, self).__init__(**kwargs)
        self.token = None


class WafMetricsResponse(msrest.serialization.Model):
    """Waf Metrics Response.

    :ivar date_time_begin:
    :vartype date_time_begin: ~datetime.datetime
    :ivar date_time_end:
    :vartype date_time_end: ~datetime.datetime
    :ivar granularity: Possible values include: "PT5M", "PT1H", "P1D".
    :vartype granularity: str or ~azure.mgmt.cdn.models.WafMetricsResponseGranularity
    :ivar series:
    :vartype series: list[~azure.mgmt.cdn.models.WafMetricsResponseSeriesItem]
    """

    _attribute_map = {
        'date_time_begin': {'key': 'dateTimeBegin', 'type': 'iso-8601'},
        'date_time_end': {'key': 'dateTimeEnd', 'type': 'iso-8601'},
        'granularity': {'key': 'granularity', 'type': 'str'},
        'series': {'key': 'series', 'type': '[WafMetricsResponseSeriesItem]'},
    }

    def __init__(
        self,
        *,
        date_time_begin: Optional[datetime.datetime] = None,
        date_time_end: Optional[datetime.datetime] = None,
        granularity: Optional[Union[str, "WafMetricsResponseGranularity"]] = None,
        series: Optional[List["WafMetricsResponseSeriesItem"]] = None,
        **kwargs
    ):
        """
        :keyword date_time_begin:
        :paramtype date_time_begin: ~datetime.datetime
        :keyword date_time_end:
        :paramtype date_time_end: ~datetime.datetime
        :keyword granularity: Possible values include: "PT5M", "PT1H", "P1D".
        :paramtype granularity: str or ~azure.mgmt.cdn.models.WafMetricsResponseGranularity
        :keyword series:
        :paramtype series: list[~azure.mgmt.cdn.models.WafMetricsResponseSeriesItem]
        """
        super(WafMetricsResponse, self).__init__(**kwargs)
        self.date_time_begin = date_time_begin
        self.date_time_end = date_time_end
        self.granularity = granularity
        self.series = series


class WafMetricsResponseSeriesItem(msrest.serialization.Model):
    """WafMetricsResponseSeriesItem.

    :ivar metric:
    :vartype metric: str
    :ivar unit:  The only acceptable values to pass in are None and "count". The default value is
     None.
    :vartype unit: str
    :ivar groups:
    :vartype groups: list[~azure.mgmt.cdn.models.WafMetricsResponseSeriesPropertiesItemsItem]
    :ivar data:
    :vartype data:
     list[~azure.mgmt.cdn.models.Components18OrqelSchemasWafmetricsresponsePropertiesSeriesItemsPropertiesDataItems]
    """

    _attribute_map = {
        'metric': {'key': 'metric', 'type': 'str'},
        'unit': {'key': 'unit', 'type': 'str'},
        'groups': {'key': 'groups', 'type': '[WafMetricsResponseSeriesPropertiesItemsItem]'},
        'data': {'key': 'data', 'type': '[Components18OrqelSchemasWafmetricsresponsePropertiesSeriesItemsPropertiesDataItems]'},
    }

    def __init__(
        self,
        *,
        metric: Optional[str] = None,
        unit: Optional[str] = None,
        groups: Optional[List["WafMetricsResponseSeriesPropertiesItemsItem"]] = None,
        data: Optional[List["Components18OrqelSchemasWafmetricsresponsePropertiesSeriesItemsPropertiesDataItems"]] = None,
        **kwargs
    ):
        """
        :keyword metric:
        :paramtype metric: str
        :keyword unit:  The only acceptable values to pass in are None and "count". The default value
         is None.
        :paramtype unit: str
        :keyword groups:
        :paramtype groups: list[~azure.mgmt.cdn.models.WafMetricsResponseSeriesPropertiesItemsItem]
        :keyword data:
        :paramtype data:
         list[~azure.mgmt.cdn.models.Components18OrqelSchemasWafmetricsresponsePropertiesSeriesItemsPropertiesDataItems]
        """
        super(WafMetricsResponseSeriesItem, self).__init__(**kwargs)
        self.metric = metric
        self.unit = unit
        self.groups = groups
        self.data = data


class WafMetricsResponseSeriesPropertiesItemsItem(msrest.serialization.Model):
    """WafMetricsResponseSeriesPropertiesItemsItem.

    :ivar name:
    :vartype name: str
    :ivar value:
    :vartype value: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'value': {'key': 'value', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        value: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword name:
        :paramtype name: str
        :keyword value:
        :paramtype value: str
        """
        super(WafMetricsResponseSeriesPropertiesItemsItem, self).__init__(**kwargs)
        self.name = name
        self.value = value


class WafRankingsResponse(msrest.serialization.Model):
    """Waf Rankings Response.

    :ivar date_time_begin:
    :vartype date_time_begin: ~datetime.datetime
    :ivar date_time_end:
    :vartype date_time_end: ~datetime.datetime
    :ivar groups:
    :vartype groups: list[str]
    :ivar data:
    :vartype data: list[~azure.mgmt.cdn.models.WafRankingsResponseDataItem]
    """

    _attribute_map = {
        'date_time_begin': {'key': 'dateTimeBegin', 'type': 'iso-8601'},
        'date_time_end': {'key': 'dateTimeEnd', 'type': 'iso-8601'},
        'groups': {'key': 'groups', 'type': '[str]'},
        'data': {'key': 'data', 'type': '[WafRankingsResponseDataItem]'},
    }

    def __init__(
        self,
        *,
        date_time_begin: Optional[datetime.datetime] = None,
        date_time_end: Optional[datetime.datetime] = None,
        groups: Optional[List[str]] = None,
        data: Optional[List["WafRankingsResponseDataItem"]] = None,
        **kwargs
    ):
        """
        :keyword date_time_begin:
        :paramtype date_time_begin: ~datetime.datetime
        :keyword date_time_end:
        :paramtype date_time_end: ~datetime.datetime
        :keyword groups:
        :paramtype groups: list[str]
        :keyword data:
        :paramtype data: list[~azure.mgmt.cdn.models.WafRankingsResponseDataItem]
        """
        super(WafRankingsResponse, self).__init__(**kwargs)
        self.date_time_begin = date_time_begin
        self.date_time_end = date_time_end
        self.groups = groups
        self.data = data


class WafRankingsResponseDataItem(msrest.serialization.Model):
    """WafRankingsResponseDataItem.

    :ivar group_values:
    :vartype group_values: list[str]
    :ivar metrics:
    :vartype metrics:
     list[~azure.mgmt.cdn.models.ComponentsKpo1PjSchemasWafrankingsresponsePropertiesDataItemsPropertiesMetricsItems]
    """

    _attribute_map = {
        'group_values': {'key': 'groupValues', 'type': '[str]'},
        'metrics': {'key': 'metrics', 'type': '[ComponentsKpo1PjSchemasWafrankingsresponsePropertiesDataItemsPropertiesMetricsItems]'},
    }

    def __init__(
        self,
        *,
        group_values: Optional[List[str]] = None,
        metrics: Optional[List["ComponentsKpo1PjSchemasWafrankingsresponsePropertiesDataItemsPropertiesMetricsItems"]] = None,
        **kwargs
    ):
        """
        :keyword group_values:
        :paramtype group_values: list[str]
        :keyword metrics:
        :paramtype metrics:
         list[~azure.mgmt.cdn.models.ComponentsKpo1PjSchemasWafrankingsresponsePropertiesDataItemsPropertiesMetricsItems]
        """
        super(WafRankingsResponseDataItem, self).__init__(**kwargs)
        self.group_values = group_values
        self.metrics = metrics
