# pylint: disable=line-too-long,useless-suppression,too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
from collections.abc import MutableMapping
from io import IOBase
from typing import Any, Callable, IO, Literal, Optional, TypeVar, Union, overload

from azure.core import PipelineClient
from azure.core.exceptions import (
    ClientAuthenticationError,
    HttpResponseError,
    ResourceExistsError,
    ResourceNotFoundError,
    ResourceNotModifiedError,
    map_error,
)
from azure.core.pipeline import PipelineResponse
from azure.core.rest import HttpRequest, HttpResponse
from azure.core.tracing.decorator import distributed_trace
from azure.core.utils import case_insensitive_dict

from .. import models as _models
from .._configuration import AzureFileStorageConfiguration
from .._utils.serialization import Deserializer, Serializer

T = TypeVar("T")
ClsType = Optional[Callable[[PipelineResponse[HttpRequest, HttpResponse], T, dict[str, Any]], Any]]

_SERIALIZER = Serializer()
_SERIALIZER.client_side_validation = False


def build_create_request(
    url: str,
    *,
    timeout: Optional[int] = None,
    metadata: Optional[dict[str, str]] = None,
    quota: Optional[int] = None,
    access_tier: Optional[Union[str, _models.ShareAccessTier]] = None,
    enabled_protocols: Optional[str] = None,
    root_squash: Optional[Union[str, _models.ShareRootSquash]] = None,
    enable_snapshot_virtual_directory_access: Optional[bool] = None,
    paid_bursting_enabled: Optional[bool] = None,
    paid_bursting_max_bandwidth_mibps: Optional[int] = None,
    paid_bursting_max_iops: Optional[int] = None,
    share_provisioned_iops: Optional[int] = None,
    share_provisioned_bandwidth_mibps: Optional[int] = None,
    enable_smb_directory_lease: Optional[bool] = None,
    file_request_intent: Optional[Union[str, _models.ShareTokenIntent]] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    restype: Literal["share"] = kwargs.pop("restype", _params.pop("restype", "share"))
    version: Literal["2026-02-06"] = kwargs.pop("version", _headers.pop("x-ms-version", "2026-02-06"))
    accept = _headers.pop("Accept", "application/xml")

    # Construct URL
    _url = kwargs.pop("template_url", "{url}")
    path_format_arguments = {
        "url": _SERIALIZER.url("url", url, "str", skip_quote=True),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["restype"] = _SERIALIZER.query("restype", restype, "str")
    if timeout is not None:
        _params["timeout"] = _SERIALIZER.query("timeout", timeout, "int", minimum=0)

    # Construct headers
    if metadata is not None:
        _headers["x-ms-meta"] = _SERIALIZER.header("metadata", metadata, "{str}")
    if quota is not None:
        _headers["x-ms-share-quota"] = _SERIALIZER.header("quota", quota, "int", minimum=1)
    if access_tier is not None:
        _headers["x-ms-access-tier"] = _SERIALIZER.header("access_tier", access_tier, "str")
    _headers["x-ms-version"] = _SERIALIZER.header("version", version, "str")
    if enabled_protocols is not None:
        _headers["x-ms-enabled-protocols"] = _SERIALIZER.header("enabled_protocols", enabled_protocols, "str")
    if root_squash is not None:
        _headers["x-ms-root-squash"] = _SERIALIZER.header("root_squash", root_squash, "str")
    if enable_snapshot_virtual_directory_access is not None:
        _headers["x-ms-enable-snapshot-virtual-directory-access"] = _SERIALIZER.header(
            "enable_snapshot_virtual_directory_access", enable_snapshot_virtual_directory_access, "bool"
        )
    if paid_bursting_enabled is not None:
        _headers["x-ms-share-paid-bursting-enabled"] = _SERIALIZER.header(
            "paid_bursting_enabled", paid_bursting_enabled, "bool"
        )
    if paid_bursting_max_bandwidth_mibps is not None:
        _headers["x-ms-share-paid-bursting-max-bandwidth-mibps"] = _SERIALIZER.header(
            "paid_bursting_max_bandwidth_mibps", paid_bursting_max_bandwidth_mibps, "int"
        )
    if paid_bursting_max_iops is not None:
        _headers["x-ms-share-paid-bursting-max-iops"] = _SERIALIZER.header(
            "paid_bursting_max_iops", paid_bursting_max_iops, "int"
        )
    if file_request_intent is not None:
        _headers["x-ms-file-request-intent"] = _SERIALIZER.header("file_request_intent", file_request_intent, "str")
    if share_provisioned_iops is not None:
        _headers["x-ms-share-provisioned-iops"] = _SERIALIZER.header(
            "share_provisioned_iops", share_provisioned_iops, "int"
        )
    if share_provisioned_bandwidth_mibps is not None:
        _headers["x-ms-share-provisioned-bandwidth-mibps"] = _SERIALIZER.header(
            "share_provisioned_bandwidth_mibps", share_provisioned_bandwidth_mibps, "int"
        )
    if enable_smb_directory_lease is not None:
        _headers["x-ms-enable-smb-directory-lease"] = _SERIALIZER.header(
            "enable_smb_directory_lease", enable_smb_directory_lease, "bool"
        )
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="PUT", url=_url, params=_params, headers=_headers, **kwargs)


def build_get_properties_request(
    url: str,
    *,
    sharesnapshot: Optional[str] = None,
    timeout: Optional[int] = None,
    lease_id: Optional[str] = None,
    file_request_intent: Optional[Union[str, _models.ShareTokenIntent]] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    restype: Literal["share"] = kwargs.pop("restype", _params.pop("restype", "share"))
    version: Literal["2026-02-06"] = kwargs.pop("version", _headers.pop("x-ms-version", "2026-02-06"))
    accept = _headers.pop("Accept", "application/xml")

    # Construct URL
    _url = kwargs.pop("template_url", "{url}")
    path_format_arguments = {
        "url": _SERIALIZER.url("url", url, "str", skip_quote=True),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["restype"] = _SERIALIZER.query("restype", restype, "str")
    if sharesnapshot is not None:
        _params["sharesnapshot"] = _SERIALIZER.query("sharesnapshot", sharesnapshot, "str")
    if timeout is not None:
        _params["timeout"] = _SERIALIZER.query("timeout", timeout, "int", minimum=0)

    # Construct headers
    _headers["x-ms-version"] = _SERIALIZER.header("version", version, "str")
    if lease_id is not None:
        _headers["x-ms-lease-id"] = _SERIALIZER.header("lease_id", lease_id, "str")
    if file_request_intent is not None:
        _headers["x-ms-file-request-intent"] = _SERIALIZER.header("file_request_intent", file_request_intent, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_delete_request(
    url: str,
    *,
    sharesnapshot: Optional[str] = None,
    timeout: Optional[int] = None,
    delete_snapshots: Optional[Union[str, _models.DeleteSnapshotsOptionType]] = None,
    lease_id: Optional[str] = None,
    file_request_intent: Optional[Union[str, _models.ShareTokenIntent]] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    restype: Literal["share"] = kwargs.pop("restype", _params.pop("restype", "share"))
    version: Literal["2026-02-06"] = kwargs.pop("version", _headers.pop("x-ms-version", "2026-02-06"))
    accept = _headers.pop("Accept", "application/xml")

    # Construct URL
    _url = kwargs.pop("template_url", "{url}")
    path_format_arguments = {
        "url": _SERIALIZER.url("url", url, "str", skip_quote=True),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["restype"] = _SERIALIZER.query("restype", restype, "str")
    if sharesnapshot is not None:
        _params["sharesnapshot"] = _SERIALIZER.query("sharesnapshot", sharesnapshot, "str")
    if timeout is not None:
        _params["timeout"] = _SERIALIZER.query("timeout", timeout, "int", minimum=0)

    # Construct headers
    _headers["x-ms-version"] = _SERIALIZER.header("version", version, "str")
    if delete_snapshots is not None:
        _headers["x-ms-delete-snapshots"] = _SERIALIZER.header("delete_snapshots", delete_snapshots, "str")
    if lease_id is not None:
        _headers["x-ms-lease-id"] = _SERIALIZER.header("lease_id", lease_id, "str")
    if file_request_intent is not None:
        _headers["x-ms-file-request-intent"] = _SERIALIZER.header("file_request_intent", file_request_intent, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="DELETE", url=_url, params=_params, headers=_headers, **kwargs)


def build_acquire_lease_request(
    url: str,
    *,
    timeout: Optional[int] = None,
    duration: Optional[int] = None,
    proposed_lease_id: Optional[str] = None,
    sharesnapshot: Optional[str] = None,
    request_id_parameter: Optional[str] = None,
    file_request_intent: Optional[Union[str, _models.ShareTokenIntent]] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    comp: Literal["lease"] = kwargs.pop("comp", _params.pop("comp", "lease"))
    action: Literal["acquire"] = kwargs.pop("action", _headers.pop("x-ms-lease-action", "acquire"))
    restype: Literal["share"] = kwargs.pop("restype", _params.pop("restype", "share"))
    version: Literal["2026-02-06"] = kwargs.pop("version", _headers.pop("x-ms-version", "2026-02-06"))
    accept = _headers.pop("Accept", "application/xml")

    # Construct URL
    _url = kwargs.pop("template_url", "{url}")
    path_format_arguments = {
        "url": _SERIALIZER.url("url", url, "str", skip_quote=True),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["comp"] = _SERIALIZER.query("comp", comp, "str")
    _params["restype"] = _SERIALIZER.query("restype", restype, "str")
    if timeout is not None:
        _params["timeout"] = _SERIALIZER.query("timeout", timeout, "int", minimum=0)
    if sharesnapshot is not None:
        _params["sharesnapshot"] = _SERIALIZER.query("sharesnapshot", sharesnapshot, "str")

    # Construct headers
    _headers["x-ms-lease-action"] = _SERIALIZER.header("action", action, "str")
    if duration is not None:
        _headers["x-ms-lease-duration"] = _SERIALIZER.header("duration", duration, "int")
    if proposed_lease_id is not None:
        _headers["x-ms-proposed-lease-id"] = _SERIALIZER.header("proposed_lease_id", proposed_lease_id, "str")
    _headers["x-ms-version"] = _SERIALIZER.header("version", version, "str")
    if request_id_parameter is not None:
        _headers["x-ms-client-request-id"] = _SERIALIZER.header("request_id_parameter", request_id_parameter, "str")
    if file_request_intent is not None:
        _headers["x-ms-file-request-intent"] = _SERIALIZER.header("file_request_intent", file_request_intent, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="PUT", url=_url, params=_params, headers=_headers, **kwargs)


def build_release_lease_request(
    url: str,
    *,
    lease_id: str,
    timeout: Optional[int] = None,
    sharesnapshot: Optional[str] = None,
    request_id_parameter: Optional[str] = None,
    file_request_intent: Optional[Union[str, _models.ShareTokenIntent]] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    comp: Literal["lease"] = kwargs.pop("comp", _params.pop("comp", "lease"))
    action: Literal["release"] = kwargs.pop("action", _headers.pop("x-ms-lease-action", "release"))
    restype: Literal["share"] = kwargs.pop("restype", _params.pop("restype", "share"))
    version: Literal["2026-02-06"] = kwargs.pop("version", _headers.pop("x-ms-version", "2026-02-06"))
    accept = _headers.pop("Accept", "application/xml")

    # Construct URL
    _url = kwargs.pop("template_url", "{url}")
    path_format_arguments = {
        "url": _SERIALIZER.url("url", url, "str", skip_quote=True),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["comp"] = _SERIALIZER.query("comp", comp, "str")
    _params["restype"] = _SERIALIZER.query("restype", restype, "str")
    if timeout is not None:
        _params["timeout"] = _SERIALIZER.query("timeout", timeout, "int", minimum=0)
    if sharesnapshot is not None:
        _params["sharesnapshot"] = _SERIALIZER.query("sharesnapshot", sharesnapshot, "str")

    # Construct headers
    _headers["x-ms-lease-action"] = _SERIALIZER.header("action", action, "str")
    _headers["x-ms-lease-id"] = _SERIALIZER.header("lease_id", lease_id, "str")
    _headers["x-ms-version"] = _SERIALIZER.header("version", version, "str")
    if request_id_parameter is not None:
        _headers["x-ms-client-request-id"] = _SERIALIZER.header("request_id_parameter", request_id_parameter, "str")
    if file_request_intent is not None:
        _headers["x-ms-file-request-intent"] = _SERIALIZER.header("file_request_intent", file_request_intent, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="PUT", url=_url, params=_params, headers=_headers, **kwargs)


def build_change_lease_request(
    url: str,
    *,
    lease_id: str,
    timeout: Optional[int] = None,
    proposed_lease_id: Optional[str] = None,
    sharesnapshot: Optional[str] = None,
    request_id_parameter: Optional[str] = None,
    file_request_intent: Optional[Union[str, _models.ShareTokenIntent]] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    comp: Literal["lease"] = kwargs.pop("comp", _params.pop("comp", "lease"))
    action: Literal["change"] = kwargs.pop("action", _headers.pop("x-ms-lease-action", "change"))
    restype: Literal["share"] = kwargs.pop("restype", _params.pop("restype", "share"))
    version: Literal["2026-02-06"] = kwargs.pop("version", _headers.pop("x-ms-version", "2026-02-06"))
    accept = _headers.pop("Accept", "application/xml")

    # Construct URL
    _url = kwargs.pop("template_url", "{url}")
    path_format_arguments = {
        "url": _SERIALIZER.url("url", url, "str", skip_quote=True),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["comp"] = _SERIALIZER.query("comp", comp, "str")
    _params["restype"] = _SERIALIZER.query("restype", restype, "str")
    if timeout is not None:
        _params["timeout"] = _SERIALIZER.query("timeout", timeout, "int", minimum=0)
    if sharesnapshot is not None:
        _params["sharesnapshot"] = _SERIALIZER.query("sharesnapshot", sharesnapshot, "str")

    # Construct headers
    _headers["x-ms-lease-action"] = _SERIALIZER.header("action", action, "str")
    _headers["x-ms-lease-id"] = _SERIALIZER.header("lease_id", lease_id, "str")
    if proposed_lease_id is not None:
        _headers["x-ms-proposed-lease-id"] = _SERIALIZER.header("proposed_lease_id", proposed_lease_id, "str")
    _headers["x-ms-version"] = _SERIALIZER.header("version", version, "str")
    if request_id_parameter is not None:
        _headers["x-ms-client-request-id"] = _SERIALIZER.header("request_id_parameter", request_id_parameter, "str")
    if file_request_intent is not None:
        _headers["x-ms-file-request-intent"] = _SERIALIZER.header("file_request_intent", file_request_intent, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="PUT", url=_url, params=_params, headers=_headers, **kwargs)


def build_renew_lease_request(
    url: str,
    *,
    lease_id: str,
    timeout: Optional[int] = None,
    sharesnapshot: Optional[str] = None,
    request_id_parameter: Optional[str] = None,
    file_request_intent: Optional[Union[str, _models.ShareTokenIntent]] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    comp: Literal["lease"] = kwargs.pop("comp", _params.pop("comp", "lease"))
    action: Literal["renew"] = kwargs.pop("action", _headers.pop("x-ms-lease-action", "renew"))
    restype: Literal["share"] = kwargs.pop("restype", _params.pop("restype", "share"))
    version: Literal["2026-02-06"] = kwargs.pop("version", _headers.pop("x-ms-version", "2026-02-06"))
    accept = _headers.pop("Accept", "application/xml")

    # Construct URL
    _url = kwargs.pop("template_url", "{url}")
    path_format_arguments = {
        "url": _SERIALIZER.url("url", url, "str", skip_quote=True),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["comp"] = _SERIALIZER.query("comp", comp, "str")
    _params["restype"] = _SERIALIZER.query("restype", restype, "str")
    if timeout is not None:
        _params["timeout"] = _SERIALIZER.query("timeout", timeout, "int", minimum=0)
    if sharesnapshot is not None:
        _params["sharesnapshot"] = _SERIALIZER.query("sharesnapshot", sharesnapshot, "str")

    # Construct headers
    _headers["x-ms-lease-action"] = _SERIALIZER.header("action", action, "str")
    _headers["x-ms-lease-id"] = _SERIALIZER.header("lease_id", lease_id, "str")
    _headers["x-ms-version"] = _SERIALIZER.header("version", version, "str")
    if request_id_parameter is not None:
        _headers["x-ms-client-request-id"] = _SERIALIZER.header("request_id_parameter", request_id_parameter, "str")
    if file_request_intent is not None:
        _headers["x-ms-file-request-intent"] = _SERIALIZER.header("file_request_intent", file_request_intent, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="PUT", url=_url, params=_params, headers=_headers, **kwargs)


def build_break_lease_request(
    url: str,
    *,
    timeout: Optional[int] = None,
    break_period: Optional[int] = None,
    lease_id: Optional[str] = None,
    request_id_parameter: Optional[str] = None,
    sharesnapshot: Optional[str] = None,
    file_request_intent: Optional[Union[str, _models.ShareTokenIntent]] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    comp: Literal["lease"] = kwargs.pop("comp", _params.pop("comp", "lease"))
    action: Literal["break"] = kwargs.pop("action", _headers.pop("x-ms-lease-action", "break"))
    restype: Literal["share"] = kwargs.pop("restype", _params.pop("restype", "share"))
    version: Literal["2026-02-06"] = kwargs.pop("version", _headers.pop("x-ms-version", "2026-02-06"))
    accept = _headers.pop("Accept", "application/xml")

    # Construct URL
    _url = kwargs.pop("template_url", "{url}")
    path_format_arguments = {
        "url": _SERIALIZER.url("url", url, "str", skip_quote=True),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["comp"] = _SERIALIZER.query("comp", comp, "str")
    _params["restype"] = _SERIALIZER.query("restype", restype, "str")
    if timeout is not None:
        _params["timeout"] = _SERIALIZER.query("timeout", timeout, "int", minimum=0)
    if sharesnapshot is not None:
        _params["sharesnapshot"] = _SERIALIZER.query("sharesnapshot", sharesnapshot, "str")

    # Construct headers
    _headers["x-ms-lease-action"] = _SERIALIZER.header("action", action, "str")
    if break_period is not None:
        _headers["x-ms-lease-break-period"] = _SERIALIZER.header("break_period", break_period, "int")
    if lease_id is not None:
        _headers["x-ms-lease-id"] = _SERIALIZER.header("lease_id", lease_id, "str")
    _headers["x-ms-version"] = _SERIALIZER.header("version", version, "str")
    if request_id_parameter is not None:
        _headers["x-ms-client-request-id"] = _SERIALIZER.header("request_id_parameter", request_id_parameter, "str")
    if file_request_intent is not None:
        _headers["x-ms-file-request-intent"] = _SERIALIZER.header("file_request_intent", file_request_intent, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="PUT", url=_url, params=_params, headers=_headers, **kwargs)


def build_create_snapshot_request(
    url: str,
    *,
    timeout: Optional[int] = None,
    metadata: Optional[dict[str, str]] = None,
    file_request_intent: Optional[Union[str, _models.ShareTokenIntent]] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    restype: Literal["share"] = kwargs.pop("restype", _params.pop("restype", "share"))
    comp: Literal["snapshot"] = kwargs.pop("comp", _params.pop("comp", "snapshot"))
    version: Literal["2026-02-06"] = kwargs.pop("version", _headers.pop("x-ms-version", "2026-02-06"))
    accept = _headers.pop("Accept", "application/xml")

    # Construct URL
    _url = kwargs.pop("template_url", "{url}")
    path_format_arguments = {
        "url": _SERIALIZER.url("url", url, "str", skip_quote=True),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["restype"] = _SERIALIZER.query("restype", restype, "str")
    _params["comp"] = _SERIALIZER.query("comp", comp, "str")
    if timeout is not None:
        _params["timeout"] = _SERIALIZER.query("timeout", timeout, "int", minimum=0)

    # Construct headers
    if metadata is not None:
        _headers["x-ms-meta"] = _SERIALIZER.header("metadata", metadata, "{str}")
    _headers["x-ms-version"] = _SERIALIZER.header("version", version, "str")
    if file_request_intent is not None:
        _headers["x-ms-file-request-intent"] = _SERIALIZER.header("file_request_intent", file_request_intent, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="PUT", url=_url, params=_params, headers=_headers, **kwargs)


def build_create_permission_request(
    url: str,
    *,
    timeout: Optional[int] = None,
    file_request_intent: Optional[Union[str, _models.ShareTokenIntent]] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    restype: Literal["share"] = kwargs.pop("restype", _params.pop("restype", "share"))
    comp: Literal["filepermission"] = kwargs.pop("comp", _params.pop("comp", "filepermission"))
    content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
    version: Literal["2026-02-06"] = kwargs.pop("version", _headers.pop("x-ms-version", "2026-02-06"))
    accept = _headers.pop("Accept", "application/xml")

    # Construct URL
    _url = kwargs.pop("template_url", "{url}")
    path_format_arguments = {
        "url": _SERIALIZER.url("url", url, "str", skip_quote=True),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["restype"] = _SERIALIZER.query("restype", restype, "str")
    _params["comp"] = _SERIALIZER.query("comp", comp, "str")
    if timeout is not None:
        _params["timeout"] = _SERIALIZER.query("timeout", timeout, "int", minimum=0)

    # Construct headers
    _headers["x-ms-version"] = _SERIALIZER.header("version", version, "str")
    if file_request_intent is not None:
        _headers["x-ms-file-request-intent"] = _SERIALIZER.header("file_request_intent", file_request_intent, "str")
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header("content_type", content_type, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="PUT", url=_url, params=_params, headers=_headers, **kwargs)


def build_get_permission_request(
    url: str,
    *,
    file_permission_key: str,
    file_permission_format: Optional[Union[str, _models.FilePermissionFormat]] = None,
    timeout: Optional[int] = None,
    file_request_intent: Optional[Union[str, _models.ShareTokenIntent]] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    restype: Literal["share"] = kwargs.pop("restype", _params.pop("restype", "share"))
    comp: Literal["filepermission"] = kwargs.pop("comp", _params.pop("comp", "filepermission"))
    version: Literal["2026-02-06"] = kwargs.pop("version", _headers.pop("x-ms-version", "2026-02-06"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = kwargs.pop("template_url", "{url}")
    path_format_arguments = {
        "url": _SERIALIZER.url("url", url, "str", skip_quote=True),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["restype"] = _SERIALIZER.query("restype", restype, "str")
    _params["comp"] = _SERIALIZER.query("comp", comp, "str")
    if timeout is not None:
        _params["timeout"] = _SERIALIZER.query("timeout", timeout, "int", minimum=0)

    # Construct headers
    _headers["x-ms-file-permission-key"] = _SERIALIZER.header("file_permission_key", file_permission_key, "str")
    if file_permission_format is not None:
        _headers["x-ms-file-permission-format"] = _SERIALIZER.header(
            "file_permission_format", file_permission_format, "str"
        )
    _headers["x-ms-version"] = _SERIALIZER.header("version", version, "str")
    if file_request_intent is not None:
        _headers["x-ms-file-request-intent"] = _SERIALIZER.header("file_request_intent", file_request_intent, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_set_properties_request(
    url: str,
    *,
    timeout: Optional[int] = None,
    quota: Optional[int] = None,
    access_tier: Optional[Union[str, _models.ShareAccessTier]] = None,
    lease_id: Optional[str] = None,
    root_squash: Optional[Union[str, _models.ShareRootSquash]] = None,
    enable_snapshot_virtual_directory_access: Optional[bool] = None,
    paid_bursting_enabled: Optional[bool] = None,
    paid_bursting_max_bandwidth_mibps: Optional[int] = None,
    paid_bursting_max_iops: Optional[int] = None,
    share_provisioned_iops: Optional[int] = None,
    share_provisioned_bandwidth_mibps: Optional[int] = None,
    enable_smb_directory_lease: Optional[bool] = None,
    file_request_intent: Optional[Union[str, _models.ShareTokenIntent]] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    restype: Literal["share"] = kwargs.pop("restype", _params.pop("restype", "share"))
    comp: Literal["properties"] = kwargs.pop("comp", _params.pop("comp", "properties"))
    version: Literal["2026-02-06"] = kwargs.pop("version", _headers.pop("x-ms-version", "2026-02-06"))
    accept = _headers.pop("Accept", "application/xml")

    # Construct URL
    _url = kwargs.pop("template_url", "{url}")
    path_format_arguments = {
        "url": _SERIALIZER.url("url", url, "str", skip_quote=True),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["restype"] = _SERIALIZER.query("restype", restype, "str")
    _params["comp"] = _SERIALIZER.query("comp", comp, "str")
    if timeout is not None:
        _params["timeout"] = _SERIALIZER.query("timeout", timeout, "int", minimum=0)

    # Construct headers
    _headers["x-ms-version"] = _SERIALIZER.header("version", version, "str")
    if quota is not None:
        _headers["x-ms-share-quota"] = _SERIALIZER.header("quota", quota, "int", minimum=1)
    if access_tier is not None:
        _headers["x-ms-access-tier"] = _SERIALIZER.header("access_tier", access_tier, "str")
    if lease_id is not None:
        _headers["x-ms-lease-id"] = _SERIALIZER.header("lease_id", lease_id, "str")
    if root_squash is not None:
        _headers["x-ms-root-squash"] = _SERIALIZER.header("root_squash", root_squash, "str")
    if enable_snapshot_virtual_directory_access is not None:
        _headers["x-ms-enable-snapshot-virtual-directory-access"] = _SERIALIZER.header(
            "enable_snapshot_virtual_directory_access", enable_snapshot_virtual_directory_access, "bool"
        )
    if paid_bursting_enabled is not None:
        _headers["x-ms-share-paid-bursting-enabled"] = _SERIALIZER.header(
            "paid_bursting_enabled", paid_bursting_enabled, "bool"
        )
    if paid_bursting_max_bandwidth_mibps is not None:
        _headers["x-ms-share-paid-bursting-max-bandwidth-mibps"] = _SERIALIZER.header(
            "paid_bursting_max_bandwidth_mibps", paid_bursting_max_bandwidth_mibps, "int"
        )
    if paid_bursting_max_iops is not None:
        _headers["x-ms-share-paid-bursting-max-iops"] = _SERIALIZER.header(
            "paid_bursting_max_iops", paid_bursting_max_iops, "int"
        )
    if file_request_intent is not None:
        _headers["x-ms-file-request-intent"] = _SERIALIZER.header("file_request_intent", file_request_intent, "str")
    if share_provisioned_iops is not None:
        _headers["x-ms-share-provisioned-iops"] = _SERIALIZER.header(
            "share_provisioned_iops", share_provisioned_iops, "int"
        )
    if share_provisioned_bandwidth_mibps is not None:
        _headers["x-ms-share-provisioned-bandwidth-mibps"] = _SERIALIZER.header(
            "share_provisioned_bandwidth_mibps", share_provisioned_bandwidth_mibps, "int"
        )
    if enable_smb_directory_lease is not None:
        _headers["x-ms-enable-smb-directory-lease"] = _SERIALIZER.header(
            "enable_smb_directory_lease", enable_smb_directory_lease, "bool"
        )
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="PUT", url=_url, params=_params, headers=_headers, **kwargs)


def build_set_metadata_request(
    url: str,
    *,
    timeout: Optional[int] = None,
    metadata: Optional[dict[str, str]] = None,
    lease_id: Optional[str] = None,
    file_request_intent: Optional[Union[str, _models.ShareTokenIntent]] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    restype: Literal["share"] = kwargs.pop("restype", _params.pop("restype", "share"))
    comp: Literal["metadata"] = kwargs.pop("comp", _params.pop("comp", "metadata"))
    version: Literal["2026-02-06"] = kwargs.pop("version", _headers.pop("x-ms-version", "2026-02-06"))
    accept = _headers.pop("Accept", "application/xml")

    # Construct URL
    _url = kwargs.pop("template_url", "{url}")
    path_format_arguments = {
        "url": _SERIALIZER.url("url", url, "str", skip_quote=True),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["restype"] = _SERIALIZER.query("restype", restype, "str")
    _params["comp"] = _SERIALIZER.query("comp", comp, "str")
    if timeout is not None:
        _params["timeout"] = _SERIALIZER.query("timeout", timeout, "int", minimum=0)

    # Construct headers
    if metadata is not None:
        _headers["x-ms-meta"] = _SERIALIZER.header("metadata", metadata, "{str}")
    _headers["x-ms-version"] = _SERIALIZER.header("version", version, "str")
    if lease_id is not None:
        _headers["x-ms-lease-id"] = _SERIALIZER.header("lease_id", lease_id, "str")
    if file_request_intent is not None:
        _headers["x-ms-file-request-intent"] = _SERIALIZER.header("file_request_intent", file_request_intent, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="PUT", url=_url, params=_params, headers=_headers, **kwargs)


def build_get_access_policy_request(
    url: str,
    *,
    timeout: Optional[int] = None,
    lease_id: Optional[str] = None,
    file_request_intent: Optional[Union[str, _models.ShareTokenIntent]] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    restype: Literal["share"] = kwargs.pop("restype", _params.pop("restype", "share"))
    comp: Literal["acl"] = kwargs.pop("comp", _params.pop("comp", "acl"))
    version: Literal["2026-02-06"] = kwargs.pop("version", _headers.pop("x-ms-version", "2026-02-06"))
    accept = _headers.pop("Accept", "application/xml")

    # Construct URL
    _url = kwargs.pop("template_url", "{url}")
    path_format_arguments = {
        "url": _SERIALIZER.url("url", url, "str", skip_quote=True),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["restype"] = _SERIALIZER.query("restype", restype, "str")
    _params["comp"] = _SERIALIZER.query("comp", comp, "str")
    if timeout is not None:
        _params["timeout"] = _SERIALIZER.query("timeout", timeout, "int", minimum=0)

    # Construct headers
    _headers["x-ms-version"] = _SERIALIZER.header("version", version, "str")
    if lease_id is not None:
        _headers["x-ms-lease-id"] = _SERIALIZER.header("lease_id", lease_id, "str")
    if file_request_intent is not None:
        _headers["x-ms-file-request-intent"] = _SERIALIZER.header("file_request_intent", file_request_intent, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_set_access_policy_request(
    url: str,
    *,
    timeout: Optional[int] = None,
    lease_id: Optional[str] = None,
    content: Any = None,
    file_request_intent: Optional[Union[str, _models.ShareTokenIntent]] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    restype: Literal["share"] = kwargs.pop("restype", _params.pop("restype", "share"))
    comp: Literal["acl"] = kwargs.pop("comp", _params.pop("comp", "acl"))
    content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
    version: Literal["2026-02-06"] = kwargs.pop("version", _headers.pop("x-ms-version", "2026-02-06"))
    accept = _headers.pop("Accept", "application/xml")

    # Construct URL
    _url = kwargs.pop("template_url", "{url}")
    path_format_arguments = {
        "url": _SERIALIZER.url("url", url, "str", skip_quote=True),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["restype"] = _SERIALIZER.query("restype", restype, "str")
    _params["comp"] = _SERIALIZER.query("comp", comp, "str")
    if timeout is not None:
        _params["timeout"] = _SERIALIZER.query("timeout", timeout, "int", minimum=0)

    # Construct headers
    _headers["x-ms-version"] = _SERIALIZER.header("version", version, "str")
    if lease_id is not None:
        _headers["x-ms-lease-id"] = _SERIALIZER.header("lease_id", lease_id, "str")
    if file_request_intent is not None:
        _headers["x-ms-file-request-intent"] = _SERIALIZER.header("file_request_intent", file_request_intent, "str")
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header("content_type", content_type, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="PUT", url=_url, params=_params, headers=_headers, content=content, **kwargs)


def build_get_statistics_request(
    url: str,
    *,
    timeout: Optional[int] = None,
    lease_id: Optional[str] = None,
    file_request_intent: Optional[Union[str, _models.ShareTokenIntent]] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    restype: Literal["share"] = kwargs.pop("restype", _params.pop("restype", "share"))
    comp: Literal["stats"] = kwargs.pop("comp", _params.pop("comp", "stats"))
    version: Literal["2026-02-06"] = kwargs.pop("version", _headers.pop("x-ms-version", "2026-02-06"))
    accept = _headers.pop("Accept", "application/xml")

    # Construct URL
    _url = kwargs.pop("template_url", "{url}")
    path_format_arguments = {
        "url": _SERIALIZER.url("url", url, "str", skip_quote=True),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["restype"] = _SERIALIZER.query("restype", restype, "str")
    _params["comp"] = _SERIALIZER.query("comp", comp, "str")
    if timeout is not None:
        _params["timeout"] = _SERIALIZER.query("timeout", timeout, "int", minimum=0)

    # Construct headers
    _headers["x-ms-version"] = _SERIALIZER.header("version", version, "str")
    if lease_id is not None:
        _headers["x-ms-lease-id"] = _SERIALIZER.header("lease_id", lease_id, "str")
    if file_request_intent is not None:
        _headers["x-ms-file-request-intent"] = _SERIALIZER.header("file_request_intent", file_request_intent, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_restore_request(
    url: str,
    *,
    timeout: Optional[int] = None,
    request_id_parameter: Optional[str] = None,
    deleted_share_name: Optional[str] = None,
    deleted_share_version: Optional[str] = None,
    file_request_intent: Optional[Union[str, _models.ShareTokenIntent]] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    restype: Literal["share"] = kwargs.pop("restype", _params.pop("restype", "share"))
    comp: Literal["undelete"] = kwargs.pop("comp", _params.pop("comp", "undelete"))
    version: Literal["2026-02-06"] = kwargs.pop("version", _headers.pop("x-ms-version", "2026-02-06"))
    accept = _headers.pop("Accept", "application/xml")

    # Construct URL
    _url = kwargs.pop("template_url", "{url}")
    path_format_arguments = {
        "url": _SERIALIZER.url("url", url, "str", skip_quote=True),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["restype"] = _SERIALIZER.query("restype", restype, "str")
    _params["comp"] = _SERIALIZER.query("comp", comp, "str")
    if timeout is not None:
        _params["timeout"] = _SERIALIZER.query("timeout", timeout, "int", minimum=0)

    # Construct headers
    _headers["x-ms-version"] = _SERIALIZER.header("version", version, "str")
    if request_id_parameter is not None:
        _headers["x-ms-client-request-id"] = _SERIALIZER.header("request_id_parameter", request_id_parameter, "str")
    if deleted_share_name is not None:
        _headers["x-ms-deleted-share-name"] = _SERIALIZER.header("deleted_share_name", deleted_share_name, "str")
    if deleted_share_version is not None:
        _headers["x-ms-deleted-share-version"] = _SERIALIZER.header(
            "deleted_share_version", deleted_share_version, "str"
        )
    if file_request_intent is not None:
        _headers["x-ms-file-request-intent"] = _SERIALIZER.header("file_request_intent", file_request_intent, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="PUT", url=_url, params=_params, headers=_headers, **kwargs)


class ShareOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.storage.fileshare.AzureFileStorage`'s
        :attr:`share` attribute.
    """

    models = _models

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client: PipelineClient = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config: AzureFileStorageConfiguration = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize: Serializer = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize: Deserializer = input_args.pop(0) if input_args else kwargs.pop("deserializer")

    @distributed_trace
    def create(  # pylint: disable=inconsistent-return-statements
        self,
        timeout: Optional[int] = None,
        metadata: Optional[dict[str, str]] = None,
        quota: Optional[int] = None,
        access_tier: Optional[Union[str, _models.ShareAccessTier]] = None,
        enabled_protocols: Optional[str] = None,
        root_squash: Optional[Union[str, _models.ShareRootSquash]] = None,
        enable_snapshot_virtual_directory_access: Optional[bool] = None,
        paid_bursting_enabled: Optional[bool] = None,
        paid_bursting_max_bandwidth_mibps: Optional[int] = None,
        paid_bursting_max_iops: Optional[int] = None,
        share_provisioned_iops: Optional[int] = None,
        share_provisioned_bandwidth_mibps: Optional[int] = None,
        enable_smb_directory_lease: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """Creates a new share under the specified account. If the share with the same name already
        exists, the operation fails.

        :param timeout: The timeout parameter is expressed in seconds. For more information, see
         :code:`<a
         href="https://learn.microsoft.com/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations">Setting
         Timeouts for File Service Operations.</a>`. Default value is None.
        :type timeout: int
        :param metadata: A name-value pair to associate with a file storage object. Default value is
         None.
        :type metadata: dict[str, str]
        :param quota: Specifies the maximum size of the share, in gigabytes. Default value is None.
        :type quota: int
        :param access_tier: Specifies the access tier of the share. Known values are:
         "TransactionOptimized", "Hot", "Cool", and "Premium". Default value is None.
        :type access_tier: str or ~azure.storage.fileshare.models.ShareAccessTier
        :param enabled_protocols: Protocols to enable on the share. Default value is None.
        :type enabled_protocols: str
        :param root_squash: Root squash to set on the share.  Only valid for NFS shares. Known values
         are: "NoRootSquash", "RootSquash", and "AllSquash". Default value is None.
        :type root_squash: str or ~azure.storage.fileshare.models.ShareRootSquash
        :param enable_snapshot_virtual_directory_access: Default value is None.
        :type enable_snapshot_virtual_directory_access: bool
        :param paid_bursting_enabled: Optional. Boolean. Default if not specified is false. This
         property enables paid bursting. Default value is None.
        :type paid_bursting_enabled: bool
        :param paid_bursting_max_bandwidth_mibps: Optional. Integer. Default if not specified is the
         maximum throughput the file share can support. Current maximum for a file share is 10,340
         MiB/sec. Default value is None.
        :type paid_bursting_max_bandwidth_mibps: int
        :param paid_bursting_max_iops: Optional. Integer. Default if not specified is the maximum IOPS
         the file share can support. Current maximum for a file share is 102,400 IOPS. Default value is
         None.
        :type paid_bursting_max_iops: int
        :param share_provisioned_iops: Optional. Supported in version 2025-01-05 and later. Only
         allowed for provisioned v2 file shares. Specifies the provisioned number of input/output
         operations per second (IOPS) of the share. If this is not specified, the provisioned IOPS is
         set to value calculated based on recommendation formula. Default value is None.
        :type share_provisioned_iops: int
        :param share_provisioned_bandwidth_mibps: Optional. Supported in version 2025-01-05 and later.
         Only allowed for provisioned v2 file shares. Specifies the provisioned bandwidth of the share,
         in mebibytes per second (MiBps). If this is not specified, the provisioned bandwidth is set to
         value calculated based on recommendation formula. Default value is None.
        :type share_provisioned_bandwidth_mibps: int
        :param enable_smb_directory_lease: SMB only, default is true.  Specifies whether granting of
         new directory leases for directories present in a share are to be enabled or disabled. An input
         of true specifies that granting of new directory leases is to be allowed. An input of false
         specifies that granting of new directory leases is to be blocked. Default value is None.
        :type enable_smb_directory_lease: bool
        :return: None or the result of cls(response)
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        restype: Literal["share"] = kwargs.pop("restype", _params.pop("restype", "share"))
        cls: ClsType[None] = kwargs.pop("cls", None)

        _request = build_create_request(
            url=self._config.url,
            timeout=timeout,
            metadata=metadata,
            quota=quota,
            access_tier=access_tier,
            enabled_protocols=enabled_protocols,
            root_squash=root_squash,
            enable_snapshot_virtual_directory_access=enable_snapshot_virtual_directory_access,
            paid_bursting_enabled=paid_bursting_enabled,
            paid_bursting_max_bandwidth_mibps=paid_bursting_max_bandwidth_mibps,
            paid_bursting_max_iops=paid_bursting_max_iops,
            share_provisioned_iops=share_provisioned_iops,
            share_provisioned_bandwidth_mibps=share_provisioned_bandwidth_mibps,
            enable_smb_directory_lease=enable_smb_directory_lease,
            file_request_intent=self._config.file_request_intent,
            restype=restype,
            version=self._config.version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [201]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(
                _models.StorageError,
                pipeline_response,
            )
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers["ETag"] = self._deserialize("str", response.headers.get("ETag"))
        response_headers["Last-Modified"] = self._deserialize("rfc-1123", response.headers.get("Last-Modified"))
        response_headers["x-ms-request-id"] = self._deserialize("str", response.headers.get("x-ms-request-id"))
        response_headers["x-ms-version"] = self._deserialize("str", response.headers.get("x-ms-version"))
        response_headers["Date"] = self._deserialize("rfc-1123", response.headers.get("Date"))
        response_headers["x-ms-share-quota"] = self._deserialize("int", response.headers.get("x-ms-share-quota"))
        response_headers["x-ms-share-provisioned-iops"] = self._deserialize(
            "int", response.headers.get("x-ms-share-provisioned-iops")
        )
        response_headers["x-ms-share-provisioned-bandwidth-mibps"] = self._deserialize(
            "int", response.headers.get("x-ms-share-provisioned-bandwidth-mibps")
        )
        response_headers["x-ms-share-included-burst-iops"] = self._deserialize(
            "int", response.headers.get("x-ms-share-included-burst-iops")
        )
        response_headers["x-ms-share-max-burst-credits-for-iops"] = self._deserialize(
            "int", response.headers.get("x-ms-share-max-burst-credits-for-iops")
        )

        if cls:
            return cls(pipeline_response, None, response_headers)  # type: ignore

    @distributed_trace
    def get_properties(  # pylint: disable=inconsistent-return-statements
        self,
        sharesnapshot: Optional[str] = None,
        timeout: Optional[int] = None,
        lease_access_conditions: Optional[_models.LeaseAccessConditions] = None,
        **kwargs: Any
    ) -> None:
        """Returns all user-defined metadata and system properties for the specified share or share
        snapshot. The data returned does not include the share's list of files.

        :param sharesnapshot: The snapshot parameter is an opaque DateTime value that, when present,
         specifies the share snapshot to query. Default value is None.
        :type sharesnapshot: str
        :param timeout: The timeout parameter is expressed in seconds. For more information, see
         :code:`<a
         href="https://learn.microsoft.com/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations">Setting
         Timeouts for File Service Operations.</a>`. Default value is None.
        :type timeout: int
        :param lease_access_conditions: Parameter group. Default value is None.
        :type lease_access_conditions: ~azure.storage.fileshare.models.LeaseAccessConditions
        :return: None or the result of cls(response)
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        restype: Literal["share"] = kwargs.pop("restype", _params.pop("restype", "share"))
        cls: ClsType[None] = kwargs.pop("cls", None)

        _lease_id = None
        if lease_access_conditions is not None:
            _lease_id = lease_access_conditions.lease_id

        _request = build_get_properties_request(
            url=self._config.url,
            sharesnapshot=sharesnapshot,
            timeout=timeout,
            lease_id=_lease_id,
            file_request_intent=self._config.file_request_intent,
            restype=restype,
            version=self._config.version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(
                _models.StorageError,
                pipeline_response,
            )
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers["x-ms-meta"] = self._deserialize("{str}", response.headers.get("x-ms-meta"))
        response_headers["ETag"] = self._deserialize("str", response.headers.get("ETag"))
        response_headers["Last-Modified"] = self._deserialize("rfc-1123", response.headers.get("Last-Modified"))
        response_headers["x-ms-request-id"] = self._deserialize("str", response.headers.get("x-ms-request-id"))
        response_headers["x-ms-version"] = self._deserialize("str", response.headers.get("x-ms-version"))
        response_headers["Date"] = self._deserialize("rfc-1123", response.headers.get("Date"))
        response_headers["x-ms-share-quota"] = self._deserialize("int", response.headers.get("x-ms-share-quota"))
        response_headers["x-ms-share-provisioned-iops"] = self._deserialize(
            "int", response.headers.get("x-ms-share-provisioned-iops")
        )
        response_headers["x-ms-share-provisioned-ingress-mbps"] = self._deserialize(
            "int", response.headers.get("x-ms-share-provisioned-ingress-mbps")
        )
        response_headers["x-ms-share-provisioned-egress-mbps"] = self._deserialize(
            "int", response.headers.get("x-ms-share-provisioned-egress-mbps")
        )
        response_headers["x-ms-share-next-allowed-quota-downgrade-time"] = self._deserialize(
            "rfc-1123", response.headers.get("x-ms-share-next-allowed-quota-downgrade-time")
        )
        response_headers["x-ms-share-provisioned-bandwidth-mibps"] = self._deserialize(
            "int", response.headers.get("x-ms-share-provisioned-bandwidth-mibps")
        )
        response_headers["x-ms-lease-duration"] = self._deserialize("str", response.headers.get("x-ms-lease-duration"))
        response_headers["x-ms-lease-state"] = self._deserialize("str", response.headers.get("x-ms-lease-state"))
        response_headers["x-ms-lease-status"] = self._deserialize("str", response.headers.get("x-ms-lease-status"))
        response_headers["x-ms-access-tier"] = self._deserialize("str", response.headers.get("x-ms-access-tier"))
        response_headers["x-ms-access-tier-change-time"] = self._deserialize(
            "rfc-1123", response.headers.get("x-ms-access-tier-change-time")
        )
        response_headers["x-ms-access-tier-transition-state"] = self._deserialize(
            "str", response.headers.get("x-ms-access-tier-transition-state")
        )
        response_headers["x-ms-enabled-protocols"] = self._deserialize(
            "str", response.headers.get("x-ms-enabled-protocols")
        )
        response_headers["x-ms-root-squash"] = self._deserialize("str", response.headers.get("x-ms-root-squash"))
        response_headers["x-ms-enable-snapshot-virtual-directory-access"] = self._deserialize(
            "bool", response.headers.get("x-ms-enable-snapshot-virtual-directory-access")
        )
        response_headers["x-ms-share-paid-bursting-enabled"] = self._deserialize(
            "bool", response.headers.get("x-ms-share-paid-bursting-enabled")
        )
        response_headers["x-ms-share-paid-bursting-max-iops"] = self._deserialize(
            "int", response.headers.get("x-ms-share-paid-bursting-max-iops")
        )
        response_headers["x-ms-share-paid-bursting-max-bandwidth-mibps"] = self._deserialize(
            "int", response.headers.get("x-ms-share-paid-bursting-max-bandwidth-mibps")
        )
        response_headers["x-ms-share-included-burst-iops"] = self._deserialize(
            "int", response.headers.get("x-ms-share-included-burst-iops")
        )
        response_headers["x-ms-share-max-burst-credits-for-iops"] = self._deserialize(
            "int", response.headers.get("x-ms-share-max-burst-credits-for-iops")
        )
        response_headers["x-ms-share-next-allowed-provisioned-iops-downgrade-time"] = self._deserialize(
            "rfc-1123", response.headers.get("x-ms-share-next-allowed-provisioned-iops-downgrade-time")
        )
        response_headers["x-ms-share-next-allowed-provisioned-bandwidth-downgrade-time"] = self._deserialize(
            "rfc-1123", response.headers.get("x-ms-share-next-allowed-provisioned-bandwidth-downgrade-time")
        )
        response_headers["x-ms-enable-smb-directory-lease"] = self._deserialize(
            "bool", response.headers.get("x-ms-enable-smb-directory-lease")
        )

        if cls:
            return cls(pipeline_response, None, response_headers)  # type: ignore

    @distributed_trace
    def delete(  # pylint: disable=inconsistent-return-statements
        self,
        sharesnapshot: Optional[str] = None,
        timeout: Optional[int] = None,
        delete_snapshots: Optional[Union[str, _models.DeleteSnapshotsOptionType]] = None,
        lease_access_conditions: Optional[_models.LeaseAccessConditions] = None,
        **kwargs: Any
    ) -> None:
        """Operation marks the specified share or share snapshot for deletion. The share or share snapshot
        and any files contained within it are later deleted during garbage collection.

        :param sharesnapshot: The snapshot parameter is an opaque DateTime value that, when present,
         specifies the share snapshot to query. Default value is None.
        :type sharesnapshot: str
        :param timeout: The timeout parameter is expressed in seconds. For more information, see
         :code:`<a
         href="https://learn.microsoft.com/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations">Setting
         Timeouts for File Service Operations.</a>`. Default value is None.
        :type timeout: int
        :param delete_snapshots: Specifies the option include to delete the base share and all of its
         snapshots. Known values are: "include" and "include-leased". Default value is None.
        :type delete_snapshots: str or ~azure.storage.fileshare.models.DeleteSnapshotsOptionType
        :param lease_access_conditions: Parameter group. Default value is None.
        :type lease_access_conditions: ~azure.storage.fileshare.models.LeaseAccessConditions
        :return: None or the result of cls(response)
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        restype: Literal["share"] = kwargs.pop("restype", _params.pop("restype", "share"))
        cls: ClsType[None] = kwargs.pop("cls", None)

        _lease_id = None
        if lease_access_conditions is not None:
            _lease_id = lease_access_conditions.lease_id

        _request = build_delete_request(
            url=self._config.url,
            sharesnapshot=sharesnapshot,
            timeout=timeout,
            delete_snapshots=delete_snapshots,
            lease_id=_lease_id,
            file_request_intent=self._config.file_request_intent,
            restype=restype,
            version=self._config.version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [202]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(
                _models.StorageError,
                pipeline_response,
            )
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers["x-ms-request-id"] = self._deserialize("str", response.headers.get("x-ms-request-id"))
        response_headers["x-ms-version"] = self._deserialize("str", response.headers.get("x-ms-version"))
        response_headers["Date"] = self._deserialize("rfc-1123", response.headers.get("Date"))
        response_headers["x-ms-file-share-usage-bytes"] = self._deserialize(
            "int", response.headers.get("x-ms-file-share-usage-bytes")
        )
        response_headers["x-ms-file-share-snapshot-usage-bytes"] = self._deserialize(
            "int", response.headers.get("x-ms-file-share-snapshot-usage-bytes")
        )

        if cls:
            return cls(pipeline_response, None, response_headers)  # type: ignore

    @distributed_trace
    def acquire_lease(  # pylint: disable=inconsistent-return-statements
        self,
        timeout: Optional[int] = None,
        duration: Optional[int] = None,
        proposed_lease_id: Optional[str] = None,
        sharesnapshot: Optional[str] = None,
        request_id_parameter: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """The Lease Share operation establishes and manages a lock on a share, or the specified snapshot
        for set and delete share operations.

        :param timeout: The timeout parameter is expressed in seconds. For more information, see
         :code:`<a
         href="https://learn.microsoft.com/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations">Setting
         Timeouts for File Service Operations.</a>`. Default value is None.
        :type timeout: int
        :param duration: Specifies the duration of the lease, in seconds, or negative one (-1) for a
         lease that never expires. A non-infinite lease can be between 15 and 60 seconds. A lease
         duration cannot be changed using renew or change. Default value is None.
        :type duration: int
        :param proposed_lease_id: Proposed lease ID, in a GUID string format. The File service returns
         400 (Invalid request) if the proposed lease ID is not in the correct format. See Guid
         Constructor (String) for a list of valid GUID string formats. Default value is None.
        :type proposed_lease_id: str
        :param sharesnapshot: The snapshot parameter is an opaque DateTime value that, when present,
         specifies the share snapshot to query. Default value is None.
        :type sharesnapshot: str
        :param request_id_parameter: Provides a client-generated, opaque value with a 1 KB character
         limit that is recorded in the analytics logs when storage analytics logging is enabled. Default
         value is None.
        :type request_id_parameter: str
        :return: None or the result of cls(response)
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        comp: Literal["lease"] = kwargs.pop("comp", _params.pop("comp", "lease"))
        action: Literal["acquire"] = kwargs.pop("action", _headers.pop("x-ms-lease-action", "acquire"))
        restype: Literal["share"] = kwargs.pop("restype", _params.pop("restype", "share"))
        cls: ClsType[None] = kwargs.pop("cls", None)

        _request = build_acquire_lease_request(
            url=self._config.url,
            timeout=timeout,
            duration=duration,
            proposed_lease_id=proposed_lease_id,
            sharesnapshot=sharesnapshot,
            request_id_parameter=request_id_parameter,
            file_request_intent=self._config.file_request_intent,
            comp=comp,
            action=action,
            restype=restype,
            version=self._config.version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [201]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(
                _models.StorageError,
                pipeline_response,
            )
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers["ETag"] = self._deserialize("str", response.headers.get("ETag"))
        response_headers["Last-Modified"] = self._deserialize("rfc-1123", response.headers.get("Last-Modified"))
        response_headers["x-ms-lease-id"] = self._deserialize("str", response.headers.get("x-ms-lease-id"))
        response_headers["x-ms-client-request-id"] = self._deserialize(
            "str", response.headers.get("x-ms-client-request-id")
        )
        response_headers["x-ms-request-id"] = self._deserialize("str", response.headers.get("x-ms-request-id"))
        response_headers["x-ms-version"] = self._deserialize("str", response.headers.get("x-ms-version"))
        response_headers["Date"] = self._deserialize("rfc-1123", response.headers.get("Date"))

        if cls:
            return cls(pipeline_response, None, response_headers)  # type: ignore

    @distributed_trace
    def release_lease(  # pylint: disable=inconsistent-return-statements
        self,
        lease_id: str,
        timeout: Optional[int] = None,
        sharesnapshot: Optional[str] = None,
        request_id_parameter: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """The Lease Share operation establishes and manages a lock on a share, or the specified snapshot
        for set and delete share operations.

        :param lease_id: Specifies the current lease ID on the resource. Required.
        :type lease_id: str
        :param timeout: The timeout parameter is expressed in seconds. For more information, see
         :code:`<a
         href="https://learn.microsoft.com/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations">Setting
         Timeouts for File Service Operations.</a>`. Default value is None.
        :type timeout: int
        :param sharesnapshot: The snapshot parameter is an opaque DateTime value that, when present,
         specifies the share snapshot to query. Default value is None.
        :type sharesnapshot: str
        :param request_id_parameter: Provides a client-generated, opaque value with a 1 KB character
         limit that is recorded in the analytics logs when storage analytics logging is enabled. Default
         value is None.
        :type request_id_parameter: str
        :return: None or the result of cls(response)
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        comp: Literal["lease"] = kwargs.pop("comp", _params.pop("comp", "lease"))
        action: Literal["release"] = kwargs.pop("action", _headers.pop("x-ms-lease-action", "release"))
        restype: Literal["share"] = kwargs.pop("restype", _params.pop("restype", "share"))
        cls: ClsType[None] = kwargs.pop("cls", None)

        _request = build_release_lease_request(
            url=self._config.url,
            lease_id=lease_id,
            timeout=timeout,
            sharesnapshot=sharesnapshot,
            request_id_parameter=request_id_parameter,
            file_request_intent=self._config.file_request_intent,
            comp=comp,
            action=action,
            restype=restype,
            version=self._config.version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(
                _models.StorageError,
                pipeline_response,
            )
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers["ETag"] = self._deserialize("str", response.headers.get("ETag"))
        response_headers["Last-Modified"] = self._deserialize("rfc-1123", response.headers.get("Last-Modified"))
        response_headers["x-ms-client-request-id"] = self._deserialize(
            "str", response.headers.get("x-ms-client-request-id")
        )
        response_headers["x-ms-request-id"] = self._deserialize("str", response.headers.get("x-ms-request-id"))
        response_headers["x-ms-version"] = self._deserialize("str", response.headers.get("x-ms-version"))
        response_headers["Date"] = self._deserialize("rfc-1123", response.headers.get("Date"))

        if cls:
            return cls(pipeline_response, None, response_headers)  # type: ignore

    @distributed_trace
    def change_lease(  # pylint: disable=inconsistent-return-statements
        self,
        lease_id: str,
        timeout: Optional[int] = None,
        proposed_lease_id: Optional[str] = None,
        sharesnapshot: Optional[str] = None,
        request_id_parameter: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """The Lease Share operation establishes and manages a lock on a share, or the specified snapshot
        for set and delete share operations.

        :param lease_id: Specifies the current lease ID on the resource. Required.
        :type lease_id: str
        :param timeout: The timeout parameter is expressed in seconds. For more information, see
         :code:`<a
         href="https://learn.microsoft.com/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations">Setting
         Timeouts for File Service Operations.</a>`. Default value is None.
        :type timeout: int
        :param proposed_lease_id: Proposed lease ID, in a GUID string format. The File service returns
         400 (Invalid request) if the proposed lease ID is not in the correct format. See Guid
         Constructor (String) for a list of valid GUID string formats. Default value is None.
        :type proposed_lease_id: str
        :param sharesnapshot: The snapshot parameter is an opaque DateTime value that, when present,
         specifies the share snapshot to query. Default value is None.
        :type sharesnapshot: str
        :param request_id_parameter: Provides a client-generated, opaque value with a 1 KB character
         limit that is recorded in the analytics logs when storage analytics logging is enabled. Default
         value is None.
        :type request_id_parameter: str
        :return: None or the result of cls(response)
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        comp: Literal["lease"] = kwargs.pop("comp", _params.pop("comp", "lease"))
        action: Literal["change"] = kwargs.pop("action", _headers.pop("x-ms-lease-action", "change"))
        restype: Literal["share"] = kwargs.pop("restype", _params.pop("restype", "share"))
        cls: ClsType[None] = kwargs.pop("cls", None)

        _request = build_change_lease_request(
            url=self._config.url,
            lease_id=lease_id,
            timeout=timeout,
            proposed_lease_id=proposed_lease_id,
            sharesnapshot=sharesnapshot,
            request_id_parameter=request_id_parameter,
            file_request_intent=self._config.file_request_intent,
            comp=comp,
            action=action,
            restype=restype,
            version=self._config.version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(
                _models.StorageError,
                pipeline_response,
            )
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers["ETag"] = self._deserialize("str", response.headers.get("ETag"))
        response_headers["Last-Modified"] = self._deserialize("rfc-1123", response.headers.get("Last-Modified"))
        response_headers["x-ms-lease-id"] = self._deserialize("str", response.headers.get("x-ms-lease-id"))
        response_headers["x-ms-client-request-id"] = self._deserialize(
            "str", response.headers.get("x-ms-client-request-id")
        )
        response_headers["x-ms-request-id"] = self._deserialize("str", response.headers.get("x-ms-request-id"))
        response_headers["x-ms-version"] = self._deserialize("str", response.headers.get("x-ms-version"))
        response_headers["Date"] = self._deserialize("rfc-1123", response.headers.get("Date"))

        if cls:
            return cls(pipeline_response, None, response_headers)  # type: ignore

    @distributed_trace
    def renew_lease(  # pylint: disable=inconsistent-return-statements
        self,
        lease_id: str,
        timeout: Optional[int] = None,
        sharesnapshot: Optional[str] = None,
        request_id_parameter: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """The Lease Share operation establishes and manages a lock on a share, or the specified snapshot
        for set and delete share operations.

        :param lease_id: Specifies the current lease ID on the resource. Required.
        :type lease_id: str
        :param timeout: The timeout parameter is expressed in seconds. For more information, see
         :code:`<a
         href="https://learn.microsoft.com/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations">Setting
         Timeouts for File Service Operations.</a>`. Default value is None.
        :type timeout: int
        :param sharesnapshot: The snapshot parameter is an opaque DateTime value that, when present,
         specifies the share snapshot to query. Default value is None.
        :type sharesnapshot: str
        :param request_id_parameter: Provides a client-generated, opaque value with a 1 KB character
         limit that is recorded in the analytics logs when storage analytics logging is enabled. Default
         value is None.
        :type request_id_parameter: str
        :return: None or the result of cls(response)
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        comp: Literal["lease"] = kwargs.pop("comp", _params.pop("comp", "lease"))
        action: Literal["renew"] = kwargs.pop("action", _headers.pop("x-ms-lease-action", "renew"))
        restype: Literal["share"] = kwargs.pop("restype", _params.pop("restype", "share"))
        cls: ClsType[None] = kwargs.pop("cls", None)

        _request = build_renew_lease_request(
            url=self._config.url,
            lease_id=lease_id,
            timeout=timeout,
            sharesnapshot=sharesnapshot,
            request_id_parameter=request_id_parameter,
            file_request_intent=self._config.file_request_intent,
            comp=comp,
            action=action,
            restype=restype,
            version=self._config.version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(
                _models.StorageError,
                pipeline_response,
            )
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers["ETag"] = self._deserialize("str", response.headers.get("ETag"))
        response_headers["Last-Modified"] = self._deserialize("rfc-1123", response.headers.get("Last-Modified"))
        response_headers["x-ms-lease-id"] = self._deserialize("str", response.headers.get("x-ms-lease-id"))
        response_headers["x-ms-client-request-id"] = self._deserialize(
            "str", response.headers.get("x-ms-client-request-id")
        )
        response_headers["x-ms-request-id"] = self._deserialize("str", response.headers.get("x-ms-request-id"))
        response_headers["x-ms-version"] = self._deserialize("str", response.headers.get("x-ms-version"))
        response_headers["Date"] = self._deserialize("rfc-1123", response.headers.get("Date"))

        if cls:
            return cls(pipeline_response, None, response_headers)  # type: ignore

    @distributed_trace
    def break_lease(  # pylint: disable=inconsistent-return-statements
        self,
        timeout: Optional[int] = None,
        break_period: Optional[int] = None,
        request_id_parameter: Optional[str] = None,
        sharesnapshot: Optional[str] = None,
        lease_access_conditions: Optional[_models.LeaseAccessConditions] = None,
        **kwargs: Any
    ) -> None:
        """The Lease Share operation establishes and manages a lock on a share, or the specified snapshot
        for set and delete share operations.

        :param timeout: The timeout parameter is expressed in seconds. For more information, see
         :code:`<a
         href="https://learn.microsoft.com/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations">Setting
         Timeouts for File Service Operations.</a>`. Default value is None.
        :type timeout: int
        :param break_period: For a break operation, proposed duration the lease should continue before
         it is broken, in seconds, between 0 and 60. This break period is only used if it is shorter
         than the time remaining on the lease. If longer, the time remaining on the lease is used. A new
         lease will not be available before the break period has expired, but the lease may be held for
         longer than the break period. If this header does not appear with a break operation, a
         fixed-duration lease breaks after the remaining lease period elapses, and an infinite lease
         breaks immediately. Default value is None.
        :type break_period: int
        :param request_id_parameter: Provides a client-generated, opaque value with a 1 KB character
         limit that is recorded in the analytics logs when storage analytics logging is enabled. Default
         value is None.
        :type request_id_parameter: str
        :param sharesnapshot: The snapshot parameter is an opaque DateTime value that, when present,
         specifies the share snapshot to query. Default value is None.
        :type sharesnapshot: str
        :param lease_access_conditions: Parameter group. Default value is None.
        :type lease_access_conditions: ~azure.storage.fileshare.models.LeaseAccessConditions
        :return: None or the result of cls(response)
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        comp: Literal["lease"] = kwargs.pop("comp", _params.pop("comp", "lease"))
        action: Literal["break"] = kwargs.pop("action", _headers.pop("x-ms-lease-action", "break"))
        restype: Literal["share"] = kwargs.pop("restype", _params.pop("restype", "share"))
        cls: ClsType[None] = kwargs.pop("cls", None)

        _lease_id = None
        if lease_access_conditions is not None:
            _lease_id = lease_access_conditions.lease_id

        _request = build_break_lease_request(
            url=self._config.url,
            timeout=timeout,
            break_period=break_period,
            lease_id=_lease_id,
            request_id_parameter=request_id_parameter,
            sharesnapshot=sharesnapshot,
            file_request_intent=self._config.file_request_intent,
            comp=comp,
            action=action,
            restype=restype,
            version=self._config.version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [202]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(
                _models.StorageError,
                pipeline_response,
            )
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers["ETag"] = self._deserialize("str", response.headers.get("ETag"))
        response_headers["Last-Modified"] = self._deserialize("rfc-1123", response.headers.get("Last-Modified"))
        response_headers["x-ms-lease-time"] = self._deserialize("int", response.headers.get("x-ms-lease-time"))
        response_headers["x-ms-lease-id"] = self._deserialize("str", response.headers.get("x-ms-lease-id"))
        response_headers["x-ms-client-request-id"] = self._deserialize(
            "str", response.headers.get("x-ms-client-request-id")
        )
        response_headers["x-ms-request-id"] = self._deserialize("str", response.headers.get("x-ms-request-id"))
        response_headers["x-ms-version"] = self._deserialize("str", response.headers.get("x-ms-version"))
        response_headers["Date"] = self._deserialize("rfc-1123", response.headers.get("Date"))

        if cls:
            return cls(pipeline_response, None, response_headers)  # type: ignore

    @distributed_trace
    def create_snapshot(  # pylint: disable=inconsistent-return-statements
        self, timeout: Optional[int] = None, metadata: Optional[dict[str, str]] = None, **kwargs: Any
    ) -> None:
        """Creates a read-only snapshot of a share.

        :param timeout: The timeout parameter is expressed in seconds. For more information, see
         :code:`<a
         href="https://learn.microsoft.com/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations">Setting
         Timeouts for File Service Operations.</a>`. Default value is None.
        :type timeout: int
        :param metadata: A name-value pair to associate with a file storage object. Default value is
         None.
        :type metadata: dict[str, str]
        :return: None or the result of cls(response)
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        restype: Literal["share"] = kwargs.pop("restype", _params.pop("restype", "share"))
        comp: Literal["snapshot"] = kwargs.pop("comp", _params.pop("comp", "snapshot"))
        cls: ClsType[None] = kwargs.pop("cls", None)

        _request = build_create_snapshot_request(
            url=self._config.url,
            timeout=timeout,
            metadata=metadata,
            file_request_intent=self._config.file_request_intent,
            restype=restype,
            comp=comp,
            version=self._config.version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [201]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(
                _models.StorageError,
                pipeline_response,
            )
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers["x-ms-snapshot"] = self._deserialize("str", response.headers.get("x-ms-snapshot"))
        response_headers["ETag"] = self._deserialize("str", response.headers.get("ETag"))
        response_headers["Last-Modified"] = self._deserialize("rfc-1123", response.headers.get("Last-Modified"))
        response_headers["x-ms-request-id"] = self._deserialize("str", response.headers.get("x-ms-request-id"))
        response_headers["x-ms-version"] = self._deserialize("str", response.headers.get("x-ms-version"))
        response_headers["Date"] = self._deserialize("rfc-1123", response.headers.get("Date"))

        if cls:
            return cls(pipeline_response, None, response_headers)  # type: ignore

    @overload
    def create_permission(
        self,
        share_permission: _models.SharePermission,
        timeout: Optional[int] = None,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> None:
        """Create a permission (a security descriptor).

        :param share_permission: A permission (a security descriptor) at the share level. Required.
        :type share_permission: ~azure.storage.fileshare.models.SharePermission
        :param timeout: The timeout parameter is expressed in seconds. For more information, see
         :code:`<a
         href="https://learn.microsoft.com/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations">Setting
         Timeouts for File Service Operations.</a>`. Default value is None.
        :type timeout: int
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: None or the result of cls(response)
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    def create_permission(
        self,
        share_permission: IO[bytes],
        timeout: Optional[int] = None,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> None:
        """Create a permission (a security descriptor).

        :param share_permission: A permission (a security descriptor) at the share level. Required.
        :type share_permission: IO[bytes]
        :param timeout: The timeout parameter is expressed in seconds. For more information, see
         :code:`<a
         href="https://learn.microsoft.com/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations">Setting
         Timeouts for File Service Operations.</a>`. Default value is None.
        :type timeout: int
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: None or the result of cls(response)
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace
    def create_permission(  # pylint: disable=inconsistent-return-statements
        self, share_permission: Union[_models.SharePermission, IO[bytes]], timeout: Optional[int] = None, **kwargs: Any
    ) -> None:
        """Create a permission (a security descriptor).

        :param share_permission: A permission (a security descriptor) at the share level. Is either a
         SharePermission type or a IO[bytes] type. Required.
        :type share_permission: ~azure.storage.fileshare.models.SharePermission or IO[bytes]
        :param timeout: The timeout parameter is expressed in seconds. For more information, see
         :code:`<a
         href="https://learn.microsoft.com/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations">Setting
         Timeouts for File Service Operations.</a>`. Default value is None.
        :type timeout: int
        :return: None or the result of cls(response)
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        restype: Literal["share"] = kwargs.pop("restype", _params.pop("restype", "share"))
        comp: Literal["filepermission"] = kwargs.pop("comp", _params.pop("comp", "filepermission"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[None] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(share_permission, (IOBase, bytes)):
            _content = share_permission
        else:
            _json = self._serialize.body(share_permission, "SharePermission")

        _request = build_create_permission_request(
            url=self._config.url,
            timeout=timeout,
            file_request_intent=self._config.file_request_intent,
            restype=restype,
            comp=comp,
            content_type=content_type,
            version=self._config.version,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [201]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(
                _models.StorageError,
                pipeline_response,
            )
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers["x-ms-request-id"] = self._deserialize("str", response.headers.get("x-ms-request-id"))
        response_headers["x-ms-version"] = self._deserialize("str", response.headers.get("x-ms-version"))
        response_headers["Date"] = self._deserialize("rfc-1123", response.headers.get("Date"))
        response_headers["x-ms-file-permission-key"] = self._deserialize(
            "str", response.headers.get("x-ms-file-permission-key")
        )

        if cls:
            return cls(pipeline_response, None, response_headers)  # type: ignore

    @distributed_trace
    def get_permission(
        self,
        file_permission_key: str,
        file_permission_format: Optional[Union[str, _models.FilePermissionFormat]] = None,
        timeout: Optional[int] = None,
        **kwargs: Any
    ) -> _models.SharePermission:
        """Returns the permission (security descriptor) for a given key.

        :param file_permission_key: Key of the permission to be set for the directory/file. Required.
        :type file_permission_key: str
        :param file_permission_format: Optional. Available for version 2023-06-01 and later. Specifies
         the format in which the permission is returned. Acceptable values are SDDL or binary. If
         x-ms-file-permission-format is unspecified or explicitly set to SDDL, the permission is
         returned in SDDL format. If x-ms-file-permission-format is explicitly set to binary, the
         permission is returned as a base64 string representing the binary encoding of the permission.
         Known values are: "Sddl" and "Binary". Default value is None.
        :type file_permission_format: str or ~azure.storage.fileshare.models.FilePermissionFormat
        :param timeout: The timeout parameter is expressed in seconds. For more information, see
         :code:`<a
         href="https://learn.microsoft.com/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations">Setting
         Timeouts for File Service Operations.</a>`. Default value is None.
        :type timeout: int
        :return: SharePermission or the result of cls(response)
        :rtype: ~azure.storage.fileshare.models.SharePermission
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        restype: Literal["share"] = kwargs.pop("restype", _params.pop("restype", "share"))
        comp: Literal["filepermission"] = kwargs.pop("comp", _params.pop("comp", "filepermission"))
        cls: ClsType[_models.SharePermission] = kwargs.pop("cls", None)

        _request = build_get_permission_request(
            url=self._config.url,
            file_permission_key=file_permission_key,
            file_permission_format=file_permission_format,
            timeout=timeout,
            file_request_intent=self._config.file_request_intent,
            restype=restype,
            comp=comp,
            version=self._config.version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(
                _models.StorageError,
                pipeline_response,
            )
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers["x-ms-request-id"] = self._deserialize("str", response.headers.get("x-ms-request-id"))
        response_headers["x-ms-version"] = self._deserialize("str", response.headers.get("x-ms-version"))
        response_headers["Date"] = self._deserialize("rfc-1123", response.headers.get("Date"))

        deserialized = self._deserialize("SharePermission", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, response_headers)  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace
    def set_properties(  # pylint: disable=inconsistent-return-statements
        self,
        timeout: Optional[int] = None,
        quota: Optional[int] = None,
        access_tier: Optional[Union[str, _models.ShareAccessTier]] = None,
        root_squash: Optional[Union[str, _models.ShareRootSquash]] = None,
        enable_snapshot_virtual_directory_access: Optional[bool] = None,
        paid_bursting_enabled: Optional[bool] = None,
        paid_bursting_max_bandwidth_mibps: Optional[int] = None,
        paid_bursting_max_iops: Optional[int] = None,
        share_provisioned_iops: Optional[int] = None,
        share_provisioned_bandwidth_mibps: Optional[int] = None,
        enable_smb_directory_lease: Optional[bool] = None,
        lease_access_conditions: Optional[_models.LeaseAccessConditions] = None,
        **kwargs: Any
    ) -> None:
        """Sets properties for the specified share.

        :param timeout: The timeout parameter is expressed in seconds. For more information, see
         :code:`<a
         href="https://learn.microsoft.com/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations">Setting
         Timeouts for File Service Operations.</a>`. Default value is None.
        :type timeout: int
        :param quota: Specifies the maximum size of the share, in gigabytes. Default value is None.
        :type quota: int
        :param access_tier: Specifies the access tier of the share. Known values are:
         "TransactionOptimized", "Hot", "Cool", and "Premium". Default value is None.
        :type access_tier: str or ~azure.storage.fileshare.models.ShareAccessTier
        :param root_squash: Root squash to set on the share.  Only valid for NFS shares. Known values
         are: "NoRootSquash", "RootSquash", and "AllSquash". Default value is None.
        :type root_squash: str or ~azure.storage.fileshare.models.ShareRootSquash
        :param enable_snapshot_virtual_directory_access: Default value is None.
        :type enable_snapshot_virtual_directory_access: bool
        :param paid_bursting_enabled: Optional. Boolean. Default if not specified is false. This
         property enables paid bursting. Default value is None.
        :type paid_bursting_enabled: bool
        :param paid_bursting_max_bandwidth_mibps: Optional. Integer. Default if not specified is the
         maximum throughput the file share can support. Current maximum for a file share is 10,340
         MiB/sec. Default value is None.
        :type paid_bursting_max_bandwidth_mibps: int
        :param paid_bursting_max_iops: Optional. Integer. Default if not specified is the maximum IOPS
         the file share can support. Current maximum for a file share is 102,400 IOPS. Default value is
         None.
        :type paid_bursting_max_iops: int
        :param share_provisioned_iops: Optional. Supported in version 2025-01-05 and later. Only
         allowed for provisioned v2 file shares. Specifies the provisioned number of input/output
         operations per second (IOPS) of the share. If this is not specified, the provisioned IOPS is
         set to value calculated based on recommendation formula. Default value is None.
        :type share_provisioned_iops: int
        :param share_provisioned_bandwidth_mibps: Optional. Supported in version 2025-01-05 and later.
         Only allowed for provisioned v2 file shares. Specifies the provisioned bandwidth of the share,
         in mebibytes per second (MiBps). If this is not specified, the provisioned bandwidth is set to
         value calculated based on recommendation formula. Default value is None.
        :type share_provisioned_bandwidth_mibps: int
        :param enable_smb_directory_lease: SMB only, default is true.  Specifies whether granting of
         new directory leases for directories present in a share are to be enabled or disabled. An input
         of true specifies that granting of new directory leases is to be allowed. An input of false
         specifies that granting of new directory leases is to be blocked. Default value is None.
        :type enable_smb_directory_lease: bool
        :param lease_access_conditions: Parameter group. Default value is None.
        :type lease_access_conditions: ~azure.storage.fileshare.models.LeaseAccessConditions
        :return: None or the result of cls(response)
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        restype: Literal["share"] = kwargs.pop("restype", _params.pop("restype", "share"))
        comp: Literal["properties"] = kwargs.pop("comp", _params.pop("comp", "properties"))
        cls: ClsType[None] = kwargs.pop("cls", None)

        _lease_id = None
        if lease_access_conditions is not None:
            _lease_id = lease_access_conditions.lease_id

        _request = build_set_properties_request(
            url=self._config.url,
            timeout=timeout,
            quota=quota,
            access_tier=access_tier,
            lease_id=_lease_id,
            root_squash=root_squash,
            enable_snapshot_virtual_directory_access=enable_snapshot_virtual_directory_access,
            paid_bursting_enabled=paid_bursting_enabled,
            paid_bursting_max_bandwidth_mibps=paid_bursting_max_bandwidth_mibps,
            paid_bursting_max_iops=paid_bursting_max_iops,
            share_provisioned_iops=share_provisioned_iops,
            share_provisioned_bandwidth_mibps=share_provisioned_bandwidth_mibps,
            enable_smb_directory_lease=enable_smb_directory_lease,
            file_request_intent=self._config.file_request_intent,
            restype=restype,
            comp=comp,
            version=self._config.version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(
                _models.StorageError,
                pipeline_response,
            )
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers["ETag"] = self._deserialize("str", response.headers.get("ETag"))
        response_headers["Last-Modified"] = self._deserialize("rfc-1123", response.headers.get("Last-Modified"))
        response_headers["x-ms-request-id"] = self._deserialize("str", response.headers.get("x-ms-request-id"))
        response_headers["x-ms-version"] = self._deserialize("str", response.headers.get("x-ms-version"))
        response_headers["Date"] = self._deserialize("rfc-1123", response.headers.get("Date"))
        response_headers["x-ms-share-quota"] = self._deserialize("int", response.headers.get("x-ms-share-quota"))
        response_headers["x-ms-share-provisioned-iops"] = self._deserialize(
            "int", response.headers.get("x-ms-share-provisioned-iops")
        )
        response_headers["x-ms-share-provisioned-bandwidth-mibps"] = self._deserialize(
            "int", response.headers.get("x-ms-share-provisioned-bandwidth-mibps")
        )
        response_headers["x-ms-share-included-burst-iops"] = self._deserialize(
            "int", response.headers.get("x-ms-share-included-burst-iops")
        )
        response_headers["x-ms-share-max-burst-credits-for-iops"] = self._deserialize(
            "int", response.headers.get("x-ms-share-max-burst-credits-for-iops")
        )
        response_headers["x-ms-share-next-allowed-quota-downgrade-time"] = self._deserialize(
            "rfc-1123", response.headers.get("x-ms-share-next-allowed-quota-downgrade-time")
        )
        response_headers["x-ms-share-next-allowed-provisioned-iops-downgrade-time"] = self._deserialize(
            "rfc-1123", response.headers.get("x-ms-share-next-allowed-provisioned-iops-downgrade-time")
        )
        response_headers["x-ms-share-next-allowed-provisioned-bandwidth-downgrade-time"] = self._deserialize(
            "rfc-1123", response.headers.get("x-ms-share-next-allowed-provisioned-bandwidth-downgrade-time")
        )

        if cls:
            return cls(pipeline_response, None, response_headers)  # type: ignore

    @distributed_trace
    def set_metadata(  # pylint: disable=inconsistent-return-statements
        self,
        timeout: Optional[int] = None,
        metadata: Optional[dict[str, str]] = None,
        lease_access_conditions: Optional[_models.LeaseAccessConditions] = None,
        **kwargs: Any
    ) -> None:
        """Sets one or more user-defined name-value pairs for the specified share.

        :param timeout: The timeout parameter is expressed in seconds. For more information, see
         :code:`<a
         href="https://learn.microsoft.com/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations">Setting
         Timeouts for File Service Operations.</a>`. Default value is None.
        :type timeout: int
        :param metadata: A name-value pair to associate with a file storage object. Default value is
         None.
        :type metadata: dict[str, str]
        :param lease_access_conditions: Parameter group. Default value is None.
        :type lease_access_conditions: ~azure.storage.fileshare.models.LeaseAccessConditions
        :return: None or the result of cls(response)
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        restype: Literal["share"] = kwargs.pop("restype", _params.pop("restype", "share"))
        comp: Literal["metadata"] = kwargs.pop("comp", _params.pop("comp", "metadata"))
        cls: ClsType[None] = kwargs.pop("cls", None)

        _lease_id = None
        if lease_access_conditions is not None:
            _lease_id = lease_access_conditions.lease_id

        _request = build_set_metadata_request(
            url=self._config.url,
            timeout=timeout,
            metadata=metadata,
            lease_id=_lease_id,
            file_request_intent=self._config.file_request_intent,
            restype=restype,
            comp=comp,
            version=self._config.version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(
                _models.StorageError,
                pipeline_response,
            )
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers["ETag"] = self._deserialize("str", response.headers.get("ETag"))
        response_headers["Last-Modified"] = self._deserialize("rfc-1123", response.headers.get("Last-Modified"))
        response_headers["x-ms-request-id"] = self._deserialize("str", response.headers.get("x-ms-request-id"))
        response_headers["x-ms-version"] = self._deserialize("str", response.headers.get("x-ms-version"))
        response_headers["Date"] = self._deserialize("rfc-1123", response.headers.get("Date"))

        if cls:
            return cls(pipeline_response, None, response_headers)  # type: ignore

    @distributed_trace
    def get_access_policy(
        self,
        timeout: Optional[int] = None,
        lease_access_conditions: Optional[_models.LeaseAccessConditions] = None,
        **kwargs: Any
    ) -> list[_models.SignedIdentifier]:
        """Returns information about stored access policies specified on the share.

        :param timeout: The timeout parameter is expressed in seconds. For more information, see
         :code:`<a
         href="https://learn.microsoft.com/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations">Setting
         Timeouts for File Service Operations.</a>`. Default value is None.
        :type timeout: int
        :param lease_access_conditions: Parameter group. Default value is None.
        :type lease_access_conditions: ~azure.storage.fileshare.models.LeaseAccessConditions
        :return: list of SignedIdentifier or the result of cls(response)
        :rtype: list[~azure.storage.fileshare.models.SignedIdentifier]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        restype: Literal["share"] = kwargs.pop("restype", _params.pop("restype", "share"))
        comp: Literal["acl"] = kwargs.pop("comp", _params.pop("comp", "acl"))
        cls: ClsType[list[_models.SignedIdentifier]] = kwargs.pop("cls", None)

        _lease_id = None
        if lease_access_conditions is not None:
            _lease_id = lease_access_conditions.lease_id

        _request = build_get_access_policy_request(
            url=self._config.url,
            timeout=timeout,
            lease_id=_lease_id,
            file_request_intent=self._config.file_request_intent,
            restype=restype,
            comp=comp,
            version=self._config.version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(
                _models.StorageError,
                pipeline_response,
            )
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers["ETag"] = self._deserialize("str", response.headers.get("ETag"))
        response_headers["Last-Modified"] = self._deserialize("rfc-1123", response.headers.get("Last-Modified"))
        response_headers["x-ms-request-id"] = self._deserialize("str", response.headers.get("x-ms-request-id"))
        response_headers["x-ms-version"] = self._deserialize("str", response.headers.get("x-ms-version"))
        response_headers["Date"] = self._deserialize("rfc-1123", response.headers.get("Date"))

        deserialized = self._deserialize("[SignedIdentifier]", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, response_headers)  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace
    def set_access_policy(  # pylint: disable=inconsistent-return-statements
        self,
        timeout: Optional[int] = None,
        lease_access_conditions: Optional[_models.LeaseAccessConditions] = None,
        share_acl: Optional[list[_models.SignedIdentifier]] = None,
        **kwargs: Any
    ) -> None:
        """Sets a stored access policy for use with shared access signatures.

        :param timeout: The timeout parameter is expressed in seconds. For more information, see
         :code:`<a
         href="https://learn.microsoft.com/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations">Setting
         Timeouts for File Service Operations.</a>`. Default value is None.
        :type timeout: int
        :param lease_access_conditions: Parameter group. Default value is None.
        :type lease_access_conditions: ~azure.storage.fileshare.models.LeaseAccessConditions
        :param share_acl: The ACL for the share. Default value is None.
        :type share_acl: list[~azure.storage.fileshare.models.SignedIdentifier]
        :return: None or the result of cls(response)
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        restype: Literal["share"] = kwargs.pop("restype", _params.pop("restype", "share"))
        comp: Literal["acl"] = kwargs.pop("comp", _params.pop("comp", "acl"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", "application/xml"))
        content_type = content_type if share_acl else None
        cls: ClsType[None] = kwargs.pop("cls", None)

        _lease_id = None
        if lease_access_conditions is not None:
            _lease_id = lease_access_conditions.lease_id
        serialization_ctxt = {"xml": {"name": "SignedIdentifiers", "wrapped": True}}
        if share_acl is not None:
            _content = self._serialize.body(
                share_acl, "[SignedIdentifier]", is_xml=True, serialization_ctxt=serialization_ctxt
            )
        else:
            _content = None

        _request = build_set_access_policy_request(
            url=self._config.url,
            timeout=timeout,
            lease_id=_lease_id,
            file_request_intent=self._config.file_request_intent,
            restype=restype,
            comp=comp,
            content_type=content_type,
            version=self._config.version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(
                _models.StorageError,
                pipeline_response,
            )
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers["ETag"] = self._deserialize("str", response.headers.get("ETag"))
        response_headers["Last-Modified"] = self._deserialize("rfc-1123", response.headers.get("Last-Modified"))
        response_headers["x-ms-request-id"] = self._deserialize("str", response.headers.get("x-ms-request-id"))
        response_headers["x-ms-version"] = self._deserialize("str", response.headers.get("x-ms-version"))
        response_headers["Date"] = self._deserialize("rfc-1123", response.headers.get("Date"))

        if cls:
            return cls(pipeline_response, None, response_headers)  # type: ignore

    @distributed_trace
    def get_statistics(
        self,
        timeout: Optional[int] = None,
        lease_access_conditions: Optional[_models.LeaseAccessConditions] = None,
        **kwargs: Any
    ) -> _models.ShareStats:
        """Retrieves statistics related to the share.

        :param timeout: The timeout parameter is expressed in seconds. For more information, see
         :code:`<a
         href="https://learn.microsoft.com/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations">Setting
         Timeouts for File Service Operations.</a>`. Default value is None.
        :type timeout: int
        :param lease_access_conditions: Parameter group. Default value is None.
        :type lease_access_conditions: ~azure.storage.fileshare.models.LeaseAccessConditions
        :return: ShareStats or the result of cls(response)
        :rtype: ~azure.storage.fileshare.models.ShareStats
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        restype: Literal["share"] = kwargs.pop("restype", _params.pop("restype", "share"))
        comp: Literal["stats"] = kwargs.pop("comp", _params.pop("comp", "stats"))
        cls: ClsType[_models.ShareStats] = kwargs.pop("cls", None)

        _lease_id = None
        if lease_access_conditions is not None:
            _lease_id = lease_access_conditions.lease_id

        _request = build_get_statistics_request(
            url=self._config.url,
            timeout=timeout,
            lease_id=_lease_id,
            file_request_intent=self._config.file_request_intent,
            restype=restype,
            comp=comp,
            version=self._config.version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(
                _models.StorageError,
                pipeline_response,
            )
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers["ETag"] = self._deserialize("str", response.headers.get("ETag"))
        response_headers["Last-Modified"] = self._deserialize("rfc-1123", response.headers.get("Last-Modified"))
        response_headers["x-ms-request-id"] = self._deserialize("str", response.headers.get("x-ms-request-id"))
        response_headers["x-ms-version"] = self._deserialize("str", response.headers.get("x-ms-version"))
        response_headers["Date"] = self._deserialize("rfc-1123", response.headers.get("Date"))

        deserialized = self._deserialize("ShareStats", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, response_headers)  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace
    def restore(  # pylint: disable=inconsistent-return-statements
        self,
        timeout: Optional[int] = None,
        request_id_parameter: Optional[str] = None,
        deleted_share_name: Optional[str] = None,
        deleted_share_version: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """Restores a previously deleted Share.

        :param timeout: The timeout parameter is expressed in seconds. For more information, see
         :code:`<a
         href="https://learn.microsoft.com/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations">Setting
         Timeouts for File Service Operations.</a>`. Default value is None.
        :type timeout: int
        :param request_id_parameter: Provides a client-generated, opaque value with a 1 KB character
         limit that is recorded in the analytics logs when storage analytics logging is enabled. Default
         value is None.
        :type request_id_parameter: str
        :param deleted_share_name: Specifies the name of the previously-deleted share. Default value is
         None.
        :type deleted_share_name: str
        :param deleted_share_version: Specifies the version of the previously-deleted share. Default
         value is None.
        :type deleted_share_version: str
        :return: None or the result of cls(response)
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        restype: Literal["share"] = kwargs.pop("restype", _params.pop("restype", "share"))
        comp: Literal["undelete"] = kwargs.pop("comp", _params.pop("comp", "undelete"))
        cls: ClsType[None] = kwargs.pop("cls", None)

        _request = build_restore_request(
            url=self._config.url,
            timeout=timeout,
            request_id_parameter=request_id_parameter,
            deleted_share_name=deleted_share_name,
            deleted_share_version=deleted_share_version,
            file_request_intent=self._config.file_request_intent,
            restype=restype,
            comp=comp,
            version=self._config.version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [201]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(
                _models.StorageError,
                pipeline_response,
            )
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers["ETag"] = self._deserialize("str", response.headers.get("ETag"))
        response_headers["Last-Modified"] = self._deserialize("rfc-1123", response.headers.get("Last-Modified"))
        response_headers["x-ms-request-id"] = self._deserialize("str", response.headers.get("x-ms-request-id"))
        response_headers["x-ms-client-request-id"] = self._deserialize(
            "str", response.headers.get("x-ms-client-request-id")
        )
        response_headers["x-ms-version"] = self._deserialize("str", response.headers.get("x-ms-version"))
        response_headers["Date"] = self._deserialize("rfc-1123", response.headers.get("Date"))
        response_headers["x-ms-share-quota"] = self._deserialize("int", response.headers.get("x-ms-share-quota"))
        response_headers["x-ms-share-provisioned-iops"] = self._deserialize(
            "int", response.headers.get("x-ms-share-provisioned-iops")
        )
        response_headers["x-ms-share-provisioned-bandwidth-mibps"] = self._deserialize(
            "int", response.headers.get("x-ms-share-provisioned-bandwidth-mibps")
        )
        response_headers["x-ms-share-included-burst-iops"] = self._deserialize(
            "int", response.headers.get("x-ms-share-included-burst-iops")
        )
        response_headers["x-ms-share-max-burst-credits-for-iops"] = self._deserialize(
            "int", response.headers.get("x-ms-share-max-burst-credits-for-iops")
        )

        if cls:
            return cls(pipeline_response, None, response_headers)  # type: ignore
