/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tools.transfer.ui.pages.stream;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Deque;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.fs.DBFUtils;
import org.jkiss.dbeaver.model.navigator.fs.DBNPathBase;
import org.jkiss.dbeaver.model.preferences.DBPPropertyDescriptor;
import org.jkiss.dbeaver.model.preferences.DBPPropertySource;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.DBRRunnableWithProgress;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSDataContainer;
import org.jkiss.dbeaver.model.struct.DBSDataManipulator;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectContainer;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.runtime.properties.PropertySourceCustom;
import org.jkiss.dbeaver.tools.transfer.DataTransferPipe;
import org.jkiss.dbeaver.tools.transfer.DataTransferSettings;
import org.jkiss.dbeaver.tools.transfer.IDataTransferConsumer;
import org.jkiss.dbeaver.tools.transfer.IDataTransferNode;
import org.jkiss.dbeaver.tools.transfer.IDataTransferProducer;
import org.jkiss.dbeaver.tools.transfer.IDataTransferSettings;
import org.jkiss.dbeaver.tools.transfer.database.DatabaseConsumerSettings;
import org.jkiss.dbeaver.tools.transfer.database.DatabaseMappingContainer;
import org.jkiss.dbeaver.tools.transfer.database.DatabaseTransferConsumer;
import org.jkiss.dbeaver.tools.transfer.internal.DTMessages;
import org.jkiss.dbeaver.tools.transfer.registry.DataTransferProcessorDescriptor;
import org.jkiss.dbeaver.tools.transfer.stream.StreamEntityMapping;
import org.jkiss.dbeaver.tools.transfer.stream.StreamProducerSettings;
import org.jkiss.dbeaver.tools.transfer.stream.StreamTransferProducer;
import org.jkiss.dbeaver.tools.transfer.ui.internal.DTUIMessages;
import org.jkiss.dbeaver.tools.transfer.ui.pages.DataTransferPageNodeSettings;
import org.jkiss.dbeaver.tools.transfer.ui.wizard.DataTransferWizard;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.ShellUtils;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.UIWidgets;
import org.jkiss.dbeaver.ui.controls.CustomTableEditor;
import org.jkiss.dbeaver.ui.dialogs.DialogUtils;
import org.jkiss.dbeaver.ui.internal.UIMessages;
import org.jkiss.dbeaver.ui.properties.PropertyTreeViewer;
import org.jkiss.dbeaver.utils.HelpUtils;
import org.jkiss.utils.CommonUtils;

public class StreamProducerPageSettings
extends DataTransferPageNodeSettings {
    private static final Log log = Log.getLog(StreamProducerPageSettings.class);
    private static final String HELP_DATA_TRANSFER_LINK = "Data-transfer#import-parameters";
    private PropertyTreeViewer propsEditor;
    private PropertySourceCustom propertySource;
    private boolean showRemoteFS;
    private Table filesTable;
    private Button tiOpenLocal;
    private Button tiOpenRemote;
    private Button openFSBrowserCheckbox;
    private String noneItemSelectedText = DTUIMessages.stream_consumer_page_settings_item_text_none;

    public StreamProducerPageSettings() {
        super(DTMessages.data_transfer_wizard_page_input_files_name);
        this.setTitle(DTMessages.data_transfer_wizard_page_input_files_title);
        this.setDescription(DTMessages.data_transfer_wizard_page_input_files_description);
        this.setPageComplete(false);
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        SashForm settingsDivider = new SashForm(parent, 512);
        settingsDivider.setLayoutData((Object)new GridData(1808));
        Composite inputFilesGroup = UIUtils.createComposite((Composite)settingsDivider, (int)1);
        inputFilesGroup.setLayoutData((Object)new GridData(1808));
        Composite inputFilesTableGroup = new Composite(inputFilesGroup, 0);
        inputFilesTableGroup.setLayout((Layout)GridLayoutFactory.fillDefaults().spacing(0, 0).create());
        inputFilesTableGroup.setLayoutData((Object)new GridData(4, 4, true, true));
        DBPProject project = ((DataTransferWizard)this.getWizard()).getProject();
        this.showRemoteFS = project != null && DBFUtils.supportsMultiFileSystems((DBPProject)project);
        this.createFileSelectionToolBar(inputFilesTableGroup);
        this.filesTable = this.createFilesTable(inputFilesTableGroup);
        if (DBWorkbench.getPlatform().getApplication().isDistributed()) {
            UIUtils.createInfoLink((Composite)inputFilesGroup, (String)"You cannot use files stored on this PC in scheduled tasks.\nIf you want to use the files for export/import, please transfer them to <a href=\"#\">Cloud Storage</a>.", () -> ShellUtils.launchProgram((String)HelpUtils.getHelpExternalReference((String)"Cloud-Storage"))).setToolTipText("Scheduled tasks don't have access to files stored on this PC because they're executed on a remote server.");
        }
        UIUtils.createTableColumn((Table)this.filesTable, (int)16384, (String)DTUIMessages.data_transfer_wizard_final_column_source);
        if (!this.isSkipTargetColumn()) {
            UIUtils.createTableColumn((Table)this.filesTable, (int)16384, (String)DTUIMessages.data_transfer_wizard_final_column_target);
        }
        new CustomTableEditor(this.filesTable){

            protected Control createEditor(Table table, int index, TableItem item) {
                StreamTransferProducer stp;
                Path inputFile;
                Text text = new Text((Composite)table, 2048);
                DataTransferPipe pipe = (DataTransferPipe)item.getData();
                IDataTransferProducer iDataTransferProducer = pipe.getProducer();
                if (iDataTransferProducer instanceof StreamTransferProducer && (inputFile = (stp = (StreamTransferProducer)iDataTransferProducer).getInputFile()) != null) {
                    text.setText(DBFUtils.convertPathToString((Path)inputFile));
                }
                text.setSelection(0, text.getCharCount());
                return text;
            }

            protected void saveEditorValue(Control control, int index, TableItem item) {
                if (control instanceof Text) {
                    Text text = (Text)control;
                    if (text.getData("saved") != null) {
                        return;
                    }
                    text.setData("saved", (Object)true);
                    DataTransferPipe pipe = (DataTransferPipe)item.getData();
                    String fileName = text.getText();
                    text.dispose();
                    if (fileName.isBlank()) {
                        return;
                    }
                    try {
                        Path path = DBFUtils.resolvePathFromString((DBRProgressMonitor)new VoidProgressMonitor(), (DBPProject)pipe.getConsumer().getProject(), (String)fileName);
                        if (!Files.exists(path, new LinkOption[0])) {
                            DBWorkbench.getPlatformUI().showError(DTUIMessages.stream_producer_column_mapping_error_title, "File '" + fileName + "' doesn't exist");
                        } else {
                            StreamProducerPageSettings.this.updateSingleConsumer((DBRProgressMonitor)new VoidProgressMonitor(), pipe, path);
                            item.setText(0, DBFUtils.convertPathToString((Path)path));
                            StreamProducerPageSettings.this.reloadPipes();
                            StreamProducerPageSettings.this.updatePageCompletion();
                        }
                    }
                    catch (Exception e) {
                        DBWorkbench.getPlatformUI().showError(DTUIMessages.stream_producer_column_mapping_error_title, "Error resolving file", (Throwable)e);
                    }
                }
            }
        };
        this.filesTable.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.updateBrowseButtons()));
        Composite exporterSettings = UIUtils.createComposite((Composite)settingsDivider, (int)1);
        UIUtils.createControlLabel((Composite)exporterSettings, (String)DTMessages.data_transfer_wizard_settings_group_importer);
        this.propsEditor = new PropertyTreeViewer(exporterSettings, 2048);
        Object layoutData = this.propsEditor.getControl().getLayoutData();
        if (layoutData instanceof GridData) {
            GridData gd = (GridData)layoutData;
            gd.heightHint = 150;
        }
        UIUtils.createInfoLink((Composite)exporterSettings, (String)DTUIMessages.stream_producer_page_input_files_hint, () -> ShellUtils.launchProgram((String)HelpUtils.getHelpExternalReference((String)HELP_DATA_TRANSFER_LINK)));
        settingsDivider.setWeights(new int[]{400, 600});
        this.setControl((Control)settingsDivider);
        this.updatePageCompletion();
    }

    public void deactivatePage() {
        this.propsEditor.saveEditorValues();
        Map processorProperties = this.propertySource.getPropertiesWithDefaults();
        DataTransferSettings dtSettings = ((DataTransferWizard)this.getWizard()).getSettings();
        dtSettings.setProcessorProperties(processorProperties);
        StreamProducerSettings producerSettings = ((DataTransferWizard)this.getWizard()).getPageSettings((IWizardPage)this, StreamProducerSettings.class);
        if (producerSettings != null) {
            producerSettings.setProcessorProperties(processorProperties);
        }
        IDataTransferSettings consumerSettings = ((DataTransferWizard)this.getWizard()).getSettings().getNodeSettings(((DataTransferWizard)this.getWizard()).getSettings().getConsumer());
        try {
            ((DataTransferWizard)this.getWizard()).getRunnableContext().run(true, true, monitor -> {
                for (DataTransferPipe pipe : dtSettings.getDataPipes()) {
                    DatabaseConsumerSettings databaseConsumerSettings;
                    DatabaseMappingContainer mapping;
                    IDataTransferProducer patt0$temp = pipe.getProducer();
                    if (!(patt0$temp instanceof StreamTransferProducer)) continue;
                    StreamTransferProducer producer = (StreamTransferProducer)patt0$temp;
                    if (producerSettings != null) {
                        producerSettings.updateProducerSettingsFromStream(monitor, producer, dtSettings);
                    }
                    if (!(consumerSettings instanceof DatabaseConsumerSettings) || (mapping = (databaseConsumerSettings = (DatabaseConsumerSettings)consumerSettings).getDataMapping((DBSDataContainer)producer.getDatabaseObject())) == null) continue;
                    mapping.getAttributeMappings(monitor);
                }
            });
            this.saveOpenFSBrowserPreference();
        }
        catch (InvocationTargetException e) {
            DBWorkbench.getPlatformUI().showError("Error updating stream settings", "Error updating settings", e.getTargetException());
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        super.deactivatePage();
    }

    public void activatePage() {
        ((DataTransferWizard)this.getWizard()).loadNodeSettings();
        DataTransferProcessorDescriptor processor = this.getProducerProcessor();
        DBPPropertyDescriptor[] properties = processor == null ? new DBPPropertyDescriptor[]{} : processor.getProperties();
        this.propertySource = new PropertySourceCustom(properties, ((DataTransferWizard)this.getWizard()).getSettings().getProcessorProperties());
        this.propsEditor.loadProperties((DBPPropertySource)this.propertySource);
        this.reloadPipes();
        this.updatePageCompletion();
        UIUtils.asyncExec(() -> UIUtils.packColumns((Table)this.filesTable, (boolean)true));
    }

    @NotNull
    private Composite createFileSelectionToolBar(@NotNull Composite inputFilesTableGroup) {
        Composite toolbar = new Composite(inputFilesTableGroup, 0);
        toolbar.setLayout((Layout)new GridLayout(4, false));
        UIUtils.createControlLabel((Composite)toolbar, (String)DTMessages.data_transfer_wizard_settings_group_input_files);
        this.tiOpenLocal = UIUtils.createPushButton((Composite)toolbar, (String)UIMessages.text_with_open_dialog_browse, (String)UIMessages.text_with_open_dialog_browse, (DBPImage)UIIcon.OPEN, (SelectionListener)SelectionListener.widgetSelectedAdapter(e -> new SelectInputFileAction(false).run()));
        if (this.showRemoteFS) {
            this.tiOpenRemote = UIUtils.createPushButton((Composite)toolbar, (String)UIMessages.text_with_open_dialog_browse_remote, (String)UIMessages.text_with_open_dialog_browse_remote, (DBPImage)UIIcon.OPEN_EXTERNAL, (SelectionListener)SelectionListener.widgetSelectedAdapter(e -> new SelectInputFileAction(true).run()));
        }
        this.openFSBrowserCheckbox = this.createOpenFSBrowserCheckbox(toolbar);
        UIUtils.createLabelSeparator((Composite)inputFilesTableGroup, (int)256);
        return toolbar;
    }

    @NotNull
    private Button createOpenFSBrowserCheckbox(@NotNull Composite toolbar) {
        return UIUtils.createCheckbox((Composite)toolbar, (String)DTUIMessages.pref_open_fs_browser_on_enter, (String)DTUIMessages.pref_open_fs_browser_on_enter_tooltip, (boolean)DBWorkbench.getPlatform().getPreferenceStore().getBoolean("openLocalFSBrowser"), (int)0);
    }

    @NotNull
    private Table createFilesTable(@NotNull Composite inputFilesTableGroup) {
        Table newFilesTable = new Table(inputFilesTableGroup, 65540);
        newFilesTable.setLayoutData((Object)new GridData(1808));
        newFilesTable.setHeaderVisible(true);
        newFilesTable.setLinesVisible(true);
        UIWidgets.setControlContextMenu((Control)newFilesTable, manager -> {
            manager.add((IAction)new SelectInputFileAction(false));
            if (this.showRemoteFS) {
                manager.add((IAction)new SelectInputFileAction(true));
            }
        });
        return newFilesTable;
    }

    private boolean isSkipTargetColumn() {
        return ((DataTransferWizard)this.getWizard()).getSettings().getSourceObjects().stream().noneMatch(so -> so instanceof DBSDataManipulator);
    }

    private void updateSingleConsumer(@NotNull DBRProgressMonitor monitor, @NotNull DataTransferPipe pipe, @NotNull Path path) {
        StreamTransferProducer stp;
        StreamProducerSettings producerSettings = ((DataTransferWizard)this.getWizard()).getPageSettings((IWizardPage)this, StreamProducerSettings.class);
        IDataTransferProducer iDataTransferProducer = pipe.getProducer();
        StreamTransferProducer oldProducer = iDataTransferProducer instanceof StreamTransferProducer ? (stp = (StreamTransferProducer)iDataTransferProducer) : null;
        StreamTransferProducer newProducer = new StreamTransferProducer(new StreamEntityMapping(path));
        pipe.setProducer((IDataTransferProducer)newProducer);
        producerSettings.updateProducerSettingsFromStream(monitor, newProducer, ((DataTransferWizard)this.getWizard()).getSettings());
        IDataTransferSettings consumerSettings = ((DataTransferWizard)this.getWizard()).getSettings().getNodeSettings(((DataTransferWizard)this.getWizard()).getSettings().getConsumer());
        if (consumerSettings instanceof DatabaseConsumerSettings) {
            StreamEntityMapping oldEntityMapping;
            DBSDataContainer dBSDataContainer;
            DatabaseMappingContainer oldMappingContainer;
            DBSObject dBSObject;
            DatabaseConsumerSettings settings = (DatabaseConsumerSettings)consumerSettings;
            DatabaseMappingContainer mapping = new DatabaseMappingContainer(settings, (DBSDataContainer)newProducer.getDatabaseObject());
            if (pipe.getConsumer() != null && (dBSObject = pipe.getConsumer().getDatabaseObject()) instanceof DBSDataManipulator) {
                DBSDataManipulator databaseObject = (DBSDataManipulator)dBSObject;
                DBSObject container = databaseObject.getParentObject();
                if (container instanceof DBSObjectContainer) {
                    settings.setContainer((DBSObjectContainer)container);
                }
                mapping.setTarget(databaseObject);
            } else {
                mapping.setTarget(null);
                mapping.setTargetName(this.generateTableName(newProducer.getObjectName()));
            }
            if (oldProducer != null && (oldMappingContainer = (DatabaseMappingContainer)settings.getDataMappings().remove(oldProducer.getDatabaseObject())) != null && (dBSDataContainer = oldMappingContainer.getSource()) instanceof StreamEntityMapping && (oldEntityMapping = (StreamEntityMapping)dBSDataContainer).isSameColumns(newProducer.getEntityMapping())) {
                StreamEntityMapping entityMapping = new StreamEntityMapping(path);
                settings.addDataMappings(((DataTransferWizard)this.getWizard()).getRunnableContext(), (DBSDataContainer)entityMapping, new DatabaseMappingContainer(oldMappingContainer, (DBSDataContainer)entityMapping));
                StreamTransferProducer producer = new StreamTransferProducer(entityMapping);
                pipe.setProducer((IDataTransferProducer)producer);
                producerSettings.updateProducerSettingsFromStream(monitor, producer, ((DataTransferWizard)this.getWizard()).getSettings());
                return;
            }
            settings.addDataMappings(((DataTransferWizard)this.getWizard()).getRunnableContext(), (DBSDataContainer)newProducer.getDatabaseObject(), mapping);
        }
    }

    private void updateItemData(TableItem item, DataTransferPipe pipe) {
        IDataTransferProducer producer = pipe.getProducer();
        if (this.isInvalidDataTransferNode((IDataTransferNode<?>)producer)) {
            item.setImage(0, null);
            item.setText(0, this.noneItemSelectedText);
        } else {
            item.setImage(0, DBeaverIcons.getImage((DBPImage)this.getProducerProcessor().getIcon()));
            if (producer instanceof StreamTransferProducer) {
                StreamTransferProducer stp = (StreamTransferProducer)producer;
                Path inputFile = stp.getInputFile();
                item.setText(0, DBFUtils.convertPathToString((Path)inputFile));
            } else {
                item.setText(0, String.valueOf(producer.getObjectName()));
            }
        }
        IDataTransferConsumer consumer = pipe.getConsumer();
        if (this.isInvalidDataTransferNode((IDataTransferNode<?>)consumer)) {
            item.setImage(1, null);
            item.setText(1, this.noneItemSelectedText);
        } else {
            item.setImage(1, DBeaverIcons.getImage((DBPImage)((DataTransferWizard)this.getWizard()).getSettings().getConsumer().getIcon()));
            item.setText(1, String.valueOf(consumer.getObjectName()));
        }
    }

    private boolean isInvalidDataTransferNode(IDataTransferNode<?> node) {
        return node == null || node.getObjectName() == null;
    }

    private void saveOpenFSBrowserPreference() {
        DBWorkbench.getPlatform().getPreferenceStore().setValue("openLocalFSBrowser", this.openFSBrowserCheckbox.getSelection());
    }

    protected boolean determinePageCompletion() {
        for (int i = 0; i < this.filesTable.getItemCount(); ++i) {
            DataTransferPipe pipe = (DataTransferPipe)this.filesTable.getItem(i).getData();
            if (!this.isInvalidDataTransferNode((IDataTransferNode<?>)pipe.getConsumer()) && !this.isInvalidDataTransferNode((IDataTransferNode<?>)pipe.getProducer())) continue;
            this.setMessage(DTUIMessages.stream_consumer_page_warning_not_enough_sources_chosen, 2);
            return false;
        }
        this.setMessage(null);
        return true;
    }

    private void reloadPipes() {
        DataTransferSettings settings = ((DataTransferWizard)this.getWizard()).getSettings();
        int selectionIndex = this.filesTable.getSelectionIndex();
        this.filesTable.removeAll();
        List dataPipes = settings.getDataPipes();
        for (DataTransferPipe pipe : dataPipes) {
            TableItem item = new TableItem(this.filesTable, 0);
            item.setData((Object)pipe);
            this.updateItemData(item, pipe);
        }
        if (!dataPipes.isEmpty()) {
            if (selectionIndex < 0) {
                selectionIndex = 0;
                if (this.isOpenFSBrowser()) {
                    this.openFSBrowser();
                }
            } else if (selectionIndex >= dataPipes.size()) {
                selectionIndex = dataPipes.size() - 1;
            }
            this.filesTable.select(selectionIndex);
        }
        this.updateBrowseButtons();
    }

    private boolean isOpenFSBrowser() {
        return this.openFSBrowserCheckbox.getSelection() && this.filesTable.getItemCount() == 1 && this.filesTable.getItem(0).getText().equals(this.noneItemSelectedText);
    }

    private void openFSBrowser() {
        UIUtils.asyncExec(() -> new SelectInputFileAction(false).run());
    }

    private void updateBrowseButtons() {
        boolean hasSelection;
        boolean bl = hasSelection = this.filesTable.getSelection().length > 0;
        if (this.tiOpenLocal != null) {
            this.tiOpenLocal.setEnabled(hasSelection);
        }
        if (this.tiOpenRemote != null) {
            this.tiOpenRemote.setEnabled(hasSelection);
        }
    }

    private DataTransferProcessorDescriptor getProducerProcessor() {
        return ((DataTransferWizard)this.getWizard()).getSettings().getProcessor();
    }

    @NotNull
    private String generateTableName(String fileName) {
        char c;
        StringBuilder name = new StringBuilder();
        int divPos = fileName.lastIndexOf(".");
        if (divPos != -1) {
            fileName = fileName.substring(0, divPos);
        }
        boolean lastCharSpecial = false;
        char lastChar = '\u0000';
        for (int i = 0; i < fileName.length() && (Character.isLetter(c = fileName.charAt(i)) || !lastCharSpecial); ++i) {
            boolean bl = lastCharSpecial = !Character.isLetterOrDigit(c);
            if (lastCharSpecial) {
                if (c != '_') {
                    c = '_';
                }
                if (lastChar == '_') continue;
            }
            lastChar = c;
            name.append(c);
        }
        if (!name.isEmpty() && name.charAt(name.length() - 1) == '_') {
            name.deleteCharAt(name.length() - 1);
        }
        return name.toString();
    }

    public boolean isPageApplicable() {
        return this.isProducerOfType(StreamTransferProducer.class);
    }

    private class SelectInputFileAction
    extends Action {
        private final boolean remote;

        public SelectInputFileAction(boolean remote) {
            super(remote ? UIMessages.text_with_open_dialog_browse_remote : UIMessages.text_with_open_dialog_browse);
            this.remote = remote;
        }

        public void run() {
            if (StreamProducerPageSettings.this.filesTable.getSelectionIndex() < 0) {
                return;
            }
            TableItem item = StreamProducerPageSettings.this.filesTable.getItem(StreamProducerPageSettings.this.filesTable.getSelectionIndex());
            DataTransferPipe pipe = (DataTransferPipe)item.getData();
            this.chooseSourceFile(pipe, this.remote);
        }

        private void chooseSourceFile(DataTransferPipe pipe, boolean remoteFS) {
            String[] extensions = new String[]{"*." + CommonUtils.toString((Object)StreamProducerPageSettings.this.propertySource.getPropertyValue(null, "extension")).replace(",", ";*."), "*.*"};
            DBRRunnableWithProgress initializer = null;
            DBPProject project = pipe.getConsumer().getProject();
            if (remoteFS && project != null) {
                StreamTransferProducer stp;
                IDataTransferProducer iDataTransferProducer;
                DBNPathBase selected = DBWorkbench.getPlatformUI().openFileSystemSelector(DTUIMessages.stream_producer_select_input_file, false, 4096, false, extensions, (iDataTransferProducer = pipe.getProducer()) instanceof StreamTransferProducer && (stp = (StreamTransferProducer)iDataTransferProducer).getInputFile() != null ? DBFUtils.convertPathToString((Path)stp.getInputFile()) : pipe.getProducer().getObjectName());
                if (selected != null) {
                    initializer = monitor -> StreamProducerPageSettings.this.updateSingleConsumer(monitor, pipe, selected.getPath());
                }
            } else if (pipe.getConsumer() != null && pipe.getConsumer().getTargetObjectContainer() != null) {
                File[] files = DialogUtils.openFileList((Shell)StreamProducerPageSettings.this.getShell(), (String)DTUIMessages.stream_producer_select_input_file, (String[])extensions);
                if (files != null && files.length > 0) {
                    initializer = monitor -> this.updateMultiConsumers(monitor, pipe, (Path[])Arrays.stream(files).map(File::toPath).toArray(Path[]::new));
                }
            } else {
                File file = DialogUtils.openFile((Shell)StreamProducerPageSettings.this.getShell(), (String[])extensions);
                if (file != null) {
                    initializer = monitor -> StreamProducerPageSettings.this.updateSingleConsumer(monitor, pipe, file.toPath());
                }
            }
            if (initializer != null) {
                try {
                    ((DataTransferWizard)StreamProducerPageSettings.this.getWizard()).getRunnableContext().run(true, true, initializer);
                }
                catch (InvocationTargetException e) {
                    DBWorkbench.getPlatformUI().showError(DTUIMessages.stream_producer_column_mapping_error_title, DTUIMessages.stream_producer_column_mapping_error_message, e.getTargetException());
                    return;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            StreamProducerPageSettings.this.reloadPipes();
            StreamProducerPageSettings.this.updatePageCompletion();
        }

        private void updateMultiConsumers(DBRProgressMonitor monitor, DataTransferPipe pipe, Path[] files) {
            StreamProducerSettings producerSettings = ((DataTransferWizard)StreamProducerPageSettings.this.getWizard()).getPageSettings((IWizardPage)StreamProducerPageSettings.this, StreamProducerSettings.class);
            IDataTransferConsumer originalConsumer = pipe.getConsumer();
            DataTransferSettings dtSettings = ((DataTransferWizard)StreamProducerPageSettings.this.getWizard()).getSettings();
            ArrayList<DataTransferPipe> newPipes = new ArrayList<DataTransferPipe>(dtSettings.getDataPipes());
            newPipes.remove(pipe);
            Deque pendingEntityMappings = Arrays.stream(files).map(StreamEntityMapping::new).collect(Collectors.toCollection(ArrayDeque::new));
            while (!pendingEntityMappings.isEmpty()) {
                Object object;
                StreamEntityMapping entityMapping = (StreamEntityMapping)pendingEntityMappings.remove();
                if (producerSettings.extractExtraEntities(monitor, entityMapping, dtSettings, (Collection)pendingEntityMappings)) continue;
                StreamTransferProducer producer = new StreamTransferProducer(entityMapping);
                DatabaseTransferConsumer consumer = new DatabaseTransferConsumer();
                DataTransferPipe singlePipe = new DataTransferPipe((IDataTransferProducer)producer, (IDataTransferConsumer)consumer);
                try {
                    singlePipe.initPipe(dtSettings, newPipes.size(), newPipes.size());
                }
                catch (DBException e) {
                    log.error((Object)e);
                    continue;
                }
                newPipes.add(singlePipe);
                producerSettings.updateProducerSettingsFromStream(monitor, producer, dtSettings);
                IDataTransferSettings consumerSettings = dtSettings.getNodeSettings(dtSettings.getConsumer());
                if (!(consumerSettings instanceof DatabaseConsumerSettings)) continue;
                DatabaseConsumerSettings dcs = (DatabaseConsumerSettings)consumerSettings;
                if (originalConsumer != null && (object = originalConsumer.getTargetObjectContainer()) instanceof DBSObjectContainer) {
                    DBSObjectContainer oc = (DBSObjectContainer)object;
                    dcs.setContainer(oc);
                }
                DatabaseMappingContainer mapping = new DatabaseMappingContainer(dcs, (DBSDataContainer)producer.getDatabaseObject());
                mapping.setTargetName(StreamProducerPageSettings.this.generateTableName(producer.getObjectName()));
                dcs.addDataMappings(((DataTransferWizard)StreamProducerPageSettings.this.getWizard()).getRunnableContext(), (DBSDataContainer)producer.getDatabaseObject(), mapping);
            }
            dtSettings.setDataPipes(newPipes, false);
            dtSettings.setPipeChangeRestricted(true);
        }
    }
}

