/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.registry;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.app.DBPApplication;
import org.jkiss.dbeaver.model.connection.DBPDriver;
import org.jkiss.dbeaver.model.impl.AbstractDescriptor;
import org.jkiss.dbeaver.model.runtime.OSDescriptor;
import org.jkiss.dbeaver.registry.NativeClientDistributionDescriptor;
import org.jkiss.dbeaver.registry.driver.DriverDescriptor;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.utils.RuntimeUtils;

public class NativeClientDescriptor
extends AbstractDescriptor {
    private final List<NativeClientDistributionDescriptor> distributions = new ArrayList<NativeClientDistributionDescriptor>();
    private String id;
    private String label;

    NativeClientDescriptor(IConfigurationElement config) {
        super(config.getContributor().getName());
        this.id = config.getAttribute("id");
        this.label = config.getAttribute("label");
        for (IConfigurationElement clientElement : config.getChildren("dist")) {
            this.distributions.add(new NativeClientDistributionDescriptor(clientElement));
        }
    }

    public String getId() {
        return this.id;
    }

    public String getLabel() {
        return this.label;
    }

    private boolean isClientsPathVirtualizedByWindows(Path clientFile) {
        DBPApplication application = DBWorkbench.getPlatform().getApplication();
        return application.isStandalone() && !application.isHeadlessMode() && RuntimeUtils.isWindowsStoreApplication() && clientFile.startsWith(System.getenv("AppData"));
    }

    @Nullable
    public NativeClientDistributionDescriptor findDistribution(@NotNull DBPDriver driver) {
        OSDescriptor localSystem = DBWorkbench.getPlatform().getLocalSystem();
        Path driversHome = DriverDescriptor.getCustomDriversHome().toAbsolutePath();
        for (NativeClientDistributionDescriptor distr : this.distributions) {
            if (!driver.isCustom() && !distr.supports(driver) || !distr.getOs().matches(localSystem) || this.isClientsPathVirtualizedByWindows(driversHome.resolve(distr.getTargetPath()))) continue;
            return distr;
        }
        return null;
    }

    public String toString() {
        return this.id;
    }
}

