/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.ai.utils;

import com.google.gson.JsonElement;
import com.google.gson.JsonSyntaxException;
import java.net.URI;
import java.net.URISyntaxException;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.data.json.JSONUtils;

public final class AIHttpUtils {
    private static final Log log = Log.getLog(AIHttpUtils.class);

    private AIHttpUtils() {
    }

    public static URI resolve(String base, String ... paths) throws DBException {
        try {
            URI uri = new URI(base);
            for (String path : paths) {
                uri = uri.resolve(path);
            }
            return uri;
        }
        catch (URISyntaxException e) {
            throw new DBException("Incorrect URI", (Throwable)e);
        }
    }

    @NotNull
    public static String parseOpenAIStyleErrorMessage(@NotNull String body) {
        try {
            JsonElement errorResponse = (JsonElement)JSONUtils.GSON.fromJson(body, JsonElement.class);
            if (errorResponse != null && errorResponse.isJsonObject()) {
                JsonElement messageElement;
                JsonElement messageElement2;
                JsonElement errorElement;
                if (errorResponse.getAsJsonObject().has("error") && (errorElement = errorResponse.getAsJsonObject().get("error")).isJsonObject() && errorElement.getAsJsonObject().has("message") && (messageElement2 = errorElement.getAsJsonObject().get("message")).isJsonPrimitive() && messageElement2.getAsJsonPrimitive().isString()) {
                    return messageElement2.getAsString();
                }
                if (errorResponse.getAsJsonObject().has("message") && (messageElement = errorResponse.getAsJsonObject().get("message")).isJsonPrimitive() && messageElement.getAsJsonPrimitive().isString()) {
                    return messageElement.getAsString();
                }
            }
            return body;
        }
        catch (JsonSyntaxException e) {
            log.debug((Object)("Failed to parse error response: " + e.getMessage()));
            return body;
        }
    }
}

