/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.erd.export;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import org.eclipse.draw2d.FreeformLayeredPane;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.SWTGraphics;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.graphics.Resource;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.ImageUtils;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.editors.erd.editor.ERDThemeSettings;
import org.jkiss.dbeaver.ui.editors.erd.export.ERDExportFormatHandler;
import org.jkiss.dbeaver.ui.editors.erd.model.EntityDiagram;
import org.jkiss.dbeaver.ui.editors.erd.part.DiagramPart;

public class ERDExportRasterImage
implements ERDExportFormatHandler {
    private static final int MARGIN_X = 10;
    private static final int MARGIN_Y = 10;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void exportDiagram(EntityDiagram diagram, IFigure figure, DiagramPart diagramPart, File targetFile) {
        int imageType = 0;
        String filePath = targetFile.getName().toLowerCase();
        if (filePath.endsWith(".jpg")) {
            imageType = 4;
        } else if (filePath.endsWith(".png")) {
            imageType = 5;
        } else if (filePath.endsWith(".gif")) {
            imageType = 2;
        }
        Rectangle contentBounds = figure instanceof FreeformLayeredPane ? ((FreeformLayeredPane)figure).getFreeformExtent() : figure.getBounds();
        try {
            if (contentBounds.isEmpty()) {
                throw new DBException("Can't serializeDiagram empty diagram");
            }
            try (FileOutputStream fos = new FileOutputStream(targetFile);){
                GC gc;
                block20: {
                    gc = null;
                    SWTGraphics graphics = null;
                    try {
                        Image image = new Image(null, contentBounds.width + 20, contentBounds.height + 20);
                        try {
                            gc = new GC((Drawable)image);
                            gc.setBackground(ERDThemeSettings.instance.diagramBackground);
                            gc.fillRectangle(image.getBounds());
                            graphics = new SWTGraphics(gc);
                            graphics.translate(contentBounds.x * -1 + 10, contentBounds.y * -1 + 10);
                            figure.paint((Graphics)graphics);
                            ImageLoader imageLoader = new ImageLoader();
                            imageLoader.data = new ImageData[1];
                            imageLoader.data[0] = imageType == 2 ? ImageUtils.makeWebImageData((Image)image) : ImageUtils.getImageDataAtCurrentZoom((Image)image);
                            imageLoader.save((OutputStream)fos, imageType);
                        }
                        finally {
                            UIUtils.dispose((Resource)image);
                        }
                        if (graphics == null) break block20;
                    }
                    catch (Throwable throwable) {
                        if (graphics != null) {
                            graphics.dispose();
                        }
                        UIUtils.dispose(gc);
                        throw throwable;
                    }
                    graphics.dispose();
                }
                UIUtils.dispose((Resource)gc);
                fos.flush();
                return;
            }
        }
        catch (Throwable e) {
            DBWorkbench.getPlatformUI().showError("Save ERD as image", null, e);
        }
    }
}

