/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls.resultset.plaintext;

import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.DBDAttributeBinding;
import org.jkiss.dbeaver.model.data.DBDDisplayFormat;
import org.jkiss.dbeaver.model.impl.data.DBDValueError;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetModel;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetRow;
import org.jkiss.utils.CommonUtils;

public class PlainTextFormatter {
    private final DBPPreferenceStore prefs;
    private boolean rightJustifyNumbers;
    private boolean rightJustifyDateTime;
    private int maxColumnSize;
    private boolean delimLeading;
    private boolean delimTrailing;
    private boolean delimTop;
    private boolean delimBottom;
    private boolean extraSpaces;
    private boolean lineNumbers;
    private boolean showNulls;
    private DBDDisplayFormat displayFormat;
    private int[] colWidths;
    private int startOffset;
    private final StringBuilder fixCellStringBuffer = new StringBuilder();

    public PlainTextFormatter(@NotNull DBPPreferenceStore prefs) {
        this.prefs = prefs;
        this.loadPrefs(prefs);
    }

    private void loadPrefs(@NotNull DBPPreferenceStore prefs) {
        this.maxColumnSize = prefs.getInt("resultset.text.max.column.size");
        this.delimLeading = prefs.getBoolean("resultset.text.delimiter.leading");
        this.delimTrailing = prefs.getBoolean("resultset.text.delimiter.trailing");
        this.delimTop = prefs.getBoolean("resultset.text.delimiter.top");
        this.delimBottom = prefs.getBoolean("resultset.text.delimiter.bottom");
        this.extraSpaces = prefs.getBoolean("resultset.text.extra.spaces");
        this.lineNumbers = prefs.getBoolean("resultset.text.line.number");
        this.showNulls = prefs.getBoolean("resultset.text.show.nulls");
        this.displayFormat = DBDDisplayFormat.safeValueOf((String)prefs.getString("resultset.text.value.format"));
        this.extraSpaces = prefs.getBoolean("resultset.text.extra.spaces");
        this.rightJustifyNumbers = prefs.getBoolean("resultset.show.rightJustifyNumbers");
        this.rightJustifyDateTime = prefs.getBoolean("resultset.show.rightJustifyDateTime");
    }

    public int[] getColWidths() {
        return this.colWidths;
    }

    public int getStartOffset() {
        return this.startOffset;
    }

    public int printGrid(StringBuilder grid, ResultSetModel model) {
        DBDAttributeBinding attr;
        int i;
        int extraSpacesNum;
        List<DBDAttributeBinding> attrs = model.getVisibleAttributes();
        List<ResultSetRow> allRows = model.getAllRows();
        int n = extraSpacesNum = this.extraSpaces ? 2 : 0;
        if (this.colWidths == null) {
            this.colWidths = new int[attrs.size()];
            this.startOffset = !attrs.isEmpty() && this.lineNumbers ? this.getStringWidth(String.valueOf(allRows.size() + 1)) + extraSpacesNum + 1 : 0;
            for (i = 0; i < attrs.size(); ++i) {
                attr = attrs.get(i);
                this.colWidths[i] = PlainTextFormatter.getAttributeName(attr).length() + extraSpacesNum;
                if (this.showNulls && !attr.isRequired()) {
                    this.colWidths[i] = Math.max(this.colWidths[i], "[NULL]".length());
                }
                for (ResultSetRow row : allRows) {
                    String displayString = this.getCellString(model, attr, row, this.displayFormat);
                    this.colWidths[i] = Math.max(this.colWidths[i], this.getStringWidth(displayString) + extraSpacesNum);
                }
            }
            for (i = 0; i < this.colWidths.length; ++i) {
                if (this.colWidths[i] <= this.maxColumnSize) continue;
                this.colWidths[i] = this.maxColumnSize;
            }
        }
        if (this.delimTop) {
            this.printSeparator(grid, this.colWidths);
        }
        if (this.delimLeading) {
            grid.append("|");
        }
        if (this.lineNumbers && attrs.size() != 0) {
            if (this.extraSpaces) {
                grid.append(" ");
            }
            grid.append("#");
            grid.append(" ".repeat(Math.max(0, this.startOffset - extraSpacesNum - 2)));
            if (this.extraSpaces) {
                grid.append(" ");
            }
        }
        for (i = 0; i < attrs.size(); ++i) {
            if (i > 0 || this.startOffset != 0) {
                grid.append("|");
            }
            if (this.extraSpaces) {
                grid.append(" ");
            }
            attr = attrs.get(i);
            String attrName = PlainTextFormatter.getAttributeName(attr);
            grid.append(attrName).append(" ".repeat(Math.max(0, this.colWidths[i] - attrName.length() - extraSpacesNum)));
            if (!this.extraSpaces) continue;
            grid.append(" ");
        }
        if (this.delimTrailing) {
            grid.append("|");
        }
        grid.append("\n");
        this.printSeparator(grid, this.colWidths);
        i = 1;
        for (ResultSetRow row : allRows) {
            if (this.delimLeading) {
                grid.append("|");
            }
            if (this.lineNumbers) {
                if (this.extraSpaces) {
                    grid.append(" ");
                }
                String displayNumber = String.valueOf(i);
                grid.append(displayNumber);
                int stringWidth = this.getStringWidth(displayNumber);
                grid.append(" ".repeat(Math.max(0, this.startOffset - stringWidth - extraSpacesNum - 1)));
                if (this.extraSpaces) {
                    grid.append(" ");
                }
            }
            for (int k = 0; k < attrs.size(); ++k) {
                DBPDataKind dataKind;
                DBDAttributeBinding attr2;
                String displayString;
                if (k > 0 || this.startOffset != 0) {
                    grid.append("|");
                }
                if ((displayString = this.getCellString(model, attr2 = attrs.get(k), row, this.displayFormat)).length() >= this.colWidths[k]) {
                    displayString = CommonUtils.truncateString((String)displayString, (int)this.colWidths[k]);
                }
                int stringWidth = this.getStringWidth(displayString);
                if (this.extraSpaces) {
                    grid.append(" ");
                }
                if ((dataKind = attr2.getDataKind()) == DBPDataKind.NUMERIC && this.rightJustifyNumbers || dataKind == DBPDataKind.DATETIME && this.rightJustifyDateTime) {
                    grid.append(" ".repeat(Math.max(0, this.colWidths[k] - stringWidth - extraSpacesNum))).append(displayString);
                } else {
                    grid.append(displayString).append(" ".repeat(Math.max(0, this.colWidths[k] - stringWidth - extraSpacesNum)));
                }
                if (!this.extraSpaces) continue;
                grid.append(" ");
            }
            if (this.delimTrailing) {
                grid.append("|");
            }
            grid.append("\n");
            ++i;
        }
        if (this.delimBottom) {
            this.printSeparator(grid, this.colWidths);
        }
        grid.setLength(grid.length() - 1);
        return allRows.size();
    }

    /*
     * Enabled aggressive block sorting
     */
    public String getCellString(ResultSetModel model, DBDAttributeBinding attr, ResultSetRow row, DBDDisplayFormat displayFormat) {
        String displayString;
        Object cellValue = model.getCellValue(attr, row);
        if (cellValue instanceof DBDValueError) {
            return ((DBDValueError)cellValue).getErrorTitle();
        }
        if (cellValue instanceof Number && this.prefs.getBoolean("resultset.format.numeric.native")) {
            displayFormat = DBDDisplayFormat.NATIVE;
        }
        if ((displayString = attr.getValueHandler().getValueDisplayString((DBSTypedObject)attr, cellValue, displayFormat)).isEmpty() && this.showNulls && DBUtils.isNullValue((Object)cellValue)) {
            displayString = "[NULL]";
        }
        this.fixCellStringBuffer.setLength(0);
        int i = 0;
        while (true) {
            block11: {
                if (i >= displayString.length()) {
                    return this.fixCellStringBuffer.toString();
                }
                char c = displayString.charAt(i);
                switch (c) {
                    case '\n': {
                        c = '\u00b6';
                        break;
                    }
                    case '\r': {
                        break block11;
                    }
                    case '\u0000': 
                    case '\t': 
                    case '\u00ff': {
                        c = ' ';
                    }
                }
                if (c < ' ') {
                    c = ' ';
                }
                this.fixCellStringBuffer.append(c);
            }
            ++i;
        }
    }

    public void printRecord(StringBuilder grid, ResultSetModel model, ResultSetRow currentRow) {
        String indent = this.extraSpaces ? " " : "";
        List<DBDAttributeBinding> attrs = model.getVisibleAttributes();
        String[] values = new String[attrs.size()];
        int nameWidth = 4;
        int valueWidth = 5;
        for (int i = 0; i < attrs.size(); ++i) {
            String displayString;
            DBDAttributeBinding attr = attrs.get(i);
            nameWidth = Math.max(nameWidth, PlainTextFormatter.getAttributeName(attr).length());
            if (currentRow == null) continue;
            values[i] = displayString = this.getCellString(model, attr, currentRow, this.displayFormat);
            valueWidth = Math.max(valueWidth, values[i].length());
        }
        int extraSpacesNum = this.extraSpaces ? 2 : 0;
        int[] colWidths = new int[]{nameWidth + extraSpacesNum, valueWidth + extraSpacesNum};
        if (this.delimTop) {
            this.printSeparator(grid, colWidths);
        }
        if (this.delimLeading) {
            grid.append("|");
        }
        grid.append(indent).append("Name").append(" ".repeat(nameWidth - 4));
        grid.append(indent).append("|").append(indent).append("Value").append(" ".repeat(valueWidth - 5));
        grid.append(indent);
        if (this.delimTrailing) {
            grid.append("|");
        }
        grid.append("\n");
        this.printSeparator(grid, colWidths);
        if (currentRow != null) {
            for (int i = 0; i < attrs.size(); ++i) {
                DBDAttributeBinding attr = attrs.get(i);
                String name = PlainTextFormatter.getAttributeName(attr);
                if (this.delimLeading) {
                    grid.append("|");
                }
                grid.append(indent).append(name).append(indent).append(" ".repeat(Math.max(0, nameWidth - name.length())));
                grid.append("|");
                grid.append(indent).append(values[i]).append(" ".repeat(Math.max(0, valueWidth - values[i].length())));
                grid.append(indent);
                if (this.delimTrailing) {
                    grid.append("|");
                }
                grid.append("\n");
            }
        }
        if (this.delimBottom) {
            this.printSeparator(grid, colWidths);
        }
        grid.setLength(grid.length() - 1);
    }

    public void printSeparator(StringBuilder output, int[] columnWidth) {
        if (this.delimLeading) {
            output.append('+');
        }
        if (this.startOffset != 0) {
            output.append("-".repeat(Math.max(0, this.startOffset - 1)));
        }
        for (int i = 0; i < columnWidth.length; ++i) {
            if (i > 0 || this.startOffset != 0) {
                output.append('+');
            }
            output.append("-".repeat(Math.max(0, columnWidth[i])));
        }
        if (this.delimTrailing) {
            output.append('+');
        }
        output.append('\n');
    }

    public void printQueryName(StringBuilder sb, String name) {
        sb.append("> ").append(name).append("\n");
    }

    private int getStringWidth(String str) {
        int width = 0;
        if (str != null && str.length() > 0) {
            for (int i = 0; i < str.length(); ++i) {
                char c = str.charAt(i);
                if (c == '\t') {
                    width += this.prefs.getInt("resultset.text.tab.size");
                    continue;
                }
                ++width;
            }
        }
        return width;
    }

    private static String getAttributeName(DBDAttributeBinding attr) {
        if (CommonUtils.isEmpty((String)attr.getLabel())) {
            return attr.getName();
        }
        return attr.getLabel();
    }
}

