/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.filter;

import java.util.Arrays;
import org.freeplane.features.filter.EditDistanceStringMatchingStrategy;
import org.freeplane.features.filter.StringMatchingStrategy;

public class PseudoDamerauLevenshtein
implements EditDistanceStringMatchingStrategy {
    private int[][] matrix;
    private String searchTerm;
    private String searchText;
    private final int costIndel = 1;
    private final int costMismatch = 1;
    private final int costTranspos = 1;
    private StringMatchingStrategy.Type type;

    private boolean isWordBegin(int position) {
        if (position == 0 || position == this.searchText.length()) {
            return true;
        }
        return Character.isLetterOrDigit(this.searchText.charAt(position)) && !Character.isLetterOrDigit(this.searchText.charAt(position - 1));
    }

    private boolean isWordEnd(int position) {
        if (position == 0 || position == this.searchText.length()) {
            return true;
        }
        return Character.isLetterOrDigit(this.searchText.charAt(position - 1)) && !Character.isLetterOrDigit(this.searchText.charAt(position));
    }

    private boolean isMatch(int i, int j) {
        char row;
        char col = this.searchTerm.charAt(i - 1);
        return col == (row = this.searchText.charAt(j - 1)) || row == '-';
    }

    @Override
    public int distance() {
        int min;
        int j;
        int j2;
        int i;
        this.matrix = new int[this.searchTerm.length() + 1][this.searchText.length() + 1];
        for (i = 0; i <= this.searchTerm.length(); ++i) {
            this.matrix[i][0] = i * 1;
        }
        if (this.type == StringMatchingStrategy.Type.ALL) {
            for (j2 = 1; j2 <= this.searchText.length(); ++j2) {
                this.matrix[0][j2] = j2 * 1;
            }
        } else if (this.type == StringMatchingStrategy.Type.WORDWISE) {
            j2 = 1;
            int letterCounter = 1;
            while (j2 <= this.searchText.length()) {
                if (this.isWordBegin(j2)) {
                    letterCounter = 0;
                }
                this.matrix[0][j2] = letterCounter * 1;
                ++j2;
                ++letterCounter;
            }
        } else if (this.type == StringMatchingStrategy.Type.SUBSTRING) {
            Arrays.fill(this.matrix[0], 0);
        }
        for (i = 1; i <= this.searchTerm.length(); ++i) {
            for (j = 1; j <= this.searchText.length(); ++j) {
                int cost_try_match = this.matrix[i - 1][j - 1] + (this.isMatch(i, j) ? 0 : 1);
                int cost_ins = this.matrix[i - 1][j] + 1;
                int cost_del = this.matrix[i][j - 1] + 1;
                this.matrix[i][j] = Math.min(cost_try_match, Math.min(cost_ins, cost_del));
                if (i < 2 || j < 2 || this.searchTerm.charAt(i - 2) != this.searchText.charAt(j - 1) || this.searchTerm.charAt(i - 1) != this.searchText.charAt(j - 2)) continue;
                this.matrix[i][j] = Math.min(this.matrix[i][j], this.matrix[i - 2][j - 2] + 1);
            }
        }
        if (this.type == StringMatchingStrategy.Type.ALL) {
            return this.matrix[this.searchTerm.length()][this.searchText.length()];
        }
        if (this.type == StringMatchingStrategy.Type.WORDWISE) {
            min = Integer.MAX_VALUE;
            j = this.searchText.length();
            int letterCounter = 0;
            while (j >= 0) {
                if (this.isWordEnd(j)) {
                    letterCounter = 0;
                }
                min = Math.min(min, this.matrix[this.searchTerm.length()][j] + letterCounter * 1);
                --j;
                ++letterCounter;
            }
            return min;
        }
        min = Integer.MAX_VALUE;
        for (j = 0; j <= this.searchText.length(); ++j) {
            min = Math.min(min, this.matrix[this.searchTerm.length()][j]);
        }
        return min;
    }

    private float getMatchProb(int distance) {
        if (this.type == StringMatchingStrategy.Type.ALL) {
            return 1.0f - (float)distance / (float)Math.min(this.searchTerm.length(), this.searchText.length());
        }
        return 1.0f - (float)distance / (float)this.searchTerm.length();
    }

    @Override
    public float matchProb() {
        int dist = this.distance();
        this.matrix = null;
        return this.getMatchProb(dist);
    }

    @Override
    public void init(String searchTerm, String searchText, StringMatchingStrategy.Type matchType) {
        if (searchTerm == null || searchText == null) {
            throw new IllegalArgumentException("Null searchText/searchTerm!");
        }
        this.searchTerm = searchTerm;
        this.searchText = searchText;
        this.type = matchType;
    }

    @Override
    public boolean matches(String searchTerm, String searchText, StringMatchingStrategy.Type matchType) {
        this.init(searchTerm, searchText, matchType);
        return (double)this.matchProb() > StringMatchingStrategy.APPROXIMATE_MATCHING_MINPROB;
    }
}

