/*
 * Decompiled with CFR 0.152.
 */
package net.infonode.util;

import java.awt.Color;

public final class ColorUtil {
    private ColorUtil() {
    }

    public static Color getOpposite(Color c) {
        return ColorUtil.isDark(c) ? Color.WHITE : Color.BLACK;
    }

    public static Color shade(Color c, double amount) {
        return ColorUtil.blend(c, ColorUtil.getOpposite(c), amount);
    }

    public static final Color mult(Color c, double amount) {
        return c == null ? null : new Color(Math.min(255, (int)((double)c.getRed() * amount)), Math.min(255, (int)((double)c.getGreen() * amount)), Math.min(255, (int)((double)c.getBlue() * amount)), c.getAlpha());
    }

    public static Color setAlpha(Color c, int alpha) {
        return c == null ? null : new Color(c.getRed(), c.getGreen(), c.getBlue(), alpha);
    }

    public static final Color add(Color c1, Color c2) {
        return c1 == null ? c2 : (c2 == null ? c1 : new Color(Math.min(255, c1.getRed() + c2.getRed()), Math.min(255, c1.getGreen() + c2.getGreen()), Math.min(255, c1.getBlue() + c2.getBlue()), c1.getAlpha()));
    }

    public static Color blend(Color c1, Color c2, double v) {
        double v2 = 1.0 - v;
        return c1 == null ? (c2 == null ? null : c2) : (c2 == null ? c1 : new Color(Math.min(255, (int)((double)c1.getRed() * v2 + (double)c2.getRed() * v)), Math.min(255, (int)((double)c1.getGreen() * v2 + (double)c2.getGreen() * v)), Math.min(255, (int)((double)c1.getBlue() * v2 + (double)c2.getBlue() * v)), Math.min(255, (int)((double)c1.getAlpha() * v2 + (double)c2.getAlpha() * v))));
    }

    public static boolean isDark(Color c) {
        return c.getRed() + c.getGreen() + c.getBlue() < 540;
    }

    public static Color highlight(Color c) {
        return ColorUtil.mult(c, ColorUtil.isDark(c) ? 1.5f : 0.67f);
    }

    public static Color copy(Color c) {
        return c == null ? null : new Color(c.getRed(), c.getGreen(), c.getBlue(), c.getAlpha());
    }
}

