/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.ai.chat;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.freeplane.core.ui.textchanger.TranslatedElementFactory;
import org.freeplane.plugin.ai.chat.AssistantProfile;
import org.freeplane.plugin.ai.chat.AssistantProfileManagerDialog;
import org.freeplane.plugin.ai.chat.AssistantProfileSelectionModel;
import org.freeplane.plugin.ai.chat.AssistantProfileSelectionSync;

class AssistantProfilePaneBuilder {
    static final String MANAGE_PROFILES_TEXT_KEY = "ai_chat_manage_profiles";
    private final AssistantProfileSelectionModel selectionModel;
    private final AssistantProfileSelectionSync selectionSync;
    private final JComboBox<AssistantProfile> selector = new JComboBox();
    private final JButton manageProfilesButton;
    private boolean updatingSelection;
    private JPanel panel;

    AssistantProfilePaneBuilder(AssistantProfileSelectionModel selectionModel, AssistantProfileSelectionSync selectionSync, Icon assistantProfileIcon) {
        this.selectionModel = selectionModel;
        this.selectionSync = selectionSync;
        this.manageProfilesButton = new JButton(assistantProfileIcon);
    }

    void initialize() {
        this.selector.addActionListener(event -> this.handleAssistantProfileSelection());
        this.manageProfilesButton.addActionListener(event -> this.openAssistantProfileManager());
        this.setAssistantProfileSelection(this.selectionModel.getSelectedProfile(), true);
    }

    JPanel buildPanel() {
        if (this.panel == null) {
            this.panel = new JPanel(new BorderLayout(5, 0));
            this.panel.add(this.selector, "Center");
            TranslatedElementFactory.createTooltip((JComponent)this.manageProfilesButton, (String)MANAGE_PROFILES_TEXT_KEY);
            this.panel.add((Component)this.manageProfilesButton, "East");
        }
        return this.panel;
    }

    void syncSelection(boolean fromTranscriptRestore) {
        AssistantProfile selected = this.selectionSync.selectForActivation(fromTranscriptRestore);
        this.setAssistantProfileSelection(selected, false);
    }

    private void handleAssistantProfileSelection() {
        if (this.updatingSelection) {
            return;
        }
        AssistantProfile profile = (AssistantProfile)this.selector.getSelectedItem();
        if (profile == null) {
            return;
        }
        this.selectionSync.handleUserSelection(profile);
    }

    void openAssistantProfileManager() {
        AssistantProfileManagerDialog dialog = new AssistantProfileManagerDialog(SwingUtilities.getWindowAncestor(this.panel), this.selectionModel);
        dialog.openDialog();
        AssistantProfile current = this.selectionModel.getSelectedProfile();
        this.selectionModel.reloadProfiles();
        if (current != null) {
            this.selectionModel.selectById(current.getId());
            this.setAssistantProfileSelection(this.selectionModel.getSelectedProfile(), false);
        } else {
            this.setAssistantProfileSelection(this.selectionModel.getSelectedProfile(), false);
        }
    }

    private void setAssistantProfileSelection(AssistantProfile profile, boolean updateLastUsed) {
        this.updatingSelection = true;
        AssistantProfile resolved = profile == null ? AssistantProfile.defaultProfile() : profile;
        DefaultComboBoxModel<AssistantProfile> model = new DefaultComboBoxModel<AssistantProfile>(this.selectionModel.getProfiles().toArray(new AssistantProfile[0]));
        this.selector.setModel(model);
        this.selector.setSelectedItem(resolved);
        this.selectionModel.setSelectedProfile(resolved, updateLastUsed);
        this.updatingSelection = false;
    }
}

