/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.ai.mcpserver;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import dev.langchain4j.agent.tool.ToolExecutionRequest;
import dev.langchain4j.invocation.InvocationContext;
import dev.langchain4j.service.tool.ToolExecutionResult;
import dev.langchain4j.service.tool.ToolExecutor;
import java.util.Map;
import java.util.Objects;
import org.freeplane.core.util.LogUtils;
import org.freeplane.plugin.ai.tools.utilities.ToolExecutorFactory;
import org.freeplane.plugin.ai.tools.utilities.ToolExecutorRegistry;

public class ModelContextProtocolToolDispatcher {
    private final ObjectMapper objectMapper;
    private final Map<String, ToolExecutor> toolExecutorsByName;

    public ModelContextProtocolToolDispatcher(Object toolSet, ObjectMapper objectMapper) {
        Objects.requireNonNull(toolSet, "toolSet");
        this.objectMapper = Objects.requireNonNull(objectMapper, "objectMapper");
        ToolExecutorFactory toolExecutorFactory = new ToolExecutorFactory(false, false);
        ToolExecutorRegistry toolExecutorRegistry = toolExecutorFactory.createRegistry(toolSet);
        this.toolExecutorsByName = toolExecutorRegistry.getExecutorsByName();
    }

    public ToolExecutionResult dispatch(String toolName, JsonNode argumentsNode) {
        return this.executeTool(toolName, argumentsNode);
    }

    private ToolExecutionResult executeTool(String toolName, JsonNode argumentsNode) {
        ToolExecutionRequest request;
        ToolExecutionResult result;
        ToolExecutor executor = this.toolExecutorsByName.get(toolName);
        if (executor == null) {
            LogUtils.info((String)this.buildToolCallLog(toolName, null, "Unknown tool name: " + toolName));
            throw new IllegalArgumentException("Unknown tool name: " + toolName);
        }
        String arguments = "{}";
        if (argumentsNode != null && !argumentsNode.isNull()) {
            try {
                arguments = this.objectMapper.writeValueAsString((Object)argumentsNode);
            }
            catch (Exception error) {
                LogUtils.info((String)this.buildToolCallLog(toolName, null, "Invalid tool arguments."));
                throw new IllegalArgumentException("Invalid tool arguments.", error);
            }
        }
        if ((result = executor.executeWithContext(request = ToolExecutionRequest.builder().name(toolName).arguments(arguments).build(), InvocationContext.builder().build())) != null && result.isError()) {
            LogUtils.info((String)this.buildToolCallLog(toolName, arguments, result.resultText()));
        }
        return result;
    }

    private String buildToolCallLog(String toolName, String arguments, String errorMessage) {
        String safeToolName = toolName == null ? "unknown tool" : toolName;
        String safeArguments = arguments == null ? "" : arguments;
        String safeError = errorMessage == null ? "" : errorMessage;
        return "MCP tool error: tool=" + safeToolName + ", arguments=" + safeArguments + ", error=" + safeError;
    }
}

