/*
 * Decompiled with CFR 0.152.
 */
package mdemangler.functiontype;

import java.util.ArrayList;
import java.util.List;
import mdemangler.MDException;
import mdemangler.MDMang;
import mdemangler.MDParsableItem;
import mdemangler.datatype.MDDataType;
import mdemangler.datatype.MDDataTypeParser;
import mdemangler.datatype.MDVarArgsType;
import mdemangler.datatype.MDVoidDataType;
import mdemangler.datatype.complex.MDComplexType;
import mdemangler.datatype.extended.MDExtendedType;
import mdemangler.datatype.modifier.MDModifierType;

public class MDArgumentsList
extends MDParsableItem {
    private List<MDDataType> args = new ArrayList<MDDataType>();

    public MDArgumentsList(MDMang dmang) {
        super(dmang);
    }

    public int getNumArgs() {
        return this.args.size();
    }

    public MDDataType getArg(int index) {
        return this.args.get(index);
    }

    @Override
    protected void parseInternal() throws MDException {
        boolean argsDone = false;
        block7: while (!argsDone) {
            MDDataType dt;
            char code = this.dmang.peek();
            switch (code) {
                case '@': {
                    this.dmang.increment();
                    argsDone = true;
                    continue block7;
                }
                case 'X': {
                    this.dmang.increment();
                    dt = new MDVoidDataType(this.dmang);
                    dt.parse();
                    if (this.args.size() == 0) {
                        argsDone = true;
                    }
                    this.args.add(dt);
                    if (this.dmang.peek() != '@') continue block7;
                    throw new MDException("Void list has '@' terminator");
                }
                case 'Z': {
                    this.dmang.increment();
                    dt = new MDVarArgsType(this.dmang);
                    dt.parse();
                    this.args.add(dt);
                    argsDone = true;
                    continue block7;
                }
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    this.dmang.increment();
                    int index = code - 48;
                    dt = this.dmang.getBackreferenceFunctionParameterMDDataType(index);
                    this.args.add(dt);
                    continue block7;
                }
                case '\uffff': {
                    throw new MDException("String Terminated");
                }
            }
            dt = MDDataTypeParser.parsePrimaryDataType(this.dmang, true);
            dt.parse();
            this.args.add(dt);
            if (!(dt instanceof MDModifierType) && !(dt instanceof MDExtendedType) && !(dt instanceof MDComplexType)) continue;
            this.dmang.addBackrefFunctionParameterMDDataType(dt);
        }
    }

    @Override
    public void insert(StringBuilder builder) {
        if (this.args.size() > 0) {
            Boolean firstArgDone = false;
            for (MDDataType arg : this.args) {
                if (firstArgDone.booleanValue()) {
                    this.dmang.appendString(builder, ",");
                }
                firstArgDone = true;
                StringBuilder argBuilder = new StringBuilder();
                arg.insert(argBuilder);
                this.dmang.appendString(builder, argBuilder.toString().trim());
            }
        }
    }
}

