/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pdb;

import ghidra.app.util.bin.format.pdb.ApplySourceFiles;
import ghidra.app.util.bin.format.pdb.ApplySymbols;
import ghidra.app.util.bin.format.pdb.PdbParser;
import ghidra.app.util.importer.MessageLog;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import ghidra.xml.XmlElement;
import ghidra.xml.XmlPullParser;

class ApplyTables {
    private ApplyTables() {
    }

    static void applyTo(PdbParser pdbParser, XmlPullParser xmlParser, TaskMonitor monitor, MessageLog log) throws CancelledException {
        while (xmlParser.hasNext()) {
            if (monitor.isCancelled()) {
                return;
            }
            XmlElement elem = xmlParser.next();
            if (elem.isEnd() && elem.getName().equals("tables")) break;
            String tableName = elem.getAttribute("name");
            if ("Symbols".equals(tableName)) {
                ApplySymbols.applyTo(pdbParser, xmlParser, monitor, log);
                continue;
            }
            if ("SourceFiles".equals(tableName)) {
                ApplySourceFiles.applyTo(pdbParser, xmlParser, monitor, log);
                continue;
            }
            if (!"Sections".equals(tableName)) continue;
        }
    }
}

