/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pdb2.pdbreader.symbol;

import ghidra.app.util.bin.format.pdb2.pdbreader.AbstractPdb;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbByteReader;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.app.util.bin.format.pdb2.pdbreader.StringParseType;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.AbstractMsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.NameMsSymbol;

public abstract class AbstractObjectNameMsSymbol
extends AbstractMsSymbol
implements NameMsSymbol {
    protected long signature;
    protected String name;

    public AbstractObjectNameMsSymbol(AbstractPdb pdb, PdbByteReader reader, StringParseType strType) throws PdbException {
        super(pdb, reader);
        this.signature = reader.parseUnsignedIntVal();
        this.name = reader.parseString(pdb, strType);
    }

    public long getSignature() {
        return this.signature;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void emit(StringBuilder builder) {
        builder.append(String.format("%s: Signature: ", this.getSymbolTypeName()));
        builder.append(this.signature);
        builder.append(", ");
        builder.append(this.name);
    }
}

