/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pdb2.pdbreader.type;

import ghidra.app.util.bin.format.pdb2.pdbreader.AbstractPdb;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbByteReader;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.app.util.bin.format.pdb2.pdbreader.RecordCategory;
import ghidra.app.util.bin.format.pdb2.pdbreader.RecordNumber;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.AbstractMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.CallingConvention;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.FunctionMsAttributes;

public abstract class AbstractProcedureMsType
extends AbstractMsType {
    protected RecordNumber returnValueRecordNumber;
    protected CallingConvention callingConvention;
    protected FunctionMsAttributes functionAttributes;
    protected int numParameters;
    protected RecordNumber argListRecordNumber;

    public AbstractProcedureMsType(AbstractPdb pdb, PdbByteReader reader, int recordNumberSize) throws PdbException {
        super(pdb, reader);
        this.returnValueRecordNumber = RecordNumber.parse(pdb, reader, RecordCategory.TYPE, recordNumberSize);
        this.callingConvention = CallingConvention.fromValue(reader.parseUnsignedByteVal());
        this.functionAttributes = new FunctionMsAttributes(reader);
        this.numParameters = reader.parseUnsignedShortVal();
        this.argListRecordNumber = RecordNumber.parse(pdb, reader, RecordCategory.TYPE, recordNumberSize);
        reader.skipPadding();
    }

    public RecordNumber getReturnRecordNumber() {
        return this.returnValueRecordNumber;
    }

    public CallingConvention getCallingConvention() {
        return this.callingConvention;
    }

    public FunctionMsAttributes getFunctionAttributes() {
        return this.functionAttributes;
    }

    public int getNumParams() {
        return this.numParameters;
    }

    public RecordNumber getArgListRecordNumber() {
        return this.argListRecordNumber;
    }

    public AbstractMsType getReturnType() {
        return this.pdb.getTypeRecord(this.returnValueRecordNumber);
    }

    public AbstractMsType getArgumentsListType() {
        return this.pdb.getTypeRecord(this.argListRecordNumber);
    }

    @Override
    public void emit(StringBuilder builder, AbstractMsType.Bind bind) {
        if (bind.ordinal() < AbstractMsType.Bind.PROC.ordinal()) {
            builder.insert(0, "(");
            builder.append(")");
        }
        builder.append(this.getArgumentsListType());
        this.getReturnType().emit(builder, AbstractMsType.Bind.PROC);
    }
}

