/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pdb2.pdbreader.type;

import ghidra.app.util.bin.format.pdb2.pdbreader.AbstractPdb;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbByteReader;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.AbstractMsType;

public class UnknownMsType
extends AbstractMsType {
    private int unknownPdbId = 0;
    private byte[] data;

    public UnknownMsType(AbstractPdb pdb, PdbByteReader reader, int unknownPdbId) {
        super(pdb, reader);
        this.unknownPdbId = unknownPdbId;
        this.data = reader.parseBytesRemaining();
    }

    @Override
    public int getPdbId() {
        return this.unknownPdbId;
    }

    public byte[] getData() {
        return this.data;
    }

    @Override
    public void emit(StringBuilder builder, AbstractMsType.Bind bind) {
        PdbByteReader reader = new PdbByteReader(this.data);
        builder.append(String.format("UNKNOWN_TYPE (0X%04X): Bytes:%s", this.unknownPdbId, reader.dumpBytes()));
    }
}

