/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.pdb.pdbapplicator;

import ghidra.app.util.bin.format.pdb2.pdbreader.MsSymbolIterator;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.AbstractMsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.AbstractPublicMsSymbol;
import ghidra.app.util.datatype.microsoft.GuidDataType;
import ghidra.app.util.datatype.microsoft.GuidUtil;
import ghidra.app.util.pdb.pdbapplicator.DefaultPdbApplicator;
import ghidra.app.util.pdb.pdbapplicator.DirectSymbolApplier;
import ghidra.app.util.pdb.pdbapplicator.MsSymbolApplier;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataUtilities;
import ghidra.program.model.listing.Program;
import ghidra.program.model.util.CodeUnitInsertionException;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.CancelledException;

public class PublicSymbolApplier
extends MsSymbolApplier
implements DirectSymbolApplier {
    private AbstractPublicMsSymbol symbol;

    public PublicSymbolApplier(DefaultPdbApplicator applicator, AbstractPublicMsSymbol symbol) {
        super(applicator);
        this.symbol = symbol;
    }

    @Override
    public void apply(MsSymbolIterator iter) throws PdbException, CancelledException {
        this.getValidatedSymbol(iter, true);
        Address symbolAddress = this.applicator.getAddress(this.symbol);
        String name = this.symbol.getName();
        if (this.applicator.isInvalidAddress(symbolAddress, name)) {
            return;
        }
        Address existingSymbolAddress = this.applicator.witnessSymbolNameAtAddress(name, symbolAddress);
        if (!symbolAddress.equals((Object)existingSymbolAddress)) {
            this.applicator.createSymbol(symbolAddress, name, false);
            Program program = this.applicator.getProgram();
            if (GuidUtil.isGuidLabel((Program)program, (Address)symbolAddress, (String)name)) {
                try {
                    DataUtilities.createData((Program)program, (Address)symbolAddress, (DataType)new GuidDataType(), (int)-1, (DataUtilities.ClearDataMode)DataUtilities.ClearDataMode.CLEAR_ALL_UNDEFINED_CONFLICT_DATA);
                }
                catch (CodeUnitInsertionException codeUnitInsertionException) {
                    // empty catch block
                }
            }
        }
    }

    private AbstractPublicMsSymbol getValidatedSymbol(MsSymbolIterator iter, boolean iterate) {
        AbstractMsSymbol abstractSymbol;
        AbstractMsSymbol abstractMsSymbol = abstractSymbol = iterate ? iter.next() : iter.peek();
        if (!(abstractSymbol instanceof AbstractPublicMsSymbol)) {
            throw new AssertException("Invalid symbol type: " + abstractSymbol.getClass().getSimpleName());
        }
        AbstractPublicMsSymbol pubSymbol = (AbstractPublicMsSymbol)abstractSymbol;
        return pubSymbol;
    }
}

