/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.pdb.pdbapplicator;

import ghidra.app.util.bin.format.pdb2.pdbreader.MsSymbolIterator;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.AbstractMsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.AbstractWithMsSymbol;
import ghidra.app.util.pdb.pdbapplicator.AbstractBlockContextApplier;
import ghidra.app.util.pdb.pdbapplicator.BlockNestingSymbolApplier;
import ghidra.app.util.pdb.pdbapplicator.DefaultPdbApplicator;
import ghidra.app.util.pdb.pdbapplicator.MsSymbolApplier;
import ghidra.app.util.pdb.pdbapplicator.NestableSymbolApplier;
import ghidra.app.util.pdb.pdbapplicator.NestingSymbolApplier;
import ghidra.program.model.address.Address;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.CancelledException;

public class WithSymbolApplier
extends MsSymbolApplier
implements BlockNestingSymbolApplier,
NestableSymbolApplier {
    private AbstractWithMsSymbol symbol;

    public WithSymbolApplier(DefaultPdbApplicator applicator, AbstractWithMsSymbol symbol) {
        super(applicator);
        this.symbol = symbol;
    }

    @Override
    public void applyTo(NestingSymbolApplier applyToApplier, MsSymbolIterator iter) throws PdbException, CancelledException {
        this.getValidatedSymbol(iter, true);
        if (applyToApplier instanceof AbstractBlockContextApplier) {
            AbstractBlockContextApplier applier = (AbstractBlockContextApplier)applyToApplier;
            Address address = this.applicator.getAddress(this.symbol);
            applier.beginBlock(address, this.symbol.getExpression(), this.symbol.getLength());
        }
    }

    private AbstractWithMsSymbol getValidatedSymbol(MsSymbolIterator iter, boolean iterate) {
        AbstractMsSymbol abstractSymbol;
        AbstractMsSymbol abstractMsSymbol = abstractSymbol = iterate ? iter.next() : iter.peek();
        if (!(abstractSymbol instanceof AbstractWithMsSymbol)) {
            throw new AssertException("Invalid symbol type: " + abstractSymbol.getClass().getSimpleName());
        }
        AbstractWithMsSymbol withSymbol = (AbstractWithMsSymbol)abstractSymbol;
        return withSymbol;
    }
}

