/*
 * Decompiled with CFR 0.152.
 */
package pdb;

import ghidra.app.plugin.core.analysis.AnalysisWorker;
import ghidra.app.plugin.core.analysis.AutoAnalysisManager;
import ghidra.app.plugin.core.analysis.MicrosoftDemanglerAnalyzer;
import ghidra.app.plugin.core.analysis.PdbUniversalAnalyzer;
import ghidra.app.plugin.core.datamgr.archive.DuplicateIdException;
import ghidra.app.plugin.core.disassembler.EntryPointAnalyzer;
import ghidra.app.services.Analyzer;
import ghidra.app.services.DataTypeManagerService;
import ghidra.app.util.bin.format.pdb.PdbException;
import ghidra.app.util.bin.format.pdb.PdbParser;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbReaderOptions;
import ghidra.app.util.importer.MessageLog;
import ghidra.app.util.pdb.pdbapplicator.PdbApplicatorControl;
import ghidra.app.util.pdb.pdbapplicator.PdbApplicatorOptions;
import ghidra.framework.options.Options;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.Memory;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.Task;
import ghidra.util.task.TaskMonitor;
import ghidra.util.task.WrappingTaskMonitor;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;

class LoadPdbTask
extends Task {
    private File pdbFile;
    private DataTypeManagerService service;
    private final Program program;
    private final boolean useMsDiaParser;
    private final PdbApplicatorControl control;
    private String resultMessages;
    private Exception resultException;

    LoadPdbTask(Program program, File pdbFile, boolean useMsDiaParser, PdbApplicatorControl control, DataTypeManagerService service) {
        super("Load PDB", true, false, true, true);
        this.program = program;
        this.pdbFile = pdbFile;
        this.useMsDiaParser = useMsDiaParser;
        this.control = control;
        this.service = service;
    }

    public void run(TaskMonitor monitor) {
        final WrappingTaskMonitor wrappedMonitor = new WrappingTaskMonitor(this, monitor){

            public void initialize(long max) {
            }
        };
        final MessageLog log = new MessageLog();
        AnalysisWorker worker = new AnalysisWorker(){

            public String getWorkerName() {
                return "Load PDB";
            }

            public boolean analysisWorkerCallback(Program currentProgram, Object workerContext, TaskMonitor currentMonitor) throws CancelledException {
                try {
                    if (LoadPdbTask.this.useMsDiaParser ? !LoadPdbTask.this.parseWithMsDiaParser(log, (TaskMonitor)wrappedMonitor) : !LoadPdbTask.this.parseWithNewParser(log, (TaskMonitor)wrappedMonitor)) {
                        return false;
                    }
                    LoadPdbTask.this.scheduleAdditionalAnalysis();
                }
                catch (IOException e) {
                    log.appendMsg("PDB IO Error: " + e.getMessage());
                }
                return false;
            }
        };
        try {
            AutoAnalysisManager.getAnalysisManager((Program)this.program).scheduleWorker(worker, null, true, (TaskMonitor)wrappedMonitor);
        }
        catch (CancelledException | InterruptedException throwable) {
        }
        catch (InvocationTargetException e) {
            this.resultException = e;
        }
        if (log.hasMessages()) {
            this.resultMessages = log.toString();
        }
    }

    String getResultMessages() {
        return this.resultMessages;
    }

    Exception getResultException() {
        return this.resultException;
    }

    private boolean parseWithMsDiaParser(MessageLog log, TaskMonitor monitor) throws IOException, CancelledException {
        PdbParser parser = new PdbParser(this.pdbFile, this.program, this.service, true, true, monitor);
        try {
            parser.parse();
            parser.openDataTypeArchives();
            parser.applyTo(log);
            return true;
        }
        catch (DuplicateIdException | PdbException e) {
            log.appendMsg("PDB Error: " + e.getMessage());
            return false;
        }
    }

    private boolean parseWithNewParser(MessageLog log, TaskMonitor monitor) throws CancelledException {
        PdbReaderOptions pdbReaderOptions = new PdbReaderOptions();
        PdbApplicatorOptions pdbApplicatorOptions = new PdbApplicatorOptions();
        pdbApplicatorOptions.setProcessingControl(this.control);
        return PdbUniversalAnalyzer.doAnalysis(this.program, this.pdbFile, pdbReaderOptions, pdbApplicatorOptions, log, monitor);
    }

    private void scheduleAdditionalAnalysis() {
        Memory addrs = this.program.getMemory();
        AutoAnalysisManager manager = AutoAnalysisManager.getAnalysisManager((Program)this.program);
        Options analysisProperties = this.program.getOptions("Analyzers");
        if (!this.useMsDiaParser && this.control == PdbApplicatorControl.ALL) {
            this.scheduleEntryPointAnalyzer(manager, analysisProperties, (AddressSetView)addrs);
        }
        if (this.useMsDiaParser || this.control != PdbApplicatorControl.DATA_TYPES_ONLY) {
            this.scheduleDemanglerAnalyzer(manager, analysisProperties, (AddressSetView)addrs);
        }
    }

    private void scheduleEntryPointAnalyzer(AutoAnalysisManager manager, Options analysisProperties, AddressSetView addrs) {
        if (!analysisProperties.getBoolean("Disassemble Entry Points", false)) {
            return;
        }
        EntryPointAnalyzer entryPointAnalyzer = new EntryPointAnalyzer();
        manager.scheduleOneTimeAnalysis((Analyzer)entryPointAnalyzer, addrs);
    }

    private void scheduleDemanglerAnalyzer(AutoAnalysisManager manager, Options analysisProperties, AddressSetView addrs) {
        if (!analysisProperties.getBoolean("Demangler Microsoft", false)) {
            return;
        }
        MicrosoftDemanglerAnalyzer demanglerAnalyzer = new MicrosoftDemanglerAnalyzer();
        manager.scheduleOneTimeAnalysis((Analyzer)demanglerAnalyzer, addrs);
    }
}

