/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.bsim.query.client.tables;

import ghidra.features.bsim.query.client.tables.StatementSupplier;
import ghidra.util.Msg;
import java.sql.SQLException;
import java.sql.Statement;

public class CachedStatement<S extends Statement> {
    private S statement;
    private Thread ownerThread;

    public S prepareIfNeeded(StatementSupplier<S> statementSupplier) throws SQLException {
        S s = this.getStatement();
        if (s != null) {
            return s;
        }
        s = statementSupplier.get();
        this.setStatement(s);
        return s;
    }

    public void setStatement(S s) {
        S oldStatement = this.statement;
        this.statement = s;
        this.ownerThread = Thread.currentThread();
        if (oldStatement != null) {
            Msg.error((Object)this, (Object)"Statement cached more than once - closing old statement");
            try {
                oldStatement.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    public S getStatement() {
        Thread t = Thread.currentThread();
        if (this.statement != null && !this.ownerThread.equals(t)) {
            Msg.error((Object)this, (Object)("BSim cached statement used in unsafe-thread manner:\n   Created in: " + this.ownerThread.getName() + "\n   Used in: " + t.getName()));
            throw new RuntimeException("BSim cached statement used in unsafe-thread manner");
        }
        return this.statement;
    }

    public void close() {
        if (this.statement != null) {
            try {
                this.statement.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.statement = null;
        }
    }
}

