/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.bsim.query.elastic;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import ghidra.features.bsim.query.elastic.ElasticException;
import ghidra.util.Msg;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;

public class ElasticConnection {
    public static final String POST = "POST";
    public static final String PUT = "PUT";
    public static final String GET = "GET";
    public static final String DELETE = "DELETE";
    protected String hostURL;
    protected String httpURLbase;
    private int lastResponseCode;

    public ElasticConnection(String url, String repo) {
        this.hostURL = url;
        this.httpURLbase = url + "/" + repo + "_";
    }

    public boolean lastRequestSuccessful() {
        return this.lastResponseCode >= 200 && this.lastResponseCode < 300;
    }

    static String convertToString(JsonElement element) {
        if (ElasticConnection.isNull(element)) {
            return null;
        }
        return element.getAsString();
    }

    static String convertToString(JsonElement element, String defaultStr) {
        String str = ElasticConnection.convertToString(element);
        return str != null ? str : defaultStr;
    }

    static boolean isNull(JsonElement element) {
        return element == null || element instanceof JsonNull;
    }

    private JsonObject grabResponse(HttpURLConnection connection) throws IOException, JsonParseException {
        InputStream in = this.lastRequestSuccessful() ? connection.getInputStream() : connection.getErrorStream();
        if (in == null) {
            throw new IOException(connection.getResponseMessage());
        }
        InputStreamReader reader = new InputStreamReader(in);
        JsonObject jsonObject = JsonParser.parseReader((Reader)reader).getAsJsonObject();
        return jsonObject;
    }

    private static String parseErrorJSON(JsonObject resp) {
        String errorDetail;
        JsonElement errorObj = resp.get("error");
        if (errorObj instanceof String) {
            return (String)errorObj;
        }
        if (!(errorObj instanceof JsonObject)) {
            return "Unknown error format";
        }
        JsonObject err = (JsonObject)errorObj;
        String typeString = ElasticConnection.convertToString(err.get("type"), "Unknown Error");
        if (typeString.endsWith("_exception") && (errorDetail = ElasticConnection.parseErrorCause(err)).length() != 0) {
            Msg.error(ElasticConnection.class, (Object)("Elasticsearch exception: " + errorDetail));
        }
        String reasonString = ElasticConnection.convertToString(err.get("reason"), "Unknown Reason");
        return typeString + " : " + reasonString;
    }

    private static StringBuilder conditionalNewLine(StringBuilder buf) {
        if (!buf.isEmpty()) {
            buf.append("\n");
        }
        return buf;
    }

    private static String parseErrorCause(JsonObject error) {
        JsonElement failedShards;
        JsonElement causedBy;
        JsonElement scriptStack;
        StringBuilder buf = new StringBuilder();
        JsonElement reason = error.get("reason");
        String typeString = ElasticConnection.convertToString(error.get("type"));
        if (typeString != null) {
            String reasonString = ElasticConnection.convertToString(reason);
            String errorStr = typeString + " : " + reasonString;
            ElasticConnection.conditionalNewLine(buf).append(errorStr);
        }
        if ((scriptStack = error.get("script_stack")) instanceof JsonArray) {
            JsonArray scriptStackArray = (JsonArray)scriptStack;
            scriptStackArray.forEach(e -> ElasticConnection.conditionalNewLine(buf).append("   ").append(ElasticConnection.convertToString(e)));
        }
        if ((causedBy = error.get("caused_by")) instanceof JsonObject) {
            JsonObject causedByObject = (JsonObject)causedBy;
            ElasticConnection.conditionalNewLine(buf).append("   ").append(ElasticConnection.parseErrorCause(causedByObject));
        }
        if ((failedShards = error.get("failed_shards")) instanceof JsonArray) {
            JsonArray failedShardsArray = (JsonArray)failedShards;
            for (JsonElement failedShardElement : failedShardsArray) {
                JsonObject failedShard = (JsonObject)failedShardElement;
                String indexStr = ElasticConnection.convertToString(failedShard.get("index"));
                ElasticConnection.conditionalNewLine(buf).append("   Failed shard index: ").append(indexStr);
                ElasticConnection.conditionalNewLine(buf).append("   ").append(ElasticConnection.parseErrorCause(failedShard));
            }
        }
        if (reason instanceof JsonObject) {
            JsonObject reasonObject = (JsonObject)reason;
            ElasticConnection.conditionalNewLine(buf).append(ElasticConnection.parseErrorCause(reasonObject));
        }
        return buf.toString();
    }

    public JsonObject executeRawStatement(String command, String path, String body) throws ElasticException {
        HttpURLConnection connection = null;
        try {
            URL httpURL = new URL(this.hostURL + path);
            connection = (HttpURLConnection)httpURL.openConnection();
            connection.setRequestMethod(command);
            connection.setRequestProperty("Content-Type", "application/json");
            connection.setDoOutput(true);
            try (OutputStreamWriter writer = new OutputStreamWriter(connection.getOutputStream());){
                writer.write(body);
            }
            this.lastResponseCode = connection.getResponseCode();
            JsonObject resp = this.grabResponse(connection);
            if (!this.lastRequestSuccessful()) {
                throw new ElasticException(ElasticConnection.parseErrorJSON(resp));
            }
            JsonObject jsonObject = resp;
            return jsonObject;
        }
        catch (IOException e) {
            throw new ElasticException("Error sending request: " + e.getMessage());
        }
        catch (JsonParseException e) {
            throw new ElasticException("Error parsing response: " + e.getMessage());
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    public void executeStatementNoResponse(String command, String path, String body) throws ElasticException {
        HttpURLConnection connection = null;
        try {
            URL httpURL = new URL(this.httpURLbase + path);
            connection = (HttpURLConnection)httpURL.openConnection();
            connection.setRequestMethod(command);
            connection.setRequestProperty("Content-Type", "application/json");
            connection.setDoOutput(true);
            try (OutputStreamWriter writer = new OutputStreamWriter(connection.getOutputStream());){
                writer.write(body);
            }
            this.lastResponseCode = connection.getResponseCode();
            JsonObject resp = this.grabResponse(connection);
            if (!this.lastRequestSuccessful()) {
                throw new ElasticException(ElasticConnection.parseErrorJSON(resp));
            }
        }
        catch (IOException e) {
            throw new ElasticException("Error sending request: " + e.getMessage());
        }
        catch (JsonParseException e) {
            throw new ElasticException("Error parsing response: " + e.getMessage());
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    public JsonObject executeStatement(String command, String path, String body) throws ElasticException {
        HttpURLConnection connection = null;
        try {
            URL httpURL = new URL(this.httpURLbase + path);
            connection = (HttpURLConnection)httpURL.openConnection();
            connection.setRequestMethod(command);
            connection.setRequestProperty("Content-Type", "application/json");
            connection.setDoOutput(true);
            try (OutputStreamWriter writer = new OutputStreamWriter(connection.getOutputStream());){
                writer.write(body);
            }
            this.lastResponseCode = connection.getResponseCode();
            JsonObject resp = this.grabResponse(connection);
            if (!this.lastRequestSuccessful()) {
                throw new ElasticException(ElasticConnection.parseErrorJSON(resp));
            }
            JsonObject jsonObject = resp;
            return jsonObject;
        }
        catch (IOException e) {
            throw new ElasticException("Error sending request: " + e.getMessage());
        }
        catch (JsonParseException e) {
            throw new ElasticException("Error parsing response: " + e.getMessage());
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    public JsonObject executeStatementExpectFailure(String command, String path, String body) throws ElasticException {
        HttpURLConnection connection = null;
        try {
            JsonObject resp;
            URL httpURL = new URL(this.httpURLbase + path);
            connection = (HttpURLConnection)httpURL.openConnection();
            connection.setRequestMethod(command);
            connection.setRequestProperty("Content-Type", "application/json");
            connection.setDoOutput(true);
            try (OutputStreamWriter writer = new OutputStreamWriter(connection.getOutputStream());){
                writer.write(body);
            }
            this.lastResponseCode = connection.getResponseCode();
            JsonObject jsonObject = resp = this.grabResponse(connection);
            return jsonObject;
        }
        catch (IOException e) {
            throw new ElasticException("Error sending request: " + e.getMessage());
        }
        catch (JsonParseException e) {
            throw new ElasticException("Error parsing response: " + e.getMessage());
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    public JsonObject executeBulk(String path, String body) throws ElasticException {
        HttpURLConnection connection = null;
        try {
            URL httpURL = new URL(this.hostURL + path);
            connection = (HttpURLConnection)httpURL.openConnection();
            connection.setRequestMethod(POST);
            connection.setRequestProperty("Content-Type", "application/x-ndjson");
            connection.setDoOutput(true);
            try (OutputStreamWriter writer = new OutputStreamWriter(connection.getOutputStream());){
                writer.write(body);
            }
            this.lastResponseCode = connection.getResponseCode();
            JsonObject resp = this.grabResponse(connection);
            if (!this.lastRequestSuccessful()) {
                throw new ElasticException(ElasticConnection.parseErrorJSON(resp));
            }
            JsonObject jsonObject = resp;
            return jsonObject;
        }
        catch (IOException e) {
            throw new ElasticException("Error sending request: " + e.getMessage());
        }
        catch (JsonParseException e) {
            throw new ElasticException("Error parsing response: " + e.getMessage());
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    public JsonObject executeURIOnly(String command, String path) throws ElasticException {
        HttpURLConnection connection = null;
        try {
            URL httpURL = new URL(this.httpURLbase + path);
            connection = (HttpURLConnection)httpURL.openConnection();
            connection.setRequestMethod(command);
            connection.setDoOutput(true);
            this.lastResponseCode = connection.getResponseCode();
            JsonObject resp = this.grabResponse(connection);
            if (!this.lastRequestSuccessful()) {
                throw new ElasticException(ElasticConnection.parseErrorJSON(resp));
            }
            JsonObject jsonObject = resp;
            return jsonObject;
        }
        catch (IOException e) {
            throw new ElasticException("Error sending request: " + e.getMessage());
        }
        catch (JsonParseException e) {
            throw new ElasticException("Error parsing response: " + e.getMessage());
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }
}

