/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.bsim.query.protocol;

import ghidra.features.bsim.query.LSHException;
import ghidra.features.bsim.query.description.DescriptionManager;
import ghidra.features.bsim.query.description.ExecutableRecord;
import ghidra.features.bsim.query.description.FunctionDescription;
import ghidra.util.xml.SpecXmlUtils;
import ghidra.xml.XmlElement;
import ghidra.xml.XmlPullParser;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;

public class ClusterNote {
    private FunctionDescription func;
    private int setsize;
    private double maxscore;
    private double signif;

    public ClusterNote() {
    }

    public ClusterNote(FunctionDescription f, int ss, double ms, double sig) {
        this.func = f;
        this.setsize = ss;
        this.maxscore = ms;
        this.signif = sig;
    }

    public FunctionDescription getFunctionDescription() {
        return this.func;
    }

    public double getMaxSimilarity() {
        return this.maxscore;
    }

    public double getSignificance() {
        return this.signif;
    }

    public void saveXml(Writer write) throws IOException {
        StringBuilder buf = new StringBuilder();
        buf.append("<note");
        SpecXmlUtils.encodeUnsignedIntegerAttribute((StringBuilder)buf, (String)"id", (long)this.func.getExecutableRecord().getXrefIndex());
        SpecXmlUtils.xmlEscapeAttribute((StringBuilder)buf, (String)"name", (String)this.func.getFunctionName());
        SpecXmlUtils.encodeUnsignedIntegerAttribute((StringBuilder)buf, (String)"addr", (long)this.func.getAddress());
        buf.append(">\n");
        buf.append(" <setsize>").append(SpecXmlUtils.encodeSignedInteger((long)this.setsize)).append("</setsize>\n");
        buf.append(" <sim>").append(Double.toString(this.maxscore)).append("</sim>\n");
        buf.append(" <sig>").append(Double.toString(this.signif)).append("</sig>\n");
        buf.append("</note>\n");
        write.append(buf.toString());
    }

    public void restoreXml(XmlPullParser parser, DescriptionManager manage, Map<Integer, ExecutableRecord> xrefMap) throws LSHException {
        XmlElement el = parser.start(new String[]{"note"});
        int id = SpecXmlUtils.decodeInt((String)el.getAttribute("id"));
        ExecutableRecord exe = xrefMap.get(id);
        long address = SpecXmlUtils.decodeLong((String)el.getAttribute("addr"));
        this.func = manage.findFunction(el.getAttribute("name"), address, exe);
        parser.start(new String[]{"setsize"});
        this.setsize = SpecXmlUtils.decodeInt((String)parser.end().getText());
        parser.start(new String[]{"sim"});
        this.maxscore = Double.parseDouble(parser.end().getText());
        parser.start(new String[]{"sig"});
        this.signif = Double.parseDouble(parser.end().getText());
        parser.end();
    }
}

