/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.emu.jit.gen.op;

import ghidra.lifecycle.Unfinished;
import ghidra.pcode.emu.jit.analysis.JitControlFlowModel;
import ghidra.pcode.emu.jit.analysis.JitType;
import ghidra.pcode.emu.jit.gen.JitCodeGenerator;
import ghidra.pcode.emu.jit.gen.op.BinOpGen;
import ghidra.pcode.emu.jit.gen.type.TypeConversions;
import ghidra.pcode.emu.jit.op.JitBinOp;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

public interface BitwiseBinOpGen<T extends JitBinOp>
extends BinOpGen<T> {
    public int intOpcode();

    public int longOpcode();

    default public void generateMpIntBinOp(JitCodeGenerator gen, JitType.MpIntJitType type, MethodVisitor mv) {
        int i;
        int legCount = type.legsAlloc();
        int firstIndex = gen.getAllocationModel().nextFreeLocal();
        Label start = new Label();
        Label end = new Label();
        mv.visitLabel(start);
        for (i = 0; i < legCount; ++i) {
            mv.visitLocalVariable("result" + i, Type.getDescriptor(Integer.TYPE), null, start, end, firstIndex + i);
            mv.visitVarInsn(54, firstIndex + i);
        }
        for (i = 0; i < legCount; ++i) {
            mv.visitVarInsn(21, firstIndex + i);
            mv.visitInsn(this.intOpcode());
            mv.visitVarInsn(54, firstIndex + i);
        }
        for (i = 0; i < legCount; ++i) {
            mv.visitVarInsn(21, firstIndex + legCount - i - 1);
        }
        mv.visitLabel(end);
    }

    @Override
    default public JitType afterLeft(JitCodeGenerator gen, T op, JitType lType, JitType rType, MethodVisitor rv) {
        return TypeConversions.forceUniformZExt(lType, rType, rv);
    }

    @Override
    default public JitType generateBinOpRunCode(JitCodeGenerator gen, T op, JitControlFlowModel.JitBlock block, JitType lType, JitType rType, MethodVisitor rv) {
        JitType jitType = rType = TypeConversions.forceUniformZExt(rType, lType, rv);
        Objects.requireNonNull(jitType);
        JitType jitType2 = jitType;
        int n = 0;
        block6: while (true) {
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{JitType.IntJitType.class, JitType.LongJitType.class, JitType.MpIntJitType.class, JitType.MpIntJitType.class}, (Object)jitType2, n)) {
                case 0: {
                    JitType.IntJitType t = (JitType.IntJitType)jitType2;
                    rv.visitInsn(this.intOpcode());
                    break block6;
                }
                case 1: {
                    JitType.LongJitType t = (JitType.LongJitType)jitType2;
                    rv.visitInsn(this.longOpcode());
                    break block6;
                }
                case 2: {
                    JitType.MpIntJitType t = (JitType.MpIntJitType)jitType2;
                    if (t.size() != lType.size()) {
                        n = 3;
                        continue block6;
                    }
                    this.generateMpIntBinOp(gen, t, rv);
                    break block6;
                }
                case 3: {
                    JitType.MpIntJitType t = (JitType.MpIntJitType)jitType2;
                    Unfinished.TODO((String)"MpInt of differing sizes", (Object[])new Object[0]);
                    break block6;
                }
                default: {
                    throw new AssertionError();
                }
            }
            break;
        }
        return lType;
    }
}

