/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.emu.jit.gen.op;

import ghidra.pcode.emu.jit.analysis.JitControlFlowModel;
import ghidra.pcode.emu.jit.analysis.JitType;
import ghidra.pcode.emu.jit.gen.JitCodeGenerator;
import ghidra.pcode.emu.jit.gen.op.OpGen;
import ghidra.pcode.emu.jit.op.JitSubPieceOp;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

public enum SubPieceOpGen implements OpGen<JitSubPieceOp>
{
    GEN;


    private void generateShiftWithPrevLeg(MethodVisitor rv, int bitShift, int index) {
        rv.visitLdcInsn((Object)(32 - bitShift));
        rv.visitInsn(122);
        rv.visitVarInsn(21, index);
        rv.visitInsn(90);
        rv.visitLdcInsn((Object)bitShift);
        rv.visitInsn(124);
        rv.visitInsn(128);
        rv.visitVarInsn(54, index);
    }

    @Override
    public void generateRunCode(JitCodeGenerator gen, JitSubPieceOp op, JitControlFlowModel.JitBlock block, MethodVisitor rv) {
        JitType vType;
        JitType jitType = vType = gen.generateValReadCode(op.u(), op.uType());
        Objects.requireNonNull(jitType);
        JitType jitType2 = jitType;
        int n = 0;
        gen.generateVarWriteCode(op.out(), (JitType)((Object)(switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{JitType.IntJitType.class, JitType.LongJitType.class, JitType.MpIntJitType.class}, (Object)jitType2, n)) {
            case 0 -> {
                JitType.IntJitType vIType = (JitType.IntJitType)jitType2;
                rv.visitLdcInsn((Object)(op.offset() * 8));
                rv.visitInsn(124);
                yield vIType;
            }
            case 1 -> {
                JitType.LongJitType vLType = (JitType.LongJitType)jitType2;
                rv.visitLdcInsn((Object)(op.offset() * 8));
                rv.visitInsn(125);
                yield vLType;
            }
            case 2 -> {
                int i;
                JitType.MpIntJitType vMpType = (JitType.MpIntJitType)jitType2;
                JitType.MpIntJitType outMpType = JitType.MpIntJitType.forSize(op.out().size());
                int outLegCount = outMpType.legsAlloc();
                int legsLeft = vMpType.legsAlloc();
                int popCount = op.offset() / 4;
                int byteShift = op.offset() % 4;
                for (int i = 0; i < popCount; ++i) {
                    rv.visitInsn(87);
                }
                int firstIndex = gen.getAllocationModel().nextFreeLocal();
                Label start = new Label();
                Label end = new Label();
                rv.visitLabel(start);
                for (i = 0; i < outLegCount; ++i) {
                    rv.visitLocalVariable("subpiece" + i, Type.getDescriptor(Integer.TYPE), null, start, end, firstIndex + i);
                    rv.visitVarInsn(54, firstIndex + i);
                    --legsLeft;
                }
                if (byteShift > 0) {
                    int curLeg = outLegCount - 1;
                    if (legsLeft > 0) {
                        this.generateShiftWithPrevLeg(rv, byteShift * 8, firstIndex + curLeg);
                        --legsLeft;
                        --curLeg;
                    } else {
                        rv.visitVarInsn(21, firstIndex + curLeg);
                        rv.visitInsn(89);
                        rv.visitLdcInsn((Object)(byteShift * 8));
                        rv.visitInsn(124);
                        rv.visitVarInsn(54, firstIndex + curLeg);
                        --curLeg;
                    }
                    while (curLeg >= 0) {
                        this.generateShiftWithPrevLeg(rv, byteShift * 8, firstIndex + curLeg);
                        --legsLeft;
                        --curLeg;
                    }
                }
                while (legsLeft > 0) {
                    rv.visitInsn(87);
                    --legsLeft;
                }
                for (i = outLegCount - 1; i >= 0; --i) {
                    rv.visitVarInsn(21, firstIndex + i);
                }
                rv.visitLabel(end);
                yield outMpType;
            }
            default -> throw new AssertionError();
        })));
    }
}

