/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.exec;

import ghidra.pcode.exec.PcodeArithmetic;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.lang.Endian;
import ghidra.program.model.pcode.PcodeOp;
import java.util.Objects;
import org.apache.commons.lang3.tuple.Pair;

public class PairedPcodeArithmetic<L, R>
implements PcodeArithmetic<Pair<L, R>> {
    private final PcodeArithmetic<L> leftArith;
    private final PcodeArithmetic<R> rightArith;
    private final Endian endian;

    public PairedPcodeArithmetic(PcodeArithmetic<L> leftArith, PcodeArithmetic<R> rightArith) {
        Endian lend = leftArith.getEndian();
        Endian rend = rightArith.getEndian();
        if (lend != null && rend != null && lend != rend) {
            throw new IllegalArgumentException("Arithmetics must agree in endianness");
        }
        this.endian = lend != null ? lend : rend;
        this.leftArith = leftArith;
        this.rightArith = rightArith;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PairedPcodeArithmetic that = (PairedPcodeArithmetic)obj;
        if (!Objects.equals(this.leftArith, that.leftArith)) {
            return false;
        }
        return Objects.equals(this.rightArith, that.rightArith);
    }

    @Override
    public Endian getEndian() {
        return this.endian;
    }

    @Override
    public Pair<L, R> unaryOp(int opcode, int sizeout, int sizein1, Pair<L, R> in1) {
        return Pair.of((Object)this.leftArith.unaryOp(opcode, sizeout, sizein1, in1.getLeft()), (Object)this.rightArith.unaryOp(opcode, sizeout, sizein1, in1.getRight()));
    }

    @Override
    public Pair<L, R> unaryOp(PcodeOp op, Pair<L, R> in1) {
        return Pair.of((Object)this.leftArith.unaryOp(op, in1.getLeft()), (Object)this.rightArith.unaryOp(op, in1.getRight()));
    }

    @Override
    public Pair<L, R> binaryOp(int opcode, int sizeout, int sizein1, Pair<L, R> in1, int sizein2, Pair<L, R> in2) {
        return Pair.of((Object)this.leftArith.binaryOp(opcode, sizeout, sizein1, in1.getLeft(), sizein2, in2.getLeft()), (Object)this.rightArith.binaryOp(opcode, sizeout, sizein1, in1.getRight(), sizein2, in2.getRight()));
    }

    @Override
    public Pair<L, R> binaryOp(PcodeOp op, Pair<L, R> in1, Pair<L, R> in2) {
        return Pair.of((Object)this.leftArith.binaryOp(op, in1.getLeft(), in2.getLeft()), (Object)this.rightArith.binaryOp(op, in1.getRight(), in2.getRight()));
    }

    @Override
    public Pair<L, R> modBeforeStore(PcodeOp op, AddressSpace space, Pair<L, R> inOffset, Pair<L, R> inValue) {
        return Pair.of((Object)this.leftArith.modBeforeStore(op, space, inOffset.getLeft(), inValue.getLeft()), (Object)this.rightArith.modBeforeStore(op, space, inOffset.getRight(), inValue.getRight()));
    }

    @Override
    public Pair<L, R> modBeforeStore(int sizeinOffset, AddressSpace space, Pair<L, R> inOffset, int sizeinValue, Pair<L, R> inValue) {
        return Pair.of((Object)this.leftArith.modBeforeStore(sizeinOffset, space, inOffset.getLeft(), sizeinValue, inValue.getLeft()), (Object)this.rightArith.modBeforeStore(sizeinOffset, space, inOffset.getRight(), sizeinValue, inValue.getRight()));
    }

    @Override
    public Pair<L, R> modAfterLoad(PcodeOp op, AddressSpace space, Pair<L, R> inOffset, Pair<L, R> inValue) {
        return Pair.of((Object)this.leftArith.modAfterLoad(op, space, inOffset.getLeft(), inValue.getLeft()), (Object)this.rightArith.modAfterLoad(op, space, inOffset.getRight(), inValue.getRight()));
    }

    @Override
    public Pair<L, R> modAfterLoad(int sizeinOffset, AddressSpace space, Pair<L, R> inOffset, int sizeinValue, Pair<L, R> inValue) {
        return Pair.of((Object)this.leftArith.modAfterLoad(sizeinOffset, space, inOffset.getLeft(), sizeinValue, inValue.getLeft()), (Object)this.rightArith.modAfterLoad(sizeinOffset, space, inOffset.getRight(), sizeinValue, inValue.getRight()));
    }

    @Override
    public Pair<L, R> fromConst(byte[] value) {
        return Pair.of(this.leftArith.fromConst(value), this.rightArith.fromConst(value));
    }

    @Override
    public byte[] toConcrete(Pair<L, R> value, PcodeArithmetic.Purpose purpose) {
        return this.leftArith.toConcrete(value.getLeft(), purpose);
    }

    @Override
    public long sizeOf(Pair<L, R> value) {
        return this.leftArith.sizeOf(value.getLeft());
    }

    public PcodeArithmetic<L> getLeft() {
        return this.leftArith;
    }

    public PcodeArithmetic<R> getRight() {
        return this.rightArith;
    }
}

