/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.client.tracermi;

import ghidra.rmi.trace.TraceRmi;
import ghidra.trace.model.target.schema.TraceObjectSchema;

public class RmiRemoteMethodParameter {
    private final String name;
    private final TraceObjectSchema schema;
    private final boolean required;
    private final Object defaultValue;
    private final String display;
    private final String description;

    public RmiRemoteMethodParameter(String name, TraceObjectSchema schema, boolean required, Object defaultValue, String display, String description) {
        this.name = name;
        this.schema = schema;
        this.required = required;
        this.defaultValue = defaultValue;
        this.display = display;
        this.description = description;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getDisplay() {
        return this.display;
    }

    public TraceRmi.ValueType getType() {
        String schemaName = this.schema.getName().toString();
        return TraceRmi.ValueType.newBuilder().setName(schemaName).build();
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public boolean isRequired() {
        return this.required;
    }
}

