/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.go.ipc;

import ghidra.app.plugin.core.go.exception.StopWaitingException;
import ghidra.app.plugin.core.go.ipc.CheckPeriodicallyRunnable;
import ghidra.util.Msg;
import ghidra.util.Swing;
import java.nio.file.Path;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class CheckForFileProcessedRunnable
extends CheckPeriodicallyRunnable {
    public static int WAIT_FOR_PROCESSING_DELAY_MS = 500;
    public static int WAIT_FOR_PROCESSING_PERIOD_MS = 60000;
    public static int MAX_WAIT_FOR_PROCESSING_MIN = 1;
    private Path filePath;
    private StopWaitingException stopWaitingException;

    public CheckForFileProcessedRunnable(Path filePath, int period, TimeUnit timeUnit) {
        super(false, period, timeUnit, () -> filePath.toFile().exists());
        this.filePath = filePath;
    }

    private CheckForFileProcessedRunnable(ScheduledExecutorService executor, Path filePath, int period, TimeUnit timeUnit) {
        super(executor, true, period, timeUnit, () -> filePath.toFile().exists());
        this.filePath = filePath;
    }

    @Override
    public void run() {
        try {
            if (((Boolean)this.checkCondition.call()).booleanValue()) {
                try {
                    if (this.showDialog) {
                        dialog.showDialog();
                    }
                    this.executor.schedule(this, (long)this.period, this.timeUnit);
                }
                catch (StopWaitingException e) {
                    this.stopWaitingException = e;
                    this.dispose();
                }
                catch (RejectedExecutionException e) {
                    this.dispose();
                }
            } else {
                this.dispose();
            }
        }
        catch (Exception e) {
            Swing.runNow(() -> Msg.showError((Object)this, null, (String)"GhidraGo Unable to Check File", (Object)("GhidraGo could not check existence of file at " + String.valueOf(this.filePath)), (Throwable)e));
            this.dispose();
        }
    }

    @Override
    public void startChecking(int delay, TimeUnit delayTimeUnit) throws StopWaitingException {
        block2: {
            dialog.reset();
            try {
                super.startChecking(delay, delayTimeUnit);
                this.executor.schedule(new CheckForFileProcessedRunnable(this.executor, this.filePath, WAIT_FOR_PROCESSING_PERIOD_MS, TimeUnit.MILLISECONDS), (long)WAIT_FOR_PROCESSING_DELAY_MS, TimeUnit.MILLISECONDS);
            }
            catch (RejectedExecutionException e) {
                if (!dialog.isAnsweredNo()) break block2;
                throw new StopWaitingException();
            }
        }
    }

    @Override
    public void awaitTermination() throws StopWaitingException {
        try {
            this.executor.awaitTermination(MAX_WAIT_FOR_PROCESSING_MIN, TimeUnit.MINUTES);
            if (dialog.isAnsweredNo()) {
                throw new StopWaitingException();
            }
            if (this.stopWaitingException != null) {
                throw this.stopWaitingException;
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

