/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.ipfilter;

import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.ipfilter.IpFilterRule;
import io.netty.handler.ipfilter.IpFilteringHandlerImpl;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class IpFilterRuleHandler
extends IpFilteringHandlerImpl {
    private final CopyOnWriteArrayList<IpFilterRule> ipFilterRuleList = new CopyOnWriteArrayList();

    public IpFilterRuleHandler(List<IpFilterRule> newList) {
        if (newList != null) {
            this.ipFilterRuleList.addAll(newList);
        }
    }

    public IpFilterRuleHandler() {
    }

    public void add(IpFilterRule ipFilterRule) {
        if (ipFilterRule == null) {
            throw new NullPointerException("IpFilterRule can not be null");
        }
        this.ipFilterRuleList.add(ipFilterRule);
    }

    public void add(int index, IpFilterRule ipFilterRule) {
        if (ipFilterRule == null) {
            throw new NullPointerException("IpFilterRule can not be null");
        }
        this.ipFilterRuleList.add(index, ipFilterRule);
    }

    public void addAll(Collection<IpFilterRule> c) {
        if (c == null) {
            throw new NullPointerException("Collection can not be null");
        }
        this.ipFilterRuleList.addAll(c);
    }

    public void addAll(int index, Collection<IpFilterRule> c) {
        if (c == null) {
            throw new NullPointerException("Collection can not be null");
        }
        this.ipFilterRuleList.addAll(index, c);
    }

    public int addAllAbsent(Collection<IpFilterRule> c) {
        if (c == null) {
            throw new NullPointerException("Collection can not be null");
        }
        return this.ipFilterRuleList.addAllAbsent(c);
    }

    public boolean addIfAbsent(IpFilterRule ipFilterRule) {
        if (ipFilterRule == null) {
            throw new NullPointerException("IpFilterRule can not be null");
        }
        return this.ipFilterRuleList.addIfAbsent(ipFilterRule);
    }

    public void clear() {
        this.ipFilterRuleList.clear();
    }

    public boolean contains(IpFilterRule ipFilterRule) {
        if (ipFilterRule == null) {
            throw new NullPointerException("IpFilterRule can not be null");
        }
        return this.ipFilterRuleList.contains(ipFilterRule);
    }

    public boolean containsAll(Collection<IpFilterRule> c) {
        if (c == null) {
            throw new NullPointerException("Collection can not be null");
        }
        return this.ipFilterRuleList.containsAll(c);
    }

    public IpFilterRule get(int index) {
        return this.ipFilterRuleList.get(index);
    }

    public boolean isEmpty() {
        return this.ipFilterRuleList.isEmpty();
    }

    public void remove(IpFilterRule ipFilterRule) {
        if (ipFilterRule == null) {
            throw new NullPointerException("IpFilterRule can not be null");
        }
        this.ipFilterRuleList.remove(ipFilterRule);
    }

    public IpFilterRule remove(int index) {
        return this.ipFilterRuleList.remove(index);
    }

    public void removeAll(Collection<IpFilterRule> c) {
        if (c == null) {
            throw new NullPointerException("Collection can not be null");
        }
        this.ipFilterRuleList.removeAll(c);
    }

    public void retainAll(Collection<IpFilterRule> c) {
        if (c == null) {
            throw new NullPointerException("Collection can not be null");
        }
        this.ipFilterRuleList.retainAll(c);
    }

    public IpFilterRule set(int index, IpFilterRule ipFilterRule) {
        if (ipFilterRule == null) {
            throw new NullPointerException("IpFilterRule can not be null");
        }
        return this.ipFilterRuleList.set(index, ipFilterRule);
    }

    public int size() {
        return this.ipFilterRuleList.size();
    }

    @Override
    protected boolean accept(ChannelHandlerContext ctx, InetSocketAddress inetSocketAddress) throws Exception {
        if (this.ipFilterRuleList.isEmpty()) {
            return true;
        }
        InetAddress inetAddress = inetSocketAddress.getAddress();
        Iterator<IpFilterRule> iterator = this.ipFilterRuleList.iterator();
        IpFilterRule ipFilterRule = null;
        while (iterator.hasNext()) {
            ipFilterRule = iterator.next();
            if (!ipFilterRule.contains(inetAddress)) continue;
            return ipFilterRule.isAllowRule();
        }
        return true;
    }
}

